/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicStatusEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleTypeEnum;
import kd.fi.bcm.common.enums.rule.CheckMethodEnum;
import kd.fi.bcm.common.enums.rule.LinkSymbolEnum;
import kd.fi.bcm.common.enums.rule.OutputLogEnum;
import kd.fi.bcm.common.util.DownFileUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.computing.BizRuleConfigImportAndExport;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleExportHelper {
    private static Log log = LogFactory.getLog(BizRuleExportHelper.class);
    public static final String propertySplitOld = "//----------------------------\u89c4\u5219\u811a\u672c\u5c5e\u6027\u5b9a\u4e49----------------------------";
    public static final String propertySplit = "//----------------------------\u89c4\u5219\u5c5e\u6027\u5b9a\u4e49----------------------------";
    public static final String contentSplitOld = "//------------------------------\u89c4\u5219\u811a\u672c\u5185\u5bb9------------------------------";
    public static final String contentSplit = "//------------------------------\u89c4\u5219\u5185\u5bb9------------------------------";
    private static final String comTitle = "// Kingdee Cloud Cosmos Consolidation System Rule file";
    private static final String scopeInclude = "include";
    private static final String scopeExcept = "except";

    public static String exportBizRule(IClientViewProxy clientViewProxy, long modelId, String modelNum, long userId, List<Object> ids) {
        String errMsg = null;
        try (DataSet ruleDataSet = BizRuleExportHelper.getBizRules(modelId, ids);
             DataSet tempDataSet = ruleDataSet.copy();){
            Set<Long> ruleIdSet = BizRuleExportHelper.collectBizRuleId(tempDataSet);
            if (!ruleIdSet.isEmpty()) {
                HashMap<Long, String> idOrderMap = new HashMap<Long, String>(ruleIdSet.size());
                Map<Long, String> idProNumMap = BizRuleExportHelper.getRuleIdProcessNumberMap(modelId, ruleIdSet, idOrderMap);
                StringBuilder fileContent = BizRuleExportHelper.buildFileHeadContent(userId);
                Iterator iterator = ruleDataSet.iterator();
                int ruleCount = 0;
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    fileContent.append((CharSequence)BizRuleExportHelper.buildOneRuleContent(idProNumMap, idOrderMap, row, modelId));
                    ++ruleCount;
                }
                if (ruleCount > 0) {
                    BizRuleExportHelper.downloadRuleContent(clientViewProxy, modelNum, fileContent);
                } else {
                    errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleExportHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                }
            } else {
                errMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleExportHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5bfc\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"BizRuleExportHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage());
            log.error(e.getMessage());
        }
        return errMsg;
    }

    private static void downloadRuleContent(IClientViewProxy clientViewProxy, String modelNum, StringBuilder fileContent) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = "RuleScript_" + modelNum + "_" + simpleDateFormat.format(new Date());
        try {
            String url = ImportAndExportUtil.writeJsFile(fileContent.toString(), fileName, "kdrle");
            if (kd.bos.util.StringUtils.isNotEmpty((String)url)) {
                DownFileUtil.authorizedDownLoadFileUrl((String)url, (long)MemberReader.findModelIdByNum((String)modelNum), (String)"cm", (String)"bcm_bizrulelist", (String)"1G2FW/G3YIL8");
                clientViewProxy.addAction("download", (Object)url);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u8f93\u51fa\u5931\u8d25\uff1a%s", (String)"BizRuleExportHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static StringBuilder buildOneRuleContent(Map<Long, String> idProNumMap, Map<Long, String> idOrderMap, Row row, Long modelId) {
        StringBuilder content = new StringBuilder();
        content.append(propertySplit).append(System.lineSeparator());
        content.append("{RuleCode} ").append(row.getString("number")).append(System.lineSeparator());
        content.append("{RuleName} ").append(row.getString("name")).append(System.lineSeparator());
        content.append("{RuleType} ").append(BizRuleTypeEnum.getEnumByType((String)row.getString("type")).getShowNumber()).append(System.lineSeparator());
        content.append("{Process} ").append(idProNumMap.get(row.getLong("id"))).append(System.lineSeparator());
        content.append("{Order} ").append(idOrderMap.get(row.getLong("id"))).append(System.lineSeparator());
        content.append("{Description} ").append(row.getString("description")).append(System.lineSeparator());
        content.append("{AutoImported} ").append(row.getBoolean("defaultimport") != false ? "Y" : "N").append(System.lineSeparator());
        content.append("{Status} ").append(row.getBoolean("status") != false ? "Y" : "N").append(System.lineSeparator());
        content.append("{ExecuteType} ").append(BizRuleExecuteTypeEnum.getEnumByCode((String)row.getString("executetype")).getShowNumber()).append(System.lineSeparator());
        long id = row.getLong("id");
        QFilter filter = new QFilter("bizrule", "=", (Object)id);
        filter.and(new QFilter("model", "=", (Object)modelId));
        Collection brallocateCollection = BusinessDataServiceHelper.loadFromCache((String)"bcm_brallocateentity", (String)"template,papertemplate,execwhenopen,execwhensave", (QFilter[])new QFilter[]{filter}).values();
        StringBuilder templatesSb = new StringBuilder();
        StringBuilder templateActionSb = new StringBuilder();
        if (!brallocateCollection.isEmpty()) {
            Map<String, String> templateActionMap = BizRuleExecuteTypeEnum.getEnumByCode((String)row.getString("executetype")) == BizRuleExecuteTypeEnum.EQUITY_ONLY || BizRuleExecuteTypeEnum.getEnumByCode((String)row.getString("executetype")) == BizRuleExecuteTypeEnum.INTR_ONLY ? brallocateCollection.stream().collect(Collectors.toMap(temA -> temA.getString("papertemplate.number"), temA -> BizRuleExportHelper.buildTemplateAction(temA, true))) : brallocateCollection.stream().collect(Collectors.toMap(temA -> temA.getString("template.number"), temA -> BizRuleExportHelper.buildTemplateAction(temA, false), (e1, e2) -> e2));
            templateActionMap.forEach((tempNumber, actionStr) -> {
                templatesSb.append((String)tempNumber).append(';');
                templateActionSb.append((String)actionStr).append(";");
            });
        }
        content.append("{Templates} ").append((CharSequence)templatesSb).append(System.lineSeparator());
        content.append("{TemplateAction} ").append((CharSequence)templateActionSb).append(System.lineSeparator());
        content.append(contentSplit).append(System.lineSeparator());
        if (row.getString("type").equals(BizRuleTypeEnum.CONFIG.getType())) {
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)row.getLong("id"), (String)"bcm_bizruleentityconfig");
            DynamicObjectCollection entries = dyo.getDynamicObjectCollection("entryentity");
            content.append("[\n\t");
            int count = 0;
            for (int i = 0; i < entries.size(); ++i) {
                String logicCommitexpr;
                DynamicObject logicRule = (DynamicObject)entries.get(i);
                if (BizRuleLogicStatusEnum.NEW.getStatus().equals(logicRule.getString("isdelete"))) continue;
                StringBuilder sb = new StringBuilder();
                if (count != 0) {
                    sb.append(System.lineSeparator());
                }
                sb.append(kd.bos.util.StringUtils.isBlank((String)(logicCommitexpr = logicRule.getString("logic_commitexpr"))) ? BizRuleExportHelper.getRuleInfoBean(logicRule) : logicCommitexpr);
                if (i < entries.size() - 1) {
                    sb.append(",");
                }
                String newStr = sb.toString().replace(System.lineSeparator(), System.lineSeparator() + "\t");
                content.append(newStr);
                ++count;
            }
            content.append("\n]\n\n");
        } else {
            content.append(row.getString("content")).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return content;
    }

    private static String buildTemplateAction(DynamicObject temA, boolean isInv) {
        StringJoiner stringJoiner = new StringJoiner(",");
        if (temA.getBoolean("execwhenopen")) {
            stringJoiner.add("Open");
        }
        if (temA.getBoolean("execwhensave")) {
            stringJoiner.add("Save");
        }
        if (StringUtils.isEmpty((String)stringJoiner.toString())) {
            if (isInv) {
                stringJoiner.add("Manual");
            } else {
                stringJoiner.add("None");
            }
        }
        return stringJoiner.toString();
    }

    public static BizRuleConfigImportAndExport getRuleInfoBean(DynamicObject logicRule) {
        BizRuleConfigImportAndExport bizRuleConfigImportAndExport = new BizRuleConfigImportAndExport();
        bizRuleConfigImportAndExport.setLogicCode(logicRule.getString("logic_number"));
        bizRuleConfigImportAndExport.setLogicName(logicRule.getString("logic_name"));
        bizRuleConfigImportAndExport.setLogTag(OutputLogEnum.getEnumByType((String)logicRule.getString("logic_log")).getEngDesc());
        String conditionStrs = logicRule.getString("logic_condition");
        List<BizRuleConfigImportAndExport.ConfigCondition> conditions = BizRuleExportHelper.getConditionByLogicCon(conditionStrs);
        bizRuleConfigImportAndExport.setCondition(conditions);
        String scopeStrs = logicRule.getString("logic_scope");
        List<Object> includes = BizRuleExportHelper.getScopeByLogicScope(scopeStrs, scopeInclude);
        List<Object> excepts = BizRuleExportHelper.getScopeByLogicScope(scopeStrs, scopeExcept);
        bizRuleConfigImportAndExport.setInclude(includes.stream().map(ob -> (BizRuleConfigImportAndExport.ConfigInclude)ob).collect(Collectors.toList()));
        bizRuleConfigImportAndExport.setExcept(excepts.stream().map(ob -> (BizRuleConfigImportAndExport.ConfigExcept)ob).collect(Collectors.toList()));
        bizRuleConfigImportAndExport.setExps(logicRule.getString("logic_expression"));
        bizRuleConfigImportAndExport.setCopySource(logicRule.getString("copysource"));
        bizRuleConfigImportAndExport.setLogicType(BizRuleLogicTypeEnum.getTypeByCode((String)logicRule.getString("logic_type")));
        return bizRuleConfigImportAndExport;
    }

    private static List<Object> getScopeByLogicScope(String scopeStrs, String scopeType) {
        ArrayList<Object> scopeList = new ArrayList<Object>(10);
        if (kd.bos.util.StringUtils.isNotEmpty((String)scopeStrs)) {
            String[] scopeStr;
            for (String str : scopeStr = scopeStrs.split(";")) {
                String[] strs = str.split("\\|");
                if (scopeInclude.equals(scopeType)) {
                    BizRuleConfigImportAndExport.ConfigInclude configInclude = new BizRuleConfigImportAndExport.ConfigInclude();
                    configInclude.setDim(strs[0]);
                    String includeMember = BizRuleExportHelper.getScopeMember(strs[1]);
                    configInclude.setMember(includeMember);
                    scopeList.add(configInclude);
                    continue;
                }
                BizRuleConfigImportAndExport.ConfigExcept configExcept = new BizRuleConfigImportAndExport.ConfigExcept();
                configExcept.setDim(strs[0]);
                String exceptMember = BizRuleExportHelper.getScopeMember(strs[2]);
                configExcept.setMember(exceptMember);
                scopeList.add(configExcept);
            }
        }
        return scopeList;
    }

    private static String getScopeMember(String str) {
        if (str.contains(",")) {
            String[] members = str.split(",");
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (String member : members) {
                sb.append(BizRuleExportHelper.getShowMember(member));
                if (count < members.length - 1) {
                    sb.append(",");
                }
                ++count;
            }
            return sb.toString();
        }
        return BizRuleExportHelper.getShowMember(str);
    }

    private static String getShowMember(String str) {
        String[] strs = str.split("@");
        if (strs.length == 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(strs[0]).append(".").append(BizRuleUtil.getFunctionNameByScope((int)Integer.parseInt(strs[1])));
            return sb.toString();
        }
        if (strs.length == 1) {
            return str;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u51fa\u914d\u7f6e\u7c7b\u89c4\u5219\u8303\u56f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"BizRuleExportHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private static List<BizRuleConfigImportAndExport.ConfigCondition> getConditionByLogicCon(String conditionStrs) {
        ArrayList<BizRuleConfigImportAndExport.ConfigCondition> configConditionList = new ArrayList<BizRuleConfigImportAndExport.ConfigCondition>(10);
        if (kd.bos.util.StringUtils.isNotEmpty((String)conditionStrs)) {
            String[] conditionStr;
            for (String str : conditionStr = conditionStrs.split(";")) {
                String[] strs = str.split("\\|");
                BizRuleConfigImportAndExport.ConfigCondition condition = new BizRuleConfigImportAndExport.ConfigCondition();
                int firstCount = 0;
                if (strs[0].length() == 1) {
                    condition.setConn(LinkSymbolEnum.getEnumByValue((String)strs[0]).getEngDes());
                    firstCount = 1;
                } else {
                    condition.setConn("");
                    condition.setDim(SysDimensionEnum.getDimNumberByMemberTreefrom((String)strs[0]));
                }
                configConditionList.add(BizRuleExportHelper.dealCondition(firstCount, condition, strs));
            }
        }
        return configConditionList;
    }

    private static BizRuleConfigImportAndExport.ConfigCondition dealCondition(int firstCount, BizRuleConfigImportAndExport.ConfigCondition condition, String[] strs) {
        condition.setDim(SysDimensionEnum.getDimNumberByMemberTreefrom((String)strs[firstCount++]));
        condition.setType(strs[firstCount++]);
        int methodInt = firstCount++;
        CheckMethodEnum methodEnum = CheckMethodEnum.getEnumByValue((String)strs[methodInt]);
        condition.setMethod(methodEnum.getExpress());
        if ("3".equals(strs[methodInt]) || "4".equals(strs[methodInt])) {
            condition.setValues(strs[firstCount++]);
            if ("4".equals(strs[methodInt])) {
                condition.setValue(String.valueOf(false));
            } else {
                condition.setValue("");
            }
        } else {
            String value = strs[firstCount++];
            condition.setValue(value);
            if (methodEnum.getDefaultCondition() != null && methodEnum.getDefaultCondition() == Boolean.FALSE) {
                condition.setValues(String.valueOf(false));
            } else {
                condition.setValues("");
            }
        }
        condition.setPrior(strs[firstCount++]);
        return condition;
    }

    private static Map<Long, String> getRuleIdProcessNumberMap(long modelId, Set<Long> ruleIdSet, Map<Long, String> idOrderMap) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("bizrule", "in", (Object)ruleIdSet.toArray());
        DynamicObjectCollection proCol = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"member,bizrule,execsort", (QFilter[])qFilter.toArray(), (String)"bizrule");
        Map<Long, String> processMap = BizRuleExportHelper.getAllProcess(modelId);
        HashMap<Long, String> idProNumMap = new HashMap<Long, String>(8);
        for (DynamicObject pro : proCol) {
            long ruleId = pro.getLong("bizrule");
            String proNumber = processMap.get(pro.getLong("member"));
            String order = pro.getString("execsort");
            if (proNumber == null) {
                proNumber = "None";
            }
            if (idProNumMap.get(ruleId) == null) {
                idProNumMap.put(ruleId, proNumber);
                idOrderMap.put(ruleId, order);
                continue;
            }
            idProNumMap.put(ruleId, (String)idProNumMap.get(ruleId) + "," + proNumber);
            idOrderMap.put(ruleId, idOrderMap.get(ruleId) + "," + order);
        }
        return idProNumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Long> collectBizRuleId(DataSet tempSet) {
        HashSet<Long> idSet = new HashSet<Long>(8);
        try {
            for (Row next : tempSet) {
                idSet.add(next.getLong("id"));
            }
        }
        finally {
            tempSet.close();
        }
        return idSet;
    }

    private static Map<Long, String> getAllProcess(long modelId) {
        QFilter qFilterProcess = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection processDynamicList = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number", (QFilter[])qFilterProcess.toArray());
        HashMap<Long, String> processMap = new HashMap<Long, String>(processDynamicList.size());
        for (DynamicObject process : processDynamicList) {
            processMap.put(process.getLong("id"), process.getString("number"));
        }
        return processMap;
    }

    private static DataSet getAllBizRuleFromDB(long modelId) {
        String selectField = "bizrule.id as id,bizrule.number as number,bizrule.name as name,bizrule.executeseq as executeseq,bizrule.description as description,bizrule.iscommon as iscommon,bizrule.content as content,bizrule.catalog as catalog,bizrule.defaultimport as defaultimport,bizrule.status as status,bizrule.type as type,bizrule.executetype as executetype,execsort";
        QFBuilder ruleBuilder = new QFBuilder();
        ruleBuilder.add("bizrule.model", "=", (Object)modelId);
        ruleBuilder.and("bizrule.deletestatus", "=", (Object)false);
        return QueryServiceHelper.queryDataSet((String)"BizRuleExportHelper", (String)"bcm_bizrulealloprocess", (String)selectField, (QFilter[])ruleBuilder.toArray(), (String)"execsort");
    }

    private static DataSet getPartBizRuleFromDB(List<Object> ids) {
        String selectField = "bizrule.id as id,bizrule.number as number,bizrule.name as name,bizrule.executeseq as executeseq,bizrule.description as description,bizrule.iscommon as iscommon,bizrule.content as content,bizrule.catalog as catalog,bizrule.defaultimport as defaultimport,bizrule.status as status,bizrule.type as type,bizrule.executetype as executetype,execsort";
        QFBuilder ruleBuilder = new QFBuilder("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)"BizRuleExportHelper", (String)"bcm_bizrulealloprocess", (String)selectField, (QFilter[])ruleBuilder.toArray(), (String)"execsort");
    }

    private static DataSet getBizRules(long modelId, List<Object> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            DataSet ruleDataSet = BizRuleExportHelper.getAllBizRuleFromDB(modelId);
            DataSet commonRule = ruleDataSet.where("iscommon = true");
            DataSet otherRule = ruleDataSet.where("iscommon = false").groupBy(new String[]{"id", "number", "name", "executeseq", "description", "iscommon", "content", "catalog", "defaultimport", "status", "type", "executetype"}).min("execsort").finish().orderBy(new String[]{"number"});
            return commonRule.union(otherRule);
        }
        return BizRuleExportHelper.getPartBizRuleFromDB(ids);
    }

    private static StringBuilder buildFileHeadContent(long userId) {
        String userName = UserServiceHelper.getUsernameByUserid((Object)userId);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentTime = dateFormat.format(new Date());
        String exportTimeAndUser = "// Exported at " + currentTime + " , by " + userName;
        StringBuilder head = new StringBuilder();
        head.append(comTitle).append(System.lineSeparator());
        head.append(exportTimeAndUser).append(System.lineSeparator()).append(System.lineSeparator());
        return head;
    }
}

