/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.model.excelformula.GETRATEFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleGetRateFormulaPlugin
extends AbstractBaseFormPlugin {
    private static final List<String> DIMKEYS = Lists.newArrayList((Object[])new String[]{"scenario", "year", "period"});
    private String commonRateSchemeNumber;
    private static String ORGCURRENCY = "ctx.E.EC";
    private static String CURRENCYNOW = "ctx.C.number";
    private static final Map<Integer, String> field2Index = new HashMap<Integer, String>();

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(DIMKEYS, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        BasedataEdit sceneEdit = (BasedataEdit)this.getView().getControl("scenario");
        sceneEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yearEdit = (BasedataEdit)this.getView().getControl("year");
        yearEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getView().getControl("period");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit fieldEditor1 = (ComboEdit)this.getView().getControl("ratescheme");
        List<ComboItem> comboItemsRate = this.getRateComboItems();
        fieldEditor1.setComboItems(comboItemsRate);
        if (this.getFormCustomParam("formula") != null) {
            String formula = (String)this.getFormCustomParam("formula");
            Map<String, String> info = this.transFormulaExpr2Formula(formula);
            try {
                String source = info.get("source");
                String target = info.get("target");
                String ratetype = info.get("ratetype");
                String ratescheme = info.get("ratescheme");
                String sNumber = info.get("sNumber");
                String yearNumber = info.get("yearNumber");
                String periodNumber = info.get("periodNumber");
                DynamicObject scenario = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_scenemembertree", (Object)this.getModelId(), (String)sNumber);
                DynamicObject year = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_fymembertree", (Object)this.getModelId(), (String)yearNumber);
                DynamicObject period = DimensionServiceHelper.queryMemberIdByNumber((String)"bcm_periodmembertree", (Object)this.getModelId(), (String)periodNumber);
                if (scenario != null) {
                    this.getModel().setValue("scenario", (Object)scenario.getLong("id"));
                }
                if (year != null) {
                    this.getModel().setValue("year", (Object)year.getLong("id"));
                }
                if (period != null) {
                    this.getModel().setValue("period", (Object)period.getLong("id"));
                }
                this.getModel().setValue("source", (Object)source);
                this.getModel().setValue("target", (Object)target);
                this.getModel().setValue("ratetype", (Object)ratetype);
                this.getModel().setValue("ratescheme", (Object)ratescheme);
            }
            catch (Exception e1) {
                log.error("error", (Throwable)e1);
            }
        } else {
            this.getModel().setValue("source", (Object)ORGCURRENCY);
            this.getModel().setValue("target", (Object)CURRENCYNOW);
            this.getModel().setValue("ratetype", (Object)"ClosingRate");
            if (StringUtils.isNotEmpty((String)this.commonRateSchemeNumber)) {
                this.getModel().setValue("ratescheme", (Object)this.commonRateSchemeNumber);
            }
        }
    }

    private List<ComboItem> getRateComboItems() {
        ArrayList comboItems = Lists.newArrayList();
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        QFilter filter2 = new QFilter("isexchangerate", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])new QFilter[]{filter1, filter2});
        if (dynamicObjectCollection != null) {
            for (DynamicObject dyo : dynamicObjectCollection) {
                if (this.getDesc().equals(dyo.getString("name"))) {
                    this.commonRateSchemeNumber = dyo.getString("number");
                }
                ComboItem item = new ComboItem(new LocaleString(dyo.getString("name")), dyo.getString("number"));
                comboItems.add(item);
            }
        }
        return comboItems;
    }

    private String getDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u6c47\u7387\u65b9\u6848", (String)"BizRuleGetRateFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private Map<String, String> transFormulaExpr2Formula(String formula) {
        HashMap<String, String> resultMap = new HashMap<String, String>(7);
        List iFormulaList = ChkFormulaServiceHelper.getIFormulaList((String)formula, (String)"GETRATE");
        if (CollectionUtils.isEmpty((Collection)iFormulaList)) {
            return resultMap;
        }
        GETRATEFormula getrateFormula = (GETRATEFormula)iFormulaList.get(0);
        ParamList paramList = getrateFormula.getParamList();
        if (paramList.size() < 4) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"getRate", 4});
        }
        for (int i = 0; i < paramList.size(); ++i) {
            resultMap.put(field2Index.get(i), ((ParamItem)paramList.get(i)).toString());
        }
        return resultMap;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            String sNumber = this.getNumber("scenario");
            String yNumber = this.getNumber("year");
            String pNumber = this.getNumber("period");
            String source = (String)this.getModel().getValue("source");
            String target = (String)this.getModel().getValue("target");
            String ratetype = (String)this.getModel().getValue("ratetype");
            String ratescheme = (String)this.getModel().getValue("ratescheme");
            GETRATEFormula getrateFormula = new GETRATEFormula();
            ParamList paramList = new ParamList();
            paramList.add((Object)new ParamItem((Object)source));
            paramList.add((Object)new ParamItem((Object)target));
            paramList.add((Object)new ParamItem((Object)ratetype));
            paramList.add((Object)new ParamItem((Object)ratescheme));
            if (StringUtils.isNotEmpty((String)sNumber)) {
                paramList.add((Object)new ParamItem((Object)sNumber));
            }
            if (StringUtils.isNotEmpty((String)yNumber)) {
                paramList.add((Object)new ParamItem((Object)yNumber));
            }
            if (StringUtils.isNotEmpty((String)pNumber)) {
                paramList.add((Object)new ParamItem((Object)pNumber));
            }
            getrateFormula.initParam(paramList);
            HashMap map = Maps.newHashMap();
            map.put("formula", getrateFormula.toBizRuleFormulaString("getRate"));
            this.getView().returnDataToParent((Object)map);
            this.getView().close();
        }
    }

    private String getNumber(String controlName) {
        return this.getModel().getValue(controlName) == null ? "" : ((DynamicObject)this.getModel().getValue(controlName)).getString("number");
    }

    static {
        field2Index.put(0, "source");
        field2Index.put(1, "target");
        field2Index.put(2, "ratetype");
        field2Index.put(3, "ratescheme");
        field2Index.put(4, "sNumber");
        field2Index.put(5, "yearNumber");
        field2Index.put(6, "periodNumber");
    }
}

