/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.upgrade.RuleHelpItemUpgradeService;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import org.apache.commons.lang.StringUtils;

public class BizRuleHelpItemTreePlugin
extends AbstractListPlugin
implements ClickListener,
ListRowClickListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_BILLLIST = "billlistap";
    private static final String KEY_SEARCH = "searchap";
    private static final String BTN_REFRESH = "btn_refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getControl(KEY_BILLLIST);
        list.addListRowClickListener((ListRowClickListener)this);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_REFRESH.equals(itemKey)) {
            TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
            Map node = tree.getTreeState().getFocusNode();
            Long id = node == null ? 0L : Long.parseLong(node.get("id").toString());
            Search search = (Search)this.getControl(KEY_SEARCH);
            search.setSearchKey("");
            this.refreshBillList(id, true);
            ThreadPoolService.runRulesAsyncThread(() -> new RuleHelpItemUpgradeService().upgrade());
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refresh".equals(key)) {
            TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
            Map node = tree.getTreeState().getFocusNode();
            Long id = node == null ? Long.valueOf(0L) : (Long)node.get("id");
            this.refreshBillList(id, true);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (KEY_TREEVIEW.equals(source.getKey())) {
            this.refreshBillList(Long.valueOf(((TreeView)this.getControl(KEY_TREEVIEW)).getTreeState().getFocusNodeId()), true);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList list = (BillList)this.getView().getControl(KEY_BILLLIST);
        ListSelectedRow info = list.getCurrentSelectedRowInfo();
        if (info != null) {
            Object pk = info.getPrimaryKeyValue();
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bcm_rulehelperitem", (String)"id,number,name,content");
            Markdown mk = (Markdown)this.getView().getControl("markdownap");
            String content = item.getString("content");
            if (StringUtils.isNotEmpty((String)content)) {
                mk.setText(content);
            } else {
                mk.setText("");
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        if (searchText.length() > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u952e\u5b57\u957f\u5ea6\u6700\u5927\u652f\u630150\u4e2a\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"BizRuleHelpItemTreePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isNotEmpty((String)searchText)) {
            String cache = this.getPageCache().get("itemCache");
            Map itemCache = (Map)ObjectSerialUtil.deSerializedBytes((String)cache);
            boolean found = this.searchKeywords(searchText, itemCache);
            if (!found) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u5e2e\u52a9\u4fe1\u606f\u3002", (String)"BizRuleHelpItemTreePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.refreshBillList(0L, true);
        }
    }

    private void refreshBillList(Long nodeId, boolean isNodeClick) {
        QFilter filter;
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        FilterParameter fp = new FilterParameter();
        if (nodeId != 0L || isNodeClick) {
            List<Long> asList = this.findChildrenNodes(nodeId);
            filter = new QFilter("group", "in", asList);
        } else {
            String items = this.getPageCache().get("items");
            filter = StringUtils.isNotEmpty((String)items) ? new QFilter("id", "in", this.getIDList(items)) : null;
        }
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        billList.refresh();
        billList.clearSelection();
    }

    private boolean searchKeywords(String text, Map<String, Tuple<String, String, String>> items) {
        Long nodeId = this.searchAndShowEntry(text, items);
        if (nodeId == null) {
            return false;
        }
        this.refreshBillList(nodeId, false);
        return true;
    }

    private List<Long> findChildrenNodes(long id) {
        ArrayListMultimap<String, DynamicObject> allCategories = this.getAllCategories();
        List dynamicObjects = allCategories.get((Object)String.valueOf(id));
        LinkedList<Long> childIds = new LinkedList<Long>();
        if (dynamicObjects != null) {
            this.getChild(allCategories, String.valueOf(id), childIds);
        }
        return childIds;
    }

    private void getChild(ArrayListMultimap<String, DynamicObject> allCategories, String parentId, List<Long> childIds) {
        List dynamicObjects = allCategories.get((Object)parentId);
        for (DynamicObject dynamicObject : dynamicObjects) {
            this.getChild(allCategories, dynamicObject.getString("id"), childIds);
        }
        childIds.add(Long.parseLong(parentId));
    }

    private List<Object> getIDList(String group) {
        String[] strs = group.split(",");
        ArrayList<Object> ids = new ArrayList<Object>(strs.length);
        for (String str : strs) {
            ids.add(Long.parseLong(str));
        }
        return ids;
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizRuleHelpItemTreePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        tree.addNode(rootNode);
        tree.focusNode(rootNode);
        this.setChildrenNode(rootNode);
        tree.expand("0");
        this.loadItems();
    }

    private Long searchAndShowEntry(String text, Map<String, Tuple<String, String, String>> items) {
        this.getPageCache().remove("items");
        StringJoiner joiner = new StringJoiner(",");
        items.forEach((key, value) -> {
            if (((String)value.p1).toLowerCase().contains(text.toLowerCase()) || ((String)value.p2).toLowerCase().contains(text.toLowerCase())) {
                joiner.add((CharSequence)key);
            }
        });
        if (joiner.length() == 0) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_rulehelperitem", (String)"id", (QFilter[])new QFilter[]{new QFilter("content", "like", (Object)("%" + text + "%"))});
            query.forEach(d -> joiner.add(d.getString("id")));
        }
        if (joiner.length() == 0) {
            return null;
        }
        this.showEntry("0");
        this.getPageCache().put("items", joiner.toString());
        return 0L;
    }

    private void setChildrenNode(TreeNode parentNode) {
        String pNodeId = parentNode.getId();
        ArrayListMultimap<String, DynamicObject> allCategories = this.getAllCategories();
        List list = allCategories.get((Object)pNodeId);
        if (list != null) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(10);
            for (DynamicObject dyn : list) {
                TreeNode node = new TreeNode(pNodeId, dyn.getString("id"), dyn.getString("name"));
                children.add(node);
                for (TreeNode child : children) {
                    this.setChildrenNode(child);
                }
            }
            if (!children.isEmpty()) {
                parentNode.setChildren(children);
            }
        }
    }

    private List<TreeNode> getChildNodes(String pNodeId) {
        ArrayListMultimap<String, DynamicObject> allCategories = this.getAllCategories();
        List list = allCategories.get((Object)pNodeId);
        if (list != null) {
            for (DynamicObject dyn : list) {
                String id = dyn.getString("id");
                String title = dyn.getString("name");
                TreeNode node = new TreeNode(pNodeId, id, title);
                if (!QueryServiceHelper.exists((String)"bcm_rulehelpercatalog", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)Long.parseLong(id))})) continue;
                node.setChildren(this.getChildNodes(id));
            }
        }
        DynamicObjectCollection categories = QueryServiceHelper.query((String)"bcm_rulehelpercatalog", (String)"id,parent,name", null);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(categories.size());
        for (DynamicObject category : categories) {
            long pid = category.getLong("parent");
            String id = String.valueOf(category.get("id"));
            String title = category.getString("name");
            TreeNode node = new TreeNode(String.valueOf(pid), id, title);
            if (!QueryServiceHelper.exists((String)"bcm_rulehelpercatalog", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)Long.parseLong(id))})) continue;
            node.setChildren(this.getChildNodes(id));
        }
        return nodes;
    }

    private void showEntry(String nodeId) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.showNode(nodeId);
        tree.focusNode(new TreeNode("", nodeId, ""));
    }

    private void loadItems() {
        DynamicObjectCollection items = QueryServiceHelper.query((String)"bcm_rulehelperitem", (String)"id,group,number,name", null, (String)"number");
        HashMap<String, Tuple> cache = new HashMap<String, Tuple>(16);
        for (DynamicObject item : items) {
            long pid = item.getLong("group");
            String parent = String.valueOf(pid);
            String id = String.valueOf(item.get("id"));
            String number = item.getString("number");
            String title = item.getString("name");
            cache.put(id, Tuple.create((Object)title, (Object)number, (Object)parent));
        }
        this.getPageCache().put("itemCache", ObjectSerialUtil.toByteSerialized(cache));
    }

    private ArrayListMultimap<String, DynamicObject> getAllCategories() {
        String categoriesCache = this.getPageCache().get("categoriesCache");
        if (StringUtils.isEmpty((String)categoriesCache)) {
            ArrayListMultimap map = ArrayListMultimap.create();
            DynamicObjectCollection categories = QueryServiceHelper.query((String)"bcm_rulehelpercatalog", (String)"id,parent,name", null, (String)"level,dseq");
            for (DynamicObject category : categories) {
                map.put((Object)category.getString("parent"), (Object)category);
            }
            categoriesCache = ObjectSerialUtil.toByteSerialized((Object)map);
            this.getPageCache().put("categoriesCache", categoriesCache);
        }
        return (ArrayListMultimap)ObjectSerialUtil.deSerializedBytes((String)categoriesCache);
    }
}

