/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.bcm.business.allinone.service.MergeProgressHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.rule.BizRuleImportTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.computing.BizRuleExportHelper;
import kd.fi.bcm.formplugin.computing.BizRuleImportService;

public class BizRuleImportPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String KEY_ATTACHMENTPANEL = "attachment";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String IMPORT = "btn_import";

    private String getOperationImport() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6574\u89c4\u5219", (String)"BizRuleImportPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u5e76\u8986\u76d6\u3002", (String)"BizRuleImportPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"BizRuleImportPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{IMPORT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (IMPORT.equals(control.getKey())) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
            if (MergeProgressHelper.hasMergeExecute((long)modelId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u667a\u80fd\u5408\u5e76\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u5bfc\u5165\u3002", (String)"BizRuleImportPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (this.getPageCache().get("urls") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BizRuleImportPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            boolean isSelect = (Boolean)this.getModel().getValue("exportbackup");
            String message = null;
            if (isSelect) {
                String modelShowNumber = (String)this.getView().getFormShowParameter().getCustomParam("modelNum");
                message = BizRuleExportHelper.exportBizRule((IClientViewProxy)this.getView().getService(IClientViewProxy.class), modelId, modelShowNumber, RequestContext.get().getCurrUserId(), Collections.emptyList());
            }
            String importType = this.getImportType();
            if (message == null) {
                this.getView().showConfirm(this.getConfirmMessage(importType), MessageBoxOptions.YesNo, new ConfirmCallBackListener(IMPORT, (IFormPlugin)this));
            } else {
                this.getView().showErrorNotification(message);
            }
        }
    }

    private String getConfirmMessage(String importType) {
        switch (importType) {
            case "1": {
                return ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u4f53\u7cfb\u4e0b\u6240\u6709\u89c4\u5219\u3002\u786e\u8ba4\u8981\u5bfc\u5165\u5417\uff1f", (String)"BizRuleImportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u66f4\u65b0\u5f53\u524d\u4f53\u7cfb\u4e0b\u5b58\u5728\u7684\u89c4\u5219\u5e76\u65b0\u589e\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u7684\u89c4\u5219\u3002\u786e\u8ba4\u8981\u5bfc\u5165\u5417\uff1f", (String)"BizRuleImportPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u65b0\u589e\u5f53\u524d\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u7684\u89c4\u5219\u3002\u786e\u8ba4\u8981\u5bfc\u5165\u5417\uff1f", (String)"BizRuleImportPlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u4f53\u7cfb\u4e0b\u6240\u6709\u89c4\u5219\u3002\u786e\u8ba4\u8981\u5bfc\u5165\u5417\uff1f", (String)"BizRuleImportPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue() && IMPORT.equals(callBackId)) {
            long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"BizRuleImportPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            List urls = (List)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("urls"));
            String importType = this.getImportType();
            String result = new BizRuleImportService(importType).importBizRule(this.getView(), (String)((Map)urls.get(0)).get("url"));
            this.getView().hideLoading();
            if (result == null) {
                this.getView().returnDataToParent((Object)"OK");
                OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationImport(), (String)this.getOperationStatusSuccess(), (Long)modelId);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(result);
                OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)this.getOperationImport(), (String)this.getOperationStatusFail(), (Long)modelId);
            }
        }
    }

    private String getImportType() {
        return this.getModel().getValue("importtype") == null ? BizRuleImportTypeEnum.OVERRIDE.getCode() : String.valueOf(this.getModel().getValue("importtype"));
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList urls = new ArrayList(10);
        Collections.addAll(urls, evt.getUrls());
        this.getPageCache().put("urls", ObjectSerialUtil.toByteSerialized(urls));
        this.getView().setEnable(Boolean.valueOf(true), new String[]{IMPORT});
    }

    public void afterRemove(UploadEvent evt) {
        this.getPageCache().put("urls", null);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{IMPORT});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{IMPORT});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("importtype")) {
            if (e.getChangeSet()[0].getNewValue().equals(BizRuleImportTypeEnum.OVERRIDE.getCode())) {
                this.getModel().setValue("exportbackup", (Object)true);
            } else {
                this.getModel().setValue("exportbackup", (Object)false);
            }
        }
    }
}

