/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentCopySource;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentIfCondition;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentScope;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleIfCondition;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleScope;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunction;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionClear;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionCopy;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionRuns;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionV;
import kd.fi.bcm.business.dimension.helper.ImportJsonServiceHelper;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleImportTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleTypeEnum;
import kd.fi.bcm.common.enums.rule.CheckMethodEnum;
import kd.fi.bcm.common.enums.rule.LinkSymbolEnum;
import kd.fi.bcm.common.enums.rule.OutputLogEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.computing.BizRuleConfigFormulaHelper;
import kd.fi.bcm.formplugin.computing.BizRuleConfigImportAndExport;
import kd.fi.bcm.formplugin.computing.BizRuleExportHelper;
import kd.fi.bcm.formplugin.computing.BizRuleHelper;
import org.apache.commons.collections.CollectionUtils;

public class BizRuleImportService {
    private final WatchLogger log = BcmLogFactory.getWatchLogInstance(BizRuleImportService.class);
    private final String lineSp = System.lineSeparator();
    private final String importType;
    private final List<Long> updateBizRuleId = new ArrayList<Long>();

    public BizRuleImportService(String importType) {
        this.importType = importType;
    }

    public String importBizRule(IFormView formView, String url) {
        String errMsg = null;
        long modelId = (Long)formView.getFormShowParameter().getCustomParam("modelId");
        long userId = Long.parseLong(formView.getFormShowParameter().getCustomParam("userId").toString());
        String json = ImportJsonServiceHelper.loadTextFileString((String)url);
        String[] data = (json = json.replaceAll("\\r\\n|\\n|\\n\\r", System.lineSeparator())).split("//----------------------------\u89c4\u5219\u5c5e\u6027\u5b9a\u4e49----------------------------" + System.lineSeparator());
        if (data.length == 1) {
            data = json.split("//----------------------------\u89c4\u5219\u811a\u672c\u5c5e\u6027\u5b9a\u4e49----------------------------" + System.lineSeparator());
        }
        if (data.length < 2) {
            errMsg = ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u3002\u8bf7\u53c2\u8003\u5bfc\u51fa\u7684\u6587\u4ef6\u683c\u5f0f\u3002", (String)"BizRuleImportHelper_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else {
            try {
                DynamicObject[] bizRuleArray = new DynamicObject[data.length - 1];
                ArrayList<DynamicObject> processList = new ArrayList<DynamicObject>(10);
                ArrayList<DynamicObject> locateSet = new ArrayList<DynamicObject>(10);
                ArrayList<String> ruleNumberList = new ArrayList<String>(data.length - 1);
                Map<String, Long> existRuleMap = this.getExistRuleMap(modelId);
                this.buildAllBizRuleAndProcess(modelId, userId, data, bizRuleArray, processList, locateSet, existRuleMap, ruleNumberList);
                this.saveRuleAndProcess(modelId, bizRuleArray, processList, locateSet, existRuleMap);
            }
            catch (Exception e) {
                this.log.error(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u4e1a\u52a1\u89c4\u5219\u5f02\u5e38\uff1a%s", (String)"BizRuleImportHelper_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e));
                errMsg = String.format(ResManager.loadKDString((String)"\u89c4\u5219\u5bfc\u5165\u5931\u8d25\u5f02\u5e38\uff1a%s", (String)"BizRuleImportHelper_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage());
            }
            ThreadPoolService.runRulesAsyncThread(() -> BizRuleUtil.updateBizRuleInternalId(null));
        }
        return errMsg;
    }

    private Map<String, Long> getExistRuleMap(long modelId) {
        DynamicObjectCollection allExistRuleArray = this.getAllBizRuleFromDB(modelId);
        HashMap<String, Long> existRuleMap = new HashMap<String, Long>(allExistRuleArray.size());
        ArrayList<String> existRuleNames = new ArrayList<String>();
        for (DynamicObject rule : allExistRuleArray) {
            existRuleMap.put(rule.getString("number"), rule.getLong("id"));
            existRuleNames.add(rule.getString("name"));
        }
        ThreadCache.put((Object)modelId, existRuleNames);
        return existRuleMap;
    }

    private DynamicObjectCollection getAllBizRuleFromDB(long modelId) {
        String selectField = "id,number,name";
        QFBuilder ruleBuilder = new QFBuilder();
        ruleBuilder.add("model", "=", (Object)modelId);
        ruleBuilder.add("deletestatus", "=", (Object)"0");
        return QueryServiceHelper.query((String)"bcm_bizruleentity", (String)selectField, (QFilter[])ruleBuilder.toArray());
    }

    private void buildAllBizRuleAndProcess(long modelId, long userId, String[] data, DynamicObject[] bizRuleArray, List<DynamicObject> processList, List<DynamicObject> locateList, Map<String, Long> existRuleMap, List<String> ruleNumberList) {
        long processDimensionId = BizRuleUtil.getProcessDimensionId((Object)modelId);
        Map templateNumberAndIdMap = BizRuleUtil.getAllTemplateNumberAndIdMap((long)modelId);
        Map invTemplateNumberAndIdMap = BizRuleUtil.getAllInvTemplateNumberAndIdMap((long)modelId);
        ArrayList<String> ruleNameList = new ArrayList(data.length - 1);
        if (BizRuleImportTypeEnum.NEW.getCode().equals(this.importType) && ThreadCache.get((Object)modelId) != null) {
            ruleNameList = (List)ThreadCache.get((Object)modelId);
        }
        Map<String, Long> processMap = this.getAllProcess(modelId);
        for (int i = 1; i < data.length; ++i) {
            String[] rule = data[i].split("//------------------------------\u89c4\u5219\u5185\u5bb9------------------------------" + System.lineSeparator());
            if (rule.length == 1) {
                rule = data[i].split("//------------------------------\u89c4\u5219\u811a\u672c\u5185\u5bb9------------------------------" + System.lineSeparator());
            }
            if (rule.length == 2) {
                HashMap<String, String> paramMap = new HashMap<String, String>(8);
                this.validateRuleParam(paramMap, rule[0]);
                long ruleId = this.getRuleId(existRuleMap, paramMap);
                if (BizRuleImportTypeEnum.NEW.getCode().equals(this.importType) && this.updateBizRuleId.contains(ruleId)) continue;
                this.buildBizRuleObject(ruleId, modelId, userId, ruleNumberList, paramMap, rule[1], i, bizRuleArray, ruleNameList);
                this.setProcessAndOrder(paramMap, (String)paramMap.get("RuleCode"), processList, processDimensionId, processMap, ruleId, modelId);
                if (!StringUtils.isNotEmpty((String)((String)paramMap.get("Templates"))) || !StringUtils.isNotEmpty((String)((String)paramMap.get("TemplateAction")))) continue;
                boolean isInv = BizRuleExecuteTypeEnum.getEnumByShowNumber((String)((String)paramMap.get("ExecuteType"))) == BizRuleExecuteTypeEnum.EQUITY_ONLY;
                this.setRuleTemplateAllocation((String)paramMap.get("Templates"), (String)paramMap.get("TemplateAction"), isInv ? invTemplateNumberAndIdMap : templateNumberAndIdMap, locateList, ruleId, modelId, userId, isInv);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u811a\u672c\u89c4\u5219\u683c\u5f0f\u6709\u8bef\uff1a%s", (String)"BizRuleImportHelper_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), data[i]));
        }
    }

    private void setRuleTemplateAllocation(String templates, String templateAction, Map<String, Long> templateNumberAndIdMap, List<DynamicObject> locateList, long ruleId, long modelId, long userId, boolean isInv) {
        String[] templateArray = templates.split(";");
        String[] templateActionArray = templateAction.split(";");
        for (int i = 0; i < templateArray.length; ++i) {
            String tmpNumber = templateArray[i];
            Long tmpId = templateNumberAndIdMap.get(tmpNumber);
            if (tmpId == null || tmpId <= 0L) continue;
            String currentTmpAction = templateActionArray[i];
            HashSet<String> actionSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((String)currentTmpAction)) {
                String[] split;
                for (String action : split = currentTmpAction.split(",")) {
                    actionSet.add(action.trim());
                }
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brallocateentity");
            dynamicObject.set("model", (Object)modelId);
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("execseq", (Object)"1");
            dynamicObject.set(isInv ? "papertemplate" : "template", (Object)tmpId);
            dynamicObject.set("bizrule", (Object)ruleId);
            dynamicObject.set("execwhensave", (Object)(actionSet.contains("Save") ? Boolean.TRUE : Boolean.FALSE));
            dynamicObject.set("execwhenopen", (Object)(actionSet.contains("Open") ? Boolean.TRUE : Boolean.FALSE));
            locateList.add(dynamicObject);
        }
    }

    private long getRuleId(Map<String, Long> existRuleMap, Map<String, String> paramMap) {
        Long ruleId = existRuleMap.get(paramMap.get("RuleCode"));
        if (ruleId != null) {
            this.updateBizRuleId.add(ruleId);
            return ruleId;
        }
        return GlobalIdUtil.genGlobalLongId();
    }

    private void saveRuleAndProcess(long modelId, DynamicObject[] bizRuleArray, List<DynamicObject> processList, List<DynamicObject> locateList, Map<String, Long> existRuleMap) {
        try (TXHandle tx = TX.required();){
            try {
                if (existRuleMap.size() > 0) {
                    QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
                    QFilter bizRuleFilter = this.getSingleFilter(existRuleMap, "bizrule").or("bizrule.deletestatus", "=", (Object)"1");
                    DeleteServiceHelper.delete((String)"bcm_bizrulealloprocess", (QFilter[])new QFilter[]{modelFilter, bizRuleFilter});
                    DeleteServiceHelper.delete((String)"bcm_brallocateentity", (QFilter[])new QFilter[]{modelFilter, bizRuleFilter});
                    QFilter idFilter = this.getSingleFilter(existRuleMap, "id").or("deletestatus", "=", (Object)"1");
                    DeleteServiceHelper.delete((String)"bcm_bizruleentity", (QFilter[])new QFilter[]{modelFilter, idFilter});
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (DynamicObject dynamicObject : bizRuleArray) {
                    if (dynamicObject == null) continue;
                    list.add(dynamicObject);
                }
                if (CollectionUtils.isNotEmpty(list)) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)list.get(0)).getDataEntityType(), (Object[])list.toArray());
                }
                if (CollectionUtils.isNotEmpty(processList)) {
                    SaveServiceHelper.save((IDataEntityType)processList.get(0).getDataEntityType(), (Object[])processList.toArray());
                }
                if (CollectionUtils.isNotEmpty(locateList)) {
                    SaveServiceHelper.save((IDataEntityType)locateList.get(0).getDataEntityType(), (Object[])locateList.toArray());
                }
                BizRuleHelper.updateCalculateStatus(String.valueOf(modelId));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    private QFilter getSingleFilter(Map<String, Long> existRuleMap, String propertyName) {
        if (BizRuleImportTypeEnum.UPDATE.getCode().equals(this.importType)) {
            return new QFilter(propertyName, "in", this.updateBizRuleId);
        }
        if (BizRuleImportTypeEnum.NEW.getCode().equals(this.importType)) {
            return new QFilter("1", "=", (Object)0);
        }
        return new QFilter(propertyName, "in", existRuleMap.values());
    }

    private void buildBizRuleObject(long ruleId, long modelId, long userId, List<String> ruleNumberList, Map<String, String> paramMap, String ruleContent, int order, DynamicObject[] bizRuleArray, List<String> ruleNameList) {
        DynamicObject bizRule = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleentityconfig");
        this.checkRuleCodeIsExit(ruleNumberList, paramMap);
        this.checkRuleLegal(paramMap.get("RuleCode"));
        this.checkRuleNameIsExit(ruleNameList, paramMap);
        String errMsg = BizRuleUtil.checkScriptGrammar((String)ruleContent);
        if (StringUtils.isEmpty((String)errMsg)) {
            bizRule.set("id", (Object)ruleId);
            bizRule.set("number", (Object)paramMap.get("RuleCode"));
            bizRule.set("name", (Object)paramMap.get("RuleName"));
            bizRule.set("executeseq", (Object)order);
            bizRule.set("description", (Object)paramMap.get("Description"));
            bizRule.set("iscommon", (Object)"None".equalsIgnoreCase(paramMap.get("Process")));
            bizRule.set("deletestatus", (Object)false);
            bizRule.set("status", (Object)("Y".equalsIgnoreCase(paramMap.get("Status")) ? "1" : "2"));
            bizRule.set("model", (Object)modelId);
            bizRule.set("runstatus", (Object)"3");
            bizRule.set("priority", (Object)1);
            bizRule.set("creator", (Object)userId);
            bizRule.set("modifier", (Object)userId);
            bizRule.set("createtime", (Object)TimeServiceHelper.now());
            bizRule.set("modifytime", (Object)TimeServiceHelper.now());
            bizRule.set("defaultimport", (Object)"Y".equalsIgnoreCase(paramMap.get("AutoImported")));
            if (paramMap.get("RuleType") != null && this.isSpecificType(paramMap, BizRuleTypeEnum.CONFIG)) {
                List list = null;
                try {
                    list = (List)JSON.parseObject((String)ruleContent, (TypeReference)new TypeReference<List<BizRuleConfigImportAndExport>>(){}, (Feature[])new Feature[0]);
                    ArrayList<DynamicObject> entryentityList = new ArrayList<DynamicObject>(list.size());
                    for (Object importAndExport : list) {
                        String logicNumber = ((BizRuleConfigImportAndExport)importAndExport).getLogicCode();
                        String logicName = ((BizRuleConfigImportAndExport)importAndExport).getLogicName();
                        String logicLog = OutputLogEnum.getEnumByengDesc((String)((BizRuleConfigImportAndExport)importAndExport).getLogTag()).getType();
                        DynamicObject dyo = new DynamicObject(bizRule.getDynamicObjectCollection("entryentity").getDynamicObjectType());
                        dyo.set("logic_number", (Object)logicNumber);
                        dyo.set("logic_name", (Object)logicName);
                        dyo.set("logic_log", (Object)logicLog);
                        BizRuleComponentIfCondition bizRuleFunctionIfCondition = new BizRuleComponentIfCondition(this.getLogicConditionByStr(((BizRuleConfigImportAndExport)importAndExport).getCondition(), modelId));
                        dyo.set("logic_condition", (Object)bizRuleFunctionIfCondition.toString());
                        BizRuleComponentScope bizRuleFunctionScope = new BizRuleComponentScope(this.getScopeByStr(((BizRuleConfigImportAndExport)importAndExport).getInclude(), ((BizRuleConfigImportAndExport)importAndExport).getExcept()), modelId);
                        dyo.set("logic_scope", (Object)bizRuleFunctionScope.toString());
                        String logicExpression = ((BizRuleConfigImportAndExport)importAndExport).getExps().replace("'", "\"");
                        dyo.set("logic_expression", (Object)logicExpression);
                        String importAndExportCopySource = ((BizRuleConfigImportAndExport)importAndExport).getCopySource();
                        dyo.set("copysource", (Object)importAndExportCopySource);
                        String codeByType = BizRuleLogicTypeEnum.getCodeByType((String)((BizRuleConfigImportAndExport)importAndExport).getLogicType());
                        dyo.set("logic_type", (Object)codeByType);
                        switch (codeByType) {
                            case "1": {
                                BizRuleFunctionV bizRuleFunctionV = new BizRuleFunctionV(logicExpression, this.getLogicJsByExpression(logicExpression));
                                BizRuleFunctionRuns bizRuleFunctionRuns = new BizRuleFunctionRuns(logicLog, logicName, logicNumber, (BizRuleComponent)bizRuleFunctionIfCondition, (BizRuleComponent)bizRuleFunctionScope, (BizRuleFunction)bizRuleFunctionV);
                                dyo.set("logic_js", (Object)bizRuleFunctionRuns.generateJsScript());
                                break;
                            }
                            case "2": {
                                String[] split = importAndExportCopySource.split(",");
                                LinkedHashMap<String, String> dim2Member = new LinkedHashMap<String, String>();
                                for (String dimAndMember : split) {
                                    String[] split1 = dimAndMember.split("@");
                                    if (split1.length != 2) continue;
                                    dim2Member.put(split1[0], split1[1]);
                                }
                                BizRuleComponentCopySource copySource = new BizRuleComponentCopySource(dim2Member);
                                BizRuleFunctionCopy bizRuleFunctionCopy = new BizRuleFunctionCopy(logicLog, logicName, logicNumber, (BizRuleComponent)bizRuleFunctionIfCondition, (BizRuleComponent)bizRuleFunctionScope, (BizRuleComponent)copySource);
                                dyo.set("logic_js", (Object)bizRuleFunctionCopy.generateJsScript());
                                break;
                            }
                            case "3": {
                                BizRuleFunctionClear bizRuleFunctionClear = new BizRuleFunctionClear(logicLog, logicName, logicNumber, (BizRuleComponent)bizRuleFunctionIfCondition, (BizRuleComponent)bizRuleFunctionScope);
                                dyo.set("logic_js", (Object)bizRuleFunctionClear.generateJsScript());
                                break;
                            }
                        }
                        dyo.set("logic_commitexpr", (Object)BizRuleExportHelper.getRuleInfoBean(dyo));
                        entryentityList.add(dyo);
                    }
                    bizRule.set("entryentity", entryentityList);
                    bizRule.set("type", (Object)BizRuleTypeEnum.CONFIG.getType());
                    StringBuilder sb = new StringBuilder();
                    sb.append("/**").append(this.lineSp).append(" * ").append(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u7f16\u7801 ", (String)"BizRuleImportHelper_24", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(bizRule.getString("number"));
                    sb.append(this.lineSp).append(" * ").append(ResManager.loadKDString((String)"\u914d\u7f6e\u89c4\u5219\u540d\u79f0 ", (String)"BizRuleImportHelper_25", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(bizRule.getString("name"));
                    sb.append(this.lineSp).append(" * ").append(ResManager.loadKDString((String)"\u5206\u914d\u8fc7\u7a0b ", (String)"BizRuleImportHelper_26", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(bizRule.getString("alloprocessname"));
                    sb.append(this.lineSp).append(" * ").append(ResManager.loadKDString((String)"\u8bf4\u660e ", (String)"BizRuleImportHelper_27", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(bizRule.getString("description")).append(this.lineSp).append(" */").append(this.lineSp).append(this.lineSp);
                    for (DynamicObject lg : entryentityList) {
                        sb.append(lg.get("logic_js")).append(this.lineSp).append(this.lineSp);
                    }
                    String script = sb.toString();
                    if (entryentityList.size() > 1) {
                        StringBuilder builder = new StringBuilder("beginBatch();\r\n");
                        script = builder.append(script).append("\r\nendBatch();").toString();
                    }
                    bizRule.set("content", (Object)script);
                    bizRule.set("debug", (Object)script);
                }
                catch (Exception e) {
                    this.log.error(String.format("import bizrule error![rulecode]:[%s],[rulename]:[%s]", paramMap.get("RuleCode"), paramMap.get("RuleName")), (Throwable)e);
                    bizRule.set("content", (Object)ruleContent);
                    bizRule.set("debug", (Object)ruleContent);
                    bizRule.set("type", (Object)BizRuleTypeEnum.SCRIPT.getType());
                }
            } else {
                bizRule.set("content", (Object)ruleContent);
                bizRule.set("debug", (Object)ruleContent);
                bizRule.set("type", (Object)BizRuleTypeEnum.SCRIPT.getType());
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801\uff1a%1$s\uff0c%2$s", (String)"BizRuleImportHelper_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramMap.get("RuleCode"), errMsg));
        }
        bizRule.set("templatename", (Object)paramMap.get("Templates"));
        bizRule.set("executetype", (Object)BizRuleExecuteTypeEnum.getEnumByShowNumber((String)paramMap.get("ExecuteType")).getCode());
        bizRuleArray[order - 1] = bizRule;
    }

    private void checkRuleLegal(String ruleCode) {
        String msg = BizRuleUtil.validBizRuleNumber((String)ruleCode);
        if (StringUtils.isNotEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
        if (ruleCode.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a50\u3002", (String)"BizRuleImportHelper_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isSpecificType(Map<String, String> paramMap, BizRuleTypeEnum ruleTypeEnum) {
        return ruleTypeEnum.getDesc().equals(paramMap.get("RuleType").trim()) || ruleTypeEnum.getShowNumber().equals(paramMap.get("RuleType").trim());
    }

    private List<BizRuleIfCondition> getLogicConditionByStr(List<BizRuleConfigImportAndExport.ConfigCondition> condition, long modelId) {
        ArrayList<BizRuleIfCondition> list = new ArrayList<BizRuleIfCondition>(10);
        for (BizRuleConfigImportAndExport.ConfigCondition configCondition : condition) {
            BizRuleIfCondition bizRuleIfCondition = new BizRuleIfCondition();
            bizRuleIfCondition.setLinkSymbol(LinkSymbolEnum.getEnumByEngDes((String)configCondition.getConn()));
            bizRuleIfCondition.setDimension(SysDimensionEnum.getEnumByNumber((String)configCondition.getDim()));
            bizRuleIfCondition.setConditionNumber(configCondition.getType());
            if (CheckMethodEnum.INCLUDE.getExpress().equals(configCondition.getMethod()) || CheckMethodEnum.NOT_INCLUDE.getExpress().equals(configCondition.getMethod())) {
                bizRuleIfCondition.setMultiConditionContentNumber(configCondition.getValues());
            } else {
                bizRuleIfCondition.setConditionContentNumber(configCondition.getValue());
            }
            bizRuleIfCondition.setMethod(CheckMethodEnum.getEnumByExpress((String)configCondition.getMethod(), (String)configCondition.getValue(), (String)configCondition.getValues()));
            bizRuleIfCondition.setPriority(Integer.parseInt(configCondition.getPrior()));
            bizRuleIfCondition.setModelId(modelId);
            list.add(bizRuleIfCondition);
        }
        return list;
    }

    private String getLogicJsByExpression(String logicExpression) {
        String[] formulaStrs = logicExpression.split(";");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String formulaStr : formulaStrs) {
            sb.append(BizRuleImportService.getJsExpressStr(formulaStr));
            if (count == formulaStr.length() - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    private static String getJsExpressStr(String formulaStr) {
        return BizRuleConfigFormulaHelper.getJsFormula(formulaStr);
    }

    private List<BizRuleScope> getScopeByStr(List<BizRuleConfigImportAndExport.ConfigInclude> include, List<BizRuleConfigImportAndExport.ConfigExcept> except) {
        ArrayList<BizRuleScope> list = new ArrayList<BizRuleScope>(10);
        for (BizRuleConfigImportAndExport.ConfigInclude configInclude : include) {
            BizRuleScope bizRuleScope = new BizRuleScope();
            bizRuleScope.setDimension(configInclude.getDim());
            bizRuleScope.setIncludeNumber(this.getMemberByConfigStr(configInclude.getMember()));
            list.add(bizRuleScope);
        }
        for (BizRuleConfigImportAndExport.ConfigExcept configExcept : except) {
            boolean flag = true;
            for (BizRuleScope bizRuleScope : list) {
                if (!bizRuleScope.getDimension().equals(configExcept.getDim())) continue;
                bizRuleScope.setExcludeNumber(this.getMemberByConfigStr(configExcept.getMember()));
                flag = false;
            }
            if (!flag) continue;
            BizRuleScope exceptBizRuleScop = new BizRuleScope();
            exceptBizRuleScop.setDimension(configExcept.getDim());
            exceptBizRuleScop.setExcludeNumber(this.getMemberByConfigStr(configExcept.getMember()));
            list.add(exceptBizRuleScop);
        }
        return list;
    }

    private String getMemberByConfigStr(String member) {
        String[] members = member.split(",");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String str : members) {
            sb.append(this.changeToLogicScopeMember(str));
            if (count < members.length - 1) {
                sb.append(",");
            }
            ++count;
        }
        return sb.toString();
    }

    private String changeToLogicScopeMember(String str) {
        if (str.endsWith(".children()")) {
            return str.replace(".children()", "@20");
        }
        if (str.endsWith(".base()")) {
            return str.replace(".base()", "@90");
        }
        if (str.endsWith(".hierarchy()")) {
            return str.replace(".hierarchy()", "@50");
        }
        if (str.endsWith(".descendant()")) {
            return str.replace(".descendant()", "@40");
        }
        return str;
    }

    private Map<String, Long> getAllProcess(long modelId) {
        QFilter qFilterProcess = new QFilter("model", "=", (Object)modelId);
        qFilterProcess.and(new QFilter("storagetype", "!=", (Object)"3"));
        DynamicObjectCollection processDynamicList = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,number", (QFilter[])qFilterProcess.toArray());
        HashMap<String, Long> processMap = new HashMap<String, Long>(processDynamicList.size());
        for (DynamicObject process : processDynamicList) {
            processMap.put(process.getString("number"), process.getLong("id"));
        }
        return processMap;
    }

    private void setProcessAndOrder(Map<String, String> paramMap, String ruleCode, List<DynamicObject> processList, long processDimensionId, Map<String, Long> processMap, long ruleId, long modelId) {
        String[] orderArray;
        String process = paramMap.get("Process");
        String order = paramMap.get("Order");
        String execType = paramMap.get("ExecuteType");
        if (!"None".equalsIgnoreCase(process) && process.contains("None")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u91ccNone\u4e0e\u5176\u4ed6\u8fc7\u7a0b\u4e0d\u80fd\u5171\u5b58\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
        String[] processArray = process.split(",");
        if (processArray.length != (orderArray = order.split(",")).length) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u548cOrder\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
        this.checkProcessOrder(ruleCode, processArray, orderArray);
        this.checkPorcessMatchExecType(ruleCode, processArray, execType);
        this.buildRuleProcessObject(processList, processDimensionId, processMap, ruleId, modelId, processArray, orderArray, ruleCode);
    }

    private void checkPorcessMatchExecType(String ruleCode, String[] processArray, String execType) {
        if (BizRuleExecuteTypeEnum.INVEST_ONLY.getShowNumber().equals(execType) && (processArray.length > 1 || !"EIRpt".equals(processArray[0]))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u548cExecuteType\u51b2\u7a81\uff0c\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
    }

    private void checkProcessOrder(String ruleCode, String[] processArray, String[] orderArray) {
        try {
            for (String o : orderArray) {
                if (Integer.parseInt(o) >= 1) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Order\u7684\u503c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6570\u5b57\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Order\u7684\u503c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6570\u5b57\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
        HashSet processSet = new HashSet(processArray.length);
        Collections.addAll(processSet, processArray);
        if (processArray.length != processSet.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u4e2d\u6709\u91cd\u590d\u7684\u8fc7\u7a0b\u7f16\u7801\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
    }

    private void buildRuleProcessObject(List<DynamicObject> processList, long processDimensionId, Map<String, Long> processMap, long ruleId, long modelId, String[] processArray, String[] orderArray, String ruleCode) {
        for (int i = 0; i < processArray.length; ++i) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulealloprocess");
            obj.set("bizrule", (Object)ruleId);
            obj.set("dimension", (Object)processDimensionId);
            if ("None".equalsIgnoreCase(processArray[i])) {
                obj.set("member", (Object)-1);
            } else {
                if (processMap.get(processArray[i]) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fc7\u7a0b\u7f16\u7801\u4e0d\u5b58\u5728\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
                }
                obj.set("member", (Object)processMap.get(processArray[i]));
            }
            obj.set("model", (Object)modelId);
            obj.set("execsort", (Object)orderArray[i]);
            processList.add(obj);
        }
    }

    private void checkRuleCodeIsExit(List<String> ruleNumberList, Map<String, String> paramMap) {
        String ruleCode = paramMap.get("RuleCode");
        if (ruleNumberList.contains(ruleCode)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u8bb0\u5f55\u3002", (String)"BizRuleImportHelper_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
        }
        ruleNumberList.add(ruleCode);
    }

    private void checkRuleNameIsExit(List<String> ruleNameList, Map<String, String> paramMap) {
        String ruleName = paramMap.get("RuleName");
        if (ruleNameList.contains(ruleName)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540d\u79f0\u91cd\u590d\uff0c\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramMap.get("RuleCode")));
        }
        ruleNameList.add(ruleName);
    }

    private void validateRuleParam(Map<String, String> paramMap, String paramStr) {
        String errMsg = null;
        try {
            String[] params;
            for (String param : params = paramStr.split(System.lineSeparator())) {
                int pos = param.indexOf("}");
                if (pos <= 2) {
                    errMsg = "";
                    break;
                }
                paramMap.put(param.substring(1, pos), param.substring(pos + 1).trim());
            }
        }
        catch (Exception e) {
            errMsg = "";
        }
        if (paramMap.size() < 9) {
            errMsg = "";
        } else {
            String ruleCode = paramMap.get("RuleCode");
            if (StringUtils.isEmpty((String)ruleCode)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"RuleCode\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u503c\u4e3a\u7a7a\uff1a%s\u3002", (String)"BizRuleImportHelper_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramStr));
            }
            if (StringUtils.isEmpty((String)paramMap.get("RuleName"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"RuleName\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u503c\u4e3a\u7a7a\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (StringUtils.isEmpty((String)paramMap.get("Process"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u503c\u4e3a\u7a7a\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (StringUtils.isEmpty((String)paramMap.get("Order"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Order\u5c5e\u6027\u4e0d\u5b58\u5728\u6216\u503c\u4e3a\u7a7a\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (paramMap.get("Description") == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Description\u5c5e\u6027\u4e0d\u5b58\u5728\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (paramMap.get("AutoImported") == null || !"Y".equalsIgnoreCase(paramMap.get("AutoImported")) && !"N".equalsIgnoreCase(paramMap.get("AutoImported"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"AutoImported\u5c5e\u6027\u7684\u503c\u5fc5\u987b\u662f\u201cY\u201d\u6216\u8005\u201cN\u201d\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (paramMap.get("Status") == null || !"Y".equalsIgnoreCase(paramMap.get("Status")) && !"N".equalsIgnoreCase(paramMap.get("Status"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Status\u5c5e\u6027\u7684\u503c\u5fc5\u987b\u662f\u201cY\u201d\u6216\u8005\u201cN\u201d\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
            if (StringUtils.isNotEmpty((String)paramMap.get("Templates")) && StringUtils.isNotEmpty((String)paramMap.get("TemplateAction"))) {
                String[] temActionArray;
                String templates = paramMap.get("Templates");
                String templateAction = paramMap.get("TemplateAction");
                String[] temArray = templates.split(";");
                if (temArray.length != (temActionArray = templateAction.split(";")).length) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"Templates\u548cTemplateAction\u5c5e\u6027\u6620\u5c04\u5173\u7cfb\u4e0d\u4e00\u81f4\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
                }
            }
            if (!"None".equalsIgnoreCase(paramMap.get("Process")) && "Y".equalsIgnoreCase(paramMap.get("AutoImported"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"Process\u4e0d\u4e3a\u7a7a\u65f6\uff0cAutoImported\u503c\u53ea\u80fd\u4e3a\u201cN\u201d\u3002\u51fa\u9519\u7684\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\uff1a%s\u3002", (String)"BizRuleImportHelper_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ruleCode));
            }
        }
        if (errMsg != null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u811a\u672c\u5c5e\u6027\u5b9a\u4e49\u6709\u8bef\uff1a%s", (String)"BizRuleImportHelper_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramStr));
        }
    }
}

