/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BizRuleCatalogEnum;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicStatusEnum;
import kd.fi.bcm.common.enums.rule.BizRuleTypeEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.CreateCopyNameUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.computing.BizRuleConfigFormulaHelper;
import kd.fi.bcm.formplugin.computing.BizRuleExportHelper;
import kd.fi.bcm.formplugin.computing.BizRuleHelper;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BizRuleListPlugin
extends AbstractBaseListPlugin
implements IRefreshList {
    private static final String DELETEBIZRULE_COMFIRM = "deletebizrule_comfirm";
    private static final String KEY_BIZRULECATALOG = "bizrulecatalog";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String modelCacheKey = "KEY_MODEL_ID";
    private static final String allocate_formid = "bcm_brallocate";
    private static final String commitbizrule_comfirm = "commitbizrule_comfirm";
    private static final String billlist_selected_idlist = "BILLLIST_SELECTED_IDLIST";
    public static final String FOCUS_NODE_ID = "FOCUS_NODE_ID";
    public static final Set<String> CAN_ADD_BIZRULE_CATALOG_SET = Sets.newHashSet((Object[])new String[]{BizRuleCatalogEnum.Normal.getNumber(), BizRuleCatalogEnum.BFLY.getNumber(), BizRuleCatalogEnum.PC.getNumber(), BizRuleCatalogEnum.IRpt.getNumber(), BizRuleCatalogEnum.Tra.getNumber(), BizRuleCatalogEnum.CS.getNumber(), BizRuleCatalogEnum.EICA.getNumber(), BizRuleCatalogEnum.EIT.getNumber(), BizRuleCatalogEnum.EOE.getNumber(), BizRuleCatalogEnum.ECF.getNumber(), BizRuleCatalogEnum.EOther.getNumber(), BizRuleCatalogEnum.ADJ.getNumber(), BizRuleCatalogEnum.DADJ.getNumber(), BizRuleCatalogEnum.DEJE.getNumber()});
    private static final String can_add_biz_rule_catalog_map = "canAddBizRuleCatalogMap";
    private static final String bar_import = "bar_import";
    private static final String bar_export = "bar_export";
    private static final String BAR_EXPORT_PART = "bar_export_part";
    private static final String EDIT_BIZRULE = "editbizrule";
    private static final String bar_copy = "bar_copy";
    private static final String[] HIDDEN_BUTTONS = new String[]{"bar_add", "bar_delete", "bar_commit", "bar_enable", "bar_sort"};

    @Override
    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId("bcm_bizrulealloprocess");
        fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"BizRuleListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        billList.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        String key;
        super.packageData(packageDataEvent);
        switch (key = ((ColumnDesc)packageDataEvent.getSource()).getKey()) {
            case "bizrule.listscatalog": {
                long id = packageDataEvent.getRowData().getLong("bizrule.id");
                DynamicObject rule = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_bizruleentity", (String)"id, name, number, scatalog");
                DynamicObjectCollection scenarios = rule.getDynamicObjectCollection("scatalog");
                if (scenarios.isEmpty()) break;
                StringBuilder stringBuilder = new StringBuilder();
                for (DynamicObject scenario : scenarios) {
                    if (ObjectUtils.isEmpty((Object)scenario.getDynamicObject("fbasedataid"))) continue;
                    stringBuilder.append(scenario.getDynamicObject("fbasedataid").getString("name")).append(';');
                }
                packageDataEvent.setFormatValue((Object)stringBuilder.toString());
                break;
            }
            case "bizrule.listtemplate": {
                QFBuilder qf;
                long id = packageDataEvent.getRowData().getLong("bizrule.id");
                QFilter filter = new QFilter("bizrule", "=", (Object)id);
                DynamicObjectCollection ruleCollection = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"template.id,template.group,papertemplate.id,papertemplate.group", (QFilter[])filter.toArray());
                List templateGroups = ruleCollection.stream().map(tem -> tem.getLong("template.group")).filter(groupId -> groupId != 0L).collect(Collectors.toList());
                List papertemplateGroups = ruleCollection.stream().map(tem -> tem.getLong("papertemplate.group")).filter(groupId -> groupId != 0L).collect(Collectors.toList());
                DynamicObjectCollection queryResult = null;
                if (CollectionUtils.isNotEmpty(templateGroups)) {
                    qf = new QFBuilder("model", "=", (Object)this.getModelId());
                    qf.and("group", "in", templateGroups);
                    queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,group", (QFilter[])qf.toArray(), (String)"sequence,number,versionnumber");
                } else if (CollectionUtils.isNotEmpty(papertemplateGroups)) {
                    qf = new QFBuilder("model", "=", (Object)this.getModelId());
                    qf.and("group", "in", papertemplateGroups);
                    queryResult = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name,group", (QFilter[])qf.toArray(), (String)"sequence,number,versionnumber");
                }
                if (queryResult == null || queryResult.isEmpty()) break;
                HashMap<Long, String> newNameMap = new HashMap<Long, String>(16);
                for (DynamicObject query : queryResult) {
                    newNameMap.put(query.getLong("group"), query.getString("name"));
                }
                if (ruleCollection.isEmpty() || queryResult.isEmpty()) break;
                StringBuilder stringBuilder = new StringBuilder();
                for (DynamicObject rule : ruleCollection) {
                    long group1;
                    String newName1;
                    long group = rule.getLong("template.group");
                    String newName = (String)newNameMap.get(group);
                    if (!StringUtils.isEmpty((String)newName)) {
                        stringBuilder.append(newName).append(';');
                    }
                    if (StringUtils.isEmpty((String)(newName1 = (String)newNameMap.get(group1 = rule.getLong("papertemplate.group"))))) continue;
                    stringBuilder.append(newName1).append(';');
                }
                packageDataEvent.setFormatValue((Object)stringBuilder.toString());
                break;
            }
            case "bizrule.type": {
                String type = packageDataEvent.getRowData().getString("bizrule.type");
                if (!StringUtils.isEmpty((String)type)) break;
                packageDataEvent.setFormatValue((Object)BizRuleTypeEnum.SCRIPT.getDesc());
                break;
            }
            case "bizrule.alloprocessname": {
                long ruleId = packageDataEvent.getRowData().getLong("bizrule.id");
                QFilter filter = new QFilter("bizrule", "=", (Object)ruleId);
                filter.and(new QFilter("dimension", "=", (Object)MemberReader.getDimensionIdByNum((long)this.getModelId(), (String)DimTypesEnum.PROCESS.getNumber())));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"member", (QFilter[])new QFilter[]{filter});
                if (collection.isEmpty()) break;
                List processIds = collection.stream().map(dy -> dy.getLong("member")).collect(Collectors.toList());
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                List names = processIds.stream().map(process -> MemberReader.findProcessMemberById((String)modelNum, (Long)process).getName()).collect(Collectors.toList());
                packageDataEvent.setFormatValue((Object)String.join((CharSequence)",", names));
                break;
            }
        }
    }

    @Override
    public String getModelSign() {
        return "modelbd";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    private void addListeners() {
        this.addClickListeners("btnadd", "btndel", "btnedit");
        TreeView treeView = (TreeView)this.getControl(KEY_BIZRULECATALOG);
        final BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addSearchClickListener(evt -> this.refreshList());
        billList.addPagerClickListener(pagerClickEvent -> this.refreshList());
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                BizRuleListPlugin.this.getPageCache().put(BizRuleListPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                billList.clearSelection();
                BizRuleListPlugin.this.refreshList();
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            return;
        }
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam(modelCacheKey);
        if (StringUtils.isEmpty((String)modelId) || "0".equals(modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "modelbd");
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
        }
        if (StringUtils.isEmpty((String)modelId) || "0".equals(modelId)) {
            BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return;
        }
        this.getModel().setValue("modelbd", (Object)modelId);
        this.modelChange(modelId);
    }

    private void modelChange(String modelId) {
        this.getPageCache().put(modelCacheKey, modelId);
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.setFilterParameter(fp);
        billList.clearSelection();
        this.refreshTree();
        this.refreshList();
    }

    @Override
    public void refreshList() {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        billList.refresh();
    }

    private void queryAllChildNodeList(String nodeId, List<Map<String, String>> treeList, List<String> allChildNodeList) {
        for (Map<String, String> map : treeList) {
            if (!map.get("parentid").equals(nodeId)) continue;
            allChildNodeList.add(map.get("id"));
            this.queryAllChildNodeList(map.get("id"), treeList, allChildNodeList);
        }
    }

    private void queryAllChildNodeListByIsleaf(String nodeId, List<Map<String, String>> treeList, List<String> allChildNodeList) {
        for (Map<String, String> map : treeList) {
            if (!map.get("parentid").equals(nodeId)) continue;
            if (Boolean.parseBoolean(map.get("isleaf"))) {
                allChildNodeList.add(map.get("id"));
                return;
            }
            this.queryAllChildNodeList(map.get("id"), treeList, allChildNodeList);
        }
    }

    private void refreshTree() {
        TreeView tree = (TreeView)this.getControl(KEY_BIZRULECATALOG);
        tree.deleteAllNodes();
        this.initTree();
    }

    private void refreshTree4Click() {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        this.refreshTree();
        if ((this.isCM() || this.isRPT()) && StringUtils.isNotEmpty((String)nodeId)) {
            this.getPageCache().put(FOCUS_NODE_ID, nodeId);
            TreeView tree = (TreeView)this.getControl(KEY_BIZRULECATALOG);
            tree.treeNodeClick("", nodeId);
            TreeNode bizrulecatalog = new TreeNode("", nodeId, "");
            tree.focusNode(bizrulecatalog);
        }
    }

    private void initTree() {
        TreeNode bizrulecatalog = new TreeNode();
        long modelid = Long.parseLong(this.getPageCache().get(modelCacheKey));
        String selectFields = "id,name,number,parent,isleaf,isbizrule";
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection processObjs = QueryServiceHelper.query((String)"bcm_processmembertree", (String)selectFields, (QFilter[])modelFilter.toArray(), (String)"dseq");
        processObjs.removeIf(processObj -> !processObj.getBoolean("isbizrule") && processObj.getBoolean("isleaf"));
        HashMap<String, String> canAddBizRuleCatalogMap = new HashMap<String, String>(16);
        List<Map<String, String>> tmpList = processObjs.stream().map(dynamicObject -> {
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            memberMap.put("id", dynamicObject.getString("id"));
            memberMap.put("number", dynamicObject.getString("number"));
            memberMap.put("name", sb.append(dynamicObject.getString("name")).append("(").append(dynamicObject.getString("number")).append(")").toString());
            memberMap.put("parentid", dynamicObject.getString("parent"));
            memberMap.put("isleaf", dynamicObject.getString("isleaf"));
            return memberMap;
        }).collect(Collectors.toList());
        ArrayList<String> notContains = new ArrayList<String>();
        for (DynamicObject dynamicObject2 : processObjs) {
            String number = dynamicObject2.getString("number");
            String id = dynamicObject2.getString("id");
            boolean isleaf = dynamicObject2.getBoolean("isleaf");
            if (Arrays.asList("TCF", "BPNone", "TARPT", "DIF").contains(number)) {
                this.queryAllChildNodeList(id, tmpList, notContains);
                notContains.add(id);
                continue;
            }
            if (isleaf) continue;
            ArrayList<String> tmpNoChildNodeList = new ArrayList<String>(16);
            this.queryAllChildNodeListByIsleaf(id, tmpList, tmpNoChildNodeList);
            if (!tmpNoChildNodeList.isEmpty()) continue;
            notContains.add(id);
        }
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(10);
        HashMap<String, String> memberByCommonLibMap = new HashMap<String, String>(4);
        memberByCommonLibMap.put("id", "-1");
        memberByCommonLibMap.put("number", "commonlib");
        memberByCommonLibMap.put("name", ResManager.loadKDString((String)"\u516c\u5171\u5e93(None)", (String)"BizRuleListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        memberByCommonLibMap.put("parentid", "0");
        treeList.add(memberByCommonLibMap);
        for (DynamicObject dynamicObject3 : processObjs) {
            StringBuilder sb = new StringBuilder();
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            String nodeId = dynamicObject3.getString("id");
            if (notContains.contains(nodeId)) continue;
            memberMap.put("id", dynamicObject3.getString("id"));
            memberMap.put("number", dynamicObject3.getString("number"));
            memberMap.put("name", sb.append(dynamicObject3.getString("name")).append("(").append(dynamicObject3.getString("number")).append(")").toString());
            memberMap.put("parentid", dynamicObject3.getString("parent"));
            if (this.isRPT() && BizRuleConstant.RPT_PROCESS.contains(dynamicObject3.getString("number")) || !this.isRPT()) {
                treeList.add(memberMap);
            }
            if ("0".equals(dynamicObject3.get("parent").toString())) {
                bizrulecatalog.setId("0");
                this.getPageCache().put(FOCUS_NODE_ID, "0");
                this.getPageCache().put("rootnodeid", "0");
                continue;
            }
            if (!CAN_ADD_BIZRULE_CATALOG_SET.contains(dynamicObject3.getString("number"))) continue;
            canAddBizRuleCatalogMap.put(dynamicObject3.getString("number"), dynamicObject3.getString("id"));
        }
        if (!this.isRPT()) {
            this.addRuleExecuteTypeCatalog(treeList);
        }
        bizrulecatalog.setParentid("");
        bizrulecatalog.setText(ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7c7b", (String)"BizRuleListPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getPageCache().put(can_add_biz_rule_catalog_map, JSON.toJSONString(canAddBizRuleCatalogMap));
        if (!treeList.isEmpty()) {
            this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        }
        BCMTreeUtils.setEntryNode((TreeNode)bizrulecatalog, treeList, (String)"0");
        BCMTreeUtils.spreadAllNode((TreeNode)bizrulecatalog);
        TreeView tree = (TreeView)this.getControl(KEY_BIZRULECATALOG);
        tree.addNode(bizrulecatalog);
        tree.focusNode(bizrulecatalog);
    }

    private void addRuleExecuteTypeCatalog(List<Map<String, String>> treeList) {
        HashMap<String, String> mountedNode = new HashMap<String, String>(4);
        mountedNode.put("id", "-2");
        mountedNode.put("number", "mounted");
        mountedNode.put("name", ResManager.loadKDString((String)"\u6302\u8f7d\u5f0f", (String)"BizRuleListPlugin_56", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        mountedNode.put("parentid", "0");
        mountedNode.put("isleaf", "0");
        treeList.add(mountedNode);
        for (BizRuleExecuteTypeEnum executeType : BizRuleConstant.EXECUTE_TYPES) {
            HashMap<String, String> node = new HashMap<String, String>(4);
            node.put("id", executeType.getCode());
            node.put("number", executeType.getShowNumber());
            node.put("name", executeType.getDescription());
            node.put("parentid", "-2");
            node.put("isleaf", "1");
            treeList.add(node);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (name = e.getProperty().getName()) {
            case "treecheckbox": {
                this.refreshList();
                break;
            }
            case "modelbd": {
                String modelId = UserSelectUtil.getF7SelectId(this.getView(), "modelbd");
                if (modelId == null) {
                    this.getModel().setValue("modelbd", (Object)this.getPageCache().get(modelCacheKey));
                    break;
                }
                if (modelId.equals(this.getPageCache().get(modelCacheKey))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                this.modelChange(modelId);
                break;
            }
            case "hideinvalidrule": {
                boolean flag = (Boolean)this.getModel().getValue("hideinvalidrule");
                String op = ResManager.loadKDString((String)"\u65e0\u6548\u89c4\u5219", (String)"BizRuleListPlugin_69", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                if (flag) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"moveup", "movedown"});
                    this.getPageCache().put("hideinvalidtag", "1");
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"moveup", "movedown"});
                    this.getPageCache().remove("hideinvalidtag");
                }
                this.refreshList();
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        ArrayList idList = new ArrayList(10);
        billList.getSelectedRows().forEach(e -> idList.add(e.getPrimaryKeyValue()));
        this.getPageCache().put(billlist_selected_idlist, ObjectSerialUtil.toByteSerialized(idList));
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (!this.validator()) {
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("modelbd");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BizRuleListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        String modelId = this.getPageCache().get(modelCacheKey);
        switch (key) {
            case "bar_add": {
                FormShowParameter formShowParameter = new FormShowParameter();
                List mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
                String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
                if (this.getIsCommon() || mountedNode.contains(nodeId)) {
                    this.addBizRule("bcm_bizruleentity", BizRuleTypeEnum.SCRIPT.getType());
                    break;
                }
                formShowParameter.setFormId("bcm_ruleconfigtype");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_ruleconfigtype"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "bar_copy": {
                this.copyBizrule(billList);
                break;
            }
            case "bar_delete": {
                if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%s\u6761\uff0c\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"BizRuleListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), billList.getSelectedRows().size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETEBIZRULE_COMFIRM, (IFormPlugin)this));
                break;
            }
            case "bar_commit": {
                this.commitBizRule();
                this.refreshList();
                break;
            }
            case "bar_enable": 
            case "bar_disable": {
                boolean isEnable = "bar_enable".equals(key);
                if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
                    if (!isEnable) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BizRuleListPlugin_52", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                ArrayList<Object> idList = new ArrayList<Object>(10);
                billList.getSelectedRows().forEach(e -> idList.add(e.getPrimaryKeyValue()));
                if (this.isChange(idList, isEnable)) {
                    BizRuleHelper.updateCalculateStatus(modelId);
                }
                this.updateBizRuleStatus(this.getRuleIdByRuleProcessId(idList), isEnable);
                QFilter qcf = new QFilter("id", "in", idList);
                DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"bizrule.name,bizrule.number", (QFilter[])new QFilter[]{qcf});
                if (isEnable) {
                    for (int i = 0; i < data.size(); ++i) {
                        this.writeOperationLog(BizRuleConstant.getOperationEnable(), ((DynamicObject)data.get(i)).getString("bizrule.number"), ((DynamicObject)data.get(i)).getString("bizrule.name"), BizRuleConstant.getOperationStatusSuccess());
                    }
                } else {
                    for (int i = 0; i < data.size(); ++i) {
                        this.writeOperationLog(BizRuleConstant.getOperationDisable(), ((DynamicObject)data.get(i)).getString("bizrule.number"), ((DynamicObject)data.get(i)).getString("bizrule.name"), BizRuleConstant.getOperationStatusSuccess());
                    }
                }
                this.refreshList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BizRuleListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_allocate": {
                this.showAllocateForm();
                break;
            }
            case "bar_executeinfo": {
                this.showExecInfoForm(key);
                break;
            }
            case "bar_refresh": {
                this.refreshTree4Click();
                billList.clearSelection();
                this.refreshList();
                break;
            }
            case "bar_import": {
                this.showImportView(model, key);
                break;
            }
            case "bar_export": 
            case "bar_export_part": {
                this.exportRule(model, key);
                break;
            }
            case "bar_sort": {
                this.bizRuleSort();
                break;
            }
            case "bar_retrieval": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_bizruleentitretrieva");
                showParameter.setCustomParam(modelCacheKey, (Object)modelId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPageId(this.getPageId(key));
                this.getView().showForm(showParameter);
                this.writeOperationLog(ResManager.loadKDString((String)"\u67e5\u770b\u89c4\u5219\u68c0\u7d22", (String)"BizRuleListPlugin_55", (String)"fi-bcm-formplugin", (Object[])new Object[0]), BizRuleConstant.getOperationStatusSuccess());
                break;
            }
            case "bar_help": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bcm_rulehelperguide");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPageId(this.getPageId(key));
                this.getView().showForm(showParameter);
                this.writeOperationLog(ResManager.loadKDString((String)"\u67e5\u770b\u5e2e\u52a9\u624b\u518c", (String)"BizRuleListPlugin_68", (String)"fi-bcm-formplugin", (Object[])new Object[0]), BizRuleConstant.getOperationStatusSuccess());
                break;
            }
            case "bar_upgrade": {
                ThreadPoolService.runRulesAsyncThread(() -> BizRuleUtil.updateBizRuleInternalId(null));
                break;
            }
        }
    }

    private void exportRule(DynamicObject model, String key) {
        String errMsg;
        if (bar_export.equals(key)) {
            errMsg = BizRuleExportHelper.exportBizRule(this.getClientViewProxy(), model.getLong("id"), model.getString("shownumber"), this.getUserId(), Collections.emptyList());
        } else {
            BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
            ArrayList<Object> idList = new ArrayList<Object>(10);
            billList.getSelectedRows().forEach(e -> idList.add(e.getPrimaryKeyValue()));
            if (idList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_71", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            errMsg = BizRuleExportHelper.exportBizRule(this.getClientViewProxy(), model.getLong("id"), model.getString("shownumber"), this.getUserId(), idList);
        }
        if (errMsg != null) {
            this.writeMultiLangLog(BizRuleConstant.getOperationExport(), BizRuleConstant.getOperationExportFail());
            this.getView().showErrorNotification(errMsg);
        } else {
            this.writeMultiLangLog(BizRuleConstant.getOperationExport(), BizRuleConstant.getOperationExportSuccess());
        }
    }

    private void copyBizrule(BillList billList) {
        if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_62", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] selectIds = billList.getSelectedRows().getPrimaryKeyValues();
        Set bizruleIds = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"bizrule.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectIds)}).stream().map(dyn -> dyn.getLong("bizrule.id")).collect(Collectors.toSet());
        DynamicObject[] bizRules = BusinessDataServiceHelper.load((Object[])bizruleIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleentityconfig").getDynamicObjectType());
        if (bizRules != null && bizRules.length > 0) {
            DynamicObject[] bizruleProcess = BusinessDataServiceHelper.load((String)"bcm_bizrulealloprocess", (String)"bizrule.id,dimension.id,member,execsort,model.id", (QFilter[])new QFilter[]{new QFilter("bizrule.id", "in", bizruleIds)}, (String)"bizrule.id, member");
            HashMap<Long, ArrayList> biz2ProcessMap = new HashMap<Long, ArrayList>(bizruleIds.size());
            for (Long id : bizruleIds) {
                ArrayList collect = (ArrayList)Arrays.stream(bizruleProcess).filter(p -> p.getLong("bizrule.id") == id.longValue()).collect(Collectors.toList());
                biz2ProcessMap.put(id, collect);
            }
            DynamicObject[] bizAllocates = BusinessDataServiceHelper.load((String)"bcm_brallocateentity", (String)"template.id,papertemplate.id,bizrule.id,dimension.id,model.id,execseq,execwhenopen,execwhensave,creator,createdate,modifier,modifydate", (QFilter[])new QFilter[]{new QFilter("bizrule.id", "in", bizruleIds)});
            HashMap<Long, ArrayList> biz2AllocateMap = new HashMap<Long, ArrayList>(bizruleIds.size());
            for (Long id : bizruleIds) {
                ArrayList collect = (ArrayList)Arrays.stream(bizAllocates).filter(p -> p.getLong("bizrule.id") == id.longValue()).collect(Collectors.toList());
                biz2AllocateMap.put(id, collect);
            }
            ArrayList<DynamicObject> copyBizrules = new ArrayList<DynamicObject>(bizRules.length);
            ArrayList<DynamicObject> copyBizBps = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> copyBizAllocates = new ArrayList<DynamicObject>(10);
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            for (DynamicObject bizrule : bizRules) {
                DynamicObject copyBizrule = (DynamicObject)OrmUtils.clone((IDataEntityBase)bizrule, (boolean)false, (boolean)true);
                long copyBizruleId = DBServiceHelper.genGlobalLongId();
                copyBizrule.set("id", (Object)copyBizruleId);
                String suffix = CreateCopyNameUtil.getCopyNumberOrNameSuffix((String)"number", (String)bizrule.getString("number"), (String)"copy", (String)"bcm_bizruleentity", (QFBuilder)new QFBuilder("model", "=", (Object)this.getModelId()));
                copyBizrule.set("number", (Object)(bizrule.getString("number") + suffix));
                copyBizrule.set("name", (Object)(bizrule.getString("name") + suffix));
                copyBizrule.set("content", null);
                copyBizrule.set("executeseq", (Object)(bizrule.getInt("executeseq") + 1));
                copyBizrule.set("runstatus", (Object)BizRuleRunStatusEnum.ADDED.getIndex());
                copyBizrule.set("createtime", (Object)TimeServiceHelper.now());
                copyBizrule.set("modifytime", (Object)TimeServiceHelper.now());
                copyBizrule.set("creator", (Object)RequestContext.get().getUserId());
                copyBizrule.set("modifier", (Object)RequestContext.get().getUserId());
                copyBizrules.add(copyBizrule);
                ArrayList process = (ArrayList)biz2ProcessMap.get(bizrule.getLong("id"));
                StringJoiner stringJoiner = new StringJoiner(",");
                if (CollectionUtils.isNotEmpty((Collection)process)) {
                    for (DynamicObject bizBp : process) {
                        DynamicObject copyBizBp = BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizrulealloprocess");
                        DynamicObjectUtils.copy((DynamicObject)bizBp, (DynamicObject)copyBizBp);
                        copyBizBp.set("bizrule", (Object)copyBizrule);
                        copyBizBp.set("execsort", (Object)(copyBizBp.getInt("execsort") + 1));
                        copyBizBps.add(copyBizBp);
                        stringJoiner.add(MemberReader.findProcessMemberById((String)modelNumber, (Long)bizBp.getLong("member")).getName());
                    }
                }
                if (BizRuleTypeEnum.CONFIG.getType().equals(bizrule.getString("type"))) {
                    copyBizrule.set("alloprocessname", (Object)stringJoiner.toString());
                    copyBizrule.set("debug", (Object)BizRuleConfigFormulaHelper.buildScript(copyBizrule));
                }
                stringJoiner.setEmptyValue("");
                ArrayList allocates = (ArrayList)biz2AllocateMap.get(bizrule.getLong("id"));
                if (!CollectionUtils.isNotEmpty((Collection)allocates)) continue;
                for (DynamicObject allocate : allocates) {
                    DynamicObject copyAllocate = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brallocateentity");
                    DynamicObjectUtils.copy((DynamicObject)allocate, (DynamicObject)copyAllocate);
                    copyAllocate.set("bizrule", (Object)copyBizrule);
                    copyBizAllocates.add(copyAllocate);
                }
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])copyBizrules.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])copyBizBps.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])copyBizAllocates.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    for (DynamicObject biz : bizRules) {
                        this.writeOperationLog(BizRuleConstant.getOperationCopy().getDescription(), biz.getString("number"), biz.getString("name"), BizRuleConstant.getOperationStatusFail());
                    }
                    log.error("Bizrule copy fail: ", (Throwable)e);
                    tx.markRollback();
                    throw new KDBizException(ResManager.loadKDString((String)"\u590d\u5236\u89c4\u5219\u5931\u8d25\u3002", (String)"BizRuleListPlugin_63", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                for (DynamicObject biz : bizRules) {
                    this.writeOperationLog(BizRuleConstant.getOperationCopy().getDescription(), biz.getString("number"), biz.getString("name"), BizRuleConstant.getOperationStatusSuccess());
                }
            }
            billList.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"BizRuleListPlugin_64", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getPageId(String key) {
        return this.getView().getPageId() + key + this.getModelId();
    }

    private void showImportView(DynamicObject model, String key) {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_bizruleimport");
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        formparam.setStatus(OperationStatus.ADDNEW);
        formparam.setCustomParam("modelId", (Object)model.getLong("id"));
        formparam.setCustomParam("modelNum", (Object)model.getString("shownumber"));
        formparam.setCustomParam("userId", (Object)this.getUserId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        formparam.setCloseCallBack(closeCallBack);
        this.getView().showForm(formparam);
    }

    public boolean isChange(List<Object> idList, boolean isEnable) {
        Object[] objs = this.getBizRuleEntitys(idList);
        if (ArrayUtils.isEmpty((Object[])objs)) {
            return false;
        }
        for (Object obj : objs) {
            Integer status = obj.getInt("status");
            boolean think = StringUtils.isNotEmpty((String)obj.getString("content"));
            if ((status != 1 || isEnable) && (status != 2 || !isEnable) || !think) continue;
            return true;
        }
        return false;
    }

    public boolean isChange(List<Object> idList) {
        Object[] objs = this.getBizRuleEntitys(idList);
        if (ArrayUtils.isEmpty((Object[])objs)) {
            return false;
        }
        for (Object obj : objs) {
            Integer status = obj.getInt("status");
            if (status != 1) continue;
            return true;
        }
        return false;
    }

    public DynamicObject[] getBizRuleEntitys(List<Object> idList) {
        QFilter filter = new QFilter("id", "in", (Object)this.getRuleIdByRuleProcessId(idList).toArray());
        return BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)"id,status,runstatus,content", (QFilter[])new QFilter[]{filter});
    }

    private void bizRuleSort() {
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        ListSelectedRowCollection ls = billList.getCurrentListAllRowCollection();
        if (ls == null || ls.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u89c4\u5219\u9700\u8981\u6392\u5e8f\u3002", (String)"BizRuleListPlugin_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizrulesort"));
        formShowParameter.setCustomParam("processid", (Object)nodeId);
        formShowParameter.setCustomParam("model", (Object)this.getModelId());
        formShowParameter.setFormId("bcm_bizrulesort");
        this.getView().showForm(formShowParameter);
    }

    private void commitBizRule() {
        if (this.checkSelection(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]))) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u8c03\u8bd5\u7248\u5185\u5bb9\u5c06\u4f1a\u8986\u76d6\u5230\u8fd0\u884c\u7248\uff0c\u786e\u5b9a\u63d0\u4ea4\uff1f", (String)"BizRuleListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(commitbizrule_comfirm, (IFormPlugin)this));
    }

    private void commitBizRule(String modelId) {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        ArrayList<Object> ids = new ArrayList<Object>(10);
        billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
        DynamicObject[] array = BusinessDataServiceHelper.load((Object[])this.getRuleIdByRuleProcessId(ids).toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_bizruleentityconfig").getDynamicObjectType());
        if (array != null && array.length > 0) {
            for (DynamicObject rule : array) {
                rule.set("content", rule.get("debug"));
                rule.set("modifier", (Object)RequestContext.get().getUserId());
                rule.set("modifytime", (Object)TimeServiceHelper.getTimeStamp());
                if (BizRuleTypeEnum.CONFIG.getType().equals(rule.getString("type")) && BizRuleRunStatusEnum.COMMITED.getIndex() != rule.getInt("runstatus")) {
                    DynamicObjectCollection ruleLogics = rule.getDynamicObjectCollection("entryentity");
                    ruleLogics.removeIf(BizRuleHelper::isDelete);
                    ruleLogics.forEach(ruleLogic -> {
                        ruleLogic.set("isdelete", (Object)BizRuleLogicStatusEnum.VALID.getStatus());
                        ruleLogic.set("logic_commitexpr", (Object)BizRuleExportHelper.getRuleInfoBean(ruleLogic));
                    });
                }
                rule.set("runstatus", (Object)BizRuleRunStatusEnum.COMMITED.getIndex());
            }
            SaveServiceHelper.save((DynamicObject[])array);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BizRuleListPlugin_67", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        billList.clearSelection();
    }

    private boolean checkSelection(String tips) {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void setFilter(SetFilterEvent e) {
        Set<Long> ids;
        super.setFilter(e);
        String nodeId = this.getPageCache().get(FOCUS_NODE_ID);
        String tag = this.getPageCache().get("hideinvalidtag");
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        List<String> mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
        if ("1".equals(tag)) {
            QFilter tagFilter = new QFilter("bizrule.status", "=", (Object)"1");
            tagFilter.and("bizrule.content", "is not null", null);
            e.getQFilters().add(tagFilter);
        }
        if ("-1".equals(nodeId)) {
            QFilter filter0 = new QFilter("member", "=", (Object)-1);
            e.getQFilters().add(filter0);
            this.getView().setVisible(Boolean.TRUE, HIDDEN_BUTTONS);
        } else if ("-2".equals(nodeId)) {
            ids = this.getIds(mountedNode);
            e.getQFilters().add(new QFilter("id", "in", ids));
            this.getView().setVisible(Boolean.FALSE, HIDDEN_BUTTONS);
        } else if (mountedNode.contains(nodeId)) {
            ids = this.getIds(Collections.singletonList(nodeId));
            e.getQFilters().add(new QFilter("id", "in", ids));
            this.getView().setVisible(Boolean.TRUE, HIDDEN_BUTTONS);
        } else {
            IDNumberTreeNode process;
            String str = this.getPageCache().get("treelist");
            if (str == null) {
                e.getQFilters().add(new QFilter("1", "!=", (Object)1));
                return;
            }
            ArrayList nodeids = Lists.newArrayList();
            nodeids.add(nodeId);
            List collect = nodeids.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter qFilter1 = new QFilter("member", "in", collect);
            List treeList = (List)SerializationUtils.fromJsonString((String)str, List.class);
            ArrayList<String> list = new ArrayList<String>(10);
            this.queryAllChildNodeList(nodeId, treeList, list);
            if (!list.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, HIDDEN_BUTTONS);
                e.getQFilters().add(new QFilter("1", "!=", (Object)1));
                return;
            }
            boolean isEdit = true;
            if (!(!this.isRPT() || "EIRpt".equals((process = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_processmembertree", (Long)Long.parseLong(nodeId))).getNumber()) || "ERAdj".equals(process.getNumber()) || "IRpt".equals(process.getNumber()) || "RAdj".equals(process.getNumber()))) {
                isEdit = false;
            }
            this.getView().setVisible(Boolean.valueOf(isEdit), new String[]{"bar_add", "bar_delete", "bar_commit", "bar_enable", "bar_sort"});
            e.getQFilters().add(qFilter1);
            e.getQFilters().add(new QFilter("bizrule.executetype", "in", Arrays.asList(BizRuleExecuteTypeEnum.ALL.getCode(), BizRuleExecuteTypeEnum.RPT_ONLY.getCode(), BizRuleExecuteTypeEnum.EXTCONV_ONLY.getCode(), BizRuleExecuteTypeEnum.ADJEJE_ONLY.getCode())));
        }
        QFilter filter = new QFilter("bizrule.deletestatus", "=", (Object)false);
        filter.and(modelFilter);
        e.getQFilters().add(filter);
        e.setOrderBy("execsort");
    }

    private Set<Long> getIds(List<String> mountedNode) {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        modelFilter.and(new QFilter("bizrule.executetype", "in", mountedNode));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"id,bizrule.number", (QFilter[])modelFilter.toArray());
        HashSet<String> nums = new HashSet<String>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject object : query) {
            if (nums.contains(object.getString("bizrule.number"))) continue;
            ids.add(object.getLong("id"));
            nums.add(object.getString("bizrule.number"));
        }
        return ids;
    }

    private void showExecInfoForm(String key) {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getPageId(key);
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bcm_brexecuteinfo");
            param.setBillFormId("bcm_brexecuteinfoentity");
            param.setCustomParam("modelid", (Object)this.getPageCache().get(modelCacheKey));
            param.setPageId(pageId);
            IFormView pageView = this.getView().getParentView();
            if (pageView != null) {
                param.setParentPageId(this.getView().getParentView().getPageId());
            }
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String exeInfo = ResManager.loadKDString((String)"\u6267\u884c\u60c5\u51b5", (String)"BizRuleListPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            param.setCaption(exeInfo);
            this.getView().showForm((FormShowParameter)param);
            this.writeOperationLog(BizRuleConstant.getOperationView() + exeInfo, BizRuleConstant.getOperationStatusSuccess());
        } else {
            IFormView pageView = mainPageView.getView(pageId);
            pageView.activate();
            this.getView().sendFormAction(pageView);
        }
    }

    private void showAllocateForm() {
        FormShowParameter param = new FormShowParameter();
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String modelId = this.getPageCache().get(modelCacheKey);
        String pageId = "ruleAllocate" + modelId + this.getView().getPageId();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            param.setFormId(allocate_formid);
            param.setCustomParam("modelid", (Object)modelId);
            param.setPageId(pageId);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5206\u914d", (String)"BizRuleListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            if (parentView == null) {
                this.getView().showForm(param);
            } else {
                parentView.showForm(param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    private DynamicObject[] updateBizRule(List<Object> idList) {
        Object[] entitys = BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)"number,name,content,status,deletestatus,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList.toArray())});
        Arrays.stream(entitys).filter(e -> "1".equals(e.getString("status")) && StringUtils.isNotEmpty((String)e.getString("content"))).findFirst().ifPresent(ru -> BizRuleHelper.updateCalculateStatus(String.valueOf(this.getModelId())));
        if (entitys.length > 0) {
            DeleteServiceHelper.delete((IDataEntityType)entitys[0].getDynamicObjectType(), (Object[])entitys);
        }
        return entitys;
    }

    private void updateBizRuleStatus(List<Object> idList, boolean isEnable) {
        HashMap<String, Object> saveInfo = new HashMap<String, Object>(16);
        saveInfo.put("status", isEnable ? 1 : 2);
        saveInfo.put("modifier", RequestContext.get().getUserId());
        saveInfo.put("modifytime", TimeServiceHelper.getTimeStamp());
        QFilter filter = new QFilter("id", "in", (Object)idList.toArray());
        String properties = saveInfo.keySet().toString().substring(1, saveInfo.keySet().toString().length() - 1);
        Object[] entitys = BusinessDataServiceHelper.load((String)"bcm_bizruleentity", (String)properties, (QFilter[])new QFilter[]{filter});
        if (entitys.length > 0) {
            for (DynamicObject dynamicObject : entitys) {
                for (Map.Entry entry : saveInfo.entrySet()) {
                    dynamicObject.set((String)entry.getKey(), entry.getValue());
                }
            }
            BusinessDataServiceHelper.save((IDataEntityType)entitys[0].getDynamicObjectType(), (Object[])entitys);
        }
    }

    @Override
    public String getBizEntityNumber() {
        return "bcm_bizrulealloprocess";
    }

    private void addBizRule(String formId, String type) {
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        String rootNodeId = this.getPageCache().get("rootnodeid");
        if (focusNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u6240\u5c5e\u7684\u5206\u7c7b\u3002", (String)"BizRuleListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.isRPT() && rootNodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u6b64\u5206\u7c7b\u4e0a\u521b\u5efa\u4e1a\u52a1\u89c4\u5219\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5206\u7c7b\u540e\u91cd\u8bd5\u3002", (String)"BizRuleListPlugin_49", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject catalog = new JSONObject();
        long normalId = this.getNormalProcessCatalogId();
        long iRptId = this.getIrptProcessCatalogId();
        if (this.isRPT()) {
            catalog.put("id", (Object)normalId);
            catalog.put("processcatalog", (Object)normalId);
        } else {
            catalog.put("id", (Object)iRptId);
            catalog.put("processcatalog", (Object)iRptId);
        }
        catalog.put("scatalog", (Object)focusNodeId);
        BillShowParameter formShowParameter = new BillShowParameter();
        if ("-1".equals(focusNodeId)) {
            formShowParameter.setCustomParam("iscommon", (Object)true);
        } else {
            formShowParameter.setCustomParam("iscommon", (Object)false);
        }
        formShowParameter.setCustomParam("nodeId", (Object)focusNodeId);
        formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219-%s", (String)"BizRuleListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), BizRuleTypeEnum.getEnumByType((String)type).getDesc()));
        formShowParameter.setCustomParam(modelCacheKey, (Object)this.getPageCache().get(modelCacheKey));
        formShowParameter.setCustomParam("catalog", (Object)catalog.toJSONString());
        formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
        formShowParameter.setCustomParam("addFlag", (Object)"1");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private long getIrptProcessCatalogId() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("number", "=", (Object)BizRuleCatalogEnum.IRpt.getNumber());
        return QueryServiceHelper.queryOne((String)"bcm_bizrulecatalog", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
    }

    private long getNormalProcessCatalogId() {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("number", "=", (Object)BizRuleCatalogEnum.Normal.getNumber());
        return QueryServiceHelper.queryOne((String)"bcm_bizrulecatalog", (String)"id", (QFilter[])new QFilter[]{filter}).getLong("id");
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        BillList billList;
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (DELETEBIZRULE_COMFIRM.equals(callBackId)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                DynamicObject[] deleteRules;
                billList = (BillList)this.getControl(KEY_BILLLISTAP);
                ArrayList<Object> ids = new ArrayList<Object>(10);
                billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
                List<Object> ruleIds = this.getRuleIdByRuleProcessId(ids);
                QFilter filter = new QFilter("bizrule", "in", ruleIds);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"id, template, bizrule", (QFilter[])new QFilter[]{filter});
                TreeSet templateIdSet = new TreeSet();
                collection.forEach(e -> templateIdSet.add(e.getLong("template")));
                for (DynamicObject rule : deleteRules = this.updateBizRule(ruleIds)) {
                    this.writeOperationLog(BizRuleConstant.getOperationDel().getDescription(), rule.getString("number"), rule.getString("name"), BizRuleConstant.getOperationStatusSuccess());
                }
                QFilter filter1 = new QFilter("bizrule", "in", ruleIds);
                BusinessDataWriter.delete((String)"bcm_brallocateentity", (QFilter[])new QFilter[]{filter1});
                BusinessDataWriter.delete((String)"bcm_brexecuteinfoentity", (QFilter[])new QFilter[]{filter1});
                BusinessDataWriter.delete((String)"bcm_bizrulealloprocess", (QFilter[])new QFilter[]{filter1});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BizRuleListPlugin_50", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshList();
                billList.clearSelection();
            }
        } else if (commitbizrule_comfirm.equals(callBackId) && mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
            billList = (BillList)this.getControl(KEY_BILLLISTAP);
            ArrayList<Object> ids = new ArrayList<Object>(10);
            billList.getSelectedRows().forEach(e -> ids.add(e.getPrimaryKeyValue()));
            QFilter qcf = new QFilter("id", "in", ids);
            DynamicObjectCollection data = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"bizrule.name,bizrule.number", (QFilter[])new QFilter[]{qcf});
            for (int i = 0; i < data.size(); ++i) {
                this.writeOperationLog(BizRuleConstant.getOperationSubmit(), ((DynamicObject)data.get(i)).getString("bizrule.number"), ((DynamicObject)data.get(i)).getString("bizrule.name"), BizRuleConstant.getOperationStatusSuccess());
            }
            String modelId = this.getPageCache().get(modelCacheKey);
            boolean changeFlag = this.isChange(ids);
            if (changeFlag) {
                BizRuleHelper.updateCalculateStatus(modelId);
            }
            this.commitBizRule(modelId);
            this.refreshList();
        }
        if (callBackId.startsWith("editbizrule|") && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            String[] split = callBackId.split("\\|", 4);
            if (split.length != 4) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u770b\u64cd\u4f5c\u65e5\u5fd7\u3002", (String)"BizRuleListPlugin_70", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.writeOperationLog(BizRuleConstant.getOperationView(), callBackId, "", BizRuleConstant.getOperationStatusFail());
            } else {
                this.editBizRule(split[1], split[2], split[3], true);
            }
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        BillList list = (BillList)evt.getSource();
        if (!list.getSelectedRows().isEmpty()) {
            DynamicObject dynamicObject = list.getModel().loadReferenceData((DynamicObjectType)list.getEntityType(), list.getFocusRowPkId());
            String id = dynamicObject.get("bizrule.id").toString();
            String name = dynamicObject.get("bizrule.name").toString();
            String type = dynamicObject.get("bizrule.type").toString();
            this.editBizRule(id, name, type);
        }
        evt.setCancel(true);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        DynamicObject row = BillListHyperLinkClickUtil.getDynamicObjectFromEvt(args, "bizrule.id,bizrule.name,bizrule.number,bizrule.type");
        if (row == null) {
            throw new KDBizException(FiBcmErrorCode.create((String)"fi.bcm.dataNotExist"), new Object[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219", (String)"BizRuleListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])});
        }
        String bizRuleId = row.getString("bizrule.id");
        String bizRuleName = row.getString("bizrule.name");
        String bizRuleNumber = row.getString("bizrule.number");
        String type = row.getString("bizrule.type");
        try {
            Map lockInfo;
            boolean lock = MutexServiceHelper.request((String)bizRuleId, (String)"bcm_bizruleentity", (String)BizRuleConstant.getOperationEdit());
            if (!lock && (lockInfo = MutexServiceHelper.getLockInfo((String)bizRuleId, (String)"bcm_bizruleentity", (String)BizRuleConstant.getOperationEdit())) != null && lockInfo.get("userid") != null && !((String)lockInfo.get("userid")).equals(RequestContext.getOrCreate().getUserId())) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u88ab%2$s\u9501\u5b9a\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002\u662f\u5426\u7ee7\u7eed\u67e5\u770b\uff1f", (String)"BizRuleListPlugin_66", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bizRuleNumber, UserServiceHelper.getUsernameByUserid(lockInfo.get("userid"))), MessageBoxOptions.YesNo, new ConfirmCallBackListener(String.format("%s|%s|%s|%s", EDIT_BIZRULE, bizRuleId, bizRuleName, type), (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
        }
        catch (Exception e) {
            log.error("request lock error!", (Throwable)e);
        }
        this.editBizRule(bizRuleId, bizRuleName, type);
        args.setCancel(true);
        this.writeOperationLog(BizRuleConstant.getOperationView(), bizRuleNumber, bizRuleName, BizRuleConstant.getOperationStatusSuccess());
    }

    private boolean getIsCommon() {
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        boolean isCommon = false;
        if ("-1".equals(focusNodeId)) {
            isCommon = true;
        }
        return isCommon;
    }

    private void editBizRule(String bizRuleId, String bizRuleName, String type) {
        this.editBizRule(bizRuleId, bizRuleName, type, false);
    }

    private void editBizRule(String bizRuleId, String bizRuleName, String type, boolean isOnlyRead) {
        String pageId;
        String focusNodeId = this.getPageCache().get(FOCUS_NODE_ID);
        if (focusNodeId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u6240\u5c5e\u7684\u5206\u7c7b\u3002", (String)"BizRuleListPlugin_48", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> openParameter = new HashMap<String, Object>(16);
        if ("2".equals(type)) {
            openParameter.put("formId", "bcm_bizruleentityconfig");
        } else {
            openParameter.put("formId", "bcm_bizruleentity");
        }
        openParameter.put("pkId", bizRuleId);
        openParameter.put("listPageID", this.getView().getPageId());
        openParameter.put("iscommon", this.getIsCommon());
        openParameter.put("nodeId", focusNodeId);
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        if (this.getPageCache().get(bizRuleId) != null) {
            pageId = this.getPageCache().get(bizRuleId);
            if (mainPageView != null && mainPageView.getView(pageId) != null) {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                FormShowParameter showParameter = childFormView.getFormShowParameter();
                showParameter.setPageId(pageId);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219-%s", (String)"BizRuleListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bizRuleName));
                showParameter.setCustomParam("isOnlyRead", (Object)isOnlyRead);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_bizruleentity");
                showParameter.setCloseCallBack(closeCallBack);
                if (ObjectUtils.isEmpty((Object)parentView)) {
                    this.getView().showForm(showParameter);
                    return;
                }
                parentView.showForm(showParameter);
                this.getView().sendFormAction(parentView);
                return;
            }
        }
        pageId = this.getView().getPageId() + bizRuleId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setPageId(pageId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219-%s", (String)"BizRuleListPlugin_51", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bizRuleName));
            showParameter.setCustomParam("isOnlyRead", (Object)isOnlyRead);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_bizruleentity");
            showParameter.setCloseCallBack(closeCallBack);
            if (ObjectUtils.isEmpty((Object)parentView)) {
                this.getView().showForm(showParameter);
                return;
            }
            parentView.showForm(showParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        switch (actionId = evt.getActionId()) {
            case "bcm_bizruleentity": {
                this.refreshList();
                break;
            }
            case "bizrulesort": {
                if (!"OK".equals(returnData)) break;
                this.refreshList();
                break;
            }
            case "bar_import": {
                if (!"OK".equals(returnData)) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BizRuleListPlugin_53", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshList();
                break;
            }
            case "bcm_ruleconfigtype": {
                if (BizRuleTypeEnum.CONFIG.getType().equals(returnData)) {
                    this.addBizRule("bcm_bizruleentityconfig", returnData.toString());
                    break;
                }
                if (!BizRuleTypeEnum.SCRIPT.getType().equals(returnData)) break;
                this.addBizRule("bcm_bizruleentity", returnData.toString());
                break;
            }
            default: {
                this.refreshList();
            }
        }
    }

    private List<Object> getRuleIdByRuleProcessId(List<Object> idList) {
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObject[] ruleIds = BusinessDataServiceHelper.load((String)"bcm_bizrulealloprocess", (String)"bizrule", (QFilter[])new QFilter[]{filter});
        return Stream.of(ruleIds).map(v -> v.getDynamicObject("bizrule").getPkValue()).collect(Collectors.toList());
    }
}

