/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentIfCondition;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentScope;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleIfCondition;
import kd.fi.bcm.business.bizrule.logicconfig.expression.BizRuleScope;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunction;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionRuns;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionV;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.script.CommonFormulaModel;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleLogicStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.computing.BizRuleConfigFormulaHelper;
import kd.fi.bcm.formplugin.computing.BizRuleLogicConfigBasePlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BizRuleLogicConfigCalculatePlugin
extends BizRuleLogicConfigBasePlugin
implements MainPage,
DynamicPage {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("esp", "rate");
    }

    @Override
    protected boolean btnSave() {
        if (this.checkNull()) {
            CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
            this.getPageCache().put("isActionSave", "true");
            custom.setData(BizRuleConfigFormulaHelper.packGetText());
        }
        return true;
    }

    @Override
    protected void btnExit() {
        if (this.getPageCache().get("ismodifer") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BizRuleConfigPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeBeforeSave", (IFormPlugin)this));
        } else {
            CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
            this.getPageCache().put("getNewFormudata", "true");
            custom.setData(BizRuleConfigFormulaHelper.packGetText());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("entryentity1");
        super.afterCreateNewData(e);
        this.showFromView("spreadpanel", "bcm_chksettingrpt");
        JSONObject bizruleconfig = (JSONObject)this.getFormCustomParam("bizruleconfig");
        if (bizruleconfig != null) {
            CustomControl control = (CustomControl)this.getControl("bizconfigformulatext");
            String formulaData = bizruleconfig.getString("logic_expression");
            formulaData = this.replacePeriod(formulaData, "getLastYearEnd()");
            formulaData = this.replacePeriod(formulaData, "getLastPeriod()");
            if (StringUtils.isNotEmpty((String)(formulaData = this.replacePeriod(formulaData, "FY@ctx.FY.lastYear()")))) {
                control.setData(BizRuleConfigFormulaHelper.packHyperClickText(formulaData, this.getPageCache()));
                this.getPageCache().put("oldformuldata", formulaData);
            }
        }
    }

    private String replacePeriod(String formulaData, String periodStr) {
        if (formulaData.contains(periodStr) && !formulaData.contains(BizRuleUtil.wrapQuote((String)periodStr))) {
            formulaData = formulaData.replace(periodStr, BizRuleUtil.wrapQuote((String)periodStr));
        }
        return formulaData;
    }

    private Boolean actionSave(String formula) {
        DynamicObject dyo;
        Object bizRuleId = this.getView().getFormShowParameter().getCustomParam("bizRuleId");
        if (bizRuleId != null && (dyo = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)bizRuleId), (String)"bcm_bizruleentityconfig")) != null) {
            if (!this.checkBasicInfo(dyo)) {
                return Boolean.FALSE;
            }
            String logicNumber = this.getModel().getValue("logic_number").toString();
            DynamicObjectCollection entries = dyo.getDynamicObjectCollection("entryentity");
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            String logicName = this.getModel().getValue("logic_name").toString();
            String logicLog = this.getModel().getValue("logic_log").toString();
            String logicType = this.getModel().getValue("logic_type").toString();
            DynamicObject entity = null;
            if (id == null && this.getPageCache().get("id") != null) {
                id = this.getPageCache().get("id");
            }
            if (id != null) {
                for (DynamicObject entry : entries) {
                    if (!entry.getString("id").equals(id)) continue;
                    entity = entry;
                    break;
                }
            }
            boolean isNew = false;
            if (entity == null) {
                entity = new DynamicObject(dyo.getDynamicObjectCollection("entryentity").getDynamicObjectType());
                long entityId = GlobalIdUtil.genGlobalLongId();
                this.getPageCache().put("id", String.valueOf(entityId));
                entity.set("id", (Object)entityId);
                entity.set("isdelete", (Object)BizRuleLogicStatusEnum.NEW.getStatus());
                entries.add((Object)entity);
                isNew = true;
            }
            entity.set("logic_number", (Object)logicNumber);
            entity.set("logic_name", (Object)logicName);
            entity.set("logic_log", (Object)logicLog);
            entity.set("logic_type", (Object)logicType);
            List<BizRuleIfCondition> bizRuleIfConditions = this.generateCondition();
            List<BizRuleScope> bizRuleScopes = this.generateScope();
            BizRuleComponentIfCondition bizRuleFunctionIfCondition = new BizRuleComponentIfCondition(bizRuleIfConditions);
            BizRuleComponentScope bizRuleFunctionScope = new BizRuleComponentScope(bizRuleScopes, this.getModelId());
            try {
                String jsFormula = BizRuleConfigFormulaHelper.getMaxJsFormula(formula);
                BizRuleFunctionV bizRuleFunctionV = new BizRuleFunctionV(formula, jsFormula);
                BizRuleFunctionRuns bizRuleFunctionRuns = new BizRuleFunctionRuns(logicLog, logicName, logicNumber, (BizRuleComponent)bizRuleFunctionIfCondition, (BizRuleComponent)bizRuleFunctionScope, (BizRuleFunction)bizRuleFunctionV);
                entity.set("logic_condition", (Object)bizRuleFunctionIfCondition.toString());
                entity.set("logic_scope", (Object)bizRuleFunctionScope.toString());
                entity.set("logic_expression", (Object)bizRuleFunctionV.toString());
                this.getPageCache().put("logic_expression", bizRuleFunctionV.toString());
                entity.set("logic_js", (Object)bizRuleFunctionRuns.generateJsScript());
                if (this.checkScopeRepetitive(formula).booleanValue()) {
                    this.removeCache("isActionSave");
                    return Boolean.FALSE;
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                this.removeCache("isActionSave");
                return Boolean.FALSE;
            }
            if (isNew) {
                entity.set("seq", (Object)entries.size());
            }
            if (BizRuleRunStatusEnum.COMMITED.getIndex() == dyo.getInt("runstatus")) {
                dyo.set("runstatus", (Object)BizRuleRunStatusEnum.MODIFIED.getIndex());
            }
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
                    IFormView parentView = this.getParentView();
                    parentView.invokeOperation("refresh");
                    OperationResult result = parentView.invokeOperation("save");
                    if (!result.isSuccess()) {
                        throw new KDBizException(result.getMessage());
                    }
                    if (isNew) {
                        parentView.getPageCache().put(logicNumber, this.getView().getPageId());
                    }
                    this.removeCache("isActionSave");
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.error(String.format("[%s][%s]save error!", logicNumber, logicName), (Throwable)e);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002%s", (String)"BizRuleConfigPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]), e.getMessage()));
                    Boolean bl = Boolean.FALSE;
                    if (tx != null) {
                        if (var17_20 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var17_20.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return bl;
                }
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getFormula(String text, Map<String, String> maps) {
        String formula = "";
        if (!StringUtil.isEmptyString((String)text)) {
            text = text.replaceAll("\n", "");
            if ((text = text.replaceAll("\\p{C}", "")).contains("{\"bn\"}") && !"{\"bn\"}".equals(text) || text.contains("%")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (ChkCheckServiceHelper.isNumber((String)text)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7eaf\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"InvChangeFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String str = BizRuleConfigFormulaHelper.transFormula(text, this.getPageCache());
            String formulaName = "";
            if ("@@@".equalsIgnoreCase(str)) {
                maps.put("formula", "");
                maps.put("name", "");
            } else {
                String[] fs = str.split("@@@");
                formula = fs[0];
                formulaName = fs[1];
            }
            maps.put("formula", formula);
            maps.put("name", formulaName);
        }
        return formula;
    }

    private void showFromView(String tab, String form) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(tab);
        formShowParameter.setFormId(form);
        formShowParameter.setPageId(this.getPageIdAndCache(this.getPageCache(), form));
        formShowParameter.setCustomParam("temp", (Object)this.toByteSerialized(Collections.emptyList()));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void dealMsg(CommandParam com) {
        List<Object> param;
        if ("addFormula".equals(com.getOperation())) {
            this.getPageCache(this.getView().getParentView()).put("ismodifer", Boolean.toString(true));
            String formula = com.getParam().get(0).toString();
            VFormula formulaWithoutContextDims = this.getFormula(formula, true);
            VFormula originalFormula = this.getFormula(formula, false);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            formShowParameter.setCustomParam("formula", (Object)formulaWithoutContextDims.toBizRuleFormulaString("v"));
            formShowParameter.setCustomParam("originalformula", (Object)originalFormula.toBizRuleFormulaString("v"));
            formShowParameter.setFormId("bcm_choosevtype");
            formShowParameter.setCustomParam("formula_temp", (Object)Boolean.TRUE);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "formula_temp");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
        if ("addExtendFormula".equals(com.getOperation()) && CollectionUtils.isNotEmpty(param = com.getParam()) && param.get(0) instanceof Map) {
            this.showExtendsFormula((Map)com.getParam().get(0), "addExtendFormula");
        }
    }

    private void showExtendsFormula(Map<String, Object> paramMap, String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_extendsformula");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = formShowParameter.getCustomParams();
        customParams.putAll(paramMap);
        customParams.put("KEY_MODEL_ID", this.getModelId());
        this.setExtendsModelAndField(customParams, paramMap);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(formShowParameter);
    }

    private void setExtendsModelAndField(Map<String, Object> customParams, Map<String, Object> paramMap) {
        Object extField;
        Object extModel = paramMap.get("extendsmodel");
        if (!(extModel instanceof Long)) {
            String extendsModel = String.valueOf(extModel);
            QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId()).and(new QFilter("number", "=", (Object)extendsModel));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])qFilter.toArray());
            if (dynamicObject == null) {
                customParams.put("extendsmodel", null);
                customParams.put("extendsfield", null);
                return;
            }
            long extendsModelId = dynamicObject.getLong("id");
            customParams.put("extendsmodel", extendsModelId);
        }
        if (!((extField = paramMap.get("extendsfield")) instanceof Long)) {
            String extendsField = String.valueOf(extField);
            QFilter qFilter1 = new QFilter("extmodelid", "=", customParams.get("extendsmodel")).and(new QFilter("extfield.number", "=", (Object)extendsField));
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"extfield", (QFilter[])qFilter1.toArray());
            if (dynamicObject1 == null) {
                customParams.put("extendsfield", null);
                return;
            }
            customParams.put("extendsfield", dynamicObject1.getLong("extfield"));
        }
    }

    private VFormula getFormula(String formula, boolean excludeContextDims) {
        List iFormulaList = ChkFormulaServiceHelper.getIFormulaList((String)formula, (String)VFormula.getVName());
        if (CollectionUtils.isEmpty((Collection)iFormulaList)) {
            return new VFormula();
        }
        VFormula vFormula = (VFormula)iFormulaList.get(0);
        if (excludeContextDims) {
            Iterator iterator = vFormula.getParamList().iterator();
            while (iterator.hasNext()) {
                ParamItem p = (ParamItem)iterator.next();
                String[] split = p.toString().split("@", 2);
                if (!BizRuleConstant.CONTEXT_DIMS.contains(split[0])) continue;
                iterator.remove();
            }
            return vFormula;
        }
        return vFormula;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent cb) {
        String actionId = cb.getActionId();
        Object data = cb.getReturnData();
        CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
        HashMap dataCache = Maps.newHashMap();
        if (cb.getReturnData() != null) {
            if (this.controlClosedCallBack(cb, actionId)) {
                this.getPageCache().put("ismodifer", "true");
                return;
            }
            switch (actionId) {
                case "getratelacb": {
                    String sign = BizRuleConfigFormulaHelper.getComboSign("getratelacb", "");
                    String getRateformula = ((HashMap)data).get("formula").toString();
                    String temporaryStr = BizRuleUtil.getTemporaryStr((String)getRateformula);
                    this.getPageCache().put(getRateformula, temporaryStr);
                    dataCache.put(sign, getRateformula);
                    custom.setData(BizRuleConfigFormulaHelper.packAddText(sign, getRateformula));
                    break;
                }
                case "espformulacb": {
                    String sign = BizRuleConfigFormulaHelper.getComboSign("espformulacb", "");
                    String espformula = ((HashMap)data).get("formula").toString();
                    String espformulaName = ((HashMap)data).get("name").toString();
                    dataCache.put(sign, espformula);
                    dataCache.put(sign + "name", espformulaName);
                    custom.setData(BizRuleConfigFormulaHelper.packAddText(sign, espformula));
                    break;
                }
                case "formula_temp": {
                    String formula = ((HashMap)data).get("formula").toString();
                    String radiogroupfield = ((HashMap)data).get("radiogroupfield").toString();
                    String key = BizRuleConfigFormulaHelper.getComboSign("formula_temp_", radiogroupfield);
                    this.getPageCache().put(key, formula);
                    custom.setData(BizRuleConfigFormulaHelper.packAddText(key, formula));
                    break;
                }
                case "formulacb": {
                    String sign = BizRuleConfigFormulaHelper.getComboSign("formula_fx_", "");
                    String vformula = ((HashMap)data).get("formula").toString();
                    dataCache.put(sign, vformula);
                    try {
                        custom.setData(BizRuleConfigFormulaHelper.packAddText(sign, vformula));
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                    break;
                }
                case "formula_temp_": {
                    if (!StringUtils.isNotEmpty((String)data.toString())) break;
                    String vformula = ((HashMap)data).get("formula").toString().substring(1);
                    String radiogroupfield1 = ((HashMap)data).get("formula").toString().substring(0, 1);
                    String jsFormula = ((HashMap)data).get("jsFormula").toString().substring(1);
                    String sign = BizRuleConfigFormulaHelper.getComboSign("formula_fx_", radiogroupfield1);
                    if (!StringUtils.isNotEmpty((String)jsFormula)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790js\u516c\u5f0f\u5f02\u5e38\u3002", (String)"BizRuleConfigPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    this.getPageCache().put(vformula, jsFormula);
                    dataCache.put(sign, vformula);
                    dataCache.put("radiogroupfield", radiogroupfield1);
                    try {
                        custom.setData(BizRuleConfigFormulaHelper.packAddText(sign, vformula));
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                    break;
                }
                case "formulacb_choosetype": {
                    if (!StringUtils.isNotEmpty((String)data.toString())) break;
                    String vformula = ((HashMap)data).get("formula").toString().substring(1);
                    String radiogroupfield2 = ((HashMap)data).get("formula").toString().substring(0, 1);
                    String jsFormula = ((HashMap)data).get("jsFormula").toString().substring(1);
                    String sign = BizRuleConfigFormulaHelper.getComboSign("formula_fx_", radiogroupfield2);
                    if (!StringUtils.isNotEmpty((String)jsFormula)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790js\u516c\u5f0f\u5f02\u5e38\u3002", (String)"BizRuleConfigPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    this.getPageCache().put(vformula, jsFormula);
                    dataCache.put(sign, vformula);
                    dataCache.put("radiogroupfield", radiogroupfield2);
                    try {
                        custom.setData(BizRuleConfigFormulaHelper.packAddText(sign, vformula));
                    }
                    catch (Exception e1) {
                        log.error("error", (Throwable)e1);
                    }
                    break;
                }
                default: {
                    if (actionId.startsWith("getratelacb")) {
                        String getRateFormula = ((HashMap)data).get("formula").toString();
                        BizRuleConfigFormulaHelper.getComboSign("espformulacb", "");
                        String getRateformula = ((HashMap)data).get("formula").toString();
                        String temporaryStr = BizRuleUtil.getTemporaryStr((String)getRateformula);
                        this.getPageCache().put(getRateformula, temporaryStr);
                        dataCache.put(actionId, getRateFormula);
                        custom.setData(BizRuleConfigFormulaHelper.packGetText());
                        break;
                    }
                    if (actionId.startsWith("espformulacb")) {
                        String espformula = ((HashMap)data).get("formula").toString();
                        dataCache.put(actionId, espformula);
                        custom.setData(BizRuleConfigFormulaHelper.packGetText());
                        break;
                    }
                    if (actionId.startsWith("formula_temp_")) {
                        if (!StringUtils.isNotEmpty((String)data.toString())) break;
                        String vformula = ((HashMap)data).get("formula").toString().substring(1);
                        String radiogroupfield3 = ((HashMap)data).get("formula").toString().substring(0, 1);
                        String jsFormula = ((HashMap)data).get("jsFormula").toString().substring(1);
                        if (!StringUtils.isNotEmpty((String)jsFormula)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790js\u516c\u5f0f\u5f02\u5e38\u3002", (String)"BizRuleConfigPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        this.getPageCache().put(vformula, jsFormula);
                        dataCache.put(actionId, vformula);
                        dataCache.put("radiogroupfield", radiogroupfield3);
                        try {
                            custom.setData(BizRuleConfigFormulaHelper.packGetText());
                        }
                        catch (Exception e1) {
                            log.error("error", (Throwable)e1);
                        }
                        break;
                    }
                    if (actionId.startsWith("formula_fx_")) {
                        String vformula = ((HashMap)data).get("formula").toString();
                        try {
                            dataCache.put(actionId, vformula.substring(1));
                            custom.setData(BizRuleConfigFormulaHelper.packGetText());
                        }
                        catch (Exception e1) {
                            log.error("error", (Throwable)e1);
                        }
                        break;
                    }
                    if ("addExtendFormula".equals(actionId)) {
                        String sign = CheckedFormulaUtil.getComboSign((String)"formula_extends_");
                        this.putXdmFormula2Cache(cb, sign, actionId);
                        break;
                    }
                    if (actionId.startsWith("formula_extends_")) {
                        this.putXdmFormula2Cache(cb, actionId, actionId);
                        break;
                    }
                    this.multiControlClosedCallBack(cb, actionId);
                }
            }
            this.getPageCache().put("ismodifer", "true");
            if (MapUtils.isNotEmpty((Map)dataCache)) {
                this.getPageCache().put((Map)dataCache);
            }
        }
    }

    private void putXdmFormula2Cache(ClosedCallBackEvent cb, String sign, String key) {
        if (cb.getReturnData() != null) {
            Map extendsFormula = (Map)cb.getReturnData();
            String fullFormula = (String)extendsFormula.get("xdmscriptbuilder");
            this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
            CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
            String formatXdmExpression = ChkFormulaServiceHelper.formatXdmExpression((String)fullFormula);
            if ("addExtendFormula".equals(key)) {
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)formatXdmExpression));
            } else {
                custom.setData(CheckedFormulaUtil.packGetText());
            }
            this.getPageCache().put(sign, formatXdmExpression);
            this.getPageCache().put("bizruleformula_" + sign, fullFormula);
        }
    }

    private Boolean checkScopeRepetitive(String vformula) {
        DynamicObjectCollection doc = this.getModel().getEntryEntity("entryentity1");
        if (!doc.isEmpty()) {
            if (StringUtils.isNotEmpty((String)vformula)) {
                int start = vformula.indexOf("v(");
                int end = vformula.indexOf("=");
                String vstr = "";
                vstr = start > end ? vformula.substring(vformula.lastIndexOf("="), vformula.lastIndexOf(")") + 1) : vformula.substring(start, end);
                String memberStr = vstr.substring(vstr.indexOf("(") + 1, vstr.length() - 1);
                String[] strs = memberStr.split(",");
                Set checkSet = doc.stream().map(dyo -> SysDimensionEnum.getEnumByNumber((String)dyo.getString("dimension")) != null ? SysDimensionEnum.getEnumByNumber((String)dyo.getString("dimension")).getShortnumber() : dyo.getString("dimension")).collect(Collectors.toSet());
                for (String str : strs) {
                    String dim;
                    if (!str.contains("@") || !checkSet.contains(dim = str.substring(1, str.indexOf("@")))) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u540c\u4e00\u7ef4\u5ea6\u201c%s\u201d\u4e0d\u80fd\u540c\u65f6\u51fa\u73b0\u8868\u8fbe\u5f0f\u5de6\u8fb9\u548c\u8303\u56f4\u57df\u4e2d\u3002", (String)"BizRuleConfigPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim));
                    return Boolean.TRUE;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u8303\u56f4\u8ba1\u7b97\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleConfigPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getEventArgs();
        switch (e.getEventName()) {
            case "f(x)": {
                if (StringUtils.isEmpty((String)key)) {
                    VFormula v = new VFormula();
                    v.initParam(new ParamList());
                    this.showVPanel("chooseVType", null, v.toString());
                    break;
                }
                if (key.startsWith("formula_fx_")) {
                    HashMap<String, String> dataMap = new HashMap<String, String>(2);
                    if (StringUtils.isNotEmpty((String)this.getPageCache().get("radiogroupfield"))) {
                        dataMap.put("radiogroupfield", this.getPageCache().get("radiogroupfield"));
                    }
                    dataMap.put(key, this.getPageCache().get(key));
                    this.showVPanel("formula_fx_", key, dataMap);
                    break;
                }
                if (key.startsWith("getratelacb")) {
                    this.showVPanel("getratelacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("espformulacb")) {
                    this.showVPanel("espformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("formula_temp_")) {
                    this.showVPanel("formula_temp_", key, this.getPageCache().get(key));
                    break;
                }
                if (!key.startsWith("formula_extends_")) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                String extendsFormula = ChkFormulaServiceHelper.parseXdmFormula((String)this.getPageCache().get("bizruleformula_" + key));
                CommonFormulaModel xdmFormulaBuilder = (CommonFormulaModel)ObjectSerialUtil.deSerializedBytes((String)extendsFormula);
                paramMap.put("extendsmodel", xdmFormulaBuilder.getCondition("extendsmodel"));
                paramMap.put("extendsfield", xdmFormulaBuilder.getCondition("extendsfield"));
                paramMap.put("extendsmdfield", xdmFormulaBuilder.getCondition("extendsmdfield"));
                paramMap.put("scenario", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.SCENARIO.getNumber()));
                paramMap.put("extendsmdfieldvalue", xdmFormulaBuilder.getCondition("extendsmdfieldvalue"));
                paramMap.put("templatename", xdmFormulaBuilder.getCondition("templatename"));
                paramMap.put("template", xdmFormulaBuilder.getCondition("template"));
                paramMap.put("entryentity", xdmFormulaBuilder.getCondition("entryconditions"));
                paramMap.put("year", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.YEAR.getNumber()));
                paramMap.put("period", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.PERIOD.getNumber()));
                paramMap.put("entity", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.ENTITY.getNumber()));
                paramMap.put("currency", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.CURRENCY.getNumber()));
                paramMap.put("process", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.PROCESS.getNumber()));
                paramMap.put("audittrail", xdmFormulaBuilder.getDimId(this.getCurModelNumber(), DimEntityNumEnum.AUDITTRIAL.getNumber()));
                this.showExtendsFormula(paramMap, key);
                break;
            }
            case "getRate": {
                this.showVPanel("getratelacb", "getratelacb", null);
                break;
            }
            case "esp": {
                this.showVPanel("espformulacb", "espformulacb", null);
                break;
            }
            case "getText": {
                String text = e.getEventArgs();
                HashMap maps = Maps.newHashMap();
                String formula = this.getFormula(text, maps);
                String isActionSave = this.getPageCache().get("isActionSave");
                String getNewFormulaData = this.getPageCache().get("getNewFormudata");
                if (isActionSave != null && Boolean.parseBoolean(isActionSave.toString())) {
                    String logicNumber = this.getModel().getValue("logic_number").toString();
                    String logicName = this.getModel().getValue("logic_name").toString();
                    if (StringUtils.isEmpty((String)formula)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba1\u7b97\u8868\u8fbe\u5f0f\u3002", (String)"BizRuleLogicConfigCalculatePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.actionSave(formula).booleanValue()) {
                        this.getPageCache().put("oldformuldata", formula);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizRuleConfigPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && this.getPageCache().get("isfirstSave") == null) {
                            this.writeOperationLog(BizRuleConstant.getOperationAddSave(), logicNumber, logicName, BizRuleConstant.getOperationStatusSuccess());
                        } else {
                            this.writeOperationLog(BizRuleConstant.getOperationUpdateSave(), logicNumber, logicName, BizRuleConstant.getOperationStatusSuccess());
                        }
                        this.getView().setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"BizRuleListPlugin_65", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getModel().getDataEntityType().getDisplayName().getLocaleValue(), this.getModel().getValue("logic_name"))));
                        this.getPageCache().remove("ismodifer");
                        this.getPageCache().put("isSaved", "true");
                        this.getPageCache().put("isfirstSave", "false");
                        break;
                    }
                    if (this.getPageCache().get("isSaved") != null) break;
                    if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && this.getPageCache().get("isfirstSave") == null) {
                        this.writeOperationLog(BizRuleConstant.getOperationAddSave(), logicNumber, logicName, BizRuleConstant.getOperationStatusFail());
                    } else {
                        this.writeOperationLog(BizRuleConstant.getOperationUpdateSave(), logicNumber, logicName, BizRuleConstant.getOperationStatusFail());
                    }
                    this.getPageCache().put("isSaved", "false");
                    break;
                }
                if (getNewFormulaData != null && Boolean.parseBoolean(getNewFormulaData.toString())) {
                    String oldforwula = this.getPageCache().get("oldformuldata");
                    if (StringUtils.isNotEmpty((String)oldforwula) && StringUtils.isNotEmpty((String)formula)) {
                        if (!oldforwula.trim().equals(formula.trim())) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BizRuleConfigPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeBeforeSave", (IFormPlugin)this));
                        } else {
                            this.getView().close();
                        }
                    } else if (StringUtils.isEmpty((String)oldforwula) && StringUtils.isEmpty((String)formula)) {
                        this.getView().close();
                    } else {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"BizRuleConfigPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeBeforeSave", (IFormPlugin)this));
                    }
                    this.getPageCache().remove("getNewFormudata");
                    break;
                }
                String data = BizRuleConfigFormulaHelper.rebuildFormula(text, this.getPageCache());
                CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
                custom.setData(BizRuleConfigFormulaHelper.packUpdateText(data));
                break;
            }
        }
    }

    private void showVPanel(String type, String key, Object param) {
        CloseCallBack closeCallBack;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_rulevnewformula");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("formula", param);
        if (key != null) {
            if ("getratelacb".equals(type)) {
                formShowParameter.setFormId("bcm_rulegetrateformula");
            } else if ("espformulacb".equals(type)) {
                formShowParameter.setFormId("bcm_ruleespformula");
            } else if (StringUtils.isNotEmpty((String)type) && type.startsWith("formula_fx_")) {
                if (key.charAt(key.length() - 2) == '_') {
                    formShowParameter.setCustomParam("radiogroupfield", (Object)key.substring(key.length() - 1));
                } else {
                    formShowParameter.setCustomParam("radiogroupfield", ((HashMap)param).get("radiogroupfield"));
                }
                formShowParameter.setCustomParam("formula", ((HashMap)param).get(key));
            } else if (key.startsWith("formula_temp_")) {
                formShowParameter.setCustomParam("radiogroupfield", (Object)key.substring(key.length() - 1));
                formShowParameter.setCustomParam("formula", param);
            }
            closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        } else {
            switch (type) {
                case "formula_fx_": {
                    formShowParameter.setCustomParam("radiogroupfield", (Object)this.getPageCache().get("radiogroupfield"));
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "formulacb");
                    break;
                }
                case "espformulacb": {
                    formShowParameter.setFormId("bcm_ruleespformula");
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "espformulacb");
                    break;
                }
                default: {
                    formShowParameter.setFormId("bcm_choosevtype");
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "formulacb_choosetype");
                }
            }
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("closeBeforeSave".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                String msg = BizRuleUtil.validBizRuleNumber((String)this.getModel().getValue("logic_number").toString());
                if (!StringUtils.isEmpty((String)msg)) {
                    this.getView().showTipNotification(msg);
                    return;
                }
                if (this.checkNull()) {
                    CustomControl custom = (CustomControl)this.getView().getControl("bizconfigformulatext");
                    this.getPageCache().put("isActionSave", "true");
                    custom.setData(BizRuleConfigFormulaHelper.packGetText());
                }
            } else {
                this.getView().close();
            }
        }
    }
}

