/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponent;
import kd.fi.bcm.business.bizrule.logicconfig.component.BizRuleComponentCopySource;
import kd.fi.bcm.business.bizrule.logicconfig.function.BizRuleFunctionCopy;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.computing.BizRuleLogicConfigBasePlugin;

public class BizRuleLogicConfigCopyPlugin
extends BizRuleLogicConfigBasePlugin {
    private static final List<String> f7keys = Arrays.asList(DimTypesEnum.ENTITY.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.SCENARIO.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.YEAR.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.PERIOD.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.CURRENCY.getNumber().toLowerCase(Locale.ENGLISH), DimTypesEnum.PROCESS.getNumber().toLowerCase(Locale.ENGLISH));

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(f7keys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject bizruleconfig = (JSONObject)this.getFormCustomParam("bizruleconfig");
        if (bizruleconfig == null) {
            return;
        }
        String copysource = bizruleconfig.getString("copysource");
        if (StringUtils.isEmpty((String)copysource)) {
            return;
        }
        String[] split = copysource.split(",");
        String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
        for (String s : split) {
            String[] split1 = s.split("@");
            if (split1.length != 2) continue;
            String dim = split1[0];
            String member = split1[1];
            String dimNumber = DimTypesEnum.getDimNumber((String)dim, (long)this.getModelId());
            String lowercaseDimNumber = dimNumber.toLowerCase(Locale.ENGLISH);
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && member.contains("_")) {
                String realMember = member.split("_", 2)[1];
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)realMember);
                if (node.getParent_SonNumber().equals(member)) {
                    this.getModel().setValue(lowercaseDimNumber, (Object)node.getId(), 0);
                    continue;
                }
                List shareNodes = node.getShareNodes();
                for (IDNumberTreeNode shareNode : shareNodes) {
                    if (!shareNode.getParent_SonNumber().equals(member)) continue;
                    this.getModel().setValue(lowercaseDimNumber, (Object)shareNode.getId(), 0);
                }
                continue;
            }
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)dimNumber, (String)member);
            this.getModel().setValue(lowercaseDimNumber, (Object)node.getId(), 0);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "closeBeforeSave": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    String msg = BizRuleUtil.validBizRuleNumber((String)this.getModel().getValue("logic_number").toString());
                    if (!StringUtils.isEmpty((String)msg)) {
                        this.getView().showTipNotification(msg);
                        return;
                    }
                    if (!this.checkNull()) break;
                    this.btnSave();
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    @Override
    protected boolean customSaveAction(DynamicObject entity, BizRuleComponent bizRuleFunctionIfCondition, BizRuleComponent bizRuleFunctionScope) {
        boolean success = super.customSaveAction(entity, bizRuleFunctionIfCondition, bizRuleFunctionScope);
        if (!success) {
            return false;
        }
        BizRuleComponentCopySource bizRuleCopySource = new BizRuleComponentCopySource(new LinkedHashMap(16));
        String processNumber = "";
        Long entityId = null;
        DynamicObject copysourceDy = this.getModel().getEntryRowEntity("entryentity11", 0);
        for (DimTypesEnum contextDimension : BizRuleConstant.CONTEXT_DIMENSIONS) {
            DynamicObject dy = (DynamicObject)copysourceDy.get(contextDimension.getNumber().toLowerCase(Locale.ENGLISH));
            if (dy == null) continue;
            String number = dy.getString("number");
            bizRuleCopySource.add(contextDimension.getShortNumber(), number);
            if (contextDimension == DimTypesEnum.PROCESS) {
                processNumber = number;
            }
            if (contextDimension != DimTypesEnum.ENTITY) continue;
            entityId = dy.getLong("id");
        }
        if (OrgRelaProcessMembPool.isRelaProcess((String)processNumber) && entityId != null) {
            bizRuleCopySource.add(DimTypesEnum.ENTITY.getShortNumber(), MemberReader.findEntityMemberById((Long)this.getModelId(), entityId).getVirtualEntity());
        }
        entity.set("copysource", (Object)bizRuleCopySource.generateJsScript());
        BizRuleFunctionCopy bizRuleFunctionCopy = new BizRuleFunctionCopy(entity.getString("logic_log"), entity.getString("logic_name"), entity.getString("logic_number"), bizRuleFunctionIfCondition, bizRuleFunctionScope, (BizRuleComponent)bizRuleCopySource);
        entity.set("logic_js", (Object)bizRuleFunctionCopy.generateJsScript());
        return true;
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.getView().getParentView().invokeOperation("refresh");
    }
}

