/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.events.BeforePackageDataListener;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.common.IRefreshList;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.lang.StringUtils;

public class BizRuleRetrievalPlugin
extends AbstractBaseListPlugin
implements IRefreshList,
SearchEnterListener,
BeforeF7SelectListener {
    private static final String KEY_BASEDATAFIELD1 = "model";
    private static final String SEARCH = "search";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String PROCESS_MAP = "process_map";

    private static String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"BizRuleRetrievalPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private static String getOperationStstusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"BizRuleRetrievalPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        billList.addBeforePackageDataListener(new BeforePackageDataListener(){

            public void beforePackageData(BeforePackageDataEvent beforePackageDataEvent) {
                DynamicObjectCollection pageData = beforePackageDataEvent.getPageData();
                BizRuleRetrievalPlugin.this.getPageCache().remove(BizRuleRetrievalPlugin.PROCESS_MAP);
                if (!pageData.isEmpty()) {
                    long modelId = BizRuleRetrievalPlugin.this.getModelId();
                    String modelNum = MemberReader.findModelNumberById((Object)modelId);
                    Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Process");
                    List ids = pageData.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                    QFilter filtes = new QFilter("bizrule", "in", ids);
                    filtes.and(new QFilter("dimension", "=", (Object)dimensionId));
                    DynamicObjectCollection collections = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"member,bizrule", (QFilter[])new QFilter[]{filtes});
                    ArrayListMultimap bizProcessMap = ArrayListMultimap.create();
                    collections.forEach(dyn -> bizProcessMap.put(dyn.get("bizrule"), (Object)dyn.getLong("member")));
                    HashMap<String, String> processMap = new HashMap<String, String>(16);
                    for (DynamicObject data : pageData) {
                        List processes = bizProcessMap.get(data.getPkValue());
                        StringJoiner sj = new StringJoiner(",");
                        for (Long process : processes) {
                            IDNumberTreeNode processMemberById = MemberReader.findProcessMemberById((String)modelNum, (Long)process);
                            String number = processMemberById == IDNumberTreeNode.NotFoundTreeNode ? "" : processMemberById.getNumber();
                            sj.add(number);
                        }
                        processMap.put(data.getPkValue().toString(), sj.toString());
                    }
                    BizRuleRetrievalPlugin.this.getPageCache().put(BizRuleRetrievalPlugin.PROCESS_MAP, BizRuleRetrievalPlugin.this.toByteSerialized(processMap));
                }
            }
        });
        billList.addPackageDataListener(packageDataEvent -> {
            String key = ((ColumnDesc)packageDataEvent.getSource()).getKey();
            if ("alloprocessname".equals(key)) {
                Map res = (Map)ThreadCache.get((Object)PROCESS_MAP, () -> {
                    String pageCache = this.getPageCache().get(PROCESS_MAP);
                    Map map = new HashMap(16);
                    if (StringUtils.isNotEmpty((String)pageCache)) {
                        map = (Map)this.deSerializedBytes(pageCache);
                    }
                    return map;
                });
                String processName = (String)res.get(packageDataEvent.getRowData().getPkValue().toString());
                packageDataEvent.setFormatValue((Object)processName);
            }
        });
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (SEARCH.equals(itemKey)) {
            this.refreshList();
        }
    }

    @Override
    public void refreshList() {
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        FilterParameter fp = new FilterParameter();
        long modelId = this.getModelId();
        QFilter filter = new QFilter(KEY_BASEDATAFIELD1, "=", (Object)modelId);
        if (modelId != 0L) {
            filter.and("deletestatus", "=", (Object)false);
            Search search = (Search)this.getView().getControl("searchap");
            String searchKey = search.getSearchKey();
            if (StringUtils.isNotEmpty((String)searchKey)) {
                filter.and(new QFilter("debug", "like", (Object)("%" + searchKey + "%")));
            }
        }
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.refresh();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        long modelId = this.getModelId();
        this.getModel().setValue(KEY_BASEDATAFIELD1, (Object)modelId);
        this.refreshList();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && kd.bos.util.StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
            ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp(this.getView());
            QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)"bcm_bizrulelist", (ApplicationTypeEnum)applicationTypeEnum));
            QFilter perRoleids = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)applicationTypeEnum, (String)"bcm_bizrulelist", (String)"47150e89000000ac"));
            qFilterList.add(superid.or(haspermid).or(perRoleids));
            qFilterList.add(ModelUtil.getModelQfilterByApp(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public String getModelSign() {
        return KEY_BASEDATAFIELD1;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (KEY_BASEDATAFIELD1.equals(name)) {
            Search search = (Search)this.getView().getControl("searchap");
            search.setSearchKey("");
            this.refreshList();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
            Object ruleId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            Long modelid = this.getModelId();
            int is = BcmBasePluginUtil.checkPermission(this.getUserId(), Long.parseLong(((Object)modelid).toString()), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), "bcm_bizrulelist", "4715a0df000000ac");
            DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_bizruleentity");
            boolean iscommon = single.getBoolean("iscommon");
            if (is == 1 || MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)((Object)modelid).toString())) {
                this.editBizRule(ruleId.toString(), single.getString("name"), iscommon, single.getString("type"));
                this.writeOperationLog(BizRuleRetrievalPlugin.getOperationView(), single.getString("number"), single.getString("name"), BizRuleRetrievalPlugin.getOperationStstusSuccess());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"BizRuleRetrievalPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(KEY_BASEDATAFIELD1);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        IDataModel model = this.getModel();
        String searchKey = searchEnterEvent.getText();
        searchEnterEvent.setText(searchKey);
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), KEY_BASEDATAFIELD1);
        this.refreshList();
    }

    private void editBizRule(String bizRuleId, String bizRuleName, Boolean iscommon, String type) {
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        if (BizRuleTypeEnum.CONFIG.getType().equals(type)) {
            openParameter.put("formId", "bcm_bizruleentityconfig");
        } else {
            openParameter.put("formId", "bcm_bizruleentity");
        }
        openParameter.put("pkId", bizRuleId);
        openParameter.put("listPageID", this.getView().getPageId());
        if (iscommon.booleanValue()) {
            openParameter.put("nodeId", "-1");
        }
        IFormView mainPageView = this.getView().getMainView();
        IFormView parentView = this.getView().getParentView();
        String pageId = this.getView().getPageId() + bizRuleId;
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setPageId(pageId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219-%s", (String)"BizRuleRetrievalPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), bizRuleName));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_bizruleentity");
            showParameter.setCloseCallBack(closeCallBack);
            if (ObjectUtils.isEmpty((Object)parentView)) {
                this.getView().showForm(showParameter);
                return;
            }
            parentView.showForm(showParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }
}

