/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class BizRuleSortPlugin
extends AbstractBaseFormPlugin {
    public static final String ENTRYENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("bar_ok");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String processid = (String)this.getFormCustomParam("processid");
        long modelid = (Long)this.getFormCustomParam("model");
        QFilter filter = new QFilter("bizrule.deletestatus", "=", (Object)false);
        filter.and("model", "=", (Object)modelid);
        List mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
        if (mountedNode.contains(processid)) {
            filter.and("bizrule.executetype", "=", (Object)processid);
        } else {
            filter.and("member", "=", (Object)Long.parseLong(processid)).and("bizrule.executetype", "not in", mountedNode);
        }
        DynamicObjectCollection result = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"id,bizrule.number,bizrule.name,bizrule.runstatus,bizrule.status", (QFilter[])filter.toArray(), (String)"execsort");
        if (!result.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, result.size());
            for (int i = 0; i < result.size(); ++i) {
                this.getModel().setValue("number", ((DynamicObject)result.get(i)).get("bizrule.number"), i);
                this.getModel().setValue("name", ((DynamicObject)result.get(i)).get("bizrule.name"), i);
                this.getModel().setValue("runstatus", ((DynamicObject)result.get(i)).get("bizrule.runstatus"), i);
                this.getModel().setValue("status", ((DynamicObject)result.get(i)).get("bizrule.status"), i);
                this.getModel().setValue("id", ((DynamicObject)result.get(i)).get("id"), i);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bar_ok".equals(key)) {
            DynamicObjectCollection stepColls = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(stepColls.size());
            for (int i = 0; i < stepColls.size(); ++i) {
                String alloprocessid = ((DynamicObject)stepColls.get(i)).getString("id");
                DynamicObject updateObject = BusinessDataServiceHelper.loadSingle((Object)alloprocessid, (String)"bcm_bizrulealloprocess");
                updateObject.set("execsort", (Object)(i + 1));
                updateList.add(updateObject);
            }
            if (!updateList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            this.getView().returnDataToParent((Object)"OK");
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("moveentryup".equals(operateKey)) {
            this.writeOpLog(OpItemEnum.UP.getName());
        } else if ("moveentrydown".equals(operateKey)) {
            this.writeOpLog(OpItemEnum.DOWN.getName());
        }
    }

    private void writeOpLog(String opName) {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] entryIds = entryGrid.getSelectRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i : entryIds) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            String log = String.format("%s %s,%s%s", number, name, opName, ResultStatusEnum.SUCCESS.getName());
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)opName, (String)log, (Long)modelId);
        }
    }
}

