/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.intergration.formula.VFormulaPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BizRuleVFormulaPlugin
extends VFormulaPlugin {
    private static final String TARGET = "2";
    private static final List<String> DIMKEYS = Lists.newArrayList((Object[])new String[]{"account", "audittrail", "changetype", "internalcompany", "multibook", "scenario", "entity", "process", "currency"});
    private static final String LASTYEAREND = "1";
    private static final String SAMEPERIODLASTYEAR = "2";
    private static final String LASTPERIOD = "3";

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(DIMKEYS, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String radiogroupfield = (String)this.getFormCustomParam("radiogroupfield");
        if ("2".equals(radiogroupfield)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bcm_scenemembertree", "bcm_entitymembertree", "bcm_processmembertree", "bcm_currencymembertree", "combo_period", "bcm_periodmembertree", "bcm_fymembertree"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if ("combo_period".equals(e.getKey())) {
            ComboEdit edit = new ComboEdit();
            edit.setKey(e.getKey());
            edit.setFieldKey(e.getKey());
            edit.setView(this.getView());
            edit.setModel(this.getModel());
            e.setControl((Control)edit);
        }
    }

    @Override
    public void click(EventObject evt) {
        String radiogroupfield;
        super.click(evt);
        String item = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(item) && StringUtils.isNotEmpty((String)(radiogroupfield = (String)this.getFormCustomParam("radiogroupfield")))) {
            VFormula vFormula = new VFormula();
            vFormula.initParam(new ParamList());
            boolean formulaEmpty = true;
            for (Object p : this.getModel().getDataEntity().getDataEntityType().getProperties()) {
                if (!p.getName().startsWith("bcm_") || p.getName().endsWith("_id")) continue;
                String dimName = p.getName();
                if (this.getModel().getValue(dimName) == null) continue;
                vFormula.getParamList().add((Object)new ParamItem((Object)this.wrapFormulaParam(dimName)));
                formulaEmpty = false;
            }
            String choosePeriod = (String)this.getModel().getValue("combo_period");
            if (StringUtils.isNotEmpty((String)choosePeriod)) {
                switch (choosePeriod) {
                    case "1": {
                        vFormula.getParamList().add((Object)new ParamItem((Object)"getLastYearEnd()"));
                        break;
                    }
                    case "2": {
                        vFormula.getParamList().add((Object)new ParamItem((Object)"FY@ctx.FY.lastYear()"));
                        break;
                    }
                    case "3": {
                        vFormula.getParamList().add((Object)new ParamItem((Object)"getLastPeriod()"));
                        break;
                    }
                }
                formulaEmpty = false;
            }
            if (formulaEmpty) {
                throw new KDBizException(ResManager.loadKDString((String)"v\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRuleVFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, StringBuffer> formulaData = new HashMap<String, StringBuffer>(16);
            formulaData.put("formula", new StringBuffer(radiogroupfield).append(vFormula.toBizRuleFormulaString(vFormula.getName().toLowerCase(Locale.ENGLISH))));
            formulaData.put("jsFormula", new StringBuffer(radiogroupfield).append(BizRuleUtil.convert2Js((VFormula)vFormula)));
            this.getView().returnDataToParent(formulaData);
        }
        this.getView().close();
    }

    @Override
    protected String wrapFormulaParam(String propName) {
        StringBuilder param = new StringBuilder();
        DynamicObject dyna = this.getModel().getDataEntity().getDynamicObject(propName);
        if (propName.contains("bcm_userdefinedmembertree_")) {
            String userdefindMember = propName.substring("bcm_userdefinedmembertree".length() + 1);
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)this.getModelId()).add("membermodel", "=", (Object)"bcm_userdefinedmembertree");
            qf.add("number", "=", (Object)QueryDimensionServiceHelper.getDimNumberEgnoreCase((String)userdefindMember, (long)this.getModelId()));
            DynamicObject dim = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,shortnumber", (QFilter[])qf.toArray());
            if (dim != null) {
                param.append(dim.getString("shortnumber"));
            }
        } else {
            SysDimensionEnum enumInfo = SysDimensionEnum.getEnumByTreeNumber((String)propName);
            if (enumInfo != null) {
                param.append(enumInfo.getShortnumber());
            }
        }
        param.append("@");
        param.append(dyna.getString("number"));
        return param.toString();
    }

    @Override
    public void initPageviewPanelValues() {
        HashMap<String, String> membValues = new HashMap<String, String>();
        String formula = (String)this.getFormCustomParam("formula");
        if (formula != null) {
            try {
                List iFormulaList = ChkFormulaServiceHelper.getIFormulaList((String)formula, (String)VFormula.getVName());
                if (CollectionUtils.isEmpty((Collection)iFormulaList)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
                }
                VFormula vFormula = (VFormula)iFormulaList.get(0);
                String periodStr = "";
                block12: for (ParamItem p : vFormula.getParamList()) {
                    String param;
                    switch (param = p.getParam().toString().replace("\"", "")) {
                        case "getLastYearEnd()": {
                            periodStr = LASTYEAREND;
                            continue block12;
                        }
                        case "FY@ctx.FY.lastYear()": {
                            periodStr = "2";
                            continue block12;
                        }
                        case "getLastPeriod()": {
                            periodStr = LASTPERIOD;
                            continue block12;
                        }
                    }
                    int pointIndex = param.indexOf("@");
                    if (pointIndex < 0) {
                        pointIndex = param.indexOf(".");
                    }
                    String shortNum = param.substring(0, pointIndex);
                    String memberNum = param.substring(pointIndex + 1);
                    membValues.put(shortNum, memberNum);
                }
                if (StringUtils.isNotEmpty((String)periodStr)) {
                    this.getModel().beginInit();
                    this.getModel().setValue("combo_period", (Object)periodStr);
                    this.getModel().endInit();
                    this.getView().updateView("combo_period");
                }
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u65e0\u6548\u516c\u5f0f", (String)"VFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            }
            membValues.forEach((key, value) -> {
                Tuple<String, String, String> dimInfo = this.shortNumber2NumberName.get(key);
                if (dimInfo == null) {
                    return;
                }
                String membEntityNum = (String)dimInfo.p3;
                String dimnum = (String)dimInfo.p1;
                String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
                IDNumberTreeNode memberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)dimnum, (String)value);
                if (memberByNumber.getId() == -1L) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u6210\u5458\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"VFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dimInfo.p2, value));
                    return;
                }
                DynamicObject o = BusinessDataServiceHelper.newDynamicObject((String)membEntityNum);
                o.set("id", (Object)memberByNumber.getId());
                o.set("name", (Object)memberByNumber.getName());
                o.set("number", (Object)memberByNumber.getNumber());
                this.getModel().setValue(this.sugarF7Key(membEntityNum, (String)dimInfo.p1), (Object)o);
            });
        }
    }

    @Override
    public void addFieldToMemberpanel(FieldsetPanelAp fieldsetpanelap, Style style) {
        super.addFieldToMemberpanel(fieldsetpanelap, style);
        FieldAp f7Field = new FieldAp();
        String key = "combo_period";
        f7Field.setName(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u9009\u62e9", (String)"BizRuleVFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        f7Field.setKey(key);
        f7Field.setFieldId(key);
        f7Field.setLabelDirection("v");
        f7Field.setStyle(this.getWideStyle());
        ComboField comboField = new ComboField();
        comboField.setKey(key);
        List<ComboItem> comboItems = this.getPeriodDimComboItems();
        comboField.setItems(comboItems);
        comboField.setDefValue(LASTYEAREND);
        comboField.setName(new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4\u9009\u62e9", (String)"BizRuleVFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        comboField.setMustInput(false);
        f7Field.setField((Field)comboField);
        f7Field.setFireUpdEvt(true);
        fieldsetpanelap.getItems().add(f7Field);
        this.getView().updateView("combo_period");
    }

    private List<ComboItem> getPeriodDimComboItems() {
        ArrayList comboItems = Lists.newArrayList();
        ComboItem item1 = new ComboItem(1, new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u671f\u672b", (String)"VFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])), LASTYEAREND);
        ComboItem item2 = new ComboItem(2, new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f", (String)"VFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "2");
        ComboItem item3 = new ComboItem(3, new LocaleString(ResManager.loadKDString((String)"\u4e0a\u671f", (String)"VFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])), LASTPERIOD);
        comboItems.add(item1);
        comboItems.add(item2);
        comboItems.add(item3);
        return comboItems;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("combo_period".equals(propertyName)) {
            String key = (String)e.getChangeSet()[0].getNewValue();
            this.getModel().beginInit();
            this.getModel().setValue("combo_period", (Object)key);
            this.getModel().setValue("bcm_fymembertree", null);
            this.getModel().setValue("bcm_periodmembertree", null);
            this.getModel().endInit();
            this.getView().updateView();
        } else if ("bcm_fymembertree".equals(propertyName) || "bcm_periodmembertree".equals(propertyName)) {
            this.getModel().beginInit();
            this.getModel().setValue("combo_period", null);
            this.getModel().endInit();
            this.getView().updateView("combo_period");
        }
    }
}

