/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.computing;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.bizrule.BizRuleConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateStatusEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.SearchResult;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.SearchUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NewBizRuleAllocatePlugin
extends AbstractBaseFormPlugin {
    private static final String TOOLBAR_AP = "toolbarap";
    private static final String BIZ_RULE_TREE = "treeviewap";
    private static final String BTN_ANTI_ALLOCATE = "btn_antiallocate";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String VIEW_COMBO = "viewcombo";
    private static final String BAR_ALLOCATE = "bar_allocate";
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String CATALOG_ID_LIST = "RULE_CATALOG_LIST";
    private static final String TEMPLATE_CATALOG_ID_LIST = "TEMPLATE_CATALOG_LIST";
    private static final String CACHE_UPDATE_DATA = "updateDataCache";
    private static final String SPLIT = "|";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    public static final String NEW_NAME_MAP = "new_name_map";
    public static final String TEM_CATALOG_TREE = "temcatalogtree";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(TOOLBAR_AP);
        TreeView templateTree = (TreeView)this.getControl(TEM_CATALOG_TREE);
        templateTree.addTreeNodeCheckListener(evt -> this.refreshBillList());
        TreeView ruleTree = (TreeView)this.getControl(BIZ_RULE_TREE);
        ruleTree.addTreeNodeCheckListener(evt -> {
            Boolean checked = evt.getChecked();
            String nodeId = evt.getNodeId().toString();
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZ_RULE_TREE), TreeNode.class);
            this.linkCheckOrUnCheck(ruleTree, checked, nodeId, root);
            this.refreshBillList();
        });
        Search searchTemp = (Search)this.getControl("tempap");
        searchTemp.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                this.searchTemplate(event.getText().trim());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"BizRuleAllocatePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        });
        Search searchRule = (Search)this.getControl("searchap");
        searchRule.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeNode node = SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), this.getView(), this.getPageCache(), ruleTree, BIZ_RULE_TREE);
                if (node != null) {
                    TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZ_RULE_TREE), TreeNode.class);
                    this.linkCheckOrUnCheck(ruleTree, true, node.getId(), root);
                }
            } else {
                this.getPageCache().put("resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"BizRuleAllocatePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        });
        this.addClickListeners("searchbefore", "searchnext", "tempbefore", "tempnext", "btn_save", BTN_ANTI_ALLOCATE);
    }

    private void linkCheckOrUnCheck(TreeView ruleTree, Boolean checked, String nodeId, TreeNode root) {
        if (nodeId.contains(",")) {
            String src = nodeId.split(",")[0];
            this.checkOrUnChekNode(ruleTree, checked, root, src);
        } else {
            String str = this.getPageCache().get(CATALOG_ID_LIST);
            List catalogList = (List)ObjectSerialUtil.deSerializedBytes((String)str);
            if (CollectionUtils.isNotEmpty((Collection)catalogList) && catalogList.contains(nodeId)) {
                LinkedList<TreeNode> selectNodes = new LinkedList<TreeNode>();
                this.findNodeChildren(nodeId, root, selectNodes);
                for (TreeNode selectNode : selectNodes) {
                    if (!selectNode.getId().contains(",")) continue;
                    this.checkOrUnChekNode(ruleTree, checked, root, selectNode.getId().split(",")[0]);
                }
            }
        }
    }

    private void checkOrUnChekNode(TreeView ruleTree, boolean checked, TreeNode root, String src) {
        LinkedList<TreeNode> selectNodes = new LinkedList<TreeNode>();
        this.findNode(src, root, selectNodes);
        if (checked) {
            ruleTree.checkNodes(selectNodes);
        } else {
            ruleTree.uncheckNodes(selectNodes.stream().map(TreeNode::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isRPT()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"templatetype"});
        }
        if (this.getModelId() != 0L) {
            this.refreshTemplateTree();
            this.refreshRuleTree();
            this.refreshBillList();
        }
    }

    private void refreshTemplateTree() {
        TreeView tree = (TreeView)this.getControl(TEM_CATALOG_TREE);
        tree.deleteAllNodes();
        DynamicObjectCollection temList = this.getTemplateCollection();
        List<Map<String, String>> catalogs = this.getTemplatecatalogList();
        TreeNode rootView = ReportListUtil.getTemplateTree(catalogs, temList, new ArrayList<TreeNode>(), "0", new TreeNode());
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootView));
        if (CollectionUtils.isNotEmpty(catalogs)) {
            List templateCatalogIds = catalogs.stream().map(catalog -> (String)catalog.get("id")).collect(Collectors.toList());
            this.getPageCache().put(TEMPLATE_CATALOG_ID_LIST, ObjectSerialUtil.toByteSerialized(templateCatalogIds));
        }
        BCMTreeUtils.spreadAllNode((TreeNode)rootView);
        tree.addNode(rootView);
        this.getView().updateView(TEM_CATALOG_TREE);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_allocate": {
                TreeView treeView = (TreeView)this.getControl(BIZ_RULE_TREE);
                List bizRuleIdList = treeView.getTreeState().getSelectedNodeId();
                if (bizRuleIdList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleAllocatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                String str = this.getPageCache().get(CATALOG_ID_LIST);
                List catalogList = (List)ObjectSerialUtil.deSerializedBytes((String)str);
                if (CollectionUtils.isNotEmpty((Collection)catalogList)) {
                    bizRuleIdList.removeAll(catalogList);
                }
                if (bizRuleIdList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u5206\u914d\u7684\u89c4\u5219\u3002", (String)"NewBizRuleAllocatePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                boolean openExec = (Boolean)this.getModel().getValue("execwhenopen");
                boolean saveExec = (Boolean)this.getModel().getValue("execwhensave");
                if (!openExec && !saveExec && this.isNormalTemplate()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\u89c4\u5219\u6267\u884c\u65b9\u5f0f\u3002", (String)"NewBizRuleAllocatePlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                TreeView tempView = (TreeView)this.getControl(TEM_CATALOG_TREE);
                List templateIdList = tempView.getTreeState().getSelectedNodeId();
                String tempStr = this.getPageCache().get(TEMPLATE_CATALOG_ID_LIST);
                List tempCatalogList = (List)ObjectSerialUtil.deSerializedBytes((String)tempStr);
                if (CollectionUtils.isNotEmpty((Collection)tempCatalogList)) {
                    templateIdList.removeAll(tempCatalogList);
                }
                if (CollectionUtils.isEmpty((Collection)templateIdList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"BizRuleAllocatePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                this.allocateBizRule(bizRuleIdList, templateIdList);
                this.refreshBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"BizRuleAllocatePlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "bar_refresh": {
                this.refreshTemplateTree();
                this.refreshRuleTree();
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String[] btns = new String[]{"searchbefore", "searchnext"};
        switch (control.getKey()) {
            case "tempbefore": {
                this.searchNext(-1);
                break;
            }
            case "tempnext": {
                this.searchNext(1);
                break;
            }
            case "searchbefore": {
                Pair<String, String> beforPair = SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), "searchbefore", (TreeView)this.getControl(BIZ_RULE_TREE), btns, BIZ_RULE_TREE);
                if (beforPair == null) break;
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZ_RULE_TREE), TreeNode.class);
                String uncheckNode = (String)beforPair.p1;
                String checkNode = (String)beforPair.p2;
                this.linkCheckOrUnCheck((TreeView)this.getControl(BIZ_RULE_TREE), false, uncheckNode, root);
                this.linkCheckOrUnCheck((TreeView)this.getControl(BIZ_RULE_TREE), true, checkNode, root);
                break;
            }
            case "searchnext": {
                Pair<String, String> afterPair = SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), "searchnext", (TreeView)this.getControl(BIZ_RULE_TREE), btns, BIZ_RULE_TREE);
                if (afterPair == null) break;
                String uncheckNode = (String)afterPair.p1;
                String checkNode = (String)afterPair.p2;
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZ_RULE_TREE), TreeNode.class);
                this.linkCheckOrUnCheck((TreeView)this.getControl(BIZ_RULE_TREE), false, uncheckNode, root);
                this.linkCheckOrUnCheck((TreeView)this.getControl(BIZ_RULE_TREE), true, checkNode, root);
                break;
            }
            case "btn_save": {
                this.updateAllocate();
                break;
            }
            case "btn_antiallocate": {
                this.antiAllocate();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("exec_type".equals(propName)) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            String key = this.getModel().getValue("id", row).toString();
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            this.updateCache(key, newValue);
        } else if (propName.equals(VIEW_COMBO)) {
            this.updateHeader(e.getChangeSet()[0].getNewValue().toString());
            this.refreshBillList();
        } else if ("templatetype".equals(propName)) {
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            this.getModel().beginInit();
            boolean isNormalTemplate = "1".equals(newValue);
            this.getModel().setValue("execwhensave", (Object)isNormalTemplate);
            this.getView().setVisible(Boolean.valueOf(isNormalTemplate), new String[]{"execwhensave"});
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("exec_type");
            if (isNormalTemplate) {
                comboEdit.setComboItems(Arrays.asList(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6253\u5f00\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "1"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "2"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6253\u5f00\u548c\u4fdd\u5b58\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "3")));
            } else {
                comboEdit.setComboItems(Arrays.asList(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6253\u5f00\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "1"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"NewBizRuleAllocatePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])), "4")));
            }
            this.getModel().endInit();
            this.getView().updateView("execwhensave");
            this.getView().updateView(ENTRY_ENTITY);
            this.refreshTemplateTree();
            this.refreshRuleTree();
            this.refreshBillList();
        }
    }

    private void allocateBizRule(List<String> originalBizRuleIdList, List<String> templateIdList) {
        long modelId = this.getModelId();
        List<String> bizRuleIdList = this.getRealRule(originalBizRuleIdList);
        boolean openExec = (Boolean)this.getModel().getValue("execwhenopen");
        boolean saveExec = (Boolean)this.getModel().getValue("execwhensave");
        if (CollectionUtils.isNotEmpty(bizRuleIdList) && CollectionUtils.isNotEmpty(templateIdList)) {
            HashSet<String> res = new HashSet<String>(16);
            for (String tempId : templateIdList) {
                for (String ruleId : bizRuleIdList) {
                    res.add(tempId + SPLIT + ruleId);
                }
            }
            QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
            QFilter templateQFilter = this.getTemplateQFilter(templateIdList);
            String selectFields = "id, template.id, bizrule.id,execwhenopen,execwhensave,modifier,modifydate,papertemplate.id";
            Object[] records = BusinessDataServiceHelper.load((String)"bcm_brallocateentity", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, templateQFilter});
            HashMap<Long, Integer> tempRuleSizeMap = new HashMap<Long, Integer>(16);
            for (Object record : records) {
                String allocateKey = this.getAllocateKey((DynamicObject)record);
                if (res.contains(allocateKey)) {
                    record.set("execwhenopen", (Object)openExec);
                    record.set("execwhensave", (Object)saveExec);
                    record.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    record.set("modifydate", (Object)TimeServiceHelper.now());
                }
                res.remove(allocateKey);
                Integer initSize = (Integer)tempRuleSizeMap.get(record.getLong("template.id"));
                if (initSize != null) {
                    int size = initSize + 1;
                    tempRuleSizeMap.put(record.getLong("template.id"), size);
                    continue;
                }
                tempRuleSizeMap.put(record.getLong("template.id"), 0);
            }
            if (records.length > 0) {
                BusinessDataWriter.save((IDataEntityType)records[0].getDataEntityType(), (Object[])records);
            }
            if (CollectionUtils.isNotEmpty(res)) {
                QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("id", "in", (Object)ConvertUtil.convertListToLong(bizRuleIdList));
                DynamicObjectCollection rules = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,number,name", (QFilter[])qFilter.toArray());
                HashMap<Long, DynamicObject> ruleMap = new HashMap<Long, DynamicObject>(16);
                for (DynamicObject rule : rules) {
                    ruleMap.put(rule.getLong("id"), rule);
                }
                Object[] allocateEntity = new DynamicObject[res.size()];
                int index = 0;
                for (String re : res) {
                    String[] splits = re.split("\\|");
                    long tempId = Long.parseLong(splits[0]);
                    long ruleId = Long.parseLong(splits[1]);
                    int seq = tempRuleSizeMap.get(tempId) == null ? 0 : (Integer)tempRuleSizeMap.get(tempId) + 1;
                    tempRuleSizeMap.put(tempId, seq);
                    allocateEntity[index] = BusinessDataServiceHelper.newDynamicObject((String)"bcm_brallocateentity");
                    if (this.isNormalTemplate()) {
                        allocateEntity[index].set("template", (Object)tempId);
                    }
                    if (this.isInvTemplate() || this.isIntrTemplate()) {
                        allocateEntity[index].set("papertemplate", (Object)tempId);
                    }
                    allocateEntity[index].set("bizrule", (Object)ruleId);
                    allocateEntity[index].set("model", (Object)modelId);
                    allocateEntity[index].set("execseq", (Object)seq);
                    allocateEntity[index].set("execwhenopen", (Object)openExec);
                    allocateEntity[index].set("execwhensave", (Object)saveExec);
                    allocateEntity[index].set("modifier", (Object)RequestContext.get().getCurrUserId());
                    allocateEntity[index].set("modifydate", (Object)TimeServiceHelper.now());
                    DynamicObject ruleDyn = (DynamicObject)ruleMap.get(ruleId);
                    if (ruleDyn != null) {
                        String logs = String.format("%s %s,%s%s", ruleDyn.getString("number"), ruleDyn.getString("name"), OpItemEnum.SEND.getName(), ResultStatusEnum.SUCCESS.getName());
                        OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.SEND.getName(), (String)logs, (Long)modelId);
                    }
                    ++index;
                }
                BusinessDataWriter.save((IDataEntityType)allocateEntity[0].getDataEntityType(), (Object[])allocateEntity);
            }
        }
    }

    private String getAllocateKey(DynamicObject record) {
        if (this.isNormalTemplate()) {
            return record.getString("template.id") + SPLIT + record.getString("bizrule.id");
        }
        if (this.isInvTemplate() || this.isIntrTemplate()) {
            return record.getString("papertemplate.id") + SPLIT + record.getString("bizrule.id");
        }
        return "";
    }

    private QFilter getTemplateQFilter(List<String> templateIdList) {
        if (this.isNormalTemplate()) {
            return new QFilter("template", "in", (Object)ConvertUtil.convertListToLong(templateIdList));
        }
        if (this.isInvTemplate() || this.isIntrTemplate()) {
            return new QFilter("papertemplate", "in", (Object)ConvertUtil.convertListToLong(templateIdList));
        }
        return new QFilter("1", "=", (Object)0);
    }

    private List<String> getRealRule(List<String> rules) {
        HashSet<String> newRules = new HashSet<String>();
        for (String rule : rules) {
            if (rule.contains(",")) {
                newRules.add(rule.split(",")[0]);
                continue;
            }
            newRules.add(rule);
        }
        return new ArrayList<String>(newRules);
    }

    private void antiAllocate() {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = eg.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5206\u914d\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleAllocatePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (int row : selectRows) {
            ids.add((Long)this.getModel().getValue("id", row));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"id, template, bizrule.id, bizrule.number,bizrule.name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_brallocateentity"), (Object[])ids.toArray());
        this.backSendOpLog(dynamicObjects, ResultStatusEnum.SUCCESS.getName());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u6210\u529f\u3002", (String)"BizRuleAllocatePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        this.refreshBillList();
        eg.clearEntryState();
        this.updateAllocateRecord();
    }

    private void backSendOpLog(DynamicObjectCollection dynamicObjects, String status) {
        long modelId = this.getModelId();
        for (DynamicObject dy : dynamicObjects) {
            String name = dy.getString("bizrule.name");
            String number = dy.getString("bizrule.number");
            String logs = String.format("%s %s,%s%s", number, name, OpItemEnum.BACKSEND.getName(), status);
            OperationLogUtil.writeOperationLog((IFormView)this.getView(), (String)OpItemEnum.BACKSEND.getName(), (String)logs, (Long)modelId);
        }
    }

    private void updateAllocateRecord() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList ids = new ArrayList();
        entryEntity.forEach(e -> ids.add(e.getLong("id")));
        Object[] records = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_brallocateentity"));
        for (int i = 0; i < records.length; ++i) {
            records[i].set("execseq", (Object)(i + 1));
            records[i].set("modifier", (Object)RequestContext.get().getUserId());
            records[i].set("modifydate", (Object)TimeServiceHelper.now());
        }
        if (records.length > 0) {
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_brallocateentity"), (Object[])records);
        }
    }

    private void updateHeader(String newView) {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if ("20".equals(newView)) {
            grid.setColumnProperty("temp_name", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u540d\u79f0", (String)"NewBizRuleAllocatePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("temp_number", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u7f16\u7801", (String)"NewBizRuleAllocatePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("rule_number", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"NewBizRuleAllocatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("rule_name", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"NewBizRuleAllocatePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
        } else {
            grid.setColumnProperty("temp_name", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"NewBizRuleAllocatePlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("temp_number", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"NewBizRuleAllocatePlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("rule_name", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u540d\u79f0", (String)"NewBizRuleAllocatePlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
            grid.setColumnProperty("rule_number", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u7f16\u7801", (String)"NewBizRuleAllocatePlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0])));
        }
    }

    private void updateCache(String key, String newValue) {
        String cacheStr = this.getPageCache().get(CACHE_UPDATE_DATA);
        Map<String, String> updateMap = new HashMap<String, String>(16);
        if (!StringUtils.isEmpty((CharSequence)cacheStr)) {
            updateMap = (Map)this.deSerializedBytes(cacheStr);
        }
        updateMap.put(key, newValue);
        this.getPageCache().put(CACHE_UPDATE_DATA, this.toByteSerialized(updateMap));
    }

    private Map<String, String> getAllocateCache() {
        String cacheStr = this.getPageCache().get(CACHE_UPDATE_DATA);
        Map<String, String> updateMap = new HashMap<String, String>(16);
        if (!StringUtils.isEmpty((CharSequence)cacheStr)) {
            updateMap = (Map)this.deSerializedBytes(cacheStr);
        }
        return updateMap;
    }

    private void updateAllocate() {
        Map<String, String> cache = this.getAllocateCache();
        if (cache.size() > 0) {
            DynamicObject[] loads;
            ArrayList<String> des = new ArrayList<String>(cache.size());
            for (DynamicObject load : loads = BusinessDataServiceHelper.load((Object[])ConvertUtil.convertListToLong(cache.keySet()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_brallocateentity"))) {
                String key = load.getString("id");
                String newExecType = cache.get(key);
                String execDes = "";
                if ("3".equals(newExecType)) {
                    load.set("execwhenopen", (Object)true);
                    load.set("execwhensave", (Object)true);
                    execDes = ResManager.loadKDString((String)"\u6253\u5f00\u548c\u4fdd\u5b58\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_9", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                } else if ("2".equals(newExecType)) {
                    load.set("execwhenopen", (Object)false);
                    load.set("execwhensave", (Object)true);
                    execDes = ResManager.loadKDString((String)"\u4fdd\u5b58\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                } else if ("4".equals(newExecType)) {
                    load.set("execwhenopen", (Object)false);
                    load.set("execwhensave", (Object)false);
                    execDes = ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c", (String)"NewBizRuleAllocatePlugin_10", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                } else {
                    load.set("execwhenopen", (Object)true);
                    load.set("execwhensave", (Object)false);
                    execDes = ResManager.loadKDString((String)"\u6253\u5f00\u65f6\u6267\u884c", (String)"NewBizRuleAllocatePlugin_8", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                }
                load.set("modifier", (Object)RequestContext.get().getCurrUserId());
                load.set("modifydate", (Object)TimeServiceHelper.now());
                des.add(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\uff1a%1s \u4e1a\u52a1\u89c4\u5219\uff1a%2s, \u6267\u884c\u65b9\u5f0f%3s \u4fdd\u5b58\u6210\u529f", (String)"NewBizRuleAllocatePlugin_12", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), load.getString("template.number"), load.getString("bizrule.number"), execDes));
            }
            SaveServiceHelper.save((DynamicObject[])loads);
            OperationLogUtil.batchWriteOperationLog((IFormView)this.getView(), (String)OpItemEnum.EDIT.getName(), des, (Long)this.getModelId());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"NewBizRuleAllocatePlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(TEM_CATALOG_TREE);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList hitNode = new ArrayList();
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (CollectionUtils.isNotEmpty(hitNode)) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                tree.focusNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u5e76\u91cd\u65b0\u641c\u7d22\u3002", (String)"NewBizRuleAllocatePlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(TEM_CATALOG_TREE);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                if (i > 0) {
                    if (result.getPrevious() != null) {
                        tree.uncheckNode(result.getPrevious().getId());
                    }
                } else if (result.getNext() != null) {
                    tree.uncheckNode(result.getNext().getId());
                }
                tree.treeNodeClick(next.getParentid(), next.getId());
                tree.focusNode(next);
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void refreshBillList() {
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        TreeView temTree = (TreeView)this.getControl(TEM_CATALOG_TREE);
        TreeView ruleTree = (TreeView)this.getControl(BIZ_RULE_TREE);
        List selectedTemplates = temTree.getTreeState().getSelectedNodeId();
        List selectedRules = ruleTree.getTreeState().getSelectedNodeId();
        if (CollectionUtils.isNotEmpty((Collection)selectedTemplates)) {
            if (this.isNormalTemplate()) {
                modelFilter.and("template", "in", (Object)ConvertUtil.convertListToLong((Collection)selectedTemplates));
            }
            if (this.isInvTemplate() || this.isIntrTemplate()) {
                modelFilter.and("papertemplate", "in", (Object)ConvertUtil.convertListToLong((Collection)selectedTemplates));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)selectedRules)) {
            selectedRules.removeIf(rule -> rule.startsWith("root"));
            if (CollectionUtils.isNotEmpty((Collection)selectedRules)) {
                List newRules = selectedRules.stream().map(rule -> rule.contains(",") ? Long.valueOf(rule.split(",")[0]) : Long.valueOf(rule)).collect(Collectors.toList());
                modelFilter.and("bizrule", "in", newRules);
            } else {
                modelFilter.and("bizrule", "=", (Object)0);
            }
        }
        String selectFields = "id,template.id,template.number,template.name,bizrule.id,bizrule.number,bizrule.name,execwhenopen,execwhensave,papertemplate.id,papertemplate.number,papertemplate.name";
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"bcm_brallocateentity", (String)selectFields, (QFilter[])new QFilter[]{modelFilter, this.getExecTypeQf()}, (String)"createdate", (int)1000);
        String newNameMapStr = this.getPageCache().get(NEW_NAME_MAP);
        Map newNameMap = new HashMap(16);
        if (StringUtils.isNotEmpty((CharSequence)newNameMapStr)) {
            newNameMap = (Map)this.deSerializedBytes(newNameMapStr);
        }
        this.getView().getModel().deleteEntryData(ENTRY_ENTITY);
        String view = this.getModel().getValue(VIEW_COMBO).toString();
        if (CollectionUtils.isNotEmpty((Collection)colls)) {
            this.getView().getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, colls.size());
            int row = 0;
            for (DynamicObject coll : colls) {
                this.getModel().setValue("id", (Object)coll.getLong("id"), row);
                String templateId = this.getTemplateProperty(coll, "id");
                String originalTemplateName = this.getTemplateProperty(coll, "name");
                String templateName = newNameMap.get(templateId) == null ? originalTemplateName : (String)newNameMap.get(templateId);
                String templateNumber = this.getTemplateProperty(coll, "number");
                if ("20".equals(view)) {
                    this.getModel().setValue("temp_number", (Object)coll.getString("bizrule.number"), row);
                    this.getModel().setValue("temp_name", (Object)coll.getString("bizrule.name"), row);
                    this.getModel().setValue("rule_number", (Object)templateNumber, row);
                    this.getModel().setValue("rule_name", (Object)templateName, row);
                } else {
                    this.getModel().setValue("temp_number", (Object)templateNumber, row);
                    this.getModel().setValue("temp_name", (Object)templateName, row);
                    this.getModel().setValue("rule_number", (Object)coll.getString("bizrule.number"), row);
                    this.getModel().setValue("rule_name", (Object)coll.getString("bizrule.name"), row);
                }
                if (coll.getBoolean("execwhenopen") && coll.getBoolean("execwhensave")) {
                    this.getModel().setValue("exec_type", (Object)"3", row);
                } else if (!coll.getBoolean("execwhenopen") && !coll.getBoolean("execwhensave")) {
                    this.getModel().setValue("exec_type", (Object)"4", row);
                } else {
                    this.getModel().setValue("exec_type", (Object)(coll.getBoolean("execwhenopen") ? "1" : "2"), row);
                }
                ++row;
            }
            this.getView().getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private String getTemplateProperty(DynamicObject coll, String propertyName) {
        if (this.isNormalTemplate()) {
            return coll.getString(String.format("template.%s", propertyName));
        }
        if (this.isInvTemplate() || this.isIntrTemplate()) {
            return coll.getString(String.format("papertemplate.%s", propertyName));
        }
        return "";
    }

    private boolean isInvTemplate() {
        return "2".equals(String.valueOf(this.getModel().getValue("templatetype")));
    }

    private boolean isIntrTemplate() {
        return "3".equals(String.valueOf(this.getModel().getValue("templatetype")));
    }

    private boolean isNormalTemplate() {
        return "1".equals(String.valueOf(this.getModel().getValue("templatetype")));
    }

    private void refreshRuleTree() {
        TreeView tree = (TreeView)this.getControl(BIZ_RULE_TREE);
        tree.deleteAllNodes();
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("templatetype")))) {
            this.getPageCache().put(CATALOG_ID_LIST, ObjectSerialUtil.toByteSerialized(new ArrayList()));
            this.getPageCache().put(BIZ_RULE_TREE, SerializationUtils.toJsonString((Object)new TreeNode()));
            return;
        }
        this.initTree();
    }

    private void initTree() {
        long modelId = this.getModelId();
        TreeNode rootNode = new TreeNode();
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
        ArrayList<String> catalogList = new ArrayList<String>();
        String selectFields = "id,name,number,parent,longnumber";
        ArrayList memberList = Lists.newArrayList((Object[])new String[]{"IRpt", "RAdj", "EIRpt", "ERAdj"});
        if (this.isCM()) {
            memberList.add("CSTE");
        }
        String orderBys = "dseq";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter numberId = new QFilter("number", "in", (Object)memberList);
        QFilter fstoragetype = new QFilter("storagetype", "=", (Object)StorageTypeEnum.UNSHARE.index);
        List<String> notBizRuleProcess = Arrays.asList("TCF", "BPNone", "TARPT");
        QFilter bizruleProcess = new QFilter("isbizrule", "=", (Object)Boolean.TRUE).and("isleaf", "=", (Object)Boolean.TRUE).and("number", "not in", notBizRuleProcess);
        notBizRuleProcess.forEach(p -> bizruleProcess.and(QFilter.notLike((String)"longnumber", (String)String.format("!%s!", p))));
        QFilter[] filters = this.isInvTemplate() ? new QFilter[]{fmodelid, bizruleProcess} : (this.isIntrTemplate() ? new QFilter[]{fmodelid, new QFilter("isbizrule", "=", (Object)Boolean.TRUE).and("isleaf", "=", (Object)Boolean.TRUE).and("number", "=", (Object)"ADJ")} : new QFilter[]{fmodelid, numberId, fstoragetype});
        DynamicObjectCollection processItems = QueryServiceHelper.query((String)"bcm_processmembertree", (String)selectFields, (QFilter[])filters, (String)orderBys);
        if (CollectionUtils.isEmpty((Collection)processItems)) {
            return;
        }
        List processIds = processItems.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter deleteStatusQf = new QFilter("bizrule.deletestatus", "=", (Object)false);
        QFilter memberQf = new QFilter("member", "in", processIds);
        QFilter execTypeQf = this.getExecTypeQf();
        DynamicObjectCollection bizrules = QueryServiceHelper.query((String)"bcm_bizrulealloprocess", (String)"id,bizrule.id,bizrule.name,bizrule.number,bizrule.executetype,member", (QFilter[])new QFilter[]{modelQf, deleteStatusQf, memberQf, execTypeQf}, (String)"execsort");
        if (CollectionUtils.isNotEmpty((Collection)processItems)) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            StringBuilder stringBuilder = new StringBuilder();
            processItems.sort((o1, o2) -> {
                String longnumber1 = o1.getString("longnumber");
                String longnumber2 = o2.getString("longnumber");
                String[] split1 = longnumber1.split("!");
                String[] split2 = longnumber2.split("!");
                for (int i = 0; i < Math.min(split1.length, split2.length); ++i) {
                    if (!split1[i].equals(split2[i])) {
                        return Integer.compare(this.getSeq(modelNum, split1[i], stringBuilder.toString()), this.getSeq(modelNum, split2[i], stringBuilder.toString()));
                    }
                    stringBuilder.append(split1[i]);
                }
                return 0;
            });
            rootNode.setId("0");
            rootNode.setText(ResManager.loadKDString((String)"\u89c4\u5219\u5206\u7c7b", (String)"BizRuleAllocatePlugin_11", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            rootNode.setParentid("");
            if (!bizrules.isEmpty()) {
                this.generateTree(rootNode, (DynamicObject[])bizrules.toArray((Object[])new DynamicObject[0]), processItems, treeList, catalogList);
                this.dealSameTreeNode(treeList);
            } else {
                catalogList.add(rootNode.getId());
            }
        }
        BCMTreeUtils.setEntryNode((TreeNode)rootNode, treeList, (String)rootNode.getId());
        BCMTreeUtils.spreadAllNode((TreeNode)rootNode);
        TreeView tree = (TreeView)this.getControl(BIZ_RULE_TREE);
        tree.addNode(rootNode);
        this.getPageCache().put(CATALOG_ID_LIST, ObjectSerialUtil.toByteSerialized(catalogList));
        this.getPageCache().put(BIZ_RULE_TREE, SerializationUtils.toJsonString((Object)rootNode));
    }

    private int getSeq(String modelNum, String member, String prefix) {
        return (Integer)ThreadCache.get((Object)(prefix + member), () -> MemberReader.findProcessMemberByNum((String)modelNum, (String)member).getdSeq());
    }

    private QFilter getExecTypeQf() {
        switch (String.valueOf(this.getModel().getValue("templatetype"))) {
            case "1": {
                return new QFilter("bizrule.executetype", "in", Arrays.asList(BizRuleExecuteTypeEnum.ALL.getCode(), BizRuleExecuteTypeEnum.RPT_ONLY.getCode(), BizRuleExecuteTypeEnum.XSYN_ONLY.getCode()));
            }
            case "2": {
                return new QFilter("bizrule.executetype", "=", (Object)BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode());
            }
            case "3": {
                return new QFilter("bizrule.executetype", "=", (Object)BizRuleExecuteTypeEnum.INTR_ONLY.getCode());
            }
        }
        return new QFilter("1", "=", (Object)0);
    }

    private void dealSameTreeNode(List<Map<String, String>> treeList) {
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> repeatIds = new HashSet<String>();
        for (Map<String, String> nodeMap : treeList) {
            if (ids.contains(nodeMap.get("id"))) {
                repeatIds.add(nodeMap.get("id"));
                continue;
            }
            ids.add(nodeMap.get("id"));
        }
        for (Map<String, String> node : treeList) {
            if (!repeatIds.contains(node.get("id"))) continue;
            node.put("id", node.get("id") + "," + GlobalIdUtil.genGlobalLongId());
        }
    }

    private void generateTree(TreeNode rootNode, DynamicObject[] bizrules, DynamicObjectCollection processItems, List<Map<String, String>> treeList, List<String> catalogList) {
        List mountedNode = BizRuleConstant.EXECUTE_TYPES.stream().map(BizRuleExecuteTypeEnum::getCode).collect(Collectors.toList());
        String templateType = this.getModel().getValue("templatetype").toString();
        if ("1".equals(templateType)) {
            for (DynamicObject process : processItems) {
                treeList.add(this.convertCatalog2Map(process, rootNode.getId()));
                if (!catalogList.contains(process.getString("id"))) {
                    catalogList.add(process.getString("id"));
                }
                TreeNode node = new TreeNode();
                node.setId(process.getString("id"));
                for (DynamicObject bizrule : bizrules) {
                    if (!this.isIncludeProcessCatalog(node, bizrule) || mountedNode.contains(bizrule.getString("bizrule.executetype"))) continue;
                    treeList.add(this.convertProcessBizRule2Map(bizrule, node.getId()));
                }
            }
            treeList.add(this.addMountedCatalog(BizRuleExecuteTypeEnum.XSYN_ONLY));
            for (DynamicObject bizrule : bizrules) {
                if (!BizRuleExecuteTypeEnum.XSYN_ONLY.getCode().equals(bizrule.getString("bizrule.executetype"))) continue;
                treeList.add(this.convertProcessBizRule2Map(bizrule, BizRuleExecuteTypeEnum.XSYN_ONLY.getCode()));
            }
        } else if ("2".equals(templateType)) {
            treeList.add(this.addMountedCatalog(BizRuleExecuteTypeEnum.EQUITY_ONLY));
            for (DynamicObject bizrule : bizrules) {
                if (!BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode().equals(bizrule.getString("bizrule.executetype"))) continue;
                treeList.add(this.convertProcessBizRule2Map(bizrule, BizRuleExecuteTypeEnum.EQUITY_ONLY.getCode()));
            }
        } else if ("3".equals(templateType)) {
            treeList.add(this.addMountedCatalog(BizRuleExecuteTypeEnum.INTR_ONLY));
            for (DynamicObject bizrule : bizrules) {
                if (!BizRuleExecuteTypeEnum.INTR_ONLY.getCode().equals(bizrule.getString("bizrule.executetype"))) continue;
                treeList.add(this.convertProcessBizRule2Map(bizrule, BizRuleExecuteTypeEnum.INTR_ONLY.getCode()));
            }
        }
        if (this.isCM()) {
            treeList.add(this.addMountedRootCatalog());
        }
    }

    private Map<String, String> convertProcessBizRule2Map(DynamicObject dynaObj, String parentId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", dynaObj.getString("bizrule.id"));
        map.put("name", dynaObj.getString("bizrule.number") + " " + dynaObj.getString("bizrule.name"));
        map.put("number", dynaObj.getString("bizrule.number"));
        map.put("parentid", parentId);
        return map;
    }

    private Map<String, String> convertCatalog2Map(DynamicObject dynaObj, String parent) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", dynaObj.getString("id"));
        map.put("name", dynaObj.getString("number") + " " + dynaObj.getString("name"));
        map.put("number", dynaObj.getString("number"));
        map.put("parentid", dynaObj.getString("parent"));
        if (parent != null) {
            map.put("parentid", parent);
        }
        return map;
    }

    private Map<String, String> addMountedRootCatalog() {
        HashMap<String, String> mountedNode = new HashMap<String, String>(4);
        mountedNode.put("id", "-2");
        mountedNode.put("number", "mounted");
        mountedNode.put("name", ResManager.loadKDString((String)"\u6302\u8f7d\u5f0f", (String)"BizRuleListPlugin_56", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        mountedNode.put("parentid", "0");
        mountedNode.put("isleaf", "0");
        return mountedNode;
    }

    private Map<String, String> addMountedCatalog(BizRuleExecuteTypeEnum executeTypeEnum) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", executeTypeEnum.getCode());
        map.put("name", executeTypeEnum.getDescription());
        map.put("number", executeTypeEnum.getShowNumber());
        map.put("parentid", "-2");
        return map;
    }

    private boolean isIncludeProcessCatalog(TreeNode rootNode, DynamicObject bizrule) {
        return String.valueOf(bizrule.get("member")).equals(rootNode.getId());
    }

    @Override
    public long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelid");
        return Long.parseLong(modelId);
    }

    private List<Map<String, String>> getTemplatecatalogList() {
        DynamicObjectCollection doc = this.getAllTemplateCatologs();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>();
        for (DynamicObject dd : doc) {
            if ("0".equals(dd.getString("parent")) && (dd.getString("longnumber") == null || "".equals(dd.getString("longnumber")))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObjectCollection getAllTemplateCatologs() {
        if (this.isNormalTemplate()) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            QFilter[] filters = new QFilter[]{filter, TemplateCatalogTypeEnum.getTemplateCalcogFilter()};
            String selectFields = "id,parent,name,longnumber,number";
            String orderBys = "longnumber";
            return QueryServiceHelper.query((String)"bcm_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        if (this.isInvTemplate()) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            QFilter invFilter = new QFilter("longnumber", "=", (Object)"root").or(QFilter.like((String)"longnumber", (String)"root.InvElim%"));
            QFilter[] filters = new QFilter[]{filter, invFilter};
            String selectFields = "id,parent,name,longnumber,number";
            String orderBys = "longnumber";
            return QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        if (this.isIntrTemplate()) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            QFilter invFilter = new QFilter("longnumber", "=", (Object)"root").or(QFilter.like((String)"longnumber", (String)"root.InnerTrade%"));
            QFilter[] filters = new QFilter[]{filter, invFilter};
            String selectFields = "id,parent,name,longnumber,number";
            String orderBys = "longnumber";
            return QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        return new DynamicObjectCollection();
    }

    private DynamicObjectCollection getTemplateCollection() {
        DynamicObjectCollection queryResult = this.getAllTemplates();
        DynamicObjectCollection result = new DynamicObjectCollection();
        HashSet groupIds = Sets.newHashSet();
        HashMap groupDynMap = new HashMap(8);
        HashMap newNameMap = new HashMap(16);
        this.getPageCache().remove(NEW_NAME_MAP);
        queryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            if (groupIds.add(groupId)) {
                result.add(c);
                groupDynMap.put(groupId, c);
            } else {
                ((DynamicObject)groupDynMap.get(groupId)).set("name", (Object)c.getString("name"));
                newNameMap.put(((DynamicObject)groupDynMap.get(groupId)).getString("id"), c.getString("name"));
            }
        });
        if (newNameMap.size() > 0) {
            this.getPageCache().put(NEW_NAME_MAP, this.toByteSerialized(newNameMap));
        }
        return result;
    }

    private DynamicObjectCollection getAllTemplates() {
        switch (String.valueOf(this.getModel().getValue("templatetype"))) {
            case "1": {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
                filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
                String selectFields = "id,name,templatecatalog,number,group";
                return QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])filter.toArray(), (String)"sequence,number,versionnumber");
            }
            case "2": {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId()).and("status", "in", Arrays.asList(PaperTemplateStatusEnum.ENABLE.getStatusValue(), PaperTemplateStatusEnum.DISABLE.getStatusValue())).and("templatecatalog.longnumber", "like", (Object)"root.InvElim%");
                String selectFields = "id,name,templatecatalog,number,group";
                return QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])filter.toArray(), (String)"sequence,number,versionnumber");
            }
            case "3": {
                QFilter filter = new QFilter("model", "=", (Object)this.getModelId()).and("status", "in", Arrays.asList(PaperTemplateStatusEnum.ENABLE.getStatusValue(), PaperTemplateStatusEnum.DISABLE.getStatusValue())).and("templatecatalog.longnumber", "like", (Object)"root.InnerTrade%");
                String selectFields = "id,name,templatecatalog,number,group";
                return QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])filter.toArray(), (String)"sequence,number,versionnumber");
            }
        }
        return new DynamicObjectCollection();
    }

    private void findNode(String nodeId, TreeNode treeNode, List<TreeNode> treeNodes) {
        if (treeNode.getId().contains(nodeId)) {
            treeNodes.add(treeNode);
        } else if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode child : treeNode.getChildren()) {
                this.findNode(nodeId, child, treeNodes);
            }
        }
    }

    private void findNodeChildren(String nodeId, TreeNode treeNode, List<TreeNode> treeNodes) {
        if (treeNode.getId().equals(nodeId)) {
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNodes.addAll(treeNode.getChildren());
            }
        } else if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode node : treeNode.getChildren()) {
                this.findNodeChildren(nodeId, node, treeNodes);
            }
        }
    }
}

