/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class AbstractConfigBatchPlugin
extends AbstractBaseFormPlugin {
    protected String getConfigNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("ConfigNumber");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().beginInit();
        ConfigEnum config = ConfigEnum.getConfigDataByNumber((String)this.getConfigNumber());
        this.getModel().setValue("number", (Object)config.getNumber());
        this.getModel().setValue("name", (Object)config.getName());
        this.getModel().setValue("description", (Object)config.getDescription());
        this.getModel().setValue("model", (Object)this.getModelId());
        this.getModel().endInit();
        this.initPageModel();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPageModel();
    }

    protected void initPageModel() {
        Map<String, Map<String, Object>> childparams = this.getChildParams();
        DynamicObjectCollection childparamDys = this.getModel().getEntryEntity("entryentity");
        Map<String, DynamicObject> childnumbers = childparamDys.stream().collect(Collectors.toMap(p -> p.getString("businesstypevalue"), p -> p));
        childparams.forEach((number, configParams) -> {
            boolean isAddNew = false;
            DynamicObject configDy = (DynamicObject)childnumbers.get(number);
            if (configDy == null) {
                isAddNew = true;
                configDy = childparamDys.addNew();
            }
            for (Map.Entry map : configParams.entrySet()) {
                if (!isAddNew && StringUtils.equals((CharSequence)"isshow", (CharSequence)((CharSequence)map.getKey()))) continue;
                configDy.set((String)map.getKey(), map.getValue());
            }
        });
        this.getModel().clearNoDataRow();
        this.getView().updateView("entryentity");
    }

    protected Map<String, Map<String, Object>> getChildParams() {
        return ChildConfigEnum.getValuesByConfigNumber((String)this.getConfigNumber()).stream().collect(Collectors.toMap(p -> p.getBusinesstypevalue(), p -> new HashMap<String, Object>(16){
            {
                super(x0);
                this.put("presetname", LanguageUtil.getValue((String)p.getPresetname(), (String)("ChildConfigEnum_" + p.getBusinesstypevalue()), (String)"fi-bcm-business"));
                this.put("entrydescription", LanguageUtil.getValue((String)p.getEntrydescription(), (String)("ChildConfigEnum_des_" + p.getBusinesstypevalue()), (String)"fi-bcm-business"));
                this.put("isshow", p.isConfig());
                this.put("businesstypevalue", p.getBusinesstypevalue());
            }
        }));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
            qfBuilder.add("number", "=", (Object)this.getConfigNumber());
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"config,modifier,modifytime", (QFilter[])qfBuilder.toArray());
            dy.set("modifier", (Object)RequestContext.getOrCreate().getUserId());
            dy.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            ConfigServiceHelper.cacheIt((Long)this.getModelId(), (String)this.getConfigNumber(), (Object)dy.get("config"));
            DynamicObjectCollection childparamDys = this.getModel().getEntryEntity("entryentity");
            childparamDys.forEach(childparamDy -> ConfigServiceHelper.cacheIt((Long)this.getModelId(), (String)this.getConfigNumber(), (String)childparamDy.getString("businesstypevalue"), (Object)childparamDy.get("isshow")));
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }
}

