/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BusinessTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class AdjustBizTypeConfigPlugin
extends AbstractBaseFormPlugin {
    private static final String PRESETNAME = "presetname";
    private static final String ISSHOW = "isshow";
    private static final String ENTRYENTITY = "entryentity";
    public static final List<String> EICA_LIST = Arrays.asList(BusinessTypeEnum.OFFSETEICA.getName(), BusinessTypeEnum.OFFSETEIT.getName(), BusinessTypeEnum.OFFSETECF.getName(), BusinessTypeEnum.OFFSETEOE.getName(), BusinessTypeEnum.OFFSETEOther.getName());

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnsave");
    }

    @Override
    public void afterBindData(EventObject e) {
        this.setBasicInfo();
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnsave"});
        }
    }

    private void setBasicInfo() {
        this.getPageCache().put("isAdd", "true");
        this.getModel().beginInit();
        this.getModel().setValue("number", (Object)ConfigEnum.CM005.getNumber());
        this.getModel().setValue("name", (Object)ConfigEnum.CM005.getName());
        this.getModel().setValue("description", (Object)ConfigEnum.CM005.getDescription());
        this.getModel().setValue("model", (Object)this.getModelId());
        HashSet noContainsPr = Sets.newHashSetWithExpectedSize((int)8);
        noContainsPr.add(BusinessTypeEnum.RPTADJUSTSELFLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.ADJUSTCROSSLEVEL.getName());
        noContainsPr.add(BusinessTypeEnum.PADJ.getName());
        IDNumberTreeNode eje = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"EJE");
        if (eje.isLeaf()) {
            noContainsPr.add(BusinessTypeEnum.OFFSETEICA.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEIT.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOE.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETECF.getName());
            noContainsPr.add(BusinessTypeEnum.OFFSETEOther.getName());
        } else {
            noContainsPr.add(BusinessTypeEnum.ADJUSTOFFSETLEVEL.getName());
        }
        DynamicObjectCollection entry = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
        HashSet existBussSet = Sets.newHashSetWithExpectedSize((int)4);
        entry.removeIf(dy -> {
            if (noContainsPr.contains(dy.getString("businesstypevalue"))) {
                return true;
            }
            existBussSet.add(dy.getString("businesstypevalue"));
            return false;
        });
        for (BusinessTypeEnum bustype : BusinessTypeEnum.values()) {
            if (noContainsPr.contains(bustype.getName()) || existBussSet.contains(bustype.getName())) continue;
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue(PRESETNAME, (Object)bustype.getText(), index);
            this.getModel().setValue("showname", (Object)bustype.getText(), index);
            this.getModel().setValue("entrydescription", (Object)bustype.getDescription(), index);
            this.getModel().setValue("businesstypevalue", (Object)bustype.getName(), index);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        this.getModel().clearNoDataRow();
        if (entry != null && entry.size() > 0) {
            String pageId = this.getView().getPageId();
            IPageCache pageCache = this.getPageCache();
            for (DynamicObject row : entry) {
                pageCache.put(row.getString(PRESETNAME) + pageId, row.getString(ISSHOW));
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObjectCollection entry;
        super.beforeClosed(e);
        if (this.getPageCache().get("isAdd") != null) {
            e.setCheckDataChange(false);
        }
        if ((entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY)) != null && entry.size() > 0) {
            IPageCache pageCache = this.getPageCache();
            String pageId = this.getView().getPageId();
            for (DynamicObject row : entry) {
                String originStatus = pageCache.get(row.getString(PRESETNAME) + pageId);
                if (!StringUtils.isNotEmpty((CharSequence)originStatus)) continue;
                pageCache.remove(row.getString(PRESETNAME) + pageId);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            boolean hasShow = false;
            for (DynamicObject dy : entryEntity) {
                if (dy.getBoolean(ISSHOW)) {
                    hasShow = true;
                }
                if (!StringUtils.isBlank((CharSequence)dy.getString("showname"))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustBizTypeConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (!hasShow) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u4e2d\u4e00\u9879\u3002", (String)"AdjustBizTypeConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("save".equals(key)) {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
            qfBuilder.add("number", "=", (Object)"CM005");
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"config,modifier,modifytime", (QFilter[])qfBuilder.toArray());
            dy.set("modifier", (Object)RequestContext.getOrCreate().getUserId());
            dy.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
            ConfigServiceHelper.cacheIt((Long)this.getModelId(), (String)"CM005", (Object)dy.get("config"));
            DynamicObjectCollection entry = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
            IPageCache pageCache = this.getPageCache();
            IFormView view = this.getView();
            long modelId = this.getModelId();
            OperationLogUtil.writeConfigLog((DynamicObjectCollection)entry, (IPageCache)pageCache, (IFormView)view, (long)modelId, (boolean)false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isAdd") != null) {
            this.getPageCache().remove("isAdd");
        }
        if (ISSHOW.equals(e.getProperty().getName())) {
            int row = e.getChangeSet()[0].getRowIndex();
            if (BusinessTypeEnum.EADJ.getName().equals(this.getModel().getValue("businesstypevalue", row))) {
                this.getModel().setValue(ISSHOW, (Object)true, row);
            }
        }
    }
}

