/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Delete;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.IOperationLog;

public class BgConfigListPlugin
extends AbstractListPlugin
implements IOperationLog {
    private static String CURMODEL = "curmodel";
    private static String CONFIGMAP = "configmap";
    private static final String BILL_LIST_AP = "billlistap";

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "openconfigedit": {
                BillList billList = (BillList)this.getView().getControl(BILL_LIST_AP);
                if (billList.getSelectedRows().size() > 0) {
                    Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
                    if (selectNodeIds == null) {
                        return;
                    }
                    if (selectNodeIds.length > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u6682\u4e0d\u652f\u6301\u591a\u884c\u3002", (String)"DimensionDisplayList_54", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.openView(selectNodeIds[0]);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"DmMyReportListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Delete de;
        DynamicObjectCollection dynamicObjectCollection;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete && (dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_configsetting", (String)"number,name,model.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)(de = (Delete)args.getSource()).getListSelectedData().getPrimaryKeyValues())})) != null && dynamicObjectCollection.size() > 0) {
            HashMap configMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
            for (DynamicObject cofigObject : dynamicObjectCollection) {
                long modelId = cofigObject.getLong("model.id");
                String number = cofigObject.getString("number");
                String name = cofigObject.getString("name");
                StringBuilder configBuilder = new StringBuilder();
                configBuilder.append(number);
                configBuilder.append("/");
                configBuilder.append(ResManager.loadKDString((String)name, (String)("ConfigEnum_" + number), (String)"fi-bcm-common", (Object[])new Object[0]));
                configMap.put(configBuilder.toString(), modelId);
                ConfigServiceHelper.remove((Long)modelId, (String)number);
            }
            this.getPageCache().put(CONFIGMAP, SerializationUtils.toJsonString((Object)configMap));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof Delete) {
            Map configMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(CONFIGMAP), Map.class);
            for (Map.Entry config : configMap.entrySet()) {
                this.getPageCache().put(CURMODEL, String.valueOf(config.getValue()));
            }
        }
    }

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescriotion) {
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    private void openView(Object pkid) {
        BaseShowParameter param = new BaseShowParameter();
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)"number,model", (QFilter[])new QFilter[]{new QFilter("id", "=", pkid)});
        Long modelId = dy.getLong("model");
        ConfigEnum configEnum = ConfigEnum.getConfigDataByNumber((String)dy.getString("number"));
        if (configEnum.getForm() == null) {
            param.setPkId(pkid);
            param.setFormId("bcm_configsetting");
        } else {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            qfBuilder.add("number", "=", (Object)configEnum.getNumber());
            param.setCustomParam("id", pkid);
            DynamicObject childconfig = QueryServiceHelper.queryOne((String)configEnum.getForm(), (String)"id", (QFilter[])qfBuilder.toArray());
            if (childconfig != null) {
                param.setCustomParam("id", (Object)childconfig.getLong("id"));
                param.setPkId((Object)childconfig.getLong("id"));
                param.setCustomParam("bcmconfigid", pkid);
            }
            param.setCustomParam("ConfigNumber", (Object)configEnum.getNumber());
            param.setFormId(configEnum.getForm());
        }
        param.setStatus(OperationStatus.EDIT);
        param.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        this.getView().showForm((FormShowParameter)param);
    }
}

