/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.config.ConfigEditPlugin;

public class ConfigCM021EditPlugin
extends ConfigEditPlugin {
    private static final String ADD_ROW = "addrow";
    private static final String DELETE_ROW = "deleterow";
    private static final String ORGENTITY = "orgentity";
    private static final String ENTITY = "entity";
    private static final String RANGE_VALUE = "rangevalue";
    private static final String BASETYPE = "basedatatype";
    private static final String ORGNAME = "orgname";
    private static final String SYNCRPTCOMMIT = "syncrptcommit";
    private static final String JSON = "json";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_ROW, DELETE_ROW});
        EntryGrid eg = (EntryGrid)this.getControl(ORGENTITY);
        BasedataEdit orgedit = (BasedataEdit)eg.getControls().get(0);
        orgedit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and(new QFilter("enable", "=", (Object)"1"));
            listShowParameter.getListFilterParameter().setFilter(qf);
        });
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addrow": {
                this.showSelectOrgView();
                break;
            }
            case "deleterow": {
                this.deleteOrgMember();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(ORGENTITY);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
            }
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection origindata = this.getModel().getEntryEntity(ORGENTITY);
        EntryGrid eg = (EntryGrid)this.getControl(ORGENTITY);
        TextEdit te = (TextEdit)eg.getItems().get(1);
        int i = 0;
        for (DynamicObject data : origindata) {
            te.setEnable("", Boolean.FALSE.booleanValue(), i++);
            data.set(ORGNAME, (Object)data.getLocaleString("entity.name"));
        }
        this.getModel().setValue(ORGENTITY, (Object)origindata);
        this.setParamVisiable();
        if (this.getModel().getDataEntityType().getProperties().containsKey((Object)SYNCRPTCOMMIT)) {
            if (this.getModel().getValue(JSON) == null) {
                this.getModel().beginInit();
                this.getModel().setValue(SYNCRPTCOMMIT, (Object)ConfigServiceHelper.resolverConfigParam((Object)this.getModel().getValue("config")));
                this.getModel().endInit();
            }
            this.getView().setEnable(Boolean.valueOf(ConfigServiceHelper.resolverConfigParam((Object)this.getModel().getValue("config"))), new String[]{SYNCRPTCOMMIT});
            this.getView().updateView(SYNCRPTCOMMIT);
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void setParamVisiable() {
        Control control = this.getView().getControl(SYNCRPTCOMMIT);
        if (Objects.nonNull(control) && ("CM043".equals(this.getModel().getValue("number")) || "CM004".equals(this.getModel().getValue("number")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNCRPTCOMMIT});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        if (key.equalsIgnoreCase(ENTITY)) {
            IDataModel model = this.getModel();
            if (Objects.nonNull(data.getNewValue())) {
                DynamicObject entity = (DynamicObject)data.getNewValue();
                model.setValue(ORGNAME, (Object)entity.getLocaleString("name"), data.getRowIndex());
            } else {
                model.setValue(ORGNAME, (Object)"", data.getRowIndex());
            }
        } else if (key.equalsIgnoreCase("config")) {
            if (this.getModel().getDataEntityType().getProperties().containsKey((Object)SYNCRPTCOMMIT)) {
                this.getModel().beginInit();
                this.getModel().setValue(SYNCRPTCOMMIT, (Object)ConfigServiceHelper.resolverConfigParam((Object)this.getModel().getValue("config")));
                this.getModel().endInit();
            }
            this.getView().setEnable(Boolean.valueOf(ConfigServiceHelper.resolverConfigParam((Object)this.getModel().getValue("config"))), new String[]{SYNCRPTCOMMIT});
            this.getView().updateView(SYNCRPTCOMMIT);
        }
    }

    private void showSelectOrgView() {
        long modelId = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"RptParamConfigPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectmember");
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.setCustomParam("isHiddenLocalradio", (Object)Boolean.TRUE.toString());
        this.getView().showForm(formShowParameter);
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(ORGENTITY);
        TextEdit te = (TextEdit)eg.getItems().get(1);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            int i = -1;
            for (DynamicObject oldone : olddoc) {
                ++i;
                Object id = LongUtil.isvalidLong((Object)newone.get(4)) ? newone.get(4) : newone.get(6);
                if (!LongUtil.isvalidLong((Object)id) || !Objects.equals(id.toString(), oldone.getString("entity.id")) || !Objects.equals(newone.get(5), oldone.get(RANGE_VALUE))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(ORGENTITY);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue(ORGNAME, newone.get(3), index);
            model.setValue(RANGE_VALUE, newone.get(5), index);
            model.setValue(ORGNAME, newone.get(3), index);
            te.setEnable("", Boolean.FALSE.booleanValue(), index);
            if (LongUtil.isvalidLong((Object)newone.get(4))) {
                model.setValue(BASETYPE, (Object)"bcm_entitymembertree", index);
                model.setValue(ENTITY, newone.get(4), index);
            } else if (LongUtil.isvalidLong((Object)newone.get(6))) {
                model.setValue(BASETYPE, (Object)"bcm_userdefinedmembertree", index);
                model.setValue(ENTITY, newone.get(6), index);
            }
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.getModel().getDataEntityType().getProperties().containsKey((Object)SYNCRPTCOMMIT)) {
            HashMap<String, Object> json = new HashMap<String, Object>(16);
            json.put(SYNCRPTCOMMIT, this.getModel().getValue(SYNCRPTCOMMIT));
            this.getModel().setValue(JSON, (Object)SerializationUtils.toJsonString(json));
        }
    }

    @Override
    protected Map<String, Object> getjsonDATA(String configNumber) {
        HashMap<String, Object> json = new HashMap<String, Object>(16);
        if (this.getModel().getDataEntityType().getProperties().containsKey((Object)SYNCRPTCOMMIT)) {
            json.put(SYNCRPTCOMMIT, this.getModel().getValue(SYNCRPTCOMMIT));
            this.getModel().setValue(JSON, (Object)SerializationUtils.toJsonString(json));
        }
        return json;
    }

    @Override
    protected void setControlValue(Map<String, Object> additionfieldMap) {
        super.setControlValue(additionfieldMap);
        this.getModel().beginInit();
        if (additionfieldMap != null && additionfieldMap.size() > 0) {
            for (Map.Entry<String, Object> entry : additionfieldMap.entrySet()) {
                this.getModel().setValue(entry.getKey(), entry.getValue());
            }
        }
        this.getModel().endInit();
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(ORGENTITY);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"RptParamConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ORGENTITY, row);
    }
}

