/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.CM053SettingEnum;
import kd.fi.bcm.common.config.CM053TypeEnum;
import kd.fi.bcm.common.config.SceneSettingVo;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.config.ConfigEditPlugin;

public class ConfigCM044EditPlugin
extends ConfigEditPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String SCENE = "scene";
    private static final String SETTING = "setting";
    private static final String USER = "user";
    private static final String UPDATETIME = "updatetime";
    private static final String OP_ADD = "addrow";
    private static final String OP_DELETE = "deleterow";
    private static final String OLD_CONFIG_CACHE = "old_config";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OP_ADD, OP_DELETE});
        BasedataEdit source = (BasedataEdit)this.getControl(SCENE);
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            String jsonStr = (String)this.getModel().getValue("json");
            LinkedHashMap oldRowIndexToDataMap = new LinkedHashMap(16);
            if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
                List oldSceneSettingVoList = SerializationUtils.fromJsonStringToList((String)jsonStr, SceneSettingVo.class);
                for (int i = 0; i < oldSceneSettingVoList.size(); ++i) {
                    oldRowIndexToDataMap.put(i + 1, oldSceneSettingVoList.get(i));
                }
            }
            DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList<SceneSettingVo> sceneSettingVoList = new ArrayList<SceneSettingVo>(10);
            int seq = 0;
            ArrayList<Integer> tipSceneIsNullLine = new ArrayList<Integer>(10);
            for (DynamicObject row : currentData) {
                SceneSettingVo oldData = (SceneSettingVo)oldRowIndexToDataMap.get(++seq);
                SceneSettingVo sceneSettingVo = new SceneSettingVo();
                sceneSettingVo.setType(row.getString(TYPE));
                String sceneNumber = row.getString("scene.number");
                if (StringUtils.isEmpty((CharSequence)sceneNumber)) {
                    tipSceneIsNullLine.add(seq);
                    continue;
                }
                sceneSettingVo.setSceneNumber(sceneNumber);
                sceneSettingVo.setSetting(row.getString(SETTING));
                boolean needUpdate = false;
                if (oldData == null) {
                    needUpdate = true;
                } else if (!(oldData.getType().equals(row.getString(TYPE)) && oldData.getSceneNumber().equals(sceneNumber) && oldData.getSetting().equals(row.getString(SETTING)))) {
                    needUpdate = true;
                }
                if (needUpdate) {
                    sceneSettingVo.setUserId(Long.valueOf(this.getUserId()));
                    sceneSettingVo.setModifyTime(TimeServiceHelper.now());
                } else {
                    sceneSettingVo.setUserId(oldData.getUserId());
                    sceneSettingVo.setModifyTime(oldData.getModifyTime());
                }
                sceneSettingVo.setSeq(seq);
                sceneSettingVoList.add(sceneSettingVo);
            }
            if (!tipSceneIsNullLine.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConfigCM044EditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Joiner.on((String)",").join(tipSceneIsNullLine)));
            }
            if (!sceneSettingVoList.isEmpty()) {
                this.getModel().setValue("json", (Object)SerializationUtils.toJsonString(sceneSettingVoList));
            } else {
                this.getModel().setValue("json", null);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (isSuccess && "save".equals(e.getOperateKey())) {
            QFBuilder qfBuilder = new QFBuilder("id", "=", e.getOperationResult().getSuccessPkIds().get(0));
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"config,model,number,name", (QFilter[])qfBuilder.toArray());
            String number = dy.getString("number");
            boolean open = dy.getBoolean("config");
            if (this.checkConfigIsChange() && open && Objects.equals(number, "CM044")) {
                MergeStatusService.getInstance().updateCheckStatus(Long.valueOf(dy.getLong("model.id")));
                this.writeMultiLangLog(new OpNameMultiLangEnumBridge("\u4fee\u6539CM044\u53c2\u6570\u503c\u4e3a\"\u662f\"\u6210\u529f", "ConfigEditPlugin_10", "fi-bcm-formplugin", "update param"), new OPDescMultiLangEnumBridge("\u5c06\u5df2\u63d0\u4ea4\u7684\u5bf9\u8d26\u72b6\u6001\u5237\u4e3a\u5df2\u786e\u8ba4\u3002", "ConfigEditPlugin_9", "fi-bcm-formplugin", null));
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFieldSettingHide();
        String config = (String)this.getModel().getValue("config");
        this.getPageCache().put(OLD_CONFIG_CACHE, StringUtils.isEmpty((CharSequence)config) ? "0" : config);
        String jsonStr = (String)this.getModel().getValue("json");
        if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            List list = SerializationUtils.fromJsonStringToList((String)jsonStr, SceneSettingVo.class);
            String modelNumber = MemberReader.findModelNumberById((Object)this.getModelId());
            list.forEach(r -> {
                int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                IDNumberTreeNode sceneMember = MemberReader.findScenaMemberByNum((String)modelNumber, (String)r.getSceneNumber());
                this.getModel().setValue(TYPE, (Object)r.getType(), rowIndex);
                this.getModel().setValue(SCENE, (Object)sceneMember.getId(), rowIndex);
                this.getModel().setValue(SETTING, (Object)r.getSetting(), rowIndex);
                this.getModel().setValue(USER, (Object)r.getUserId(), rowIndex);
                this.getModel().setValue(UPDATETIME, (Object)r.getModifyTime(), rowIndex);
            });
        }
        this.getModel().setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        int currentRowIndex = changeData.getRowIndex();
        if ((TYPE.equals(key) || SETTING.equals(key) || SCENE.equals(key)) && null != newValue) {
            if (SCENE.equals(key)) {
                DynamicObject newScene = (DynamicObject)newValue;
                long newSceneId = newScene.getLong("id");
                List<Long> selectScenePkIds = this.getSelectScenePkIds();
                boolean isExist = false;
                int existIndex = 0;
                for (int i = 0; i < selectScenePkIds.size(); ++i) {
                    if (currentRowIndex == i || selectScenePkIds.get(i) != newSceneId) continue;
                    existIndex = i;
                    isExist = true;
                    break;
                }
                if (isExist) {
                    this.getModel().setValue(key, oldValue);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u5df2\u5b58\u5728\u65b0\u8bbe\u7684\u60c5\u666f\u3002", (String)"ConfigCM044EditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), existIndex + 1));
                    return;
                }
            }
            if (TYPE.equals(key)) {
                String newType = (String)newValue;
                boolean isEnable = true;
                if (CM053TypeEnum.EXCEPTION.getValue().equals(newType)) {
                    this.getModel().setValue(SETTING, (Object)CM053SettingEnum.ONLY_TIP.getValue(), currentRowIndex);
                    isEnable = false;
                }
                this.getView().setEnable(Boolean.valueOf(isEnable), currentRowIndex, new String[]{SETTING});
            }
            this.getModel().setValue(USER, (Object)this.getUserId(), currentRowIndex);
            this.getModel().setValue(UPDATETIME, (Object)TimeServiceHelper.now(), currentRowIndex);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if (SCENE.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("model.id", "=", (Object)this.getModelId());
            qFilter.and("number", "!=", (Object)"Scenario");
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}), "dseq asc"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectScene"));
            showParameter.setSelectedRows(this.getSelectScenePkIds().toArray());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("selectScene".equals(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.fillBackScene(returnData);
        }
    }

    private int getCurrentRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        int currentRow = 0;
        if (selectRows.length > 0) {
            currentRow = selectRows[0];
        }
        return currentRow;
    }

    private void setFieldSettingHide() {
        String configNumber = (String)this.getValue("number");
        this.getView().setVisible(Boolean.valueOf(configNumber.equalsIgnoreCase("CM053")), new String[]{SETTING});
    }

    private boolean isCM053() {
        String configNumber = (String)this.getValue("number");
        return configNumber.equalsIgnoreCase("CM053");
    }

    private List<Long> getSelectScenePkIds() {
        DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
        return currentData.stream().map(r -> r.getLong("scene.id")).collect(Collectors.toList());
    }

    private void fillBackScene(ListSelectedRowCollection returnData) {
        if (returnData == null) {
            return;
        }
        DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
        Set sceneNumberSet = currentData.stream().map(r -> r.getString("scene.number")).collect(Collectors.toSet());
        int currentRow = this.getCurrentRowIndex();
        for (ListSelectedRow sceneData : returnData) {
            if (sceneNumberSet.contains(sceneData.getNumber())) continue;
            Object currentScene = this.getModel().getValue(SCENE, currentRow);
            if (currentScene != null) {
                currentRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            }
            this.getModel().setValue(SCENE, sceneData.getPrimaryKeyValue(), currentRow);
            if (!this.isCM053()) continue;
            this.getModel().setValue(SETTING, (Object)CM053SettingEnum.NOT_CONTROL.getValue(), currentRow);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addrow": {
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                if (this.isCM053()) break;
                this.getModel().setValue(TYPE, (Object)CM053TypeEnum.EXCEPTION.getValue(), row);
                break;
            }
            case "deleterow": {
                this.deleteEntry();
            }
        }
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u518d\u64cd\u4f5c", (String)"ConfigCM044EditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }

    private boolean checkConfigIsChange() {
        return !this.getModel().getValue("config").equals(this.getPageCache().get(OLD_CONFIG_CACHE));
    }
}

