/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.olap.dynamic.DynamicOlapHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ConfigEditPlugin
extends AbstractBaseBasicPlugIn {
    private static final String CONFIGTEXT = "configtext";
    protected static final String CONFIG = "config";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String BTNSAVE = "btnsave";
    private static final String ISBACKPARAM = "isBackParam";
    protected static final String NUMBER = "number";
    protected static final String ID = "id";
    private static final String MODEL = "model";
    protected static final String MODEL_ID = "model.id";
    protected static final String SAVE = "save";
    private static final Log LOG = LogFactory.getLog(ConfigEditPlugin.class);
    private static final String JSON = "json";
    private static final String INIT_PERIOD_STATUS = "initperiodstatus";
    protected static final String SHOW_NO_LEAF_NODE = "shownoleafnode";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNSAVE});
        BasedataEdit scenariocol = (BasedataEdit)this.getControl("scenario");
        if (!Objects.isNull(scenariocol)) {
            scenariocol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        String configNumber = (String)this.getValue(NUMBER);
        if (key.equalsIgnoreCase(CONFIG) && configNumber.equalsIgnoreCase("CM034")) {
            this.getView().setVisible(Boolean.valueOf(!"0".equals(e.getChangeSet()[0].getNewValue())), new String[]{"scenario"});
        }
        if (key.equalsIgnoreCase(CONFIG) && configNumber.equalsIgnoreCase("CM012")) {
            this.getView().setVisible(Boolean.valueOf(!"0".equals(e.getChangeSet()[0].getNewValue())), new String[]{INIT_PERIOD_STATUS});
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        String configNumber;
        List<String> configs;
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String isBackParam = (String)parentView.getFormShowParameter().getCustomParam(ISBACKPARAM);
            if (isBackParam != null && TRUE.equals(isBackParam)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONFIG});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONFIGTEXT});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIGTEXT});
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTNSAVE});
        }
        if ((configs = Arrays.asList("CM01", "P003")).contains(configNumber = (String)this.getValue(NUMBER))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MODEL});
        }
        if (configNumber.equalsIgnoreCase("CM006")) {
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)this.getModelId(), (String)"bcm_model", (String)NUMBER);
            try {
                Boolean isDy = OlapServiceHelper.checkCubeIsEnableDynamic((String)model.getString(NUMBER));
                if (!isDy.booleanValue()) {
                    this.showTipInfo(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5173\u8054\u7684OLAP\u670d\u52a1\u6ca1\u6709\u914d\u7f6e\u52a8\u6001\u8ba1\u7b97\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ConfigEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception exception) {
                this.showTipInfo(exception.getMessage());
                LOG.error("ConfigEditPlugin afterBindData, error:" + exception.getMessage(), (Throwable)exception);
            }
        }
        if (configNumber.equalsIgnoreCase("CM032")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"linkcreatetype"});
            this.getView().setVisible(Boolean.FALSE, new String[]{CONFIG, CONFIGTEXT});
            String linkcreatetype = (String)this.getModel().getValue("linkcreatetype");
            if (StringUtils.isBlank((String)linkcreatetype)) {
                String config = (String)this.getModel().getValue(CONFIG);
                this.getModel().setValue("linkcreatetype", (Object)(StringUtils.isBlank((String)config) ? "0" : config.trim()));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"linkcreatetype"});
        }
        if (configNumber.equalsIgnoreCase("CM034")) {
            this.getView().setVisible(Boolean.valueOf(this.getValue(CONFIG).toString().equalsIgnoreCase("1")), new String[]{"scenario"});
            boolean config = this.getValue(CONFIG).toString().equals("1");
            if (config && OlapServiceHelper.checkMeasure((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)FacTabFieldDefEnum.FIELD_LOCK.getField())) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CONFIG});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"scenario"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"scenario"});
        }
        if (configNumber.equalsIgnoreCase("CM012")) {
            String initPeriodStatusValue = (String)this.getModel().getValue(JSON);
            if (!StringUtil.isEmptyString((String)initPeriodStatusValue)) {
                this.getModel().setValue(INIT_PERIOD_STATUS, (Object)initPeriodStatusValue);
            } else {
                this.getModel().setValue(INIT_PERIOD_STATUS, (Object)"0");
            }
            this.getView().setVisible(Boolean.valueOf(this.getValue(CONFIG).toString().equalsIgnoreCase("1")), new String[]{INIT_PERIOD_STATUS});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{INIT_PERIOD_STATUS});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        if (configNumber.equalsIgnoreCase("CM048")) {
            this.setEnableOfCM048();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    private void setEnableOfCM048() {
        QFilter qf = new QFilter("baldirection", "=", (Object)"1");
        qf.and(MODEL, "=", (Object)this.getModelId());
        if (QueryServiceHelper.exists((String)"bcm_changetypemembertree", (QFilter[])qf.toArray()) || QueryServiceHelper.exists((String)"bcm_userdefinedmembertree", (QFilter[])qf.toArray())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CONFIG});
        }
    }

    private void showTipInfo(String info) {
        this.getModel().setValue(CONFIG, (Object)0);
        this.getView().setEnable(Boolean.FALSE, new String[]{CONFIG, CONFIGTEXT, BTNSAVE});
        this.getView().showTipNotification(info);
    }

    private void changeCM006() {
        DynamicObject modelObj;
        if (this.getValue(NUMBER).toString().equalsIgnoreCase("CM006") && (modelObj = (DynamicObject)this.getValue(MODEL)) != null) {
            long modelId = modelObj.getLong(ID);
            if (this.getValue(CONFIG).toString().equalsIgnoreCase("1")) {
                DynamicComputingServiceHelper.lockUpgradeModelForChangeCM006((long)modelObj.getLong(ID));
                DynamicOlapHelper.setDynamicModel((long)modelId, null, (boolean)true);
            } else {
                DynamicOlapHelper.setDynamicModel((long)modelId, null, (boolean)false);
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String number = beforeF7SelectEvent.getProperty().getName();
        if (number.equals("scenario")) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qf = new QFilter(MODEL_ID, "=", (Object)this.getModelId());
            qf.and(NUMBER, "!=", (Object)"Scenario");
            showParameter.setListFilterParameter(new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{qf}), null));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (SAVE.equals(operate.getOperateKey())) {
            String configNumber;
            String configTextVal;
            String isBackParam;
            Boolean checkRepeatNum = this.checkRepeatNum();
            if (checkRepeatNum.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u5bf9\u5e94\u7684\u53c2\u6570\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ConfigEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (isBackParam = (String)parentView.getFormShowParameter().getCustomParam(ISBACKPARAM)) != null && TRUE.equals(isBackParam) && StringUtils.isNotEmpty((String)(configTextVal = (String)this.getModel().getValue(CONFIGTEXT)))) {
                if (ResManager.loadKDString((String)"\u662f", (String)"ConfigEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(configTextVal)) {
                    configTextVal = "1";
                } else if (ResManager.loadKDString((String)"\u5426", (String)"ConfigEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]).equals(configTextVal)) {
                    configTextVal = "0";
                }
                this.getModel().setValue(CONFIG, (Object)configTextVal);
            }
            if ((configNumber = (String)this.getValue(NUMBER)).equalsIgnoreCase("CM012")) {
                this.getModel().setValue(JSON, (Object)String.valueOf(this.getModel().getValue(INIT_PERIOD_STATUS)));
            } else if (!configNumber.equalsIgnoreCase("CM044") && !configNumber.equalsIgnoreCase("CM053")) {
                if (configNumber.equalsIgnoreCase("CM030")) {
                    this.getModel().setValue(JSON, (Object)((Boolean)this.getModel().getValue(SHOW_NO_LEAF_NODE) != false ? "1" : "0"));
                } else {
                    this.saveRegistAdditionField(String.valueOf(this.getModel().getValue(NUMBER)));
                }
            }
        }
    }

    private Boolean checkRepeatNum() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            QFilter q2;
            QFilter q1;
            QFilter[] filters;
            boolean exists;
            String configNumber;
            Long modelId = 0L;
            DynamicObject modelObj = (DynamicObject)this.getValue(MODEL);
            if (modelObj != null) {
                modelId = modelObj.getLong(ID);
            }
            if (StringUtils.isNotEmpty((String)(configNumber = (String)this.getValue(NUMBER))) && modelId != null && (exists = QueryServiceHelper.exists((String)"bcm_configsetting", (QFilter[])(filters = new QFilter[]{q1 = new QFilter(NUMBER, "=", (Object)configNumber), q2 = new QFilter(MODEL, "=", (Object)modelId)})))) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean notTextParam() {
        Boolean isTextParam = Boolean.FALSE;
        String configVal = (String)this.getModel().getValue(CONFIG);
        if ("1".equals(configVal) || "0".equals(configVal)) {
            isTextParam = Boolean.TRUE;
        }
        return isTextParam;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (isSuccess && SAVE.equals(e.getOperateKey())) {
            QFBuilder qfBuilder = new QFBuilder(ID, "=", e.getOperationResult().getSuccessPkIds().get(0));
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"config,model,number,name", (QFilter[])qfBuilder.toArray());
            boolean open = dy.getBoolean(CONFIG);
            boolean oldOpenStatus = ConfigServiceHelper.getBoolParam((Long)dy.getLong(MODEL_ID), (String)"CM006");
            if (open && !oldOpenStatus) {
                if (this.notTextParam().booleanValue()) {
                    ConfigServiceHelper.cacheIt((Long)dy.getLong(MODEL_ID), (String)dy.getString(NUMBER), (Object)dy.getBoolean(CONFIG));
                }
                this.changeCM006();
            } else {
                this.changeCM006();
                if (this.notTextParam().booleanValue()) {
                    ConfigServiceHelper.cacheIt((Long)dy.getLong(MODEL_ID), (String)dy.getString(NUMBER), (Object)dy.getBoolean(CONFIG));
                }
            }
            String number = dy.getString(NUMBER);
            this.initOriginalCurMember(dy);
            ConfigServiceHelper.remove((Long)dy.getLong(MODEL_ID), (String)number);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setParamText();
        this.initControlFromAdditionField();
    }

    private void setParamText() {
        String isBackParam;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (isBackParam = (String)parentView.getFormShowParameter().getCustomParam(ISBACKPARAM)) != null && TRUE.equals(isBackParam)) {
            String configNumber = this.getValue(NUMBER).toString();
            QFBuilder qf = new QFBuilder();
            qf.add(MODEL, "=", (Object)this.getModelId());
            qf.add(NUMBER, "=", (Object)configNumber);
            DynamicObject configModel = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_configsetting", (String)CONFIG, (QFilter[])qf.toArray());
            String configVal = configModel.getString(CONFIG);
            if (TRUE.equals(configVal) || "1".equals(configVal)) {
                this.getModel().setValue(CONFIGTEXT, (Object)ResManager.loadKDString((String)"\u662f", (String)"ConfigEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else if (FALSE.equals(configVal) || "0".equals(configVal)) {
                this.getModel().setValue(CONFIGTEXT, (Object)ResManager.loadKDString((String)"\u5426", (String)"ConfigEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue(CONFIGTEXT, (Object)configVal);
            }
            this.getModel().setDataChanged(false);
            if ("CM031".equals(this.getModel().getValue(NUMBER)) && "1".equals(this.getModel().getValue(CONFIG))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{CONFIGTEXT});
            }
        }
        if ("CM031".equals(this.getModel().getValue(NUMBER)) && "1".equals(this.getModel().getValue(CONFIG))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONFIG});
        }
    }

    private void initOriginalCurMember(DynamicObject dy) {
        QFilter curNum;
        DynamicObject modelDy;
        QFilter modelId;
        DynamicObject dynamicObject;
        if ("CM031".equals(dy.getString(NUMBER)) && dy.getBoolean(CONFIG) && (dynamicObject = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)ID, (QFilter[])new QFilter[]{modelId = new QFilter(MODEL, "=", (Object)(modelDy = (DynamicObject)dy.get(MODEL)).getLong(ID)), curNum = new QFilter("longnumber", "=", (Object)"Currency!OC")})) == null) {
            QFilter showNumber = new QFilter("shownumber", "=", (Object)modelDy.getString("shownumber"));
            DynamicObject cubeDy = QueryServiceHelper.queryOne((String)"bcm_model", (String)NUMBER, (QFilter[])new QFilter[]{showNumber});
            DimensionServiceHelper.createCurrencyMember((long)modelDy.getLong(ID), (String)cubeDy.getString(NUMBER), (String)CurrencyEnum.OC.getNumber(), (String)CurrencyEnum.OC.getName(), (String)this.getClass().getName());
        }
    }

    protected void saveRegistAdditionField(String configNumber) {
        Map<String, Object> oldAdditionfieldMap = this.getOldAdditionFieldMap();
        Map<String, Object> newAdditionfieldMap = this.getjsonDATA(configNumber);
        if (oldAdditionfieldMap != null) {
            if (newAdditionfieldMap != null) {
                oldAdditionfieldMap.putAll(newAdditionfieldMap);
            }
            this.getModel().setValue(JSON, (Object)SerializationUtils.toJsonString(oldAdditionfieldMap));
        } else if (newAdditionfieldMap != null) {
            this.getModel().setValue(JSON, (Object)SerializationUtils.toJsonString(newAdditionfieldMap));
        }
    }

    private Map<String, Object> getOldAdditionFieldMap() {
        String addtionfield;
        if (this.getModel().getValue(JSON) != null && !StringUtil.isEmptyString((String)(addtionfield = String.valueOf(this.getModel().getValue(JSON))))) {
            Map additionfieldMap = (Map)SerializationUtils.fromJsonString((String)addtionfield, Map.class);
            return additionfieldMap;
        }
        return null;
    }

    protected Map<String, Object> getjsonDATA(String configNumber) {
        return null;
    }

    protected void initControlFromAdditionField() {
        if (this.getModel().getValue(JSON) != null) {
            String addtionfield;
            String configNumber = (String)this.getValue(NUMBER);
            if (configNumber.equalsIgnoreCase("CM012")) {
                this.getModel().setValue(INIT_PERIOD_STATUS, this.getModel().getValue(JSON));
            } else if (!(configNumber.equalsIgnoreCase("CM044") || configNumber.equalsIgnoreCase("CM053") || StringUtil.isEmptyString((String)(addtionfield = String.valueOf(this.getModel().getValue(JSON)))))) {
                Map additionfieldMap = (Map)SerializationUtils.fromJsonString((String)addtionfield, Map.class);
                this.setControlValue(additionfieldMap);
            }
        }
    }

    protected void setControlValue(Map<String, Object> additionfieldMap) {
    }
}

