/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.config.ConfigEditPlugin;

public class ConfigExceptOrgEditPlugin
extends ConfigEditPlugin {
    private static final String ORG_ENTITY = "orgentity";
    private static final String ADD_ROW = "addrow";
    private static final String DELETE_ROW = "deleterow";
    private static final String ENTITY = "entity";
    private static final String RANGE_VALUE = "rangevalue";
    private static final String BASE_TYPE = "basedatatype";
    private static final String ORG_NAME = "orgname";
    private static final String SELECT_MEMBER = "selectmember";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.checkIsExceptOrgAndRun(() -> {
            this.addClickListeners(new String[]{ADD_ROW, DELETE_ROW});
            EntryGrid eg = (EntryGrid)this.getControl(ORG_ENTITY);
            BasedataEdit orgEdit = (BasedataEdit)eg.getControls().get(0);
            orgEdit.addBeforeF7SelectListener(evt -> {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                qf.and("enable", "=", (Object)"1");
                listShowParameter.getListFilterParameter().setFilter(qf);
            });
        }, Boolean.TRUE);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkIsExceptOrgAndRun(() -> this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"}), Boolean.FALSE);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addrow": {
                this.showSelectOrgView();
                break;
            }
            case "deleterow": {
                this.deleteOrgMember();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection oldDoc = this.getModel().getEntryEntity(ORG_ENTITY);
        if (SELECT_MEMBER.equals(actionId) && Objects.nonNull(e.getReturnData())) {
            DynamicObjectCollection newDoc = (DynamicObjectCollection)e.getReturnData();
            this.selectOrgMember(oldDoc, newDoc);
        }
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.checkIsExceptOrgAndRun(() -> {
            DynamicObjectCollection originData = this.getModel().getEntryEntity(ORG_ENTITY);
            EntryGrid eg = (EntryGrid)this.getControl(ORG_ENTITY);
            TextEdit te = (TextEdit)eg.getItems().get(1);
            int i = 0;
            for (DynamicObject data : originData) {
                te.setEnable("", Boolean.FALSE.booleanValue(), i++);
                data.set(ORG_NAME, (Object)data.getLocaleString("entity.name"));
            }
            this.getModel().setValue(ORG_ENTITY, (Object)originData);
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }, Boolean.TRUE);
    }

    private void checkIsExceptOrgAndRun(Runnable r, boolean flag) {
        Boolean isExceptOrg = (Boolean)this.getView().getFormShowParameter().getCustomParam("isExceptOrg");
        if (Objects.nonNull(isExceptOrg) && Objects.equals(flag, isExceptOrg)) {
            r.run();
        }
    }

    private void showSelectOrgView() {
        long modelId = this.getModelId();
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_mulmemberf7base_dis");
        formShowParameter.setCustomParam("dimension", (Object)"1");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - \u7ec4\u7ec7", (String)"ConfigExceptOrgEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_MEMBER);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void selectOrgMember(DynamicObjectCollection oldDoc, DynamicObjectCollection newDoc) {
        IDataModel model = this.getModel();
        HashSet list = Sets.newHashSetWithExpectedSize((int)16);
        EntryGrid eg = (EntryGrid)this.getControl(ORG_ENTITY);
        TextEdit te = (TextEdit)eg.getItems().get(1);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newOne : newDoc) {
            boolean isExist = Boolean.FALSE;
            for (DynamicObject oldOne : oldDoc) {
                Object id = LongUtil.isvalidLong((Object)newOne.get(4)) ? newOne.get(4) : newOne.get(6);
                if (!LongUtil.isvalidLong((Object)id) || !Objects.equals(id.toString(), oldOne.getString("entity.id")) || !Objects.equals(newOne.get(5), oldOne.get(RANGE_VALUE))) continue;
                isExist = Boolean.TRUE;
                break;
            }
            if (isExist) continue;
            int index = model.createNewEntryRow(ORG_ENTITY);
            model.setValue(RANGE_VALUE, newOne.get(5), index);
            model.setValue(ORG_NAME, newOne.get(3), index);
            model.setValue(RANGE_VALUE, newOne.get(5), index);
            model.setValue(ORG_NAME, newOne.get(3), index);
            te.setEnable("", Boolean.FALSE.booleanValue(), index);
            if (LongUtil.isvalidLong((Object)newOne.get(4))) {
                model.setValue(BASE_TYPE, (Object)"bcm_entitymembertree", index);
                model.setValue(ENTITY, newOne.get(4), index);
            } else if (LongUtil.isvalidLong((Object)newOne.get(6))) {
                model.setValue(BASE_TYPE, (Object)"bcm_userdefinedmembertree", index);
                model.setValue(ENTITY, newOne.get(6), index);
            }
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (Objects.equals(list.size(), 0)) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(ORG_ENTITY);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"ConfigExceptOrgEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ORG_ENTITY, row);
    }
}

