/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.upgrade.ConfigUpgradeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.config.ChildConfigEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BlackListUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.util.BillListHyperLinkClickUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ConfigListPlugin
extends AbstractBaseListPlugin
implements TabSelectListener {
    private static final String GLOBALPARAMETER = "globalparameter";
    private static final String LOCALPAAPMETER = "localparameter";
    private static final String MODEL = "model";
    private static final String NUMBER = "number";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ConfigListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        BillList bl = (BillList)this.getControl("billlistap");
        bl.setBillFormId("bcm_configsetting");
        bl.addSetFilterListener(this::setFilter);
        bl.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
                boolean isenable = StringUtils.isEmpty((CharSequence)((CharSequence)ConfigListPlugin.this.getView().getFormShowParameter().getCustomParam("bcm_backgroundconfig")));
                if (!isenable) {
                    ConfigListPlugin.this.openView(((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId());
                }
            }
        });
        bl.addPackageDataListener(this::packageData);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(MODEL);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        for (DynamicObject object : e.getPageData()) {
            if ("CM005".equalsIgnoreCase(object.getString(NUMBER))) {
                object.set("description", (Object)ConfigEnum.CM005.getDescription());
                object.set("name", (Object)ConfigEnum.CM005.getName());
                continue;
            }
            if (!ConfigEnum.CM018.getNumber().equals(object.getString(NUMBER))) continue;
            object.set("description", (Object)ConfigEnum.CM018.getDescription());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MODEL});
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), MODEL);
        if (!StringUtil.isEmptyString((String)modelId) && !"0".equals(modelId)) {
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            this.getModel().setValue(MODEL, (Object)modelId);
            ConfigServiceHelper.upgradeConfig((Object)Long.parseLong(modelId));
        }
        this.settingControlIsVisibleByConfigParam();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_update"});
        this.refresh();
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs e) {
        super.beforeCreateListColumns(e);
        for (IListColumn listColumn : e.getListColumns()) {
            if (!"model.shownumber".equals(listColumn.getListFieldKey())) continue;
            listColumn.setVisible(0);
        }
    }

    private void settingControlIsVisibleByConfigParam() {
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_settype"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("close".equals(key)) {
            this.getView().close();
        } else if ("refresh".equals(key)) {
            this.refresh();
        } else if ("btn_update".equals(key)) {
            new ConfigUpgradeService().upgradeBefore();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"ConfigListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else if ("btn_settype".equals(key)) {
            this.openParamForm();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Tab tab = (Tab)this.getControl("tabap");
        QFilter qFilter = null;
        if (StringUtil.equals((String)GLOBALPARAMETER, (String)tab.getCurrentTab())) {
            qFilter = new QFilter(MODEL, "=", (Object)0L);
        } else {
            Object value = this.getValue("model_id");
            if (Objects.nonNull(value)) {
                qFilter = new QFilter(MODEL, "=", value);
                if (!this.isExistChangeTypeDimension()) {
                    qFilter.and(NUMBER, "!=", (Object)"CM001");
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ConfigListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        boolean isenable = StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("bcm_backgroundconfig")));
        if (this.isRPT()) {
            qFilter.and(NUMBER, "in", (Object)new String[]{"CM001", "CM007", "CM014", "CM015", "CM016", "CM008", "CM009", "CM012", "CM006", "CM03", "CM018", "CM037", "CM039"});
        } else {
            qFilter.and(NUMBER, "not in", (Object)new String[]{"P003", "CM010", "CM011", "CM02", "P002", "P005"});
        }
        qFilter.and("isenable", "=", (Object)isenable);
        if (BlackListUtils.hasFeatureInCm((String)"CMAna")) {
            qFilter.and(NUMBER, "!=", (Object)"CM008");
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMTra")) {
            qFilter.and(NUMBER, "!=", (Object)"CM009");
        }
        if (BlackListUtils.hasFeatureInCm((String)"CMLink")) {
            qFilter.and(NUMBER, "!=", (Object)"CM017").and(NUMBER, "!=", (Object)"CM032");
        }
        e.getQFilters().add(qFilter);
        e.setOrderBy(NUMBER);
    }

    private void refresh() {
        BillList bl = (BillList)this.getControl("billlistap");
        bl.refresh();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        this.openView(BillListHyperLinkClickUtil.getObjectPkIdFromEvt(args));
    }

    private HashMap<String, ArrayList<Object>> getlogMessageMap(HyperLinkClickArgs args) {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        Long selectBillListId = (Long)BillListHyperLinkClickUtil.getObjectPkIdFromEvt(args);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)selectBillListId, (String)billlistap.getBillFormId(), (String)"name,number");
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        if (Objects.nonNull(dynamicObject)) {
            ArrayList list = Lists.newArrayListWithCapacity((int)2);
            list.add(dynamicObject.getString(NUMBER));
            list.add(dynamicObject.getString("name"));
            map.put(dynamicObject.getPkValue().toString(), list);
        }
        return map;
    }

    private void openView(Object pkid) {
        BaseShowParameter param = new BaseShowParameter();
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_configsetting", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", pkid)});
        ConfigEnum configEnum = ConfigEnum.getConfigDataByNumber((String)dy.getString(NUMBER));
        if (configEnum.getForm() == null) {
            param.setPkId(pkid);
            param.setFormId("bcm_configsetting");
        } else {
            QFBuilder qfBuilder = new QFBuilder(MODEL, "=", (Object)this.getModelId());
            qfBuilder.add(NUMBER, "=", (Object)configEnum.getNumber());
            param.setCustomParam("id", pkid);
            DynamicObject childconfig = QueryServiceHelper.queryOne((String)configEnum.getForm(), (String)"id", (QFilter[])qfBuilder.toArray());
            if (childconfig != null) {
                long id = childconfig.getLong("id");
                TemplateUtil.checkCM018Data((long)this.getModelId(), (long)id, (String)configEnum.getNumber());
                param.setCustomParam("id", (Object)id);
                param.setPkId((Object)id);
                param.setCustomParam("bcmconfigid", pkid);
            }
            param.setCustomParam("ConfigNumber", (Object)configEnum.getNumber());
            param.setFormId(configEnum.getForm());
        }
        Set perModelIds = MemberPermHelper.getLimitedModelListByUser();
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)this.getUserId());
        boolean isManager = false;
        if (perModelIds.contains(this.getModelId())) {
            isManager = true;
        }
        Tab tab = (Tab)this.getControl("tabap");
        if (perModelIds.size() == 0 && !isSuperUser) {
            param.setStatus(OperationStatus.VIEW);
        } else if (isSuperUser) {
            param.setStatus(OperationStatus.EDIT);
        } else if (perModelIds.size() > 0 && (isManager || StringUtil.equals((String)GLOBALPARAMETER, (String)tab.getCurrentTab()))) {
            param.setStatus(OperationStatus.EDIT);
        } else {
            param.setStatus(OperationStatus.VIEW);
        }
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        param.setCustomParam("isExceptOrg", (Object)configEnum.isExceptOrg());
        param.getOpenStyle().setShowType(ShowType.NonModal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "configEdit");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MODEL.equals(key)) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
            if (modelId != null) {
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
                ConfigServiceHelper.upgradeConfig((Object)Long.parseLong(modelId));
                this.refresh();
            } else {
                this.getModel().setValue(MODEL, (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("configEdit".equals(closedCallBackEvent.getActionId())) {
            this.refresh();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        BillList bl = (BillList)this.getControl("billlistap");
        bl.clearSelection();
        this.getView().setVisible(Boolean.valueOf(StringUtil.equals((String)LOCALPAAPMETER, (String)tabSelectEvent.getTabKey())), new String[]{MODEL});
        this.refresh();
    }

    private void openParamForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("bcm_hwparamlist");
        this.getView().showForm(formShowParameter);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        List child = ChildConfigEnum.getValuesByConfigNumber((String)rowData.getString(NUMBER));
        if (child != null && child.size() > 0 || "CM032".equals(rowData.getString(NUMBER))) {
            rowData.set("config", (Object)"--");
        }
    }
}

