/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.config.IcTypeEnum;

public class FloatColorConfigPlugin
extends AbstractBaseFormPlugin {
    public static final String DENTITY = "dentity";
    public static final String WHITE = "#ffffff";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ConfigEnum configDataByNumber = ConfigEnum.getConfigDataByNumber((String)"CM041");
        this.getModel().setValue("number", (Object)configDataByNumber.getNumber());
        this.getModel().setValue("name", (Object)configDataByNumber.getName());
        this.getModel().setValue("description", (Object)configDataByNumber.getDescription());
        this.getModel().setValue("config", (Object)String.valueOf(ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM041")));
        this.getModel().setValue("model", (Object)this.getModelId());
        for (IcTypeEnum icTypeEnum : IcTypeEnum.values()) {
            int index = icTypeEnum.getIndex();
            this.getModel().setValue("type" + index, (Object)icTypeEnum.getValue());
            if (icTypeEnum == IcTypeEnum.ICTYPE_WHITOUTMER) continue;
            this.getModel().setValue("description" + index, (Object)icTypeEnum.getDescription());
        }
        if (this.getModel().getProperty(DENTITY) != null) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DENTITY);
            Map<Object, Object> icTypeToColor = new HashMap(3);
            if (entryEntity.size() > 0) {
                icTypeToColor = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getInt("ictype"), entry -> entry.getString("color")));
            }
            for (IcTypeEnum icTypeEnum : IcTypeEnum.values()) {
                String color = (String)icTypeToColor.get(icTypeEnum.index);
                this.colorBack(icTypeEnum.index, color);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void colorBack(int icType, String color) {
        this.getModel().setValue("color" + icType, (Object)color);
        CustomControl custom = (CustomControl)this.getView().getControl("colorpick" + icType);
        if (StringUtils.isEmpty((String)color)) {
            color = WHITE;
        }
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"colorchange");
        data.put("color", (Object)color);
        custom.setData((Object)data);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String color = JSON.parseObject((String)e.getEventArgs()).getString("color");
        if ("colorpick1".equals(e.getKey())) {
            this.getModel().setValue("color1", (Object)color);
        }
        if ("colorpick2".equals(e.getKey())) {
            this.getModel().setValue("color2", (Object)color);
        }
        if ("colorpick3".equals(e.getKey())) {
            this.getModel().setValue("color3", (Object)color);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnsave");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnsave": {
                this.save();
            }
        }
    }

    private void save() {
        Boolean config = Boolean.valueOf(this.getModel().getValue("config").toString());
        QFBuilder qfBuilder = new QFBuilder("number", "=", (Object)"CM041").add("model", "=", (Object)this.getModelId());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"id,config,number,modifytime,modifier", (QFilter[])qfBuilder.toArray());
        dy.set("config", (Object)(config != false ? 1 : 0));
        dy.set("modifytime", (Object)TimeServiceHelper.now());
        dy.set("modifier", (Object)this.getUserId());
        SaveServiceHelper.update((DynamicObject)dy);
        ConfigServiceHelper.cacheIt((Long)this.getModelId(), (String)"CM041", (Object)dy.get("config"));
        this.getModel().setDataChanged(false);
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RptParamConfigPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(DENTITY);
        if (entryEntity.size() > 0) {
            for (DynamicObject dynamicObject : entryEntity) {
                int ictype = dynamicObject.getInt("ictype");
                dynamicObject.set("color", this.getModel().getValue("color" + ictype));
            }
        } else {
            for (IcTypeEnum icTypeEnum : IcTypeEnum.values()) {
                int index = this.getModel().createNewEntryRow(DENTITY);
                this.getModel().setValue("ictype", (Object)icTypeEnum.getIndex(), index);
                this.getModel().setValue("color", this.getModel().getValue("color" + icTypeEnum.getIndex()), index);
            }
        }
    }
}

