/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.SamePeriodLastYearVo;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.config.ConfigEditPlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.collections.CollectionUtils;

public class SamePeriodLastYearConfigPlugin
extends ConfigEditPlugin {
    protected static final String NUMBER = "number";
    protected static final String NAME = "name";
    protected static final String CONFIG = "config";
    protected static final String DESCRIPTION = "description";
    private static final String OP_ADD = "add";
    private static final String OP_DEL = "del";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SCENARIO = "applyscenario";
    private static final String CURRENTPERIOD = "currentperiod";
    private static final String EXCHANGEPERIOD = "exchangeperiod";
    private static final String USER = "user";
    private static final String UPDATETIME = "updatetime";
    protected static final String SAVE = "save";
    private static final String JSON = "json";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addBeforeF7SelectListener(SCENARIO);
        this.addBeforeF7SelectListener(CURRENTPERIOD);
        this.addBeforeF7SelectListener(EXCHANGEPERIOD);
    }

    private void addBeforeF7SelectListener(String key) {
        BasedataEdit source = (BasedataEdit)this.getControl(key);
        source.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadData();
    }

    private void loadData() {
        String config = (String)this.getModel().getValue(CONFIG);
        this.getView().setEnable(Boolean.valueOf(!"0".equals(config)), new String[]{"advconap"});
        List<SamePeriodLastYearVo> list = this.jsonToVo();
        this.getModel().beginInit();
        if (CollectionUtils.isNotEmpty(list)) {
            String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
            list.forEach(r -> {
                int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(SCENARIO, (Object)this.findIdByNumber(modelNum, DimTypesEnum.SCENARIO.getNumber(), r.getSceario()), rowIndex);
                this.getModel().setValue(CURRENTPERIOD, (Object)this.findIdByNumber(modelNum, DimTypesEnum.PERIOD.getNumber(), r.getCurrentPeriod()), rowIndex);
                this.getModel().setValue(EXCHANGEPERIOD, (Object)this.findIdByNumber(modelNum, DimTypesEnum.PERIOD.getNumber(), r.getExchangePeriod()), rowIndex);
                this.getModel().setValue(USER, (Object)r.getUserId(), rowIndex);
                this.getModel().setValue(UPDATETIME, (Object)r.getModifyTime(), rowIndex);
            });
        }
        this.getModel().setValue(DESCRIPTION, (Object)ConfigEnum.CM056.getDescription());
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView(DESCRIPTION);
        this.getModel().setDataChanged(false);
    }

    @Override
    protected void saveRegistAdditionField(String configNumber) {
    }

    @Override
    protected void initControlFromAdditionField() {
    }

    private List<SamePeriodLastYearVo> jsonToVo() {
        List<Object> result = new ArrayList<SamePeriodLastYearVo>(16);
        String jsonStr = (String)this.getModel().getValue(JSON);
        if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            result = SerializationUtils.fromJsonStringToList((String)jsonStr, SamePeriodLastYearVo.class);
        }
        return result;
    }

    private long findIdByNumber(String modelNum, String dimNum, String memberNum) {
        IDNumberTreeNode treeNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)dimNum, (String)memberNum);
        Long id = 0L;
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            id = treeNode.getId();
        }
        return id;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model.id", "=", (Object)modelId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.setMultiSelect(false);
        Long dimId = 0L;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(qFilter);
        String entity = DimEntityNumEnum.PERIOD.getEntityNum();
        switch (key) {
            case "applyscenario": {
                entity = DimEntityNumEnum.SCENARIO.getEntityNum();
                dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.SCENARIO.getNumber());
                qFilters.add(new QFilter(NUMBER, "!=", (Object)"Scenario"));
                break;
            }
            case "currentperiod": 
            case "exchangeperiod": {
                qFilters.add(this.getPeriodQFilter(beforeF7SelectEvent.getRow(), key));
                dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.PERIOD.getNumber());
                break;
            }
        }
        qFilters.add(SingleMemberF7Util.getPermissionFilter(entity, dimId, modelId));
        showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ((SCENARIO.equals(actionId) || CURRENTPERIOD.equals(actionId) || EXCHANGEPERIOD.equals(actionId)) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection result = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            this.getModel().setValue(actionId, CollectionUtils.isNotEmpty((Collection)result) ? result.get(0).getPrimaryKeyValue() : null);
        }
    }

    private QFilter getPeriodQFilter(int row, String key) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        List<Long> ids = this.getPeriodIds(this.getModel().getValue(SCENARIO, row));
        if (EXCHANGEPERIOD.equals(key) && this.getModel().getValue(CURRENTPERIOD, row) instanceof DynamicObject) {
            ids.remove(((DynamicObject)this.getModel().getValue(CURRENTPERIOD, row)).getLong("id"));
        }
        qFilter = ids.isEmpty() ? new QFilter("1", "=", (Object)0) : new QFilter("id", "in", ids);
        return qFilter;
    }

    private List<Long> getPeriodIds(Object scenario) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (scenario instanceof DynamicObject) {
            DynamicObject[] col;
            QFilter filter = new QFilter("id", "=", (Object)((DynamicObject)scenario).getLong("id"));
            filter.and("model", "=", (Object)this.getModelId());
            for (DynamicObject dot : col = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"sceneperiod", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection sceneperiod = dot.getDynamicObjectCollection("sceneperiod");
                sceneperiod.forEach(p -> ids.add(p.getDynamicObject("fbasedataid").getLong("id")));
            }
        }
        return ids;
    }

    private void clearPeriodForScenario(Object scenario, int row) {
        List<Long> periodIds = this.getPeriodIds(scenario);
        this.clearPeriodValue(periodIds, row, CURRENTPERIOD);
        this.clearPeriodValue(periodIds, row, EXCHANGEPERIOD);
    }

    private void clearPeriodValue(List<Long> periodIds, int row, String key) {
        Object value = this.getModel().getValue(key, row);
        if (value instanceof DynamicObject && !periodIds.contains(((DynamicObject)value).getLong("id"))) {
            this.getModel().setValue(key, null);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int currentRowIndex = changeData.getRowIndex();
        if (null != newValue) {
            switch (key) {
                case "applyscenario": 
                case "currentperiod": 
                case "exchangeperiod": {
                    this.getModel().setValue(USER, (Object)this.getUserId(), currentRowIndex);
                    this.getModel().setValue(UPDATETIME, (Object)TimeServiceHelper.now(), currentRowIndex);
                    if (!SCENARIO.equals(key)) break;
                    this.clearPeriodForScenario(newValue, currentRowIndex);
                    break;
                }
                case "config": {
                    this.getView().setEnable(Boolean.valueOf(!"0".equals(newValue)), new String[]{"advconap"});
                    break;
                }
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (SAVE.equals(operate.getOperateKey())) {
            List<SamePeriodLastYearVo> result = this.checkData();
            if (result == null) {
                args.setCancel(true);
                return;
            }
            this.saveData(result);
        }
    }

    private List<SamePeriodLastYearVo> checkData() {
        ArrayList<SamePeriodLastYearVo> result = new ArrayList<SamePeriodLastYearVo>(16);
        String config = (String)this.getModel().getValue(CONFIG);
        DynamicObjectCollection currentData = this.getModel().getEntryEntity(ENTRYENTITY);
        if ("1".equals(config) && CollectionUtils.isNotEmpty((Collection)currentData)) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            for (int i = 0; i < currentData.size(); ++i) {
                String curNum;
                DynamicObject e = (DynamicObject)currentData.get(i);
                SamePeriodLastYearVo vo = new SamePeriodLastYearVo();
                if (e.getDynamicObject(SCENARIO) == null || e.getDynamicObject(CURRENTPERIOD) == null || e.getDynamicObject(EXCHANGEPERIOD) == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u60c5\u666f\u3001\u5f53\u524d\u671f\u95f4\u3001\u4e0a\u5e74\u540c\u671f\u67e5\u8be2\u671f\u95f4\u4e2d\u5b58\u5728\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"SamePeriodLastYearConfigPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), i + 1));
                    return null;
                }
                String scenNum = e.getDynamicObject(SCENARIO).getString(NUMBER);
                String key = String.join((CharSequence)"|", scenNum, curNum = e.getDynamicObject(CURRENTPERIOD).getString(NUMBER));
                if (map.get(key) != null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c %1s \u884c\u548c\u7b2c %2s \u884c\u7684\u60c5\u666f\u548c\u5f53\u524d\u671f\u95f4\u4e00\u6837\uff0c\u4e0d\u652f\u6301\u591a\u6b21\u8bbe\u7f6e\u3002", (String)"SamePeriodLastYearConfigPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), (Integer)map.get(key) + 1, i + 1));
                    return null;
                }
                map.put(key, i);
                vo.setSceario(scenNum);
                vo.setCurrentPeriod(curNum);
                vo.setExchangePeriod(e.getDynamicObject(EXCHANGEPERIOD).getString(NUMBER));
                DynamicObject userDyo = e.getDynamicObject(USER);
                if (userDyo instanceof DynamicObject) {
                    vo.setUserId(Long.valueOf(userDyo.getLong("id")));
                }
                vo.setModifyTime(e.getDate(UPDATETIME));
                result.add(vo);
            }
        }
        return result;
    }

    private void saveData(List<SamePeriodLastYearVo> result) {
        if (result.isEmpty()) {
            this.getModel().setValue(JSON, null);
        } else {
            this.getModel().setValue(JSON, (Object)SerializationUtils.toJsonString(result));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "add": {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                break;
            }
            case "del": {
                this.deleteEntry();
            }
        }
    }

    private void deleteEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u518d\u64cd\u4f5c", (String)"SamePeriodLastYearConfigPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }
}

