/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertdifference;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.convert.util.ConvertDiffHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.RowDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKTypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.formula.EncoderService;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.lang.RandomStringUtils;

public class ConvertDiffFormulaPlugin
extends AbstractBaseFormPlugin
implements SubPage,
DynamicPage {
    private static final String SAVEDATA = "savedata";
    private static final String MAPCACHE = "mapcache";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.checkAndBuildEditPage();
    }

    public void customEvent(CustomEventArgs e) {
        switch (e.getEventName()) {
            case "f(x)": {
                String key = e.getEventArgs();
                if (StringUtils.isEmpty((String)key)) {
                    VFormula v = this.buildDefaultFormula();
                    this.showVPanel("formula_fx_", null, v.toString());
                    break;
                }
                if (key.startsWith("formula_fx_")) {
                    this.showVPanel("formula_fx_", key, this.getPageCache().get(key));
                    break;
                }
                if (!key.startsWith("formula_temp_")) break;
                this.showVPanel("formula_temp_", key, this.getPageCache().get(key));
                break;
            }
            case "getText": {
                String text = e.getEventArgs();
                text = text.replaceAll("\n", "");
                text = text.replaceAll("\\p{C}", "");
                String serial = this.getPageCache().get(SAVEDATA);
                if (StringUtils.isNotEmpty((String)serial)) {
                    try {
                        if (StringUtils.isEmpty((String)text)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u516c\u5f0f\u3002", (String)"ConvertDiffFormulaPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        this.getPageCache().remove(SAVEDATA);
                        JSONObject checkModel = JSON.parseObject((String)serial);
                        if (ChkCheckServiceHelper.isChinese((String)text)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u4e0d\u5e94\u5305\u542b\u4e2d\u6587\u6216\u4e2d\u6587\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConvertDiffFormulaPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                        this.checkAndBuildSaveFormula(text, checkModel);
                        CommandParam com = new CommandParam("bcm_convertdiffformula", "bcm_convertdiffmainpage", this.getPageCache().get("operation"), checkModel);
                        this.sendMsg(this.getView(), com);
                    }
                    catch (KDBizException kde) {
                        CommandParam com = new CommandParam("bcm_convertdiffformula", "bcm_convertdiffmainpage", this.getPageCache().get("operation"), kde.getMessage());
                        this.sendMsg(this.getView(), com);
                    }
                    break;
                }
                CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
                String newtext = this.rebuildDatabyFormula(text, this.getPageCache(), this.getModelId());
                JSONObject data = new JSONObject();
                data.put("operate", (Object)"updateText");
                data.put("data", (Object)newtext);
                custom.setData((Object)data);
                break;
            }
        }
    }

    private void checkAndBuildSaveFormula(String text, JSONObject checkModel) {
        String lctemp;
        String lc;
        String[] resultList = CheckedFormulaUtil.getFormulaForDiff((String)text, (IPageCache)this.getPageCache());
        String actualFormula = resultList[0];
        String actualFormulaTemplate = resultList[1];
        int equalPosition = actualFormula.indexOf(61);
        if (Objects.equals(this.getPageCache().get("operation"), "closingCheck") || Objects.equals(this.getPageCache().get("operation"), "addCheck")) {
            this.getView().getParentView().getPageCache().put("curformula", actualFormulaTemplate);
            if (this.getView().getParentView().getPageCache().get("ismodifer") == null) {
                this.getView().getParentView().getPageCache().put("oldformula", actualFormulaTemplate);
            }
        }
        if (equalPosition > -1) {
            if (actualFormula.length() < equalPosition + 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53f3\u516c\u5f0f\u586b\u5199\u9519\u8bef\u3002", (String)"ConvertDiffFormulaPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String nextCom = actualFormula.substring(equalPosition + 1, equalPosition + 2);
            if ("=".equals(nextCom) || "<".equals(nextCom) || ">".equals(nextCom)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u5fc5\u987b\u6709\u7b49\u53f7\u3002", (String)"ConvertDiffFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            String leftFormula = actualFormula.substring(0, equalPosition);
            this.checkLeftFormula(leftFormula);
            String exepr = resultList[2];
            CheckedFormulaUtil.checkCanExcecuteDiff((String)exepr.substring(exepr.indexOf(61) + 1), (String)"=", (boolean)false);
            lc = ConvertDiffHelper.replaceLeftformulaAT2C((long)this.getModelId(), (String)leftFormula);
            String leftFormulaTemp = actualFormulaTemplate.substring(0, actualFormulaTemplate.indexOf(61));
            lctemp = ConvertDiffHelper.replaceLeftformulaAT2C((long)this.getModelId(), (String)leftFormulaTemp);
            boolean isatreplaced = !leftFormula.equals(lc);
            checkModel.put("isatreplaced", (Object)isatreplaced);
            if (isatreplaced) {
                this.checkTraDif(lc);
                this.replaceAtCache(text, this.getPageCache());
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u5fc5\u987b\u6709\u7b49\u53f7\u3002", (String)"ConvertDiffFormulaPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        checkModel.put("leftformula", (Object)lc);
        checkModel.put("leftformulatmp", (Object)lctemp);
        checkModel.put("rightformula", (Object)actualFormula.substring(equalPosition + 1));
        checkModel.put("rightformulatmp", (Object)actualFormulaTemplate.substring(actualFormulaTemplate.indexOf(61) + 1));
        checkModel.put("comparetype", (Object)String.valueOf(CHKTypeEnum.EQUAL.getIndex()));
    }

    private String rebuildDatabyFormula(String data, IPageCache pageCache, long modelId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c == '{') {
                sb.append(c);
                sb.append(data.charAt(++i));
                ++i;
                StringBuilder keysb = new StringBuilder();
                while (i < data.length()) {
                    c = data.charAt(i);
                    sb.append(c);
                    if (c == '\"') break;
                    keysb.append(c);
                    ++i;
                }
                String key = keysb.toString();
                String text = "";
                text = pageCache.get(key + "formula_withtemp") != null ? ChkFormulaServiceHelper.translateChkformla((String)pageCache.get(key + "formula_withtemp"), (long)modelId, (int)3) : ChkFormulaServiceHelper.translateChkformla((String)pageCache.get(key), (long)modelId, (int)3);
                sb.append(",\"");
                sb.append(text);
                sb.append('\"');
                sb.append(data.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void checkTraDif(String leftFormula) {
        if (!StringUtil.isEmptyString((String)leftFormula)) {
            String atMember;
            int fin = leftFormula.indexOf("\"AT.");
            int din = 0;
            for (int i = fin + 1; i < leftFormula.length(); ++i) {
                if (leftFormula.charAt(i) != '\"') continue;
                din = i;
                break;
            }
            if (!QueryServiceHelper.exists((String)"bcm_audittrialmember", (QFilter[])new QFilter("number", "=", (Object)(atMember = leftFormula.substring(fin + 4, din))).toArray())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22\u7f3a\u5c11\u9884\u7f6e\u6210\u5458\uff0c\u8bf7\u5148\u5230\u6298\u7b97\u6807\u51c6\u8bbe\u7f6e\u6307\u5b9a\u6298\u7b97\u5dee\u6210\u5458\u3002", (String)"ConvertDiffFormulaPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void replaceAtCache(String text, IPageCache pageCache) {
        if (!StringUtil.isEmptyString((String)text)) {
            for (int i = 0; i < text.length(); ++i) {
                String b;
                char c = text.charAt(i);
                if (c != '{') continue;
                i += 2;
                StringBuilder keysb = new StringBuilder();
                while (i < text.length() && (c = text.charAt(i)) != '\"') {
                    keysb.append(c);
                    ++i;
                }
                String key = keysb.toString();
                String a = pageCache.get(key);
                if (a != null) {
                    pageCache.put(key, ConvertDiffHelper.replaceAT((long)this.getModelId(), (String)a));
                }
                if ((b = pageCache.get(key + "formula_withtemp")) == null) break;
                pageCache.put(key + "formula_withtemp", ConvertDiffHelper.replaceAT((long)this.getModelId(), (String)b));
                break;
            }
        }
    }

    private void checkLeftFormula(String leftformula) {
        if (!StringUtil.isEmptyString((String)leftformula)) {
            int e;
            int f = leftformula.indexOf("V(\"");
            if (f != (e = leftformula.lastIndexOf("V(\"")) || f > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b49\u5f0f\u5de6\u8fb9\u53ea\u80fd\u6709\u4e00\u4e2a\u62a5\u8868\u9879\u3002", (String)"ConvertDiffFormulaPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            if (leftformula.indexOf(41) != leftformula.length() - 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f\u6b63\u786e\u6027\u3002", (String)"ConvertDiffFormulaPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            int fin = leftformula.indexOf("\"A.");
            if (fin >= 0) {
                String acountNum;
                QFilter q;
                DynamicObject d;
                int din = 0;
                for (int i = fin + 1; i < leftformula.length(); ++i) {
                    if (leftformula.charAt(i) != '\"') continue;
                    din = i;
                    break;
                }
                if (din > fin + 3 && (d = QueryServiceHelper.queryOne((String)"bcm_accountmembertree", (String)"isleaf", (QFilter[])(q = new QFilter("number", "=", (Object)(acountNum = leftformula.substring(fin + 3, din))).and("model", "=", (Object)this.getModelId())).toArray())) != null && !d.getBoolean("isleaf")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7b49\u5f0f\u5de6\u8fb9\u79d1\u76ee\u6210\u5458\u5fc5\u987b\u662f\u660e\u7ec6\u79d1\u76ee\u3002", (String)"ConvertDiffFormulaPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f", (String)"ConvertDiffFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        if ("formulacb".equals(key)) {
            if (cb.getReturnData() != null) {
                String formula = cb.getReturnData().toString();
                String sign = this.getComboSign("formula_fx_");
                this.getPageCache().put(sign, formula);
                this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
                CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
                custom.setData(CheckedFormulaUtil.packAddText((String)sign, (String)this.getChinessFormula(formula)));
            }
        } else if (key.startsWith("formula") && cb.getReturnData() != null) {
            String formula = cb.getReturnData().toString();
            this.getPageCache().put(key, formula);
            String tmpnumber = this.getPageCache().get(key + "formula_temp");
            if (StringUtils.isNotEmpty((String)tmpnumber)) {
                String formulatmp = formula.replaceAll("V\\(", "V\\(\"@TMP." + tmpnumber + "\",");
                this.getPageCache().put(key + "formula_withtemp", formulatmp);
            }
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
            this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("addFormula".equals(operation)) {
            this.addFormulaCache("formula_temp_", com.getParam().get(0).toString(), com.getParam().get(1).toString(), com.getParam().get(2).toString());
            this.getPageCache(this.getView().getParentView()).put("ismodifer", "true");
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            String key = this.getComboSign("formula_temp_");
            String f = this.setDefultAT(com.getParam().get(0).toString());
            String ftp = this.setDefultAT(com.getParam().get(1).toString());
            this.getPageCache().put(key, f);
            this.getPageCache().put(key + "formula_withtemp", ftp);
            this.getPageCache().put(key + "formula_temp", com.getParam().get(2).toString());
            custom.setData(CheckedFormulaUtil.packAddText((String)key, (String)this.getChinessFormula(com.getParam().get(1).toString())));
        } else if ("saveModel".equals(operation) || "saveModelAndAddLevel".equals(operation)) {
            JSONObject data = (JSONObject)com.getParam().get(0);
            this.getPageCache().put(SAVEDATA, data.toJSONString());
            this.getPageCache().put("operation", operation);
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
        } else if ("cacheMap".equals(operation)) {
            List doc = (List)com.getParam().get(0);
            this.getPageCache().put(MAPCACHE, this.toByteSerialized(doc));
        } else if ("addLevel".equals(operation)) {
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            this.getPageCache().put(SAVEDATA, "{}");
            custom.setData(CheckedFormulaUtil.packGetText());
            this.getPageCache().put("operation", "addCheck");
        } else if ("sureAddLevel".equals(operation)) {
            this.addLevel();
        } else if ("loadformchkup".equals(operation)) {
            long fromchkupid = (Long)com.getParam().get(0);
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            custom.setData(this.packFormulaFromChkup(fromchkupid, this.getPageCache()));
        } else if ("closing".equals(operation)) {
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            this.getPageCache().put(SAVEDATA, "{}");
            custom.setData(CheckedFormulaUtil.packGetText());
            this.getPageCache().put("operation", "closingCheck");
        }
    }

    private String setDefultAT(String formula) {
        int fin = formula.indexOf("\"AT.");
        if (fin < 0) {
            return formula.substring(0, formula.length() - 1) + ",\"AT." + "EntityInput" + "\")";
        }
        return formula;
    }

    private void checkAndBuildEditPage() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)map.get("type");
        String pkid = (String)map.get("pkid");
        CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
        if (!StringUtil.isEmptyString((String)type) && "edit".equals(type)) {
            custom.setData(this.packFormula(pkid, this.getPageCache()));
        }
        if (map.get("fromchkupid") != null) {
            custom.setData(this.packFormulaFromChkup(map.get("fromchkupid"), this.getPageCache()));
        }
    }

    private Object packFormulaFromChkup(Object pkid, IPageCache pageCache) {
        DynamicObject d = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bcm_chkformulasetting");
        String lformulatemp = d.getString("lformulatemp");
        String rformulatemp = d.getString("rformulatemp");
        String formula = "";
        if (!StringUtil.isEmptyString((String)rformulatemp) && !StringUtil.isEmptyString((String)lformulatemp)) {
            String left = this.buildDatabyFormula(lformulatemp, pageCache, this.getModelId(), true);
            String right = this.buildDatabyFormula(rformulatemp, pageCache, this.getModelId(), true);
            formula = left + "=" + right;
        }
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)formula);
        String formulaStr = d.getString("lformulatemp") + "=" + d.getString("rformulatemp");
        this.getView().getParentView().getPageCache().put("oldformula", formulaStr);
        return data;
    }

    private Object packFormula(String pkid, IPageCache pageCache) {
        DynamicObject d = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bcm_convertdiffentity");
        String lformulatemp = d.getString("lformulatemp");
        String rformulatemp = d.getString("rformulatemp");
        String formula = "";
        String left = this.buildDatabyFormula(lformulatemp, pageCache, this.getModelId(), false);
        if (ChkCheckServiceHelper.isSpecialFormula((String)rformulatemp)) {
            StringBuffer sb = new StringBuffer(left).append('=');
            String tempData = this.buildJudgeFormulaDisplay(rformulatemp, sb, pageCache, this.getModelId());
            while (tempData.length() > 0) {
                tempData = this.buildJudgeFormulaDisplay(tempData, sb, pageCache, this.getModelId());
            }
            formula = sb.toString();
        } else if (!StringUtil.isEmptyString((String)rformulatemp) && !StringUtil.isEmptyString((String)lformulatemp)) {
            String right = this.buildDatabyFormula(rformulatemp, pageCache, this.getModelId(), false);
            formula = left + "=" + right;
        }
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)formula);
        String formulaStr = d.getString("lformulatemp") + "=" + d.getString("rformulatemp");
        this.getView().getParentView().getPageCache().put("oldformula", formulaStr);
        return data;
    }

    private String buildJudgeFormulaDisplay(String data, StringBuffer sb, IPageCache pageCache, long modelid) {
        int beginPosition = data.indexOf("V(");
        if (beginPosition > 0) {
            sb.append(data, 0, beginPosition);
            return data.substring(beginPosition);
        }
        if (beginPosition == -1) {
            sb.append(data);
            return "";
        }
        try {
            String item = data.substring(beginPosition, data.indexOf(41) + 1);
            sb.append(this.buildDatabyFormula(item, pageCache, modelid, false));
            return data.substring(data.indexOf(41) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String buildDatabyFormula(String formula, IPageCache pageCache, long modelid, boolean isFromChk) {
        StringBuilder sb = new StringBuilder();
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        Pair pair = Pair.onePair(null, null);
        try {
            pair = parser.parse(formula, coder);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format("%1$s : %2$s", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u516c\u5f0f", (String)"ConvertDiffFormulaPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), formula));
            return sb.toString();
        }
        int flag = 0;
        boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)modelid);
        for (int i = 0; i < ((String)pair.p1).length(); ++i) {
            if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                if (!ExpressionServiceHelper.checkFactorComplete((int)i, (String)((String)pair.p1))) continue;
                IFormula f = (IFormula)((List)pair.p2).get(flag);
                if (isFromChk && existAuditTrailDimension) {
                    for (int j = 0; j < f.getParamList().size(); ++j) {
                        ParamItem pi = (ParamItem)f.getParamList().get(j);
                        if (!DimTypesEnum.AUDITTRIAL.getShortNumber().equals(pi.toString().split("\\.")[0])) continue;
                        pi.fixParam((Object)new StringExpr(DimTypesEnum.AUDITTRIAL.getShortNumber() + '.' + "EntityInput"));
                        break;
                    }
                }
                String tmpnum = "";
                String withtmp = f.toString();
                boolean istmp = false;
                for (int j = 0; j < f.getParamList().size(); ++j) {
                    ParamItem pi = (ParamItem)f.getParamList().get(j);
                    String sn = pi.toString().split("\\.")[0];
                    String sm = pi.toString().split("\\.")[1];
                    if (!"@TMP".equals(sn)) continue;
                    tmpnum = sm;
                    f.getParamList().remove((Object)pi);
                    istmp = true;
                    break;
                }
                String notmp = f.toString();
                String key = "";
                String text = "";
                if (istmp) {
                    key = "formula_temp_" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
                    pageCache.put(key, notmp);
                    pageCache.put(key + "formula_withtemp", withtmp);
                    pageCache.put(key + "formula_temp", tmpnum);
                    text = ChkFormulaServiceHelper.translateChkformla((String)withtmp, (long)modelid, (int)3);
                } else {
                    key = "formula_fx_" + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
                    pageCache.put(key, notmp);
                    text = ChkFormulaServiceHelper.translateChkformla((String)notmp, (long)modelid, (int)3);
                }
                sb.append("{\"");
                sb.append(key);
                sb.append("\",\"");
                sb.append(text);
                sb.append("\"}");
                ++flag;
                continue;
            }
            String oper = String.valueOf(((String)pair.p1).charAt(i));
            sb.append(oper);
        }
        return sb.toString();
    }

    private String getChinessFormula(String formula) {
        long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject chineseSettring = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkdisplaysetting");
        chineseSettring.set("selectdims", (Object)"account;changetype");
        chineseSettring.set("type", (Object)"1");
        chineseSettring.set("model", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter.and("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType()), String.valueOf(TemplateTypeEnum.DYNAMICREPORT.getType())})});
        return ChkFormulaServiceHelper.tranFormulasQuick((String)formula, (long)modelId, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates);
    }

    private void addLevel() {
        CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        data.put("data", (Object)"");
        this.getPageCache(this.getView().getParentView()).put("oldformula", "");
        custom.setData((Object)data);
    }

    private void addFormulaCache(String type, String formula, String formulawithtmp, String tempnumber) {
        String sign = this.getComboSign(type);
        this.getPageCache().put(sign, formula);
        this.getPageCache().put(sign + "formula_withtemp", formulawithtmp);
        this.getPageCache().put(sign + "formula_temp", tempnumber);
    }

    private String getComboSign(String type) {
        return type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
    }

    private void showVPanel(String type, String key, Object param) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_cvtdiffvformula");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        FormulaTicketer<DynamicObject> ticketer = this.buildTicketer(type, key);
        formShowParameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
        formShowParameter.setCustomParam("formula", param);
        CloseCallBack closeCallBack = key != null ? new CloseCallBack((IFormPlugin)this, key) : new CloseCallBack((IFormPlugin)this, "formulacb");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private FormulaTicketer<DynamicObject> buildTicketer(String type, String key) {
        String csche;
        FormulaTicketer<DynamicObject> ticketer = new FormulaTicketer<DynamicObject>();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity) || "bcm_currencymembertree".equals(entity) || "bcm_scenemembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false));
                continue;
            }
            if ("bcm_periodmembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_mycompanymembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true));
                continue;
            }
            String sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true));
        }
        if ("formula_temp_".equals(type)) {
            ticketer.addTicket("bcm_accountmembertree", new FTicket("bcm_accountmembertree", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"ConvertDiffFormulaPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), null, false));
            String tempnumber = this.getPageCache().get(key + "formula_temp");
            List<Dimension> dims = this.getRowAndColDimBy(tempnumber);
            for (Dimension dim : dims) {
                String sign = DimEntityNumEnum.getEntieyNumByNumber((String)dim.getNumber());
                if ("bcm_userdefinedmembertree".equals(sign)) {
                    sign = this.sugarF7Key(sign, dim.getNumber());
                }
                ticketer.addTicket(sign, new FTicket(DimEntityNumEnum.getEntieyNumByNumber((String)dim.getNumber()), dim.getName(), null, false));
            }
        }
        if ((csche = this.getPageCache().get(MAPCACHE)) != null) {
            List doc = (List)this.deSerializedBytes(csche);
            for (Map obj : doc) {
                String number = (String)obj.get("number");
                String name = (String)obj.get("name");
                String sign = DimEntityNumEnum.getEntieyNumByNumber((String)number);
                if ("bcm_userdefinedmembertree".equals(sign)) {
                    sign = this.sugarF7Key(sign, number);
                }
                ticketer.addTicket(sign, new FTicket(DimEntityNumEnum.getEntieyNumByNumber((String)number), name, null, false, false));
            }
        }
        ticketer.forEach(t -> {
            String k = (String)t.getKey();
            ((FTicket)t.getValue()).setMustInput(!"bcm_currencymembertree".equals(k) && !"bcm_processmembertree".equals(k) && !"bcm_periodmembertree".equals(k) && !"bcm_fymembertree".equals(k) && !"bcm_mycompanymembertree".equals(k));
        });
        return ticketer;
    }

    private List<Dimension> getRowAndColDimBy(String tmpnumber) {
        ArrayList<Dimension> list = new ArrayList<Dimension>(10);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tmpnumber), new QFilter("model", "=", (Object)this.getModelId()), new QFilter("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType()), String.valueOf(TemplateTypeEnum.DYNAMICREPORT.getType())})});
        if (null == obj) {
            return list;
        }
        DynamicObject mo = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"bcm_templateentity");
        TemplateModel model = new TemplateModel();
        model.loadDynaObj2Model(mo);
        AreaRangeEntry a = (AreaRangeEntry)model.getAreaRangeEntries().get(0);
        for (RowDimensionEntry r : a.getRowDimEntries()) {
            list.add(r.getDimension());
        }
        for (RowDimensionEntry r : a.getColDimEntries()) {
            list.add(r.getDimension());
        }
        return list;
    }

    private VFormula buildDefaultFormula() {
        VFormula v = new VFormula();
        v.initParam(new ParamList());
        QFilter qf = new QFilter("model.id", "=", (Object)this.getModelId());
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id,name,number,shortnumber,issysdimension";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfs);
        boolean existAuditTrailDimension = MemberReader.isExistAuditTrailDimension((long)this.getModelId());
        for (DynamicObject dim : dcs) {
            ParamItem pi;
            String shortnumber = dim.getString("shortnumber");
            boolean issysdimension = dim.getBoolean("issysdimension");
            if (this.isExistChangeTypeDimension() && DimTypesEnum.CHANGETYPE.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.CHANGETYPE.getShortNumber() + "." + "YTD"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.INTERCOMPANY.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.INTERCOMPANY.getShortNumber() + "." + "ICNone"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.AUDITTRIAL.getShortNumber().equals(shortnumber) && existAuditTrailDimension) {
                pi = new ParamItem((Object)(DimTypesEnum.AUDITTRIAL.getShortNumber() + "." + "EntityInput"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.MULTIGAAP.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.MULTIGAAP.getShortNumber() + "." + "PRCGAAP"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.DATASORT.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.DATASORT.getShortNumber() + "." + "Actual"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (issysdimension) continue;
            pi = new ParamItem((Object)(shortnumber + "." + shortnumber + "None"));
            v.getParamList().add((Object)pi);
        }
        return v;
    }
}

