/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertdifference;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertDiffHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ImportExportUtils;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportHelper;
import kd.fi.bcm.formplugin.dimension.batchimp.helper.ImportOperateType;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertDiffImportPlugin
extends AbsCommonImport {
    private Map<String, Long> modelShowNumberofIdMap = new HashMap<String, Long>(16);
    private Map<Long, Map<String, List<DynamicObject>>> convertNum2DyMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
    private Map<Long, Map<String, List<DynamicObject>>> convertName2DyMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
    private Map<Long, Map<String, Set<Long>>> tlpNumber2IdMap = new HashMap<Long, Map<String, Set<Long>>>(16);
    private Map<Long, Set<Long>> tlpNoPermIdMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, DynamicObjectCollection> model2TemplateMap = new HashMap<Long, DynamicObjectCollection>(16);
    private Map<Long, DynamicObjectCollection> model2DimMap = new HashMap<Long, DynamicObjectCollection>(16);
    private Map<Long, Map<Integer, String>> chkformulaMap = new HashMap<Long, Map<Integer, String>>(16);
    private Set<String> nonMustDimShortNums = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.MYCOMPANY.getShortNumber(), DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber()});
    private ExpressParser parser = new ExpressParser();
    private EncoderService coder = new EncoderService();

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.entityName = "bcm_convertdiffentity";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        super.beforeSave(billDatas, logger);
        this.initData(billDatas);
    }

    public String getLocalString(Object val) {
        if (val == null) {
            return "";
        }
        if (val instanceof Map) {
            return LocaleString.fromMap((Map)((Map)val)).toString().trim();
        }
        return val.toString().trim();
    }

    private void initData(List<ImportBillData> billDatas) {
        HashMap tlpMap = new HashMap(16);
        HashMap<Long, Pair> convertNumAndNameMap = new HashMap<Long, Pair>(16);
        billDatas.stream().forEach(bill -> {
            String modelShowNumber = ImportHelper.getImportBillProp(bill, "model.shownumber").toString();
            if (StringUtils.isNotEmpty((CharSequence)modelShowNumber)) {
                Long modelId = this.modelShowNumberofIdMap.computeIfAbsent(modelShowNumber, k -> {
                    try {
                        String modelNumber = MemberReader.findModelNumberByShowNum((String)k);
                        if (StringUtils.isNotEmpty((CharSequence)modelNumber)) {
                            return MemberReader.findModelIdByNum((String)modelNumber);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 0L;
                });
                bill.getData().put("model.id", (Object)modelId);
                if (modelId == 0L) {
                    return;
                }
                Object templateJson = ImportHelper.getImportBillProp(bill, "multitemplate");
                if (templateJson instanceof JSONObject) {
                    String tnumber = ((JSONObject)templateJson).getString("number");
                    tlpMap.computeIfAbsent(modelId, k -> new HashSet(16)).addAll(Arrays.asList(tnumber.split(",")));
                }
                Pair setSetPair = convertNumAndNameMap.computeIfAbsent(modelId, k -> Pair.onePair(new HashSet(16), new HashSet(16)));
                ((Set)setSetPair.p1).add(ImportHelper.getImportBillProp(bill, "number").toString());
                ((Set)setSetPair.p2).add(this.getLocalString(ImportHelper.getImportBillProp(bill, "name")));
            }
        });
        convertNumAndNameMap.forEach((modelId, v) -> {
            QFilter qFilter = new QFilter("model", "=", modelId);
            qFilter.and(new QFilter("name", "in", v.p2).or(new QFilter("number", "in", v.p1)));
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_convertdiffentity", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
            dyns.stream().forEach(e -> {
                this.convertNum2DyMap.computeIfAbsent((Long)modelId, k -> new HashMap(16)).computeIfAbsent(e.getString("number"), k -> new ArrayList(1)).add(e);
                this.convertName2DyMap.computeIfAbsent((Long)modelId, k -> new HashMap(16)).computeIfAbsent(e.getString("name"), k -> new ArrayList(1)).add(e);
            });
        });
        this.modelShowNumberofIdMap.forEach((showNumber, modelId) -> {
            QFilter[] qf = new QFilter("model", "=", modelId).toArray();
            Set templateNumbers = tlpMap.getOrDefault(modelId, Collections.emptySet());
            DynamicObjectCollection temps = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name,number,versionnumber,templatetype", (QFilter[])qf);
            HashSet templateTypes = Sets.newHashSet((Object[])new Integer[]{TemplateTypeEnum.FIX.getType(), TemplateTypeEnum.DYNA.getType(), TemplateTypeEnum.DYNAMICREPORT.getType()});
            List collect = temps.stream().filter(e -> templateNumbers.contains(e.getString("number")) && templateTypes.contains(e.getInt("templatetype"))).collect(Collectors.toList());
            TemplateUtil.filterVersionTemplateTree(collect);
            Map tlpNumberMaps = this.tlpNumber2IdMap.computeIfAbsent((Long)modelId, k -> new HashMap());
            collect.stream().forEach(tlp -> tlpNumberMaps.computeIfAbsent(tlp.getString("number"), k -> new HashSet()).add(tlp.getLong("id")));
            this.tlpNoPermIdMap.put((Long)modelId, PermClassCache.getPermClassIds((Long)modelId, (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO, DataTypeEnum.READ}));
            this.model2TemplateMap.put((Long)modelId, temps);
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])qf);
            this.model2DimMap.put((Long)modelId, dims);
        });
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        Optional<String> checkMsg;
        String lformulatemp;
        String number;
        if (StringUtils.isEmpty((CharSequence)ImportHelper.getImportBillProp(bill, "model.shownumber").toString())) {
            String fieldName = ResManager.loadKDString((String)"\u4f53\u7cfb", (String)"ConvertDiffImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldName);
            return Optional.of(msg);
        }
        Long modelId = (Long)bill.getData().get((Object)"model.id");
        if (modelId == 0L) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u3002", (String)"ExchangeRateMaintainImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        String sceneNumber = ImportHelper.getImportBillProp(bill, "scenario.number").toString();
        if (!StringUtils.isEmpty((CharSequence)sceneNumber)) {
            if (sceneNumber == null || sceneNumber.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ExchangeRateMaintainImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Optional.of(msg);
            }
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)sceneNumber);
            if (scene == IDNumberTreeNode.NotFoundTreeNode) {
                String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u60c5\u666f\u7f16\u7801\u3002", (String)"ConvertDiffImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Optional.of(msg);
            }
        } else {
            JSONArray sceneJson = (JSONArray)ImportHelper.getImportBillProp(bill, "scenarios");
            Optional<String> scenemsg = this.checkApplyScenes(modelId, sceneJson);
            if (scenemsg.isPresent()) {
                return scenemsg;
            }
        }
        if (StringUtils.isEmpty((CharSequence)(number = ImportHelper.getImportBillProp(bill, "number").toString()))) {
            String fieldName = ResManager.loadKDString((String)"\u7f16\u7801", (String)"ConvertDiffImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldName);
            return Optional.of(msg);
        }
        if (number.length() > 50) {
            String msg = ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ConvertDiffImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        String name = ImportHelper.getImportBillProp(bill, "name").toString();
        if (name.length() > 50) {
            String msg = ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\u3002", (String)"ConvertDiffImportPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        if (ImportOperateType.NEW == ImportHelper.getImportType(this.ctx)) {
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (dbOld.isPresent()) {
                return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataAuthMainImport_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else if (this.checkRepeatRecord(modelId, bill)) {
            return Optional.of(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u5b58\u5728\u591a\u6761\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"ConvertDiffImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)(lformulatemp = ImportHelper.getImportBillProp(bill, "lformulatemp").toString()))) {
            String fieldName = ResManager.loadKDString((String)"\u5de6\u7b49\u5f0f\u5e26\u6a21\u677f", (String)"ConvertDiffImportPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldName);
            return Optional.of(msg);
        }
        String rformulatemp = ImportHelper.getImportBillProp(bill, "rformulatemp").toString();
        if (StringUtils.isEmpty((CharSequence)rformulatemp)) {
            String fieldName = ResManager.loadKDString((String)"\u53f3\u7b49\u5f0f\u5e26\u6a21\u677f", (String)"ConvertDiffImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), fieldName);
            return Optional.of(msg);
        }
        Object templateJson = ImportHelper.getImportBillProp(bill, "multitemplate");
        if (templateJson instanceof JSONObject) {
            String tnumber = ((JSONObject)templateJson).getString("number");
            HashSet<String> templateNumbers = new HashSet<String>(Arrays.asList(tnumber.split(",")));
            Map<String, Set> tplMap = this.tlpNumber2IdMap.getOrDefault(modelId, Collections.emptyMap());
            List collect = templateNumbers.stream().filter(tlpNumber -> !tplMap.containsKey(tlpNumber)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6a21\u677f%1$s\u4e0d\u5408\u683c\u7f16\u7801\u4e3a%2$s", (String)"ConvertDiffImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b57\u6bb5\u6240\u5f55\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ConvertDiffImportPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), collect);
                return Optional.of(msg);
            }
            ArrayList noPermNumbers = new ArrayList(16);
            tplMap.forEach((num, ids) -> {
                if (ids.stream().anyMatch(e -> this.tlpNoPermIdMap.get(modelId).contains(e))) {
                    noPermNumbers.add(num);
                }
            });
            if (!noPermNumbers.isEmpty()) {
                String msg = String.format(ResManager.loadKDString((String)"\u6240\u5c5e\u6a21\u677f%1$s\u65e0\u6743", (String)"ConvertDiffImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), noPermNumbers);
                return Optional.of(msg);
            }
        }
        if ((checkMsg = this.checkFormulaRight(modelId, bill, lformulatemp, rformulatemp)).isPresent()) {
            return checkMsg;
        }
        JSONArray effectiveJson = (JSONArray)ImportHelper.getImportBillProp(bill, "effective");
        checkMsg = this.checkEffectiveDate(modelId, effectiveJson);
        return checkMsg;
    }

    private boolean checkRepeatRecord(long modelId, ImportBillData bill) {
        List dys = this.convertNum2DyMap.getOrDefault(modelId, Collections.emptyMap()).getOrDefault(ImportHelper.getImportBillProp(bill, "number"), Collections.emptyList());
        List dys2 = this.convertName2DyMap.getOrDefault(modelId, Collections.emptyMap()).getOrDefault(this.getLocalString(ImportHelper.getImportBillProp(bill, "name")), Collections.emptyList());
        if (dys.size() >= 2 || dys2.size() >= 2) {
            return true;
        }
        return dys.size() == 1 && dys2.size() == 1 && dys.get(0) != dys2.get(0);
    }

    private List<Map<String, Object>> getEffectiveDate(Long modelId, ImportBillData bill) {
        JSONArray effectiveJson = (JSONArray)ImportHelper.getImportBillProp(bill, "effective");
        ArrayList<Map<String, Object>> effectivedate = new ArrayList<Map<String, Object>>(8);
        if (effectiveJson == null) {
            return effectivedate;
        }
        for (Object entryJson : effectiveJson) {
            JSONObject periodJson;
            HashMap<String, Object> effectivedateMap = new HashMap<String, Object>();
            Object applytype = ((JSONObject)entryJson).get((Object)"applytype");
            Object yearscope = ((JSONObject)entryJson).get((Object)"yearscope");
            if (ObjectUtils.isEmpty((Object)applytype) && ObjectUtils.isEmpty((Object)yearscope)) continue;
            effectivedateMap.put("applytype", applytype);
            effectivedateMap.put("yearscope", yearscope);
            JSONObject yearJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveyear");
            if (yearJson != null) {
                IDNumberTreeNode year = MemberReader.findFyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)yearJson.getString("number"));
                effectivedateMap.put("effectiveyear", year);
            }
            if ((periodJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveperiod")) != null) {
                IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)periodJson.getString("number"));
                effectivedateMap.put("effectiveperiod", period);
            }
            effectivedate.add(effectivedateMap);
        }
        return effectivedate;
    }

    private List<Map<String, Object>> getScenes(Long modelId, ImportBillData bill) {
        ArrayList<Map<String, Object>> scenes = new ArrayList<Map<String, Object>>();
        String sceneNumber = ImportHelper.getImportBillProp(bill, "scenario.number").toString();
        if (!StringUtils.isEmpty((CharSequence)sceneNumber)) {
            HashMap<String, Object> sceneMap = new HashMap<String, Object>();
            sceneMap.put("isexcept", "0");
            sceneMap.put("scenarioscope", "10");
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)sceneNumber);
            sceneMap.put("scenariomeb", scene.getId());
            scenes.add(sceneMap);
            return scenes;
        }
        JSONArray sceneJson = (JSONArray)ImportHelper.getImportBillProp(bill, "scenarios");
        if (sceneJson == null) {
            return scenes;
        }
        for (Object entryJson : sceneJson) {
            HashMap<String, Object> sceneMap = new HashMap<String, Object>();
            Object scope = ((JSONObject)entryJson).get((Object)"scenarioscope");
            Object isexcept = ((JSONObject)entryJson).get((Object)"isexcept");
            JSONObject scenejson = (JSONObject)((JSONObject)entryJson).get((Object)"scenariomeb");
            sceneMap.put("isexcept", isexcept);
            sceneMap.put("scenarioscope", scope);
            String number = scenejson.getString("number");
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)number);
            sceneMap.put("scenariomeb", scene.getId());
            scenes.add(sceneMap);
        }
        return scenes;
    }

    private Optional<String> checkApplyScenes(Long modelId, JSONArray sceneJson) {
        if (sceneJson == null || sceneJson.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u9002\u7528\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertDiffImportPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        for (Object entryJson : sceneJson) {
            Object scope = ((JSONObject)entryJson).get((Object)"scenarioscope");
            Object isexcept = ((JSONObject)entryJson).get((Object)"isexcept");
            if (ObjectUtils.isEmpty((Object)isexcept) || ObjectUtils.isEmpty((Object)scope)) {
                return Optional.of(ResManager.loadKDString((String)"\u9002\u7528\u7c7b\u578b\uff0c\u60c5\u666f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            JSONObject scenejson = (JSONObject)((JSONObject)entryJson).get((Object)"scenariomeb");
            if (scenejson == null) {
                String msg = ResManager.loadKDString((String)"\u60c5\u666f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                return Optional.of(msg);
            }
            IDNumberTreeNode scene = MemberReader.findScenaMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)scenejson.getString("number"));
            if (scene != IDNumberTreeNode.NotFoundTreeNode) continue;
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5bfc\u5165\u7684\u60c5\u666f\u7f16\u7801\u3002", (String)"ConvertDiffImportPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            return Optional.of(msg);
        }
        return Optional.empty();
    }

    private Optional<String> checkEffectiveDate(Long modelId, JSONArray effectiveJson) {
        if (effectiveJson == null) {
            return Optional.empty();
        }
        for (Object entryJson : effectiveJson) {
            IDNumberTreeNode year;
            Object applytype = ((JSONObject)entryJson).get((Object)"applytype");
            Object yearscope = ((JSONObject)entryJson).get((Object)"yearscope");
            if (ObjectUtils.isEmpty((Object)applytype) || ObjectUtils.isEmpty((Object)yearscope)) {
                return Optional.of(ResManager.loadKDString((String)"\u5206\u7ec4\u540d\u79f0\uff0c\u8d22\u5e74\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConvertDiffImportPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            JSONObject yearJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveyear");
            if (yearJson != null && (year = MemberReader.findFyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)yearJson.getString("number"))) == IDNumberTreeNode.NotFoundTreeNode) {
                return Optional.of(ResManager.loadKDString((String)"\u8d22\u5e74\u7f16\u7801\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            JSONObject periodJson = (JSONObject)((JSONObject)entryJson).get((Object)"effectiveperiod");
            if (periodJson == null) continue;
            QFilter q = new QFilter("number", "=", (Object)periodJson.getString("number"));
            QFilter f = new QFilter("model", "=", (Object)modelId);
            IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)periodJson.getString("number"));
            if (period != IDNumberTreeNode.NotFoundTreeNode) continue;
            return Optional.of(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e0d\u5b58\u5728", (String)"LinkageMappingImport_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private Optional<String> checkFormulaRight(Long modelId, ImportBillData bill, String lformulatemp, String rformulatemp) {
        DynamicObjectCollection dims = this.model2DimMap.get(modelId);
        List selectdims = dims.stream().filter(e -> !e.getString("number").equals(DimTypesEnum.CURRENCY.getNumber())).map(p -> p.getString("number").toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        Map allMember = DimensionServiceHelper.queryDimShortNumbers(selectdims, (Object)modelId);
        String msg = this.checkFormulaTpl(modelId, lformulatemp, allMember);
        if (!"1".equalsIgnoreCase(msg)) {
            return Optional.of(msg);
        }
        lformulatemp = ConvertDiffHelper.replaceLeftformulaAT2C((long)modelId, (String)lformulatemp);
        bill.getData().put("lformulatemp", (Object)lformulatemp);
        msg = this.checkFormulaTpl(modelId, rformulatemp, allMember);
        if (!"1".equalsIgnoreCase(msg)) {
            return Optional.of(msg);
        }
        String formula = lformulatemp + "=" + rformulatemp;
        String chineseFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)formula, (long)modelId, (int)1, null, (DynamicObjectCollection)this.model2TemplateMap.get(modelId));
        if (StringUtils.equals((CharSequence)chineseFormula, (CharSequence)formula)) {
            return Optional.of(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u539f\u56e0\u3002", (String)"ConvertDiffImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.chkformulaMap.computeIfAbsent(modelId, k -> new HashMap(16)).put(bill.getStartIndex(), chineseFormula);
        return Optional.empty();
    }

    private String checkFormulaTpl(Long modelId, String formula, Map<String, Map<String, DynamicObject>> allMember) {
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            try {
                if (ObjectUtils.isEmpty((Object)this.convertBigDecimal(formula))) {
                    FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)formula);
                    List vformulas = poolMng.pull("V");
                    if (vformulas != null) {
                        Set dimShortNums = allMember.keySet().stream().collect(Collectors.toSet());
                        dimShortNums.add("C");
                        StringJoiner sb = new StringJoiner("\n");
                        for (IFormula vformula : vformulas) {
                            HashSet temp = new HashSet(dimShortNums);
                            ChkFormulaServiceHelper.translateChkformla((String)vformula.toString(), (long)modelId, (int)1, dimShortNumber -> {
                                if (!dimShortNums.contains(dimShortNumber)) {
                                    sb.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165%1$s\u516c\u5f0f\u4e2d\u7684\u7ef4\u5ea6%2$s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ConvertDiffImportPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]), vformula.toString(), dimShortNumber));
                                } else if (!temp.remove(dimShortNumber)) {
                                    sb.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165%1$s\u516c\u5f0f\u4e2d\u7684\u7ef4\u5ea6%2$s\u5df2\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ConvertDiffImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), vformula.toString(), dimShortNumber));
                                }
                            }, (shortNum, memberNumber) -> {
                                if ("C".equals(shortNum)) {
                                    if (StringUtils.isNotEmpty((CharSequence)memberNumber) && !memberNumber.equals("CvtAfter") && !memberNumber.equals("CvtBefore")) {
                                        sb.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165%1$s\u516c\u5f0f\u4e2d\u7684\u7ef4\u5ea6%2$s\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ConvertDiffImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]), vformula.toString(), shortNum));
                                    }
                                    return true;
                                }
                                return false;
                            }, (boolean)true);
                            List collect = temp.stream().filter(e -> !this.nonMustDimShortNums.contains(e)).collect(Collectors.toList());
                            if (collect.isEmpty()) continue;
                            sb.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u516c\u5f0f\u201c%1$s\u201d\u4e2d\u7684\u5fc5\u5f55\u7ef4\u5ea6\u201c%2$s\u201d\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ConvertDiffImportPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), vformula.toString(), collect.toString()));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)sb.toString())) {
                            return sb.toString();
                        }
                    }
                    try {
                        this.parser.parse(formula, this.coder);
                    }
                    catch (Exception e2) {
                        return ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u539f\u56e0\u3002", (String)"ConvertDiffImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    }
                }
                return "1";
            }
            catch (KDBizException e3) {
                return e3.getMessage();
            }
            catch (Exception e4) {
                return String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u4e0d\u5b58\u5728\u7ef4\u5ea6,\u516c\u5f0f\u586b\u5199\u9519\u8bef\u3002", (String)"ConvertDiffImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ConvertDiffImportPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private BigDecimal convertBigDecimal(Object account) {
        if (ObjectUtils.isEmpty((Object)account)) {
            return null;
        }
        try {
            return new BigDecimal(account.toString()).setScale(15, RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        Long modelId = (Long)rowData.getData().get((Object)"model.id");
        List dyns = (List)this.convertNum2DyMap.getOrDefault(modelId, Collections.emptyMap()).get(ImportHelper.getImportBillProp(rowData, "number"));
        if (CollectionUtils.isEmpty((Collection)dyns)) {
            dyns = (List)this.convertName2DyMap.getOrDefault(modelId, Collections.emptyMap()).get(this.getLocalString(ImportHelper.getImportBillProp(rowData, "name")));
        }
        return CollectionUtils.isEmpty((Collection)dyns) ? Optional.empty() : Optional.of(dyns.get(0));
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dyn = this.getDynamicObject(billDataList.get(i));
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyn.set("createtime", (Object)TimeServiceHelper.now());
            dys[i] = dyn;
        }
        return dys;
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        DynamicObject[] dys = new DynamicObject[billDataList.size()];
        for (int i = 0; i < billDataList.size(); ++i) {
            DynamicObject dyn = this.getDynamicObject(billDataList.get(i));
            dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dyn.set("modifytime", (Object)TimeServiceHelper.now());
            dys[i] = dyn;
        }
        return dys;
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        if (dys != null) {
            Set ids = Arrays.stream(dys).map(e -> e.getLong("id")).collect(Collectors.toSet());
            DeleteServiceHelper.delete((String)this.entityName, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    private DynamicObject getDynamicObject(ImportBillData rowData) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        if (rowData.getData().containsKey((Object)"id")) {
            dyn.set("id", ImportHelper.getImportBillProp(rowData, "id"));
        }
        Long modelId = (Long)rowData.getData().get((Object)"model.id");
        dyn.set("model", (Object)modelId);
        Object name = ImportHelper.getImportBillProp(rowData, "name");
        if (name instanceof Map) {
            dyn.set("name", (Object)LocaleString.fromMap((Map)((Map)name)).toString().trim());
        } else {
            dyn.set("name", (Object)name.toString().trim());
        }
        String number = ImportHelper.getImportBillProp(rowData, "number").toString();
        dyn.set("number", (Object)number);
        String status = ImportHelper.getImportBillProp(rowData, "status").toString();
        dyn.set("status", (Object)status);
        String description = ImportHelper.getImportBillProp(rowData, "description").toString();
        dyn.set("description", (Object)description);
        this.setMultitemplateData(dyn, rowData);
        String priority = (String)ImportHelper.getImportBillProp(rowData, "priority");
        Boolean unbizrule = (Boolean)ImportHelper.getImportBillProp(rowData, "unbizrule");
        dyn.set("priority", (Object)priority);
        dyn.set("unbizrule", unbizrule == null ? Integer.valueOf(1) : priority);
        this.setRangeDimData(dyn, rowData);
        this.buildScenesData(dyn, rowData);
        this.buildEntryentityData(dyn, rowData);
        String lformulatemp = ImportHelper.getImportBillProp(rowData, "lformulatemp").toString();
        String rformulatemp = ImportHelper.getImportBillProp(rowData, "rformulatemp").toString();
        String leftformula = this.cutTpl(lformulatemp, modelId);
        String rightformula = this.cutTpl(rformulatemp, modelId);
        String vformula = leftformula + "=" + rightformula;
        String chineseFormula = (String)this.chkformulaMap.getOrDefault(modelId, Collections.emptyMap()).get(rowData.getStartIndex());
        dyn.set("vformula", (Object)vformula);
        dyn.set("chineseformula", (Object)chineseFormula);
        dyn.set("chformula", (Object)(chineseFormula.length() > 255 ? chineseFormula.substring(0, 252) + "..." : chineseFormula));
        dyn.set("leftformula", (Object)leftformula);
        dyn.set("lformulatemp", (Object)lformulatemp);
        dyn.set("rightformula", (Object)rightformula);
        dyn.set("rformulatemp", (Object)rformulatemp);
        return dyn;
    }

    private void setMultitemplateData(DynamicObject dyn, ImportBillData rowData) {
        Object templateJson = ImportHelper.getImportBillProp(rowData, "multitemplate");
        if (!(templateJson instanceof JSONObject)) {
            return;
        }
        String tnumber = ((JSONObject)templateJson).getString("number");
        HashSet<String> templateNumbers = new HashSet<String>(Arrays.asList(tnumber.split(",")));
        Map<String, Set<Long>> tmp = this.tlpNumber2IdMap.get(dyn.getLong("model"));
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("multitemplate");
        templateNumbers.stream().forEach(e -> ((Set)tmp.get(e)).stream().forEach(multitemplate -> {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("fbasedataid_id", multitemplate);
        }));
    }

    private void setRangeDimData(DynamicObject dyn, ImportBillData rowData) {
        DynamicObjectCollection mem = dyn.getDynamicObjectCollection("entryentity");
        String rangetxt = ImportHelper.getImportBillProp(rowData, "rangetxt").toString();
        HashMap dimMap = new HashMap();
        new ImportExportUtils(Long.valueOf(dyn.getLong("model"))).cutDimStr(rangetxt, dimMap);
        for (Map.Entry en : dimMap.entrySet()) {
            for (Map.Entry en2 : ((Map)en.getValue()).entrySet()) {
                DynamicObject mementry = mem.addNew();
                mementry.set("memberid", en2.getKey());
                mementry.set("membbound", ((Map)en2.getValue()).get("id"));
                mementry.set("dimension", en.getKey());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)rangetxt)) {
            dyn.set("rangetxt", (Object)rangetxt);
            dyn.set("scopetxt", (Object)(rangetxt.length() > 255 ? rangetxt.substring(0, 252) + "..." : rangetxt));
        }
    }

    private void buildScenesData(DynamicObject dyn, ImportBillData rowData) {
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("scenarios");
        List<Map<String, Object>> sceneData = this.getScenes(dyn.getLong("model"), rowData);
        int seq = 0;
        for (Map<String, Object> one : sceneData) {
            DynamicObject rowObj = entry.addNew();
            one.forEach((k, v) -> rowObj.set(k, v));
            rowObj.set("seq", (Object)seq);
            ++seq;
        }
    }

    private void buildEntryentityData(DynamicObject dyn, ImportBillData rowData) {
        DynamicObjectCollection entry = dyn.getDynamicObjectCollection("effective");
        StringBuilder sb = new StringBuilder();
        List<Map<String, Object>> effectivedate = this.getEffectiveDate(dyn.getLong("model"), rowData);
        effectivedate.forEach(p -> {
            DynamicObject newEntryObj = entry.addNew();
            newEntryObj.set("applytype", p.get("applytype"));
            sb.append("1".equals(p.get("applytype").toString()) ? ResManager.loadKDString((String)"\u9002\u7528", (String)"ConvertDiffImportPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f8b\u5916", (String)"ConvertDiffImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            IDNumberTreeNode year = (IDNumberTreeNode)p.get("effectiveyear");
            if (year != null) {
                newEntryObj.set("effectiveyear", (Object)year.getId());
                sb.append(year.getName());
            }
            newEntryObj.set("yearscope", (Object)(ObjectUtils.isEmpty(p.get("yearscope")) ? Integer.valueOf(2) : p.get("yearscope")));
            switch (p.get("yearscope") + "") {
                case "3": {
                    sb.append(ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u524d\u8d22\u5e74", (String)"ConvertDiffImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "4": {
                    sb.append(ResManager.loadKDString((String)"\u5df2\u9009\u53ca\u4e4b\u540e\u8d22\u5e74", (String)"ConvertDiffImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    sb.append(ResManager.loadKDString((String)"\u4ec5\u5df2\u9009\u8d22\u5e74", (String)"ConvertDiffImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            IDNumberTreeNode period = (IDNumberTreeNode)p.get("effectiveperiod");
            if (period != null) {
                newEntryObj.set("effectiveperiod", (Object)period.getId());
                sb.append(period.getName());
            }
            sb.append(';');
        });
        dyn.set("periodtxt", (Object)sb.toString());
    }

    private String cutTpl(String rightFormula, Long modelId) {
        while (rightFormula.contains("\"@TMP.")) {
            rightFormula = this.cutStr(rightFormula, "\"@TMP.", modelId);
        }
        return rightFormula;
    }

    private String cutStr(String r, String string, Long modelId) {
        if (r.contains(string)) {
            int j;
            int i = r.indexOf(string);
            for (j = i + 1; j < r.length() && r.charAt(j) != '\"'; ++j) {
            }
            if (r.charAt(++j) != ',') {
                --i;
            } else {
                ++j;
            }
            String tmpNum = r.substring(i + string.length(), j - 2);
            if (!this.model2TemplateMap.get(modelId).stream().anyMatch(e -> e.getString("number").equals(tmpNum))) {
                throw new KDBizException(ResManager.loadKDString((String)"%s\u6a21\u677f\u4e0d\u5b58\u5728", (String)"ConvertDiffImportPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[]{tmpNum}));
            }
            String tmp = r.substring(0, i) + r.substring(j);
            if (tmp.contains(string)) {
                return this.cutStr(tmp, string, modelId);
            }
            return tmp;
        }
        return r;
    }
}

