/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertdifference;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ConvertDiffMainPagePlugin
extends AbstractBaseFormPlugin
implements MainPage {
    private static final String OLDFORMULA = "oldformula";
    private static final String CURFORMULA = "curformula";
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ConvertDiffMainPagePlugin.class);
    public static final String SCENARIOS = "scenarios";
    public static final String SCENARIONAMES = "scenarionames";

    private OpNameMultiLangEnumBridge getOperationUpdate() {
        return new OpNameMultiLangEnumBridge("\u66f4\u65b0\u4fdd\u5b58", "ConvertDiffMainPagePlugin_1", "fi-bcm-formplugin", "Update Save");
    }

    private OpNameMultiLangEnumBridge getOperationSave() {
        return new OpNameMultiLangEnumBridge("\u65b0\u589e\u4fdd\u5b58", "ConvertDiffMainPagePlugin_0", "fi-bcm-formplugin", "Add Save");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("baseinfo", (String)this.getView().getFormShowParameter().getCustomParams().get("baseinfo"));
        this.initData();
        this.showFromView("base", "bcm_convertdiffrange");
        this.showFromView("spreadpanel", "bcm_chksettingrpt");
        this.showFromView("formula", "bcm_convertdiffformula");
    }

    private void initData() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)map.get("type");
        String pkid = (String)map.get("pkid");
        if (!StringUtil.isEmptyString((String)type) && "edit".equals(type)) {
            this.getPageCache().put("pkid", pkid);
            DynamicObject condiff = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bcm_convertdiffentity");
            String name = condiff.getString("name");
            String number = condiff.getString("number");
            String priority = condiff.getString("priority");
            boolean unbizrule = condiff.getBoolean("unbizrule");
            String periodtxt = condiff.getString("periodtxt");
            String description = condiff.getString("description");
            DynamicObjectCollection dc = condiff.getDynamicObjectCollection("multitemplate");
            JSONObject js = new JSONObject();
            js.put("name", (Object)name);
            js.put("number", (Object)number);
            js.put("priority", (Object)priority);
            js.put("unbizrule", (Object)unbizrule);
            js.put("periodtxt", (Object)periodtxt);
            js.put("description", (Object)description);
            JSONArray ja = new JSONArray();
            for (DynamicObject d : dc) {
                ja.add((Object)d.getLong("fbasedataid_id"));
            }
            DynamicObjectCollection scenes = condiff.getDynamicObjectCollection(SCENARIOS);
            Pair p = PaperTemplateSceneSettingHelper.getItemAndNameByDyn((DynamicObjectCollection)scenes);
            js.put("multitemplate", (Object)ja);
            js.put(SCENARIOS, p.p2);
            js.put(SCENARIONAMES, p.p1);
            this.getPageCache().put("baseinfo", js.toJSONString());
            if (this.isNoPerm(condiff)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
            }
        } else {
            this.getPageCache().put("pkid", "");
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_itemaddlevel"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            if (StringUtil.isEmptyString((String)this.getPageCache().get("baseinfo"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"ConvertDiffMainPagePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "saveModel", new JSONObject());
            this.sendMsg(this.getView(), com);
        } else if ("bar_base".equals(key)) {
            this.showBaseInfo(true);
        } else if ("bar_itemaddlevel".equals(key)) {
            if (this.getPageCache().get("baseinfo_confirm") != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u6267\u884c\u4e86\u786e\u5b9a\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"ConvertDiffMainPagePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("addLevel", (IFormPlugin)this));
            } else {
                CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "addLevel", new Object[0]);
                this.sendMsg(this.getView(), com);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object o;
        super.closedCallBack(closedCallBackEvent);
        if ("bcm_convertdiffinfo".equals(closedCallBackEvent.getActionId()) && (o = closedCallBackEvent.getReturnData()) != null) {
            JSONObject obj;
            this.getPageCache().put("baseinfo_confirm", "true");
            String jstr = (String)this.deSerializedBytes((String)o);
            this.getPageCache().put("baseinfo", jstr);
            if (!StringUtil.isEmptyString((String)jstr) && (obj = JSON.parseObject((String)jstr)).get((Object)"fromchkupid") != null) {
                long fromchkupid = obj.getLong("fromchkupid");
                CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "loadformchkup", fromchkupid);
                this.sendMsg(this.getView(), com);
                com.setReceiver("bcm_convertdiffformula");
                this.sendMsg(this.getView(), com);
            }
        }
    }

    private boolean isNoPerm(DynamicObject dy) {
        Set noPerms = PermClassCache.getPermClassIds((Long)this.getModelId(), (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO, DataTypeEnum.READ});
        if (CollectionUtils.isNotEmpty((Collection)noPerms)) {
            return dy.getDynamicObjectCollection("multitemplate").stream().anyMatch(e -> noPerms.contains(DynUtils.getBaseId((DynamicObject)e, (String)"fbasedataid")));
        }
        return false;
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("saveModel".equals(operation) || "saveModelAndAddLevel".equals(operation)) {
            if (com.getParam().get(0) instanceof String) {
                this.getView().showErrorNotification(com.getParam().get(0).toString());
                return;
            }
            JSONObject j = (JSONObject)com.getParam().get(0);
            DynamicObject condiff = this.creatCondiffData(j);
            if (!this.checkNameNum(condiff.getString("name"), condiff.getString("number"))) {
                return;
            }
            if (this.isNoPerm(condiff)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u6a21\u677f\u65e0\u6743\u6216\u53ea\u8bfb\uff0c\u4e0d\u53ef\u4fdd\u5b58\u3002", (String)"ConvertDiffMainPagePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] o = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{condiff});
            this.getPageCache().put("pkid", ((DynamicObject)o[0]).getString("id"));
            if (j.getBooleanValue("isatreplaced")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u7b49\u5f0f\u5de6\u8fb9\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u5df2\u81ea\u52a8\u4fee\u6539\u4e3a\u6298\u7b97\u6807\u51c6\u8bbe\u7f6e\u6307\u5b9a\u7684\u5ba1\u8ba1\u7ebf\u7d22\u6210\u5458\u3002", (String)"ConvertDiffMainPagePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ConvertDiffMainPagePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().remove("baseinfo_confirm");
            if (condiff.getLong("id") == 0L) {
                this.writeOperationLog(this.getOperationSave(), condiff.getString("number"), condiff.getString("name"), ResultStatusEnum.SUCCESS.getName());
            } else {
                this.writeOperationLog(this.getOperationUpdate(), condiff.getString("number"), condiff.getString("name"), ResultStatusEnum.SUCCESS.getName());
            }
            if ("saveModelAndAddLevel".equals(operation)) {
                this.addLevel();
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_itemaddlevel"});
            }
            this.getPageCache().remove("ismodifer");
            if (Objects.equals(this.getPageCache().get("closeingOK"), "true")) {
                this.getView().close();
            }
        } else if ("addLevel".equals(operation) || "closing".equals(operation)) {
            String msg = com.getParam().get(0).toString();
            if (!StringUtil.isEmptyString((String)msg)) {
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(operation, (IFormPlugin)this));
            } else if ("addLevel".equals(operation)) {
                this.addLevel();
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_itemaddlevel"});
            } else if ("closing".equals(operation)) {
                this.getPageCache().put("closeingOK", "true");
                this.getView().close();
            }
        } else if ("closingCheck".equals(operation) || "addCheck".equals(operation)) {
            String msg = "";
            if (!Objects.equals(this.getPageCache().get(CURFORMULA), this.getPageCache().get(OLDFORMULA)) || this.getPageCache().get("ismodifer") != null) {
                msg = ResManager.loadKDString((String)"\u6298\u7b97\u5dee\u516c\u5f0f\u6709\u4fee\u6539\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"ConvertDiffFormulaPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            operation = "closingCheck".equals(operation) ? "closing" : "addLevel";
            com = new CommandParam("bcm_convertdiffformula", "bcm_convertdiffmainpage", operation, msg);
            this.sendMsg(this.getView(), com);
        }
    }

    private boolean checkNameNum(String name, String number) {
        if (StringUtil.isEmptyString((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801", (String)"ConvertDiffMainPagePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtil.isEmptyString((String)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0", (String)"ConvertDiffMainPagePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter mq = new QFilter("model", "=", (Object)this.getModelId());
        String pkid = this.getPageCache().get("pkid");
        if (!StringUtil.isEmptyString((String)pkid)) {
            mq.and(new QFilter("id", "!=", (Object)Long.parseLong(pkid)));
        }
        QFilter nq = new QFilter("name", "=", (Object)name);
        QFilter nuq = new QFilter("number", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"bcm_convertdiffentity", (QFilter[])new QFilter[]{mq, nuq})) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728%s", (String)"ConvertDiffMainPagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number));
            return false;
        }
        if (QueryServiceHelper.exists((String)"bcm_convertdiffentity", (QFilter[])new QFilter[]{mq, nq})) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728%s", (String)"ConvertDiffMainPagePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name));
            return false;
        }
        return true;
    }

    private void addLevel() {
        this.getPageCache().put("baseinfo", "");
        this.getPageCache().put("pkid", "");
        this.showBaseInfo(false);
        CommandParam com = new CommandParam("bcm_convertdiffmainpage", null, "sureAddLevel", new Object[0]);
        this.sendMsg(this.getView(), com);
    }

    private DynamicObject creatCondiffData(JSONObject j) {
        DynamicObject dy = null;
        String pkid = this.getPkid();
        if (!StringUtil.isEmptyString((String)pkid)) {
            dy = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bcm_convertdiffentity");
        } else {
            dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_convertdiffentity");
            dy.set("creator", (Object)this.getUserId());
            dy.set("createtime", (Object)new Date());
            dy.set("status", (Object)"1");
        }
        dy.set("modifier", (Object)this.getUserId());
        dy.set("modifytime", (Object)new Date());
        JSONObject obj = JSON.parseObject((String)this.getPageCache().get("baseinfo"));
        dy.set("name", (Object)obj.getString("name"));
        dy.set("number", (Object)obj.getString("number"));
        dy.set("priority", (Object)Integer.valueOf(obj.getString("priority")));
        dy.set("unbizrule", (Object)obj.getBoolean("unbizrule"));
        dy.set("description", (Object)obj.getString("description"));
        DynamicObjectCollection mult = dy.getDynamicObjectCollection("multitemplate");
        mult.clear();
        for (Object o : (JSONArray)obj.get((Object)"multitemplate")) {
            mult.addNew().set("fbasedataid", o);
        }
        Long modelId = this.getModelId();
        JSONArray sa = (JSONArray)obj.get((Object)SCENARIOS);
        DynamicObjectCollection scenes = dy.getDynamicObjectCollection(SCENARIOS);
        scenes.clear();
        int seq = 1;
        for (Object entryJson : sa) {
            Object isexcept = ((JSONObject)entryJson).get((Object)"isexcept");
            Object scenarioId = ((JSONObject)entryJson).get((Object)"id");
            Object scope = ((JSONObject)entryJson).get((Object)"scope");
            DynamicObject rowObj = scenes.addNew();
            rowObj.set("seq", (Object)seq);
            rowObj.set("isexcept", isexcept);
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"bcm_scenemembertree");
            member.set("id", scenarioId);
            rowObj.set("scenariomeb", (Object)member);
            rowObj.set("scenarioscope", scope);
            ++seq;
        }
        EffectiveYearPeriodUtil.saveEffectiveInfo(dy, (Map)obj.getObject("effective", Map.class));
        dy.set("model", (Object)modelId);
        dy.set("scenario", this.getView().getFormShowParameter().getCustomParam("KEY_SCENARIO_ID"));
        JSONArray ja = (JSONArray)j.get((Object)"dimrange");
        DynamicObjectCollection dc = dy.getDynamicObjectCollection("entryentity");
        dc.clear();
        for (Object o : ja) {
            JSONArray jarray = (JSONArray)o;
            for (Object object : jarray) {
                JSONObject jo = (JSONObject)object;
                DynamicObject d = dc.addNew();
                d.set("dimension", jo.get((Object)"dimension"));
                d.set("memberid", jo.get((Object)"memberid"));
                d.set("membbound", jo.get((Object)"membbound"));
                if (jo.get((Object)"propertyid") == null) continue;
                d.set("propertyid", jo.get((Object)"propertyid"));
            }
        }
        String rangetxt = j.getString("dimrangetxt");
        if (rangetxt != null && rangetxt.length() >= 255) {
            dy.set("scopetxt", (Object)(rangetxt.substring(0, 252) + "..."));
        } else {
            dy.set("scopetxt", (Object)rangetxt);
        }
        dy.set("rangetxt", (Object)rangetxt);
        dy.set("periodtxt", (Object)obj.getString("periodtxt"));
        String l = j.getString("leftformula");
        String r = j.getString("rightformula");
        String ltmp = j.getString("leftformulatmp");
        String rtmp = j.getString("rightformulatmp");
        if (ltmp.toLowerCase(Locale.ENGLISH).contains("null") || rtmp.toLowerCase(Locale.ENGLISH).contains("null")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7c98\u8d34(ctrl+v)\u751f\u6210\u7684\u516c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConvertDiffMainPagePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String ct = j.getString("comparetype");
        dy.set("leftformula", (Object)l);
        dy.set("lformulatemp", (Object)ltmp);
        dy.set("rightformula", (Object)r);
        dy.set("rformulatemp", (Object)rtmp);
        dy.set("vformula", (Object)(l + "=" + r));
        this.getPageCache().put(OLDFORMULA, ltmp + "=" + rtmp);
        String chf = this.translate(ltmp, rtmp, ct);
        if (chf != null && chf.length() >= 255) {
            dy.set("chformula", (Object)(chf.substring(0, 252) + "..."));
        } else {
            dy.set("chformula", (Object)chf);
        }
        dy.set("chineseformula", (Object)chf);
        return dy;
    }

    private String translate(String ltmp, String rtmp, String comparetype) {
        long modelid = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObject chineseSettring = BusinessDataServiceHelper.newDynamicObject((String)"bcm_chkdisplaysetting");
        chineseSettring.set("selectdims", (Object)"account;changetype");
        chineseSettring.set("type", (Object)"1");
        chineseSettring.set("model", (Object)modelid);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number,name", (QFilter[])new QFilter[]{qFilter.and("templatetype", "in", (Object)new String[]{String.valueOf(TemplateTypeEnum.FIX.getType()), String.valueOf(TemplateTypeEnum.DYNA.getType()), String.valueOf(TemplateTypeEnum.DYNAMICREPORT.getType())})});
        String chineseFormula = ChkFormulaServiceHelper.tranFormulasQuick((String)ltmp, (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates) + ChkFormulaServiceHelper.changeNum2Symbol((String)comparetype) + ChkFormulaServiceHelper.tranFormulasQuick((String)rtmp, (long)modelid, (int)1, (DynamicObject)chineseSettring, (DynamicObjectCollection)templates);
        return chineseFormula;
    }

    private void showBaseInfo(boolean isEdit) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bcm_convertdiffinfo");
        formShowParameter.setCustomParam("baseinfo", (Object)this.getPageCache().get("baseinfo"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_SCENARIO_ID", this.getFormCustomParam("KEY_SCENARIO_ID"));
        if (isEdit) {
            formShowParameter.setCustomParam("type", (Object)"edit");
        }
        formShowParameter.setCustomParam("pkid", (Object)this.getPkid());
        formShowParameter.setCustomParam("template_id", this.getFormCustomParam("template_id"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bcm_convertdiffinfo"));
        this.getView().showForm(formShowParameter);
    }

    private String getPkid() {
        return this.getPageCache().get("pkid");
    }

    private void showFromView(String tab, String form) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(tab);
        formShowParameter.setFormId(form);
        formShowParameter.setPageId(this.getPageIdAndCache(this.getPageCache(), form));
        formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)map.get("type");
        String pkid = (String)map.get("pkid");
        if (!StringUtil.isEmptyString((String)type) && "edit".equals(type)) {
            formShowParameter.setCustomParam("pkid", (Object)pkid);
            formShowParameter.setCustomParam("type", (Object)type);
            formShowParameter.setCustomParam("template_id", map.get("template_id"));
        }
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (Objects.equals(this.getPageCache().get("closeingOK"), "true")) {
            return;
        }
        e.setCancel(true);
        if (this.getPageCache().get("baseinfo_confirm") != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u6267\u884c\u4e86\u786e\u5b9a\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"ConvertDiffMainPagePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("closing", (IFormPlugin)this));
        } else {
            CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "closing", new Object[0]);
            this.sendMsg(this.getView(), com);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "addLevel": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "saveModelAndAddLevel", new JSONObject());
                    this.sendMsg(this.getView(), com);
                } else {
                    this.addLevel();
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_itemaddlevel"});
                break;
            }
            case "closing": {
                if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                    this.checkPerm("bar_save");
                    CommandParam com = new CommandParam("bcm_convertdiffmainpage", "bcm_convertdiffrange", "saveModel", new JSONObject());
                    this.sendMsg(this.getView(), com);
                    break;
                }
                this.getPageCache().put("closeingOK", "true");
                this.getView().close();
                break;
            }
        }
    }
}

