/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertdifference;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.util.PageManageUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.spread.common.util.StringUtil;

public class ConvertDiffRangePlugin
extends AbstractBaseFormPlugin
implements SubPage,
DynamicPage {
    private static final String MAPDIM = "mapdim";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("dimtool");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildPage();
    }

    @Override
    public String getPermEntityId() {
        return "bcm_convertdiffmainpage";
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        this.checkPerm("bar_save");
        switch (key = evt.getItemKey()) {
            case "bar_adddim": {
                MulBasedataEdit bs = (MulBasedataEdit)this.getControl("dimension");
                QFilter model = new QFilter("model", "=", (Object)this.getModelId());
                QFilter number = new QFilter("number", "not in", (Object)new String[]{DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()});
                bs.setQFilter(model.and(number));
                bs.click();
                break;
            }
            case "bar_deldim": {
                DynamicObjectCollection doc = (DynamicObjectCollection)this.getModel().getValue("dimension");
                if (doc == null || doc.isEmpty()) {
                    return;
                }
                if (doc.size() == 1) {
                    this.getModel().setValue("dimension", null);
                    break;
                }
                doc.remove(doc.size() - 1);
                this.getModel().setValue("dimension", (Object)doc);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if ("dimension".equals(e.getProperty().getName())) {
            DynamicObjectCollection doc = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            ArrayList<JSONObject> dimNameNumber = new ArrayList<JSONObject>();
            for (DynamicObject obj : doc) {
                JSONObject j = new JSONObject();
                String number = ((DynamicObject)obj.get("fbasedataid")).getString("number");
                String name = ((DynamicObject)obj.get("fbasedataid")).getString("name");
                j.put("name", (Object)name);
                j.put("number", (Object)number);
                dimNameNumber.add(j);
            }
            this.addDims(dimNameNumber);
        }
        if (e.getProperty().getName().startsWith(MAPDIM) && (e.getChangeSet()[0].getNewValue() == null || StringUtils.isEmpty((String)e.getChangeSet()[0].getNewValue().toString()))) {
            this.getPageCache().put(e.getProperty().getName(), null);
        }
    }

    private void addDims(ArrayList<JSONObject> dimNameNumber) {
        String sign;
        ArrayList mapList = new ArrayList(10);
        Page page = this.getPage(this.getView());
        Area area = PageManageUtil.findAreaByUserDefindSign((Page)page, (String)MAPDIM);
        ArrayList<String> olddimsign = new ArrayList<String>();
        ArrayList<String> newdimsign = new ArrayList<String>();
        for (Element ele : area.getElementListList()) {
            if (!TextEditElement.class.isAssignableFrom(ele.getClass())) continue;
            String number = ((TextEditElement)ele).getNumber();
            olddimsign.add(number);
        }
        area.getElementListList().clear();
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        for (JSONObject jsonObject : dimNameNumber) {
            String name = jsonObject.getString("name");
            String number = jsonObject.getString("number");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", name);
            map.put("number", number);
            mapList.add(map);
            this.addDimToPanel(name, number);
            if (olddimsign.remove(number)) continue;
            newdimsign.add(number);
        }
        for (String ent : olddimsign) {
            sign = this.buildF7Sign(MAPDIM, ent);
            this.getPageCache().remove(sign);
        }
        for (String ent : newdimsign) {
            sign = this.buildF7Sign(MAPDIM, ent);
            this.getModel().setValue(sign, (Object)" ");
        }
        CommandParam com = new CommandParam("bcm_convertdiffrange", "bcm_convertdiffformula", "cacheMap", mapList);
        this.sendMsg(this.getView(), com);
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null) {
            Element c = this.getPage(this.getView()).findElementBySign(e.getKey());
            if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else if (c != null) {
                e.setControl(c.getControl(this.getView()));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        Element c;
        String key = ((Control)evt.getSource()).getKey();
        if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(key)) != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            long rootid = 0L;
            this.showMulTiF7(key, ((TextEditElement)c).getNumber(), rootid);
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        Element c = this.getPage(this.getView()).findElementBySign(key);
        if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            if (ThreadCache.get((Object)"okbtn") == null) {
                return;
            }
            DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
            if (doc != null) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                for (DynamicObject dyn : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dyn.getString(4));
                    map.put("scope", dyn.getString(5));
                    map.put("number", dyn.getString(2));
                    map.put("name", dyn.getString(3));
                    map.put("pid", dyn.getString(6));
                    if (RangeEnum.getRangeByVal((int)dyn.getInt(5)) == RangeEnum.VALUE_10) {
                        sb.append(dyn.getString(3)).append(',');
                    } else {
                        sb.append(dyn.get(3).toString()).append(ResManager.loadKDString((String)"\u7684", (String)"ConvertDiffRangePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)dyn.getInt(5)).getName()).append(',');
                    }
                    list.add(map);
                }
                if (sb.length() > 0 && !"null".equals(sb.toString()) && !"".equals(sb.toString())) {
                    this.getModel().setValue(key, (Object)sb.substring(0, sb.length() - 1));
                } else {
                    this.getModel().setValue(key, (Object)" ");
                }
                this.getPageCache().put(key, SerializationUtils.toJsonString(list));
            } else {
                this.getModel().setValue(key, null);
                this.getPageCache().remove(key);
            }
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        String operation = com.getOperation();
        if ("saveModel".equals(operation) || "saveModelAndAddLevel".equals(operation)) {
            Page page = this.getPage(this.getView());
            Area mapdim = PageManageUtil.findAreaByUserDefindSign((Page)page, (String)MAPDIM);
            JSONObject save = this.save(mapdim, true);
            this.getPageCache().put("olddimrangetxt", save.getString("dimrangetxt"));
            com.getParam().set(0, save);
            com.setReceiver("bcm_convertdiffformula");
            com.setSender("bcm_convertdiffrange");
            this.sendMsg(this.getView(), com);
        } else if ("sureAddLevel".equals(operation)) {
            this.getModel().setValue("dimension", null);
            this.getPageCache().put("olddimrangetxt", "");
        } else if ("loadformchkup".equals(operation)) {
            long fromchkupid = (Long)com.getParam().get(0);
            this.loadFrom(BusinessDataServiceHelper.loadSingle((Object)fromchkupid, (String)"bcm_chkformulasetting"), false);
        } else if ("addLevel".equals(operation) || "closing".equals(operation)) {
            Page page = this.getPage(this.getView());
            Area mapdim = PageManageUtil.findAreaByUserDefindSign((Page)page, (String)MAPDIM);
            JSONObject save = this.save(mapdim, false);
            String msg = "";
            if (!save.getString("dimrangetxt").equals(this.getPageCache().get("olddimrangetxt"))) {
                msg = ResManager.loadKDString((String)"\u9002\u7528\u7ef4\u5ea6\u6709\u4fee\u6539\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f", (String)"ConvertDiffRangePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                com = new CommandParam("bcm_convertdiffrange", "bcm_convertdiffmainpage", operation, msg);
            } else {
                com = new CommandParam("bcm_convertdiffrange", "bcm_convertdiffformula", operation, msg);
            }
            this.sendMsg(this.getView(), com);
        }
    }

    private JSONObject save(Area mapdim, boolean isSave) {
        List eles = mapdim.getElementListList();
        JSONArray rangear = new JSONArray();
        StringBuilder sb = new StringBuilder();
        for (Element ele : eles) {
            String sec = this.getPageCache().get(ele.getSign());
            if (sec != null) {
                TextEditElement bs = (TextEditElement)ele;
                String number = bs.getNumber();
                DynamicObject dimdy = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,name,number,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)number)});
                sb.append(dimdy.getString("name")).append(':');
                List list = (List)SerializationUtils.fromJsonString((String)sec, List.class);
                JSONArray mbr = new JSONArray();
                for (Map map : list) {
                    JSONObject member = new JSONObject();
                    String name = (String)map.get("name");
                    int scope = Integer.parseInt((String)map.get("scope"));
                    String propertyid = (String)map.get("pid");
                    sb.append(ConvertDiffRangePlugin.getMemberRangeStr(name, scope)).append(';');
                    member.put("dimension", (Object)dimdy.getLong("id"));
                    member.put("memberid", (Object)Long.valueOf((String)map.get("id")));
                    member.put("membbound", (Object)scope);
                    if (!StringUtil.isEmptyString((String)propertyid) && !"0".equals(propertyid)) {
                        member.put("propertyid", map.get("id"));
                    }
                    member.put("name", (Object)name);
                    member.put("number", map.get("number"));
                    mbr.add((Object)member);
                }
                rangear.add((Object)mbr);
                continue;
            }
            if (!isSave || !TextEditElement.class.isAssignableFrom(ele.getClass())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9002\u7528\u7ef4\u5ea6%s\u7684\u6210\u5458\u3002", (String)"ConvertDiffRangePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ele.getName()));
        }
        JSONObject j = new JSONObject();
        j.put("dimrange", (Object)rangear);
        j.put("dimrangetxt", (Object)sb.toString());
        return j;
    }

    public static String getMemberRangeStr(String memberName, int memberBound) {
        switch (memberBound) {
            case 10: {
                return memberName;
            }
            case 20: {
                return String.format(ResManager.loadKDString((String)"%s\u76f4\u63a5\u4e0b\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 30: {
                return String.format(ResManager.loadKDString((String)"%s\u76f4\u63a5\u4e0b\u7ea7\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 40: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709\u4e0b\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 50: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709\u4e0b\u7ea7\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 60: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709\u5e73\u7ea7\u4e0d\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 70: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709\u5e73\u7ea7\u542b\u81ea\u5df1", (String)"ConvertDiffRangePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 90: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709_\u4ec5\u660e\u7ec6\u6210\u5458", (String)"ConvertDiffRangePlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
            case 110: {
                return String.format(ResManager.loadKDString((String)"%s\u6240\u6709_\u4ec5\u975e\u660e\u7ec6\u6210\u5458", (String)"ConvertDiffRangePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), memberName);
            }
        }
        return memberName;
    }

    private void showMulTiF7(String key, String number, long rootid) {
        DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)number);
        FormShowParameter para = null;
        para = new FormShowParameter();
        if (number.equals(DimTypesEnum.INTERCOMPANY.getNumber())) {
            para.setFormId("bcm_mulmemberf7_tem_ic");
        } else {
            para.setFormId("bcm_mulmemberf7base_tem");
        }
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dimension", dim.getInt("dseq") + "");
        params.put("sign", key);
        para.setCustomParams(params);
        if (rootid != 0L) {
            para.setCustomParam("rootid", (Object)rootid);
        }
        para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"ConvertDiffRangePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    protected void buildPage() {
        Page page = new Page();
        Area area3 = new Area("showpanel");
        area3.setUserDefindSign(MAPDIM);
        page.addArea(area3);
        page.updatePage(this.getView());
        this.setPage(this.getView(), page);
        this.loadData();
    }

    private void loadData() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)map.get("type");
        String pkid = (String)map.get("pkid");
        Object fromchkupid = map.get("fromchkupid");
        if (!StringUtil.isEmptyString((String)type) && "edit".equals(type) || fromchkupid != null) {
            if (fromchkupid != null) {
                this.loadFrom(BusinessDataServiceHelper.loadSingle(fromchkupid, (String)"bcm_chkformulasetting"), false);
            } else {
                this.loadFrom(BusinessDataServiceHelper.loadSingle((Object)pkid, (String)"bcm_convertdiffentity"), true);
            }
        }
        Page page = this.getPage(this.getView());
        Area mapdim = PageManageUtil.findAreaByUserDefindSign((Page)page, (String)MAPDIM);
        JSONObject save = this.save(mapdim, false);
        this.getPageCache().put("olddimrangetxt", save.getString("dimrangetxt"));
    }

    private void loadFrom(DynamicObject data, boolean isFromCondiff) {
        DynamicObjectCollection dc = !isFromCondiff ? data.getDynamicObjectCollection("memberrange") : data.getDynamicObjectCollection("entryentity");
        HashMap rd = new HashMap();
        HashMap<String, String> entityName = new HashMap<String, String>();
        HashMap memids = new HashMap();
        ArrayList<JSONObject> jl = new ArrayList<JSONObject>();
        ArrayList<String> dimids = new ArrayList<String>();
        if (dc != null) {
            for (DynamicObject dynamicObject : dc) {
                ArrayList<Object> m;
                DynamicObject d;
                String number;
                if (!isFromCondiff && !"3".equals(dynamicObject.getString("limittype")) || (number = (d = dynamicObject.getDynamicObject("dimension")).getString("number")).equals(DimTypesEnum.YEAR.getNumber()) || number.equals(DimTypesEnum.PERIOD.getNumber())) continue;
                String name = d.getString("name");
                if (!rd.containsKey(number)) {
                    JSONObject jo = new JSONObject();
                    jo.put("name", (Object)name);
                    jo.put("number", (Object)number);
                    jl.add(jo);
                    dimids.add(d.getString("id"));
                }
                entityName.put(number, d.getString("membermodel"));
                ArrayList asd = (ArrayList)rd.get(number);
                if (asd == null) {
                    asd = new ArrayList();
                }
                if ((m = (ArrayList<Object>)memids.get(number)) == null) {
                    m = new ArrayList<Object>();
                }
                HashMap<String, Object> mapp = new HashMap<String, Object>();
                mapp.put("id", dynamicObject.get("memberid"));
                mapp.put("membbound", dynamicObject.get("membbound"));
                long pd = dynamicObject.getLong("propertyid_id");
                mapp.put("propertyid", pd);
                if (pd == 0L) {
                    m.add(dynamicObject.get("memberid"));
                }
                memids.put(number, m);
                asd.add(mapp);
                rd.put(number, asd);
            }
        }
        this.getModel().setValue("dimension", (Object)LongUtil.toLongList(dimids).toArray());
        this.addDims(jl);
        for (Map.Entry entry : rd.entrySet()) {
            String num = (String)entry.getKey();
            ArrayList list = new ArrayList();
            ArrayList al = (ArrayList)entry.getValue();
            HashMap<Long, JSONObject> mennumname = this.getMbNameNumber((ArrayList)memids.get(num), (String)entityName.get(num));
            StringBuilder sb = new StringBuilder();
            for (HashMap mmmm : al) {
                HashMap<String, String> tmap = new HashMap<String, String>();
                Long id = (Long)mmmm.get("id");
                Integer range = (Integer)mmmm.get("membbound");
                long propertyid = (Long)mmmm.get("propertyid");
                JSONObject nj = mennumname.get(id);
                if (nj == null) {
                    nj = this.getZdyNameNumber(id);
                }
                if (nj == null) continue;
                tmap.put("id", id.toString());
                tmap.put("scope", range.toString());
                tmap.put("number", nj.getString("number"));
                tmap.put("name", nj.getString("name"));
                tmap.put("pid", propertyid == 0L ? "" : String.valueOf(propertyid));
                if (RangeEnum.getRangeByVal((int)((Integer)mmmm.get("membbound"))) == RangeEnum.VALUE_10) {
                    sb.append(nj.getString("name")).append(',');
                } else {
                    sb.append(nj.getString("name")).append(ResManager.loadKDString((String)"\u7684", (String)"ConvertDiffRangePlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)range).getName()).append(',');
                }
                list.add(tmap);
            }
            if (sb.length() <= 0) continue;
            this.getModel().setValue(this.buildF7Sign(MAPDIM, num), (Object)sb.substring(0, sb.length() - 1));
            this.getPageCache().put(this.buildF7Sign(MAPDIM, num), SerializationUtils.toJsonString(list));
        }
    }

    private JSONObject getZdyNameNumber(Long id) {
        DynamicObject m;
        DynamicObject d = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"number,name,propertyid", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (d != null && (m = QueryServiceHelper.queryOne((String)"bcm_definedproperty", (String)"number,name", (QFilter[])new QFilter("id", "=", (Object)d.getLong("propertyid")).toArray())) != null) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)(m.getString("name") + ":" + d.getString("name")));
            obj.put("number", (Object)(m.getString("number") + ":" + d.getString("number")));
            return obj;
        }
        return null;
    }

    private HashMap<Long, JSONObject> getMbNameNumber(ArrayList<Object> arrayList, String entryname) {
        HashMap<Long, JSONObject> menname = new HashMap<Long, JSONObject>();
        if (arrayList.isEmpty() && StringUtil.isEmptyString((String)entryname)) {
            return menname;
        }
        DynamicObjectCollection men = QueryServiceHelper.query((String)entryname, (String)"id,name,number", (QFilter[])new QFilter("id", "in", arrayList).toArray());
        if (men != null) {
            for (DynamicObject dynamicObject : men) {
                JSONObject j = new JSONObject();
                j.put("name", (Object)dynamicObject.getString("name"));
                j.put("number", (Object)dynamicObject.getString("number"));
                menname.put(dynamicObject.getLong("id"), j);
            }
        }
        return menname;
    }

    private void addDimToPanel(String name, String number) {
        Page page = this.getPage(this.getView());
        Area area = PageManageUtil.findAreaByUserDefindSign((Page)page, (String)MAPDIM);
        TextEditElement ele = new TextEditElement(name, this.buildF7Sign(MAPDIM, number), DimEntityNumEnum.getEntieyNumByNumber((String)number));
        ele.setNumber(number);
        area.addElement((Element)ele);
        page.getAreaList().remove(area);
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private String buildF7Sign(String type, String number) {
        return (type + number).toLowerCase(Locale.ENGLISH);
    }
}

