/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertdifference;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.chkcheck.model.MultiTemplateModel;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.TreeModel;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.CreateCopyNameUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.importhelper.AbsCommonImport;
import kd.fi.bcm.formplugin.util.CodeRuleUtil;
import kd.fi.bcm.formplugin.util.ReportListUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import org.apache.commons.collections.CollectionUtils;

public class ConvertDifferenceListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener {
    private static final String NODE_SELECT_TEMPID = "templateselectedNodeId";
    private static final String treeview_template = "treeviewap";
    private static final String NOTEMPLATEID = "NOTEMPLATEID123456";
    private static final String SEARCH_LIST_TEMP = "templist";
    private static final String TREEFOCUS_TEMP = "tempfocus";
    private static String NEWCLOSECALLBACK = "new_closecallback";
    public static final String SCENARIOS = "scenarios";
    public static final String SCENARIONAMES = "scenarionames";
    private Map<Long, String> templateNameMapCache;
    private Map<Long, String> sceneNameMapCache;

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap(16);
        this.asMapF7toType(Collections.singletonList("scenario"), SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("vectorap_up", "vectorap_down");
        TreeView tree = (TreeView)this.getControl(treeview_template);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                this.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim());
            } else {
                this.getPageCache().put(SEARCH_LIST_TEMP, null);
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
    }

    private void searchMember(String text) {
        ArrayList<String> list = new ArrayList<String>(10);
        TreeView treeView = (TreeView)this.getControl(treeview_template);
        TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_template);
        if (treeModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ConvertDifferenceListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ITreeNode root = treeModel.getRoot();
        List lists = treeModel.seekAllChildrenIf(root.getId(), p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH)));
        for (AbstractTreeNode node : lists) {
            list.add(node.getId());
        }
        if (list.size() > 0) {
            this.getPageCache().put(SEARCH_LIST_TEMP, SerializationUtils.toJsonString(list));
            this.getPageCache().put(TREEFOCUS_TEMP, "0");
            String focusnode = (String)list.get(0);
            ITreeNode parent = ((AbstractTreeNode)treeModel.searchByNodeId(focusnode)).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent() != null) {
                    parentId = ((AbstractTreeNode)treeModel.searchByNodeId(temp)).getParent().getId();
                    continue;
                }
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"ConvertDifferenceListPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshBillByUserSelect(this.getDimKeys(), Boolean.FALSE);
        if (this.getModel().getValue(this.getModelSign()) != null) {
            this.initLeftTree();
        }
        this.refreshBillList();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(this.getDataFilter());
        e.setOrderBy("number,modifytime");
    }

    private QFilter getDataFilter() {
        QFilter qm = new QFilter("model", "=", (Object)this.getModelId());
        Set ids = CheckUtil.getApplySceneTmpls((Long)this.getModelId(), (Long)this.getScenarioId(), (String)"bcm_convertdiffentity");
        qm.and("id", "in", (Object)ids);
        TreeView treeView = (TreeView)this.getControl(treeview_template);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusNodeId)) {
            focusNodeId = this.getPageCache().get(NODE_SELECT_TEMPID);
        }
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            String s = this.getPageCache().get("treecache");
            if (NOTEMPLATEID.equals(focusNodeId)) {
                return qm.and(this.getNotemplateQFilter());
            }
            TemplateTreeNode t = (TemplateTreeNode)this.deSerializedBytes(s);
            TemplateTreeNode selectedNode = this.findFocusNode(focusNodeId, t);
            if (selectedNode != null) {
                boolean isLeaf = selectedNode.isLeaf();
                if (isLeaf) {
                    List ls = TemplateUtil.getTemplateIds((Long)Long.valueOf(focusNodeId));
                    qm.and(new QFilter("multitemplate.fbasedataid", "in", (Object)ls));
                } else {
                    Set noPermIds = PermClassCache.getPermClassIds((Long)this.getModelId(), (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO});
                    if (selectedNode.getNumber().toLowerCase(Locale.ENGLISH).equals("root")) {
                        if (CollectionUtils.isNotEmpty((Collection)noPermIds)) {
                            qm.and(new QFilter("multitemplate.fbasedataid", "not in", (Object)noPermIds).or(this.getNotemplateQFilter()));
                        }
                        return qm;
                    }
                    List ls = TemplateUtil.getTemplateIds((Long)this.getModelId(), (Long)Long.valueOf(focusNodeId));
                    ls.removeAll(noPermIds);
                    qm.and(new QFilter("multitemplate.fbasedataid", "in", (Object)ls));
                }
                return qm;
            }
        }
        return qm;
    }

    private QFilter getNotemplateQFilter() {
        return new QFilter("multitemplate.fbasedataid", "is null", null).or("multitemplate.fbasedataid", "=", (Object)0L);
    }

    private TemplateTreeNode findFocusNode(String focusNodeId, TemplateTreeNode treenode) {
        String id = treenode.getId();
        if (focusNodeId.equals(id)) {
            return treenode;
        }
        List subList = treenode.getChildren();
        if (subList != null && !subList.isEmpty()) {
            for (ITreeNode treeNode2 : subList) {
                TemplateTreeNode n = this.findFocusNode(focusNodeId, (TemplateTreeNode)treeNode2);
                if (n == null) continue;
                return n;
            }
        } else {
            return null;
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("showtmptype".equals(key)) {
            this.initLeftTree();
        } else if ("model".equals(key)) {
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), "model");
            if (modelId != null) {
                this.propertyChangedModelUse(this.getDimKeys());
                this.initLeftTree();
                this.refreshBillList();
            } else {
                this.getModel().setValue("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            }
        } else if ("scenario".equals(key)) {
            String scenarioId = UserSelectUtil.getF7SelectId(this.getView(), "scenario");
            this.initLeftTree();
            this.refreshBillList();
            if (scenarioId != null) {
                this.savetUserSelectWhenOtherChange("scenario", new UserSelectModel());
            }
            this.getPageCache().put("KEY_SCENARIO_ID", scenarioId);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_new": {
                this.newConvertDiff();
                break;
            }
            case "bar_refresh": {
                this.refreshTree();
                this.refreshBillList();
                break;
            }
            case "bar_enable": {
                this.enable(true);
                break;
            }
            case "bar_disable": {
                this.enable(false);
                break;
            }
            case "bar_delete": {
                this.delete();
                break;
            }
            case "bar_copy": {
                this.copy();
                this.refreshBillList();
                break;
            }
            case "bar_export": {
                try {
                    this.getView().getFormShowParameter().setCustomParam("authDownloadFileFlag", (Object)1);
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection ls = billList.getSelectedRows();
                    if (ls.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"ConvertDifferenceListPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    List collect = ls.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
                    this.exportData("bcm_convertdiffentity", new QFilter("id", "in", collect).toArray(), ResManager.loadKDString((String)"\u6298\u7b97\u5dee\u8bbe\u7f6e\u5bfc\u51fa", (String)"ConvertDifferenceListPlugin_47", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "bcm_convertdifferencelist", "1G2FW/G3YIL8");
                    this.writeOperationLog(OpItemEnum.EXPORT.getName(), ResultStatusEnum.SUCCESS.getName());
                    break;
                }
                catch (Exception e) {
                    this.writeOperationLog(OpItemEnum.EXPORT.getName(), ResultStatusEnum.FAIL.getName());
                    throw new KDBizException(e.getMessage());
                }
            }
            case "bar_import": {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ConvertDiffImportPlugin");
                String listName = ResManager.loadKDString((String)"\u6298\u7b97\u5dee", (String)"ConvertDifferenceListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
                AbsCommonImport.invokeOperation("bcm_convertdiffentity", "kd.fi.bcm.formplugin.convertdifference.ConvertDiffImportPlugin", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
                break;
            }
        }
    }

    @Override
    public void handleDys(DynamicObject[] dys) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        Map dimShortNumMap = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)this.getModelId()));
        HashSet nonNeed = Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.MYCOMPANY.getShortNumber(), DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber()});
        Set<String> dims = dimShortNumMap.keySet().stream().filter(e -> !nonNeed.contains(e)).collect(Collectors.toSet());
        HashMap<String, String> dimNoneMaps = new HashMap<String, String>(16);
        dims.forEach(shortNum -> {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)((String)dimShortNumMap.get(shortNum)), (String)(shortNum + "None"));
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                dimNoneMaps.put((String)shortNum, shortNum + "." + node.getNumber());
            }
        });
        DynamicObject dy = null;
        for (int i = 0; i < dys.length; ++i) {
            DynamicObjectCollection multitemplate;
            dy = dys[i];
            String rightformula = this.replaceVformula(dy.getString("rformulatemp"), dims, dimNoneMaps);
            String leftformula = this.replaceVformula(dy.getString("lformulatemp"), dims, dimNoneMaps);
            if (rightformula != null || leftformula != null) {
                dys[i] = dy = (DynamicObject)cloneUtils.clone((IDataEntityBase)dys[i]);
            }
            if (rightformula != null) {
                dy.set("rformulatemp", (Object)rightformula);
            }
            if (leftformula != null) {
                dy.set("lformulatemp", (Object)leftformula);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(multitemplate = dy.getDynamicObjectCollection("multitemplate")))) continue;
            multitemplate.removeIf(e -> e.get("fbasedataid") == null);
        }
    }

    private String replaceVformula(String formula, Set<String> dims, Map<String, String> dimNoneMaps) {
        if (NumberUtils.isNumber((String)formula)) {
            return null;
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>(16);
        FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)formula);
        List v = poolMng.pull("V");
        String vstr = null;
        for (IFormula iFormula : v) {
            if (!(iFormula instanceof VFormula)) continue;
            HashSet<String> repairDims = new HashSet<String>(dims);
            for (ParamItem paramItem : iFormula.getParamList()) {
                if (paramItem.getParam() == null || !(paramItem.getParam() instanceof StringExpr)) continue;
                String[] split = ((StringExpr)paramItem.getParam()).getValue().split("\\.");
                repairDims.remove(split[0]);
            }
            vstr = iFormula.toString();
            if (repairDims.isEmpty()) continue;
            repairDims.forEach(e -> {
                if (dimNoneMaps.containsKey(e)) {
                    vformula.getParamList().add((Object)new ParamItem((Object)new StringExpr((String)dimNoneMaps.get(e))));
                }
            });
            replaceMap.put(vstr, iFormula.toString());
        }
        if (!replaceMap.isEmpty()) {
            for (Map.Entry entry : replaceMap.entrySet()) {
                formula = formula.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return formula;
        }
        return null;
    }

    private void copy() {
        DynamicObject[] records = this.loadSelectedRecords();
        if (records == null || records.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u8bb0\u5f55\u3002", (String)"ConvertDifferenceListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] copyDy = new DynamicObject[records.length];
        for (int i = 0; i < records.length; ++i) {
            copyDy[i] = (DynamicObject)OrmUtils.clone((IDataEntityBase)records[i], (boolean)false, (boolean)true);
        }
        try {
            String[] codeeNumbers = CodeRuleUtil.getBatchCodeRuleNumber("bcm_chkformulasetting", "createtime", records.length);
            for (int i = 0; i < copyDy.length; ++i) {
                DynamicObject dyn = copyDy[i];
                String codeRuleNumber = null;
                if (codeeNumbers.length >= i + 1) {
                    codeRuleNumber = codeeNumbers[i];
                }
                if (codeRuleNumber == null) {
                    dyn.set("number", (Object)(dyn.getString("number").length() > 56 ? dyn.getString("number").substring(0, 55) + "copy" : dyn.getString("number") + "copy"));
                } else {
                    dyn.set("number", (Object)codeRuleNumber);
                }
                dyn.set("name", (Object)new LocaleString(CreateCopyNameUtil.createCopyName((String)dyn.getString("name"), (String)"copy", (String)"bcm_convertdiffentity", (QFBuilder)new QFBuilder("model", "=", this.getValue("model_id")))));
                dyn.set("status", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])copyDy);
            if (records.length <= 20) {
                for (DynamicObject dyn : records) {
                    this.writeOperationLog(OpItemEnum.COPY.getName(), dyn.getString("number"), dyn.getString("name"), ResultStatusEnum.SUCCESS.getName());
                }
            } else {
                DynamicObject dyn = records[0];
                String andsoon = String.format(ResManager.loadKDString((String)"\u7b49%s\u6761", (String)"ConvertDifferenceListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), records.length);
                this.writeOperationLog(OpItemEnum.COPY.getName(), dyn.getString("number"), dyn.getString("name") + andsoon, ResultStatusEnum.SUCCESS.getName());
            }
        }
        catch (Exception e) {
            DynamicObject dyn = records[0];
            String andsoon = String.format(ResManager.loadKDString((String)"\u7b49%s\u6761", (String)"ConvertDifferenceListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), records.length);
            this.writeOperationLog(OpItemEnum.COPY.getName(), dyn.getString("number"), dyn.getString("name") + andsoon, ResultStatusEnum.FAIL.getName());
            throw new KDBizException(e.getMessage());
        }
    }

    private Set<Object> getSelectedRowIds() {
        HashSet<Object> set = new HashSet<Object>(10);
        BillList billList = (BillList)this.getControl("billlistap");
        for (ListSelectedRow row : billList.getSelectedRows()) {
            set.add(row.getPrimaryKeyValue());
        }
        return set;
    }

    private DynamicObjectCollection getSelectedRecords() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFilter qf = new QFilter("id", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues());
        return QueryServiceHelper.query((String)"bcm_convertdiffentity", (String)"id,number,name", (QFilter[])qf.toArray());
    }

    private DynamicObject[] loadSelectedRecords() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getSelectedRows().isEmpty()) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])billList.getSelectedRows().getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
    }

    private void delete() {
        BillList entryGrid = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection idxs = entryGrid.getSelectedRows();
        if (idxs == null || idxs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ConvertDifferenceListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%s\u6761\uff0c\u662f\u5426\u5220\u9664\u9009\u62e9\u7684\u6570\u636e\uff1f", (String)"ConvertDifferenceListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]), idxs.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirm_delete", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        int result = evt.getResult().getValue();
        if ("confirm_delete".equals(callBackId) && result == 6) {
            DynamicObjectCollection data = this.getSelectedRecords();
            DeleteServiceHelper.delete((String)"bcm_convertdiffentity", (QFilter[])new QFBuilder("id", "in", (Object)this.getSelectedRowIds().toArray()).toArray());
            if (data.size() <= 20) {
                for (DynamicObject dyn : data) {
                    this.writeOperationLog(OpItemEnum.DELETE.getName(), dyn.getString("number"), dyn.getString("name"), ResultStatusEnum.SUCCESS.getName());
                }
            } else {
                DynamicObject dyn = (DynamicObject)data.get(0);
                String andsoon = String.format(ResManager.loadKDString((String)"\u7b49%s\u6761", (String)"ConvertDifferenceListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), data.size());
                this.writeOperationLog(OpItemEnum.DELETE.getName(), dyn.getString("number"), dyn.getString("name") + andsoon, ResultStatusEnum.SUCCESS.getName());
            }
            this.refreshBillList();
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + list.getFocusRowPkId().toString();
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setFormId("bcm_convertdiffmainpage");
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getScenarioId());
            formShowParameter.setCustomParam("pkid", (Object)list.getFocusRowPkId().toString());
            formShowParameter.setCustomParam("type", (Object)"edit");
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)list.getFocusRowPkId(), (String)"bcm_convertdiffentity", (String)"multitemplate");
            ArrayList<MultiTemplateModel> templs = new ArrayList<MultiTemplateModel>();
            for (DynamicObject object : dy.getDynamicObjectCollection("multitemplate")) {
                templs.add(new MultiTemplateModel(Long.valueOf(object.getLong("fbasedataid.id"))));
            }
            formShowParameter.setCustomParam("temp", (Object)this.toByteSerialized(templs));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6298\u7b97\u5dee\u57fa\u672c\u4fe1\u606f", (String)"ConvertDifferenceListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            formShowParameter.setCustomParam("template_id", (Object)this.getPageCache().get(NODE_SELECT_TEMPID));
            CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "bcm_convertdiffmainpage");
            formShowParameter.setCloseCallBack(cb);
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                formShowParameter.setParentPageId(parentView.getPageId());
                formShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            } else {
                this.getView().showForm(formShowParameter);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
        DynamicObject dyn = (DynamicObject)this.getSelectedRecords().get(0);
        this.writeOperationLog(OpItemEnum.LOOKUP.getName(), dyn.getString("number"), dyn.getString("name"), ResultStatusEnum.SUCCESS.getName());
    }

    private void enable(boolean isEnable) {
        DynamicObject[] dyns = this.loadSelectedRecords();
        if (dyns.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ConvertDifferenceListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String status = isEnable ? "1" : "0";
        String opName = isEnable ? OpItemEnum.ENABLE.getName() : OpItemEnum.DISABLE.getName();
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>();
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject dyn : dyns) {
            if (status.equals(dyn.getString("status"))) continue;
            dyn.set("status", (Object)status);
            dyn.set("modifier", (Object)userId);
            dyn.set("modifytime", (Object)now);
            data.add(dyn);
        }
        SaveServiceHelper.save((DynamicObject[])data.toArray(new DynamicObject[0]));
        if (data.size() <= 20) {
            for (DynamicObject dyn : data) {
                this.writeOperationLog(opName, dyn.getString("number"), dyn.getString("name"), ResultStatusEnum.SUCCESS.getName());
            }
        } else {
            DynamicObject dyn = (DynamicObject)data.get(0);
            String andsoon = String.format(ResManager.loadKDString((String)"\u7b49%s\u6761", (String)"ConvertDifferenceListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]), data.size());
            this.writeOperationLog(opName, dyn.getString("number"), dyn.getString("name") + andsoon, ResultStatusEnum.SUCCESS.getName());
        }
        this.getView().showSuccessNotification(opName + ResultStatusEnum.SUCCESS.getName());
        this.refreshBillList();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Vector)evt.getSource()).getKey();
        if ("vectorap_up".equals(key) || "vectorap_down".equals(key)) {
            if (this.getModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RptAdjustdListPlugin_119", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            int rowCount = 0;
            TreeView treeView = (TreeView)this.getControl(treeview_template);
            TreeModel treeModel = TreeModel.toTreeModel((IPageCache)this.getPageCache(), (String)treeview_template);
            String rowcache = this.getPageCache().get(SEARCH_LIST_TEMP);
            String count = this.getPageCache().get(TREEFOCUS_TEMP);
            if (count != null) {
                rowCount = Integer.parseInt(count);
            }
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5185\u5bb9\uff0c\u518d\u6309\u56de\u8f66\u952e\u5f00\u59cb\u641c\u7d22\u3002", (String)"ConvertDifferenceListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.fromJsonString((String)rowcache, List.class);
            if ("vectorap_up".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ConvertDifferenceListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else if ("vectorap_down".equals(key)) {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ConvertDifferenceListPlugin_41", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            String focusnode = String.valueOf(rowList.get(rowCount));
            this.getPageCache().put(TREEFOCUS_TEMP, String.valueOf(rowCount));
            ITreeNode parent = treeModel.searchByNodeId(focusnode).getParent();
            String parentId = parent == null ? null : parent.getId();
            treeView.focusNode(new TreeNode(parentId, focusnode, ""));
            treeView.treeNodeClick(parentId, focusnode);
            while (parentId != null) {
                String temp = parentId;
                treeView.expand(temp);
                if (treeModel.searchByNodeId(temp).getParent() == null) break;
                parentId = treeModel.searchByNodeId(temp).getParent().getId();
            }
        }
    }

    private void setTemplateNameCache(DynamicObjectCollection docs) {
        this.templateNameMapCache = new HashMap<Long, String>(32);
        this.sceneNameMapCache = new HashMap<Long, String>(32);
        if (CollectionUtils.isNotEmpty((Collection)docs)) {
            DynamicObject[] data;
            List ids = docs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            for (DynamicObject conEntiry : data = BusinessDataServiceHelper.load((String)"bcm_convertdiffentity", (String)"multitemplate,scenarios.isexcept,scenarios.scenariomeb,scenarios.scenarioscope", (QFilter[])new QFilter("id", "in", ids).toArray())) {
                DynamicObjectCollection tpls = conEntiry.getDynamicObjectCollection("multitemplate");
                DynamicObjectCollection scenes = conEntiry.getDynamicObjectCollection(SCENARIOS);
                this.templateNameMapCache.put(conEntiry.getLong("id"), DynUtils.joinString((String)";", (String)"fbasedataid.name", (Collection)tpls));
                StringJoiner stringJoiner = new StringJoiner(";");
                for (DynamicObject dyn : scenes) {
                    stringJoiner.add(PaperTemplateSceneSettingHelper.formateDisplay((String)dyn.getString("scenariomeb.number"), (String)dyn.getString("scenariomeb.name"), (String)dyn.getString("scenarioscope"), (String)dyn.getString("isexcept")));
                }
                this.sceneNameMapCache.put(conEntiry.getLong("id"), stringJoiner.toString());
            }
        }
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection docs = super.getData(start, limit);
                ConvertDifferenceListPlugin.this.setTemplateNameCache(docs);
                return docs;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        String key = ((AbstractColumnDesc)e.getSource()).getKey();
        if ("multitemplatetext".equals(key) && this.templateNameMapCache != null) {
            e.setFormatValue((Object)this.templateNameMapCache.get(e.getRowData().getLong("id")));
        } else if ("scenarioset".equals(key) && this.sceneNameMapCache != null) {
            e.setFormatValue((Object)this.sceneNameMapCache.get(e.getRowData().getLong("id")));
        }
    }

    private void newConvertDiff() {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ConvertDifferenceListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bcm_convertdiffinfo");
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_SCENARIO_ID", (Object)this.getScenarioId());
        String tpid = this.getPageCache().get(NODE_SELECT_TEMPID);
        formShowParameter.setCustomParam("template_id", (Object)tpid);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6298\u7b97\u5dee\u57fa\u672c\u4fe1\u606f", (String)"ConvertDifferenceListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        CloseCallBack cb = new CloseCallBack((IFormPlugin)this, "bcm_convertdiffinfo");
        formShowParameter.setCloseCallBack(cb);
        this.getView().showForm(formShowParameter);
    }

    private long getScenarioId() {
        DynamicObject d = this.getModel().getDataEntity().getDynamicObject("scenario");
        return d == null ? 0L : d.getLong("id");
    }

    private void refreshTree() {
        this.initLeftTree();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        if (this.getModel().getValue(this.getModelSign()) == null) {
            billList.getFilterParameter().setFilter(new QFilter("1", "=", (Object)0));
        } else {
            billList.refresh();
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String selectedNodeId = (String)arg0.getNodeId();
        if (selectedNodeId.isEmpty()) {
            return;
        }
        this.treeNodeClickCache(selectedNodeId);
        this.refreshBillList();
    }

    private void treeNodeClickCache(String selectedNodeId) {
        this.getPageCache().put(NODE_SELECT_TEMPID, selectedNodeId);
    }

    private void initLeftTree() {
        if (this.isNoModel()) {
            return;
        }
        long modelId = this.getModelId();
        DynamicObjectCollection rootNodeList = this.getTempTreeListCollection(modelId);
        TemplateTreeNode root = new TemplateTreeNode("root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ConvertDifferenceListPlugin_44", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("usage", "=", (Object)"1");
        qfBuilder.add("templatetype", "!=", (Object)(TemplateTypeEnum.MSN.getType() + ""));
        qfBuilder.add("status", "=", (Object)"1");
        Set noPermTemplateIds = PermClassCache.getPermClassIds((Long)modelId, (String)"bcm_templateentity", (DataTypeEnum[])new DataTypeEnum[]{DataTypeEnum.NO});
        if (CollectionUtils.isNotEmpty((Collection)noPermTemplateIds)) {
            qfBuilder.add("id", "not in", (Object)noPermTemplateIds);
        }
        String showType = (String)this.getModel().getValue("showtmptype");
        root = TreeBuilder.getTemplateTreeNew((DynamicObjectCollection)rootNodeList, (TemplateTreeNode)root, () -> ((QFBuilder)qfBuilder).toArray(), (String)showType, this::setScenarioFilter);
        TemplateTreeNode child = new TemplateTreeNode(NOTEMPLATEID, ResManager.loadKDString((String)"\u4e0d\u533a\u5206\u6a21\u677f", (String)"ConvertDifferenceListPlugin_45", (String)"fi-bcm-formplugin", (Object[])new Object[0]), "TemplateNone", false);
        child.setParent((ITreeNode)root);
        root.getChildren().add(0, child);
        root.SetIsOpened(true);
        this.buildLeftTree((AbstractTreeNode<Object>)root);
        this.getPageCache().put("treecache", this.toByteSerialized(root));
    }

    private void setScenarioFilter(DynamicObjectCollection templateColl) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamicObject : templateColl) {
            ids.add(dynamicObject.getLong("id"));
        }
        Long cpId = this.getScenarioId();
        Long modelId = this.getModelId();
        Set noPermSceneIds = new HashSet(8);
        if (cpId == 0L) {
            PermissionService permissionService = PermissionServiceImpl.getInstance((Long)this.getModelId());
            Set allSceneIds = MemberReader.getAllNodeFromCache((String)"bcm_scenemembertree", (Object)modelId).keySet();
            noPermSceneIds = permissionService.matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Scenario"), "bcm_scenemembertree", allSceneIds);
        }
        List templist = TemplateRangeService.getTemplateModels(ids, (long)this.getModelId(), (boolean)false, (boolean)true);
        HashSet<Long> notInSet = new HashSet<Long>();
        for (TemplateModel templateModel : templist) {
            if (cpId != 0L && !TemplateRangeService.isInnerRange((String)"bcm_scenemembertree", (TemplateModel)templateModel, (Object)cpId)) {
                notInSet.add(templateModel.getId());
                continue;
            }
            if (cpId != 0L || noPermSceneIds.isEmpty() || !TemplateRangeService.isInnerRangeBatch((String)"bcm_scenemembertree", (TemplateModel)templateModel, noPermSceneIds)) continue;
            notInSet.add(templateModel.getId());
        }
        Iterator it = templateColl.iterator();
        while (it.hasNext()) {
            DynamicObject object = (DynamicObject)it.next();
            long templateId = object.getLong("id");
            if (!notInSet.contains(templateId)) continue;
            it.remove();
        }
    }

    private void buildLeftTree(AbstractTreeNode<Object> root) {
        TreeView tree = (TreeView)this.getControl(treeview_template);
        if (root != null) {
            TreeModel treemodel = new TreeModel(root);
            TreeNode nodeRoot = treemodel.buildEntryTree(tree);
            nodeRoot.iterate(999, v -> v.setIsOpened(false));
            nodeRoot.iterate(0, v -> v.setIsOpened(true));
            if (root.getChildren() == null) {
                return;
            }
            TreeNode selectnode = this.findCacheNode(nodeRoot);
            tree.focusNode(selectnode);
            this.getPageCache().put(NODE_SELECT_TEMPID, selectnode.getId());
            treemodel.ache2page(this.getPageCache(), treeview_template);
        }
    }

    private TreeNode findCacheNode(TreeNode root) {
        String selectNode = null;
        selectNode = this.getPageCache().get(NODE_SELECT_TEMPID);
        if (selectNode == null || selectNode.equals(root.getId())) {
            return new TreeNode("0", root.getId(), root.getText());
        }
        List childPathNodes = root.getChildPathNodes(selectNode);
        childPathNodes.forEach(v -> v.setIsOpened(true));
        if (!childPathNodes.isEmpty()) {
            return (TreeNode)childPathNodes.get(childPathNodes.size() - 1);
        }
        return new TreeNode("0", root.getId(), root.getText());
    }

    private DynamicObjectCollection getTempTreeListCollection(long modelId) {
        QFBuilder qfBuilder = new QFBuilder();
        if (modelId != 0L) {
            qfBuilder.add("model", "=", (Object)modelId);
            qfBuilder.add(TemplateCatalogTypeEnum.getTemplateCalcog());
        }
        DynamicObjectCollection doc = ReportListUtil.getCollection("bcm_templatecatalog", qfBuilder.toArray(), "sequence");
        return doc;
    }

    public List<String> getDimKeys() {
        return Lists.newArrayList((Object[])new String[]{"scenario"});
    }

    private boolean isNoScenario() {
        return this.getModel().getValue("scenario") == null;
    }

    private boolean isNoModel() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ConvertDifferenceListPlugin_42", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("bcm_convertdiffinfo".equalsIgnoreCase(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            String jstr = (String)this.deSerializedBytes((String)closedCallBackEvent.getReturnData());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("baseinfo", jstr);
            JSONObject jo = JSON.parseObject((String)jstr);
            param.put("name", jo.get((Object)"name"));
            param.put("number", jo.get((Object)"number"));
            param.put("isNew", Boolean.TRUE);
            ArrayList<MultiTemplateModel> templs = new ArrayList<MultiTemplateModel>();
            for (Object multitemplate : jo.getJSONArray("multitemplate")) {
                templs.add(new MultiTemplateModel((Long)multitemplate));
            }
            param.put("temp", this.toByteSerialized(templs));
            long fromchkupid = jo.getLongValue("fromchkupid");
            if (fromchkupid != 0L) {
                param.put("fromchkupid", jo.getLongValue("fromchkupid"));
            }
            param.put("KEY_MODEL_ID", this.getModelId());
            param.put("KEY_SCENARIO_ID", this.getScenarioId());
            param.put(SCENARIOS, jo.get((Object)SCENARIOS));
            param.put(SCENARIONAMES, jo.get((Object)SCENARIONAMES));
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, NEWCLOSECALLBACK);
            this.showFormParameter("bcm_convertdiffmainpage", param, ShowType.MainNewTabPage, callBack);
        }
        if ("ConvertDiffImportPlugin".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"ConvertDifferenceListPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.refreshBillList();
        }
    }

    private void showFormParameter(String entity, Map<String, Object> params, ShowType showType, CloseCallBack callBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(showType);
        formShowParameter.setFormId(entity);
        formShowParameter.setCustomParams(params);
        if (callBack != null) {
            formShowParameter.setCloseCallBack(callBack);
        }
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!this.getModelSign().equals(((BasedataEdit)beforeF7SelectEvent.getSource()).getKey()) && this.getModelId() == 0L) {
            beforeF7SelectEvent.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"RptAdjustdListPlugin_119", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        super.beforeF7Select(beforeF7SelectEvent);
    }
}

