/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertscheme;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkFormulaServiceHelper;
import kd.fi.bcm.business.chkcheck.util.CheckedFormulaUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.formula.express.ExpressParser;
import kd.fi.bcm.business.formula.model.FormulaEnum;
import kd.fi.bcm.business.formula.model.FormulaPoolManager;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.serviceHelper.ExpressionServiceHelper;
import kd.fi.bcm.business.serviceHelper.FormulaServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.CvtFactorEnum;
import kd.fi.bcm.common.enums.CvtFactorEnum4Edit;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.invest.HolderTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.intergration.formula.validate.FTicket;
import kd.fi.bcm.formplugin.intergration.formula.validate.FormulaTicketer;
import kd.fi.bcm.formplugin.intergration.formula.validate.IValidate;
import kd.fi.bcm.formplugin.intergration.formula.validate.NotNullValidate;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.spread.formula.EncoderService;
import org.apache.commons.lang.RandomStringUtils;

public class CvtFormulaEditPlugin
extends AbstractBaseFormPlugin
implements DynamicPage {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(CvtFormulaEditPlugin.class);
    public static final String CVTFORMULACV = "cvtformulacb";
    private static final String FI_BCM_FORMPLUGIN = "fi-bcm-formplugin";
    private static final String FORMULA = "formula";
    private static final String EXCHANGE = "exchange";
    private static final String PRE_EXCHANGE = "preexchange";
    private static final String EXCHANGE_INFO = "exchangeInfo";
    private static final String CVT_FACTOR = "cvtfactor";
    private static final String ISRATE = "israte";
    private static final String HIDEBTNS = "f(x),abs,if,and,or,len,>,<>,<,>=,<=,=";

    @Override
    public void initialize() {
        super.initialize();
        if (this.getPage(this.getView()) != null) {
            this.getPage(this.getView()).bindCtrlMapping(this.getView());
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_del", "btn_+", "btn_-", "btn_*", "btn_/", "btn_(", "btn_)", "btn_v");
        this.addClickListeners("confirm");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboBox();
        this.customView();
        this.buildEditPage();
    }

    private void customView() {
        String showtype = (String)this.getView().getFormShowParameter().getCustomParam("showtype");
        if ("1".equals(showtype)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CVT_FACTOR, "rights", "presetrate"});
        }
        if ("bcm_rateformulasetting".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"presetrate"});
            this.getPageCache().put(ISRATE, "1");
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"presetrate"});
        }
        CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
        JSONObject data = new JSONObject();
        data.put("operate", (Object)"updateText");
        if (Objects.equals(this.getPageCache().get(ISRATE), "1")) {
            data.put("ishide", (Object)HIDEBTNS);
        }
        data.put("data", (Object)"");
        custom.setData((Object)data);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = this.getModel().getValue(key);
        if (newValue == null) {
            return;
        }
        String number = String.valueOf(newValue);
        if (key.equals(CVT_FACTOR)) {
            String name = CvtFactorEnum4Edit.getCvtFactorEnum4EditByNumber((String)number).getName();
            this.addFactor(key, name, number);
        } else if (key.equals(EXCHANGE) || key.equals(PRE_EXCHANGE)) {
            Map exchangeInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(EXCHANGE_INFO));
            String name = key.startsWith("pre") ? String.format(ResManager.loadKDString((String)"\u4e0a\u671f%s", (String)"CvtFormulaEditPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), exchangeInfo.get(number.replaceFirst("pre", ""))) : (String)exchangeInfo.get(number.replaceFirst("pre", ""));
            this.addFactor(key, name, number);
        } else if (key.equals("rights")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            if ("inv".equals(number)) {
                formShowParameter.setFormId("bcm_invfunctionset");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "invformulacb");
                formShowParameter.setCloseCallBack(closeCallBack);
            } else if ("esp".equals(number)) {
                formShowParameter.setFormId("bcm_espfunctionset");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "espformulacb");
                formShowParameter.setCloseCallBack(closeCallBack);
            }
            this.getView().showForm(formShowParameter);
        } else if ("presetrate".equals(key)) {
            String name = CvtFactorEnum.CurYearAvgRate.getName();
            this.addFactor(EXCHANGE, name, number);
        }
        this.getModel().setValue(key, null);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("confirm")) {
            this.getPageCache().put("issave", "true");
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            custom.setData(CheckedFormulaUtil.packGetText());
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        switch (eventArgs.getEventName()) {
            case "f(x)": {
                String key = eventArgs.getEventArgs();
                if (StringUtils.isEmpty((String)key)) {
                    VFormula v = this.buildDefaultFormula();
                    this.showVPanel("formula_fx_", null, v.toString());
                    break;
                }
                if (key.startsWith("formula_fx_")) {
                    this.showVPanel("formula_fx_", key, this.getPageCache().get(key));
                    break;
                }
                if (key.startsWith("invformulacb")) {
                    this.showVPanel("invformulacb", key, this.getPageCache().get(key));
                    break;
                }
                if (!key.startsWith("espformulacb")) break;
                this.showVPanel("espformulacb", key, this.getPageCache().get(key));
                break;
            }
            case "getText": {
                String text = eventArgs.getEventArgs();
                if (this.getPageCache().get("issave") != null) {
                    boolean startWithEq = false;
                    text = text.replaceAll("\n", "");
                    if (StringUtils.isEmpty((String)(text = text.replaceAll("\\p{C}", "")))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6298\u7b97\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_1", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                        break;
                    }
                    if (text.startsWith("=")) {
                        text = text.replaceFirst("=", "");
                        startWithEq = true;
                    }
                    if (ChkCheckServiceHelper.isChinese((String)text)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u4e0d\u5e94\u5305\u542b\u4e2d\u6587\u6216\u4e2d\u6587\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_2", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    Object[] resultList = CheckedFormulaUtil.changeVFuntionToNumber((String)text, (IPageCache)this.getPageCache());
                    String exepr = CheckedFormulaUtil.getFormulaFromObjectResult((Object[])resultList);
                    FormulaPoolManager poolMng = ChkCheckServiceHelper.getPoolMng((String)exepr);
                    if (!poolMng.iterator().hasNext() && !(ExtDataServiceHelper.getBigDecimal((Object)exepr) instanceof BigDecimal)) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6298\u7b97\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_3", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        if (Objects.equals(this.getPageCache().get(ISRATE), "1")) {
                            msg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6c47\u7387\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_7", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]);
                        }
                        throw new KDBizException(msg);
                    }
                    CheckedFormulaUtil.FormulaBuilder formulas = (CheckedFormulaUtil.FormulaBuilder)resultList[0];
                    CheckedFormulaUtil.checkCanExcecuteDiff((String)((String)resultList[1]), (String)formulas.getCompsb().toString(), (boolean)false);
                    Pair<String, String> result = this.getFormula(formulas);
                    this.returnDataToParent(result);
                    if (startWithEq) {
                        this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9700\u5199\u5165=\u7b49\u53f7\u3002", (String)"CvtFormulaEditPlugin_4", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    this.getView().close();
                    break;
                }
                CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
                String newtext = FormulaServiceHelper.rebuildFormula((String)text, (IPageCache)this.getPageCache());
                JSONObject data = new JSONObject();
                data.put("operate", (Object)"updateText");
                if (Objects.equals(this.getPageCache().get(ISRATE), "1")) {
                    data.put("ishide", (Object)HIDEBTNS);
                }
                data.put("data", (Object)newtext);
                custom.setData((Object)data);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
        Object data = e.getReturnData();
        if (data != null) {
            String formula = "";
            String sign = "";
            Object packGetText = CheckedFormulaUtil.packGetText();
            HashMap dataCache = Maps.newHashMap();
            if ("formulacb".equals(key)) {
                formula = data.toString();
                sign = this.getComboSign("formula_fx_");
                dataCache.put(sign, formula);
                try {
                    String returnData = InvestServiceHelper.translateInvformla((String)formula, (long)this.getModelId());
                    dataCache.put(sign + "name", returnData);
                    custom.setData(FormulaServiceHelper.packAddText((String)sign, (String)returnData));
                }
                catch (Exception e1) {
                    log.error("error", (Throwable)e1);
                }
            } else if (key.startsWith("formula_fx_")) {
                formula = data.toString();
                sign = key;
                try {
                    String vFormulaName = InvestServiceHelper.translateInvformla((String)formula, (long)this.getModelId());
                    dataCache.put(key, formula);
                    dataCache.put(key + "name", vFormulaName);
                }
                catch (Exception e1) {
                    log.error("error", (Throwable)e1);
                }
                custom.setData(packGetText);
            } else if (key.equals("invformulacb")) {
                sign = this.getComboSign("invformulacb");
                formula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                dataCache.put(sign, formula);
                dataCache.put(sign + "name", invFormulaName);
                custom.setData(FormulaServiceHelper.packAddText((String)sign, (String)invFormulaName));
            } else if (key.startsWith("invformulacb")) {
                sign = key;
                formula = ((HashMap)data).get(FORMULA).toString();
                String invFormulaName = ((HashMap)data).get("name").toString();
                dataCache.put(sign, formula);
                dataCache.put(sign + "name", invFormulaName);
                custom.setData(packGetText);
            }
            this.getPageCache().put((Map)dataCache);
            this.getPageCache().put(sign, formula);
        }
    }

    private Pair<String, String> getFormula(CheckedFormulaUtil.FormulaBuilder formulas) {
        String formula = formulas.getLeftsb().toString() + formulas.getCompsb().toString() + formulas.getRigntsb().toString();
        return new Pair((Object)formula, (Object)FormulaServiceHelper.analyCvtFullFormula((String)formula, null, (long)this.getModelId()));
    }

    private void setComboBox() {
        ComboEdit cvtFactor = (ComboEdit)this.getControl(CVT_FACTOR);
        ArrayList<ComboItem> factors = new ArrayList<ComboItem>(10);
        for (CvtFactorEnum4Edit factor : CvtFactorEnum4Edit.getCurrentUsage()) {
            factors.add(new ComboItem(new LocaleString(factor.getName()), factor.getNumber()));
        }
        cvtFactor.setComboItems(factors);
        ComboEdit exchange = (ComboEdit)this.getControl(EXCHANGE);
        ComboEdit preExchange = (ComboEdit)this.getControl(PRE_EXCHANGE);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ArrayList<ComboItem> preItems = new ArrayList<ComboItem>();
        Long modelId = this.getModelId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("parent.number", "=", (Object)"ExchangeRate");
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"name,number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq");
        for (DynamicObject dot : cols) {
            String name = dot.getString("name");
            String number = dot.getString("number");
            items.add(new ComboItem(new LocaleString(name), number));
            preItems.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"\u4e0a\u671f%s", (String)"CvtFormulaEditPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), name)), "pre" + number));
        }
        exchange.setComboItems(items);
        preExchange.setComboItems(preItems);
        this.getPageCache().put(EXCHANGE_INFO, ObjectSerialUtil.toByteSerialized((Object)FormulaServiceHelper.getExchangeInfoMap((Long)modelId)));
    }

    private void buildEditPage() {
        String formula = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
        if (formula != null) {
            CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
            custom.setData(this.packFormula(formula));
        }
    }

    private void addFactor(String key, String value, String number) {
        CustomControl custom = (CustomControl)this.getView().getControl("cvtformulasettingtext");
        String sign = this.getComboSign(CVTFORMULACV);
        number = "CVT(\"" + key + "@" + number + "\")";
        this.getPageCache().put(sign, number);
        custom.setData(CheckedFormulaUtil.packAddTextNoEdit((String)sign, (String)value));
    }

    private String getComboSign(String type) {
        return type + RandomStringUtils.randomAlphanumeric((int)5).toLowerCase(Locale.ENGLISH);
    }

    private Pair<String, String> transFormula(String formula) {
        ExpressParser parser = new ExpressParser();
        EncoderService coder = new EncoderService();
        StringBuilder chinese = new StringBuilder();
        try {
            Map exchangeInfo = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(EXCHANGE_INFO));
            Pair pair = parser.parse(formula, coder);
            int flag = 0;
            for (int i = 0; i < ((String)pair.p1).length(); ++i) {
                if (((String)pair.p1).charAt(i) >= 'A' && ((String)pair.p1).charAt(i) <= 'Z') {
                    if (!ExpressionServiceHelper.checkFactorComplete((int)i, (String)((String)pair.p1))) continue;
                    chinese.append(this.transToChinese((IFormula)((List)pair.p2).get(flag), exchangeInfo));
                    ++flag;
                    continue;
                }
                chinese.append(((String)pair.p1).charAt(i));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6298\u7b97\u516c\u5f0f\u3002", (String)"CvtFormulaEditPlugin_5", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
        }
        return Pair.onePair((Object)formula, (Object)chinese.toString());
    }

    private String transToChinese(IFormula f, Map<String, String> exchangeInfo) {
        StringBuilder chinaName = new StringBuilder();
        if (f.getName().equals("CVT")) {
            String[] number = ((ParamItem)f.getParamList().get(0)).toString().split("@");
            if (number[0].equals(CVT_FACTOR)) {
                chinaName.append(CvtFactorEnum4Edit.getCvtFactorEnum4EditByNumber((String)number[1]).getName());
            } else if (number[0].equals(EXCHANGE) || number[0].equals(PRE_EXCHANGE)) {
                chinaName.append(number[1].startsWith("pre") ? String.format(ResManager.loadKDString((String)"\u4e0a\u671f%s", (String)"CvtFormulaEditPlugin_0", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]), exchangeInfo.get(number[1].replaceFirst("pre", ""))) : exchangeInfo.get(number[1]));
            } else if (number[0].equals("rights")) {
                chinaName.append(ResManager.loadKDString((String)"\u7b49\u6548\u6301\u80a1\u6bd4\u4f8b", (String)"CvtFormulaEditPlugin_6", (String)FI_BCM_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if (f.getName().equals(FormulaEnum.Inv.name())) {
            String aNumber = ((ParamItem)f.getParamList().get(1)).toString();
            String ctNumber = ((ParamItem)f.getParamList().get(2)).toString();
            DynamicObject a = DimensionServiceHelper.queryMemberNameByNumber((String)"bcm_accountmembertree", (Object)this.getModelId(), (String)aNumber);
            DynamicObject ct = DimensionServiceHelper.queryMemberNameByNumber((String)"bcm_changetypemembertree", (Object)this.getModelId(), (String)ctNumber);
            chinaName.append(a.getString("name"));
            chinaName.append('|').append(ct.getString("name"));
        } else if (f.getName().equals(FormulaEnum.Esp.name())) {
            String invType = ((ParamItem)f.getParamList().get(0)).toString();
            String numberType = ((ParamItem)f.getParamList().get(1)).toString();
            String name = HolderTypeEnum.getNameByNumber((String)numberType);
            if ("4".equals(invType) || "5".equals(invType)) {
                name = HolderTypeEnum.UniteScale.getName();
            }
            chinaName.append(name);
        } else if (f.getName().equals("V")) {
            String oldValue = f.toString();
            chinaName.append(ChkFormulaServiceHelper.translateChkformla((String)oldValue, (long)this.getModelId(), (int)1, (String)"account;changetype"));
        }
        return chinaName.toString();
    }

    private VFormula buildDefaultFormula() {
        VFormula v = new VFormula();
        v.initParam(new ParamList());
        QFilter qf = new QFilter("model.id", "=", (Object)this.getModelId());
        QFilter[] qfs = new QFilter[]{qf};
        String selectFields = "id,name,number,shortnumber,issysdimension";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])qfs);
        for (DynamicObject dim : dcs) {
            ParamItem pi;
            String shortnumber = dim.getString("shortnumber");
            boolean issysdimension = dim.getBoolean("issysdimension");
            if (DimTypesEnum.CURRENCY.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.CURRENCY.getShortNumber() + "." + "EC"));
                v.getParamList().add((Object)pi);
            }
            if (this.isExistAuditTrailDimension() && DimTypesEnum.AUDITTRIAL.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.AUDITTRIAL.getShortNumber() + "." + "ATTotal"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.INTERCOMPANY.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.INTERCOMPANY.getShortNumber() + "." + "ICNone"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.MYCOMPANY.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.MYCOMPANY.getShortNumber() + "." + "MCNone"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.MULTIGAAP.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.MULTIGAAP.getShortNumber() + "." + "PRCGAAP"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (DimTypesEnum.DATASORT.getShortNumber().equals(shortnumber)) {
                pi = new ParamItem((Object)(DimTypesEnum.DATASORT.getShortNumber() + "." + "Actual"));
                v.getParamList().add((Object)pi);
                continue;
            }
            if (issysdimension) continue;
            pi = new ParamItem((Object)(shortnumber + "." + shortnumber + "None"));
            v.getParamList().add((Object)pi);
        }
        return v;
    }

    private void showVPanel(String type, String key, Object param) {
        CloseCallBack closeCallBack;
        FormShowParameter formShowParameter = new FormShowParameter();
        if (key == null || key.startsWith("formula_fx_")) {
            formShowParameter.setFormId("bcm_vformula");
            closeCallBack = key != null ? new CloseCallBack((IFormPlugin)this, key) : new CloseCallBack((IFormPlugin)this, "formulacb");
        } else if (key.startsWith("invformulacb")) {
            formShowParameter.setFormId("bcm_invfunctionset");
            closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        } else {
            formShowParameter.setFormId("bcm_espfunctionset");
            closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        FormulaTicketer ticketer = this.buildTicketer();
        formShowParameter.setCustomParam("FormulaTicketer", (Object)this.toByteSerialized(ticketer));
        formShowParameter.setCustomParam(FORMULA, param);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private FormulaTicketer buildTicketer() {
        FormulaTicketer ticketer = new FormulaTicketer();
        IValidate notnull = (IValidate)IValidate.build(NotNullValidate.class);
        DynamicObjectCollection alldims = QueryDimensionServiceHelper.getDimensionBaseInfos((Object)this.getModelId());
        for (DynamicObject obj : alldims) {
            String entity = obj.getString("membermodel");
            String number = obj.getString("number");
            String name = obj.getString("name");
            if ("bcm_entitymembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, false, false, false));
                continue;
            }
            if ("bcm_periodmembertree".equals(entity) || "bcm_fymembertree".equals(entity) || "bcm_scenemembertree".equals(entity) || "bcm_processmembertree".equals(entity)) {
                ticketer.addTicket(entity, new FTicket(entity, name, null, true, true, false));
                continue;
            }
            String sign = this.sugarF7Key(entity, number);
            ticketer.addTicket(sign, new FTicket(entity, name, notnull, true, true, true));
        }
        return ticketer;
    }

    private Object packFormula(String formula) {
        JSONObject data = new JSONObject();
        data.put("data", (Object)FormulaServiceHelper.analyCvtFullFormula((String)formula, (IPageCache)this.getPageCache(), (long)this.getModelId()));
        data.put("operate", (Object)"updateText");
        if (Objects.equals(this.getPageCache().get(ISRATE), "1")) {
            data.put("ishide", (Object)HIDEBTNS);
        }
        return data;
    }
}

