/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.EffectiveYearPeriodUtil;
import org.apache.commons.lang3.StringUtils;

public class ExpiredDatePlugin
extends AbstractBaseFormPlugin {
    private static final String year = "yearcol";
    private static final String period = "periodcol";
    private static final String yearscope = "yearscopecol";
    private static final String entryentity = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_cancel", "btn_confirm");
        BasedataEdit yearcol = (BasedataEdit)this.getControl(year);
        yearcol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodCol = (BasedataEdit)this.getControl(period);
        periodCol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        EffectiveYearPeriodUtil.beforeF7Select(beforeF7SelectEvent, this.getModelId(), name, this.getModel(), this.getPageCache());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(key)) {
            JSONObject obj = new JSONObject();
            obj.put("text", (Object)EffectiveYearPeriodUtil.buildPeriodTxt(this.getModel(), this.getModelId()));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            obj.put("entryId", formShowParameter.getCustomParam("entryId"));
            obj.put("effective", EffectiveYearPeriodUtil.saveEffectiveInfo(this.getModel()));
            this.returnDataToParent(obj.toJSONString());
            this.getView().close();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        Long scenarioId;
        Map effectiveMap;
        String effective;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object data = formShowParameter.getCustomParam("effective");
        if (null != data && StringUtils.isNotBlank((CharSequence)(effective = String.valueOf(data))) && (effectiveMap = (Map)JSON.parseObject((String)effective, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0])) != null) {
            EffectiveYearPeriodUtil.loadEntitymember(this.getModel(), this.getPageCache(), effectiveMap);
        }
        if ((scenarioId = (Long)formShowParameter.getCustomParam("KEY_SCENARIO_ID")) != null) {
            this.getPageCache().put("SCENARIO_ID", scenarioId.toString());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(entryentity);
        if (year.equals(key)) {
            if (e.getChangeSet()[0].getOldValue() == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.THISYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            }
            if (e.getChangeSet()[0].getNewValue() == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            }
        }
        if (yearscope.equals(key)) {
            if (this.getModel().getEntryRowEntity(entryentity, index).get(year) == null) {
                this.getModel().setValue(yearscope, (Object)YearScopeEnum.ALLYEAR.getValue(), index);
                this.getView().updateView(yearscope, index);
            } else if (YearScopeEnum.ALLYEAR.getValue().equals(e.getChangeSet()[0].getNewValue())) {
                this.getModel().setValue(year, null, index);
                this.getView().updateView(year, index);
            }
        }
    }
}

