/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.convertscheme;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.convert.ReportConvertParam;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;

public class ReportConvertPlugin
extends AbstractBaseFormPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle {
    private static final String model_id = "KEY_MODEL_ID";
    private static final String scene_id = "bcm_scenemembertree";
    private static final String year_id = "bcm_fymembertree";
    private static final String period_id = "bcm_periodmembertree";
    private static final String org_id = "bcm_entitymembertree";
    private static final List<String> keys = Lists.newArrayList((Object[])new String[]{"sourcecurrency", "targetcurrency"});
    private static final String CUR_EC = "cur_ec";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<String, Long> param = this.getQueryParam();
        Long modelId = param.get(model_id);
        Long orgId = param.get(org_id);
        IDNumberTreeNode enode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        boolean isautoconvert = ExchangeQueryHelper.getAutoConvert((Long)param.get(model_id), (Long)param.get(scene_id), (Long)param.get(year_id), (Long)param.get(period_id), (SimpleVo)SimpleVo.newOne((IDNumberTreeNode)enode));
        this.setModelValue(isautoconvert, param);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("btn_ok");
        long modelId = this.getQueryParam().get(model_id);
        String currencyDimId = this.getPageCache().get("currencyDimId");
        if (currencyDimId == null) {
            QFilter filter1 = new QFilter("model", "=", (Object)modelId);
            QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.CURRENCY.getNumber());
            DynamicObject dimObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{filter1, filter2});
            currencyDimId = dimObj.getString("id");
            this.getPageCache().put("currencyDimId", currencyDimId);
        }
        SingleMemberF7Util.cacheSingleMemberF7ByModelId(this.getView(), this.getModel(), modelId, Long.parseLong(currencyDimId), keys, (SingleMemberF7Util.ISingleMemberF7Handle)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long modelId = this.getQueryParam().get(model_id);
        this.getPageCache().put(model_id, String.valueOf(modelId));
        SingleMemberF7Util.cacheModelPrem(this.getPageCache(), modelId, this.getApplicationType());
        if (this.getFormCustomParam("tip") != null) {
            this.getView().showTipNotification((String)this.getFormCustomParam("tip"), Integer.valueOf(5000));
        }
        boolean isShowOrgScope = false;
        if (this.getFormCustomParam("isShowOrgScope") != null) {
            isShowOrgScope = (Boolean)this.getFormCustomParam("isShowOrgScope");
        }
        this.showOrgScope(isShowOrgScope);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "sourcecurrency": 
            case "targetcurrency": {
                DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.propertyChangedDimUse(key, newValue);
                break;
            }
            case "cvtscope": {
                IDNumberTreeNode ecNode;
                String scope = (String)e.getChangeSet()[0].getNewValue();
                if (!ConvertServiceHelper.isSingleOrgConvert((String)scope)) {
                    IDNumberTreeNode ecCurNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)"EC");
                    if (ecCurNode == IDNumberTreeNode.NotFoundTreeNode) break;
                    this.setValueOnModel("sourcecurrency", ecCurNode.getId());
                    this.getView().setEnable(Boolean.FALSE, new String[]{"sourcecurrency"});
                    break;
                }
                IDNumberTreeNode currentOrgNode = this.getCurrentOrgNode();
                if (currentOrgNode != IDNumberTreeNode.NotFoundTreeNode && (ecNode = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)currentOrgNode.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode) {
                    this.setValueOnModel("sourcecurrency", ecNode.getId());
                }
                Map<String, Long> param = this.getQueryParam();
                boolean isAutoConvert = ExchangeQueryHelper.getAutoConvert((Long)param.get(model_id), (Long)param.get(scene_id), (Long)param.get(year_id), (Long)param.get(period_id), (SimpleVo)SimpleVo.newOne((IDNumberTreeNode)currentOrgNode));
                this.getView().setEnable(Boolean.valueOf(!isAutoConvert), new String[]{"sourcecurrency"});
                break;
            }
        }
    }

    private void setModelValue(boolean isautoconvert, Map<String, Long> param) {
        DynamicObject pcobj;
        this.setValueOnModel("isautoconvert", isautoconvert);
        this.setValueOnModel("convertpath", 2);
        Long orgId = param.get(org_id);
        Long yearId = param.get(year_id);
        Long periodId = param.get(period_id);
        DynamicObject ecobj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId);
        if (Objects.nonNull(ecobj)) {
            this.setValueOnModel("sourcecurrency", ecobj.getLong("id"));
            this.getPageCache().put(CUR_EC, ecobj.getString("number"));
        }
        if (Objects.nonNull(pcobj = OrgCurrencyServiceHelper.getParentCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId))) {
            this.setValueOnModel("targetcurrency", pcobj.getLong("id"));
        }
        if (isautoconvert) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcecurrency"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"targetcurrency"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"sourcecurrency", "targetcurrency"});
        }
    }

    private ReportConvertParam getCurrentConvertPath() {
        ArrayList<Pair<Long, String>> path = new ArrayList<Pair<Long, String>>(2);
        path.add(this.getCurrencyIdAndNumberByKey("sourcecurrency"));
        path.add(this.getCurrencyIdAndNumberByKey("targetcurrency"));
        String cvtScope = (String)this.getModel().getValue("cvtscope");
        return new ReportConvertParam(path, cvtScope);
    }

    private void checkCurrencyValueNotEmpty() {
        DynamicObject source = (DynamicObject)this.getModel().getValue("sourcecurrency");
        DynamicObject target = (DynamicObject)this.getModel().getValue("targetcurrency");
        if (source == null || target == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8bbe\u7f6e\u7684\u5e01\u79cd\u3002", (String)"ReportConvertPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        String sourceCurNumber = source.getString("number");
        String targetCurNumber = target.getString("number");
        String cvtScope = (String)this.getModel().getValue("cvtscope");
        boolean isSingleOrgCvt = ConvertServiceHelper.isSingleOrgConvert((String)cvtScope);
        if (!source.getBoolean("isleaf") || isSingleOrgCvt && "EC".equals(sourceCurNumber) || "PC".equals(sourceCurNumber) || "DC".equals(sourceCurNumber) || "OC".equals(sourceCurNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u524d\u5e01\u79cd\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u5e01\u79cd\u3002", (String)"ReportConvertPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (!target.getBoolean("isleaf") || "EC".equals(targetCurNumber) || "PC".equals(targetCurNumber) || "DC".equals(targetCurNumber) || "OC".equals(targetCurNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u540e\u5e01\u79cd\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u5e01\u79cd\u3002", (String)"ReportConvertPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        if (isSingleOrgCvt && Objects.equals(targetCurNumber, this.getPageCache().get(CUR_EC))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u540e\u5e01\u79cd\u4e0d\u5141\u8bb8\u4e3a\u5f53\u524d\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"ReportConvertPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkCurrencyIsNotSame() {
        if (this.getCurrencyIdFromModel("sourcecurrency").equals(this.getCurrencyIdFromModel("targetcurrency"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u7b97\u524d\u540e\u5e01\u79cd\u76f8\u540c\uff0c\u4e0d\u6267\u884c\u6298\u7b97\uff0c\u5982\u9700\u6298\u7b97\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u6298\u7b97\u5e01\u79cd\u3002", (String)"ReportConvertPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getCurrencyIdFromModel(String f7Key) {
        Object o = this.getModel().getValue(f7Key);
        return o != null ? ((DynamicObject)o).getLong("id") : 0L;
    }

    private Pair<Long, String> getCurrencyIdAndNumberByKey(String key) {
        DynamicObject curr = (DynamicObject)this.getModel().getValue(key);
        return Pair.onePair((Object)curr.getLong("id"), (Object)curr.getString("number"));
    }

    private Map<String, Long> getQueryParam() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(model_id, (Long)this.getFormCustomParam(model_id));
        map.put(scene_id, (Long)this.getFormCustomParam(scene_id));
        map.put(year_id, (Long)this.getFormCustomParam(year_id));
        map.put(period_id, (Long)this.getFormCustomParam(period_id));
        map.put(org_id, (Long)this.getFormCustomParam(org_id));
        return map;
    }

    private IDNumberTreeNode getCurrentOrgNode() {
        long modelId = this.getQueryParam().get(model_id);
        long orgId = this.getQueryParam().get(org_id);
        return MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String itemkey = Control2.getKey();
        if ("btn_ok".equals(itemkey)) {
            try {
                this.checkCurrencyValueNotEmpty();
                this.checkCurrencyIsNotSame();
                this.checkPCMergeStatus();
                this.getView().returnDataToParent((Object)this.getCurrentConvertPath());
                this.getView().close();
            }
            catch (KDBizException e) {
                this.getView().showTipNotification(e.getMessage());
            }
        }
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
    }

    private void checkPCMergeStatus() {
        long modelId = this.getQueryParam().get(model_id);
        long orgId = this.getQueryParam().get(org_id);
        long sceneId = this.getQueryParam().get(scene_id);
        long yearId = this.getQueryParam().get(year_id);
        long periodId = this.getQueryParam().get(period_id);
        DynamicObject targetCurrencyDy = (DynamicObject)this.getModel().getValue("targetcurrency");
        String targetCurrencyNumber = targetCurrencyDy.getString("number");
        McStatus status = McStatus.getMcStatusByCurrencyNumber((Long)modelId, (Long)orgId, (Long)sceneId, (Long)yearId, (Long)periodId, (String)targetCurrencyNumber);
        if (status != null && status.getPcFlow().isSubmit()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6298\u7b97\u5e01\u5728\u667a\u80fd\u5408\u5e76\u7684\u6298\u7b97\u5e01\u6d41\u7a0b\u72b6\u6001\u4e3a\u5df2\u9501\u5b9a\uff0c\u4e0d\u5141\u8bb8\u6298\u7b97\u3002", (String)"ReportConvertPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showOrgScope(boolean isShowOrgScope) {
        IDNumberTreeNode currentOrgNode = this.getCurrentOrgNode();
        this.getView().setVisible(Boolean.valueOf(isShowOrgScope && !currentOrgNode.isLeaf()), new String[]{"flexpanelap5", "flexpanelap6"});
    }
}

