/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ParentBasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.log.DataPermLogHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.CslSchemeScopeEnum;
import kd.fi.bcm.common.enums.log.DataPermLogMultiLangEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.util.DynamicEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import org.apache.commons.lang3.StringUtils;

public class CslSchemeAndCatalogEditPlugin
extends AbstractBaseBasicPlugIn
implements BCMBaseFunction {
    private String getOperationCreateNewClass() {
        return ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b", (String)"CslSchemeAndCatalogEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setSchemeDefaultValue();
        this.getView().setVisible(Boolean.FALSE, new String[]{"permclass"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlVisibleAndProperty();
        if (!this.isScheme()) {
            this.checkItemAuthForEnable("islegalorgview");
        }
    }

    public void afterLoadData(EventObject e) {
        if (!CslSchemeScopeEnum.isPermClassControl((String)this.getModel().getValue("scope").toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"permclass"});
        } else {
            PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getModelId(), (boolean)false);
        }
        if ("root".equals(this.getModel().getValue("number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"scope"});
            this.getModel().setValue("scope", (Object)CslSchemeScopeEnum.ALL.getValue());
        }
        Object id = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (this.getModel().getValue("scope").equals(CslSchemeScopeEnum.PERMCLASS.getValue()) && PermClassEntityHelper.isHasReadPerm((String)"bcm_cslscheme", (Long)this.getModelId(), (Long)LongUtil.toLong((Object)id))) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_ok"});
        }
        this.getModel().setDataChanged(false);
    }

    private void setControlVisibleAndProperty() {
        Map customParams;
        boolean isScheme = this.isScheme();
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(isScheme), new String[]{"description", "islegalorgview"});
        view.setEnable(Boolean.valueOf(isScheme), new String[]{"parent"});
        if (isScheme) {
            ParentBasedataEdit parentControl = (ParentBasedataEdit)this.getControl("parent");
            String strName = ResManager.loadKDString((String)"\u5206\u7c7b", (String)"CslSchemeAndCatalogEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            parentControl.setCaption(new LocaleString(strName));
            parentControl.setMustInput(true);
        }
        boolean islegalorgview = (Boolean)this.getModel().getValue("islegalorgview");
        if (isScheme && islegalorgview) {
            view.setEnable(Boolean.FALSE, new String[]{"islegalorgview"});
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("parent")) {
            if (customParams.get("parent") != null) {
                view.setVisible(Boolean.valueOf(false), new String[]{"catelog"});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"catelog"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit permclass = (BasedataEdit)this.getControl("permclass");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getModelId());
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("nodetype_list", (Object)NodeType.Catelog.value);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCustomParam("source", (Object)"dim_manager_view");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u5217\u8868", (String)"CslSchemeAndCatalogEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("model", "=", (Object)this.getModelId()));
            listFilterParameter.setFilter(new QFilter("nodetype", "=", (Object)NodeType.Catelog.value));
            listFilterParameter.setOrderBy("level, createdate");
        });
    }

    private boolean isScheme() {
        String nodeType = (String)this.getModel().getValue("nodetype");
        return NodeType.Scheme.value.equals(nodeType);
    }

    private void setSchemeDefaultValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object parentId = formShowParameter.getCustomParam("parent");
        Object modelId = formShowParameter.getCustomParam("model");
        Boolean isScheme = (Boolean)formShowParameter.getCustomParam("isScheme");
        IDataModel dataModel = this.getModel();
        boolean isNotNullParent = Objects.nonNull(parentId);
        if (!isNotNullParent) {
            QFilter qcf = new QFilter("model", "=", modelId);
            qcf.and("nodetype", "=", (Object)NodeType.Catelog.value);
            Collection mcs = BusinessDataServiceHelper.loadFromCache((String)"bcm_cslscheme", (String)"name, level", (QFilter[])new QFilter[]{qcf}, (String)"level").values();
            ArrayList items = new ArrayList();
            ArrayList<String[]> keysAndValues = new ArrayList<String[]>(mcs.size());
            for (DynamicObject catelog : mcs) {
                String[] keysAndValue = new String[]{catelog.getString("name"), catelog.getString("id")};
                keysAndValues.add(keysAndValue);
            }
            keysAndValues.forEach(new DynamicEnum(items));
            ComboEdit comboEdit = (ComboEdit)this.getControl("catelog");
            comboEdit = (ComboEdit)this.getControl("catelog");
            comboEdit.setComboItems(items);
            dataModel.setValue("catelog", (Object)((ComboItem)items.get(0)).getValue());
            parentId = ((ComboItem)items.get(0)).getValue();
            comboEdit.setMustInput(true);
        }
        dataModel.setValue("parent", parentId);
        DynamicObject parentDyn = (DynamicObject)dataModel.getValue("parent");
        dataModel.setValue("level", (Object)(parentDyn.getInt("level") + 1));
        this.getView().setVisible(Boolean.valueOf(isNotNullParent), new String[]{"parent"});
        dataModel.setValue("model", modelId);
        if (isScheme != null && isScheme.booleanValue()) {
            this.getModel().setValue("nodetype", (Object)NodeType.Scheme.value);
            this.getModel().setValue("isleaf", (Object)true);
            this.getModel().setValue("isenable", (Object)false);
            this.getModel().setValue("effectivestatus", (Object)false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equalsIgnoreCase(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Boolean isScheme = (Boolean)formShowParameter.getCustomParam("isScheme");
            Boolean isSchemeClass = (Boolean)formShowParameter.getCustomParam("isSchemeClass");
            if (isScheme != null && isScheme.booleanValue()) {
                this.writeOpLog(OpItemEnum.ADD.getName(), OpItemEnum.ADD.getName(), ResultStatusEnum.SUCCESS.getName());
            } else if (isSchemeClass != null && isSchemeClass.booleanValue()) {
                this.writeOpLog(this.getOperationCreateNewClass(), OpItemEnum.ADD.getName(), ResultStatusEnum.SUCCESS.getName());
            } else {
                this.writeOpLog(OpItemEnum.SAVE.getName(), OpItemEnum.SAVE.getName(), ResultStatusEnum.SUCCESS.getName());
            }
            this.permclassLog();
            this.saveMemberPermData(afterDoOperationEventArgs);
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            if (this.isParentEditPage(parentView)) {
                this.getView().sendFormAction(parentView);
                return;
            }
            if (isScheme != null && isScheme.booleanValue()) {
                this.showCslSchemeEditForm(afterDoOperationEventArgs, parentView);
            } else {
                this.getView().returnDataToParent(afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0));
            }
        }
    }

    private void writeOpLog(String opName, String op, String status) {
        String log = String.format("%s %s,%s%s", this.getModel().getValue("number"), this.getModel().getValue("name"), op, status);
        OperationLogUtil.writeOperationLog((String)opName, (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
    }

    private void saveMemberPermData(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        Object successPkId = operationResult.getSuccessPkIds().get(0);
        try (TXHandle tx = TX.required();){
            try {
                PermClassEntityHelper.savePermClass((String)"bcm_cslscheme", successPkId, (Object)this.getModelId(), (Object)this.getModel().getValue("permclass"));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    private boolean isParentEditPage(IFormView parentView) {
        return StringUtils.equals((CharSequence)"bcm_cslschemeedit", (CharSequence)parentView.getFormShowParameter().getFormId());
    }

    private void showCslSchemeEditForm(AfterDoOperationEventArgs afterDoOperationEventArgs, IFormView parentView) {
        if (this.isLegalSchemeAndFromDimensionListPage(parentView)) {
            return;
        }
        CslSchemeUtils.showCslSchemeEditForm(parentView, afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().get(0).toString(), (Long)this.getFormCustomParam("model"), true);
    }

    private boolean isLegalSchemeAndFromDimensionListPage(IFormView parentView) {
        return (Boolean)this.getModel().getValue("islegalorgview") != false && "bcm_dimensionmanager".equals(parentView.getFormShowParameter().getFormId());
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("number".equals(propertyName)) {
            this.numberChanged(e);
        } else if ("catelog".equals(propertyName)) {
            if (e.getChangeSet()[0].getNewValue() == null) {
                return;
            }
            IDataModel dataModel = this.getModel();
            dataModel.setValue("parent", e.getChangeSet()[0].getNewValue());
            DynamicObject parentDyn = (DynamicObject)dataModel.getValue("parent");
            dataModel.setValue("level", (Object)(parentDyn.getInt("level") + 1));
        } else if ("scope".equals(propertyName)) {
            if (CslSchemeScopeEnum.PERMCLASS.getValue().equals(e.getChangeSet()[0].getNewValue())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"permclass"});
                PermClassEntityHelper.loadPermClass((IDataModel)this.getModel(), (Object)this.getModelId(), (boolean)false);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"permclass"});
                this.getModel().setValue("permclass", null);
            }
        } else if ("permclass".equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue == null && oldValue != null) {
                this.getPageCache().put("permclassOp", "delete");
                this.getPageCache().put("oldValue", oldValue.getString("number"));
            } else if (oldValue == null && newValue != null) {
                this.getPageCache().put("permclassOp", "add");
            } else if (oldValue != null && newValue != null) {
                this.getPageCache().put("permclassOp", "update");
            } else {
                return;
            }
        }
    }

    private void numberChanged(PropertyChangedArgs e) {
        String newnumber = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isEmpty((CharSequence)newnumber)) {
            return;
        }
        String regEx = "^(?!_)[-a-zA-Z0-9.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(newnumber);
        String message = "";
        if (!matcher.matches()) {
            message = ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"CslSchemeAndCatalogEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        } else if (newnumber.contains("..") || newnumber.startsWith(".") || newnumber.startsWith("-")) {
            message = ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"CslSchemeAndCatalogEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.getModel().setValue("number", null);
            this.getView().showTipNotification(message);
            return;
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("change2Close_comfirm")) {
            if (mbce.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                this.getPageCache().put("isClose", "true");
                this.getView().close();
            } else {
                this.getPageCache().put("isClose", null);
            }
        }
    }

    private void permclassLog() {
        String permclassOp = this.getPageCache().get("permclassOp");
        if (Objects.nonNull(permclassOp)) {
            String distributeObject;
            String appId = this.getView().getFormShowParameter().getAppId();
            ArrayList<DynamicObject> permlogs = new ArrayList<DynamicObject>(1);
            Long modelid = LongUtil.toLong((Object)((DynamicObject)this.getModel().getValue("model")).getString("id"));
            DynamicObject permClassDy = (DynamicObject)this.getModel().getValue("permclass");
            String permClassNumber = permClassDy == null ? "" : permClassDy.getString("number");
            String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            String content = "";
            String cslscheme = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe_%1$s", (String)"CslSchemeAndCatalogEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name);
            String cslschemeClass = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b_%1$s", (String)"CslSchemeAndCatalogEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), name);
            String string = distributeObject = this.isScheme() ? cslscheme : cslschemeClass;
            if ("add".equals(permclassOp)) {
                content = DataPermLogMultiLangEnum.PermCLASS_Distribute_AddNew.getOperateName();
            } else if ("update".equals(permclassOp)) {
                content = DataPermLogMultiLangEnum.PermCLASS_Distribute_MODIFY.getOperateName();
            } else if ("delete".equals(permclassOp)) {
                content = DataPermLogMultiLangEnum.PermCLASS_Distribute_DELETE.getOperateName();
                permClassNumber = this.getPageCache().get("oldValue");
            }
            DynamicObject logs = DataPermLogHelper.newPermClassDistributeLog((Long)modelid, null, null, null, (String)permClassNumber, (String)distributeObject, (String)content, (String)appId);
            permlogs.add(logs);
            if (permlogs.size() > 0) {
                try {
                    DataPermLogHelper.batchInsertDataPermLog(permlogs);
                }
                catch (KDException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        OperateOption option = ((Save)source).getOption();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT == status) {
            boolean islegalNew = (Boolean)this.getModel().getValue("islegalorgview");
            Long cslId = (Long)this.getModel().getValue("id");
            QFilter qf = new QFilter("id", "=", (Object)cslId);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"islegalorgview", (QFilter[])qf.toArray());
            if (islegalNew && !dy.getBoolean("islegalorgview")) {
                QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
                qFilter.and("cslscheme", "=", (Object)cslId);
                qFilter.and("status", "=", (Object)StatusEnum.TempSave.toString());
                if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])qFilter.toArray())) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u89c6\u56fe\u4e0b\u6709\u65b0\u589e\u4f46\u672a\u63d0\u4ea4\u7684\u7ec4\u7ec7\u6210\u5458\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u6cd5\u5b9a\u89c6\u56fe\uff0c\u8bf7\u901a\u8fc7\u5f00\u542f\u89c6\u56fe\u7684\u65b9\u5f0f\u63d0\u4ea4\u6210\u5458\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"CslSchemeAndCatalogEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            }
            option.setVariableValue("ope_type", OperationStatus.EDIT.toString());
        } else {
            String number = (String)this.getValue("number");
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            qf.and("number", "=", (Object)number);
            if (QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])qf.toArray())) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u5206\u7c7b\u6216\u7ec4\u7ec7\u89c6\u56fe\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"CslSchemeAndCatalogEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            option.setVariableValue("ope_type", OperationStatus.ADDNEW.toString());
        }
    }

    private void checkItemAuthForEnable(String ... buttons) {
        Map btnPerms = this.getButtonsPerm(buttons);
        IFormView view = this.getPlugin().getView();
        btnPerms.forEach((btnStr, perm) -> view.setEnable(Boolean.valueOf(perm != 0), new String[]{btnStr}));
    }

    private static enum NodeType {
        Catelog("0"),
        Scheme("1");

        private String value;

        private NodeType(String value) {
            this.value = value;
        }
    }
}

