/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.formplugin.BcmBasePluginUtil;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.util.SearchUtil;

public class CslSchemeEditPlugin
extends AbstractBaseBasicPlugIn
implements TreeNodeClickListener,
SubPage {
    private static final String orgtree = "orgtree";
    private static final String cache_tree = "cache_tree";
    private static final String cache_nodeNumbers = "cache_nodeNumbers";
    private static final String AddNewCslSchemeType = "";
    private static final int MAXLEVEL = 20;
    private Long modelId = 0L;
    private Long dimensionId = 0L;
    private Date beginDate = null;
    private Long cslSchemeId = 0L;
    public static final String selector = "id,name,number,shownumber,parent.id,dseq,level,isleaf,longnumber,aggoprt,storagetype,currency.id,currency.name,currency.number,belongscheme.id,ctrlorg,isindependentorg,isinnerorg,copyfrom,status";

    private String getOperationSave() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CslSchemeEditPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDisadle() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"CslSchemeEditPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationAdle() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"CslSchemeEditPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CslSchemeEditPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"CslSchemeEditPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "btn_quickimport"});
        final TreeView tree = (TreeView)this.getControl(orgtree);
        tree.addTreeNodeDragListener(new TreeNodeDragListener(){

            public void treeNodeDragged(TreeNodeDragEvent arg0) {
                CslSchemeEditPlugin.this.handleTreeNodeDragged(arg0);
            }
        });
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        Search sr = (Search)this.getControl("searchap");
        sr.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !CslSchemeEditPlugin.AddNewCslSchemeType.equals(event.getText())) {
                    SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, tree, CslSchemeEditPlugin.cache_tree);
                } else {
                    pageCache.put("resultlist", null);
                    view.showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = evt.getNodeId().toString();
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode != null) {
            TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
            TreeNode parentNode = rootNode.getTreeNode(focusNode.getParentid(), 20);
            DynamicObject model = this.getModel().getDataEntity();
            this.getPageCache().put("focusNodeId", focusNodeId);
            model.set("number", this.getNodeProperty("number", focusNode));
            model.set("name", this.getNodeProperty("name", focusNode));
            model.set("parentname", parentNode != null ? this.getNodeProperty("name", parentNode) : null);
            model.set("storagetype", this.getNodeProperty("storagetype", focusNode));
            model.set("aggoprt", this.getNodeProperty("aggoprt", focusNode));
            Object nodeProperty = this.getNodeProperty("currency.id", focusNode);
            String currencyId = nodeProperty == null ? "0" : nodeProperty.toString();
            model.set("currency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(currencyId), (String)"bd_currency", (String)"id"));
            model.set("isinnerorg", this.getNodeProperty("isinnerorg", focusNode));
            model.set("isouterorg", this.getNodeProperty("isouterorg", focusNode));
            Object belSchemNode = this.getNodeProperty("belongscheme.id", focusNode);
            String belSchemeId = belSchemNode == null ? "0" : belSchemNode.toString();
            model.set("belongscheme", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(belSchemeId), (String)"bcm_cslscheme", (String)"id"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "aggoprt", "ctrlorg", "currency", "isindependentorg", "isinnerorg", "isouterorg", "belongscheme"});
            this.getView().updateView("vieworg");
        }
    }

    private void handleTreeNodeDragged(TreeNodeDragEvent evt) {
        if ("1".equals(this.getPageCache().get("isenable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u89c6\u56fe\u5904\u4e8e\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u62d6\u52a8\u3002", (String)"CslSchemeEditPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode == null) {
            return;
        }
        String fromParentId = evt.getFromParentId().toString();
        String nodeId = evt.getNodeId().toString();
        String toParentId = evt.getToParentId().toString();
        if (rootNode.getId().equals(nodeId) || fromParentId.equals(toParentId) || nodeId.equals(toParentId)) {
            return;
        }
        TreeNode fromParentNode = rootNode.getTreeNode(fromParentId, 20);
        TreeNode toParentNode = rootNode.getTreeNode(toParentId, 20);
        if (toParentNode == null) {
            return;
        }
        if (fromParentNode != null && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)fromParentNode.getData()).get("storagetype")) || toParentNode != null && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)toParentNode.getData()).get("storagetype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u62d6\u52a8\u7684\u201c\u539f\u4f4d\u7f6e\u7236\u7ea7\u201d\u6216\u201c\u76ee\u6807\u4f4d\u7f6e\u7236\u7ea7\u201d\u4e3a\u5171\u4eab\u65f6\u4e0d\u80fd\u62d6\u52a8\u3002", (String)"CslSchemeEditPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode focusNode = rootNode.getTreeNode(nodeId, 20);
        if (!this.isShareNonLeafOrg(toParentNode) && !this.isFictitiousOrg(toParentNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u62d6\u52a8\u81f3\u660e\u7ec6\u7684\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"CslSchemeEditPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List path = rootNode.getChildPath(toParentId);
        if (path.contains(nodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u62d6\u52a8\u81f3\u4e0b\u7ea7\u5b50\u5b59\u7ec4\u7ec7\u3002", (String)"CslSchemeEditPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>();
        ArrayList<String> sourceIds = new ArrayList<String>();
        String text = focusNode.getText();
        this.collectChildren(focusNode, actNodes, sourceIds);
        TreeView tree = (TreeView)this.getControl(orgtree);
        TreeNode oldParentNode = rootNode.deleteChildNode(nodeId);
        tree.deleteNode(nodeId);
        if (oldParentNode.getChildren() == null || oldParentNode.getChildren().size() == 0) {
            oldParentNode.setChildren(null);
            this.setNodeProperty("isEdit", "1", oldParentNode);
            if (!this.isAuditStoragetOrg(oldParentNode)) {
                this.setNodeProperty("isleaf", true, oldParentNode);
            }
        }
        Set<String> cacheNodeNumbers = this.getNodeNumbers();
        this.removeCache(cacheNodeNumbers, focusNode);
        this.wholeOne(rootNode, toParentNode, cacheNodeNumbers, actNodes, sourceIds);
        tree.updateNode(rootNode);
        List childPathNodes1 = rootNode.getChildPathNodes(toParentId);
        childPathNodes1.forEach(node -> node.setIsOpened(true));
        List childPathNodes2 = rootNode.getChildPathNodes(fromParentId);
        childPathNodes2.forEach(node -> node.setIsOpened(true));
        this.cacheTreeRoot(rootNode);
        focusNode = rootNode.getTreeNodeByText(text, 20);
        tree.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        tree.focusNode(focusNode);
    }

    private void collectChildren(TreeNode focusNode, List<TreeNode> actNodes, List<String> sourceIds) {
        actNodes.add(focusNode);
        sourceIds.add(focusNode.getId());
        List children = focusNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.collectChildren(child, actNodes, sourceIds);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String cslschemeId = (String)this.getFormCustomParam("cslschemeId");
        DynamicObject cslscheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"isenable,model", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(cslschemeId))});
        if (cslscheme.getBoolean("isenable")) {
            this.getPageCache().put("isenable", "1");
            this.setBarEnable(false);
        } else {
            this.getPageCache().put("isenable", "0");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_enable"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disable"});
        }
        this.getPageCache().put("model_id", cslscheme.getString("model"));
        this.initTreeByCslschemeId(cslschemeId);
    }

    private void initTreeByCslschemeId(String cslschemeId) {
        if (cslschemeId == null) {
            return;
        }
        Long modelId = this.getModelId();
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("cslscheme", "=", (Object)Long.valueOf(cslschemeId));
        qf.add("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selector, (QFilter[])qf.toArray(), (String)"level, dseq");
        TreeNode rootNode = this.initTreeByOrgs(orgs, true);
        if (rootNode == null) {
            return;
        }
        String focusNodeId = this.getPageCache().get("focusNodeId");
        if (focusNodeId != null) {
            List childPathNodes = rootNode.getChildPathNodes(focusNodeId);
            childPathNodes.forEach(node -> node.setIsOpened(true));
            TreeView tree = (TreeView)this.getControl(orgtree);
            TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
            if (focusNode != null) {
                tree.focusNode(focusNode);
            }
        } else if (rootNode != null) {
            TreeView tree = (TreeView)this.getControl(orgtree);
            tree.addTreeNodeClickListener((TreeNodeClickListener)this);
            tree.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            tree.focusNode(rootNode);
        }
        if (Boolean.parseBoolean(this.getFormCustomParam("islegalorgview").toString()) && QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)ConvertUtil.convertStrToLong((String)cslschemeId)).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_import", "bar_remove", "bar_addfictitiousorg", "bar_moveup", "bar_movedown", "bar_enable", "bar_disable", "vieworg"});
        }
        if (PermClassEntityHelper.isHasReadPerm((String)"bcm_cslscheme", (Long)this.getModelId(), (Long)LongUtil.toLong((Object)cslschemeId))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save", "bar_import", "bar_remove", "bar_addfictitiousorg", "bar_moveup", "bar_movedown", "bar_enable", "bar_disable", "vieworg"});
        }
    }

    private TreeNode initTreeByOrgs(DynamicObjectCollection orgs, boolean hasSuffix) {
        boolean notHaveOrg = orgs.isEmpty();
        this.setVisible(notHaveOrg);
        TreeView treeView = (TreeView)this.getControl(orgtree);
        treeView.deleteAllNodes();
        if (notHaveOrg) {
            this.getPageCache().remove(cache_tree);
            this.getPageCache().remove(cache_nodeNumbers);
            return null;
        }
        DynamicObject rootDy = (DynamicObject)orgs.get(0);
        String rootText = rootDy.getString("number") + " " + rootDy.getString("name");
        TreeNode rootNode = new TreeNode(AddNewCslSchemeType, rootDy.getString("id"), rootText, (Object)rootDy);
        if (hasSuffix && StorageTypeEnum.SHARE.getOIndex().equals(rootDy.getString("storagetype"))) {
            rootNode.setText(this.getShareText(rootNode.getText()));
        }
        HashSet<String> nodeNumbers = new HashSet<String>();
        nodeNumbers.add(rootDy.getString("number"));
        this.expandNextLevel(rootNode, orgs, nodeNumbers, hasSuffix);
        this.cacheTreeRoot(rootNode);
        this.cacheNodeNumbers(nodeNumbers);
        treeView.addNode(rootNode);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private void setVisible(boolean notHaveOrg) {
        this.getView().setVisible(Boolean.valueOf(!notHaveOrg), new String[]{"existorg"});
        this.getView().setVisible(Boolean.valueOf(notHaveOrg), new String[]{"quickimport"});
        SplitContainer splitOrgn = (SplitContainer)this.getView().getControl("splitcontainerap");
        splitOrgn.hidePanel(SplitDirection.right, notHaveOrg);
        this.getView().setEnable(Boolean.valueOf(!notHaveOrg), new String[]{"bar_addfictitiousorg"});
        this.getView().setEnable(Boolean.valueOf(!notHaveOrg), new String[]{"addnewlevel"});
    }

    private void expandNextLevel(TreeNode parentNode, DynamicObjectCollection orgs, Set<String> nodeNumbers, boolean hasSuffix) {
        HashMap<Long, List<TreeNode>> result = new HashMap<Long, List<TreeNode>>(5);
        if (orgs != null && orgs.size() > 0) {
            HashMap<String, Object> forCompareCurrentTree = new HashMap<String, Object>();
            forCompareCurrentTree.put(((DynamicObject)orgs.get(0)).getString("longnumber"), orgs.get(0));
            HashMap<String, Object> oldLongNumber2Dy = new HashMap<String, Object>();
            oldLongNumber2Dy.put(((DynamicObject)orgs.get(0)).getString("longnumber"), orgs.get(0));
            for (int i = 1; i < orgs.size(); ++i) {
                long parentId;
                ArrayList<TreeNode> children;
                DynamicObject org = (DynamicObject)orgs.get(i);
                String longNumber = org.getString("longnumber");
                if (hasSuffix) {
                    oldLongNumber2Dy.put(longNumber, org);
                    if (!OrgStoreStatusEnum.REMOVE.getValue().equals(org.getString("status"))) {
                        forCompareCurrentTree.put(longNumber, org);
                    }
                }
                if (OrgStoreStatusEnum.REMOVE.getValue().equals(org.getString("status"))) continue;
                String text = org.getString("number") + " " + org.getString("name");
                if (hasSuffix && StorageTypeEnum.SHARE.getOIndex().equals(org.getString("storagetype"))) {
                    text = this.getShareText(text);
                }
                if ((children = (ArrayList<TreeNode>)result.get(parentId = org.getLong("parent.id"))) == null) {
                    children = new ArrayList<TreeNode>();
                    result.put(parentId, children);
                }
                TreeNode node = new TreeNode();
                node.setText(text);
                node.setId(org.getString("id"));
                node.setData((Object)org);
                children.add(node);
                nodeNumbers.add(org.getString("number"));
            }
            if (hasSuffix) {
                this.getPageCache().put("oldLongNumber2Dy", SerializationUtils.toJsonString(oldLongNumber2Dy));
                this.getPageCache().put("forCompareCurrentTree", SerializationUtils.toJsonString(forCompareCurrentTree));
            }
        }
        this.assember(parentNode, result);
    }

    private void assember(TreeNode parentNode, Map<Long, List<TreeNode>> result) {
        Long rootid = Long.valueOf(parentNode.getId());
        List<TreeNode> realChildren = result.get(rootid);
        if (realChildren != null && realChildren.size() > 0) {
            for (TreeNode child : realChildren) {
                parentNode.addChild(child);
                child.setParentid(parentNode.getId());
                this.assember(child, result);
            }
        } else {
            DynamicObject data = (DynamicObject)parentNode.getData();
            if (StorageTypeEnum.STORAGE.getOIndex().equals(data.getString("storagetype"))) {
                parentNode.setColor("green");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Date enableDate;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("callback_addfictitiousorg")) {
            HashSet<String> nodeNumbers;
            TreeNode rootNode;
            TreeNode returnData = (TreeNode)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            this.setBaseInfo(false, returnData, returnData);
            String parentId = returnData.getParentid();
            TreeView tree = (TreeView)this.getControl(orgtree);
            if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                rootNode = this.getCacheRoot();
                if (rootNode != null) {
                    TreeNode focusNode = rootNode.getTreeNode(parentId, 20);
                    List children = focusNode.getChildren();
                    this.modifyTreeSeq(children);
                    this.setNodeProperty("dseq", !CollectionUtils.isEmpty((Collection)children) ? children.size() + 1 : 1, returnData);
                    focusNode.addChild(returnData);
                    tree.updateNode(focusNode);
                    tree.expand(focusNode.getId());
                }
                nodeNumbers = this.getNodeNumbers();
            } else {
                nodeNumbers = new HashSet();
                this.setNodeProperty("dseq", this.getRootNodeSeq(), returnData);
                rootNode = returnData;
                tree.addNode(rootNode);
                this.setVisible(false);
            }
            this.cacheTreeRoot(rootNode);
            this.addNodeCache(nodeNumbers, returnData);
            this.cacheNodeNumbers(nodeNumbers);
            tree.addTreeNodeClickListener((TreeNodeClickListener)this);
            tree.treeNodeClick(returnData.getParentid(), returnData.getId());
            tree.focusNode(returnData);
        } else if (actionId.equals("callback_import")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            TreeNode rootNode = this.getCacheRoot();
            if (rootNode != null) {
                this.handleHasTree(rootNode, returnData);
            } else {
                this.handleNotHasTree(returnData);
            }
        } else if ("callback_setEnableDate".equals(actionId) && (enableDate = (Date)closedCallBackEvent.getReturnData()) != null) {
            this.enableScheme(Long.valueOf((String)this.getFormCustomParam("cslschemeId")), enableDate);
        }
    }

    private void modifyTreeSeq(List<TreeNode> children) {
        if (children == null) {
            return;
        }
        int seq = 1;
        for (TreeNode child : children) {
            this.setNodeProperty("dseq", seq, child);
            ++seq;
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        this.checkPerm(key);
        super.itemClick(evt);
        if (key.equals("bar_baseinfo")) {
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u57fa\u672c\u4fe1\u606f", (String)"CslSchemeEditPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bcm_cslscheme");
            parameter.setPkId((Object)Long.valueOf((String)this.getFormCustomParam("cslschemeId")));
            parameter.setCustomParam("isScheme", (Object)true);
            parameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (key.equals("bar_save")) {
            this.handleSaveTree();
        } else if (key.equals("bar_import")) {
            this.importOrg();
        } else if (key.equals("bar_remove")) {
            this.handleRemoveNode();
        } else if (key.equals("bar_addfictitiousorg")) {
            this.getPageCache().put(AddNewCslSchemeType, "bar_addfictitiousorg");
            this.handleFictitiousOrg();
        } else if (key.equals("addnewlevel")) {
            this.getPageCache().put(AddNewCslSchemeType, "addnewlevel");
            this.handleFictitiousOrg();
        } else if (key.equals("bar_moveup") || key.equals("bar_movedown")) {
            this.moveNode(key);
        } else if (key.equals("bar_enable")) {
            if (!this.existData(Long.valueOf((String)this.getFormCustomParam("cslschemeId")))) {
                return;
            }
            DynamicObject cslscheme = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"isenable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)this.getFormCustomParam("cslschemeId")))});
            if (cslscheme.getBoolean("isenable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u89c6\u56fe\u5df2\u7ecf\u5728\u5217\u8868\u542f\u7528\u3002", (String)"CslSchemeEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isOrgTreeChange() || this.getView().getPageCache().get("treeStatus") != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5171\u4eab\u7684\u7ec4\u7ec7\u6210\u5458\u5c42\u7ea7\u5173\u7cfb\u53d1\u751f\u53d8\u52a8\uff0c\u4f1a\u5bf9\u5176\u7236\u7ea7\u5b58\u50a8\u7c7b\u578b\u7684\u6570\u636e\u4ea7\u751f\u5f71\u54cd\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u4fdd\u5b58\u5e76\u542f\u7528\uff1f", (String)"CslSchemeEditPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("setEnableWhetherSave"));
            } else {
                this.handleEnableScheme();
            }
        } else if (key.equals("bar_disable")) {
            Long cslSchemeId = Long.valueOf((String)this.getFormCustomParam("cslschemeId"));
            if (!this.existData(cslSchemeId)) {
                return;
            }
            CslSchemeUtils.updateCslSchemeStatus(cslSchemeId, false, this.getView(), ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CslSchemeEditPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            QFilter qf = new QFilter("id", "=", (Object)cslSchemeId);
            DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"name,number", (QFilter[])new QFilter[]{qf});
            String log = String.format("%s %s,%s%s", data.getString("number"), data.getString("name"), this.getOperationDisadle(), this.getOperationStatusSuccess());
            OperationLogUtil.writeOperationLog((String)this.getOperationDisadle(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
            this.setBarEnable(true);
            if (this.getCacheRoot() == null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_addfictitiousorg"});
            }
            this.getPageCache().put("isenable", "0");
        }
    }

    private void checkPerm(String opkey) {
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permitem.get(this.getView().getEntityId());
        if (map == null || map.get(opkey) == null) {
            return;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return;
        }
        int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), perm[0], perm[1]);
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"CslSchemeEditPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean existData(Long cslschemeId) {
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (Object)cslschemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u89c6\u56fe\u5df2\u7ecf\u5728\u5217\u8868\u5220\u9664\u3002", (String)"CslSchemeEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setBarEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"bar_save", "bar_import", "bar_remove", "bar_addfictitiousorg", "bar_moveup", "bar_movedown", "vieworg"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"bar_enable"});
        this.getView().setVisible(Boolean.valueOf(!isEnable), new String[]{"bar_disable"});
    }

    private void importOrg() {
        TreeNode focusNode;
        TreeNode rootNode = this.getCacheRoot();
        String focusNodeId = null;
        if (rootNode != null) {
            focusNode = this.getFocusNode(rootNode);
            if (focusNode == null) {
                return;
            }
            if (focusNode != null && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)focusNode.getData()).get("storagetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u4e3a\u5171\u4eab\u6210\u5458\uff0c\u4e0d\u80fd\u9009\u5165\u3002", (String)"CslSchemeEditPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u5408\u5e76\u8282\u70b9\u540e\u518d\u6267\u884c\u9009\u5165\u64cd\u4f5c", (String)"CslSchemeEditPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        focusNodeId = focusNode.getId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_cslschemeimport");
        parameter.setCustomParam("focusNodeId", (Object)focusNodeId);
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("existNumbers", (Object)this.getPageCache().get(cache_nodeNumbers));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_import");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void moveNode(String moveType) {
        TreeView tree = (TreeView)this.getControl(orgtree);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u7ec4\u7ec7\u3002", (String)"CslSchemeEditPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode == null) {
            return;
        }
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
        if (focusNode == null) {
            return;
        }
        TreeNode parentNode = rootNode.getTreeNode(focusNode.getParentid(), 20);
        if (parentNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u4e0d\u80fd\u79fb\u52a8\u3002", (String)"CslSchemeEditPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List children = parentNode.getChildren();
        if ("bar_moveup".equals(moveType) && focusNodeId.equals(((TreeNode)children.get(0)).getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u5904\u4e8e\u9996\u4f4d\u3002", (String)"CslSchemeEditPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("bar_movedown".equals(moveType) && focusNodeId.equals(((TreeNode)children.get(children.size() - 1)).getId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u5904\u4e8e\u672b\u4f4d\u3002", (String)"CslSchemeEditPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode targetNode = null;
        int focusNodeIndex = 0;
        int targetNodeIndex = 0;
        for (int i = 0; i < children.size(); ++i) {
            TreeNode treeNode = (TreeNode)children.get(i);
            if (!focusNodeId.equals(treeNode.getId())) continue;
            focusNodeIndex = i;
            if ("bar_moveup".equals(moveType)) {
                targetNode = (TreeNode)children.get(i - 1);
                targetNodeIndex = i - 1;
                break;
            }
            targetNode = (TreeNode)children.get(i + 1);
            targetNodeIndex = i + 1;
            break;
        }
        this.setNodeProperty("isEdit", "1", focusNode);
        this.setNodeProperty("isEdit", "1", targetNode);
        children.set(targetNodeIndex, focusNode);
        children.set(focusNodeIndex, targetNode);
        focusNodeIndex = (Integer)this.getNodeProperty("dseq", focusNode);
        if (targetNode != null) {
            targetNodeIndex = (Integer)this.getNodeProperty("dseq", targetNode);
        }
        this.setNodeProperty("dseq", targetNodeIndex, focusNode);
        this.setNodeProperty("dseq", focusNodeIndex, targetNode);
        this.cacheTreeRoot(rootNode);
        tree.updateNode(parentNode);
        parentNode.setIsOpened(true);
        tree.focusNode(focusNode);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(orgtree), btns, cache_tree);
        } else if ("btn_quickimport".equals(key)) {
            String cslschemeId = (String)this.getFormCustomParam("cslschemeId");
            DynamicObject cslscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(cslschemeId), (String)"bcm_cslscheme", (String)"isenable,model");
            if (cslscheme.getBoolean("isenable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7981\u7528\u8be5\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CslSchemeEditPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.handleFictitiousOrg();
        }
    }

    private void handleEnableScheme() {
        Long cslschemeId = Long.valueOf((String)this.getFormCustomParam("cslschemeId"));
        if (!QueryServiceHelper.exists((String)"bcm_cslscheme", (Object)cslschemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u89c6\u56fe\u5df2\u7ecf\u5728\u5217\u8868\u5220\u9664\u3002", (String)"CslSchemeEditPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"CslSchemeEditPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_cslschemesetdate");
        if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)cslschemeId).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray())) {
            parameter.setCustomParam("text", (Object)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u53d8\u66f4\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"CslSchemeEditPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_setEnableDate");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void enableScheme(Long cslschemeId, Date enableDate) {
        QFilter qf = new QFilter("id", "=", (Object)cslschemeId);
        DynamicObject data = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"name,number", (QFilter[])new QFilter[]{qf});
        String result = CslSchemeUtils.handleEnable(cslschemeId, this.getClass().getName(), enableDate);
        if (result != null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u5931\u8d25\u8be6\u60c5\u3002", (String)"CslSchemeEditPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]), result, MessageTypes.Default);
            String log = String.format("%s %s,%s%s", data.getString("number"), data.getString("name"), this.getOperationAdle(), this.getOperationStatusFail());
            OperationLogUtil.writeOperationLog((String)this.getOperationAdle(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
        } else {
            CslSchemeUtils.updateCslSchemeStatus(cslschemeId, true, this.getView(), ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CslSchemeEditPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            String log = String.format("%s %s,%s%s", data.getString("number"), data.getString("name"), this.getOperationAdle(), this.getOperationStatusSuccess());
            OperationLogUtil.writeOperationLog((String)this.getOperationAdle(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
            this.setBarEnable(false);
            this.getPageCache().put("isenable", "1");
            this.initTreeByCslschemeId((String)this.getFormCustomParam("cslschemeId"));
        }
    }

    private void handleHasTree(TreeNode rootNode, Map<String, Object> returnData) {
        String focusNodeId = this.getPageCache().get("focusNodeId");
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
        TreeView tree = (TreeView)this.getControl(orgtree);
        Set<String> cache = this.getNodeNumbers();
        String from = (String)returnData.get("importFrom");
        List actNodes = (List)this.deSerializedBytes(returnData.get("actNodes").toString());
        if (from.equals("fromscheme")) {
            List<String> sourceIds = actNodes.stream().map(a -> a.getId()).collect(Collectors.toList());
            this.wholeOne(rootNode, focusNode, cache, actNodes, sourceIds);
        } else {
            actNodes.forEach(o -> {
                focusNode.addChild(o);
                this.addNodeCache(cache, (TreeNode)o);
            });
            tree.updateNode(focusNode);
            tree.expand(focusNode.getId());
        }
        this.cacheTreeRoot(rootNode);
        this.cacheNodeNumbers(cache);
        tree.focusNode(focusNode);
        boolean hasSkip = (Boolean)returnData.get("hasSkip");
        if (hasSkip) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8df3\u8fc7\u7ec4\u7ec7\u89c6\u56fe\u4e2d\u5b58\u5728\u7684\u6210\u5458\u3002", (String)"CslSchemeEditPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleNotHasTree(Map<String, Object> returnData) {
        List checkedNodeIds = (List)this.deSerializedBytes(returnData.get("actNodes").toString());
        DynamicObjectCollection orgs = this.getOrgInfoByIds(checkedNodeIds);
        this.initTreeByOrgs(orgs, false);
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode != null) {
            this.setBaseInfo(true, rootNode, rootNode);
            String parentId = String.valueOf(GlobalIdUtil.genGlobalLongId());
            rootNode.setId(parentId);
            HashSet<String> nodeNumbers = new HashSet<String>();
            this.addNodeCache(nodeNumbers, rootNode);
            List children = rootNode.getChildren();
            this.resetData(parentId, children, nodeNumbers);
            this.cacheTreeRoot(rootNode);
            this.cacheNodeNumbers(nodeNumbers);
            TreeView treeView = (TreeView)this.getControl(orgtree);
            treeView.deleteAllNodes();
            treeView.addNode(rootNode);
            rootNode.setIsOpened(true);
        }
    }

    private void handleRemoveNode() {
        TreeNode focusNode;
        TreeView tree = (TreeView)this.getView().getControl(orgtree);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        TreeNode rootNode = this.getCacheRoot();
        if (StringUtils.isEmpty((CharSequence)focusNodeId) || rootNode == null || (focusNode = rootNode.getTreeNode(focusNodeId, 20)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"CslSchemeEditPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode treeNode = rootNode.getTreeNode(focusNode.getParentid(), 20);
        if (treeNode != null && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)treeNode.getData()).get("storagetype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u7ea7\u4e3a\u5171\u4eab\u65f6\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"CslSchemeEditPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (focusNodeId.equals(rootNode.getId())) {
            if (this.isNewNode(rootNode) || OrgStoreStatusEnum.TEMPSAVE.getValue().equals(this.getNodeProperty("status", rootNode))) {
                tree.deleteAllNodes();
                this.getPageCache().remove(cache_tree);
                this.getPageCache().remove(cache_nodeNumbers);
                this.setVisible(true);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u79fb\u9664\u6839\u8282\u70b9\u3002", (String)"CslSchemeEditPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<String> nodeNumbers = this.getNodeNumbers();
        TreeNode parentNode = rootNode.deleteChildNode(focusNodeId);
        this.removeCache(nodeNumbers, focusNode);
        tree.deleteNode(focusNodeId);
        if (parentNode.getChildren() == null || parentNode.getChildren().size() == 0) {
            parentNode.setChildren(null);
            this.setNodeProperty("isEdit", "1", parentNode);
            if (!this.isAuditStoragetOrg(parentNode)) {
                this.setNodeProperty("isleaf", true, parentNode);
            }
        }
        tree.updateNode(parentNode);
        tree.expand(parentNode.getId());
        this.cacheTreeRoot(rootNode);
        this.cacheNodeNumbers(nodeNumbers);
    }

    private void handleFictitiousOrg() {
        TreeNode rootNode = this.getCacheRoot();
        TreeNode focusNode = null;
        String focusNodeId = null;
        String selectNodeName = null;
        if (rootNode != null) {
            focusNode = this.getFocusNode(rootNode);
            TreeNode treeNode = null;
            if ("addnewlevel".equals(this.getPageCache().get(AddNewCslSchemeType))) {
                if (focusNode != null && focusNode != rootNode) {
                    treeNode = rootNode.getTreeNode(focusNode.getParentid(), 20);
                    if (treeNode != null && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)treeNode.getData()).get("storagetype"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u7ea7\u4e3a\u5171\u4eab\u65f6\u4e0d\u5141\u8bb8\u65b0\u589e\u5e73\u7ea7\u3002", (String)"CslSchemeEditPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (treeNode != null && treeNode != focusNode) {
                        focusNode = treeNode;
                    }
                } else if (focusNode != null && focusNode == rootNode) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u5e73\u7ea7\u3002", (String)"CslSchemeEditPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else if (focusNode != null && "bar_addfictitiousorg".equals(this.getPageCache().get(AddNewCslSchemeType)) && StorageTypeEnum.SHARE.getOIndex().equals(((LinkedHashMap)focusNode.getData()).get("storagetype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\u3002", (String)"CslSchemeEditPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (focusNode == null) {
                return;
            }
            focusNodeId = focusNode.getId();
            selectNodeName = (String)this.getNodeProperty("name", focusNode);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u57fa\u672c\u4fe1\u606f", (String)"CslSchemeEditPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_cslschemeaddorg");
        parameter.setCustomParam("focusNodeId", (Object)focusNodeId);
        parameter.setCustomParam("selectNodeName", (Object)selectNodeName);
        parameter.setCustomParam("existNumbers", (Object)this.getPageCache().get(cache_nodeNumbers));
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_addfictitiousorg");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void handleSaveTree() {
        this.cslSchemeId = Long.valueOf((String)this.getFormCustomParam("cslschemeId"));
        if (!this.existData(this.cslSchemeId)) {
            return;
        }
        DynamicObject cslscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this.cslSchemeId, (String)"bcm_cslscheme", (String)"isenable,number");
        if (cslscheme.getBoolean("isenable")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u89c6\u56fe\u5df2\u7ecf\u5728\u5217\u8868\u542f\u7528\u3002", (String)"CslSchemeEditPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isChanged = this.isOrgTreeChange();
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode == null) {
            DeleteServiceHelper.delete((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)this.cslSchemeId).toArray());
            this.getPageCache().remove("oldLongNumber2Dy");
            this.getPageCache().remove("forCompareCurrentTree");
            OpNameMultiLangEnumBridge opNameBridge = new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "CslSchemeEditPlugin_0", "fi-bcm-formplugin", "save");
            super.writeOperationLog(opNameBridge, new OPDescMultiLangEnumBridge("%1$s %2$s,%3$s\u6210\u529f\u3002", "CslSchemeEditPlugin_38", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{cslscheme.getString("number"), this.getModel().getValue("name").toString(), opNameBridge.getDescription()})));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CslSchemeEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.numberIsExsit()) {
            String number = AddNewCslSchemeType + this.getModel().getValue("number");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7ec4\u7ec7\u3002", (String)"CslSchemeEditPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number));
            return;
        }
        ArrayList<Long> copyFromIds = new ArrayList<Long>();
        ArrayList<TreeNode> updateNode = new ArrayList<TreeNode>();
        HashMap<String, String> nonLeaf2Copyfrom = new HashMap<String, String>();
        this.assembleSaveInfo(rootNode, copyFromIds, updateNode, nonLeaf2Copyfrom);
        rootNode.setParentid(CslSchemeServiceHelper.getEntityOrgId((long)this.getModelId()).getString("id"));
        MainEntityType orgEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_entitymembertree");
        DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])copyFromIds.toArray(), (DynamicObjectType)orgEntityType);
        HashMap<String, DynamicObject> orgId2DyMap = new HashMap<String, DynamicObject>(orgs.length);
        for (DynamicObject dy : orgs) {
            orgId2DyMap.put(dy.getString("id"), dy);
        }
        HashSet<String> newOrgStructure = new HashSet<String>();
        ArrayList<DynamicObject> toSaveOrgs = new ArrayList<DynamicObject>();
        HashMap<Long, TreeNode> toUpdateOrgs = new HashMap<Long, TreeNode>();
        this.modelId = this.getModelId();
        this.dimensionId = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id", (QFilter[])new QFBuilder("model", "=", (Object)this.modelId).add("number", "=", (Object)"Entity").toArray()).getLong("id");
        this.beginDate = EntityVersioningUtil.getModelBeginDate((Object)this.modelId);
        this.assembleNode(rootNode, null, 0, orgId2DyMap, newOrgStructure, toSaveOrgs, toUpdateOrgs);
        HashSet<Long> realDel = new HashSet<Long>();
        ArrayList<LinkedHashMap<String, Object>> updateInvalid = new ArrayList<LinkedHashMap<String, Object>>();
        this.handleOrgTreeChanged(newOrgStructure, toSaveOrgs, realDel, updateInvalid);
        try (TXHandle tx = TX.required();){
            try {
                if (!toSaveOrgs.isEmpty()) {
                    SaveServiceHelper.save((IDataEntityType)orgEntityType, (Object[])toSaveOrgs.toArray(new DynamicObject[0]));
                }
                if (!realDel.isEmpty()) {
                    DeleteServiceHelper.delete((IDataEntityType)orgEntityType, (Object[])realDel.toArray());
                }
                if (!updateInvalid.isEmpty()) {
                    ArrayList toInvalid = new ArrayList();
                    ArrayList toSetLeaf = new ArrayList();
                    updateInvalid.forEach(org -> {
                        String orgId = org.get("id").toString();
                        toInvalid.add(orgId);
                        if (!Boolean.parseBoolean(org.get("isleaf").toString()) && !QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("parent", "=", (Object)ConvertUtil.convertStrToLong((String)orgId)).add("status", "=", (Object)"C").or("status", "=", (Object)"D").or("status", "=", (Object)"E").toArray())) {
                            toSetLeaf.add(orgId);
                        }
                    });
                    DB.execute((DBRoute)new DBRoute("bcm"), (String)("update t_bcm_structofent set fstatus='D' where fid in (" + String.join((CharSequence)",", toInvalid) + ")"));
                    if (!toSetLeaf.isEmpty()) {
                        DB.execute((DBRoute)new DBRoute("bcm"), (String)("update t_bcm_structofent set fisleaf='1' where fid in (" + String.join((CharSequence)",", toSetLeaf) + ")"));
                    }
                }
                if (!toUpdateOrgs.isEmpty()) {
                    this.handleUpdateOrg((DynamicObjectType)orgEntityType, toUpdateOrgs);
                }
                this.initTreeByCslschemeId(this.cslSchemeId.toString());
                DimMemberSortUtil.upadteDimChangeTime((Long)this.modelId, (Long)this.cslSchemeId, (Long)this.dimensionId, (String)"changetime");
                if (this.getPageCache().get("isClosePageConfirm") == null) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CslSchemeEditPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    OpNameMultiLangEnumBridge opNameBridge = new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "CslSchemeEditPlugin_0", "fi-bcm-formplugin", "save");
                    super.writeOperationLog(opNameBridge, new OPDescMultiLangEnumBridge("%1$s %2$s,%3$s\u6210\u529f\u3002", "CslSchemeEditPlugin_38", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{cslscheme.getString("number"), this.getModel().getValue("name").toString(), opNameBridge.getDescription()})));
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                OpNameMultiLangEnumBridge opNameBridge = new OpNameMultiLangEnumBridge("\u4fdd\u5b58", "CslSchemeEditPlugin_0", "fi-bcm-formplugin", "save");
                super.writeOperationLog(opNameBridge, new OPDescMultiLangEnumBridge("%1$s %2$s,%3$s\u5931\u8d25\u3002", "CslSchemeEditPlugin_39", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{cslscheme.getString("number"), this.getModel().getValue("name").toString(), opNameBridge.getDescription()})));
                throw e;
            }
        }
        this.cacheTreeStatus(isChanged);
    }

    private void cacheTreeStatus(boolean isChanged) {
        if (isChanged) {
            this.getView().getPageCache().put("treeStatus", "change");
        }
    }

    private boolean numberIsExsit() {
        boolean flag = false;
        IDataModel model = this.getModel();
        String modelid = this.getPageCache().get("model_id");
        String number = AddNewCslSchemeType + model.getValue("number");
        String isinnerorg = AddNewCslSchemeType + model.getValue("isinnerorg");
        String isouterorg = AddNewCslSchemeType + model.getValue("isouterorg");
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter modelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
        QFilter orgFilter = new QFilter("isinnerorg", "=", (Object)"1").or("entitypart.isouterorg", "=", (Object)"1");
        boolean exsit = QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFilter[]{numberFilter, orgFilter, modelFilter});
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("number", "=", (Object)number));
        qFilters.add(new QFilter("model", "=", (Object)ConvertUtil.convertStrToLong((String)modelid)));
        if ((Boolean.parseBoolean(isinnerorg) || Boolean.parseBoolean(isouterorg)) && !exsit) {
            flag = QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])qFilters.toArray(new QFilter[0]));
        }
        return flag;
    }

    private void handleUpdateOrg(DynamicObjectType orgEntityType, Map<Long, TreeNode> toUpdateOrgs) {
        if (toUpdateOrgs.isEmpty()) {
            return;
        }
        DynamicObject[] orgs = BusinessDataServiceHelper.load((Object[])toUpdateOrgs.keySet().toArray(), (DynamicObjectType)orgEntityType);
        for (int i = 0; i < orgs.length; ++i) {
            DynamicObject org = orgs[i];
            TreeNode node = toUpdateOrgs.get(org.getLong("id"));
            Map data = (Map)node.getData();
            org.set("name", data.get("name"));
            org.set("aggoprt", data.get("aggoprt"));
            org.set("currency", data.get("currency.id"));
            org.set("isinnerorg", data.get("isinnerorg"));
            org.set("isouterorg", data.get("isouterorg"));
            org.set("isleaf", data.get("isleaf"));
            org.set("dseq", data.get("dseq"));
        }
        SaveServiceHelper.save((DynamicObject[])orgs);
    }

    private void handleOrgTreeChanged(Set<String> newOrgStructure, List<DynamicObject> toSaveOrgs, Set<Long> realDel, List<LinkedHashMap<String, Object>> updateInvalid) {
        String oldCache = this.getPageCache().get("oldLongNumber2Dy");
        if (oldCache == null) {
            return;
        }
        Map oldLongNumber2Dy = (Map)SerializationUtils.fromJsonString((String)oldCache, Map.class);
        HashSet delSet = new HashSet();
        oldLongNumber2Dy.keySet().forEach(oldValue -> {
            if (!newOrgStructure.contains(oldValue)) {
                delSet.add(oldValue);
            }
        });
        delSet.forEach(d -> {
            LinkedHashMap dy = (LinkedHashMap)oldLongNumber2Dy.get(d);
            String status = dy.get("status").toString();
            if (OrgStoreStatusEnum.TEMPSAVE.getValue().equals(status)) {
                realDel.add(Long.valueOf(dy.get("id").toString()));
            } else if (OrgStoreStatusEnum.AUDIT.getValue().equals(status)) {
                updateInvalid.add(dy);
            }
        });
        ArrayList restore = new ArrayList();
        toSaveOrgs.removeIf(org -> {
            LinkedHashMap oldDy = (LinkedHashMap)oldLongNumber2Dy.get(org.getString("longnumber"));
            if (oldDy != null) {
                DynamicObject old = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(oldDy.get("id").toString()), (String)"bcm_entitymembertree");
                String status = oldDy.get("status").toString();
                if (OrgStoreStatusEnum.REMOVE.getValue().equals(status)) {
                    old.set("status", (Object)OrgStoreStatusEnum.AUDIT.getValue());
                } else {
                    old.set("status", (Object)status);
                }
                old.set("name", org.get("name"));
                old.set("aggoprt", org.get("aggoprt"));
                old.set("currency", org.get("currency"));
                old.set("isinnerorg", org.get("isinnerorg"));
                old.set("isouterorg", org.get("isouterorg"));
                old.set("dseq", org.get("dseq"));
                restore.add(old);
                return true;
            }
            return false;
        });
        toSaveOrgs.addAll(restore);
    }

    private void assembleSaveInfo(TreeNode rootNode, List<Long> copyFromIds, List<TreeNode> updateNode, Map<String, String> nonLeaf2Copyfrom) {
        List children;
        String copyfromId;
        Object data = this.getNodeProperty("sourceId", rootNode);
        String string = copyfromId = data != null ? data.toString() : this.getNodeProperty("copyfrom", rootNode).toString();
        if (!this.isFictitiousOrg(rootNode) && this.isNewNode(rootNode)) {
            copyFromIds.add(Long.valueOf(copyfromId));
        }
        if (this.isEditNode(rootNode)) {
            updateNode.add(rootNode);
        }
        if ((children = rootNode.getChildren()) != null && children.size() > 0) {
            if (StorageTypeEnum.SHARE.getOIndex().equals(this.getNodeProperty("storagetype", rootNode))) {
                nonLeaf2Copyfrom.put(rootNode.getId(), copyfromId);
            }
            for (TreeNode node : children) {
                this.assembleSaveInfo(node, copyFromIds, updateNode, nonLeaf2Copyfrom);
            }
        }
    }

    public void assembleNode(TreeNode node, TreeNode parentNode, int seq, Map<String, DynamicObject> orgId2DyMap, Set<String> newOrgStructure, List<DynamicObject> toSaveOrgs, Map<Long, TreeNode> toUpdateOrgs) {
        if (this.isNewNode(node)) {
            this.assembleMemObj(node, parentNode, seq + 1, orgId2DyMap, toSaveOrgs);
        } else if (this.isEditNode(node)) {
            toUpdateOrgs.put(Long.valueOf(node.getId()), node);
        }
        newOrgStructure.add((String)this.getNodeProperty("longnumber", node));
        List childs = node.getChildren();
        if (childs != null && childs.size() > 0) {
            for (int i = 0; i < childs.size(); ++i) {
                int lastSeq = this.getLastSeq(childs, i);
                TreeNode treeNode = (TreeNode)childs.get(i);
                this.assembleNode(treeNode, node, lastSeq, orgId2DyMap, newOrgStructure, toSaveOrgs, toUpdateOrgs);
                newOrgStructure.add((String)this.getNodeProperty("longnumber", treeNode));
            }
            this.resetParentIsleaf(node);
        }
    }

    private int getLastSeq(List<TreeNode> childs, int i) {
        if (i == 0) {
            return 0;
        }
        Object seq = this.getNodeProperty("dseq", childs.get(i - 1));
        if (seq != null) {
            return Integer.parseInt(seq.toString());
        }
        return this.getLastSeq(childs, i - 1);
    }

    private void assembleMemObj(TreeNode node, TreeNode parentNode, int seq, Map<String, DynamicObject> orgId2DyMap, List<DynamicObject> toSaveOrgs) {
        List children = node.getChildren();
        boolean isFictitiousOrg = this.isFictitiousOrg(node);
        String storageType = (String)this.getNodeProperty("storagetype", node);
        boolean isShare = storageType.equals(StorageTypeEnum.SHARE.getOIndex());
        String copyfromId = this.getNodeProperty("copyfrom", node).toString();
        String number = (String)this.getNodeProperty("number", node);
        Object sourceId = this.getNodeProperty("sourceId", node);
        DynamicObject orgSource = sourceId != null ? orgId2DyMap.get(sourceId.toString()) : orgId2DyMap.get(copyfromId);
        DynamicObject orgNewData = isFictitiousOrg ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree") : (DynamicObject)OrmUtils.clone((IDataEntityBase)orgSource, (boolean)true, (boolean)true);
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)orgNewData);
        orgNewData.set("id", (Object)node.getId());
        DynamicObject copyfromDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
        copyfromDy.set("id", (Object)copyfromId);
        orgNewData.set("copyfrom", isShare ? copyfromDy : Integer.valueOf(0));
        orgNewData.set("storageType", (Object)storageType);
        orgNewData.set("number", (Object)number);
        orgNewData.set("shownumber", this.getNodeProperty("shownumber", node));
        orgNewData.set("issysmember", (Object)(isShare ? DimMemTypeEnum.SHAREMEM.getIndex() : DimMemTypeEnum.UNSYSMEM.getIndex()));
        orgNewData.set("isleaf", (Object)(children == null || children.isEmpty() ? 1 : 0));
        orgNewData.set("level", (Object)(parentNode != null ? (Integer)this.getNodeProperty("level", parentNode) + 1 : 2));
        orgNewData.set("longnumber", (Object)(parentNode != null ? this.getNodeProperty("longnumber", parentNode) + String.valueOf('!') + number : "Entity!" + number));
        orgNewData.set("dseq", (Object)(parentNode != null ? seq : this.getRootNodeSeq()));
        orgNewData.set("status", (Object)OrgStoreStatusEnum.TEMPSAVE.getValue());
        DynamicObject parentOrg = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
        parentOrg.set("id", (Object)(parentNode != null ? parentNode.getId() : node.getParentid()));
        orgNewData.set("parent", (Object)parentOrg);
        DynamicObject cslScheme = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
        cslScheme.set("id", (Object)this.cslSchemeId);
        orgNewData.set("cslscheme", (Object)cslScheme);
        orgNewData.set("entitypart", null);
        String name = (String)this.getNodeProperty("name", node);
        if (!isShare) {
            DynamicObjectCollection nameRecords = orgNewData.getDynamicObjectCollection("namechangerds");
            nameRecords.clear();
            DynamicObject nameRecord = new DynamicObject(nameRecords.getDynamicObjectType());
            nameRecord.set("namerds", (Object)name);
            nameRecord.set("simplenamerds", (Object)name);
            nameRecord.set("nameeffdate", (Object)this.beginDate);
            nameRecord.set("namemodifier", (Object)RequestContext.get().getUserId());
            nameRecord.set("namemodifytime", (Object)TimeServiceHelper.now());
            nameRecord.set("seq", (Object)1);
            nameRecords.add((Object)nameRecord);
        }
        if (isFictitiousOrg || !orgNewData.getBoolean("isleaf")) {
            orgNewData.set("name", (Object)name);
            orgNewData.set("aggoprt", this.getNodeProperty("aggoprt", node));
            Object nodeProperty = this.getNodeProperty("currency.id", node);
            if (nodeProperty != null) {
                orgNewData.set("currency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(nodeProperty.toString()), (String)"bd_currency", (String)"id"));
            }
            orgNewData.set("isinnerorg", this.getNodeProperty("isinnerorg", node));
            orgNewData.set("isouterorg", this.getNodeProperty("isouterorg", node));
            orgNewData.set("model", (Object)this.modelId);
            orgNewData.set("dimension", (Object)this.dimensionId);
        }
        Object data = node.getData();
        Map nodeData = (Map)data;
        nodeData.put("dseq", seq);
        nodeData.put("longnumber", orgNewData.getString("longnumber"));
        nodeData.put("level", orgNewData.getInt("level"));
        toSaveOrgs.add(orgNewData);
    }

    private int getRootNodeSeq() {
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"dseq", (QFilter[])new QFBuilder("model", "=", (Object)this.modelId).add("level", "=", (Object)2).toArray(), (String)"dseq desc");
        if (orgs != null && orgs.size() > 0) {
            return ((DynamicObject)orgs.get(0)).getInt("dseq") + 1;
        }
        return 1;
    }

    private void resetParentIsleaf(TreeNode parent) {
        if (!this.isNewNode(parent) && ((Boolean)this.getNodeProperty("isleaf", parent)).booleanValue()) {
            Object[] params = new Object[]{LongUtil.toLong((Object)parent.getId())};
            DB.execute((DBRoute)new DBRoute("bcm"), (String)"update t_bcm_structofent set fisleaf=0 where fid=?", (Object[])params);
            this.setNodeProperty("isleaf", Boolean.FALSE, parent);
        }
    }

    private void setBaseInfo(boolean isShare, TreeNode source, TreeNode copy) {
        Object data = copy.getData();
        Map nodeData = (Map)data;
        nodeData.put("isNew", "1");
        nodeData.put("isEdit", "0");
        String text = this.getNodeProperty("number", source) + " " + this.getNodeProperty("name", source);
        if (isShare || !this.isFictitiousOrg(source) || OrgStoreStatusEnum.AUDIT.getValue().equals(this.getNodeProperty("status", source))) {
            text = this.getShareText(text);
            nodeData.put("storagetype", StorageTypeEnum.SHARE.getOIndex());
            String copyfrom = this.getNodeProperty("copyfrom", source).toString();
            if ("0".equals(copyfrom)) {
                nodeData.put("copyfrom", source.getId());
            } else {
                nodeData.put("copyfrom", copyfrom);
            }
            copy.setColor("blue");
        } else {
            copy.setColor("green");
        }
        copy.setText(text);
    }

    private boolean isNewNode(TreeNode focusNode) {
        String isNew = (String)this.getNodeProperty("isNew", focusNode);
        return "1".equals(isNew);
    }

    private boolean isFictitiousOrg(TreeNode focusNode) {
        String isFictitiousOrg = (String)this.getNodeProperty("isFictitiousOrg", focusNode);
        String storageType = (String)this.getNodeProperty("storagetype", focusNode);
        return "1".equals(isFictitiousOrg) || StorageTypeEnum.STORAGE.getOIndex().equals(storageType);
    }

    private boolean isAuditStoragetOrg(TreeNode focusNode) {
        return OrgStoreStatusEnum.AUDIT.getValue().equals(this.getNodeProperty("status", focusNode));
    }

    private boolean isShareNonLeafOrg(TreeNode focusNode) {
        String copyfrom;
        QFilter qFilter;
        boolean isleaf;
        String storageType = (String)this.getNodeProperty("storagetype", focusNode);
        return StorageTypeEnum.SHARE.getOIndex().equals(storageType) && !(isleaf = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"isleaf", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.valueOf(copyfrom = this.getNodeProperty("copyfrom", focusNode).toString()))).toArray()).getBoolean("isleaf"));
    }

    private boolean isEditNode(TreeNode focusNode) {
        String isEdit = (String)this.getNodeProperty("isEdit", focusNode);
        return "1".equals(isEdit);
    }

    private void removeCache(final Set<String> nodeNumbers, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        nodeNumbers.remove(number);
        if (copy.getChildren() != null) {
            copy.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    CslSchemeEditPlugin.this.removeCache(nodeNumbers, t);
                }
            });
        }
    }

    private DynamicObjectCollection getOrgInfoByIds(List<String> checkedNodeIds) {
        QFBuilder qf = new QFBuilder("id", "in", (Object)ConvertUtil.convertObjsToLongArray(checkedNodeIds));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selector, (QFilter[])qf.toArray(), (String)"level, dseq");
        return orgs;
    }

    private void resetData(String parentId, List<TreeNode> children, Set<String> nodeNumbers) {
        if (children != null) {
            for (TreeNode node : children) {
                this.setBaseInfo(true, node, node);
                node.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
                node.setParentid(parentId);
                nodeNumbers.add((String)this.getNodeProperty("number", node));
                this.resetData(node.getId(), node.getChildren(), nodeNumbers);
            }
        }
    }

    private TreeNode getFocusNode(TreeNode rootNode) {
        TreeView tree = (TreeView)this.getControl(orgtree);
        String focusNodeId = tree.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u5e76\u8282\u70b9\u3002", (String)"CslSchemeEditPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
        if (focusNode == null || !this.isShareNonLeafOrg(focusNode) && !this.isFictitiousOrg(focusNode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u5e76\u8282\u70b9\u3002", (String)"CslSchemeEditPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return focusNode;
    }

    private void wholeOne(TreeNode rootNode, TreeNode focusNode, Set<String> nodeNumbers, List<TreeNode> actNodes, List<String> sourceIds) {
        TreeView tree = (TreeView)this.getView().getControl(orgtree);
        for (TreeNode actNode : actNodes) {
            TreeNode copy = this.cloneNode(actNode, focusNode, sourceIds);
            this.totalMerge(focusNode, nodeNumbers, copy, rootNode, sourceIds);
        }
        tree.updateNode(focusNode);
        tree.expand(focusNode.getId());
    }

    protected List<TreeNode> totalMerge(TreeNode focusNode, Set<String> nodeNumbers, TreeNode copy, TreeNode rootNode, List<String> sourceIds) {
        if (!this.isNodeExists(nodeNumbers, copy)) {
            this.slipTreeNode(nodeNumbers, copy, focusNode);
            focusNode.addChild(copy);
            this.addNodeCache(nodeNumbers, copy);
            ArrayList<TreeNode> copys = new ArrayList<TreeNode>();
            copys.add(copy);
            return copys;
        }
        TreeNode matchNode = this.isMatch(focusNode, copy);
        if (matchNode != null) {
            if (copy.getChildren() != null) {
                this.wholeOne(rootNode, matchNode, nodeNumbers, copy.getChildren(), sourceIds);
            }
            return null;
        }
        this.slipTreeNode(nodeNumbers, copy, focusNode);
        if (copy.getChildren() != null) {
            focusNode.addChildren(copy.getChildren());
            copy.getChildren().forEach(node -> node.setParentid(focusNode.getId()));
            copy.getChildren().forEach(node -> this.addNodeCache(nodeNumbers, (TreeNode)node));
            return copy.getChildren();
        }
        return null;
    }

    protected TreeNode isMatch(TreeNode focusNode, TreeNode copy) {
        if (focusNode.getChildren() != null) {
            for (TreeNode focusChild : focusNode.getChildren()) {
                if (!focusChild.getId().equals(copy.getId()) && !focusChild.getText().equals(copy.getText())) continue;
                return focusChild;
            }
        }
        return null;
    }

    private void addNodeCache(final Set<String> nodeNumbers, TreeNode node) {
        if (node == null) {
            return;
        }
        String number = (String)this.getNodeProperty("number", node);
        nodeNumbers.add(number);
        if (node.getChildren() != null) {
            node.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    CslSchemeEditPlugin.this.addNodeCache(nodeNumbers, t);
                }
            });
        }
    }

    protected void slipTreeNode(Set<String> nodeNumbers, TreeNode copy, TreeNode focusNode) {
        if (copy.getChildren() != null) {
            for (int i = 0; copy.getChildren() != null && i < copy.getChildren().size(); ++i) {
                TreeNode t = (TreeNode)copy.getChildren().get(i);
                if (this.isNodeExists(nodeNumbers, t)) {
                    copy.deleteChildNode(t.getId());
                    --i;
                    if (copy.getChildren() != null && copy.getChildren().size() == 0) {
                        copy.setChildren(null);
                    }
                    if (t.getChildren() == null) continue;
                    copy.addChildren(t.getChildren());
                    t.getChildren().forEach(node -> node.setParentid(copy.getId()));
                    continue;
                }
                this.slipTreeNode(nodeNumbers, t, focusNode);
            }
        }
    }

    private TreeNode cloneNode(TreeNode source, final TreeNode focusNode, final List<String> sourceIds) {
        final TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        copy.setParentid(focusNode.getId());
        Object data = source.getData();
        Map sourceData = (Map)data;
        HashMap<String, String> copyData = new HashMap<String, String>();
        if (sourceData != null) {
            copyData.putAll(sourceData);
            copyData.put("sourceId", source.getId());
        }
        copy.setData(copyData);
        this.setBaseInfo(false, source, copy);
        if (source.getChildren() != null) {
            source.getChildren().forEach(new Consumer<TreeNode>(){

                @Override
                public void accept(TreeNode t) {
                    if (sourceIds.contains(t.getId())) {
                        copy.addChild(CslSchemeEditPlugin.this.cloneNode(t, focusNode, sourceIds));
                    }
                }
            });
        }
        return copy;
    }

    private String getShareText(String text) {
        return text + "\uff08S\uff09";
    }

    private void cacheNodeNumbers(Set<String> nodeNumbers) {
        this.getPageCache().put(cache_nodeNumbers, this.toByteSerialized(nodeNumbers));
    }

    private void cacheTreeRoot(TreeNode rootNode) {
        Queue<TreeNode> queue = SearchUtil.getQueue(rootNode);
        while (!queue.isEmpty()) {
            TreeNode node = queue.poll();
            List children = node.getChildren();
            if (children == null) continue;
            for (TreeNode child : children) {
                child.setParentid(node.getId());
            }
        }
        this.getPageCache().put(cache_tree, SerializationUtils.toJsonString((Object)rootNode));
    }

    private TreeNode getCacheRoot() {
        String str = this.getPageCache().get(cache_tree);
        if (str != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
        }
        return null;
    }

    private Set<String> getNodeNumbers() {
        String str = this.getPageCache().get(cache_nodeNumbers);
        Set<String> nodeNumbers = new HashSet<String>();
        if (str != null) {
            nodeNumbers = (Set)this.deSerializedBytes(str);
        }
        return nodeNumbers;
    }

    private boolean isNodeExists(Set<String> nodeNumbers, TreeNode copy) {
        String number = (String)this.getNodeProperty("number", copy);
        return nodeNumbers.contains(number);
    }

    private <T> T getNodeProperty(String key, TreeNode node) {
        Object data = node.getData();
        Map nodeData = (Map)data;
        return (T)(nodeData.get(key) != null ? nodeData.get(key) : nodeData.get(key.toUpperCase(Locale.ENGLISH)));
    }

    private void setNodeProperty(String key, Object value, TreeNode node) {
        if (node != null) {
            Object data = node.getData();
            Map nodeData = (Map)data;
            nodeData.put(key, value);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        String focusNodeId = this.getPageCache().get("focusNodeId");
        if (focusNodeId == null) {
            return;
        }
        TreeNode rootNode = this.getCacheRoot();
        if (rootNode == null) {
            return;
        }
        TreeNode focusNode = rootNode.getTreeNode(focusNodeId, 20);
        if (focusNode == null) {
            return;
        }
        if ("isinnerorg".equals(propName) || "isouterorg".equals(propName)) {
            boolean isOuter = (Boolean)this.getModel().getValue("isouterorg");
            boolean isInner = (Boolean)this.getModel().getValue("isinnerorg");
            if (isOuter && isInner) {
                if ("isinnerorg".equals(propName)) {
                    this.getModel().setValue("isouterorg", (Object)false);
                } else {
                    this.getModel().setValue("isinnerorg", (Object)false);
                }
            }
        } else if ("currency".equals(propName)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency == null) {
                DynamicObject oldData = (DynamicObject)e.getChangeSet()[0].getOldValue();
                this.getModel().getDataEntity().set("currency", (Object)oldData);
                return;
            }
        } else if ("name".equals(propName) && StringUtils.isBlank((CharSequence)(name = (String)this.getModel().getValue("name")))) {
            String oldData = (String)e.getChangeSet()[0].getOldValue();
            this.getModel().getDataEntity().set("name", (Object)oldData);
            return;
        }
        Object data = focusNode.getData();
        Map nodeData = (Map)data;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        nodeData.put("name", this.getModel().getValue("name").toString());
        nodeData.put("aggoprt", this.getModel().getValue("aggoprt").toString());
        nodeData.put("currency.id", currency.getLong("id"));
        nodeData.put("currency.number", currency.getString("number"));
        nodeData.put("currency.name", currency.getString("name"));
        nodeData.put("isinnerorg", (Boolean)this.getModel().getValue("isinnerorg"));
        nodeData.put("isouterorg", (Boolean)this.getModel().getValue("isouterorg"));
        nodeData.put("isEdit", "1");
        this.cacheTreeRoot(rootNode);
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        CommandParam commandParam = new CommandParam("bcm_cslschemeedit", "bcm_tpl_treelist", "refresh", new Object[0]);
        this.sendMsg(this.getView(), commandParam);
        if ("1".equals(this.getPageCache().get("isenable"))) {
            return;
        }
        if (this.getPageCache().get("isClosePageConfirm") != null) {
            return;
        }
        this.getPageCache().put("isClosePageConfirm", "true");
        boolean orgTreeChange = this.isOrgTreeChange();
        if (orgTreeChange) {
            e.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u53d1\u751f\u53d8\u52a8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"CslSchemeEditPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("exitWhetherSave"));
        }
    }

    private boolean isOrgTreeChange() {
        String oldCache = this.getPageCache().get("forCompareCurrentTree");
        TreeNode rootNode = this.getCacheRoot();
        if (oldCache == null && rootNode == null) {
            return false;
        }
        if (oldCache == null && rootNode != null || oldCache != null && rootNode == null) {
            return true;
        }
        Map forCompareCurrentTree = (Map)SerializationUtils.fromJsonString((String)oldCache, Map.class);
        HashMap<String, LinkedHashMap<String, Object>> currentTree = new HashMap<String, LinkedHashMap<String, Object>>();
        this.assembleCurrentTree(rootNode, "Entity", currentTree);
        if (!forCompareCurrentTree.keySet().containsAll(currentTree.keySet()) || !currentTree.keySet().containsAll(forCompareCurrentTree.keySet())) {
            return true;
        }
        for (Map.Entry entry : forCompareCurrentTree.entrySet()) {
            LinkedHashMap oldValue;
            LinkedHashMap newValue = (LinkedHashMap)currentTree.get(entry.getKey());
            boolean isOrgTreeChange = this.isOrgTreeChangeByField(newValue, oldValue = (LinkedHashMap)entry.getValue(), "dseq", "name", "aggoprt", "currency.id", "isinnerorg");
            if (!isOrgTreeChange) continue;
            return true;
        }
        return false;
    }

    private boolean isOrgTreeChangeByField(LinkedHashMap<String, Object> newValue, LinkedHashMap<String, Object> oldValue, String ... field) {
        return Stream.of(field).anyMatch(f -> !Objects.equals(newValue.get(f), oldValue.get(f)));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("exitWhetherSave".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                this.checkPerm("bar_save");
                this.handleSaveTree();
            }
            this.getView().close();
        } else if ("setEnableWhetherSave".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                this.checkPerm("bar_save");
                this.handleSaveTree();
                this.handleEnableScheme();
            } else {
                return;
            }
        }
    }

    private void assembleCurrentTree(TreeNode node, String parentLongNumber, Map<String, LinkedHashMap<String, Object>> currentTree) {
        LinkedHashMap data = (LinkedHashMap)node.getData();
        String longNumber = parentLongNumber + '!' + data.get("number");
        currentTree.put(longNumber, data);
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            for (TreeNode child : children) {
                this.assembleCurrentTree(child, longNumber, currentTree);
            }
        }
    }
}

