/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseBasicPlugIn;
import kd.fi.bcm.formplugin.util.SearchUtil;

public class CslSchemeImportOrgPlugin
extends AbstractBaseBasicPlugIn {
    private static final String lefttree = "cslschemetree";
    private static final String righttree = "waitforselecttree";
    private static final String orglist = "orglist";
    private static final String orgfocus = "orgfocus";
    private static final String cache_lefttree = "cache_lefttree";
    private static final String cache_righttree = "cache_righttree";
    private static final int MAXLEVEL = 20;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbar"});
        this.addClickListeners(new String[]{"searchbefore_left", "searchnext_left", "searchbefore_right", "searchnext_right", "btn_ok"});
        TreeView treeView = (TreeView)this.getControl(lefttree);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent arg0) {
                String cslschemeId = (String)arg0.getNodeId();
                if (!cslschemeId.isEmpty()) {
                    TreeView waitForSelectTreeView = (TreeView)CslSchemeImportOrgPlugin.this.getControl(CslSchemeImportOrgPlugin.righttree);
                    waitForSelectTreeView.deleteAllNodes();
                    DynamicObject cslScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(cslschemeId), (String)"bcm_cslscheme", (String)"nodetype");
                    if ("1".equals(cslScheme.getString("nodetype"))) {
                        CslSchemeImportOrgPlugin.this.buildTreeByCslschemeId(cslschemeId);
                    }
                }
            }
        });
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final TreeView leftTree = (TreeView)this.getControl(lefttree);
        Search sl = (Search)this.getControl("searchap_left");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, leftTree, CslSchemeImportOrgPlugin.cache_lefttree);
                } else {
                    pageCache.put("resultlist", null);
                    view.showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
        final TreeView rightTree = (TreeView)this.getControl(righttree);
        Search sr = (Search)this.getControl("searchap_right");
        sr.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    SearchUtil.searchMember(event.getText().toLowerCase(Locale.ENGLISH).trim(), view, pageCache, rightTree, CslSchemeImportOrgPlugin.cache_righttree, CslSchemeImportOrgPlugin.orglist, CslSchemeImportOrgPlugin.orgfocus);
                } else {
                    pageCache.put(CslSchemeImportOrgPlugin.orglist, null);
                    CslSchemeImportOrgPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCslSchemetree();
        this.initAllOrg();
    }

    private void initAllOrg() {
        QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
        qf.and("cslscheme.isenable", "=", (Object)"1");
        qf.and("number", "!=", (Object)"Entity");
        qf.and("isexchangerate", "=", (Object)"0");
        qf.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, name, dpropertyid1.number, dpropertyid2.number, dpropertyid3.number, dpropertyid4.number, dpropertyid5.number, dpropertyid6.number, dpropertyid7.number, dpropertyid8.number, dpropertyid9.number, dpropertyid10.number", (QFilter[])qf.toArray());
        int size = orgs.size();
        if (size > 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", size);
            for (int i = 0; i < size; ++i) {
                DynamicObject org = (DynamicObject)orgs.get(i);
                this.getModel().setValue("orgid", (Object)org.getString("id"), i);
                this.getModel().setValue("orgnumber", (Object)org.getString("number"), i);
                this.getModel().setValue("orgname", (Object)org.getString("name"), i);
                StringBuilder sb = new StringBuilder();
                for (int j = 1; j <= 10; ++j) {
                    String dp = org.getString("dpropertyid" + j + ".number");
                    if (!StringUtils.isNotEmpty((String)dp)) continue;
                    sb.append(dp).append(";");
                }
                if (sb.length() <= 0) continue;
                this.getModel().setValue("userproperty", (Object)sb.toString(), i);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void initCslSchemetree() {
        TreeView treeView = (TreeView)this.getControl(lefttree);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        TreeNode treeRoot = CslSchemeServiceHelper.addTreeNode((long)modelId, (boolean)true, (TreeView)treeView, (boolean)true);
        this.getPageCache().put(cache_lefttree, SerializationUtils.toJsonString((Object)treeRoot));
    }

    private void buildTreeByCslschemeId(String cslschemeId) {
        if (cslschemeId == null) {
            return;
        }
        Long modelId = this.getModelId();
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("cslscheme", "=", (Object)Long.valueOf(cslschemeId));
        qf.add("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
        qf.add("storagetype", "!=", (Object)StorageTypeEnum.UNSHARE.getOIndex());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,shownumber,parent.id,dseq,level,isleaf,longnumber,aggoprt,storagetype,currency.id,currency.name,currency.number,belongscheme.id,ctrlorg,isindependentorg,isinnerorg,copyfrom,status", (QFilter[])qf.toArray(), (String)"level, dseq");
        if (orgs.isEmpty()) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(righttree);
        treeView.deleteAllNodes();
        DynamicObject rootDy = (DynamicObject)orgs.get(0);
        String rootText = rootDy.getString("number") + " " + rootDy.getString("name");
        TreeNode treeRoot = new TreeNode("", rootDy.getString("id"), rootText, (Object)rootDy);
        if (StorageTypeEnum.SHARE.getOIndex().equals(rootDy.getString("storagetype"))) {
            treeRoot.setText(this.getShareText(treeRoot.getText()));
        }
        this.expandNextLevel(treeRoot, orgs);
        this.cacheTreeRoot(treeRoot);
        treeView.addNode(treeRoot);
        treeRoot.setIsOpened(true);
        Search sr = (Search)this.getControl("searchap_right");
        sr.setSearchKey("");
        this.getPageCache().put(orglist, null);
    }

    private void expandNextLevel(TreeNode parentNode, DynamicObjectCollection orgs) {
        HashMap<Long, List<TreeNode>> result = new HashMap<Long, List<TreeNode>>();
        if (orgs != null && orgs.size() > 0) {
            for (int i = 1; i < orgs.size(); ++i) {
                DynamicObject task = (DynamicObject)orgs.get(i);
                long parentId = task.getLong("parent.id");
                ArrayList<TreeNode> children = (ArrayList<TreeNode>)result.get(parentId);
                if (children == null) {
                    children = new ArrayList<TreeNode>();
                    result.put(parentId, children);
                }
                TreeNode node = new TreeNode();
                String text = task.getString("number") + " " + task.getString("name");
                if (StorageTypeEnum.SHARE.getOIndex().equals(task.getString("storagetype"))) {
                    text = this.getShareText(text);
                }
                node.setText(text);
                node.setId(task.getString("id"));
                node.setData((Object)task);
                children.add(node);
            }
        }
        this.assember(parentNode, result);
    }

    private void assember(TreeNode parentNode, Map<Long, List<TreeNode>> result) {
        Long rootid = Long.valueOf(parentNode.getId());
        List<TreeNode> realChildren = result.get(rootid);
        if (realChildren != null && realChildren.size() > 0) {
            for (TreeNode child : realChildren) {
                parentNode.addChild(child);
                child.setParentid(parentNode.getId());
                this.assember(child, result);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore_left".equals(key) || "searchnext_left".equals(key)) {
            String[] btns = new String[]{"searchbefore_left", "searchnext_left"};
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key, (TreeView)this.getControl(lefttree), btns, cache_lefttree);
        } else if ("searchbefore_right".equals(key) || "searchnext_right".equals(key)) {
            TreeNode old;
            String rowcache = this.getPageCache().get(orglist);
            if (rowcache == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"CslSchemeImportOrgPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            List rowList = (List)SerializationUtils.deSerializeFromBase64((String)rowcache);
            int rowCount = Integer.parseInt(this.getPageCache().get(orgfocus));
            if ("searchbefore_right".equals(key)) {
                if (0 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"CslSchemeImportOrgPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                --rowCount;
            } else {
                if (rowList.size() - 1 == rowCount) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"CslSchemeImportOrgPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ++rowCount;
            }
            this.getPageCache().put(orgfocus, String.valueOf(rowCount));
            TreeNode focusNode = (TreeNode)rowList.get(rowCount);
            TreeNode rootNode = this.getCacheRoot();
            TreeView rightTree = (TreeView)this.getControl(righttree);
            String oldnode = this.getPageCache().get("oldnode");
            TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
            if (old != null) {
                old.setColor("");
                rightTree.updateNode(old);
            }
            focusNode.setColor("blue");
            rightTree.updateNode(focusNode);
            rightTree.focusNode(focusNode);
            this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
            SearchUtil.expand(focusNode.getParentid(), rightTree, rootNode);
        } else if (key.equals("btn_ok")) {
            String focusNodeId = (String)this.getFormCustomParam("focusNodeId");
            if (focusNodeId != null) {
                this.handleHasTree();
            } else {
                this.handleNotHasTree();
            }
        }
    }

    private void handleHasTree() {
        Set existNumbers = new HashSet();
        String existNumbersStr = (String)this.getFormCustomParam("existNumbers");
        if (existNumbersStr != null) {
            existNumbers = (Set)this.deSerializedBytes(existNumbersStr);
        }
        boolean hasSkip = false;
        ArrayList<TreeNode> actNodes = new ArrayList<TreeNode>(128);
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (currentTab.equals("fromscheme")) {
            TreeView righTree = (TreeView)this.getControl(righttree);
            List selectIds = righTree.getTreeState().getSelectedNodeId();
            if (selectIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6811\u8282\u70b9\u3002", (String)"CslSchemeImportOrgPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = this.getCacheRoot();
            if (rootNode == null) {
                return;
            }
            List<String> realSelectNode = this.collectSelectNode(rootNode, selectIds);
            for (String actId : realSelectNode) {
                TreeNode selectNode = rootNode.getTreeNode(actId, 20);
                String number = (String)this.getNodeProperty("number", selectNode);
                if (existNumbers.contains(number)) {
                    hasSkip = true;
                    continue;
                }
                this.setNodeProperty("storagetype", StorageTypeEnum.SHARE.getOIndex(), selectNode);
                actNodes.add(selectNode);
            }
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u9009\u7ec4\u7ec7\u3002", (String)"CslSchemeImportOrgPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> checkedNodeIds = new ArrayList<String>();
            for (int row : selectRows) {
                String number = (String)this.getModel().getValue("orgnumber", row);
                if (existNumbers.contains(number)) {
                    hasSkip = true;
                    continue;
                }
                checkedNodeIds.add(this.getModel().getValue("orgid", row).toString());
            }
            String parentId = (String)this.getFormCustomParam("focusNodeId");
            QFBuilder qf = new QFBuilder("id", "in", (Object)ConvertUtil.convertListToLong(checkedNodeIds));
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,name,number,shownumber,parent.id,dseq,level,isleaf,longnumber,aggoprt,storagetype,currency.id,currency.name,currency.number,belongscheme.id,ctrlorg,isindependentorg,isinnerorg,copyfrom,status", (QFilter[])qf.toArray(), (String)"level, dseq");
            orgs.forEach(o -> {
                TreeNode node = new TreeNode("", o.getString("id"), o.getString("number") + " " + o.getString("name"));
                node.setData(o);
                node = (TreeNode)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)node), TreeNode.class);
                TreeNode cloneNode = this.cloneNode(node);
                cloneNode.setParentid(parentId);
                actNodes.add(cloneNode);
            });
        }
        result.put("hasSkip", hasSkip);
        result.put("actNodes", this.toByteSerialized(actNodes));
        result.put("importFrom", currentTab);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private List<String> collectSelectNode(TreeNode rootNode, List<String> selectIds) {
        ArrayList<String> result = new ArrayList<String>(128);
        int value = Integer.parseInt(this.getModel().getValue("combo_range").toString());
        if (RangeEnum.VALUE_40.getValue() == value) {
            this.getAfterLevelNodes(selectIds, rootNode, result, Boolean.FALSE);
        } else if (RangeEnum.VALUE_50.getValue() == value) {
            this.getAfterLevelNodes(selectIds, rootNode, result, Boolean.TRUE);
        } else if (RangeEnum.VALUE_30.getValue() == value) {
            this.getNextLevelNodes(selectIds, rootNode, result, Boolean.TRUE);
        } else if (RangeEnum.VALUE_20.getValue() == value) {
            this.getNextLevelNodes(selectIds, rootNode, result, Boolean.FALSE);
        } else if (RangeEnum.VALUE_70.getValue() == value) {
            this.getBrotherLevelNodes(selectIds, rootNode, result, Boolean.FALSE);
        } else if (RangeEnum.VALUE_60.getValue() == value) {
            this.getBrotherLevelNodes(selectIds, rootNode, result, Boolean.TRUE);
        } else if (RangeEnum.VALUE_90.getValue() == value) {
            this.getAfterLevelDetailedNodes(selectIds, rootNode, result, Boolean.TRUE);
        } else if (RangeEnum.VALUE_110.getValue() == value) {
            this.getAfterLevelDetailedNodes(selectIds, rootNode, result, Boolean.FALSE);
        } else {
            result.addAll(selectIds);
        }
        return result;
    }

    private void getAfterLevelNodes(List<String> selectIds, TreeNode rootNode, List<String> result, Boolean included) {
        for (String selectId : selectIds) {
            TreeNode selectNode = rootNode.getTreeNode(selectId, 20);
            if (included.booleanValue() && !result.contains(selectId)) {
                result.add(selectId);
            }
            List children = selectNode.getChildren();
            this.recursionCollectNode(result, children);
        }
    }

    private void getNextLevelNodes(List<String> selectIds, TreeNode rootNode, List<String> result, Boolean included) {
        for (String selectId : selectIds) {
            TreeNode selectNode = rootNode.getTreeNode(selectId, 20);
            if (included.booleanValue() && !result.contains(selectId)) {
                result.add(selectId);
            }
            List children = selectNode.getChildren();
            this.nextChildrenCollectNode(result, children);
        }
    }

    private void getBrotherLevelNodes(List<String> selectIds, TreeNode rootNode, List<String> result, Boolean notIncluded) {
        for (String selectId : selectIds) {
            TreeNode selectNode = rootNode.getTreeNode(selectId, 20);
            String parentNodeId = selectNode.getParentid();
            if (StringUtils.isEmpty((String)parentNodeId)) {
                result.add(selectId);
            } else {
                TreeNode selectParentNode = rootNode.getTreeNode(parentNodeId, 20);
                List children = selectParentNode.getChildren();
                this.nextChildrenCollectNode(result, children);
            }
            if (!notIncluded.booleanValue() || !result.contains(selectId)) continue;
            result.remove(selectId);
        }
    }

    private void getAfterLevelDetailedNodes(List<String> selectIds, TreeNode rootNode, List<String> result, Boolean isDetailed) {
        for (String selectId : selectIds) {
            TreeNode selectNode = rootNode.getTreeNode(selectId, 20);
            List children = selectNode.getChildren();
            this.detailedNode(result, children, isDetailed);
        }
    }

    private void detailedNode(List<String> result, List<TreeNode> nodeList, Boolean isDetailed) {
        if (nodeList != null && nodeList.size() > 0) {
            for (TreeNode treeNode : nodeList) {
                List children;
                String treeNodeId = treeNode.getId();
                if (!result.contains(treeNodeId)) {
                    boolean isLeaf = treeNode.isLeaf();
                    List childrenNodes = treeNode.getChildren();
                    if (isDetailed.booleanValue()) {
                        if (isLeaf || childrenNodes == null || childrenNodes.isEmpty()) {
                            result.add(treeNodeId);
                        }
                    } else if (!isLeaf && childrenNodes != null && childrenNodes.size() > 0) {
                        result.add(treeNodeId);
                    }
                }
                if ((children = treeNode.getChildren()) == null || children.size() <= 0) continue;
                this.detailedNode(result, children, isDetailed);
            }
        }
    }

    private void recursionCollectNode(List<String> result, List<TreeNode> nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            for (TreeNode treeNode : nodeList) {
                List children;
                String treeNodeId = treeNode.getId();
                if (!result.contains(treeNodeId)) {
                    result.add(treeNodeId);
                }
                if ((children = treeNode.getChildren()) == null || children.size() <= 0) continue;
                this.recursionCollectNode(result, children);
            }
        }
    }

    private void nextChildrenCollectNode(List<String> result, List<TreeNode> nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            for (TreeNode treeNode : nodeList) {
                String treeNodeId = treeNode.getId();
                if (result.contains(treeNodeId)) continue;
                result.add(treeNodeId);
            }
        }
    }

    private void handleNotHasTree() {
        List<String> checkedNodeIds = new ArrayList();
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if (currentTab.equals("fromscheme")) {
            TreeView tree = (TreeView)this.getControl(righttree);
            checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
            if (checkedNodeIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u9009\u7ec4\u7ec7\u3002", (String)"CslSchemeImportOrgPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = this.getCacheRoot();
            List<String> realSelectNodeId = this.collectSelectNode(rootNode, checkedNodeIds);
            ArrayList checkedNodes = new ArrayList();
            realSelectNodeId.forEach(n -> checkedNodes.add(rootNode.getTreeNode(n, 20)));
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u4e0b\u5217\u7ec4\u7ec7\u4e3a\u9009\u62e9\u7684\u9876\u7ea7\u8282\u70b9\uff1a", (String)"CslSchemeImportOrgPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
            int num = 0;
            for (TreeNode n2 : checkedNodes) {
                if (realSelectNodeId.contains(this.getNodeProperty("parent.id", n2).toString())) continue;
                sb.append(n2.getText()).append("\uff0c\n");
                ++num;
            }
            if (num > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f85\u7f16\u8f91\u7684\u7ec4\u7ec7\u89c6\u56fe\u4e3a\u7a7a\u65f6\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u6216\u5b8c\u6574\u7684\u7ec4\u7ec7\u6811\u3002", (String)"CslSchemeImportOrgPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                return;
            }
            checkedNodeIds = realSelectNodeId;
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u9009\u7ec4\u7ec7\u3002", (String)"CslSchemeImportOrgPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u7f16\u8f91\u7684\u7ec4\u7ec7\u89c6\u56fe\u4e3a\u7a7a\u65f6\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u3002", (String)"CslSchemeImportOrgPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            checkedNodeIds.add(this.getModel().getValue("orgid", selectRows[0]).toString());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("actNodes", this.toByteSerialized(checkedNodeIds));
        result.put("importFrom", currentTab);
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private void setBaseInfo(TreeNode source, TreeNode copy) {
        String copyfrom = this.getNodeProperty("copyfrom", source).toString();
        if ("0".equals(copyfrom)) {
            this.setNodeProperty("copyfrom", source.getId(), copy);
        } else {
            this.setNodeProperty("copyfrom", copyfrom, copy);
        }
        this.setNodeProperty("isNew", "1", copy);
        copy.setText(this.getShareText(source.getText()));
        this.setNodeProperty("storagetype", StorageTypeEnum.SHARE.getOIndex(), copy);
        copy.setColor("blue");
    }

    private TreeNode cloneNode(TreeNode source) {
        TreeNode copy = new TreeNode();
        copy.setId(String.valueOf(GlobalIdUtil.genGlobalLongId()));
        Object data = source.getData();
        Map sourceData = (Map)data;
        HashMap copyData = new HashMap();
        if (sourceData != null) {
            copyData.putAll(sourceData);
        }
        copy.setData(copyData);
        this.setBaseInfo(source, copy);
        return copy;
    }

    private String getShareText(String text) {
        return text + "\uff08S\uff09";
    }

    private void cacheTreeRoot(TreeNode treeRoot) {
        this.getPageCache().putBigObject(cache_righttree, SerializationUtils.toJsonString((Object)treeRoot));
    }

    private TreeNode getCacheRoot() {
        String str = this.getPageCache().getBigObject(cache_righttree);
        if (str != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
        }
        return null;
    }

    private <T> T getNodeProperty(String key, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        return (T)(nodeData.get(key) != null ? nodeData.get(key) : nodeData.get(key.toUpperCase(Locale.ENGLISH)));
    }

    private void setNodeProperty(String key, Object value, TreeNode rightNode) {
        Object data = rightNode.getData();
        Map nodeData = (Map)data;
        nodeData.put(key, value);
    }
}

