/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBCMIndividuationPlugin;

public class CslSchemeIndividuationPlugin
extends AbstractBCMIndividuationPlugin {
    private static final long serialVersionUID = 1L;
    private static final Set<String> excludeSign = Sets.newHashSet((Object[])new String[]{"nodetype_list", "scenecslscheme_filter", "belongscheme_filter"});

    @Override
    protected void addCustomF7Filter(BaseDataCustomControllerEvent event) {
        List qFilters = event.getQfilters();
        Map customParams = event.getListShowParameter().getCustomParams();
        Set signs = customParams.keySet();
        if (Collections.disjoint(signs, excludeSign)) {
            if (!event.getListShowParameter().getCustomParams().containsKey("custom")) {
                this.addParentModelFilter(qFilters, event);
            } else {
                qFilters.add(QFilter.of((String)"isenable = ? and nodetype = ?", (Object[])new Object[]{true, "1"}));
            }
        }
    }

    private void addParentModelFilter(List<QFilter> qFilters, BaseDataCustomControllerEvent event) {
        QFBuilder qfBuilder = new QFBuilder();
        IFormView parentView = this.getParentView(event);
        if (parentView == null) {
            return;
        }
        if ("bcm_bdmapping".equals(parentView.getEntityId())) {
            qfBuilder.and("islegalorgview", "=", (Object)"1");
            qfBuilder.and("number", "!=", (Object)"DefaultRateScheme");
        }
        IDataModel parentDataModel = parentView.getModel();
        DynamicObject dataEntity = parentDataModel.getDataEntity();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        Object modelId = null;
        if (properties.containsKey((Object)"model")) {
            Object value = parentDataModel.getValue("model");
            if (value instanceof DynamicObject) {
                DynamicObject temp = (DynamicObject)value;
                modelId = temp.get("id");
                qfBuilder.add(QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}));
            }
        } else {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String modelIdTemp = pageCache.get("KEY_MODEL_ID");
            if (modelIdTemp != null) {
                qfBuilder.add(QFilter.of((String)"model = ?", (Object[])new Object[]{Long.valueOf(modelIdTemp)}));
            } else {
                FormShowParameter parentShowParamter = parentView.getFormShowParameter();
                modelId = parentShowParamter.getCustomParam("KEY_MODEL_ID");
                if (Objects.nonNull(modelId)) {
                    qfBuilder.add(QFilter.of((String)"model = ?", (Object[])new Object[]{Long.valueOf(String.valueOf(modelId))}));
                }
            }
        }
        this.filterByPerm(qFilters, modelId, qfBuilder);
    }

    private void filterByPerm(List<QFilter> qFilters, Object modelId, QFBuilder qfBuilder) {
        qfBuilder.add(QFilter.of((String)"isenable = ? and nodetype = ?", (Object[])new Object[]{true, "1"}));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id", (QFilter[])qfBuilder.toArray());
        CslSchemeServiceHelper.filterByPerm((DynamicObjectCollection)doc, (Long)LongUtil.toLong((Object)modelId));
        ArrayList ids = new ArrayList(doc.size());
        doc.forEach(x -> {
            if (x != null) {
                ids.add(x.getLong("id"));
            }
        });
        qFilters.add(new QFilter("id", "in", ids));
    }

    private IFormView getParentView(BaseDataCustomControllerEvent event) {
        Object source = event.getSource();
        if (source instanceof BillList) {
            BillList temp = (BillList)source;
            return temp.getView().getParentView();
        }
        if (source instanceof BasedataEdit) {
            BasedataEdit temp = (BasedataEdit)source;
            return temp.getView();
        }
        return null;
    }
}

