/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.util.UserSelectUtil;

public class CslSchemeListPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
MainPage {
    protected static final String ctl_model = "model";
    protected static final String ctl_tree = "templatecatalog";
    protected static final String ctl_list = "billlistap";
    protected static final String action_add = "btn_addgroup";
    protected static final String action_edit = "btn_editgroup";
    protected static final String action_del = "btn_delgroup";
    protected static final String btn_new = "btn_new";
    protected static final String btn_refresh = "btn_refresh";
    protected static final String btn_delete = "btn_del";
    protected static final String btn_view = "btn_view";
    protected static final String btn_delete_share = "btn_delete_share";
    private static final String ISENABLECONST = "isenable";
    private static final String cache_root = "cache_root";
    private static final String delete = "delete";
    private static final String enable = "enable";
    private static final String disable = "disable";

    private String getOperationDisable() {
        return ResManager.loadKDString((String)"\u7981\u7528", (String)"CslSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationEnable() {
        return ResManager.loadKDString((String)"\u542f\u7528", (String)"CslSchemeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationView() {
        return ResManager.loadKDString((String)"\u67e5\u770b", (String)"CslSchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDel() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"CslSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"CslSchemeListPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5931\u8d25", (String)"CslSchemeListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationDelClass() {
        return ResManager.loadKDString((String)"\u5220\u9664\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b", (String)"CslSchemeListPlugin_39", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isFromF7()) {
            return;
        }
        this.addClickListeners(action_add, action_edit, action_del);
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("refresh".equals(com.getOperation())) {
            this.buildLefttree();
            this.refreshList();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (Objects.nonNull(nodeId)) {
            this.refreshList();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isFromF7()) {
            return;
        }
        this.refreshBillByUserSelect(Lists.newArrayList(), false);
        this.buildLefttree();
        this.refreshList();
        BasedataEdit model = (BasedataEdit)this.getControl(ctl_model);
        model.setMustInput(true);
    }

    private boolean isFromF7() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return "bos_listf7".equals(formShowParameter.getFormId());
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (this.isFromF7()) {
            return;
        }
        super.listRowDoubleClick(evt);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (btn_new.equals(itemKey)) {
            this.newScheme();
        } else if (btn_refresh.equals(itemKey)) {
            this.buildLefttree();
            this.refreshList();
        } else if (btn_delete.equals(itemKey)) {
            this.batchDeleteScheme();
        } else if (btn_view.equals(itemKey)) {
            this.viewScheme();
        } else if ("btn_enable".equals(itemKey)) {
            this.batchEnableScheme();
        } else if ("btn_disable".equals(itemKey)) {
            this.batchDisableScheme();
        } else if ("btn_move".equals(itemKey)) {
            this.moveScheme();
        } else if ("btn_close".equals(itemKey)) {
            String hasdisableflag = this.getPageCache().get("hasdisableflag");
            if ("true".equals(hasdisableflag)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u542f\u7528\u7684\u7ec4\u7ec7\u89c6\u56fe\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\u3002", (String)"CslSchemeListPlugin_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exitTip", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    private void moveScheme() {
        Long selectId = this.getSelectId(ResManager.loadKDString((String)"\u79fb\u52a8", (String)"CslSchemeListPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (selectId == null) {
            return;
        }
        DynamicObject cslscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)selectId, (String)"bcm_cslscheme", (String)ISENABLECONST);
        if (!cslscheme.getBoolean(ISENABLECONST)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u7684\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"CslSchemeListPlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_cslschememove");
        parameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        parameter.setCustomParam("cslschemeId", (Object)selectId);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_moveScheme");
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
        this.getPageCache().put("name", this.getSelectInfo().get(0).getName());
        this.getPageCache().put("number", this.getSelectInfo().get(0).getNumber());
    }

    private Long getSelectId(String op) {
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CslSchemeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), op));
            return null;
        }
        return Long.valueOf(selectedRows.getPrimaryKeyValues()[0].toString());
    }

    private ListSelectedRowCollection getSelectInfo() {
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows;
    }

    private void batchEnableScheme() {
        String op = ResManager.loadKDString((String)"\u542f\u7528", (String)"CslSchemeListPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CslSchemeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), op));
            return;
        }
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>();
        ArrayList list = new ArrayList();
        map.put("firstList", list);
        ArrayList dyList = new ArrayList();
        map.put("noFirstDys", dyList);
        HashSet set = new HashSet();
        selectedRows.stream().mapToLong(row -> LongUtil.toLong((Object)row.getPrimaryKeyValue())).forEach(set::add);
        QFilter qFilter = new QFilter("id", "in", set).and(ctl_model, "=", (Object)this.getModelId());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_cslscheme", (String)"id,isenable, islegalorgview", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> list1 = new ArrayList<DynamicObject>(Arrays.asList(load));
        for (DynamicObject dy : load) {
            if (dy.getBoolean(ISENABLECONST)) {
                list1.remove(dy);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7ecf\u7981\u7528\u7684\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CslSchemeListPlugin_36", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                this.refreshList();
                return;
            }
            this.getNoFirstEnable(dy, map);
        }
        List<Long> entityIds = Arrays.stream(load).map(x -> x.getLong("id")).collect(Collectors.toList());
        if (!this.permCheck(entityIds, enable)) {
            return;
        }
        list1.removeAll((Collection)map.get("noFirstDys"));
        ((List)map.get("firstList")).addAll(list1);
        this.getView().getPageCache().put("firstEnableId", SerializationUtils.serializeToBase64(map));
        if (list1.isEmpty()) {
            List list2 = (List)map.get("noFirstDys");
            list2.forEach(this::enableCsls);
            this.refreshList();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CslSchemeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            Long selectId = ((DynamicObject)list1.get(0)).getLong("id");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"CslSchemeListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bcm_cslschemesetdate");
            if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)selectId).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray())) {
                parameter.setCustomParam("text", (Object)ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u53d8\u66f4\u7684\u751f\u6548\u65e5\u671f", (String)"CslSchemeListPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callback_setEnableDate");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    private void enableCsls(DynamicObject cslscheme) {
        Long selectId = cslscheme.getLong("id");
        CslSchemeUtils.updateCslSchemeStatus(selectId, true, null, null);
        String number = cslscheme.getString("number");
        String name = cslscheme.getString("name");
        String log = String.format("%s %s,%s%s", number, name, this.getOperationEnable(), this.getOperationStatusSuccess());
        OperationLogUtil.writeOperationLog((String)this.getOperationEnable(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
    }

    private void getNoFirstEnable(DynamicObject cslscheme, Map<String, List<DynamicObject>> map) {
        boolean bol;
        Long selectId = cslscheme.getLong("id");
        boolean exists = QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)selectId).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray());
        boolean bl = bol = cslscheme.getBoolean("islegalorgview") && exists;
        if (bol) {
            map.get("noFirstDys").add(cslscheme);
        }
    }

    private void batchDisableScheme() {
        String op = ResManager.loadKDString((String)"\u7981\u7528", (String)"CslSchemeListPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CslSchemeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), op));
            return;
        }
        HashSet set = new HashSet();
        selectedRows.stream().mapToLong(row -> LongUtil.toLong((Object)row.getPrimaryKeyValue())).forEach(set::add);
        QFilter qFilter = new QFilter(ctl_model, "=", (Object)this.getModelId());
        qFilter.and("id", "in", set);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_cslscheme", (String)"id,isenable,number,name", (QFilter[])qFilter.toArray());
        Set entries = dynamicObjectMap.entrySet();
        for (Map.Entry entity : entries) {
            DynamicObject value = (DynamicObject)entity.getValue();
            boolean bol = value.getBoolean(ISENABLECONST);
            if (bol) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7ecf\u7981\u7528\u7684\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"CslSchemeListPlugin_37", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> entityIds = dynamicObjectMap.values().stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        if (!this.permCheck(entityIds, disable)) {
            return;
        }
        for (Map.Entry entity : entries) {
            DynamicObject value = (DynamicObject)entity.getValue();
            long selectId = value.getLong("id");
            String number = value.getString("number");
            String name = value.getString("name");
            CslSchemeUtils.updateCslSchemeStatus(selectId, false, null, null);
            String log = String.format("%s %s,%s%s", number, name, this.getOperationDisable(), this.getOperationStatusSuccess());
            OperationLogUtil.writeOperationLog((String)this.getOperationDisable(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"CslSchemeListPlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.refreshList();
    }

    private void enableScheme(DynamicObject dynamicObject, Date enableDate, List<Boolean> booleanList) {
        long cslschemeId = dynamicObject.getLong("id");
        String result = CslSchemeUtils.handleEnable(cslschemeId, this.getClass().getName(), enableDate);
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        String log = null;
        boolean notEmpty = StringUtils.isEmpty((CharSequence)result);
        booleanList.add(notEmpty);
        if (result != null) {
            log = String.format("%s %s,%s%s", number, name, this.getOperationEnable(), this.getOperationStatusFail());
            OperationLogUtil.writeOperationLog((String)this.getOperationEnable(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
        } else {
            log = String.format("%s %s,%s%s", number, name, this.getOperationEnable(), this.getOperationStatusSuccess());
            OperationLogUtil.writeOperationLog((String)this.getOperationEnable(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
            CslSchemeUtils.updateCslSchemeStatus(cslschemeId, true, null, null);
            this.refreshList();
        }
    }

    private void viewScheme() {
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u6682\u4e0d\u652f\u6301\u591a\u884c\u3002", (String)"CslSchemeListPlugin_34", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long selectId = this.getSelectId(ResManager.loadKDString((String)"\u67e5\u770b", (String)"CslSchemeListPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (selectId == null) {
            return;
        }
        IFormView view = this.getView();
        IFormView mainPageView = view.getMainView();
        IFormView parentView = view.getParentView();
        String pageId = view.getPageId() + selectId + "view";
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bcm_cslschemeview");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
            showParameter.setCustomParam("cslschemeId", (Object)selectId);
            showParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(showParameter);
                view.sendFormAction(parentView);
            } else {
                view.showForm(showParameter);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            view.sendFormAction(childFormView);
        }
        String log = null;
        log = String.format("%s %s,%s%s", selectedRows.get(0).getNumber(), selectedRows.get(0).getName(), this.getOperationView(), this.getOperationStatusSuccess());
        OperationLogUtil.writeOperationLog((String)this.getOperationView(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
    }

    private void batchDeleteScheme() {
        String op = ResManager.loadKDString((String)"\u5220\u9664", (String)"CslSchemeListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        BillList billList = (BillList)this.getControl(ctl_list);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u201c%s\u201d\u7684\u6570\u636e\u3002", (String)"CslSchemeListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), op));
            return;
        }
        for (ListSelectedRow row2 : selectedRows) {
            if ("DefaultScheme".equalsIgnoreCase(row2.getNumber())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u9ed8\u8ba4\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u53ef\u5220\u9664\u3002", (String)"CslSchemeListPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("DefaultRateScheme".equalsIgnoreCase(row2.getNumber())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u53ef\u5220\u9664\u3002", (String)"CslSchemeListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFilter("cslscheme", "=", row2.getPrimaryKeyValue()).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u4e0b\u5b58\u5728\u7ec4\u7ec7\u6210\u5458\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"CslSchemeListPlugin_31", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("id", "=", row2.getPrimaryKeyValue());
            filter.and(new QFilter(ISENABLECONST, "=", (Object)"1"));
            if (QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])filter.toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u542f\u7528\u72b6\u6001\u65e0\u6cd5\u5220\u9664\u3002", (String)"CslSchemeListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qf = new QFilter(ctl_model, "=", (Object)this.getModelId());
            qf.and(new QFilter("belongscheme", "=", row2.getPrimaryKeyValue()));
            if (!QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])qf.toArray())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5df2\u88ab\u7ec4\u7ec7\u6210\u5458\u8bbe\u4e3a\u201c\u6240\u5c5e\u7ec4\u7ec7\u89c6\u56fe\u201d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"CslSchemeMovePlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> selectedIds = new ArrayList<Long>(10);
        selectedRows.stream().mapToLong(row -> LongUtil.toLong((Object)row.getPrimaryKeyValue().toString())).forEach(selectedIds::add);
        if (!this.permCheck(selectedIds, delete)) {
            return;
        }
        CslSchemeServiceHelper.forceDeleteScheme(selectedIds);
        OperationLogUtil.writeOperationLog((String)this.getOperationDel(), (String)String.format("%s %s,%s%s", selectedRows.get(0).getNumber(), selectedRows.get(0).getName(), this.getOperationDel(), this.getOperationStatusSuccess()), (Long)this.getModelId(), (String)"bcm_cslscheme");
        this.refreshList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CslSchemeListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    private boolean permCheck(List<Long> entityIds, String Operation) {
        if (PermClassEntityHelper.isHasReadPerm((String)"bcm_cslscheme", (Long)this.getModelId(), entityIds)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u201c\u53ea\u8bfb\u201d\u6743\u9650\u7684\u7ec4\u7ec7\u89c6\u56fe\uff0c\u4e0d\u5141\u8bb8\u201c%s\u201d\u3002", (String)"CslSchemeListPlugin_33", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.getOperation(Operation)));
            return false;
        }
        return true;
    }

    private String getOperation(String operation) {
        switch (operation) {
            case "delete": {
                return this.getOperationDel();
            }
            case "enable": {
                return this.getOperationEnable();
            }
            case "disable": {
                return this.getOperationDisable();
            }
        }
        return "";
    }

    public void newScheme() {
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(ctl_model);
        if (modelDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"CslSchemeListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (Objects.isNull(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"CslSchemeListPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u57fa\u672c\u4fe1\u606f", (String)"CslSchemeListPlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bcm_cslscheme");
        parameter.setCustomParam("parent", (Object)focusNodeId);
        parameter.setCustomParam(ctl_model, (Object)modelDyn.getLong("id"));
        parameter.setCustomParam("isScheme", (Object)true);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, btn_new));
        this.getView().showForm(parameter);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (ctl_model.equals(name)) {
            this.buildLefttree();
            this.refreshList();
            UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), String.valueOf(this.getModelId()));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        e.setCancel(true);
    }

    protected void refreshList() {
        BillList billList = (BillList)this.getControl(ctl_list);
        billList.clearSelection();
        billList.refresh();
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (StringUtils.isEmpty((CharSequence)source)) {
            return;
        }
        for (IListColumn listColumn : args.getListColumns()) {
            List<String> groupDisplayFields;
            String fieldKey = listColumn.getListFieldKey();
            if ("parent.name".equals(fieldKey)) {
                listColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u7ea7", (String)"CslSchemeMovePlugin_32", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            }
            if ((groupDisplayFields = Arrays.asList("number", "name", "parent.name", "modifytime", "creater.number")).contains(fieldKey)) continue;
            listColumn.setVisible(0);
        }
    }

    protected void buildLefttree() {
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        try {
            TreeNode root = CslSchemeServiceHelper.addTreeNode2TreeView((long)modelId, (boolean)false, (TreeView)treeView);
            treeView.focusNode(root);
            this.getPageCache().put(cache_root, root.getId());
        }
        catch (KDBizException ex) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (action_del.equals(key)) {
            this.deleteTreeNode(evt);
            this.refreshList();
        } else if (action_edit.equals(key)) {
            this.modifyTreeNode(evt);
        } else if (action_add.equals(key)) {
            this.newTreeNode(evt);
        }
    }

    protected void newTreeNode(EventObject evt) {
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(ctl_model);
        if (modelDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"CslSchemeListPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String focusNodeId = this.getFocusNodeId();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b", (String)"CslSchemeListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss stylecss = new StyleCss();
        stylecss.setHeight("350px");
        parameter.getOpenStyle().setInlineStyleCss(stylecss);
        parameter.setFormId("bcm_cslscheme");
        parameter.setCustomParam("parent", (Object)focusNodeId);
        parameter.setCustomParam(ctl_model, (Object)modelDyn.getLong("id"));
        parameter.setCustomParam("isSchemeClass", (Object)true);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action_add));
        this.getView().showForm(parameter);
    }

    protected void modifyTreeNode(EventObject evt) {
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (Objects.isNull(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4fee\u6539\u7684\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"CslSchemeListPlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b", (String)"CslSchemeListPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        baseShowParameter.setFormId("bcm_cslscheme");
        baseShowParameter.setPkId((Object)focusNodeId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss stylecss = new StyleCss();
        stylecss.setHeight("300px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(stylecss);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action_add));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    protected void deleteTreeNode(EventObject evt) {
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (Objects.isNull(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u3002", (String)"CslSchemeListPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (focusNodeId.equalsIgnoreCase(this.getPageCache().get(cache_root))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CslSchemeListPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (CslSchemeServiceHelper.existScheme((Long)Long.valueOf(focusNodeId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u4e0b\u5b58\u5728\u7ec4\u7ec7\u89c6\u56fe\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CslSchemeListPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id, longnumber,number,name", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(focusNodeId)}).toArray());
        if (queryOne != null) {
            DeleteServiceHelper.delete((String)"bcm_cslscheme", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}).and(new QFilter("longnumber", "like", (Object)(queryOne.getString("longnumber") + ".%")).or(QFilter.of((String)"id = ?", (Object[])new Object[]{queryOne.getLong("id")}))).toArray());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CslSchemeListPlugin_28", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            String log = String.format("%s %s,%s%s", queryOne.getString("number"), queryOne.getString("name"), this.getOperationDel(), this.getOperationStatusSuccess());
            OperationLogUtil.writeOperationLog((String)this.getOperationDelClass(), (String)log, (Long)this.getModelId(), (String)"bcm_cslscheme");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5206\u7c7b\u5df2\u88ab\u5220\u9664\u3002", (String)"CslSchemeListPlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.buildLefttree();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (action_add.equals(actionId)) {
            if (closedCallBackEvent.getReturnData() != null) {
                this.buildLefttree();
                this.refreshList();
            }
        } else if (btn_new.equals(actionId) || "callback_moveScheme".equals(actionId)) {
            this.refreshList();
        } else if ("callback_setEnableDate".equals(actionId)) {
            Date enableDate = (Date)closedCallBackEvent.getReturnData();
            if (enableDate != null) {
                String firstEnableId = this.getView().getPageCache().get("firstEnableId");
                if (StringUtils.isNotEmpty((CharSequence)firstEnableId)) {
                    List dyList;
                    Map map = (Map)SerializationUtils.deSerializeFromBase64((String)firstEnableId);
                    List list = (List)map.get("firstList");
                    ArrayList booleanList = new ArrayList();
                    if (!list.isEmpty()) {
                        list.forEach(firstDy -> this.enableScheme((DynamicObject)firstDy, enableDate, booleanList));
                        if (booleanList.contains(true)) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"CslSchemeListPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        } else {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002", (String)"CslSchemeListPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                        }
                    }
                    if (!(dyList = (List)map.get("noFirstDys")).isEmpty()) {
                        dyList.forEach(this::enableCsls);
                    }
                }
                this.getView().getPageCache().remove("firstEnableId");
            }
            this.refreshList();
        }
    }

    @Override
    public long getModelId() {
        if (this.getControl(ctl_model) == null) {
            return 0L;
        }
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(ctl_model);
        if (modelDyn == null) {
            return 0L;
        }
        return modelDyn.getLong("id");
    }

    public void setFilter(SetFilterEvent e) {
        if (this.isFromF7()) {
            return;
        }
        QFilter filters = QFilter.of((String)"nodetype = ?", (Object[])new Object[]{"1"});
        DynamicObjectCollection queryDatas = this.queryListData(filters);
        CslSchemeServiceHelper.filterByPerm((DynamicObjectCollection)queryDatas, (Long)this.getModelId());
        Collection<Long> needQueryId = this.filterVersionData(queryDatas);
        filters = new QFilter("id", "in", needQueryId);
        e.addCustomQFilter(filters);
    }

    private DynamicObjectCollection queryListData(QFilter filters) {
        String focusNodeId = this.getFocusNodeId();
        String longNumber = "aaa@aaa";
        long modelId = this.getModelId();
        filters = filters.and(QFilter.of((String)"model = ?", (Object[])new Object[]{modelId}));
        if (this.isFocusNodeIdNotEmpty(focusNodeId)) {
            longNumber = this.getNodeLongNumber(focusNodeId);
        }
        filters = filters.and(new QFilter("longnumber", "like", (Object)(longNumber + ".%")));
        this.getPageCache().remove("hasdisableflag");
        DynamicObjectCollection queryDatas = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number, isenable", (QFilter[])filters.toArray(), (String)"version", (int)-1);
        this.getPageCache().put("hasdisableflag", "false");
        if (queryDatas.toString().contains("false")) {
            this.getPageCache().put("hasdisableflag", "true");
        }
        return queryDatas;
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getControl(ctl_tree);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (Objects.isNull(focusNodeId)) {
            focusNodeId = this.getPageCache().get(cache_root);
        }
        return focusNodeId;
    }

    private boolean isFocusNodeIdNotEmpty(String focusNodeId) {
        return StringUtils.isNotEmpty((CharSequence)focusNodeId) && !StringUtils.equals((CharSequence)"0", (CharSequence)focusNodeId);
    }

    private String getNodeLongNumber(String focusNodeId) {
        String longNumber = "";
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.cslscheme.CslSchemeListPlugin.refreshList()", (String)"bcm_cslscheme", (String)"id, number, longnumber", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(focusNodeId)}).toArray(), null, (int)1);){
            Iterator iterator = queryDataSet.iterator();
            longNumber = iterator.hasNext() ? ((Row)iterator.next()).getString("longnumber") : longNumber;
        }
        return longNumber;
    }

    private Collection<Long> filterVersionData(DynamicObjectCollection queryDatas) {
        HashMap needQueryNumber2IdMapping = Maps.newHashMap();
        queryDatas.forEach(q -> {
            String number = q.getString("number");
            if (needQueryNumber2IdMapping.containsKey(number)) {
                return;
            }
            needQueryNumber2IdMapping.put(number, q.getLong("id"));
        });
        return needQueryNumber2IdMapping.values();
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (this.isFromF7()) {
            return;
        }
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        CslSchemeUtils.showCslSchemeEditForm(this.getView(), list.getFocusRowPkId().toString(), this.getModelId(), false);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("exitTip".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
            return;
        }
    }
}

