/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.TreeMapVO;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.mergecontrol.AdjustShareDimRangeParse;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserSelectServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import org.apache.commons.collections.CollectionUtils;

public class CslSchemeUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void showCslSchemeEditForm(IFormView view, String cslschemeId, long modelId, boolean isAdd) {
        String pageId = view.getPageId() + cslschemeId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"islegalorgview", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{Long.valueOf(cslschemeId)}).toArray());
        if (queryOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u5df2\u88ab\u5220\u9664\u3002", (String)"CslSchemeUtils_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        boolean islegalorgview = queryOne.getBoolean("islegalorgview");
        boolean exist = QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)LongUtil.toLong((Object)cslschemeId)).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray());
        if (islegalorgview && isAdd) {
            showParameter.setFormId("bcm_dimensionmanager");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)("" + modelId));
        } else if (islegalorgview) {
            boolean isDimLmtAdmin = ConfigServiceHelper.getGlobalBoolParam((String)"isDimLmtAdmin");
            if (isDimLmtAdmin) {
                Set manaModelIds = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)ApplicationTypeEnum.CM);
                if (!manaModelIds.contains(modelId)) throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u4f53\u7cfb\u7ba1\u7406\u5458\u53ef\u4ee5\u67e5\u770b\u8be5\u4f53\u7cfb\u7684\u6cd5\u5b9a\u89c6\u56fe\uff0c\u8bf7\u6388\u6743\u540e\u91cd\u8bd5", (String)"CslSchemeUtils_35", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                showParameter.setFormId("bcm_dimensionmanager");
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)("" + modelId));
            } else {
                showParameter.setFormId("bcm_dimensionmanager");
                showParameter.setCustomParam("KEY_MODEL_ID", (Object)("" + modelId));
            }
        } else {
            showParameter.setFormId("bcm_cslschemeedit");
            showParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        }
        showParameter.setCustomParam("cslschemeId", (Object)cslschemeId);
        showParameter.setCustomParam("islegalorgview", (Object)queryOne.getBoolean("islegalorgview"));
        showParameter.setCustomParam("entity", (Object)"bcm_entitymembertree");
        showParameter.setPageId(pageId);
        view.showForm(showParameter);
    }

    public static String validateAdjustShareSetting(DynamicObject sourceOrg, DynamicObject shareOrg, Long modelId, boolean isOld) {
        String msg = null;
        if (shareOrg == null) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u8981\u5171\u4eab\u7684\u7ec4\u7ec7\u3002", (String)"CslSchemeUtils_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        if (sourceOrg == null || shareOrg == null || modelId == null) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0b\u5217\u4f20\u5165\u53c2\u6570\u5b58\u5728\u7a7a\u503c\uff1a\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\uff0c\u201c%3$s\u201d\u3002", (String)"CslSchemeUtils_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sourceOrg == null, shareOrg == null, modelId == null));
        }
        if (isOld && sourceOrg.getLong("cslscheme") - shareOrg.getLong("cslscheme") == 0L) {
            return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u76f8\u540c\u7ec4\u7ec7\u89c6\u56fe\u7ec4\u7ec7\u95f4\u8fdb\u884c\u5171\u4eab\u3002", (String)"CslSchemeUtils_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    public static Object getDefaultCslSchemeId(String modelId) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id, number", (QFilter[])QFilter.of((String)"model = ? and nodetype = ?", (Object[])new Object[]{ConvertUtil.convertStrToLong((String)modelId), "1"}).toArray(), (String)"isenable desc, id asc");
        if (query == null || query.size() == 0) {
            return null;
        }
        if (query.size() == 1 || !"DefaultRateScheme".equals(((DynamicObject)query.get(0)).getString("number"))) {
            return ((DynamicObject)query.get(0)).getLong("id");
        }
        return ((DynamicObject)query.get(1)).getLong("id");
    }

    public static void setDefaultCslSchemeValue(String modelId, boolean force, IFormView iFormView) {
        IDataModel dataModel = iFormView.getModel();
        boolean containsCslschemeField = dataModel.getDataEntityType().getProperties().containsKey((Object)"cslscheme");
        if (!containsCslschemeField) {
            return;
        }
        if (GuidePageUtils.setDefaultCslSchemeValue(iFormView, modelId)) {
            return;
        }
        Object cslSchemeId = null;
        if (force) {
            cslSchemeId = CslSchemeUtils.getDefaultCslSchemeId(modelId);
        } else {
            UserSelectModel userSelectByForm = UserSelectServiceHelper.getUserSelectByForm((String)RequestContext.get().getUserId(), (String)UserSelectServiceHelper.getDefaultFileds((String)iFormView.getFormShowParameter().getFormId()), (ApplicationTypeEnum)ApplicationTypeEnum.CM, (String)"");
            if (userSelectByForm != null && StringUtils.isNotEmpty((CharSequence)userSelectByForm.getCslScheme())) {
                Set modelIds = MemberPermHelper.getLimitedModelListByUser();
                if (modelIds.contains(LongUtil.toLong((Object)modelId))) {
                    cslSchemeId = userSelectByForm.getCslScheme();
                } else {
                    Set noPermCslSchemeIds = CslSchemeServiceHelper.getNoPermCslSchemeIds((Long)Long.parseLong(modelId));
                    if (!noPermCslSchemeIds.contains(Long.parseLong(userSelectByForm.getCslScheme()))) {
                        cslSchemeId = userSelectByForm.getCslScheme();
                    }
                }
            }
            if (cslSchemeId == null || "0".equals(cslSchemeId) || !CslSchemeUtils.existsScheme(cslSchemeId, Long.valueOf(modelId))) {
                cslSchemeId = CslSchemeUtils.getDefaultCslSchemeId(modelId);
            }
        }
        dataModel.beginInit();
        dataModel.setValue("cslscheme", cslSchemeId);
        dataModel.endInit();
    }

    private static boolean existsScheme(Object cslSchemeId, Long modelId) {
        return QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])QFilter.of((String)"id = ? and model = ? and number != ?", (Object[])new Object[]{Long.parseLong(cslSchemeId.toString()), modelId, "DefaultRateScheme"}).toArray());
    }

    public static FormShowParameter genDimMultiF7FormShowParameter(long modelId, int dimension, String sign, CloseCallBack callback) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bcm_multiplememberf7_adj");
        formShowParameter.setCustomParam("model", (Object)modelId);
        formShowParameter.setCustomParam("dimension", (Object)Integer.toString(dimension));
        formShowParameter.setCustomParam("sign", (Object)sign);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"CslSchemeUtils_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(callback);
        return formShowParameter;
    }

    public static DynamicObjectCollection getAllEntityContainShareDynCollection(Collection<Long> selectedOrgIds) {
        DynamicObjectCollection belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"member", (QFilter[])new QFilter("id", "in", selectedOrgIds).toArray());
        belongorgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, name, isleaf, cslscheme, member, model", (QFilter[])new QFilter("member", "in", belongorgs.stream().map(v -> v.getLong("member")).collect(Collectors.toSet())).toArray());
        return belongorgs;
    }

    public static Multimap<Long, Long> getCommonSettingOrgs(Collection<Object> ids, Map<String, Long> commonDims) {
        DynamicObjectCollection reportAdjustDC = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id, model, scenario, year, period, audittrail, bussnesstype, journaltype, belongorg,belongorg.longnumber", (QFilter[])new QFilter("id", "in", ids).toArray());
        HashSet allOrgSetting = Sets.newHashSet();
        reportAdjustDC.forEach(row -> allOrgSetting.add(row.getLong("belongorg")));
        DynamicObjectCollection allSourceEntityDC = CslSchemeServiceHelper.getTreeAllEntityContainShare((Collection)allOrgSetting);
        ArrayListMultimap member2orgsMapping = ArrayListMultimap.create();
        ArrayList adjBelongOrgVOs = new ArrayList(16);
        allSourceEntityDC.forEach(arg_0 -> CslSchemeUtils.lambda$getCommonSettingOrgs$2(allOrgSetting, (Multimap)member2orgsMapping, arg_0));
        DynamicObjectCollection settingcollectin = CslSchemeUtils.getSettingDynamicObjects(commonDims);
        DynamicObjectCollection allShareOrgDC = CslSchemeServiceHelper.getTreeAllEntityContainShare((Collection)settingcollectin.stream().map(v -> v.getLong("shareorg")).collect(Collectors.toSet()));
        CslSchemeUtils.filterAutoMergeOrgStatus(commonDims, settingcollectin, allShareOrgDC);
        allShareOrgDC.forEach(row -> {
            TreeMapVO vo = new TreeMapVO(row.getString("number"), "", row.getString("longnumber"), row.getLong("id"), row.getLong("member"), 0L);
            adjBelongOrgVOs.add(vo);
        });
        allSourceEntityDC.forEach(row -> {
            for (TreeMapVO adjBelongOrgVO : adjBelongOrgVOs) {
                if (!adjBelongOrgVO.getNumber().equals(row.getString("number"))) continue;
                adjBelongOrgVO.setSourceOrgField(row.getString("number"), row.getString("longnumber"), row.getLong("id"));
            }
        });
        AdjustShareDimRangeParse parse = AdjustShareDimRangeParse.getInstance((DynamicObjectCollection)settingcollectin, (DynamicObjectCollection)reportAdjustDC, (Multimap)member2orgsMapping, adjBelongOrgVOs);
        parse.setAllShareOrgDC(allShareOrgDC);
        parse.setAllSourceEntityDC(allSourceEntityDC);
        parse.setAdjBelongOrgVOs(adjBelongOrgVOs);
        Multimap result = parse.findValideAdjust2OrgMapping();
        return result;
    }

    public static DynamicObjectCollection getSettingDynamicObjects(Map<String, Long> commonDims) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, member,longnumber,cslscheme", (QFilter[])new QFilter("id", "in", (Object)commonDims.get("org")).toArray());
        HashMap<Long, Long> csl2OrgId = new HashMap<Long, Long>(16);
        for (DynamicObject object : doc) {
            csl2OrgId.put(object.getLong("cslscheme"), object.getLong("id"));
        }
        QFilter filter = new QFilter("shareorg", "in", (Object)commonDims.get("org"));
        QFilter filter2 = new QFilter("sharecsl", "in", doc.stream().map(e -> e.getLong("cslscheme")).collect(Collectors.toSet()));
        QFilter filter3 = new QFilter("sharecsl", "=", (Object)0L).and(new QFilter("sourcecsl", "!=", (Object)0L));
        QFilter filter4 = new QFilter("model", "=", (Object)commonDims.get("model"));
        DynamicObjectCollection dynCollection = QueryServiceHelper.query((String)"bcm_ajshareglobalsetting", (String)"id, sourceorg, sourceorg.member,sourceorg.longnumber, shareorg,sourcecsl,sharecsl, scenario, year, period, audittrail, businesstype, journaltype, model", (QFilter[])new QFilter[]{filter4.and(filter.or(filter2).or(filter3))});
        DynamicObjectCollection toDeleteDoc = CslSchemeServiceHelper.filterOrgSetting((Object)commonDims.get("model"), (Object)commonDims.get("scenario"), (Object)commonDims.get("year"), (Object)commonDims.get("period"), (DynamicObjectCollection)dynCollection);
        dynCollection.removeAll((Collection)toDeleteDoc);
        Set set = dynCollection.stream().map(e -> e.getLong("sourcecsl")).collect(Collectors.toSet());
        filter = new QFilter("cslscheme", "in", set);
        filter2 = new QFilter("cslscheme", "!=", (Object)0L);
        QFilter lvfilter = new QFilter("level", "=", (Object)2);
        doc.addAll((Collection)QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, member,longnumber,cslscheme", (QFilter[])new QFilter[]{filter, filter2, lvfilter}));
        for (DynamicObject dy : dynCollection) {
            for (DynamicObject obj : doc) {
                long cslscheme = obj.getLong("cslscheme");
                if (cslscheme == dy.getLong("sourcecsl")) {
                    dy.set("sourceorg", (Object)obj.getLong("id"));
                    dy.set("sourceorg.member", (Object)obj.getLong("member"));
                    dy.set("sourceorg.longnumber", (Object)obj.getString("longnumber"));
                }
                if (cslscheme == dy.getLong("sharecsl")) {
                    Long shareorg = (Long)csl2OrgId.get(cslscheme);
                    dy.set("shareorg", (Object)(shareorg == null ? Long.valueOf(obj.getLong("id")) : shareorg));
                    continue;
                }
                if (dy.getLong("sharecsl") != 0L || dy.getLong("sourcecsl") == 0L || !csl2OrgId.containsKey(cslscheme)) continue;
                dy.set("shareorg", csl2OrgId.get(cslscheme));
            }
        }
        return dynCollection;
    }

    private static void filterAutoMergeOrgStatus(Map<String, Long> commonDims, DynamicObjectCollection dynCollection, DynamicObjectCollection allEntityDynCollection) {
        ArrayList allOrgIds = Lists.newArrayListWithCapacity((int)allEntityDynCollection.size());
        HashMap orgMap = new HashMap(10);
        ArrayListMultimap member2orgsMapping = ArrayListMultimap.create();
        allEntityDynCollection.forEach(arg_0 -> CslSchemeUtils.lambda$filterAutoMergeOrgStatus$8(allOrgIds, orgMap, (Multimap)member2orgsMapping, arg_0));
        Map batchGetMcStatus = McStatus.batchGetMcStatus((Object)commonDims.get("model"), (Collection)Lists.newArrayList((Iterable)allOrgIds), (Object)commonDims.get("scenario"), (Object)commonDims.get("year"), (Object)commonDims.get("period"));
        Set periodOpenOrgSet = PeriodSettingHelper.batchSelectPeriodStatusOpen((Long)commonDims.get("model"), new HashSet(orgMap.values()), (Long)commonDims.get("scenario"), (Long)commonDims.get("year"), (Long)commonDims.get("period"), (String)"entrystatus");
        member2orgsMapping.asMap().forEach((k, v) -> {
            boolean flag = false;
            for (Long row : v) {
                McStatus mcStatus = (McStatus)batchGetMcStatus.get(row);
                if (mcStatus.getFlow().isSubmit() || mcStatus.getConvertFlow().isSubmit()) {
                    flag = true;
                    break;
                }
                if (!ConfigServiceHelper.getBoolParam((Long)((Long)commonDims.get("model")), (String)"CM012") || periodOpenOrgSet.contains(orgMap.get(row))) continue;
                flag = true;
                break;
            }
            if (flag) {
                allOrgIds.removeAll((Collection<?>)v);
            }
        });
        Iterator iterator = dynCollection.iterator();
        while (iterator.hasNext()) {
            if (allOrgIds.contains(((DynamicObject)iterator.next()).getLong("shareorg"))) continue;
            iterator.remove();
        }
    }

    public static void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"CslSchemeUtils_12", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public static String handleEnable(Long cslschemeId, String className, Date enableDate) {
        Object oldOrg22;
        DynamicObject[] orgs;
        DynamicObject cslscheme = BusinessDataServiceHelper.loadSingleFromCache((Object)cslschemeId, (String)"bcm_cslscheme", (String)"number, islegalorgview");
        if (cslscheme.getBoolean("islegalorgview") && QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("cslscheme", "=", (Object)cslschemeId).add("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()).toArray())) {
            return null;
        }
        Map storageOrg = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"number,name", (QFilter[])new QFBuilder("cslscheme", "=", (Object)cslschemeId).add("storagetype", "=", (Object)StorageTypeEnum.STORAGE.getOIndex()).add("isleaf", "=", (Object)true).add("status", "not in", Arrays.asList(OrgStoreStatusEnum.REMOVE.getValue(), OrgStoreStatusEnum.DISABLE.getValue())).toArray());
        if (!storageOrg.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            storageOrg.values().forEach(o -> {
                sb.append(ResManager.loadKDString((String)"\u4e0b\u5217\u5408\u5e76\u7ec4\u7ec7\u4e0b\u65e0\u6210\u5458\uff0c\u4e0d\u80fd\u542f\u7528\uff1a", (String)"CslSchemeUtils_29", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                sb.append(o.getString("number")).append(' ').append(o.getString("name")).append('\n');
            });
            return sb.toString();
        }
        Set allOrgIds = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFBuilder("cslscheme", "=", (Object)cslschemeId).add("status", "not in", Collections.singletonList(OrgStoreStatusEnum.DISABLE.getValue())).toArray()).keySet();
        if (allOrgIds.isEmpty()) {
            return null;
        }
        HashMap<Long, DynamicObject> id2NotLeafOrg = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, List> copyfromId2ShareOrg = new HashMap<Long, List>(16);
        DynamicObject root = null;
        MainEntityType orgEntityType = EntityMetadataCache.getDataEntityType((String)"bcm_entitymembertree");
        for (DynamicObject org2 : orgs = BusinessDataServiceHelper.load((Object[])allOrgIds.toArray(), (DynamicObjectType)orgEntityType)) {
            if (org2.getInt("level") == 2) {
                root = org2;
            }
            if (!org2.getBoolean("isleaf")) {
                id2NotLeafOrg.put(org2.getLong("id"), org2);
            }
            if (org2.getBoolean("isleaf") || !StorageTypeEnum.SHARE.getOIndex().equals(org2.getString("storagetype"))) continue;
            long copyfromId = org2.getDynamicObject("copyfrom").getLong("id");
            copyfromId2ShareOrg.computeIfAbsent(copyfromId, k -> new ArrayList(4)).add(org2);
        }
        Map copyfromId2Org = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"aggoprt,isindependentorg,ctrlorg,currency", (QFilter[])new QFBuilder("id", "in", copyfromId2ShareOrg.keySet()).toArray());
        Map<Long, List<DynamicObject>> groupByCopyfromOrg = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number,isleaf,parent.id", (QFilter[])new QFBuilder("parent.id", "in", copyfromId2ShareOrg.keySet()).toArray()).values().stream().collect(Collectors.groupingBy(e -> e.getLong("parent.id")));
        Map<Long, List<DynamicObject>> groupByNotLeaf = Arrays.stream(orgs).collect(Collectors.groupingBy(e -> e.getDynamicObject("parent").getLong("id")));
        HashMap<Long, DynamicObject> changedOrg = new HashMap<Long, DynamicObject>(16);
        HashMap<String, DynamicObject> newCurrency = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : groupByCopyfromOrg.entrySet()) {
            for (DynamicObject notLeafOrg : (List)copyfromId2ShareOrg.get(entry.getKey())) {
                long notLeafOrgId;
                boolean isChanged = CslSchemeUtils.isStructChange(notLeafOrg, groupByNotLeaf.get(notLeafOrgId = notLeafOrg.getLong("id")), (DynamicObject)copyfromId2Org.get(entry.getKey()), entry.getValue(), newCurrency);
                if (!isChanged) continue;
                changedOrg.put(notLeafOrgId, notLeafOrg);
            }
        }
        DynamicObjectCollection notLeafOrgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, level", (QFilter[])new QFBuilder("cslscheme", "=", (Object)cslschemeId).add("isleaf", "=", (Object)false).add("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue()).toArray(), (String)"level, dseq");
        HashMap<Long, DynamicObject> toSaveOrgs = new HashMap<Long, DynamicObject>(16);
        HashSet<String> changedParentNumbers = new HashSet<String>(16);
        HashSet<Long> newStorageOrgIds = new HashSet<Long>(16);
        HashSet<String> toSaveOlapOrgNumbers = new HashSet<String>(16);
        HashMap<Long, Long> id2newId = new HashMap<Long, Long>(16);
        HashMap<String, String> deriveOlapNumber = new HashMap<String, String>(16);
        String schemeNumber = cslscheme.getString("number");
        ArrayList<Long> oldStorageIsIC = new ArrayList<Long>(10);
        ArrayList<Long> oldStorageNotIsIC = new ArrayList<Long>(10);
        if (root != null && OrgStoreStatusEnum.TEMPSAVE.getValue().equals(root.getString("status"))) {
            if (StorageTypeEnum.SHARE.getOIndex().equals(root.getString("storagetype")) && changedOrg.isEmpty()) {
                return ResManager.loadKDString((String)"\u6839\u6210\u5458\u4e0d\u80fd\u4e3a\u5171\u4eab\u6210\u5458\u3002", (String)"CslSchemeUtils_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            }
            for (DynamicObject org3 : notLeafOrgs) {
                long notLeafOrgId = org3.getLong("id");
                DynamicObject notLeafOrg = (DynamicObject)id2NotLeafOrg.get(notLeafOrgId);
                if (StorageTypeEnum.SHARE.getOIndex().equals(notLeafOrg.getString("storagetype"))) {
                    boolean isChanged = changedOrg.containsKey(notLeafOrgId);
                    CslSchemeUtils.handleNotLeafShareOrg(isChanged, notLeafOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, deriveOlapNumber, enableDate);
                    continue;
                }
                if (!StorageTypeEnum.STORAGE.getOIndex().equals(notLeafOrg.getString("storagetype"))) continue;
                CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
                newStorageOrgIds.add(notLeafOrgId);
                for (DynamicObject child2 : groupByNotLeaf.get(notLeafOrgId)) {
                    if (!child2.getBoolean("isleaf")) continue;
                    CslSchemeUtils.updateOrgAttribute(child2, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
                }
            }
        } else {
            HashSet<String> handledOrgNumber = new HashSet<String>(16);
            HashMap<Long, Integer> parentId2lastDseq = new HashMap<Long, Integer>(16);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject tmp : notLeafOrgs) {
                long notLeafOrgId = tmp.getLong("id");
                DynamicObject notLeafOrg = (DynamicObject)id2NotLeafOrg.get(notLeafOrgId);
                String status = notLeafOrg.getString("status");
                if (status.equals(OrgStoreStatusEnum.REMOVE.getValue())) {
                    CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, 0, null, enableDate);
                    if (!CollectionUtils.isNotEmpty((Collection)groupByNotLeaf.get(notLeafOrgId))) continue;
                    for (DynamicObject child3 : groupByNotLeaf.get(notLeafOrgId)) {
                        if (!child3.getBoolean("isleaf")) continue;
                        CslSchemeUtils.updateOrgAttribute(child3, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, 0, null, enableDate);
                    }
                    continue;
                }
                if (StorageTypeEnum.SHARE.getOIndex().equals(notLeafOrg.getString("storagetype"))) {
                    String longNumber = notLeafOrg.getString("longnumber");
                    boolean ishandled = false;
                    for (String parentLongNumber : handledOrgNumber) {
                        if (!longNumber.startsWith(parentLongNumber)) continue;
                        ishandled = true;
                        break;
                    }
                    if (ishandled) continue;
                    if (changedOrg.containsKey(notLeafOrgId)) {
                        Object parent = (DynamicObject)id2NotLeafOrg.get(notLeafOrg.getDynamicObject("parent").getLong("id"));
                        while (StorageTypeEnum.SHARE.getOIndex().equals(parent.getString("storagetype"))) {
                            status = parent.getString("status");
                            longNumber = parent.getString("longnumber");
                            parent = (DynamicObject)id2NotLeafOrg.get(parent.getDynamicObject("parent").getLong("id"));
                        }
                        if (status.equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) {
                            CslSchemeUtils.handleNotLeafShareOrg(true, notLeafOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, deriveOlapNumber, enableDate);
                            continue;
                        }
                        long parentId = parent.getLong("id");
                        if (!parentId2lastDseq.containsKey(parentId)) {
                            int lastDseq = ((DynamicObject)QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"dseq", (QFilter[])new QFBuilder("parent", "=", (Object)parentId).toArray(), (String)"dseq desc").get(0)).getInt("dseq");
                            parentId2lastDseq.put(parentId, lastDseq);
                        }
                        handledOrgNumber.add(longNumber);
                        QFBuilder qf = new QFBuilder("cslscheme", "=", (Object)cslschemeId);
                        qf.add("longnumber", "like", (Object)(longNumber + "!%"));
                        qf.or("longnumber", "=", (Object)longNumber);
                        qf.add("isleaf", "=", (Object)false);
                        qf.add("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
                        DynamicObjectCollection notLeafOfBranch = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, level", (QFilter[])qf.toArray(), (String)"level");
                        for (DynamicObject tmp2 : notLeafOfBranch) {
                            long tmpNotLeafOrgId = tmp2.getLong("id");
                            DynamicObject tmpNotLeafOrg = (DynamicObject)id2NotLeafOrg.get(tmpNotLeafOrgId);
                            if (tmpNotLeafOrg.getString("status").equals(OrgStoreStatusEnum.REMOVE.getValue())) continue;
                            CslSchemeUtils.handleNotLeafShareOrToCopyOrg(changedOrg.containsKey(tmpNotLeafOrgId), tmpNotLeafOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, id2newId, enableDate, parentId2lastDseq);
                        }
                        continue;
                    }
                    if (!status.equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) continue;
                    CslSchemeUtils.handleNotLeafShareOrg(false, notLeafOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, deriveOlapNumber, enableDate);
                    continue;
                }
                if (!StorageTypeEnum.STORAGE.getOIndex().equals(notLeafOrg.getString("storagetype"))) continue;
                boolean isTempSave = status.equals(OrgStoreStatusEnum.TEMPSAVE.getValue());
                if (isTempSave) {
                    CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
                    newStorageOrgIds.add(notLeafOrgId);
                } else if (notLeafOrg.getBoolean("isinnerorg")) {
                    oldStorageIsIC.add(notLeafOrgId);
                } else {
                    oldStorageNotIsIC.add(notLeafOrgId);
                }
                Recorder existEffectiveChild = new Recorder((Object)false);
                if (groupByNotLeaf.get(notLeafOrgId) != null) {
                    for (DynamicObject child4 : groupByNotLeaf.get(notLeafOrgId)) {
                        String childStatus = child4.getString("status");
                        if (childStatus.equals(OrgStoreStatusEnum.TEMPSAVE.getValue()) || childStatus.equals(OrgStoreStatusEnum.AUDIT.getValue())) {
                            existEffectiveChild.setRecord((Object)true);
                        }
                        if (childStatus.equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) {
                            if (child4.getBoolean("isleaf")) {
                                CslSchemeUtils.updateOrgAttribute(child4, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
                            }
                            if (isTempSave) continue;
                            if (child4.getBoolean("isleaf")) {
                                toSaveOlapOrgNumbers.add(notLeafOrg.getString("number") + "_" + child4.getString("number"));
                                continue;
                            }
                            if (deriveOlapNumber.containsKey(child4.getString("number"))) continue;
                            deriveOlapNumber.put(child4.getString("number"), notLeafOrg.getString("number") + "_" + child4.getString("number"));
                            continue;
                        }
                        if (!childStatus.equals(OrgStoreStatusEnum.REMOVE.getValue()) || !child4.getBoolean("isleaf")) continue;
                        CslSchemeUtils.updateOrgAttribute(child4, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, 0, null, enableDate);
                    }
                }
                if (((Boolean)existEffectiveChild.getRecord()).booleanValue()) continue;
                sb.append(ResManager.loadKDString((String)"\u4e0b\u5217\u5408\u5e76\u7ec4\u7ec7\u4e0b\u65e0\u6210\u5458\uff0c\u4e0d\u80fd\u542f\u7528\uff1a", (String)"CslSchemeUtils_29", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
                sb.append(notLeafOrg.getString("number")).append(' ').append(notLeafOrg.getString("name")).append('\n');
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        DynamicObject model = orgs[0].getDynamicObject("model");
        long modelId = model.getLong("id");
        StringBuilder result = new StringBuilder();
        Set icLongNumbers = MemberReader.getAllNodeFromCache((String)"bcm_icmembertree", (Object)modelId).values().stream().map(v -> v.getLongNumber()).collect(Collectors.toSet());
        StringBuilder existMsg = new StringBuilder();
        existMsg.append(ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u3010\u5171\u4eab\u5408\u5e76\u7ec4\u7ec7\u4e0b\u7ea7\u53d1\u751f\u53d8\u5316\uff0c\u5c06\u81ea\u52a8\u4f5c\u4e3a\u65b0\u589e\u6210\u5458\u5904\u7406\uff0c\u65b0\u589e\u6210\u5458\u7684\u81ea\u52a8\u7f16\u7801\u89c4\u5219\u4e3a\u539f\u7ec4\u7ec7\u7f16\u7801+\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801\uff0c\u53ef\u901a\u8fc7\u624b\u5de5\u65b0\u589e\u5408\u5e76\u8282\u70b9\u65b9\u5f0f\u5904\u7406\u3002\u3011", (String)"CslSchemeUtils_31", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        StringBuilder existNumber = new StringBuilder();
        existNumber.append("\n").append(ResManager.loadKDString((String)"\u4e0b\u5217\u6210\u5458\u7684\u81ea\u52a8\u7f16\u7801\u4e0e\u5df2\u6709\u7ec4\u7ec7\u6210\u5458\u7f16\u7801\u91cd\u590d\uff1a", (String)"CslSchemeUtils_32", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        StringBuilder existShare2StorageICNumber = new StringBuilder();
        existShare2StorageICNumber.append("\n").append(ResManager.loadKDString((String)"\u4e0b\u5217\u6210\u5458\u662f\u5f80\u6765\u7ec4\u7ec7\uff0c\u81ea\u52a8\u7f16\u7801\u4e0e\u5df2\u6709\u5916\u90e8\u5f80\u6765\u7ec4\u7ec7\u6210\u5458\u7f16\u7801\u91cd\u590d\uff1a", (String)"CslSchemeUtils_33", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        boolean exist = false;
        boolean existShare2StorageIC = false;
        for (Long newId : newStorageOrgIds) {
            DynamicObject newStorageOrg = (DynamicObject)id2NotLeafOrg.get(newId);
            String number3 = newStorageOrg.getString("number");
            if (QueryServiceHelper.exists((String)"bcm_entitymembertree", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)number3).add("id", "!=", (Object)newId).toArray())) {
                exist = true;
                existNumber.append(newStorageOrg.getString("shownumber")).append(' ').append(newStorageOrg.getString("name")).append('\n');
                continue;
            }
            if (newStorageOrg.getString("number").equals(newStorageOrg.getString("shownumber")) || !newStorageOrg.getBoolean("isinnerorg") || !icLongNumbers.contains("InternalCompany!ICTotal!ICOEntity!" + number3)) continue;
            existShare2StorageIC = true;
            existShare2StorageICNumber.append(newStorageOrg.getString("shownumber")).append(' ').append(newStorageOrg.getString("name")).append('\n');
        }
        if (exist || existShare2StorageIC) {
            if (exist) {
                result.append((CharSequence)existMsg).append((CharSequence)existNumber);
            }
            if (existShare2StorageIC) {
                if (exist) {
                    result.append((CharSequence)existShare2StorageICNumber);
                } else {
                    result.append((CharSequence)existMsg).append((CharSequence)existShare2StorageICNumber);
                }
            }
        }
        boolean existIC = false;
        StringBuilder existICNumber = new StringBuilder();
        existICNumber.append(result.length() > 0 ? "\n\n" : "").append(ResManager.loadKDString((String)"\u4e0b\u5217\u5b58\u50a8\u7c7b\u578b\u6210\u5458\u8bbe\u7f6e\u4e86\u5f80\u6765\u7ec4\u7ec7\uff0c\u7f16\u7801\u4e0e\u5df2\u6709\u5916\u90e8\u5f80\u6765\u7ec4\u7ec7\u6210\u5458\u7f16\u7801\u91cd\u590d\uff1a", (String)"CslSchemeUtils_34", (String)"fi-bcm-formplugin", (Object[])new Object[0])).append("\n");
        for (DynamicObject notLeafOrg : id2NotLeafOrg.values()) {
            String number4 = notLeafOrg.getString("number");
            if (!notLeafOrg.getString("number").equals(notLeafOrg.getString("shownumber")) || !notLeafOrg.getBoolean("isinnerorg") || !icLongNumbers.contains("InternalCompany!ICTotal!ICOEntity!" + number4)) continue;
            existIC = true;
            existICNumber.append(number4).append(' ').append(notLeafOrg.getString("name")).append('\n');
        }
        if (existIC) {
            result.append((CharSequence)existICNumber);
        }
        if (result.length() > 0) {
            return result.toString();
        }
        long dimensionId = orgs[0].getDynamicObject("dimension").getLong("id");
        DynamicObject icDimension = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id,number", (QFilter[])new QFBuilder("model", "=", (Object)modelId).add("number", "=", (Object)"InternalCompany").toArray());
        long icDimensionId = icDimension.getLong("id");
        long icParentId = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_icmembertree", (String)"id", (QFilter[])new QFBuilder("dimension", "=", (Object)icDimensionId).add("number", "=", (Object)"ICEntity").toArray()).getLong("id");
        int icMaxSeq = 0;
        DynamicObjectCollection icChildren = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"dseq", (QFilter[])new QFBuilder("parent", "=", (Object)icParentId).toArray(), (String)"dseq desc", (int)1);
        if (icChildren != null && icChildren.size() > 0) {
            icMaxSeq = ((DynamicObject)icChildren.get(0)).getInt("dseq");
        }
        DynamicObject mcDimension = DimensionServiceHelper.queryMyCompanyDim((long)modelId);
        long mcDimensionId = 0L;
        long mcParentId = 0L;
        int mcMaxSeq = 0;
        if (mcDimension != null) {
            mcDimensionId = mcDimension.getLong("id");
            mcParentId = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_mycompanymembertree", (String)"id", (QFilter[])new QFBuilder("dimension", "=", (Object)mcDimension.getLong("id")).add("number", "=", (Object)"MyCompany").toArray()).getLong("id");
            DynamicObjectCollection mcChildren = QueryServiceHelper.query((String)"bcm_mycompanymembertree", (String)"dseq", (QFilter[])new QFBuilder("parent", "=", (Object)mcParentId).toArray(), (String)"dseq desc", (int)1);
            mcMaxSeq = ((DynamicObject)mcChildren.get(0)).getInt("dseq");
        }
        ArrayList<DynamicObject> toSaveOrgMembers = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> toSaveMCs = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> toSaveMCMembers = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> toSaveICs = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> toSaveICMembers = new ArrayList<DynamicObject>(10);
        toSaveOlapOrgNumbers.addAll(deriveOlapNumber.values());
        HashSet<String> toSaveOlapICNumbers = new HashSet<String>(16);
        HashSet<String> toSaveOlapMCNumbers = new HashSet<String>(16);
        ArrayList<String> deleteICNumbers = new ArrayList<String>(16);
        for (Long l : newStorageOrgIds) {
            DynamicObject newStorageOrg = (DynamicObject)id2NotLeafOrg.get(l);
            newCurrency.put(newStorageOrg.getDynamicObject("currency").getString("number"), newStorageOrg.getDynamicObject("currency"));
            String number5 = newStorageOrg.getString("number");
            if (newStorageOrg.getInt("level") == 2) {
                toSaveOlapOrgNumbers.add("Entity_" + number5);
            } else {
                DynamicObject parent = newStorageOrg.getDynamicObject("parent");
                Long newParentId = (Long)id2newId.get(parent.getLong("id"));
                parent = newParentId != null ? (DynamicObject)id2NotLeafOrg.get(newParentId) : (DynamicObject)id2NotLeafOrg.get(parent.getLong("id"));
                toSaveOlapOrgNumbers.add(parent.getString("number") + "_" + number5);
            }
            toSaveOlapOrgNumbers.add(number5);
            DynamicObject newMember = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymember");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)newMember);
            long memberNewId = GlobalIdUtil.genGlobalLongId();
            newMember.set("id", (Object)memberNewId);
            newMember.set("number", (Object)number5);
            newMember.set("name", (Object)newStorageOrg.getString("name"));
            newMember.set("model", (Object)modelId);
            newMember.set("dimension", (Object)dimensionId);
            toSaveOrgMembers.add(newMember);
            newStorageOrg.set("member", (Object)newMember);
            DynamicObjectCollection currencychangerds = newStorageOrg.getDynamicObjectCollection("currencychangerds");
            DynamicObject currencychangerd = new DynamicObject(currencychangerds.getDynamicObjectType());
            currencychangerd.set("currencyrds", (Object)newStorageOrg.getDynamicObject("currency"));
            currencychangerd.set("currencyeffdate", (Object)enableDate);
            currencychangerd.set("currencymodifier", (Object)RequestContext.get().getUserId());
            currencychangerd.set("currencymodifytime", (Object)new Date());
            currencychangerd.set("seq", (Object)1);
            currencychangerds.clear();
            currencychangerds.add((Object)currencychangerd);
            toSaveOrgs.put(l, newStorageOrg);
            groupByNotLeaf.get(l).forEach(child -> {
                if (child.getBoolean("isleaf")) {
                    child.set("longnumber", (Object)(newStorageOrg.getString("longnumber") + '!' + child.getString("number")));
                    toSaveOrgs.put(child.getLong("id"), (DynamicObject)child);
                    toSaveOlapOrgNumbers.add(number5 + "_" + child.getString("number"));
                } else {
                    Long newChildId = (Long)id2newId.get(child.getLong("id"));
                    if (newChildId != null) {
                        DynamicObject newChildOrg = (DynamicObject)id2NotLeafOrg.get(newChildId);
                        newChildOrg.set("parent", (Object)newStorageOrg);
                        newChildOrg.set("longnumber", (Object)(newStorageOrg.getString("longnumber") + '!' + newChildOrg.getString("number")));
                        toSaveOrgs.put(newChildId, newChildOrg);
                        toSaveOlapOrgNumbers.add(number5 + "_" + newChildOrg.getString("number"));
                    } else {
                        DynamicObject parent = child.getDynamicObject("parent");
                        Long newParentId = (Long)id2newId.get(parent.getLong("id"));
                        if (newParentId != null) {
                            DynamicObject newParent = (DynamicObject)id2NotLeafOrg.get(newParentId);
                            child.set("parent", (Object)newParent);
                            child.set("longnumber", (Object)(newParent.getString("longnumber") + '!' + child.getString("number")));
                        }
                        toSaveOrgs.put(child.getLong("id"), (DynamicObject)child);
                        toSaveOlapOrgNumbers.add(number5 + "_" + child.getString("number"));
                    }
                }
            });
            if (newStorageOrg.getBoolean("isinnerorg")) {
                toSaveOlapICNumbers.add(number5);
                CslSchemeUtils.createMcOrICMember(newStorageOrg, true, ++icMaxSeq, icDimensionId, icParentId, toSaveICMembers, toSaveICs);
            }
            if (mcDimension == null) continue;
            toSaveOlapMCNumbers.add(number5);
            CslSchemeUtils.createMcOrICMember(newStorageOrg, false, ++mcMaxSeq, mcDimensionId, mcParentId, toSaveMCMembers, toSaveMCs);
        }
        for (Long l : oldStorageIsIC) {
            String number2 = ((DynamicObject)id2NotLeafOrg.get(l)).getString("number");
            if (icLongNumbers.contains("InternalCompany!ICTotal!ICEntity!" + number2)) continue;
            toSaveOlapICNumbers.add(number2);
            CslSchemeUtils.createMcOrICMember((DynamicObject)id2NotLeafOrg.get(l), true, ++icMaxSeq, icDimensionId, icParentId, toSaveICMembers, toSaveICs);
        }
        for (Long l : oldStorageNotIsIC) {
            String number2 = ((DynamicObject)id2NotLeafOrg.get(l)).getString("number");
            if (!icLongNumbers.contains("InternalCompany!ICTotal!ICEntity!" + number2)) continue;
            deleteICNumbers.add(number2);
        }
        DynamicObjectCollection oldNotLeafOrgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, level", (QFilter[])new QFBuilder("id", "in", id2newId.keySet()).toArray(), (String)"level");
        for (Object oldOrg22 : oldNotLeafOrgs) {
            Long oldId = oldOrg22.getLong("id");
            Long newId = (Long)id2newId.get(oldId);
            if (newStorageOrgIds.contains(newId)) continue;
            DynamicObject newNotLeafOrg = (DynamicObject)id2NotLeafOrg.get(newId);
            for (DynamicObject child5 : groupByNotLeaf.get(newId)) {
                if (child5.getBoolean("isleaf")) {
                    DynamicObject newChildOrg = (DynamicObject)toSaveOrgs.get(child5.getLong("id"));
                    newChildOrg.set("longnumber", (Object)(newNotLeafOrg.getString("longnumber") + '!' + newChildOrg.getString("number")));
                    continue;
                }
                DynamicObject newNotLeafChild = (DynamicObject)id2NotLeafOrg.get(id2newId.get(child5.getLong("id")));
                if (newNotLeafChild == null) continue;
                newNotLeafChild.set("parent", (Object)newNotLeafOrg);
                newNotLeafChild.set("longnumber", (Object)(newNotLeafOrg.getString("longnumber") + '!' + newNotLeafChild.getString("number")));
                toSaveOrgs.put(newNotLeafChild.getLong("id"), newNotLeafChild);
            }
        }
        id2NotLeafOrg.forEach((id, org) -> {
            if (!org.getBoolean("isleaf")) {
                List list = (List)groupByNotLeaf.get(id);
                if (org.getString("status").equals(OrgStoreStatusEnum.DISABLE.getValue()) && CollectionUtils.isNotEmpty((Collection)list)) {
                    boolean existDisabledChild = false;
                    for (DynamicObject tmp : list) {
                        if (!((DynamicObject)toSaveOrgs.get(tmp.getLong("id"))).getString("status").equals(OrgStoreStatusEnum.DISABLE.getValue())) continue;
                        existDisabledChild = true;
                        break;
                    }
                    if (!existDisabledChild) {
                        ((DynamicObject)toSaveOrgs.get(id)).set("isleaf", (Object)true);
                    }
                }
                if (org.getString("storagetype").equals(StorageTypeEnum.SHARE.getOIndex())) {
                    DynamicObject copyfromOrg;
                    DynamicObject toSaveOrg = (DynamicObject)toSaveOrgs.get(id);
                    if (toSaveOrg != null) {
                        copyfromOrg = (DynamicObject)copyfromId2Org.get(toSaveOrg.getDynamicObject("copyfrom").getLong("id"));
                        toSaveOrg.set("aggoprt", copyfromOrg.get("aggoprt"));
                        toSaveOrg.set("isindependentorg", copyfromOrg.get("isindependentorg"));
                        toSaveOrg.set("ctrlorg", copyfromOrg.get("ctrlorg"));
                        toSaveOrg.set("currency", copyfromOrg.get("currency"));
                    } else {
                        copyfromOrg = (DynamicObject)copyfromId2Org.get(org.getDynamicObject("copyfrom").getLong("id"));
                        org.set("aggoprt", copyfromOrg.get("aggoprt"));
                        org.set("isindependentorg", copyfromOrg.get("isindependentorg"));
                        org.set("ctrlorg", copyfromOrg.get("ctrlorg"));
                        toSaveOrgs.put((Long)id, (DynamicObject)org);
                    }
                }
            }
        });
        TXHandle tXHandle = TX.required();
        oldOrg22 = null;
        try {
            try {
                SaveServiceHelper.save((DynamicObject[])toSaveOrgs.values().toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])toSaveOrgMembers.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])toSaveMCs.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])toSaveMCMembers.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])toSaveICs.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])toSaveICMembers.toArray(new DynamicObject[0]));
                QFilter qfDisabled = new QFilter("cslscheme", "=", (Object)cslschemeId).and("status", "=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
                List longNumbers = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"longnumber", (QFilter[])qfDisabled.toArray()).stream().map(x -> x.getString("longnumber")).collect(Collectors.toList());
                if (!longNumbers.isEmpty()) {
                    HashMap longNumber2Org = new HashMap(4);
                    QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, status, longnumber", (QFilter[])new QFilter("cslscheme", "=", (Object)cslschemeId).and("longnumber", "in", longNumbers).toArray()).forEach(o -> {
                        List list = longNumber2Org.computeIfAbsent(o.getString("longnumber"), l -> new ArrayList(2));
                        list.add(o);
                    });
                    ArrayList<Long> toUpdateIds = new ArrayList<Long>(4);
                    ArrayList<Long> toDeleteIds = new ArrayList<Long>(4);
                    for (List list : longNumber2Org.values()) {
                        if (list.size() <= 1) continue;
                        for (DynamicObject org4 : list) {
                            if (OrgStoreStatusEnum.DISABLE.getValue().equals(org4.getString("status"))) {
                                toUpdateIds.add(org4.getLong("id"));
                                continue;
                            }
                            toDeleteIds.add(org4.getLong("id"));
                        }
                    }
                    if (toDeleteIds.size() > 0) {
                        DeleteServiceHelper.delete((IDataEntityType)orgEntityType, (Object[])toDeleteIds.toArray());
                    }
                    if (toUpdateIds.size() > 0) {
                        DynamicObject[] toUpdateOrgs;
                        DynamicObject modifier = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                        modifier.set("id", (Object)RequestContext.get().getCurrUserId());
                        modifier.set("name", (Object)RequestContext.get().getUserName());
                        for (DynamicObject org5 : toUpdateOrgs = BusinessDataServiceHelper.load((Object[])toUpdateIds.toArray(), (DynamicObjectType)orgEntityType)) {
                            org5.set("status", (Object)OrgStoreStatusEnum.AUDIT.getValue());
                            DynamicObjectCollection bizRecords = org5.getDynamicObjectCollection("bizchangerds");
                            bizRecords.clear();
                            DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
                            bizRecord.set("bizeffdate", (Object)enableDate);
                            bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
                            bizRecord.set("seq", (Object)1);
                            bizRecord.set("bizmodifier", (Object)modifier);
                            bizRecord.set("bizmodifytime", (Object)new Date());
                            bizRecords.add((Object)bizRecord);
                        }
                        SaveServiceHelper.save((DynamicObject[])toUpdateOrgs);
                    }
                }
                String modelNumber = model.getString("number");
                if (!deleteICNumbers.isEmpty()) {
                    QFBuilder qf = new QFBuilder("model", "=", (Object)modelId).add("number", "in", deleteICNumbers);
                    Collection members = BusinessDataServiceHelper.loadFromCache((String)"bcm_icmembertree", (String)"member.id", (QFilter[])qf.toArray()).values();
                    DeleteServiceHelper.delete((String)"bcm_icmembertree", (QFilter[])qf.toArray());
                    DeleteServiceHelper.delete((String)"bcm_intercompanymember", (QFilter[])new QFilter("id", "in", members.stream().map(v -> v.getLong("member.id")).collect(Collectors.toSet())).toArray());
                    ArrayListMultimap multimap = ArrayListMultimap.create();
                    deleteICNumbers.forEach(arg_0 -> CslSchemeUtils.lambda$handleEnable$21((Multimap)multimap, arg_0));
                    OlapServiceHelper.batchDropAggFactor((String)modelNumber, (String)DimEntityNumEnum.ENTITY.getNumber(), (Multimap)multimap);
                    OlapServiceHelper.batchDropDimensionMembersForce((String)modelNumber, (String)"InternalCompany", deleteICNumbers);
                }
                if (!newCurrency.isEmpty()) {
                    List newCurrencyOlapMembers = Collections.synchronizedList(new ArrayList(4));
                    List newProcessOlapMembers = Collections.synchronizedList(new ArrayList(4));
                    newCurrency.values().forEach(currency -> {
                        String cyNumber = currency.getString("number");
                        DimensionServiceHelper.createCurrencyMember((long)modelId, (String)modelNumber, (String)cyNumber, (String)currency.getString("name"), (String)className);
                        DimensionServiceHelper.createProcessMember((long)modelId, (DynamicObject)currency, (String)modelNumber, (String)className);
                        newCurrencyOlapMembers.add(new Tuple((Object)cyNumber, (Object)AggOprtEnum.SKIP.getIntSign(), (Object)"Currency"));
                        newProcessOlapMembers.add(new Tuple((Object)cyNumber, (Object)AggOprtEnum.SKIP.getIntSign(), (Object)"TCF"));
                    });
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)"Currency", newCurrencyOlapMembers);
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)"Process", newProcessOlapMembers);
                }
                if (!toSaveOlapOrgNumbers.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)"Entity", (String[])toSaveOlapOrgNumbers.toArray(new String[0]));
                    HashMap orgMap = new HashMap(16);
                    toSaveOlapOrgNumbers.stream().filter(f -> f.contains("_")).forEach(n -> {
                        String[] str = n.split("_");
                        if (str.length == 2) {
                            orgMap.computeIfAbsent(str[0], o -> new HashSet(16)).add(str[1]);
                        }
                    });
                    LockScopeServiceHelper.addOrgToLockScope((long)modelId, orgMap);
                }
                if (!toSaveOlapICNumbers.isEmpty()) {
                    List newIcOlapMembers = Collections.synchronizedList(new ArrayList(4));
                    toSaveOlapICNumbers.forEach(number -> newIcOlapMembers.add(new Tuple(number, (Object)AggOprtEnum.ADD.getIntSign(), (Object)"ICEntity")));
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)"InternalCompany", newIcOlapMembers);
                }
                if (!toSaveOlapMCNumbers.isEmpty()) {
                    List newMcOlapMembers = Collections.synchronizedList(new ArrayList(4));
                    toSaveOlapMCNumbers.forEach(number -> newMcOlapMembers.add(new Tuple(number, (Object)AggOprtEnum.ADD.getIntSign(), (Object)"MyCompany")));
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNumber, (String)"MyCompany", newMcOlapMembers);
                }
            }
            catch (Throwable e2) {
                tXHandle.markRollback();
                throw e2;
            }
        }
        catch (Throwable e2) {
            oldOrg22 = e2;
            throw e2;
        }
        finally {
            if (tXHandle != null) {
                if (oldOrg22 != null) {
                    try {
                        tXHandle.close();
                    }
                    catch (Throwable e2) {
                        ((Throwable)oldOrg22).addSuppressed(e2);
                    }
                } else {
                    tXHandle.close();
                }
            }
        }
        String string = model.getString("number");
        QFilter filter = new QFilter("cslscheme", "=", (Object)cslschemeId);
        filter.and(new QFilter("status", "!=", (Object)"A"));
        DynamicObjectCollection toRepairOrgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, parent.id, aggoprt, isleaf, storagetype, level", (QFilter[])filter.toArray(), (String)"level");
        DynamicComputingServiceHelper.repairModelByScope((String)string, (String)DimTypesEnum.ENTITY.getNumber(), (boolean)false, (DynamicObjectCollection)toRepairOrgs);
        return null;
    }

    private static void handleNotLeafShareOrg(boolean isChanged, DynamicObject notLeafOrg, Map<Long, DynamicObject> id2NotLeafOrg, String schemeNumber, Set<String> changedParentNumbers, Map<Long, DynamicObject> toSaveOrgs, Set<Long> newStorageOrgIds, Map<Long, List<DynamicObject>> groupByNotLeaf, Map<String, String> deriveOlapNumber, Date enableDate) {
        long notLeafOrgId = notLeafOrg.getLong("id");
        if (isChanged) {
            long parentId = notLeafOrg.getDynamicObject("parent").getLong("id");
            DynamicObject parentOrg = id2NotLeafOrg.get(parentId);
            if (parentOrg != null && StorageTypeEnum.SHARE.getOIndex().equals(parentOrg.getString("storagetype"))) {
                CslSchemeUtils.handleNotLeafShareOrg(isChanged, parentOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, deriveOlapNumber, enableDate);
            }
            String number = notLeafOrg.getString("number");
            CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, true, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
            if (parentOrg != null) {
                deriveOlapNumber.put(number, parentOrg.getString("number") + "_" + notLeafOrg.getString("number"));
            }
            changedParentNumbers.add(number);
            newStorageOrgIds.add(notLeafOrgId);
            id2NotLeafOrg.put(notLeafOrgId, notLeafOrg);
        } else {
            CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 1, null, enableDate);
        }
        for (DynamicObject child : groupByNotLeaf.get(notLeafOrgId)) {
            if (!child.getBoolean("isleaf")) continue;
            CslSchemeUtils.updateOrgAttribute(child, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, isChanged ? 0 : 1, null, enableDate);
        }
    }

    private static void handleNotLeafShareOrToCopyOrg(boolean isChanged, DynamicObject notLeafOrg, Map<Long, DynamicObject> id2NotLeafOrg, String schemeNumber, Set<String> changedParentNumbers, Map<Long, DynamicObject> toSaveOrgs, Set<Long> newStorageOrgIds, Map<Long, List<DynamicObject>> groupByNotLeaf, Map<Long, Long> id2newId, Date enableDate, Map<Long, Integer> parentId2lastDseq) {
        long notLeafOrgId = notLeafOrg.getLong("id");
        long newId = 0L;
        if (isChanged) {
            long parentId = notLeafOrg.getDynamicObject("parent").getLong("id");
            DynamicObject parentOrg = id2NotLeafOrg.get(parentId);
            if (parentOrg != null && StorageTypeEnum.SHARE.getOIndex().equals(parentOrg.getString("storagetype")) && !newStorageOrgIds.contains(id2newId.get(parentOrg.getLong("id")))) {
                CslSchemeUtils.handleNotLeafShareOrToCopyOrg(isChanged, parentOrg, id2NotLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, newStorageOrgIds, groupByNotLeaf, id2newId, enableDate, parentId2lastDseq);
            }
            String number = notLeafOrg.getString("number");
            if (notLeafOrg.getString("status").equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) {
                CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, true, OrgStoreStatusEnum.AUDIT, 0, null, enableDate);
                newStorageOrgIds.add(notLeafOrgId);
            } else {
                Integer lastDseq;
                DynamicObject newOrg = null;
                Date disabledDate = null;
                if (!id2newId.containsKey(notLeafOrgId)) {
                    newId = GlobalIdUtil.genGlobalLongId();
                    newOrg = (DynamicObject)OrmUtils.clone((IDataEntityBase)notLeafOrg, (boolean)true, (boolean)true);
                    id2newId.put(notLeafOrgId, newId);
                    newOrg.set("id", (Object)newId);
                    disabledDate = CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, 1, null, enableDate);
                } else {
                    DynamicObjectCollection bizchangerds = notLeafOrg.getDynamicObjectCollection("bizchangerds");
                    disabledDate = ((DynamicObject)bizchangerds.get(bizchangerds.size() - 1)).getDate("bizeffdate");
                    newId = id2newId.get(notLeafOrgId);
                    newOrg = toSaveOrgs.get(newId);
                }
                if (parentOrg != null && (lastDseq = parentId2lastDseq.get(parentOrg.getLong("id"))) != null) {
                    newOrg.set("dseq", (Object)(lastDseq + 1));
                    parentId2lastDseq.put(parentOrg.getLong("id"), lastDseq + 1);
                }
                List<DynamicObject> list = groupByNotLeaf.get(notLeafOrgId);
                boolean existActive = false;
                for (DynamicObject dy : list) {
                    if (!dy.getString("status").equals(OrgStoreStatusEnum.TEMPSAVE.getValue()) && !dy.getString("status").equals(OrgStoreStatusEnum.AUDIT.getValue())) continue;
                    existActive = true;
                    break;
                }
                if (!existActive) {
                    newOrg.set("isleaf", (Object)true);
                    CslSchemeUtils.updateOrgAttribute(newOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 0, null, disabledDate);
                } else {
                    CslSchemeUtils.updateOrgAttribute(newOrg, schemeNumber, changedParentNumbers, toSaveOrgs, true, OrgStoreStatusEnum.AUDIT, 0, null, disabledDate);
                    newStorageOrgIds.add(newId);
                }
                id2NotLeafOrg.put(newId, newOrg);
            }
            changedParentNumbers.add(number);
        } else if (notLeafOrg.getString("status").equals(OrgStoreStatusEnum.AUDIT.getValue())) {
            newId = GlobalIdUtil.genGlobalLongId();
            DynamicObject newOrg = (DynamicObject)OrmUtils.clone((IDataEntityBase)notLeafOrg, (boolean)true, (boolean)true);
            id2newId.put(notLeafOrgId, newId);
            newOrg.set("id", (Object)newId);
            Date disabledDate = CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, 1, null, enableDate);
            CslSchemeUtils.updateOrgAttribute(newOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 1, null, disabledDate);
            id2NotLeafOrg.put(newId, newOrg);
        } else if (notLeafOrg.getString("status").equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) {
            CslSchemeUtils.updateOrgAttribute(notLeafOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, 1, null, enableDate);
        }
        List<DynamicObject> list = null;
        if (newId != 0L) {
            list = groupByNotLeaf.get(newId);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                groupByNotLeaf.put(newId, list);
            } else {
                list.forEach(org -> {
                    if (org.getBoolean("isleaf")) {
                        org.set("share", (Object)0);
                        toSaveOrgs.put(org.getLong("id"), (DynamicObject)org);
                    }
                });
                return;
            }
        }
        for (DynamicObject child : groupByNotLeaf.get(notLeafOrgId)) {
            DynamicObject newOrg = null;
            if (child.getBoolean("isleaf")) {
                if (child.getString("status").equals(OrgStoreStatusEnum.TEMPSAVE.getValue())) {
                    CslSchemeUtils.updateOrgAttribute(child, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, isChanged ? 0 : 1, id2NotLeafOrg.get(newId), enableDate);
                } else if (child.getString("status").equals(OrgStoreStatusEnum.AUDIT.getValue())) {
                    newOrg = (DynamicObject)OrmUtils.clone((IDataEntityBase)child, (boolean)true, (boolean)true);
                    Date disabledDate = CslSchemeUtils.updateOrgAttribute(child, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, isChanged ? 0 : 1, null, enableDate);
                    CslSchemeUtils.updateOrgAttribute(newOrg, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.AUDIT, isChanged ? 0 : 1, id2NotLeafOrg.get(newId), disabledDate);
                } else if (child.getString("status").equals(OrgStoreStatusEnum.REMOVE.getValue())) {
                    CslSchemeUtils.updateOrgAttribute(child, schemeNumber, changedParentNumbers, toSaveOrgs, false, OrgStoreStatusEnum.DISABLE, isChanged ? 0 : 1, null, enableDate);
                }
            }
            if (newId == 0L) continue;
            if (newOrg != null && list != null) {
                list.add(newOrg);
            }
            if (!child.getString("status").equals(OrgStoreStatusEnum.AUDIT.getValue()) && (child.getBoolean("isleaf") || child.getString("status").equals(OrgStoreStatusEnum.REMOVE.getValue())) || list == null) continue;
            list.add(child);
        }
    }

    private static boolean isStructChange(DynamicObject notLeafOrg, List<DynamicObject> children, DynamicObject copyfromOrg, List<DynamicObject> copyfromChild, Map<String, DynamicObject> newCurrency) {
        if (children == null || copyfromChild == null) {
            return false;
        }
        if (notLeafOrg.getDynamicObject("currency").getLong("id") != copyfromOrg.getDynamicObject("currency").getLong("id")) {
            newCurrency.put(notLeafOrg.getDynamicObject("currency").getString("number"), notLeafOrg.getDynamicObject("currency"));
            return true;
        }
        if (children.size() != copyfromChild.size()) {
            return true;
        }
        HashMap number2Dy = new HashMap(16);
        copyfromChild.forEach(o -> number2Dy.put(o.getString("number"), o));
        for (DynamicObject o2 : children) {
            DynamicObject n = (DynamicObject)number2Dy.get(o2.getString("number"));
            if (n != null && !o2.getString("status").equals(OrgStoreStatusEnum.REMOVE.getValue())) continue;
            return true;
        }
        return false;
    }

    private static Date setBizchangerds(DynamicObjectCollection bizRecords, boolean isAdd, Date addBizeffdate, boolean isRoot) {
        DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
        Date disabledDate = null;
        if (isAdd) {
            Date effDate = addBizeffdate;
            if (isRoot || bizRecords.isEmpty()) {
                bizRecords.clear();
                if (!bizRecords.isEmpty()) {
                    effDate = ((DynamicObject)bizRecords.get(0)).getDate("bizeffdate");
                }
                if (addBizeffdate.compareTo(effDate) <= 0) {
                    bizRecord.set("bizeffdate", (Object)effDate);
                } else {
                    bizRecord.set("bizeffdate", (Object)addBizeffdate);
                }
                bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
                bizRecord.set("seq", (Object)1);
                bizRecord.set("bizmodifier", (Object)RequestContext.get().getCurrUserId());
                bizRecord.set("bizmodifytime", (Object)new Date());
                bizRecords.add((Object)bizRecord);
            }
        } else {
            bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.disable.getValue());
            bizRecord.set("seq", (Object)(bizRecords.size() + 1));
            DynamicObject rd = (DynamicObject)bizRecords.get(bizRecords.size() - 1);
            Date oldBizeffdate = rd.getDate("bizeffdate");
            if (addBizeffdate.compareTo(oldBizeffdate) <= 0) {
                rd.set("bizeffdate", (Object)DateTimeUtils.getDayAround((Date)oldBizeffdate, (int)-1));
                rd.set("bizexpdate", (Object)DateTimeUtils.getDayAround((Date)oldBizeffdate, (int)-1));
                bizRecord.set("bizeffdate", (Object)oldBizeffdate);
                disabledDate = oldBizeffdate;
            } else {
                rd.set("bizexpdate", (Object)DateTimeUtils.getDayAround((Date)addBizeffdate, (int)-1));
                bizRecord.set("bizeffdate", (Object)addBizeffdate);
                disabledDate = addBizeffdate;
            }
            bizRecord.set("bizmodifier", (Object)RequestContext.get().getUserId());
            bizRecord.set("bizmodifytime", (Object)new Date());
            bizRecords.add((Object)bizRecord);
        }
        return disabledDate;
    }

    private static Date updateOrgAttribute(DynamicObject org, String schemeNumber, Set<String> changedParentNumbers, Map<Long, DynamicObject> toSaveOrgs, boolean isChangeNumber, OrgStoreStatusEnum status, int shareValue, DynamicObject newOrg, Date addBizeffdate) {
        String number = org.getString("number");
        if (isChangeNumber) {
            org.set("number", (Object)(number + schemeNumber));
            org.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
            org.set("copyfrom", null);
            org.set("copyfrom", (Object)0);
            org.set("issysmember", (Object)DimMemTypeEnum.UNSYSMEM.getIndex());
        }
        if (status == OrgStoreStatusEnum.AUDIT) {
            CharSequence[] sp = org.getString("longnumber").split("\\!");
            for (int i = 0; i < sp.length; ++i) {
                if (!changedParentNumbers.contains(sp[i]) && (!isChangeNumber || i != sp.length - 1)) continue;
                sp[i] = (String)sp[i] + schemeNumber;
            }
            org.set("longnumber", (Object)String.join((CharSequence)String.valueOf('!'), sp));
            org.set("share", (Object)shareValue);
        }
        if (newOrg != null) {
            if (org.getString("status").equals(OrgStoreStatusEnum.AUDIT.getValue())) {
                org.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            }
            org.set("parent", (Object)newOrg);
        }
        org.set("status", (Object)status.getValue());
        boolean isAdd = status == OrgStoreStatusEnum.AUDIT;
        boolean isRoot = false;
        if (org.get("parent") != null) {
            isRoot = !StorageTypeEnum.SHARE.getOIndex().equals(((DynamicObject)org.get("parent")).getString("storagetype"));
        }
        Date disabledDate = CslSchemeUtils.setBizchangerds(org.getDynamicObjectCollection("bizchangerds"), isAdd, addBizeffdate, isRoot);
        toSaveOrgs.put(org.getLong("id"), org);
        return disabledDate;
    }

    private static void createMcOrICMember(DynamicObject treeMem, boolean isIc, int seq, Long dimensionId, Long parentId, List<DynamicObject> toSaveMember, List<DynamicObject> toSaveMemberTree) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)(isIc ? "bcm_intercompanymember" : "bcm_mycompanymember"));
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)member);
        member.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        member.set("number", treeMem.get("number"));
        member.set("name", treeMem.get("name"));
        member.set("simplename", treeMem.get("simplename"));
        member.set("model", treeMem.get("model"));
        member.set("dimension", (Object)dimensionId);
        toSaveMember.add(member);
        DynamicObject memberTree = BusinessDataServiceHelper.newDynamicObject((String)(isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree"));
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)memberTree);
        memberTree.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        memberTree.set("member", (Object)member);
        memberTree.set("number", treeMem.get("number"));
        memberTree.set("name", treeMem.get("name"));
        StringBuilder longnumber = new StringBuilder();
        if (isIc) {
            longnumber.append("InternalCompany").append('!').append("ICTotal").append('!').append("ICEntity").append('!').append(treeMem.getString("number"));
        } else {
            longnumber.append("MyCompany").append('!').append(treeMem.getString("number"));
        }
        memberTree.set("longnumber", (Object)longnumber.toString());
        memberTree.set("storagetype", (Object)4);
        memberTree.set("aggoprt", treeMem.get("aggoprt"));
        memberTree.set("description", treeMem.get("description"));
        memberTree.set("model", treeMem.get("model"));
        memberTree.set("dimension", (Object)dimensionId);
        memberTree.set("issysmember", (Object)2);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)(isIc ? 3 : 2));
        memberTree.set("dseq", (Object)seq);
        memberTree.set("parent", (Object)parentId);
        toSaveMemberTree.add(memberTree);
    }

    public static void updateCslSchemeStatus(Long schemeId, boolean status, IFormView view, String msg) {
        DynamicObject cslscheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"bcm_cslscheme", (String)"isenable, modifier, modifytime");
        cslscheme.set("isenable", (Object)status);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)RequestContext.get().getUserId());
        cslscheme.set("modifier", (Object)user);
        cslscheme.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cslscheme});
        if (view != null) {
            view.showSuccessNotification(msg);
        }
    }

    private static /* synthetic */ void lambda$handleEnable$21(Multimap multimap, String number) {
        multimap.put((Object)"ICEntity", (Object)Pair.onePair((Object)number, (Object)AggOprtEnum.ADD.getIntSign()));
    }

    private static /* synthetic */ void lambda$filterAutoMergeOrgStatus$8(List allOrgIds, Map orgMap, Multimap member2orgsMapping, DynamicObject row) {
        allOrgIds.add(row.getLong("id"));
        orgMap.put(row.getLong("id"), row.getString("number"));
        member2orgsMapping.put((Object)row.getLong("member"), (Object)row.getLong("id"));
    }

    private static /* synthetic */ void lambda$getCommonSettingOrgs$2(Set allOrgSetting, Multimap member2orgsMapping, DynamicObject row) {
        allOrgSetting.add(row.getLong("id"));
        member2orgsMapping.put((Object)row.getLong("member"), (Object)row.getLong("id"));
    }
}

