/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.util.TreeEntryEntityUtil;

public class CslSchemeViewPlugin
extends AbstractFormPlugin {
    private static final String treeentryentity = "treeentryentity";
    private static final String selector = "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,isleaf,level,currency.name as currency,ctrlorg.name as ctrlorg,isinnerorg, bizchangerds.changetype as bizchangetype, bizchangerds.bizeffdate as bizeffdate";
    private static final List<String> property = Arrays.asList("number", "name", "aggoprt", "storagetype", "currency", "ctrlorg", "isinnerorg", "bizchangetype", "bizeffdate", "memberid");
    private static final String CSLSCHEMEID = "cslschemeId";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntry.addCellClickListener(new TreeNodeQueryListener(){

            public void queryTreeNodeChildren(TreeNodeEvent arg0) {
                CslSchemeViewPlugin.this.addChildRows(arg0);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTreeByCslschemeId();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void initTreeByCslschemeId() {
        Long cslschemeId = (Long)this.getView().getFormShowParameter().getCustomParam(CSLSCHEMEID);
        QFBuilder qf = new QFBuilder("cslscheme", "=", (Object)cslschemeId);
        qf.add("level", "in", Arrays.asList(2, 3));
        qf.add(QFilter.isNull((String)"bizchangerds.bizexpdate"));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selector, (QFilter[])qf.toArray(), (String)"level, dseq");
        if (orgs.isEmpty()) {
            return;
        }
        Long parentId = ((DynamicObject)orgs.get(0)).getLong("parent");
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), orgs, property, true, parentId, modelId);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeEntry.setCollapse(true);
        treeEntry.expandOne(0);
        this.getView().updateView(treeentryentity);
        this.getPageCache().put(CSLSCHEMEID, cslschemeId.toString());
    }

    private void addChildRows(TreeNodeEvent evt) {
        DynamicObject obj = this.getModel().getEntryRowEntity(treeentryentity, evt.getRowKey());
        long pid = obj.getLong("memberid");
        DynamicObject next = this.getModel().getEntryRowEntity(treeentryentity, evt.getRowKey() + 1);
        if (next != null && next.getLong("pid") == obj.getLong("id") && StringUtils.isNotEmpty((CharSequence)next.getString("number").trim())) {
            return;
        }
        QFBuilder qf = new QFBuilder("parent.id", "=", (Object)pid);
        qf.add(QFilter.isNull((String)"bizchangerds.bizexpdate"));
        DynamicObjectCollection members = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)selector, (QFilter[])qf.toArray(), (String)"dseq");
        this.assignBizChangeTypeValue(members);
        TreeEntryEntityUtil.insertTreeEntryRows(this.getView(), members, property, evt.getRowKey(), pid, false, true);
        this.getView().updateView(treeentryentity);
    }

    private void assignBizChangeTypeValue(DynamicObjectCollection members) {
        Map invChangetypeModel = InvestServiceHelper.getInvChangetypeModel((Long)((Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        List dcs = invChangetypeModel.values().stream().filter(x -> !TreeEntryEntityUtil.isContainsNumber(x.number()) && (x.GetIsdefault() || !"0".equals(x.change()))).collect(Collectors.toList());
        Map<String, String> result = dcs.stream().collect(Collectors.toMap(x -> x.number(), y -> y.name()));
        result.put("BD000", ResManager.loadKDString((String)"\u7981\u7528", (String)"OpItemEnum_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        for (DynamicObject x2 : members) {
            x2.set("bizchangetype", (Object)result.get(x2.getString("bizchangetype")));
        }
    }
}

