/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.cslscheme;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustEntryConfig;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.scheme.AdjustCvtCurrencyScheme;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimension;

public class RptAdjustEntryCopyHelper {
    public static DynamicObject queryEntryExChange(long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)"bcm_entryexchange", (String)"account,changetype,mycompany,internalcompany,multigaap,audittrail,dim1,dim2,dim3,dim4,dim5,dim6", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isEntryExchangeRate(long modelId) {
        return true;
    }

    public static List<DynamicObject> getUserDefindedList(Long modelId, Long yearId, Long scenarioId, Long periodId) {
        if (scenarioId == null || yearId == null || periodId == null) {
            return null;
        }
        SimpleVo sceneSimple = SimpleVo.newOne(null, (Long)scenarioId);
        SimpleVo fySimple = SimpleVo.newOne(null, (Long)yearId);
        SimpleVo periodSimple = SimpleVo.newOne(null, (Long)periodId);
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        String key = "userdefinedformula|" + modelId + "|" + scenarioId + yearId + periodId;
        List udfs = (List)GlobalCacheServiceHelper.getOrLoadNode((String)key, () -> {
            DynamicObject[] udfstmp = BusinessDataServiceHelper.load((String)"bcm_userdefcvtformula", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdefcvtformula").getAllFields().keySet()), (QFilter[])qf.toArray());
            List yearIdsList = DimensionServiceHelper.getYearIdsByModel((long)modelId);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(20);
            Collections.addAll(list, udfstmp);
            list.removeIf(udf -> {
                DynamicObjectCollection effectives = udf.getDynamicObjectCollection("effective");
                return udf.getDynamicObject("scenario") != null && udf.getDynamicObject("scenario").getLong("id") != sceneSimple.id.longValue() || !ConvertDifferenceHandle.isApply((Long)fySimple.id, (Long)periodSimple.id, (DynamicObjectCollection)effectives, (List)yearIdsList);
            });
            return list;
        });
        return udfs;
    }

    public static Map<Integer, List<DynamicObject>> createSeqGroup(List<DynamicObject> udfsClone) {
        TreeMap<Integer, List<DynamicObject>> seqGroup = new TreeMap<Integer, List<DynamicObject>>();
        for (DynamicObject dy : udfsClone) {
            Integer priority = dy.getInt("executionorder");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)seqGroup.get(priority);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                seqGroup.put(priority, list);
            }
            list.add(dy);
        }
        return seqGroup;
    }

    public static String getConvertRateNumber4UserDef(Long modelId, Map<String, Pair<Long, String>> yearAndScenAndPeriod, Map<String, String[]> scopeMap, String orgId, String orgNumber, Map<Integer, List<DynamicObject>> seqUserDefGroupNotFilter, Long srcCurrencyId, String srcCurrencyNum, Long targetCurrencyId, String targetCurrencyNum) {
        if (modelId == 0L || scopeMap == null || scopeMap.isEmpty()) {
            return null;
        }
        List cvtPaths = RptAdjustEntryCopyHelper.getCvtPath(srcCurrencyId, srcCurrencyNum, targetCurrencyId, targetCurrencyNum).toList();
        Pair model = Pair.onePair((Object)modelId, (Object)QueryDimensionServiceHelper.getModelNumber((long)modelId));
        Pair entity = Pair.onePair((Object)Long.parseLong(orgId), (Object)orgNumber);
        return ConvertServiceHelper.getUserDefindedRateNumber((List)cvtPaths, (Pair)model, (Pair)entity, yearAndScenAndPeriod.get(PresetConstant.FY_DIM), yearAndScenAndPeriod.get(PresetConstant.PERIOD_DIM), yearAndScenAndPeriod.get(PresetConstant.SCENE_DIM), scopeMap, seqUserDefGroupNotFilter);
    }

    public static PairList<Long, String> getCvtPath(Long srcCurrencyId, String srcCurrencyNum, Long targetCurrencyId, String targetCurrencyNum) {
        PairList path = new PairList();
        if (srcCurrencyNum == null) {
            srcCurrencyNum = BusinessDataServiceHelper.loadSingleFromCache((Object)srcCurrencyId, (String)"bcm_currencymembertree", (String)"number").getString("number");
        }
        path.addPair((Object)srcCurrencyId, (Object)srcCurrencyNum);
        path.addPair((Object)targetCurrencyId, (Object)targetCurrencyNum);
        return path;
    }

    public static Map<Integer, List<DynamicObject>> getSeqGroupNotFilter(Long modelId, Map<String, Pair<Long, String>> yearAndScenAndPeriod) {
        List<DynamicObject> userDefindedList = RptAdjustEntryCopyHelper.getUserDefindedList(modelId, (Long)yearAndScenAndPeriod.get((Object)PresetConstant.FY_DIM).p1, (Long)yearAndScenAndPeriod.get((Object)PresetConstant.SCENE_DIM).p1, (Long)yearAndScenAndPeriod.get((Object)PresetConstant.PERIOD_DIM).p1);
        if (userDefindedList == null) {
            return null;
        }
        return RptAdjustEntryCopyHelper.createSeqGroup(userDefindedList);
    }

    public static Map getAcctTypeAndChangeWay(Long modelId, List<String> acctNums, List<String> changeTypeNums) {
        HashMap acctTypeAndChangeWayMap = new HashMap();
        if (!acctNums.isEmpty()) {
            HashMap acctExchangeMap = new HashMap();
            RptAdjustEntryCopyHelper.executeQuery(modelId, "bcm_accountmembertree", "number,exchange", acctNums::toArray, e -> acctExchangeMap.put(e.getString("number"), ExchangeEnum.getExchangeEnumByIndex((String)e.getString("exchange"))));
            acctTypeAndChangeWayMap.put("Account", acctExchangeMap);
        }
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)modelId)) && !changeTypeNums.isEmpty()) {
            HashMap changeTypeMap = new HashMap();
            RptAdjustEntryCopyHelper.executeQuery(modelId, "bcm_changetypemembertree", "number,changeway", changeTypeNums::toArray, e -> changeTypeMap.put(e.getString("number"), ChangewayEnum.getChangewayEnumByIndex((String)e.getString("changeway"))));
            acctTypeAndChangeWayMap.put("ChangeType", changeTypeMap);
        }
        return acctTypeAndChangeWayMap;
    }

    public static void executeQuery(Long modelId, String entity, String fields, Supplier<Object[]> filterVals, Consumer<DynamicObject> cs) {
        Collection coll = BusinessDataServiceHelper.loadFromCache((String)entity, (String)fields, (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).add("number", "in", (Object)filterVals.get()).toArray()).values();
        coll.forEach(e -> cs.accept((DynamicObject)e));
    }

    public static Set<Long> getMultipleCurrency(long modelId, long orgId, String businessType) {
        Optional<AdjustCvtCurrencyScheme> schemeOp = AdjustEntryConfig.get().getAdjustCvtCurrencySchemes(Long.valueOf(modelId)).stream().filter(scheme -> scheme.ishit(orgId, businessType)).findFirst();
        if (schemeOp.isPresent()) {
            return schemeOp.get().getCurIds();
        }
        return Collections.emptySet();
    }

    private static List<DimMember> getCurrencyResultList(long modelId) {
        ArrayList currencyList = Lists.newArrayList();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("isleaf", "=", (Object)true);
        filter.and(new QFilter("status", "<>", (Object)Character.valueOf('E')));
        filter.and(new QFilter("number", "<>", (Object)"EC"));
        filter.and(new QFilter("number", "<>", (Object)"DC"));
        filter.and(new QFilter("number", "<>", (Object)"PC"));
        filter.and(new QFilter("number", "<>", (Object)"CNone"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : col) {
            Dimension dim = new Dimension(null, SysDimensionEnum.Currency.getNumber(), null);
            DimMember memb = new DimMember(obj.getString("name"), obj.getString("number"), null, (IDimension)dim);
            currencyList.add(memb);
        }
        return currencyList;
    }
}

