/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.database;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.export.ExportUtil;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.vo.ImportResult;
import org.apache.commons.lang3.StringUtils;

public class HBLDataImportErrorTipsPlugin
extends AbstractBaseFormPlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BCM_DATA_IMPORT_RESULT = "bcm_dataimportresult";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(BTN_OK);
        this.addClickListeners(BTN_EXPORT);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List importResults = (List)this.deSerializedBytes(parameter.getCustomParam("msg").toString());
        for (ImportResult importResult : importResults) {
            int index = this.getModel().createNewEntryRow("listresults");
            this.getModel().setValue("dims", (Object)importResult.getDims(), index);
            this.getModel().setValue("ischeck", (Object)importResult.isCheckStatus(), index);
            this.getModel().setValue("error", (Object)importResult.getError(), index);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_ok": {
                this.getView().close();
                break;
            }
            case "btn_export": {
                this.export();
                break;
            }
        }
    }

    private void export() {
        String filename = ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u5bfc\u5165\u9519\u8bef\u63d0\u793a\u6570\u636e\u3002", (String)"HBLDataImportErrorTipsPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"bcm_dataimportresult_EXPT_S"), new QFilter("bizobject.number", "=", (Object)BCM_DATA_IMPORT_RESULT)};
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)2);
        FormView formView = (FormView)this.getView();
        String routeAppId = formView.getFormShowParameter().getServiceAppId();
        List importResults = (List)this.deSerializedBytes(this.getView().getFormShowParameter().getCustomParam("msg").toString());
        ArrayList<DynamicObject> doList = new ArrayList<DynamicObject>(importResults.size());
        for (ImportResult importResult : importResults) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)BCM_DATA_IMPORT_RESULT);
            dy.set("dims", (Object)importResult.getDims());
            dy.set("ischeck", (Object)importResult.isCheckStatus());
            dy.set("error", (Object)importResult.getError());
            doList.add(dy);
        }
        try {
            String url = ExportUtil.export((DynamicObject[])doList.toArray(new DynamicObject[0]), pkIds.get(0), (String)routeAppId, (String)BCM_DATA_IMPORT_RESULT, (String)(filename + ".xlsx"));
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                this.downloadFile(url, "bcm_dataimport", "47150e89000000ac");
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"HBLDataImportErrorTipsPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }
}

