/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.database;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.model.ModelOlapDataOpeLogEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.HBLDataImportProgress;
import kd.fi.bcm.formplugin.database.vo.ImportResult;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import org.apache.commons.collections.CollectionUtils;

public class HBLDataImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener,
ProgresssListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(HBLDataImportPlugin.class);
    private static final String model = "model";
    private static final String dimension = "dimension";
    private static final String index = "index";
    private static final String ctl_default = "default";
    private static final String entryentity = "entryentity";
    private static final String CACHE_URL = "cache_url";
    private static final String METRIC_NAME = "FMONEY";
    private static final String TOOLBAR_PANEL = "toolbarap";
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String PROGRESSBAR_PANEL = "progressbarap";
    private static final String BCM_DATA_IMPORT_ERROR_TIPS = "bcm_dataimporterrortips";
    private static final String DELIMITER = ",";
    private static final String TEXT_FORMAT = "txt";
    private static final String ISMANAGER = "ISMANAGER";
    private static final String PARENTFORMID = "parentFormId";

    private OpNameMultiLangEnumBridge getOperationImport() {
        return new OpNameMultiLangEnumBridge("\u5bfc\u5165", "HBLDataImportPlugin_0", "fi-bcm-formplugin", "import");
    }

    private String getOperationStatusSuccess() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"HBLDataImportPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private String getOperationStatusFail() {
        return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"HBLDataImportPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
    }

    private OPDescMultiLangEnumBridge getOperationStatusSuccessNew() {
        return new OPDescMultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u3002", "HBLDataImportPlugin_1", "fi-bcm-formplugin", null);
    }

    private OPDescMultiLangEnumBridge getOperationStatusFailNew() {
        return new OPDescMultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25", "HBLDataImportPlugin_2", "fi-bcm-formplugin", null);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(ctl_default);
        this.addItemClickListeners(TOOLBAR_PANEL);
        AttachmentPanel attach = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        attach.addUploadListener((UploadListener)this);
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBAR_PANEL);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (model.equals(name)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String billFormId = "";
            if (this.getView() != null && this.getView().getFormShowParameter().getCustomParams().containsKey(PARENTFORMID)) {
                billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTFORMID);
            }
            ApplicationTypeEnum sign = ModelUtil.queryApp((IFormView)this.getView());
            showParameter.setCustomParam(ISMANAGER, (Object)MemberPermHelper.isManager((ApplicationTypeEnum)sign, (String)billFormId));
            Set modelIds = MemberPermHelper.getLimitedModelListByUser((String)billFormId, (ApplicationTypeEnum)sign);
            QFilter qFilter = new QFilter("id", "in", (Object)modelIds);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(qFilter);
            QFilter qf = null;
            if (ApplicationTypeEnum.CM == sign) {
                qf = new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex());
            } else if (ApplicationTypeEnum.RPT == sign) {
                qf = new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.PUB.getOIndex()).or(new QFilter("model.ReportType", "=", (Object)ApplicationTypeEnum.RPT.getOIndex()));
            }
            qFilters.add(qf);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btn_import".equals(itemKey)) {
            Set<String> cachedUrl = this.getCachedUrl();
            if (CollectionUtils.isEmpty(cachedUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9700\u8981\u5bfc\u5165\u7684\u6587\u4ef6\u3002", (String)"HBLDataImportPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (cachedUrl.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bfc\u5165\u4e00\u4e2a\u6587\u4ef6\u3002", (String)"HBLDataImportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            ProgressBar progressbarap = (ProgressBar)this.getControl(PROGRESSBAR_PANEL);
            progressbarap.start();
            progressbarap.setPercent(0);
            this.getView().setVisible(Boolean.TRUE, new String[]{PROGRESSBAR_PANEL});
            new HBLDataImportProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u5bfc\u5165", (String)"HBLDataImportPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(this.getView());
            this.getView().getFormShowParameter().setAppId(ApplicationTypeEnum.CM.appnum);
            HBLDataImport dataImport = new HBLDataImport(cachedUrl.size());
            for (String file_url : cachedUrl) {
                try {
                    String id;
                    TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
                    String[] reqParams = new URL(file_url).getQuery().split("&");
                    HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                    for (String param : reqParams) {
                        String[] p = param.split("=");
                        map.put(p[0], p[1]);
                    }
                    String configkey = (String)map.get("configKey");
                    TempFileCacheDownloadable.Content content = fileCache.get(configkey, id = (String)map.get("id"));
                    if (content == null) continue;
                    if (!this.checkTextFormat(content)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u53ea\u80fd\u662ftxt\u683c\u5f0f\u3002", (String)"HBLDataImportPlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    BatchProcessHelper.handleAsync(() -> dataImport.importData(fileCache, configkey, id));
                }
                catch (Exception e) {
                    log.error("error", (Throwable)e);
                    this.writeMultiLangLog(this.getOperationImport(), this.getOperationStatusFailNew());
                    throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)e.getMessage()), new Object[0]);
                }
            }
        } else if ("btn_tpl".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection mappingCollection = dataEntity.getDynamicObjectCollection(entryentity);
            HBLDataImport hblDataImport = new HBLDataImport();
            hblDataImport.check(mappingCollection);
            try {
                List sortedList = mappingCollection.stream().filter(v -> org.apache.commons.lang3.math.NumberUtils.isDigits((String)v.getString(index))).sorted(Comparator.comparingInt(v -> Integer.parseInt(v.getString(index)))).collect(Collectors.toList());
                String headText = sortedList.stream().map(v -> v.getDynamicObject(dimension).getString("name")).collect(Collectors.joining(";"));
                String lineSeparator = "\r\n";
                String content = String.format(ResManager.loadKDString((String)"!DATA!;!true%1$s%2$s%3$s\u91d1\u989d\uff08\u8bf7\u53c2\u7167\u6b64\u683c\u5f0f\u586b\u5199\u6570\u636e\uff0c\u6bcf\u6761\u6570\u636e\u5360\u4e00\u884c\uff09", (String)"HBLDataImportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), lineSeparator, headText, StringUtils.isNotBlank((CharSequence)headText) ? ";" : "");
                String url = ImportAndExportUtil.writeJsFile(content, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u6a21\u7248", (String)"HBLDataImportPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), TEXT_FORMAT);
                this.getView().download(url);
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else if ("btn_flush".equals(itemKey)) {
            this.initMappingEntry();
            this.getView().updateView(entryentity);
            Control attachmentControl = this.getView().getControl(ATTACHMENT_PANEL);
            AttachmentPanel panel = (AttachmentPanel)attachmentControl;
            List attachmentData = panel.getAttachmentData();
            attachmentData.forEach(arg_0 -> ((AttachmentPanel)panel).remove(arg_0));
            this.getView().updateView(ATTACHMENT_PANEL);
        }
    }

    private void saveOpeLogOfOlaoData(Boolean opeResult, String reason) {
        BatchProcessHelper.handleAsync(() -> {
            DynamicObject dyLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_olapdata_opelog");
            long modelId = this.getModelId();
            dyLog.set(model, (Object)modelId);
            dyLog.set("operesult", (Object)(opeResult != false ? "1" : "2"));
            dyLog.set("opetype", (Object)ModelOlapDataOpeLogEnum.OPE_IMPORT.getCode());
            dyLog.set("reason", (Object)(opeResult != false ? "" : reason));
            dyLog.set("traceid", (Object)RequestContext.get().getTraceId());
            dyLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyLog.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyLog});
        });
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String changeFieldName = e.getProperty().getName();
        if (model.equals(changeFieldName)) {
            this.dimensionAddModelFilter();
            this.initMappingEntry();
            String modelId = UserSelectUtil.getF7SelectId(this.getView(), model);
            if (modelId == null) {
                this.getModel().setValue(model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
            } else {
                if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    return;
                }
                this.getPageCache().put("KEY_MODEL_ID", modelId);
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
            }
        } else if (index.equals(changeFieldName) && (changeData = e.getChangeSet()[0]).getNewValue() != null) {
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue(ctl_default, null, rowIndex);
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        Set<String> urlSet = this.getCachedUrl();
        for (Object url : urls) {
            Map urlTemp = (Map)url;
            urlSet.add((String)urlTemp.get("url"));
        }
        this.saveUrlCache(urlSet);
    }

    public void afterRemove(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        Set<String> urlSet = this.getCachedUrl();
        for (Object url : urls) {
            Map urlTemp = (Map)url;
            urlSet.remove(urlTemp.get("url"));
        }
        this.saveUrlCache(urlSet);
    }

    private Set<String> getCachedUrl() {
        Set urlSet = Sets.newHashSet();
        String cacheUrl = this.getPageCache().get(CACHE_URL);
        if (StringUtil.isNotEmpty((CharSequence)cacheUrl)) {
            urlSet = (Set)ObjectSerialUtil.deSerializedBytes((String)cacheUrl);
        }
        return urlSet;
    }

    private void saveUrlCache(Set<String> urlSet) {
        if (CollectionUtils.isEmpty(urlSet)) {
            this.getPageCache().remove(CACHE_URL);
            return;
        }
        this.getPageCache().put(CACHE_URL, ObjectSerialUtil.toByteSerialized(urlSet));
    }

    @Override
    public void afterBindData(EventObject e) {
        this.dimensionAddModelFilter();
    }

    private void dimensionAddModelFilter() {
        BasedataEdit tagClassEdit = (BasedataEdit)this.getControl(dimension);
        tagClassEdit.setQFilter(QFilter.of((String)"model = ?", (Object[])new Object[]{this.getModelId()}));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBAR_PANEL});
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        Object modelIdCust = showParam.getCustomParam("modelIdCust");
        if (modelIdCust == null) {
            return;
        }
        if (modelIdCust.equals(0)) {
            String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), model);
            if (StringUtils.isNotEmpty((CharSequence)modelId)) {
                this.getModel().setValue(model, (Object)Long.valueOf(modelId));
                this.getPageCache().put("KEY_MODEL_ID", modelId);
            }
        } else {
            this.getModel().setValue(model, (Object)ConvertUtil.convertObjToLong((Object)modelIdCust));
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelIdCust));
        }
        this.initMappingEntry();
    }

    private void initMappingEntry() {
        List<Long> dimensionIds = this.getAllDimensionIds();
        if (CollectionUtils.isEmpty(dimensionIds)) {
            return;
        }
        this.setInitEntryValue(dimensionIds);
    }

    private List<Long> getAllDimensionIds() {
        return DimensionServiceHelper.getDimensionIdListByModel((Object)this.getModelId());
    }

    private void setInitEntryValue(List<Long> dimensionIds) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(entryentity);
        int size = dimensionIds.size();
        dataModel.batchCreateNewEntryRow(entryentity, size);
        for (int i = 0; i < size; ++i) {
            Long dimensionId = dimensionIds.get(i);
            dataModel.setValue(dimension, (Object)dimensionId, i);
            dataModel.setValue(index, (Object)(i + 1), i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{index});
        }
    }

    @Override
    public long getModelId() {
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(model);
        if (modelDyn != null) {
            return modelDyn.getLong("id");
        }
        return 0L;
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBAR_PANEL);
        HBLDataImportProgress progressData = HBLDataImportProgress.fromCache(this.getView());
        if (Objects.nonNull(progressData)) {
            int percent = progressData.getPercent();
            String message = progressData.getMessage();
            List<ImportResult> detailInfoList = progressData.getDetailInfoList();
            if (percent == -1) {
                progressEvent.setProgress(0);
                progressbar.stop();
                this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBAR_PANEL});
                if (detailInfoList == null || detailInfoList.isEmpty()) {
                    this.getView().showTipNotification(message);
                    this.saveOpeLogOfOlaoData(Boolean.FALSE, message);
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(BCM_DATA_IMPORT_ERROR_TIPS);
                parameter.setCaption(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"HBLDataImportPlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("msg", (Object)this.toByteSerialized(detailInfoList));
                this.getView().showForm(parameter);
                this.writeMultiLangLog(this.getOperationImport(), this.getOperationStatusFailNew());
            } else {
                progressEvent.setProgress(percent);
                if (percent == 100) {
                    this.getView().showSuccessNotification(this.getOperationStatusSuccess());
                    progressbar.stop();
                    this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBAR_PANEL});
                    this.writeMultiLangLog(this.getOperationImport(), this.getOperationStatusSuccessNew());
                }
            }
        }
    }

    public boolean checkTextFormat(TempFileCacheDownloadable.Content content) {
        String filename = content.getFilename();
        if (filename == null) {
            return false;
        }
        String textFormat = filename.substring(filename.lastIndexOf(".") + 1);
        return TEXT_FORMAT.equalsIgnoreCase(textFormat);
    }

    private class HBLDataImport {
        private OperationResult result = null;
        private List<String> rowDatas = null;
        private String[] dimKeys;
        private String modelNumber;
        private String separator;
        private int lineNum;
        private final Multimap<String, String[]> tempSaveData = LinkedListMultimap.create();
        private final Multimap<String, String[]> waitSaveData = LinkedListMultimap.create();
        private List<ImportResult> importResults = new ArrayList<ImportResult>(10);
        private final List<String> dimOrder = Stream.of("Entity", "Scenario", "Year", "Period").collect(Collectors.toList());

        public HBLDataImport() {
        }

        public HBLDataImport(int count) {
            this.initDimIndexMappingAndDefaultValue();
            this.result = new OperationResult();
            this.result.setBillCount(count);
            this.rowDatas = Lists.newArrayList();
        }

        public OperationResult getResult() {
            return this.result;
        }

        private void initDimIndexMappingAndDefaultValue() {
            DynamicObject dataEntity = HBLDataImportPlugin.this.getModel().getDataEntity(true);
            this.modelNumber = dataEntity.getDynamicObject(HBLDataImportPlugin.model).getString("number");
            DynamicObjectCollection mappingCollection = dataEntity.getDynamicObjectCollection(HBLDataImportPlugin.entryentity);
            this.check(mappingCollection);
            int size = mappingCollection.size();
            this.dimKeys = new String[size + 1];
            boolean[] isIndexFlag = new boolean[size];
            int count = 0;
            for (int i = 0; i < size; ++i) {
                String dimNumber;
                DynamicObject mappingRow = (DynamicObject)mappingCollection.get(i);
                DynamicObject dimensionDyn = mappingRow.getDynamicObject(HBLDataImportPlugin.dimension);
                this.dimKeys[count] = dimNumber = dimensionDyn.getString("number");
                isIndexFlag[i] = true;
                ++count;
            }
            this.dimKeys[count] = HBLDataImportPlugin.METRIC_NAME;
        }

        private void check(DynamicObjectCollection mappingCollection) {
            HashSet indexContain = Sets.newHashSet();
            int count = 0;
            int seq = 1;
            for (DynamicObject row : mappingCollection) {
                String mapingIndexStr = row.getString(HBLDataImportPlugin.index);
                String defaultName = row.getString(HBLDataImportPlugin.ctl_default);
                if (StringUtils.isEmpty((CharSequence)mapingIndexStr) && StringUtils.isEmpty((CharSequence)defaultName)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u987a\u5e8f\u7801\u548c\u7f3a\u7701\u503c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"HBLDataImportPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                if (!StringUtils.isNotEmpty((CharSequence)mapingIndexStr)) continue;
                Integer indexTemp = Integer.valueOf(mapingIndexStr);
                if (indexContain.contains(indexTemp)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u987a\u5e8f\u7801\u4e0d\u53ef\u91cd\u590d\u3002", (String)"HBLDataImportPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                count += seq - indexTemp;
                indexContain.add(indexTemp);
                ++seq;
            }
            if (count != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u987a\u5e8f\u7801\u5fc5\u987b\u4ece1\u5f00\u59cb\u4e14\u5fc5\u987b\u8fde\u7eed\u3002", (String)"HBLDataImportPlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }

        public void importData(TempFileCacheDownloadable fileCache, String configkey, String id) {
            this.rowDatas.clear();
            this.waitSaveData.clear();
            TempFileCacheDownloadable.Content contentCheck = fileCache.get(configkey, id);
            new HBLDataImportProgress(25).cache(HBLDataImportPlugin.this.getView());
            if (!this.checkAllData(contentCheck)) {
                log.error("olap data is error!");
                return;
            }
            log.info("olap data is right!");
            new HBLDataImportProgress(60).cache(HBLDataImportPlugin.this.getView());
            TempFileCacheDownloadable.Content content = fileCache.get(configkey, id);
            this.handleInputStream(content);
            new HBLDataImportProgress(100).cache(HBLDataImportPlugin.this.getView());
            this.result.addSuccessPkId((Object)content.getFilename());
            HBLDataImportPlugin.this.saveOpeLogOfOlaoData(Boolean.TRUE, "");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkAllData(TempFileCacheDownloadable.Content contentCheck) {
            Set<String> orgNums = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (Object)HBLDataImportPlugin.this.getModelId()).values().stream().map(x -> x.getNumber()).collect(Collectors.toSet());
            String noneData = String.format(ResManager.loadResFormat((String)"\u201c%s\u201d\u6587\u4ef6\u5185\u65e0\u6570\u636e\u3002", (String)"HBLDataImportPlugin_18", (String)"fi-bcm-formplugin", (Object[])new Object[0]), contentCheck.getFilename());
            String errorData = String.format(ResManager.loadResFormat((String)"\u201c%s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"HBLDataImportPlugin_19", (String)"fi-bcm-formplugin", (Object[])new Object[0]), contentCheck.getFilename());
            try (InputStream inputStream = contentCheck.getInputStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (!scanner.hasNextLine()) {
                    this.addError(noneData);
                    new HBLDataImportProgress(-1, noneData).cache(HBLDataImportPlugin.this.getView());
                    boolean bl = false;
                    return bl;
                }
                String nextLine = scanner.nextLine().replaceAll("\\p{C}", "");
                if (StringUtils.isEmpty((CharSequence)nextLine) || !nextLine.trim().startsWith("!DATA")) {
                    this.addError(errorData);
                    new HBLDataImportProgress(-1, errorData).cache(HBLDataImportPlugin.this.getView());
                    boolean bl = false;
                    return bl;
                }
                String[] tipStrs = nextLine.split("!");
                if (tipStrs.length != 4 || !";".equals(tipStrs[2]) && !HBLDataImportPlugin.DELIMITER.equals(tipStrs[2]) || !Boolean.TRUE.toString().equals(tipStrs[3]) && !Boolean.FALSE.toString().equals(tipStrs[3])) {
                    this.addError(errorData);
                    new HBLDataImportProgress(-1, errorData).cache(HBLDataImportPlugin.this.getView());
                    boolean bl = false;
                    return bl;
                }
                this.separator = tipStrs[2];
                this.lineNum = 1;
                if (Boolean.TRUE.toString().equals(tipStrs[3])) {
                    scanner.nextLine();
                    this.lineNum = 2;
                }
                if (!scanner.hasNextLine()) {
                    this.addError(noneData);
                    new HBLDataImportProgress(-1, noneData).cache(HBLDataImportPlugin.this.getView());
                    boolean bl = false;
                    return bl;
                }
                int sum = 0;
                while (scanner.hasNextLine()) {
                    nextLine = scanner.nextLine();
                    boolean isAppend = this.appendDataOfPreRow(this.rowDatas, nextLine = nextLine.replaceAll("\\p{C}", ""), orgNums);
                    if (isAppend) continue;
                    this.rowDatas.add(nextLine);
                    if (++sum != 100000) continue;
                    if (!this.checkDataOfBatch()) {
                        boolean bl = false;
                        return bl;
                    }
                    sum = 0;
                }
                if (this.rowDatas.size() <= 0) return true;
                if (this.checkDataOfBatch()) return true;
                boolean bl = false;
                return bl;
            }
            catch (NoSuchElementException e) {
                this.addError(noneData);
                new HBLDataImportProgress(-1, noneData).cache(HBLDataImportPlugin.this.getView());
                return true;
            }
            catch (Exception e) {
                new HBLDataImportProgress(-1, e.getMessage()).cache(HBLDataImportPlugin.this.getView());
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[]{e.getMessage()});
            }
        }

        private boolean appendDataOfPreRow(List<String> rowDatas, String nextLine, Set<String> orgNums) {
            if (StringUtils.isEmpty((CharSequence)nextLine)) {
                return true;
            }
            if (nextLine.contains(this.separator)) {
                String[] nextLineArr = nextLine.split(this.separator);
                String fisrtField = nextLineArr[0];
                if (!orgNums.contains(fisrtField) && rowDatas.size() > 0) {
                    String preLine = rowDatas.remove(rowDatas.size() - 1);
                    preLine = preLine + System.getProperty("line.separator") + nextLine;
                    rowDatas.add(preLine);
                    return true;
                }
                return false;
            }
            String preLine = rowDatas.remove(rowDatas.size() - 1);
            preLine = preLine + System.getProperty("line.separator") + nextLine;
            rowDatas.add(preLine);
            return true;
        }

        private boolean checkDataOfBatch() {
            this.genOlapData();
            this.validateOlapData();
            boolean isSuccess = this.importResults.stream().allMatch(ImportResult::isCheckStatus);
            ArrayList<String> infoList = new ArrayList<String>();
            if (!isSuccess) {
                this.importResults = this.importResults.stream().sorted(Comparator.comparingInt(x -> x.isCheckStatus() ? 1 : 0)).collect(Collectors.toList());
                new HBLDataImportProgress(-1, infoList, this.importResults, ResManager.loadResFormat((String)"\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\u3002", (String)"HBLDataImportPlugin_20", (String)"fi-bcm-formplugin", (Object[])new Object[0])).cache(HBLDataImportPlugin.this.getView());
                this.rowDatas.clear();
                this.waitSaveData.clear();
                this.importResults.clear();
                return false;
            }
            this.rowDatas.clear();
            this.waitSaveData.clear();
            this.importResults.clear();
            return true;
        }

        private void removeFmoney() {
            for (Map.Entry v : this.waitSaveData.entries()) {
                String[] dataValues = (String[])v.getValue();
                v.setValue(Arrays.copyOf(dataValues, this.dimKeys.length - 1));
            }
        }

        private void handleInputStream(TempFileCacheDownloadable.Content content) {
            Set<String> orgNums = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (Object)HBLDataImportPlugin.this.getModelId()).values().stream().map(x -> x.getNumber()).collect(Collectors.toSet());
            try (InputStream inputStream = content.getInputStream();
                 Scanner scanner = new Scanner(inputStream);){
                String nextLine = scanner.nextLine().replaceAll("\\p{C}", "");
                String[] tipStrs = nextLine.split("!");
                this.separator = tipStrs[2];
                if (Boolean.TRUE.toString().equals(tipStrs[3])) {
                    scanner.nextLine();
                }
                int sum = 0;
                while (scanner.hasNextLine()) {
                    nextLine = scanner.nextLine();
                    boolean isAppend = this.appendDataOfPreRow(this.rowDatas, nextLine = nextLine.replaceAll("\\p{C}", ""), orgNums);
                    if (isAppend) continue;
                    this.rowDatas.add(nextLine);
                    if (++sum != 100000) continue;
                    this.transfer2Olap();
                    sum = 0;
                }
                if (this.rowDatas.size() > 0) {
                    this.transfer2Olap();
                }
            }
            catch (Exception e) {
                new HBLDataImportProgress(-1, e.getMessage()).cache(HBLDataImportPlugin.this.getView());
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[]{e.getMessage()});
            }
        }

        private void transfer2Olap() {
            this.genOlapData();
            this.removeFmoney();
            this.saveOlapData();
            this.rowDatas.clear();
            this.waitSaveData.clear();
            this.importResults.clear();
        }

        private void genOlapData() {
            this.tempSaveData.clear();
            for (String rowData : this.rowDatas) {
                String[] splitArray = rowData.split(this.separator);
                this.tempSaveData.put((Object)rowData, (Object)splitArray);
            }
            int entityIdx = -1;
            int currencyIdx = -1;
            for (int i = 0; i < this.dimKeys.length; ++i) {
                if (PresetConstant.ENTITY_DIM.equals(this.dimKeys[i])) {
                    entityIdx = i;
                    continue;
                }
                if (!PresetConstant.CURRENCY_DIM.equals(this.dimKeys[i])) continue;
                currencyIdx = i;
            }
            if (entityIdx != -1 && currencyIdx != -1) {
                for (Map.Entry v : this.tempSaveData.entries()) {
                    IDNumberTreeNode entityMember;
                    String[] values = (String[])v.getValue();
                    if (values == null || values.length != this.dimKeys.length) continue;
                    String currency = ((String[])v.getValue())[currencyIdx];
                    String entity = ((String[])v.getValue())[entityIdx];
                    if (!currency.equalsIgnoreCase("EC") && !currency.equalsIgnoreCase("DC") || IDNumberTreeNode.NotFoundTreeNode == (entityMember = MemberReader.findEntityMemberByNum((String)this.modelNumber, (String)entity))) continue;
                    ((String[])v.getValue())[currencyIdx] = entityMember.getCurrency();
                }
            }
            this.waitSaveData.putAll(this.tempSaveData);
        }

        private void validateOlapData() {
            if (this.waitSaveData.size() <= 0) {
                return;
            }
            HashMultimap memberMap = HashMultimap.create();
            HashMap memberNumMemberIdMap = new HashMap(16);
            Comparator<String> comparator = Comparator.comparingInt(this.dimOrder::indexOf);
            for (Map.Entry v : this.waitSaveData.entries()) {
                ++this.lineNum;
                TreeMap<String, CharSequence> periodCheckDimMap = new TreeMap<String, CharSequence>(comparator);
                CharSequence[] dataValues = (String[])v.getValue();
                ImportResult importResult = new ImportResult();
                this.importResults.add(importResult);
                importResult.setIndex(this.lineNum);
                importResult.setDims(String.join((CharSequence)";", dataValues));
                if (dataValues.length < this.dimKeys.length) {
                    this.setErrorMsg(importResult, String.format(ResManager.loadResFormat((String)"\u7b2c%1$d\u884c\u6570\u636e\u7ef4\u5ea6\u4e2a\u6570\u201c%2$d\u201d\u4e0e\u4f53\u7cfb\u7ef4\u5ea6\u4e2a\u6570\u201c%3$d\u201d\u4e0d\u7b26\u3002", (String)"HBLDataImportPlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.lineNum, dataValues.length - 1, this.dimKeys.length - 1));
                } else {
                    if (dataValues.length > this.dimKeys.length) {
                        dataValues = this.splitFmoney((String[])dataValues);
                    }
                    HashMap<String, String> dimNumMemberNumMap = new HashMap<String, String>(16);
                    for (int i = 0; i < this.dimKeys.length; ++i) {
                        String dimKey = this.dimKeys[i];
                        if (dimKey.equals(HBLDataImportPlugin.METRIC_NAME)) continue;
                        memberMap.put((Object)dimKey, (Object)dataValues[i]);
                        dimNumMemberNumMap.put(dimKey, (String)dataValues[i]);
                        if (!this.dimOrder.contains(dimKey)) continue;
                        periodCheckDimMap.put(dimKey, dataValues[i]);
                    }
                    importResult.setDimNumMemberNumMap(dimNumMemberNumMap);
                    importResult.setPeriodCheckDimStr(String.join((CharSequence)HBLDataImportPlugin.DELIMITER, periodCheckDimMap.values()));
                }
                v.setValue(Arrays.copyOf(dataValues, dataValues.length - 1));
            }
            HashSet<Long> scenarioIdSet = new HashSet<Long>(16);
            HashSet<Long> yearIdSet = new HashSet<Long>(16);
            HashSet<Long> periodIdSet = new HashSet<Long>(16);
            HashSet<String> entityNumSet = new HashSet<String>(16);
            HashMultimap notExistDim2MemberNumMap = HashMultimap.create();
            memberMap.forEach((arg_0, arg_1) -> this.lambda$validateOlapData$3((SetMultimap)notExistDim2MemberNumMap, memberNumMemberIdMap, scenarioIdSet, yearIdSet, periodIdSet, entityNumSet, arg_0, arg_1));
            Collection values = memberMap.values();
            boolean dimRepeat = false;
            if ((long)values.size() != values.stream().distinct().count()) {
                dimRepeat = true;
            }
            if (!notExistDim2MemberNumMap.isEmpty()) {
                for (ImportResult importResult : this.importResults) {
                    List<Object> notExistMemberNum;
                    if (importResult.getDimNumMemberNumMap() == null || importResult.getDimNumMemberNumMap().isEmpty()) continue;
                    if (dimRepeat) {
                        notExistMemberNum = new ArrayList(10);
                        for (String dim : notExistDim2MemberNumMap.keySet()) {
                            if (!notExistDim2MemberNumMap.get((Object)dim).contains(importResult.getDimNumMemberNumMap().get(dim))) continue;
                            notExistMemberNum.add(importResult.getDimNumMemberNumMap().get(dim));
                        }
                    } else {
                        notExistMemberNum = importResult.getDimNumMemberNumMap().values().stream().filter(arg_0 -> ((SetMultimap)notExistDim2MemberNumMap).containsValue(arg_0)).collect(Collectors.toList());
                    }
                    if (notExistMemberNum.isEmpty()) continue;
                    this.setErrorMsg(importResult, String.format(ResManager.loadResFormat((String)"\u6210\u5458\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"HBLDataImportPlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]), String.join((CharSequence)HBLDataImportPlugin.DELIMITER, notExistMemberNum)));
                }
            }
            this.checkPeriod(scenarioIdSet, yearIdSet, periodIdSet, entityNumSet);
        }

        private String[] splitFmoney(String[] dataValues) {
            ArrayList<String> list = new ArrayList<String>(16);
            Collections.addAll(list, Arrays.copyOf(dataValues, this.dimKeys.length - 1));
            StringBuilder sb = new StringBuilder();
            for (int i = this.dimKeys.length - 1; i < dataValues.length; ++i) {
                sb.append(dataValues[i]);
                if (i == dataValues.length - 1) continue;
                sb.append(this.separator);
            }
            list.add(sb.toString());
            return list.toArray(new String[0]);
        }

        private void checkPeriod(HashSet<Long> scenarioIdSet, HashSet<Long> yearIdSet, HashSet<Long> periodIdSet, HashSet<String> entityNumSet) {
            boolean cm012 = ConfigServiceHelper.getBoolParam((Long)HBLDataImportPlugin.this.getModelId(), (String)"CM012");
            if (!cm012) {
                return;
            }
            Set openPeriodSet = PeriodSettingHelper.batchCheckPeriodStatusForHBL((long)HBLDataImportPlugin.this.getModelId(), entityNumSet, scenarioIdSet, yearIdSet, periodIdSet);
            Map<String, List<ImportResult>> periodCheckDimSet = this.importResults.stream().filter(ImportResult::isCheckStatus).collect(Collectors.groupingBy(ImportResult::getPeriodCheckDimStr));
            periodCheckDimSet.keySet().removeIf(openPeriodSet::contains);
            for (Map.Entry<String, List<ImportResult>> entry : periodCheckDimSet.entrySet()) {
                String periodCheckDimStr = entry.getKey();
                String[] periodCheckDim = periodCheckDimStr.split(HBLDataImportPlugin.DELIMITER);
                if (periodCheckDim.length != 4) {
                    List<ImportResult> importResults = entry.getValue();
                    for (ImportResult importResult : importResults) {
                        this.setErrorMsg(importResult, ResManager.loadResFormat((String)"\u7528\u4e8e\u671f\u95f4\u6548\u9a8c\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5168\u3002", (String)"HBLDataImportPlugin_30", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    continue;
                }
                String entityNumber = periodCheckDim[this.dimOrder.indexOf("Entity")];
                String scenario = periodCheckDim[this.dimOrder.indexOf("Scenario")];
                String year = periodCheckDim[this.dimOrder.indexOf("Year")];
                String period = periodCheckDim[this.dimOrder.indexOf("Period")];
                List<ImportResult> importResults = periodCheckDimSet.get(periodCheckDimStr);
                for (ImportResult importResult : importResults) {
                    this.setErrorMsg(importResult, String.format(ResManager.loadResFormat((String)"\u671f\u95f4\u672a\u5f00\u542f\u6216\u5df2\u5173\u95ed\uff08\u60c5\u666f\uff1a%1$s\uff0c\u8d22\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u7ec4\u7ec7\uff1a%4$s\uff09\u3002", (String)"HBLDataImportPlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]), scenario, year, period, entityNumber));
                }
            }
        }

        private void setErrorMsg(ImportResult importResult, String errMsg) {
            if (importResult.getError() == null) {
                importResult.setError(errMsg);
            } else {
                importResult.setError(importResult.getError() + " | " + errMsg);
            }
            importResult.setCheckStatus(false);
        }

        private void saveOlapData() {
            if (this.waitSaveData.size() <= 0) {
                return;
            }
            this.queryAccountAndSceneAccuracy(this.modelNumber);
            SaveCommandInfo info = new SaveCommandInfo();
            info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            OlapCommandUtil.addSourceMeasure((String)this.modelNumber, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.A5);
            String[] dims = (String[])Arrays.stream(Arrays.copyOf(this.dimKeys, this.dimKeys.length)).filter(s -> !HBLDataImportPlugin.METRIC_NAME.equals(s)).toArray(String[]::new);
            info.setDimensions(dims);
            CellSet cellSets = new CellSet(dims, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            List<Integer> indexs = this.setIndex();
            this.waitSaveData.forEach((k, v) -> {
                String[] temp = k.split(this.separator);
                if (temp.length > this.dimKeys.length) {
                    temp = this.splitFmoney(temp);
                }
                if (NumberUtils.isNumber((String)temp[temp.length - 1])) {
                    BigDecimal money = this.setAccuracyOfFmoney(temp, indexs);
                    cellSets.set(v, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)money);
                } else {
                    cellSets.set(v, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)temp[temp.length - 1]);
                }
            });
            OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)this.modelNumber, (boolean)false);
        }

        private void addError(String errorMsg) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue((Object)"hbldi");
            errorInfo.setMessage(errorMsg);
            errorInfo.setErrorLevel(ErrorLevel.Error.name());
            this.result.addErrorInfo(errorInfo);
        }

        private void queryAccountAndSceneAccuracy(String modelNumber) {
            DynamicObject[] sceneScales;
            Long modelId = MemberReader.findModelIdByNum((String)modelNumber);
            QFilter qf = new QFilter(HBLDataImportPlugin.model, "=", (Object)modelId);
            DynamicObjectCollection accountScales = QueryServiceHelper.query((String)"bcm_accountscale", (String)"accountnumber, scale", (QFilter[])qf.toArray());
            Map<String, Integer> accNum2Scale = accountScales.stream().collect(Collectors.toMap(x -> x.getString("accountnumber"), y -> y.getInt("scale"), (v1, v2) -> v1));
            Collection allNodeByDimNum = MemberReader.getAllNodeByDimNum((String)SysDimensionEnum.Currency.getNumber(), (String)modelNumber);
            Map<Long, String> currId2Nums = allNodeByDimNum.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getNumber(), (v1, v2) -> v1));
            for (DynamicObject sceneScale : sceneScales = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"number, scaleentry.currency, scaleentry.scale", (QFilter[])qf.toArray())) {
                String number = sceneScale.getString("number");
                DynamicObjectCollection scaleentry = sceneScale.getDynamicObjectCollection("scaleentry");
                if (CollectionUtils.isEmpty((Collection)scaleentry)) continue;
                for (DynamicObject dynamicObject : scaleentry) {
                    String currNum = currId2Nums.get(dynamicObject.getLong("currency.id"));
                    int scale = dynamicObject.getInt("scale");
                    accNum2Scale.put(number + "_" + currNum, scale);
                }
            }
            if (accNum2Scale.size() > 0) {
                ThreadCache.put((Object)"account_scene_scale", accNum2Scale);
            }
        }

        private List<Integer> setIndex() {
            int accountIndex = 0;
            int sceneIndex = 0;
            int currencyIndex = 0;
            List sortDims = DimensionServiceHelper.sortDims;
            for (int i = 0; i < sortDims.size(); ++i) {
                if ("account".equalsIgnoreCase((String)sortDims.get(i))) {
                    accountIndex = i;
                }
                if ("scenario".equalsIgnoreCase((String)sortDims.get(i))) {
                    sceneIndex = i;
                }
                if (!"currency".equalsIgnoreCase((String)sortDims.get(i))) continue;
                currencyIndex = i;
            }
            return Arrays.asList(accountIndex, sceneIndex, currencyIndex);
        }

        private BigDecimal setAccuracyOfFmoney(String[] temp, List<Integer> indexs) {
            Map accNum2Scale = (Map)ThreadCache.get((Object)"account_scene_scale");
            String money = temp[temp.length - 1];
            if (accNum2Scale == null) {
                return new BigDecimal(money);
            }
            String accountNum = temp[indexs.get(0)];
            Integer accountScale = (Integer)accNum2Scale.get(accountNum);
            if (accountScale != null && accountScale % 1 == 0 && accountScale >= -4 && accountScale <= 15) {
                return this.pricitionSettings(accountScale, money);
            }
            String sceneNum = temp[indexs.get(1)];
            String currNum = temp[indexs.get(2)];
            Integer sceneScale = (Integer)accNum2Scale.get(sceneNum + "_" + currNum);
            if (sceneScale != null && sceneScale % 1 == 0 && sceneScale >= -4 && sceneScale <= 15) {
                return this.pricitionSettings(sceneScale, money);
            }
            return new BigDecimal(money);
        }

        private BigDecimal pricitionSettings(Integer scale, String money) {
            int index = money.indexOf(46);
            if (scale == 0) {
                return new BigDecimal(money);
            }
            if (scale > 0) {
                BigDecimal bigDecimal = new BigDecimal(money);
                bigDecimal = bigDecimal.setScale((int)scale, 4);
                return bigDecimal;
            }
            int scaleAbs = Math.abs(scale);
            if (index != -1) {
                money = money.substring(0, index);
            }
            int length = money.length();
            boolean flag = money.startsWith("-");
            if (flag) {
                --length;
            }
            if (length > scaleAbs) {
                int strIndex = money.length() + scale;
                int num = Integer.parseInt(String.valueOf(money.charAt(strIndex)));
                int preMoney = Integer.parseInt(money.substring(0, strIndex));
                if (num > 4) {
                    preMoney = flag ? --preMoney : ++preMoney;
                }
                StringBuilder sb = new StringBuilder(String.valueOf(Math.abs(preMoney)));
                for (int i = 0; i < scaleAbs; ++i) {
                    sb.append("0");
                }
                String sufMoney = sb.toString();
                if (flag) {
                    sufMoney = "-" + sufMoney;
                }
                return new BigDecimal(sufMoney);
            }
            return new BigDecimal(0);
        }

        private /* synthetic */ void lambda$validateOlapData$3(SetMultimap notExistDim2MemberNumMap, HashMap memberNumMemberIdMap, HashSet scenarioIdSet, HashSet yearIdSet, HashSet periodIdSet, HashSet entityNumSet, String dimKey, String dimValue) {
            IDNumberTreeNode memberNode = MemberReader.findMemberByNumber((String)this.modelNumber, (String)dimKey, (String)dimValue);
            if (IDNumberTreeNode.NotFoundTreeNode == memberNode) {
                notExistDim2MemberNumMap.put((Object)dimKey, (Object)dimValue);
            } else {
                memberNumMemberIdMap.put(dimValue, memberNode.getId());
                switch (dimKey) {
                    case "Scenario": {
                        scenarioIdSet.add(memberNode.getId());
                        break;
                    }
                    case "Year": {
                        yearIdSet.add(memberNode.getId());
                        break;
                    }
                    case "Period": {
                        periodIdSet.add(memberNode.getId());
                        break;
                    }
                    case "Entity": {
                        entityNumSet.add(dimValue);
                        break;
                    }
                }
            }
        }
    }
}

