/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.database;

import java.util.List;
import java.util.function.Function;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.formplugin.database.vo.ImportResult;

public class HBLDataImportProgress {
    public static final String PROGRESS_CACHE_ID = "data_import_progress";
    private int percent;
    private String message;
    private List<String> infoList;
    private List<ImportResult> detailInfoList;
    private static Function<IFormView, String> buildCacheKey = v -> PROGRESS_CACHE_ID + v.getPageId();

    public HBLDataImportProgress() {
    }

    public HBLDataImportProgress(int percent) {
        this.percent = percent;
    }

    public HBLDataImportProgress(int percent, String message) {
        this.percent = percent;
        this.message = message;
    }

    public HBLDataImportProgress(int percent, List<String> infoList, List<ImportResult> detailInfoList, String message) {
        this.percent = percent;
        this.infoList = infoList;
        this.detailInfoList = detailInfoList;
        this.message = message;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<String> infoList) {
        this.infoList = infoList;
    }

    public List<ImportResult> getDetailInfoList() {
        return this.detailInfoList;
    }

    public void setDetailInfoList(List<ImportResult> detailInfoList) {
        this.detailInfoList = detailInfoList;
    }

    public void cache(IFormView view) {
        view.getPageCache().put(buildCacheKey.apply(view), JacksonUtils.toJson((Object)this));
    }

    public static HBLDataImportProgress fromCache(IFormView view) {
        String s = view.getPageCache().get(buildCacheKey.apply(view));
        if (StringUtils.isNotEmpty((String)s)) {
            return (HBLDataImportProgress)JacksonUtils.fromJson((String)s, HBLDataImportProgress.class);
        }
        return null;
    }
}

