/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.database;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.IFrameMessage;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;

public class MultiF7Plugin
extends AbstractBaseFormPlugin {
    private String entity;
    private String sign;
    private long dimId;
    private DynamicObject dim;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dimId = (Long)this.getFormCustomParam("dimId");
        this.dim = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"dseq,number,name,model.id,membermodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.dimId)});
        if (this.dim != null) {
            this.entity = this.dim.getString("membermodel");
            this.sign = this.entity + "!" + this.dim.getString("number");
            String value = (String)this.getFormCustomParam("value");
            if (StringUtils.isNotEmpty((String)value)) {
                MultiF7Results mps = (MultiF7Results)JSONObject.parseObject((String)value, MultiF7Results.class);
                this.getPageCache().put(this.sign, SerializationUtils.toJsonString((Object)mps.toList()));
            }
            this.showMulTiF7();
        }
    }

    private void showMulTiF7() {
        if (this.dim != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            FormShowParameter para = new FormShowParameter();
            if (DimTypesEnum.INTERCOMPANY.getNumber().equalsIgnoreCase(this.dim.getString("number"))) {
                para.setFormId("bcm_mulmemberf7_tem_ic");
            } else {
                para.setFormId("bcm_mulmemberf7base_tem");
            }
            para.getOpenStyle().setShowType(ShowType.Modal);
            this.getPageCache().put("KEY_MODEL_ID", this.dim.getString("model.id"));
            this.getPlugin().getPageCache().put("KEY_MODEL_ID", this.dim.getString("model.id"));
            params.put("dimension", this.dim.getInt("dseq") + "");
            params.put("sign", this.sign);
            para.setCustomParams(params);
            para.setCustomParam("isincludeorg", (Object)ResManager.loadKDString((String)"\u5408\u5e76\u5f55\u5165,\u4e2a\u522b\u62a5\u8868,\u5408\u5e76\u62a5\u8868", (String)"MultiF7Plugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            para.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"MultiF7Plugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.dim.getString("name")));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "key");
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
        MultiF7Results mps = MultiF7Results.buildParam((DynamicObjectCollection)doc);
        if (mps != null) {
            String callFrom = (String)this.getFormCustomParam("callFrom");
            if ("qing".equals(callFrom)) {
                String qingPageId = (String)this.getFormCustomParam("qingPageId");
                String controlKey = (String)this.getFormCustomParam("controlKey");
                String hierarchy = (String)this.getFormCustomParam("hierarchy");
                IFrameMessage message = new IFrameMessage();
                message.setType("qing_hierarchy_filter");
                message.setOrigin(qingPageId);
                HashMap<String, String> rs = new HashMap<String, String>();
                rs.put("hierarchy ", hierarchy);
                rs.put("value", JSONObject.toJSON((Object)mps).toString());
                rs.put("text", mps.getShowText());
                rs.put("pageId", qingPageId);
                message.setContent(rs);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("controlKey", controlKey);
                map.put("msg", (String)message);
                this.getView().returnDataToParent(map);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("text", mps.getShowText());
                map.put("value", JSONObject.toJSON((Object)mps).toString());
                this.getView().returnDataToParent(map);
            }
        }
        this.getView().close();
    }
}

