/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dataquery;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.page.model.Area;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OlapQueryDataPlugin
extends MainQueryPlugin
implements AfterF7SelectListener {
    private static final List<String> MUSTINPUT = Arrays.asList("Entity", "Account", "Scenario", "Year", "Period");
    private static final String ISMANAGER = "ISMANAGER";
    private static final String PARENTFORMID = "parentFormId";
    private static final String f7MapCACHEKEY = "f7MapCacheKey";
    private static final String SING_PREFIX = "mutil";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        this.addClickListeners("excute");
        this.getAllDimensions().stream().forEach(dimension -> this.addClickListeners(SING_PREFIX + ((String)dimension.p1).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("model".equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String billFormId = "";
            if (this.getView() != null && this.getView().getFormShowParameter().getCustomParams().containsKey(PARENTFORMID)) {
                billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARENTFORMID);
            }
            ApplicationTypeEnum sign = ModelUtil.queryApp((IFormView)this.getView());
            showParameter.setCustomParam(ISMANAGER, (Object)MemberPermHelper.isManager((ApplicationTypeEnum)sign, (String)billFormId));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        if (evt.getInputValue() != null) {
            BasedataEdit source = (BasedataEdit)evt.getSource();
            String f7Name = source.getFieldKey();
            DynamicObject org = source.getModel().getDataEntity().getDynamicObject(f7Name);
            this.getView().getModel().setValue(f7Name, (Object)org);
            this.getView().updateView(f7Name);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ComboEdit edit = (ComboEdit)this.getControl("function");
        if (edit != null) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u67e5\u8be2\u56e0\u5b50", (String)"OlapQueryDataPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "getFactors"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u67e5\u8be2\u9501\u5b9a\u8303\u56f4\u540d\u79f0", (String)"OlapQueryDataPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "getCubeDataLockRuleNames"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u67e5\u8be2\u9501\u5b9a\u8303\u56f4\u660e\u7ec6", (String)"OlapQueryDataPlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0])), "getCubeDataLockRule"));
            edit.setComboItems(items);
        }
        this.foldConditonAdv(false);
        AdvContainer containerResult = (AdvContainer)this.getControl("advconap1");
        containerResult.setCollapse(true);
        Object modelId = this.getView().getFormShowParameter().getCustomParam("model_id");
        if (modelId == null || modelId.equals(0)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), "model");
        }
        if (modelId != null && !modelId.equals(0)) {
            this.getModel().setValue("model", modelId);
            this.createF7Area();
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(modelId));
        }
    }

    @Override
    public void click(EventObject evt) {
        Element c;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("excute".equals(key)) {
            if (this.getModel().getValue("model") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"OlapQueryDataPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("function") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapQueryDataPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setMsg(this.getFunctionResult());
        } else if (this.getPage(this.getView()) != null && (c = this.getPage(this.getView()).findElementBySign(key)) != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            String number = ((TextEditElement)c).getNumber();
            DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)this.getModelId(), (String)number);
            FormShowParameter para = new FormShowParameter();
            if (number.equals(DimTypesEnum.INTERCOMPANY.getNumber())) {
                para.setFormId("bcm_mulmemberf7_tem_ic");
            } else {
                para.setFormId("bcm_mulmemberf7base_tem");
            }
            para.getOpenStyle().setShowType(ShowType.Modal);
            this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getModelId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dimension", dim.getInt("dseq") + "");
            params.put("sign", key);
            params.put(key, SerializationUtils.toJsonString((Object)((DimensionScope)((Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY))).get(key)).getdimMembers()));
            para.setCustomParams(params);
            para.setCaption(String.format(ResManager.loadKDString((String)"%s - \u6210\u5458\u9009\u62e9", (String)"ConvertDiffRangePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), dim.getString("name")));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm(para);
        }
    }

    private String getFunctionResult() {
        String param = this.getModel().getValue("param").toString();
        String function = this.getModel().getValue("function").toString();
        String result = null;
        switch (function) {
            case "getCubeDataLockRuleNames": {
                result = OlapServiceHelper.queryLockScope((String)this.getModelNumber());
                break;
            }
            case "getCubeDataLockRule": {
                if (kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)param)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapQueryDataPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                result = OlapServiceHelper.queryLockScopeDetail((String)this.getModelNumber(), (String)param);
                break;
            }
            default: {
                if (kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)param)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OlapQueryDataPlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                result = OlapServiceHelper.excuteCustomFunction((String)this.getModelNumber(), (String)function, (String)param);
            }
        }
        return result;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "model": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue == null) {
                    this.setValue("model", e.getChangeSet()[0].getOldValue());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f53\u7cfb\u503c\u3002", (String)"OlapQueryDataPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else {
                    this.createF7Area();
                }
                UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), String.valueOf(this.getModelId()));
                break;
            }
            case "measures": {
                String measures = (String)this.getModel().getValue("measures");
                if (measures != null && (measures.contains(FacTabFieldDefEnum.FIELD_LOCK.getField()) || measures.contains(FacTabFieldDefEnum.FIELD_SOURCE.getField()))) {
                    this.getModel().setValue("excludedynadata", (Object)true);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"excludedynadata"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"excludedynadata"});
                break;
            }
        }
    }

    private void createF7Area() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,name", (QFilter[])new QFilter[]{qFilter}, (String)"dseq asc");
        ArrayList<Pair<String, String>> dimensions = new ArrayList<Pair<String, String>>(10);
        cols.forEach(p -> dimensions.add(Pair.onePair((Object)p.getString("number"), (Object)p.getString("name"))));
        this.autoInCache("dimensions", dimensions);
        this.createMutiF7("flex_scrcondition", dimensions);
        this.foldConditonAdv(true);
        this.resetOlapPage();
    }

    private void createMutiF7(String areaidentity, List<Pair<String, String>> dimensions) {
        Area area = new Area(areaidentity);
        HashMap sign2DimNumber = new HashMap(8);
        HashMap f7DimModels = new HashMap(8);
        long modelId = this.getModelId();
        SchemeContext schemeContext = new SchemeContext(modelId);
        dimensions.stream().forEach(p -> {
            String sign = SING_PREFIX + ((String)p.p1).toLowerCase(Locale.ENGLISH);
            f7DimModels.put(sign, new DimensionScope(String.valueOf(modelId), schemeContext.getDimensionByNumber((String)p.p1)));
            sign2DimNumber.put(sign, p.p1);
            TextEditElement element = new TextEditElement((String)p.p2, sign, DimensionServiceHelper.getDimMembEntityNumByDimNum((String)((String)p.p1)));
            Style style = element.getStyle();
            Margin margin = new Margin();
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            if (MUSTINPUT.contains(p.p1)) {
                element.setMustInput(true);
            }
            element.setNumber((String)p.p1);
            area.addElement((Element)element);
        });
        this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        Page page = new Page();
        page.addArea(area);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_query": 
            case "btn_refresh": {
                if (this.getValue("model") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"OlapQueryDataPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                long modelId = this.getModelId();
                List<Pair<String, String>> dimensions = this.getAllDimensions();
                Map dimDyMaps = MemberReader.getDimDyoByModelId((long)modelId);
                Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
                boolean[] flag = new boolean[]{Boolean.FALSE};
                Map<String, Object> paramValues = dimensions.stream().collect(Collectors.toMap(dimension -> String.format("%s=%s", dimension.p1, dimension.p2), dimension -> {
                    Set numbers = ((DimensionScope)f7DimModels.get(SING_PREFIX + ((String)dimension.p1).toLowerCase(Locale.ENGLISH))).getResolveScopes();
                    Set ids = ((DimensionScope)f7DimModels.get(SING_PREFIX + ((String)dimension.p1).toLowerCase(Locale.ENGLISH))).getResolveScopeIds();
                    if (CollectionUtils.isNotEmpty((Collection)numbers) && this.filterNoPermMembers(ids, numbers, dimDyMaps, (String)dimension.p1, modelId)) {
                        flag[0] = Boolean.TRUE;
                    }
                    if ("Entity".equals(dimension.p1)) {
                        QFilter qf = new QFilter("model", "=", (Object)modelId);
                        qf.and(new QFilter("parent.number", "in", (Object)numbers).or("number", "in", (Object)numbers));
                        qf.and("status", "!=", (Object)StatusEnum.TempSave.toString());
                        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"parent.number, number", (QFilter[])qf.toArray()).forEach(e -> {
                            String parNumber = e.getString("parent.number");
                            if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)parNumber)) {
                                numbers.add(e.getString("parent.number") + "_" + e.getString("number"));
                            }
                        });
                    }
                    return numbers;
                }));
                if (flag[0]) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8fc7\u6ee4\u65e0\u6743\u9650\u7684\u4e0b\u7ea7\u6210\u5458\u3002", (String)"OlapQueryDataPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                paramValues.put("model", this.getModelNumber());
                paramValues.put("excludeDynaData", this.getModel().getValue("excludedynadata"));
                paramValues.put("includeCalType", this.getModel().getValue("includecaltype"));
                paramValues.put("excludeNullData", this.getModel().getValue("excludeNullData"));
                paramValues.put("measures", this.getModel().getValue("measures"));
                ArrayList dimensionKey = new ArrayList(10);
                dimensions.forEach(p -> dimensionKey.add(p.p1));
                paramValues.put("dimensionKey", dimensionKey);
                this.getQueryDataTabManger().resetOlapExcute(this.getView());
                this.getQueryDataTabManger().addOlapQueryDataTabInfo(String.valueOf(UUID.randomUUID().hashCode()), ResManager.loadKDString((String)"\u591a\u7ef4\u67e5\u8be2\u7ed3\u679c", (String)"OlapQueryDataPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), paramValues).showTabView(this.getView());
                this.cacheQueryDataTabManger();
                AdvContainer container = (AdvContainer)this.getControl("advconap1");
                container.setCollapse(false);
                break;
            }
            case "btn_reset": {
                Object model = this.getModel().getValue("model");
                if (Objects.isNull(model)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f53\u7cfb\u503c\u3002", (String)"OlapQueryDataPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.resetOlapPage();
                break;
            }
            case "btn_export": {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d", (String)"ReportMultiExportPlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                try {
                    if (this.getQueryDataTabManger().getQueryDataTabs() == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u67e5\u8be2", (String)"OlapQueryDataPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    String resultPageId = this.getQueryDataTabManger().getQueryDataTabs().getTabKey();
                    IFormView resultView = this.getView().getMainView().getView(resultPageId);
                    IDataModel resultModel = resultView.getModel();
                    String colNameCache = resultView.getPageCache().get("colNames");
                    if (StringUtil.isEmptyString((String)colNameCache)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u67e5\u8be2", (String)"OlapQueryDataPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                    List colName = (List)ObjectSerialUtil.deSerializedBytes((String)colNameCache);
                    DynamicObjectCollection exportData = resultModel.getEntryEntity("entryentity");
                    String url = this.handleExportData(exportData, colName);
                    if (StringUtils.isNotEmpty((CharSequence)url)) {
                        this.downloadFile(url, "bcm_query_mainpage", "47150e89000000ac");
                    }
                    OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u67e5\u8be2\u591a\u7ef4\u6570\u636e", "OlapQueryDataPlugin_12", "fi-bcm-formplugin", "queryOlapData");
                    OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u6210\u529f", "OlapQueryDataPlugin_13", "fi-bcm-formplugin", null);
                    this.writeMultiLangLog(opName, opDes);
                    break;
                }
                finally {
                    this.getView().hideLoading();
                }
            }
        }
    }

    private boolean filterNoPermMembers(Set<Long> ids, Set<String> numbers, Map<String, DynamicObject> dimDyMaps, String dimNum, long modelId) {
        DynamicObject dynamicObject = dimDyMaps.get(dimNum);
        if (dynamicObject == null) {
            throw new KDBizException("the dimension is not found");
        }
        long dimId = dynamicObject.getLong("id");
        String entityName = dynamicObject.getString("membermodel");
        List<IDNumberTreeNode> members = MemberReader.getAllNodeFromCache((String)entityName, (Object)modelId).values().stream().filter(x -> ids.contains(x.getId())).collect(Collectors.toList());
        Map<Long, String> id2Nums = members.stream().collect(Collectors.toMap(x -> x.getId(), y -> y.getNumber()));
        if (id2Nums.size() != ids.size()) {
            throw new KDBizException("the member ids size not equal numbers size");
        }
        Map<Long, List<Long>> relationMap = this.buildPCRelation(members);
        int formerSize = ids.size();
        this.delNoPermMember(id2Nums, relationMap, ids, numbers, modelId, dimId);
        if (ids.size() != formerSize) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void delNoPermMember(Map<Long, String> id2Nums, Map<Long, List<Long>> relationMap, Set<Long> ids, Set<String> numbers, long modelId, long dimId) {
        PermissionService service = PermissionServiceImpl.getInstance((Long)modelId);
        if (service.isAdmin()) {
            return;
        }
        Iterator<Map.Entry<Long, String>> iterator = id2Nums.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, String> next = iterator.next();
            Long memId = next.getKey();
            String memNum = next.getValue();
            if (service.memberCanShow(Long.valueOf(dimId), memId, relationMap)) continue;
            iterator.remove();
            ids.remove(memId);
            numbers.remove(memNum);
        }
    }

    private Map<Long, List<Long>> buildPCRelation(List<IDNumberTreeNode> members) {
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>();
        members.forEach(p -> {
            long id = p.getId();
            IDNumberTreeNode parent = p.getParent();
            if (parent != null && parent != IDNumberTreeNode.NotFoundTreeNode) {
                long parentId = parent.getId();
                if (relationMap.get(parentId) != null) {
                    ((List)relationMap.get(parentId)).add(id);
                } else {
                    ArrayList<Long> children = new ArrayList<Long>();
                    children.add(id);
                    relationMap.put(parentId, children);
                }
            }
        });
        return relationMap;
    }

    private void foldConditonAdv(boolean flag) {
        AdvContainer containerCondition = (AdvContainer)this.getControl("advconap");
        if (flag) {
            containerCondition.setCollapse(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"measures", "excludedynadata", "includecaltype", "excludenulldata"});
            this.getModel().setValue("excludedynadata", (Object)false);
            this.setCombo();
        } else {
            containerCondition.setCollapse(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"measures", "excludedynadata", "includecaltype", "excludenulldata"});
        }
    }

    private void setCombo() {
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("measures");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (FacTabFieldDefEnum m : FacTabFieldDefEnum.values()) {
            String field = m.getField();
            if (!OlapServiceHelper.checkMeasure((String)modelNum, (String)field)) continue;
            items.add(new ComboItem(new LocaleString(field), field));
        }
        comboEdit.setComboItems(items);
        comboEdit.setMustInput(true);
        this.getModel().setValue("measures", (Object)FacTabFieldDefEnum.FIELD_MONEY.getField());
    }

    @Override
    protected void setMsg(String msg) {
        this.setValue("infomationtextarea", msg);
    }

    @Override
    public void resetOlapPage() {
        super.resetOlapPage();
        this.getModel().beginInit();
        this.getAllDimensions().stream().forEach(dimension -> this.setValue(SING_PREFIX + ((String)dimension.p1).toLowerCase(Locale.ENGLISH), null));
        this.getModel().endInit();
        Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
        f7DimModels.forEach((k, v) -> v.clear());
        this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        this.getView().updateView("flex_scrcondition");
    }

    private List<Pair<String, String>> getAllDimensions() {
        List<Object> dimensions = new ArrayList<Pair<String, String>>(10);
        String dimensionCache = this.queryDataTabMangerCache.get("dimensions");
        if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)dimensionCache)) {
            dimensions = (List)ObjectSerialUtil.deSerializedBytes((String)dimensionCache);
        }
        return dimensions;
    }

    public void beforeBindData(EventObject e) {
        if (this.isHideSql()) {
            this.hideSqlTabAndOlapItem();
        } else {
            this.showLoginView();
        }
    }

    private void hideSqlTabAndOlapItem() {
        this.getModel().setValue("combofield", (Object)"0");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"olapmethod"});
        this.getView().updateControlMetadata("tabap", (Map)new HashMap<String, Object>(16){
            {
                this.put("hideNav", true);
            }
        });
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab("tabpageap1");
    }

    public void closedCallBack(ClosedCallBackEvent cb) {
        super.closedCallBack(cb);
        String key = cb.getActionId();
        Element c = this.getPage(this.getView()).findElementBySign(key);
        if (c != null && TextEditElement.class.isAssignableFrom(c.getClass())) {
            if (ThreadCache.get((Object)"okbtn") == null) {
                return;
            }
            DynamicObjectCollection doc = (DynamicObjectCollection)cb.getReturnData();
            Map f7DimModels = (Map)this.deSerializedBytes(this.getPageCache().get(f7MapCACHEKEY));
            DimensionScope dimScope = (DimensionScope)f7DimModels.get(key);
            dimScope.clear();
            if (doc != null && doc.size() != 0) {
                for (DynamicObject dyn : doc) {
                    long id = dyn.getLong(4);
                    int scope = dyn.getInt(5);
                    dimScope.addDimeMemRange(id, scope);
                    this.getModel().setValue(key, (Object)dimScope.toString());
                }
            } else {
                this.getModel().setValue(key, (Object)"");
            }
            this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(f7DimModels));
        } else {
            Map map = (Map)cb.getReturnData();
            if ("ok".equals(map.get("status"))) {
                this.getModel().setValue("combofield", (Object)"0");
            } else {
                this.getView().close();
            }
        }
    }

    public void showLoginView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bcm_query_checklogin");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "status"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String handleExportData(DynamicObjectCollection toExportData, List<String> headerList) {
        if (toExportData == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"OlapQueryDataPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (toExportData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"OlapQueryDataPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            XSSFSheet xssfSheet = workBook.createSheet();
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            for (int i = 0; i < headerList.size(); ++i) {
                XSSFCell cell = headerRow1.createCell(i, CellType.STRING);
                cell.setCellValue(headerList.get(i));
                cell.setCellStyle((CellStyle)headerStyle);
            }
            ++rowNum;
            for (DynamicObject rowData : toExportData) {
                ArrayList row = Lists.newArrayListWithExpectedSize((int)headerList.size());
                for (int i = 0; i < headerList.size(); ++i) {
                    row.add(rowData.get(headerList.get(i)));
                }
                XSSFRow xssfRow = xssfSheet.createRow(rowNum);
                for (int j = 0; j < row.size(); ++j) {
                    XSSFCell cell = xssfRow.createCell(j);
                    cell.setCellValue((String)row.get(j));
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
            String string = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c", (String)"SqlQueryResultPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return string;
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null || kd.fi.bcm.fel.common.StringUtils.isEmpty((CharSequence)newValue.toString())) {
            this.getPageCache().remove(name);
            String f7Map = this.getPageCache().get(f7MapCACHEKEY);
            if (kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)f7Map)) {
                Map stringDimensionScopeMap = (Map)this.deSerializedBytes(f7Map);
                long modelId = this.getModelId();
                SchemeContext schemeContext = new SchemeContext(modelId);
                String entitySign = name.substring(5);
                stringDimensionScopeMap.put(name, new DimensionScope(String.valueOf(modelId), schemeContext.getDimensionByNumber(entitySign)));
                this.getPageCache().put(f7MapCACHEKEY, this.toByteSerialized(stringDimensionScopeMap));
            }
        }
    }
}

