/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dataquery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class QueryDataTabManger
implements Serializable {
    private static final long serialVersionUID = -1211749306483726L;
    private List<QueryDataTabInfo> tabs = new ArrayList<QueryDataTabInfo>();
    private QueryDataTabInfo queryDataTabs;

    public QueryDataTabInfo addSqlQueryDataTabInfo(String tabKey, String tabName, Map<String, Object> paramvalue) {
        QueryDataTabInfo queryDataTabInfo = new QueryDataTabInfo(tabKey, tabName, false);
        queryDataTabInfo.setCommomnParams(paramvalue);
        this.tabs.remove(queryDataTabInfo);
        this.tabs.add(queryDataTabInfo);
        return queryDataTabInfo;
    }

    public QueryDataTabInfo addOlapQueryDataTabInfo(String tabKey, String tabName, Map<String, Object> paramvalue) {
        if (this.queryDataTabs == null) {
            this.queryDataTabs = new QueryDataTabInfo();
        }
        this.queryDataTabs.setTabKey(tabKey);
        this.queryDataTabs.setTabName(tabName);
        this.queryDataTabs.setOlapTab(true);
        this.queryDataTabs.setCommomnParams(paramvalue);
        return this.queryDataTabs;
    }

    public void setTabs(List<QueryDataTabInfo> tabs) {
        this.tabs = tabs;
    }

    public List<QueryDataTabInfo> getListTabs() {
        return this.tabs;
    }

    public QueryDataTabInfo getQueryDataTabs() {
        return this.queryDataTabs;
    }

    public void setQueryDataTabs(QueryDataTabInfo queryDataTabs) {
        this.queryDataTabs = queryDataTabs;
    }

    public String getLastTabKey() {
        if (this.queryDataTabs != null) {
            this.tabs.remove(this.queryDataTabs);
        }
        if (this.tabs.size() > 0) {
            return this.tabs.get(this.tabs.size() - 1).getTabKey();
        }
        return "tabpageap2";
    }

    public Iterator<QueryDataTabInfo> iterator() {
        return this.tabs.iterator();
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    private void releaseAll() {
        this.tabs.clear();
        this.queryDataTabs = null;
    }

    private void releaseOlap() {
        this.queryDataTabs = null;
    }

    public void resetExcute(IFormView iFormView) {
        if (this.tabs != null && this.tabs.size() > 0) {
            for (QueryDataTabInfo tab : this.tabs) {
                IFormView formView = SessionManager.getCurrent().getView(tab.getTabKey());
                if (formView == null) continue;
                formView.close();
                HashMap<String, String> arg = new HashMap<String, String>();
                arg.put("pageId", tab.getTabKey());
                ((IClientViewProxy)iFormView.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
        this.releaseAll();
    }

    public void resetOlapExcute(IFormView iFormView) {
        if (this.queryDataTabs != null) {
            this.closeTab(this.queryDataTabs.getTabKey(), iFormView);
        }
        this.releaseOlap();
    }

    public void resetSqlExecute(IFormView iFormView) {
        if (this.tabs != null && this.tabs.size() > 0) {
            this.tabs.stream().forEach(tab -> this.closeTab(tab.getTabKey(), iFormView));
        }
        this.releaseSql();
    }

    private void closeTab(String tabkey, IFormView iFormView) {
        IFormView formView = SessionManager.getCurrent().getView(tabkey);
        if (formView != null) {
            formView.close();
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", tabkey);
            ((IClientViewProxy)iFormView.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        }
    }

    public void hideSqlExcute(IFormView iFormView) {
        if (this.tabs != null && this.tabs.size() > 0) {
            for (QueryDataTabInfo tab : this.tabs) {
                IFormView formView;
                if (tab.equals(this.queryDataTabs) || (formView = SessionManager.getCurrent().getView(tab.getTabKey())) == null) continue;
                formView.setVisible(Boolean.FALSE, new String[]{tab.getTabKey()});
                formView.updateView();
            }
        }
        this.releaseSql();
    }

    public void hideOlapExcute(IFormView iFormView) {
        IFormView formView;
        if (this.queryDataTabs != null && (formView = SessionManager.getCurrent().getView(this.queryDataTabs.getTabKey())) != null) {
            formView.setVisible(Boolean.FALSE, new String[]{this.queryDataTabs.getTabKey()});
        }
        this.releaseOlap();
    }

    private void releaseSql() {
        this.tabs.clear();
    }

    public static class QueryDataTabInfo
    implements Serializable {
        private static final long serialVersionUID = -1211749306483774426L;
        private static final String RESULT_GRID = "bcm_query_result";
        private static final String RESULT_TAB_KEY = "resulttab";
        private String tabKey;
        private String tabName;
        private boolean isOlapTab;
        private Map<String, Object> commomnParams = new HashMap<String, Object>();

        public String getTabKey() {
            return this.tabKey;
        }

        public String getTabName() {
            return this.tabName;
        }

        public boolean isOlapTab() {
            return this.isOlapTab;
        }

        public Map<String, Object> getCommomnParams() {
            return this.commomnParams;
        }

        public void setCommomnParams(Map<String, Object> commomnParams) {
            this.commomnParams = commomnParams;
        }

        public void addCommomnParam(String paramname, Object param) {
            this.commomnParams.put(paramname, param);
        }

        public void removeCommomnParam(String paramname) {
            this.commomnParams.remove(paramname);
        }

        public void showTabView(IFormView iFormView) {
            this.showTabView(iFormView, RESULT_GRID);
        }

        public void showTabView(IFormView iFormView, String formId) {
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(formId);
            lsp.setCustomParams(this.commomnParams);
            lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
            lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
            lsp.setCaption(this.tabName);
            lsp.setPageId(this.tabKey);
            lsp.setParentFormId(iFormView.getFormShowParameter().getPageId());
            iFormView.showForm(lsp);
        }

        public QueryDataTabInfo() {
        }

        public QueryDataTabInfo(String tabKey, String tabName, boolean isOlapTab) {
            this.tabKey = tabKey;
            this.tabName = tabName;
            this.isOlapTab = isOlapTab;
        }

        public boolean equals(Object obj) {
            boolean isEquals = false;
            if (obj instanceof QueryDataTabInfo) {
                QueryDataTabInfo o = (QueryDataTabInfo)obj;
                isEquals = new EqualsBuilder().append((Object)this.tabKey, (Object)o.getTabKey()).isEquals();
            }
            return isEquals;
        }

        public void setTabKey(String tabKey) {
            this.tabKey = tabKey;
        }

        public void setTabName(String tabName) {
            this.tabName = tabName;
        }

        public void setOlapTab(boolean olapTab) {
            this.isOlapTab = olapTab;
        }
    }
}

