/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dataquery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;

public class ShowCellDifferencePlugin
extends AbstractBaseFormPlugin {
    private String TREE_ENTRY_ENTITY = "treeentryentity";
    private String HEAD_LOCATION = "location";
    private String HEAD_FRONTFORMULA = "frontformula";
    private String HEAD_BACKFORMULA = "backformula";
    private String HEAD_FRONTVALUE = "frontvalue";
    private String HEAD_BACKVALUE = "backvalue";
    private String HEAD_STARTPOSITION = "startposition";
    private String HEAD_AREARANGE = "arearange";
    private String HEAD_ORIGINALSTARTPOSITION = "originalstartposition";
    private String HEAD_ORIGINALAREARANGE = "originalarearange";
    private String DELETEENTRY = "option";
    private String NEWENTRY = "newentry";
    private SpreadManager sm;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam("celldifference") == null) {
            return;
        }
        List maps = (List)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("celldifference")));
        if (maps != null && !maps.isEmpty()) {
            int[] rows = this.getModel().batchCreateNewEntryRow(this.TREE_ENTRY_ENTITY, maps.size());
            for (int i = 0; i < maps.size(); ++i) {
                Map map = (Map)maps.get(i);
                this.getModel().setValue(this.HEAD_LOCATION, map.get(this.HEAD_LOCATION), rows[i]);
                this.getModel().setValue(this.HEAD_FRONTFORMULA, map.get(this.HEAD_FRONTFORMULA), rows[i]);
                this.getModel().setValue(this.HEAD_BACKFORMULA, map.get(this.HEAD_BACKFORMULA), rows[i]);
                this.getModel().setValue(this.HEAD_FRONTVALUE, map.get(this.HEAD_FRONTVALUE), rows[i]);
                this.getModel().setValue(this.HEAD_BACKVALUE, map.get(this.HEAD_BACKVALUE), rows[i]);
            }
            this.getView().updateView(this.TREE_ENTRY_ENTITY);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap321"});
        }
        this.createRangTreeentryEntity();
    }

    private void createRangTreeentryEntity() {
        SpreadManager spreadManager;
        Set positionInfoSet;
        TemplateModel templateModel;
        List areaRangeEntryList;
        if (this.getView().getFormShowParameter().getCustomParam("template_model") != null && !(areaRangeEntryList = (templateModel = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("template_model")))).getAreaRangeEntries()).isEmpty()) {
            Collections.sort(areaRangeEntryList, new Comparator<AreaRangeEntry>(){

                @Override
                public int compare(AreaRangeEntry o1, AreaRangeEntry o2) {
                    Point point1 = ExcelUtils.pos2Point((String)o1.getStartPosition());
                    Point point2 = ExcelUtils.pos2Point((String)o2.getStartPosition());
                    int i = point1.y - point2.y;
                    if (i == 0) {
                        i = point1.x - point2.x;
                    }
                    return i;
                }
            });
            int[] rows = this.getModel().batchCreateNewEntryRow("treeentryentity_tm", areaRangeEntryList.size());
            for (int i = 0; i < areaRangeEntryList.size(); ++i) {
                AreaRangeEntry areaRangeEntry = (AreaRangeEntry)areaRangeEntryList.get(i);
                this.getModel().setValue(this.HEAD_STARTPOSITION + "_tm", (Object)areaRangeEntry.getStartPosition(), rows[i]);
                this.getModel().setValue(this.HEAD_AREARANGE + "_tm", (Object)areaRangeEntry.getAreaRange(), rows[i]);
            }
            this.getView().updateView("treeentryentity_tm");
        }
        if (this.getView().getFormShowParameter().getCustomParam("KEY_SPREAD_MODEL") != null && !(positionInfoSet = (spreadManager = this.getSpreadManager()).getAreaManager().getPostionInfoSet()).isEmpty()) {
            List positionInfoList = positionInfoSet.stream().collect(Collectors.toList());
            Collections.sort(positionInfoList, new Comparator<PositionInfo>(){

                @Override
                public int compare(PositionInfo o1, PositionInfo o2) {
                    Point point1 = ExcelUtils.pos2Point((String)o1.getStartPosition());
                    Point point2 = ExcelUtils.pos2Point((String)o2.getStartPosition());
                    int i = point1.y - point2.y;
                    if (i == 0) {
                        i = point1.x - point2.x;
                    }
                    return i;
                }
            });
            int[] rows = this.getModel().batchCreateNewEntryRow("treeentryentity_sm", positionInfoList.size());
            ArrayList allBasePoinInfos = new ArrayList(16);
            for (int i = 0; i < positionInfoList.size(); ++i) {
                PositionInfo positionInfo = (PositionInfo)positionInfoList.get(i);
                this.getModel().setValue(this.HEAD_STARTPOSITION + "_sm", (Object)positionInfo.getStartPosition(), rows[i]);
                this.getModel().setValue(this.HEAD_AREARANGE + "_sm", (Object)positionInfo.getAreaRange(), rows[i]);
                this.getModel().setValue(this.HEAD_ORIGINALSTARTPOSITION + "_sm", (Object)positionInfo.getOriginalStartPosition(), rows[i]);
                this.getModel().setValue(this.HEAD_ORIGINALAREARANGE + "_sm", (Object)positionInfo.getOriginalAreaRange(), rows[i]);
                List basePoints = positionInfo.getBasePoints();
                if (basePoints == null || basePoints.isEmpty()) continue;
                allBasePoinInfos.addAll(basePoints);
            }
            this.getView().updateView("treeentryentity_sm");
            if (!allBasePoinInfos.isEmpty()) {
                int[] rowList = this.getModel().batchCreateNewEntryRow("floatentry_sm", allBasePoinInfos.size());
                for (int i = 0; i < allBasePoinInfos.size(); ++i) {
                    BasePointInfo basePointInfo = (BasePointInfo)allBasePoinInfos.get(i);
                    this.getModel().setValue("floatrange_sm", (Object)basePointInfo.getDynaRange(), rowList[i]);
                    this.getModel().setValue("floatoriginal_sm", (Object)basePointInfo.getOriginalDynaRange(), rowList[i]);
                }
            }
            this.getView().updateView("floatentry_sm");
            if (allBasePoinInfos.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3221"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        args.setCancel(true);
        if (this.NEWENTRY.equals(operateKey) || this.DELETEENTRY.equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.TREE_ENTRY_ENTITY);
            if (entryEntity.isEmpty()) {
                this.getView().close();
                return;
            }
            ArrayList maps = new ArrayList(entryEntity.size());
            for (DynamicObject object : entryEntity) {
                Point point = ExcelUtils.pos2Point((String)object.getString(this.HEAD_LOCATION));
                HashMap<String, Object> e = new HashMap<String, Object>(10);
                e.put("r", point.y);
                e.put("c", point.x);
                e.put("v", object.get(this.DELETEENTRY.equals(operateKey) ? this.HEAD_BACKVALUE : this.HEAD_FRONTVALUE));
                maps.add(e);
            }
            Tuple result = Tuple.create(maps, (Object)this.getSpreadManager(), (Object)operateKey);
            this.returnDataToParent(result);
            this.getView().close();
        }
    }

    public SpreadManager getSpreadManager() {
        if (this.sm == null) {
            this.sm = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)((String)this.getView().getFormShowParameter().getCustomParam("KEY_SPREAD_MODEL")));
        }
        return this.sm;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }
}

