/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dataquery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.DBObject;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.UnitTestUtil;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;

public class SqlQueryPlugin
extends MainQueryPlugin
implements ClickListener {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MainQueryPlugin.class);
    private static final String BR = "\r\n";
    private static final String INFOMATION_TEXTAREA = "infomationtextarea";
    private static final String TEXT_DBROUTE = "dbroute";
    private static final String TEXTAREA_SQLAREA = "codeeditap";

    @Override
    public void afterCreateNewData(EventObject e) {
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl(TEXT_DBROUTE);
        try {
            List dbInstanceList = LoginMCService.create().getDbInstanceList(RequestContext.get().getAccountId());
            if (dbInstanceList != null) {
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(dbInstanceList.size());
                for (DBObject dbObject : dbInstanceList) {
                    ComboItem item = new ComboItem(new LocaleString(dbObject.getName()), dbObject.getNumber());
                    list.add(item);
                }
                dbCombo.setComboItems(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue(TEXT_DBROUTE, (Object)"fi");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_execute_first", "btn_execute_all", "btn_reset1");
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_execute_first": {
                this.execute(false);
                break;
            }
            case "btn_execute_all": {
                this.execute(true);
                break;
            }
            case "btn_reset1": {
                this.resetSqlPage();
                break;
            }
        }
    }

    @Override
    protected void resetSqlPage() {
        this.setValue(INFOMATION_TEXTAREA, "");
        CodeEdit edit = (CodeEdit)this.getView().getControl(TEXTAREA_SQLAREA);
        edit.setText(null);
        super.resetSqlPage();
    }

    @Override
    protected void setMsg(String msg) {
    }

    private void execute(boolean colmn) {
        CodeEdit edit = (CodeEdit)this.getView().getControl(TEXTAREA_SQLAREA);
        String[] sqls = String.valueOf(edit.getText()).split(";");
        if (UnitTestUtil.checkUnitTestView((IFormView)this.getView())) {
            sqls = String.valueOf(this.getModel().getValue("sqlarea")).split(";");
        }
        this.getQueryDataTabManger().resetSqlExecute(this.getView());
        for (int i = 0; i < sqls.length; ++i) {
            String sql = SqlQueryPlugin.replaceBlank(sqls[i].trim());
            if (StringUtils.isEmpty((CharSequence)sql)) {
                this.setMsg(i + 1, false, null, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165SQL\u8bed\u53e5\u3002", (String)"SqlQueryPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
            this.executeSql(i + 1, sql);
            if (!colmn) break;
        }
        this.cacheQueryDataTabManger();
        Tab tab = (Tab)this.getView().getControl("resulttab");
        tab.activeTab(this.getQueryDataTabManger().getLastTabKey());
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll(" ");
        }
        return dest;
    }

    private void executeSql(int index, final String sql) {
        String sqlCopy = sql.toLowerCase(Locale.ENGLISH);
        if (sqlCopy.startsWith("select ")) {
            this.getQueryDataTabManger().addSqlQueryDataTabInfo(String.valueOf(UUID.randomUUID().hashCode()), String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u7ed3\u679c\u4e3a%s\u3002", (String)"SqlQueryPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), index), (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("dbRoute", SqlQueryPlugin.this.getValue(SqlQueryPlugin.TEXT_DBROUTE));
                    this.put("sql", sql);
                }
            }).showTabView(this.getView());
            this.setMsg(index, true, sql, "Please click on the corresponding query details tab");
        } else if (!DebugServiceHelper.isDebugDML() || !ConfigServiceHelper.getGlobalBoolParam((String)"isSupportDML")) {
            this.setMsg(index, false, sql, "only support select");
        } else if (!(sqlCopy.startsWith("insert ") || sqlCopy.startsWith("delete ") || sqlCopy.startsWith("update ") || sqlCopy.startsWith("alter ") || sqlCopy.startsWith("drop ") || sqlCopy.startsWith("create ") || sqlCopy.startsWith("/*dialect*/"))) {
            this.setMsg(index, false, sql, ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u8be5\u8bed\u53e5\u3002", (String)"SqlQueryPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            this.execute(index, new DBRoute((String)this.getValue(TEXT_DBROUTE)), sql);
        }
    }

    private void execute(int index, DBRoute rout, String sql) {
        try {
            DB.execute((DBRoute)rout, (String)sql);
            this.setMsg(index, true, sql, "");
        }
        catch (Throwable ex) {
            this.setMsg(index, false, sql, ex);
        }
    }

    private void setMsg(int index, boolean isSucess, String sql, Object msg) {
        String oldValue = (String)this.getView().getModel().getValue(INFOMATION_TEXTAREA);
        msg = index + ". " + (msg instanceof Throwable ? this.getErrorMessage((Throwable)msg, sql) : this.appendMessage(isSucess, sql, (String)msg));
        this.getView().getModel().setValue(INFOMATION_TEXTAREA, (Object)(msg + BR + oldValue));
    }

    private String getErrorMessage(Throwable ex, String sql) {
        return this.appendMessage(false, sql, ex.getMessage());
    }

    private String appendMessage(boolean isSucess, String sql, String Message) {
        return isSucess ? ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"SqlQueryPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff1a%1$s\uff0c\u9519\u8bef\u539f\u56e0\uff1a%2$s\u3002", (String)"SqlQueryPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sql, Message);
    }
}

