/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.dataquery;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.fi.bcm.business.page.model.BaseEditElement;
import kd.fi.bcm.business.page.model.Element;
import kd.fi.bcm.business.page.model.Page;
import kd.fi.bcm.business.page.model.TextEditElement;
import kd.fi.bcm.business.page.model.entry.DynamicEntry;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.util.InvestUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.dataquery.MainQueryPlugin;
import kd.fi.bcm.formplugin.pageinteraction.CommandParam;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.pageinteraction.SubPage;
import kd.fi.bcm.formplugin.util.ImportAndExportUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SqlQueryResultPlugin
extends MainQueryPlugin
implements DynamicPage,
SubPage {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static String KEY_MSG = "msgflex";
    private static final List<String> MUSTINPUT = Arrays.asList("Entity", "Account", "Scenario", "Year", "Period");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("advcontoolbarap");
    }

    private Boolean isOlap() {
        return this.getView().getFormShowParameter().getCustomParam("sql") == null;
    }

    private int getFromPageType() {
        return this.getFormCustomParam("type", 0);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        List<String> colNames;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MSG});
        Map paramValues = this.getView().getFormShowParameter().getCustomParams();
        if (this.isHideSql()) {
            this.getView().updateControlMetadata("tabap", (Map)new HashMap<String, Object>(16){
                {
                    this.put("hideNav", true);
                }
            });
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap"});
        } else if (3 == this.getFromPageType()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_sql"});
        }
        if (this.isOlap().booleanValue()) {
            boolean excludeDynaData = (Boolean)paramValues.get("excludeDynaData");
            boolean excludeNullData = (Boolean)paramValues.get("excludeNullData");
            String measures = (String)paramValues.get("measures");
            if (StringUtils.isEmpty((CharSequence)measures)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"SqlQueryResultPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean includeCalType = (Boolean)paramValues.remove("includeCalType");
            this.getView().getFormShowParameter().getCustomParams().remove("excludeDynaData");
            paramValues.remove("hidesql");
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_sql"});
            String model = (String)paramValues.remove("model");
            List dimensionKey = (List)paramValues.remove("dimensionKey");
            colNames = this.createTable(dimensionKey, true, measures);
            SQLBuilder sqlBuilder = this.createSQLBuilder(model, dimensionKey, paramValues, includeCalType);
            if (sqlBuilder == null) {
                return;
            }
            for (FacTabFieldDefEnum m : FacTabFieldDefEnum.values()) {
                if (!measures.contains(m.getField())) continue;
                sqlBuilder.addMeasures(new String[]{m.getField()});
            }
            sqlBuilder.setExcludeDynaData(excludeDynaData);
            sqlBuilder.setExcludeNullData(excludeNullData);
            sqlBuilder.setTop(5000);
            MDResultSet data = OlapServiceHelper.queryData((SQLBuilder)sqlBuilder, (boolean)true);
            int size = data.getCount();
            this.fillData(data.asMultiMeasureMap(), colNames);
            this.autoInCache("modelNum", model);
            this.setMsg("Total:" + size + "\n" + sqlBuilder);
        } else {
            colNames = new ArrayList<String>(20);
            String sql = (String)paramValues.get("sql");
            DBRoute dbRoute = new DBRoute((String)paramValues.get("dbRoute"));
            List<List<Object>> queryData = this.excuteSql(dbRoute, sql, colNames);
            this.createTable(colNames, false, null);
            this.fillData(queryData, colNames);
        }
        this.autoInCache("colNames", colNames);
        this.setHideOfView(paramValues);
    }

    private void setHideOfView(Map<String, Object> paramValues) {
        Object hidetabandbtn = paramValues.get("hidetabandbtn");
        if (hidetabandbtn != null && ((Boolean)hidetabandbtn).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconsummarypanelap"});
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("hideNav", true);
            this.getView().updateControlMetadata("tabap", map);
        }
    }

    @Override
    protected void setMsg(String msg) {
        this.getModel().setValue("infomationtextarea", (Object)msg);
    }

    private List<List<Object>> excuteSql(DBRoute rout, String sql, final List<String> colNames) {
        if (sql.indexOf(42) > -1) {
            sql = "/*dialect*/" + sql;
        }
        List<List<Object>> rs = new ArrayList<List<Object>>(10);
        try {
            rs = (List)DB.query((DBRoute)rout, (String)sql, (ResultSetHandler)new ResultSetHandler<List<List<Object>>>(){

                public List<List<Object>> handle(ResultSet rs) throws Exception {
                    int i;
                    ArrayList<List<Object>> data = new ArrayList<List<Object>>(10);
                    ResultSetMetaData meta = rs.getMetaData();
                    int colNum = meta.getColumnCount();
                    for (i = 1; i <= colNum; ++i) {
                        colNames.add(meta.getColumnName(i));
                    }
                    i = 0;
                    while (rs.next()) {
                        ArrayList<String> row = new ArrayList<String>(10);
                        ++i;
                        for (int n = 1; n <= colNum; ++n) {
                            row.add(rs.getObject(n) == null ? "" : rs.getObject(n).toString());
                        }
                        data.add(row);
                        if (data.size() < Math.min(SqlQueryResultPlugin.this.getFormCustomParam("limit", 5000), 5000)) continue;
                        break;
                    }
                    return data;
                }
            });
        }
        catch (Exception e) {
            this.setMsg(e.getMessage());
        }
        return rs;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String url = "";
        switch (evt.getItemKey()) {
            case "btn_export": {
                url = this.handleExportData();
                if (!StringUtils.isNotEmpty((CharSequence)url)) break;
                this.downloadFile(url, "bcm_query_mainpage", "47150e89000000ac");
                break;
            }
            case "btn_sql": {
                Pattern p2 = Pattern.compile("(.*from\\s)(\\w*)(.*)");
                Matcher m2 = p2.matcher(this.getView().getFormShowParameter().getCustomParam("sql").toString().toLowerCase(Locale.ENGLISH));
                if (m2.find()) {
                    List<String> colNames = this.getColNames();
                    ArrayList pkids = new ArrayList(10);
                    String fields = String.join((CharSequence)",", colNames);
                    DynamicObjectCollection toExportData = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                    int[] toLoadDatas = ((EntryGrid)this.getView().getControl(KEY_ENTRYENTITY)).getSelectRows();
                    if (toLoadDatas.length > 0) {
                        Arrays.stream(toLoadDatas).forEach(p -> pkids.add(((DynamicObject)toExportData.get(p)).get("FID") + ""));
                    } else {
                        toExportData.forEach(p -> pkids.add(p.get("FID") + ""));
                    }
                    if (toExportData.size() <= 0) break;
                    DBRoute dbRoute = new DBRoute((String)this.getView().getFormShowParameter().getCustomParam("dbRoute"));
                    PreInsDataScriptBuilder pa = new PreInsDataScriptBuilder();
                    Map params = pa.genInsertSQLScript(dbRoute, m2.group(2), fields, String.format("FID IN (%s)", String.join((CharSequence)",", pkids)), "", "");
                    url = params.get("sql").toString();
                    String sqlFileName = String.format("%s_%s.sql", m2.group(2), new SimpleDateFormat("yyyyMMdd").format(new Date()));
                    try {
                        ByteArrayInputStream ins = new ByteArrayInputStream(url.getBytes("UTF-8"));
                        this.getView().openUrl(CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, (InputStream)ins, 5000));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.setMsg(e.getMessage());
                    }
                    break;
                }
                this.setMsg(ResManager.loadKDString((String)"\u8bed\u53e5\u4e0d\u89c4\u8303", (String)"SqlQueryResultPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String dataType = e.getChangeSet()[0].getDataEntity().getDataEntityType().getName();
        if (KEY_ENTRYENTITY.equals(dataType)) {
            DynamicObject row = e.getChangeSet()[0].getDataEntity();
            SaveCommandInfo info = new SaveCommandInfo();
            List<String> colNames = this.getColNames();
            colNames.remove(FacTabFieldDefEnum.FIELD_MONEY.getField().toLowerCase(Locale.ENGLISH));
            String firstDim = colNames.remove(0);
            for (String colName : colNames) {
                info.addfixedDimension(new String[]{colName, row.getString(colName)});
            }
            info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            info.setDimensions(new String[]{firstDim});
            CellSet cellSets = new CellSet(new String[]{firstDim}, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            String newValueStr = row.get(FacTabFieldDefEnum.FIELD_MONEY.getField().toLowerCase(Locale.ENGLISH)).toString();
            if (StringUtils.isEmpty((CharSequence)newValueStr)) {
                cellSets.set(new String[]{row.getString(firstDim)}, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
            } else {
                try {
                    cellSets.set(new String[]{row.getString(firstDim)}, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)InvestUtils.convertToBigDecimal((Object)newValueStr));
                }
                catch (Exception e1) {
                    cellSets.set(new String[]{row.getString(firstDim)}, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)newValueStr);
                }
            }
            OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)this.getPageCache().get("modelNum"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"SqlQueryResultPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> createTable(List<String> cols, boolean isDynamicWidth, String measures) {
        ArrayList<String> colNames = new ArrayList<String>(10);
        Page page = new Page();
        DynamicEntry entry = new DynamicEntry(KEY_ENTRYENTITY);
        LocaleString width = isDynamicWidth ? new LocaleString(90 / cols.size() + "%") : new LocaleString("10%");
        String sign = "";
        String name = "";
        if (isDynamicWidth) {
            for (FacTabFieldDefEnum m : FacTabFieldDefEnum.values()) {
                String measure = m.getField();
                if (measures == null || !measures.contains(measure)) continue;
                TextEditElement element = this.createTextEditElement(measure, measure.toLowerCase(), new LocaleString("10%"), 1);
                if (!ConfigServiceHelper.getGlobalBoolParam((String)"isSupportDML")) {
                    element.setLock("new,edit");
                }
                entry.addElement((Element)element);
                colNames.add(measure.toLowerCase());
            }
        }
        for (String param : cols) {
            if (param.contains("=")) {
                sign = param.split("=")[0];
                name = param.split("=")[1];
            } else {
                sign = name = param;
            }
            Element element = this.buildColEditElement(name, sign, width, 1);
            element.setLock("new,edit");
            element.setFontSize(12);
            entry.addElement(element);
            colNames.add(sign);
        }
        page.addEntry(entry);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        return colNames;
    }

    private Element buildColEditElement(String name, String sign, LocaleString width, int editStyle) {
        if (3 == this.getFromPageType()) {
            Map colNames = (Map)this.getFormCustomParam("colNames");
            if ("fuserid".equalsIgnoreCase(sign)) {
                BaseEditElement element = new BaseEditElement((String)colNames.get("fuserid"), sign, "bos_user");
                element.setWidth(width);
                return element;
            }
            return this.createTextEditElement((String)colNames.get(sign.toLowerCase(Locale.ENGLISH)), sign, width, editStyle);
        }
        return this.createTextEditElement(name, sign, width, editStyle);
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setLock("new,edit,view");
        return textEditElement;
    }

    public SQLBuilder createSQLBuilder(String model, List<String> dimensionKey, Map<String, Object> paramValues, boolean includeCalType) {
        SQLBuilder sql = new SQLBuilder(model);
        Recorder errMsg = new Recorder((Object)"");
        Recorder noAccount = new Recorder((Object)false);
        for (String key : dimensionKey) {
            for (Map.Entry<String, Object> entry : paramValues.entrySet()) {
                String k = entry.getKey();
                if (!k.split("=")[0].equals(key)) continue;
                JSONArray values = (JSONArray)paramValues.get(k);
                sql.addSelectField(new String[]{key});
                if (!values.isEmpty()) {
                    if ("Account".equals(key) && !includeCalType) {
                        HashSet accounts = new HashSet(10);
                        QFBuilder builder = new QFBuilder("model", "=", (Object)MemberReader.findModelIdByNum((String)model));
                        builder.add("number", "in", (Object)values);
                        builder.add("iscaltype", "=", (Object)Character.valueOf('0'));
                        DynamicObjectCollection col = QueryServiceHelper.query((String)"bcm_accountmembertree", (String)"number,iscaltype", (QFilter[])builder.toArray());
                        col.forEach(e -> accounts.add(e.getString("number")));
                        if (accounts.isEmpty()) {
                            noAccount.setRecord((Object)true);
                            continue;
                        }
                        sql.addFilter(key, accounts.toArray(new String[0]));
                        continue;
                    }
                    sql.addFilter(key, (String[])values.toArray((Object[])new String[0]));
                    continue;
                }
                if (!MUSTINPUT.contains(key)) continue;
                errMsg.setRecord((Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"SqlQueryResultPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
        if (((Boolean)noAccount.getRecord()).booleanValue()) {
            return null;
        }
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)errMsg.getRecord()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"SqlQueryResultPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            this.setMsg(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u5f55\u9879\u3002", (String)"SqlQueryResultPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return null;
        }
        return sql;
    }

    private void fillData(Object entryData, List<String> colNames) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String colName : colNames) {
            vs.addField(colName, new Object[0]);
        }
        vs = this.fillDataToVs(colNames, entryData, vs);
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private TableValueSetter fillDataToVs(List<String> colNames, Object entryData, TableValueSetter vs) {
        if (entryData instanceof Map) {
            AtomicInteger measureSize = new AtomicInteger(1);
            ArrayList<List> allData = new ArrayList<List>(16);
            ((Map)entryData).forEach((key, value) -> {
                ArrayList<String> dimCombineList = new ArrayList<String>(16);
                if (value instanceof List) {
                    List listValue = (List)value;
                    listValue.forEach(v -> {
                        if (v instanceof String) {
                            v = String.format("\\\"%s\\\"", v);
                        }
                        dimCombineList.add((String)v);
                    });
                    measureSize.set(listValue.size());
                }
                dimCombineList.addAll(Arrays.asList(key.split("\\|")));
                allData.add(dimCombineList);
            });
            allData.sort(Comparator.comparing(c -> (String)c.get(measureSize.get())).thenComparing(c -> (String)c.get(measureSize.get() + 1)).thenComparing(c -> (String)c.get(measureSize.get() + 2)).thenComparing(c -> (String)c.get(measureSize.get() + 3)).thenComparing(c -> (String)c.get(measureSize.get() + 4)));
            allData.forEach(a -> vs.addRow(a.toArray()));
        } else if (entryData instanceof List) {
            if (3 == this.getFromPageType()) {
                int fopertypeIndex = IntStream.range(0, colNames.size() - 1).filter(i -> "fopertype".equalsIgnoreCase((String)colNames.get(i))).findFirst().orElse(-1);
                if (fopertypeIndex != -1) {
                    ((List)entryData).forEach(data -> {
                        Object[] rowData = data.toArray();
                        Integer fopertype = InvestUtils.convertToInteger((Object)rowData[fopertypeIndex], (Integer)-1000);
                        AdjustOperTypeEnum fopertypeEnum = AdjustOperTypeEnum.getEnumByValue((int)fopertype);
                        if (fopertypeEnum != null) {
                            rowData[fopertypeIndex] = fopertypeEnum.getName();
                        }
                        vs.addRow(rowData);
                    });
                }
            } else {
                ((List)entryData).forEach(p -> vs.addRow(p.toArray()));
            }
        }
        return vs;
    }

    private List<String> getColNames() {
        String cloNamesCache = this.getPageCache().get("colNames");
        if (StringUtil.isEmptyString((String)cloNamesCache)) {
            return new ArrayList<String>(20);
        }
        return (List)ObjectSerialUtil.deSerializedBytes((String)cloNamesCache);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String handleExportData() {
        DynamicObjectCollection toExportData = new DynamicObjectCollection();
        int[] selectRows = ((EntryGrid)this.getControl(KEY_ENTRYENTITY)).getSelectRows();
        if (selectRows.length > 0) {
            for (int i : selectRows) {
                toExportData.add((Object)this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, i));
            }
        } else {
            toExportData = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        }
        if (toExportData == null) throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"SqlQueryResultPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        if (toExportData.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e", (String)"SqlQueryResultPlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        try (XSSFWorkbook workBook = new XSSFWorkbook();){
            XSSFCell cell;
            XSSFCellStyle style = workBook.createCellStyle();
            style.setAlignment(HorizontalAlignment.LEFT);
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFCellStyle headerStyle = workBook.createCellStyle();
            headerStyle.setAlignment(HorizontalAlignment.CENTER);
            headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headerStyle.setBorderTop(BorderStyle.THIN);
            headerStyle.setBorderRight(BorderStyle.THIN);
            headerStyle.setBorderBottom(BorderStyle.THIN);
            headerStyle.setBorderLeft(BorderStyle.THIN);
            short s = 0;
            headerStyle.setFillForegroundColor(s);
            headerStyle.setBottomBorderColor(s);
            headerStyle.setLocked(true);
            XSSFSheet xssfSheet = workBook.createSheet();
            List<String> headerList = this.getColNames();
            int rowNum = 0;
            XSSFRow headerRow1 = xssfSheet.createRow(rowNum);
            Map colNames = (Map)this.getFormCustomParam("colNames");
            for (int i = 0; i < headerList.size(); ++i) {
                cell = headerRow1.createCell(i, CellType.STRING);
                String headName = headerList.get(i);
                cell.setCellValue(colNames == null ? headName : colNames.getOrDefault(headName.toLowerCase(Locale.ENGLISH), headName));
                cell.setCellStyle((CellStyle)headerStyle);
            }
            ++rowNum;
            Object string = toExportData.iterator();
            while (true) {
                XSSFRow xssfRow;
                ArrayList row;
                if (string.hasNext()) {
                    DynamicObject rowData = (DynamicObject)string.next();
                    row = Lists.newArrayListWithExpectedSize((int)headerList.size());
                    for (int i = 0; i < headerList.size(); ++i) {
                        row.add(rowData.get(headerList.get(i)));
                    }
                    xssfRow = xssfSheet.createRow(rowNum);
                } else {
                    string = ImportAndExportUtil.writeFile(workBook, ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c", (String)"SqlQueryResultPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return string;
                }
                for (int j = 0; j < row.size(); ++j) {
                    cell = xssfRow.createCell(j);
                    Object cellData = row.get(j);
                    if (cellData instanceof DynamicObject) {
                        cell.setCellValue(((DynamicObject)cellData).getString("name"));
                    } else if (cellData != null) {
                        if (cellData.toString().length() < SpreadsheetVersion.EXCEL2007.getMaxTextLength()) {
                            cell.setCellValue(cellData.toString());
                        } else {
                            XSSFRichTextString richText = workBook.getCreationHelper().createRichTextString(cellData.toString());
                            cell.setCellValue((RichTextString)richText);
                        }
                    }
                    cell.setCellStyle((CellStyle)style);
                }
                ++rowNum;
            }
        }
        catch (IOException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
    }

    @Override
    public void dealMsg(CommandParam com) {
        if ("exportOlapData".equals(com.getOperation())) {
            String url = this.handleExportData();
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                List<Object> param = com.getParam();
                this.downloadFile(url, (String)param.get(0), (String)param.get(1));
                OpNameMultiLangEnumBridge opName = new OpNameMultiLangEnumBridge("\u5bfc\u51fa\u591a\u7ef4\u6570\u636e", "DataQueryAnalyticsPlugin_13", "fi-bcm-formplugin", "exportOlapData");
                OPDescMultiLangEnumBridge opDes = new OPDescMultiLangEnumBridge("\u5bfc\u51fa\u591a\u7ef4\u6570\u636e\u6210\u529f", "DataQueryAnalyticsPlugin_14", "fi-bcm-formplugin", null);
                this.writeMultiLangLog(opName, opDes);
            }
        } else if ("clearData".equals(com.getOperation())) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
    }
}

