/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AbstractBaseListPlugin;

public class DataSourceList
extends AbstractBaseListPlugin
implements ClickListener {
    private static final String refreshAdd = "refreshadd";
    private static final String CMAPPID = "11H66HLOX4IC";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DataSourceList.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "baritemadd": {
                this.openform();
                break;
            }
            case "baritemdelete": {
                boolean hasPermission = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)CMAPPID, (String)"epbs_datasource", (String)"4715e1f1000000ac");
                if (!hasPermission) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5220\u9664\u6570\u636e\u6e90\u7684\u64cd\u4f5c\u6743\u9650\u3002", (String)"DataSourceList_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillList billlist = (BillList)this.getControl("billlistap");
                Object[] obj = billlist.getSelectedRows().getPrimaryKeyValues();
                QFilter qFilter = new QFilter("id", "in", (Object)obj);
                DynamicObject[] billlistaps = BusinessDataServiceHelper.load((String)"epbs_datasource", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
                if (obj == null || obj.length == 0 || obj.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55,\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"DataSourceList_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection list = this.getQuote(obj[0]);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    String tip = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u88ab\u201c%s\u201d\u4e2a\u4f53\u7cfb\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DataSourceList_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]), list.size());
                    this.openUnDelReason(tip, list);
                    return;
                }
                BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"epbs_datasource"), (Object[])obj);
                for (DynamicObject billlistap : billlistaps) {
                    Object number = billlistap.get("number");
                    Object name = billlistap.get("name");
                    String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"DataSourceList_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                    String opDescriotion = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u5220\u9664\u6210\u529f\u3002", (String)"DataSourceList_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, name);
                    OperationLogUtil.writeOperationLog((String)opName, (String)opDescriotion, (Long)this.getModelId(), (String)"epbs_datasource");
                }
                this.refreshList();
                break;
            }
            case "baritemrefresh": {
                this.refreshList();
                this.clearDataSourceCache();
                break;
            }
        }
    }

    private void openUnDelReason(String msg, DynamicObjectCollection list) {
        String quoteSerial = this.toByteSerialized(list);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_dimensiontips");
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u5217\u8868\u5220\u9664\u63d0\u793a", (String)"DataSourceList_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("title", (Object)msg);
        parameter.setCustomParam("collection", (Object)quoteSerial);
        this.getView().showForm(parameter);
    }

    private void openform() {
        BaseShowParameter showparameter = new BaseShowParameter();
        showparameter.setStatus(OperationStatus.ADDNEW);
        showparameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"DataSourceList_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        showparameter.setFormId("epbs_datasource");
        showparameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack clo = new CloseCallBack((IFormPlugin)this, refreshAdd);
        showparameter.setCloseCallBack(clo);
        this.getView().showForm((FormShowParameter)showparameter);
    }

    private void clearDataSourceCache() {
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bcm_model", (String)"number", null, null);
        if (ds != null) {
            ds.forEachRemaining(m -> {
                String modelNum = m.getString("number");
                ModelDataClearUtils.reMoveCatalogCache((String)modelNum);
            });
        }
    }

    private void refreshList() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
        billlist.clearSelection();
    }

    private DynamicObjectCollection getQuote(Object obj) {
        QFilter qFilter = new QFilter("datasource", "=", obj);
        return QueryServiceHelper.query((String)"bcm_model", (String)"name,number", (QFilter[])qFilter.toArray());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (refreshAdd.equals(e.getActionId())) {
            this.refreshList();
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HashMap<String, ArrayList<Object>> map = null;
        try {
            map = this.getlogMessageMap();
            Iterator<Map.Entry<String, ArrayList<Object>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> value = iterator.next().getValue();
                String number = (String)value.get(0);
                String name = (String)value.get(1);
                String opName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"DataSourceList_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String opDescriotion = String.format(ResManager.loadKDString((String)"\u201c%1$s\uff08%2$s\uff09\u201d\u67e5\u770b\u6210\u529f\u3002", (String)"DataSourceList_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]), number, name);
                OperationLogUtil.writeOperationLog((String)opName, (String)opDescriotion, (Long)this.getModelId(), (String)"epbs_datasource");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private HashMap<String, ArrayList<Object>> getlogMessageMap() {
        ArrayList<Object> selectIdList = new ArrayList<Object>();
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection cos = billlistap.getSelectedRows();
        for (ListSelectedRow listSelectedRow : cos) {
            selectIdList.add(listSelectedRow.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])selectIdList.toArray(), (DynamicObjectType)billlistap.getEntityType());
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        for (DynamicObject dynamicObject : load) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(dynamicObject.getString("number"));
            list.add(dynamicObject.getString("name"));
            map.put(dynamicObject.getPkValue().toString(), list);
        }
        return map;
    }
}

