/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.datatrace;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.linkquery.LinkFormulaUtil;
import kd.fi.bcm.business.linkquery.LinkQueryService;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTraceSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.formplugin.analytics.MDQADataQueryHelper;
import kd.fi.bcm.formplugin.intergration.util.LinkExtDataUtil;
import kd.fi.bcm.formplugin.intergration.util.OlapUtil;
import kd.fi.bcm.formplugin.linkdata.util.LinkDataTraceHelper;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import kd.fi.bcm.spread.model.HeadObject;
import org.apache.commons.lang3.StringUtils;

public class DataTraceHelper {
    protected static final List<String> unfoldToProcess = Arrays.asList("CSTE", "SRPT", "ADJT", "EJET");
    protected static final List<String> unfoldToERpt = Arrays.asList("DIF", "Rpt");
    protected static final List<String> canUnfoldProcessList = Arrays.asList("SRPT", "SADJ", "SCADJ", "SCCADJ", "SEJE");
    private static final String PROCESS_RPT = "RPT";
    private static Map<String, String> isNotNormalDataMap = new HashMap<String, String>(4);

    public static Map<String, List<String>> getUnfoldMapForProcess(Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula, boolean isExistAT, Boolean isDif) {
        HashMap<String, List<String>> unfoldMap = new HashMap<String, List<String>>(16);
        if (convertFormula != null) {
            for (String currency : orgCurrencyMap.values()) {
                if (isExistAT) {
                    unfoldMap.put("EIRpt_" + currency + "_" + "EntityInput", unfoldToProcess);
                    unfoldMap.put("IRpt_" + currency + "_" + "EntityInput", unfoldToProcess);
                } else {
                    unfoldMap.put("EIRpt_" + currency, unfoldToProcess);
                    unfoldMap.put("IRpt_" + currency, unfoldToProcess);
                }
                for (String pro : canUnfoldProcessList) {
                    unfoldMap.put(pro + "_" + currency, Collections.singletonList(PROCESS_RPT.equals(pro.substring(1)) ? "Rpt" : pro.substring(1)));
                }
                if (!isDif.booleanValue()) continue;
                unfoldMap.put("ERpt_" + currency + "_ATTotal", unfoldToERpt);
            }
        }
        return unfoldMap;
    }

    public static List<String> getProcessForUnfold(Sheet sheet, int rowNum, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Boolean ignoreAT) {
        Cell processCell = sheet.getCell(rowNum, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNum, columnIndexMap.get("Currency").intValue());
        Cell audiCell = new Cell();
        if (columnIndexMap.containsKey("AuditTrail")) {
            audiCell = sheet.getCell(rowNum, columnIndexMap.get("AuditTrail").intValue());
        }
        String processNumber = processCell.getUserObject("number").toString();
        String currencyNumber = currencyCell.getUserObject("number").toString();
        if (unfoldMap.get(processNumber + "_" + currencyNumber) != null) {
            return unfoldMap.get(processNumber + "_" + currencyNumber);
        }
        if (audiCell != null && unfoldMap.get(processNumber + "_" + currencyNumber + "_" + (ignoreAT != false ? "EntityInput" : audiCell.getUserObject("number"))) != null) {
            return unfoldMap.get(processNumber + "_" + currencyNumber + "_" + (ignoreAT != false ? "EntityInput" : audiCell.getUserObject("number")));
        }
        return null;
    }

    public static boolean getParentNumber(String number1, String number2, Long modelId) {
        boolean flag = false;
        QFBuilder myqfBuilder = new QFBuilder();
        myqfBuilder.and("model", "=", (Object)modelId);
        QFBuilder my = new QFBuilder("number", "=", (Object)number1);
        QFBuilder my2 = new QFBuilder("number", "=", (Object)number2);
        DynamicObject one = BusinessDataServiceHelper.loadSingle((String)DimEntityNumEnum.getEntieyNumByNumber((String)"Process"), (String)"id,longnumber", (QFilter[])my.and(myqfBuilder).toArray());
        DynamicObject two = BusinessDataServiceHelper.loadSingle((String)DimEntityNumEnum.getEntieyNumByNumber((String)"Process"), (String)"id,longnumber", (QFilter[])my2.and(myqfBuilder).toArray());
        return two.getString("longnumber").startsWith(one.getString("longnumber"));
    }

    public static List<String> getProcessForAllUnfold(String processNumber, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Cell audiCell, Boolean ignoreAT) {
        if (unfoldMap.get(processNumber + "_" + currencyNumber) != null) {
            return unfoldMap.get(processNumber + "_" + currencyNumber);
        }
        if (audiCell != null && unfoldMap.get(processNumber + "_" + currencyNumber + "_" + (ignoreAT != false ? "EntityInput" : audiCell.getUserObject("number"))) != null) {
            return unfoldMap.get(processNumber + "_" + currencyNumber + "_" + (ignoreAT != false ? "EntityInput" : audiCell.getUserObject("number")));
        }
        return null;
    }

    public static DynamicObjectCollection getAllChildrenNodes(String extenddim, String processNumber, Long processid, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, DynamicObjectCollection result, long modelId, Cell audiCell, Boolean ignoreAT) {
        if (Objects.equals(extenddim, "Process") && Objects.nonNull(DataTraceHelper.getProcessForAllUnfold(processNumber, currencyNumber, unfoldMap, columnIndexMap, audiCell, ignoreAT))) {
            QFBuilder myqfBuilder = new QFBuilder();
            List<String> specialprocess = DataTraceHelper.getProcessForAllUnfold(processNumber, currencyNumber, unfoldMap, columnIndexMap, audiCell, ignoreAT);
            myqfBuilder.and("model", "=", (Object)modelId);
            myqfBuilder.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            myqfBuilder.and("number", "in", specialprocess);
            DynamicObjectCollection process = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)"Process"), (String)"id,name,number,isleaf,level,storagetype,longnumber", (QFilter[])myqfBuilder.toArray(), (String)"dseq asc");
            result.addAll((Collection)process);
            for (DynamicObject pro : process) {
                result.addAll((Collection)DataTraceHelper.getAllChildrenNodes("Process", pro.getString("number"), pro.getLong("id"), currencyNumber, unfoldMap, columnIndexMap, result, modelId, audiCell, ignoreAT));
            }
        } else {
            QFBuilder myqfBuilder = new QFBuilder();
            myqfBuilder.and("model", "=", (Object)modelId);
            myqfBuilder.and("parent.id", "=", (Object)processid);
            DynamicObjectCollection process = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)extenddim), (String)"id,name,number,isleaf,level,storagetype,longnumber", (QFilter[])myqfBuilder.toArray(), (String)"dseq asc");
            result.addAll((Collection)process);
        }
        return result;
    }

    public static boolean isIRptEC(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, List<String>> unfoldMap) {
        boolean result = false;
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        Cell audiCell = null;
        if (columnIndexMap.containsKey("AuditTrail")) {
            audiCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        }
        String processNumber = processCell.getUserObject("number").toString();
        String currencyNumber = currencyCell.getUserObject("number").toString();
        if (audiCell != null && unfoldMap.get(processNumber + "_" + currencyNumber + "_" + audiCell.getUserObject("number")) != null) {
            result = true;
        }
        return result;
    }

    public static boolean isCanUnfoldProcessEC(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, List<String>> unfoldMap) {
        boolean result = false;
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        String processNumber = processCell.getUserObject("number").toString();
        String currencyNumber = currencyCell.getUserObject("number").toString();
        if (unfoldMap.get(processNumber + "_" + currencyNumber) != null) {
            result = true;
        } else if (Objects.equals(processNumber, "ERpt") && unfoldMap.get(processNumber + "_" + currencyNumber + "_" + "ATTotal") != null) {
            result = true;
        }
        return result;
    }

    public static boolean isIRptNotEC(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap) {
        boolean result = false;
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        String processNumber = processCell.getUserObject("number").toString();
        String currencyNumber = currencyCell.getUserObject("number").toString();
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        if (("EIRpt".equalsIgnoreCase(processNumber) || "IRpt".equalsIgnoreCase(processNumber)) && !currencyNumber.equalsIgnoreCase(orgCurrencyMap.get(orgCell.getUserObject("number").toString()))) {
            result = true;
        }
        return result;
    }

    public static boolean needChangeAudiForIRptNotEC(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula) {
        boolean result = false;
        if (columnIndexMap.containsKey("AuditTrail") && DataTraceHelper.isIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) {
            Cell audiCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
            if (convertFormula != null && convertFormula.getConvertAudittrial() != null && convertFormula.getConvertAudittrial().equalsIgnoreCase(audiCell.getUserObject("number").toString())) {
                result = true;
            }
        }
        return result;
    }

    public static String[] getMembersFromCollection(DynamicObjectCollection collection) {
        String[] memNumbers = new String[collection.size()];
        for (int j = 0; j < collection.size(); ++j) {
            memNumbers[j] = ((DynamicObject)collection.get(j)).getString("number");
        }
        return memNumbers;
    }

    public static int packUpRowOrCol(IClientViewProxy view, String spreadKey, int rowNumber, int colNumber, Sheet sheet, Cell cell, boolean isH, boolean isCN) {
        if (cell.getUserObject("openCount") != null) {
            int mergeCount;
            int openCount = (Integer)cell.getUserObject("openCount");
            int jumpCount = 1;
            if (openCount > 0) {
                int i;
                LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
                map.put("status", Boolean.valueOf(true));
                ArrayList<Integer> delNumberList = new ArrayList<Integer>(10);
                if (isH) {
                    for (i = 0; i < openCount; ++i) {
                        delNumberList.add(colNumber + jumpCount);
                        sheet.delColumn(colNumber + jumpCount);
                    }
                    map.put("data", delNumberList);
                    SpreadClientInvoker.invokeDelCol(view, spreadKey, map);
                } else {
                    for (i = 0; i < openCount; ++i) {
                        delNumberList.add(rowNumber + jumpCount);
                        sheet.delRow(rowNumber + jumpCount);
                    }
                    map.put("data", delNumberList);
                    SpreadClientInvoker.invokeDelRow(view, spreadKey, map);
                }
            }
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
            String newCellValue = cell.getValue().toString().replace("\u25bd ", "\u25b6 ");
            if (isCN) {
                newCellValue = cell.getValue().toString().replace("\u25bd ", "\u25b6 ");
            }
            int n = mergeCount = cell.getUserObject("mergeCount") == null ? 0 : (Integer)cell.getUserObject("mergeCount");
            if (isH) {
                cellValues.add(DataTraceHelper.packedUpdateCellMap(rowNumber, colNumber - mergeCount, newCellValue));
            } else {
                cellValues.add(DataTraceHelper.packedUpdateCellMap(rowNumber - mergeCount, colNumber, newCellValue));
            }
            cell.setValue((Object)newCellValue);
            SpreadClientInvoker.invokeUpdataValueMethod(view, spreadKey, Lists.newArrayList(cellValues));
            return openCount;
        }
        return 0;
    }

    private static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public static boolean isLeafNodeData(String processDim, String auditDim, long model) {
        if (processDim == null || auditDim == null) {
            return true;
        }
        if (canUnfoldProcessList.contains(processDim)) {
            return false;
        }
        String modelNum = MemberReader.findModelNumberById((Object)model);
        Set leafProcessSet = MemberReader.getAllNodeByDimNum((String)"Process", (String)modelNum).stream().filter(IDNumberTreeNode::isLeaf).map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        Set leafAuditSet = MemberReader.getAllNodeByDimNum((String)"AuditTrail", (String)modelNum).stream().filter(IDNumberTreeNode::isLeaf).map(IDNumberTreeNode::getNumber).collect(Collectors.toSet());
        return auditDim.equalsIgnoreCase(isNotNormalDataMap.get(processDim)) || leafProcessSet.contains(processDim) && leafAuditSet.contains(auditDim);
    }

    public static boolean checkZero(Object value) {
        Boolean money = Boolean.FALSE;
        if (value instanceof BigDecimal) {
            money = BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
        } else {
            BigDecimal result = ExtDataServiceHelper.getBigDecimal((Object)value);
            if (result != null && BigDecimal.ZERO.compareTo(result) == 0) {
                money = Boolean.TRUE;
            }
        }
        return money;
    }

    public static boolean openDataTraceFromHeaderMode(long modelId, Sheet sheet, IFormView view, Map<String, DynamicObject> pageDimDyoMap, Map<String, String> pageDimMap, SpreadSelector selector, String caption, RangeModel rangeModel, Map<String, Pair<String, String>> specialYear) {
        boolean isNeedExcCurrency;
        Header rHeader = sheet.getRowHeader();
        Header cHeader = sheet.getColHeader();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<Map<String, Object>> selectDimCell = new ArrayList<Map<String, Object>>(10);
        String realCurrency = pageDimMap.get(PresetConstant.CURRENCY_DIM);
        boolean isPExitPage = pageDimMap.containsKey(PresetConstant.PROCESS_DIM);
        boolean isEExitPage = pageDimMap.containsKey(PresetConstant.ENTITY_DIM);
        boolean bl = isNeedExcCurrency = "DC".equals(realCurrency) || "EC".equals(realCurrency);
        if (isNeedExcCurrency && isEExitPage && isPExitPage) {
            String orgNum = pageDimMap.get(PresetConstant.ENTITY_DIM);
            String processNum = pageDimMap.get(PresetConstant.PROCESS_DIM);
            Pair pair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)orgNum), (long)modelId, (String)processNum, (String)realCurrency);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                pageDimMap.put(PresetConstant.CURRENCY_DIM, (String)pair.p2);
            }
        }
        ArrayList<String> dimNums = new ArrayList<String>(rHeader.getDimNums());
        dimNums.addAll(cHeader.getDimNums());
        LinkedHashSet<String> noPermMembers = new LinkedHashSet<String>(16);
        boolean modelManage = MemberPermHelper.isModelAdmin((Long)modelId);
        boolean isRemoveCur = false;
        for (int i = selector.getStartRow(); i < selector.getEndRow() + 1; ++i) {
            for (int j = selector.getStartCol(); j < selector.getEndCol() + 1; ++j) {
                Object value;
                Map<String, String> memberMap = MDQADataQueryHelper.getCellDimMemberMap(modelId, rHeader, cHeader, i, j, pageDimMap, rangeModel, specialYear);
                if (memberMap == null || memberMap.isEmpty()) continue;
                Cell cell = sheet.getCell(i, j, false);
                HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
                if (!(!isNeedExcCurrency || isPExitPage && isEExitPage)) {
                    dimNums.add(PresetConstant.CURRENCY_DIM);
                    isRemoveCur = true;
                }
                memberMap.forEach((k, v) -> {
                    if (dimNums.contains(k)) {
                        map.put((String)k, v);
                    }
                });
                Object object = value = cell == null ? null : cell.getValue();
                if (modelManage) {
                    hashMap.put("cellValue", value);
                    selectDimCell.add(hashMap);
                    continue;
                }
                Boolean noPermCellflag = Boolean.TRUE;
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (PermEnum.NOPERM == IntegrationUtil.getMemePerm((Long)modelId, (String)((String)entry.getKey()), (String)entry.getValue().toString())) {
                        noPermMembers.add(entry.getValue().toString());
                        noPermCellflag = false;
                    }
                    if (PermEnum.NOPERM != IntegrationUtil.getMemeClassPerm((Long)modelId, (String)((String)entry.getKey()), (String)entry.getValue().toString())) continue;
                    noPermMembers.add(entry.getValue().toString());
                    noPermCellflag = false;
                }
                hashMap.put("cellValue", value);
                if (!noPermCellflag.booleanValue()) continue;
                selectDimCell.add(hashMap);
            }
        }
        int size = selectDimCell.size();
        if (size > 200) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8d85\u8fc7\u4e86200\u5355\u5143\u683c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataDetailPlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (size < 1 && !noPermMembers.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%s\u6210\u5458\u65e0\u6743\uff0c\u56e0\u6b64\u65e0\u6743\u8054\u67e5\u8be5\u6210\u5458\u7684\u6570\u636e\u3002", (String)"MultiDimQueryAnalysisPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), noPermMembers.iterator().next());
            view.showTipNotification(message);
            return false;
        }
        if (size < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"MultiDimQueryAnalysisPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, Long> orgNumberIdMap = new HashMap<String, Long>();
        DataTraceHelper.buildOrgIdNumberMap(pageDimMap, selectDimCell, orgNumberIdMap, modelId, pageDimDyoMap);
        if (isRemoveCur) {
            pageDimMap.remove("Currency");
        }
        if (!modelManage) {
            String commonDimNoPerm = null;
            for (Map.Entry entry : pageDimMap.entrySet()) {
                if (PermEnum.NOPERM == IntegrationUtil.getMemePerm((Long)modelId, (String)((String)entry.getKey()), (String)((String)entry.getValue()))) {
                    commonDimNoPerm = (String)entry.getValue();
                    break;
                }
                if (PermEnum.NOPERM != IntegrationUtil.getMemeClassPerm((Long)modelId, (String)((String)entry.getKey()), (String)((String)entry.getValue()))) continue;
                commonDimNoPerm = (String)entry.getValue();
                break;
            }
            if (commonDimNoPerm != null) {
                String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%s\u6210\u5458\u65e0\u6743\uff0c\u56e0\u6b64\u65e0\u6743\u8054\u67e5\u8be5\u6210\u5458\u7684\u6570\u636e\u3002", (String)"MultiDimQueryAnalysisPlugin_46", (String)"fi-bcm-formplugin", (Object[])new Object[0]), commonDimNoPerm);
                view.showTipNotification(message);
                return false;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("model", (Object)modelId);
        long schemeId = DataTraceHelper.getClsSchemeId(view);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        ArrayList<String> massage = new ArrayList<String>(1);
        if (!DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Year.getNumber(), modelId, pageDimDyoMap, massage)) {
            view.showTipNotification((String)massage.get(0));
            return false;
        }
        if (!DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Period.getNumber(), modelId, pageDimDyoMap, massage)) {
            view.showTipNotification((String)massage.get(0));
            return false;
        }
        if (!DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Scenario.getNumber(), modelId, pageDimDyoMap, massage)) {
            view.showTipNotification((String)massage.get(0));
            return false;
        }
        showParameter.setCustomParam("orgNumberIdMap", orgNumberIdMap);
        showParameter.setCustomParam("selectDimCell", selectDimCell);
        showParameter.setCustomParam("commonMemberList", pageDimMap);
        showParameter.setCaption(caption);
        showParameter.setFormId("bcm_datatrace");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        boolean supportNewLink = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SUPPORT_NEWLINK.getNumber());
        if (supportNewLink && size == 1) {
            DataTrace2FromService service;
            DataTraceFrom dtf;
            HashMap<String, String> memberMap = new HashMap<String, String>(pageDimMap);
            ((Map)selectDimCell.get(0)).forEach((k, v) -> {
                if (!"cellValue".equals(k)) {
                    memberMap.put((String)k, v.toString());
                }
            });
            Set<String> dims = memberMap.keySet();
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            Boolean isMMark = OlapUtil.getMMarkStatus(modelNum, dims, memberMap);
            if (!isMMark.booleanValue() && (dtf = (service = new DataTrace2FromService(Long.valueOf(modelId), Long.valueOf(0L))).queryDataTraceFrom(memberMap)) != null) {
                if (DataTraceSourceEnum.DI_OUTPUT.getCode().equals(dtf.getF())) {
                    new LinkQueryService(modelId, view).linkDiByDataTrace(dtf, memberMap);
                } else {
                    Map<String, Object> commonParamId = DataTraceHelper.getCommonParamId(MemberReader.findModelNumberById((Object)modelId), memberMap);
                    String traceInfo = LinkQueryUtil.createDimMember(memberMap, (long)modelId);
                    showParameter = LinkFormulaUtil.getLinkQueryParameter((String)JacksonUtils.toJson((Object)dtf), (String)((String)memberMap.get("Entity")), (String)((String)memberMap.get("Year")), (String)((String)memberMap.get("Period")), commonParamId, (String)traceInfo);
                    view.showForm(showParameter);
                }
                return true;
            }
        }
        view.showForm(showParameter);
        return true;
    }

    private static long getClsSchemeId(IFormView view) {
        long schemeId = 0L;
        if (view.getFormShowParameter().getCustomParam("schemeId") != null) {
            schemeId = LongUtil.toLong((Object)view.getFormShowParameter().getCustomParam("schemeId").toString());
        }
        return schemeId;
    }

    public static boolean openLinkData(long modelId, Sheet sheet, IFormView view, Map<String, DynamicObject> pageDimDyoMap, Map<String, String> pageDimMap, SpreadSelector selector, String caption, RangeModel rangeModel) {
        boolean isNeedExcCurrency;
        Header rHeader = sheet.getRowHeader();
        Header cHeader = sheet.getColHeader();
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<Map<String, Object>> selectDimCell = new ArrayList<Map<String, Object>>(10);
        String realCurrency = pageDimMap.get(PresetConstant.CURRENCY_DIM);
        boolean isPExitPage = pageDimMap.containsKey(PresetConstant.PROCESS_DIM);
        boolean isEExitPage = pageDimMap.containsKey(PresetConstant.ENTITY_DIM);
        boolean bl = isNeedExcCurrency = "DC".equals(realCurrency) || "EC".equals(realCurrency);
        if (isNeedExcCurrency && isEExitPage && isPExitPage) {
            String orgNum = pageDimMap.get(PresetConstant.ENTITY_DIM);
            String processNum = pageDimMap.get(PresetConstant.PROCESS_DIM);
            Pair pair = TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)BcmThreadCache.findMemberByNum((String)modelNumber, (String)PresetConstant.ENTITY_DIM, (String)orgNum), (long)modelId, (String)processNum, (String)realCurrency);
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                pageDimMap.put(PresetConstant.CURRENCY_DIM, (String)pair.p2);
            }
        }
        ArrayList<String> dimNums = new ArrayList<String>(rHeader.getDimNums());
        dimNums.addAll(cHeader.getDimNums());
        boolean isRemoveCur = false;
        for (int i = selector.getStartRow(); i < selector.getEndRow() + 1; ++i) {
            for (int j = selector.getStartCol(); j < selector.getEndCol() + 1; ++j) {
                Map<String, String> memberMap = MDQADataQueryHelper.getCellDimMemberMap(modelId, rHeader, cHeader, i, j, pageDimMap, rangeModel, null);
                if (memberMap == null || memberMap.isEmpty()) continue;
                Cell cell2 = sheet.getCell(i, j, false);
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                if (!(!isNeedExcCurrency || isPExitPage && isEExitPage)) {
                    dimNums.add(PresetConstant.CURRENCY_DIM);
                    isRemoveCur = true;
                }
                memberMap.forEach((k, v) -> {
                    if (dimNums.contains(k)) {
                        map.put((String)k, v);
                    }
                });
                Object value = cell2 == null ? null : cell2.getValue();
                map.put("cellValue", value);
                selectDimCell.add(map);
            }
        }
        int size = selectDimCell.size();
        if (size < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"MultiDimQueryAnalysisPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, Long> orgNumberIdMap = new HashMap<String, Long>();
        DataTraceHelper.buildOrgIdNumberMap(pageDimMap, selectDimCell, orgNumberIdMap, modelId, pageDimDyoMap);
        if (isRemoveCur) {
            pageDimMap.remove("Currency");
        }
        if (selectDimCell.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"AbstractMultiReportPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map<String, Set<String>> noPermMap = LinkDataTraceHelper.getNoPermMap(modelId, selectDimCell);
        boolean modelManage = MemberPermHelper.isModelAdmin((Long)modelId);
        ArrayList<Map<String, Object>> newSelectCell = new ArrayList<Map<String, Object>>(10);
        StringJoiner sj = new StringJoiner(",");
        if (modelManage) {
            newSelectCell.addAll(selectDimCell);
        } else {
            selectDimCell.forEach(cell -> {
                boolean havePerm = true;
                for (Map.Entry entry : cell.entrySet()) {
                    if ("cellValue".equals(entry.getKey()) || !((Set)noPermMap.get(entry.getKey())).contains(entry.getValue().toString())) continue;
                    havePerm = false;
                    sj.add((String)entry.getKey() + "|" + entry.getValue());
                }
                if (havePerm) {
                    newSelectCell.add((Map<String, Object>)cell);
                }
            });
        }
        if (newSelectCell.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5bf9%s\u6210\u5458\u65e0\u6743\uff0c\u65e0\u6cd5\u5bf9\u8be5\u5355\u5143\u683c\u8fdb\u884c\u5e95\u7a3f\u5f0f\u8ffd\u6eaf\u3002", (String)"AbstractMultiReportPlugin_849", (String)"fi-bcm-formplugin", (Object[])new Object[0]), sj);
            view.showTipNotification(message);
            return false;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("model", (Object)modelId);
        long schemeId = DataTraceHelper.getSchemeId(orgNumberIdMap, modelNumber);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        ArrayList<String> massage = new ArrayList<String>(1);
        DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Year.getNumber(), modelId, pageDimDyoMap, massage);
        DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Period.getNumber(), modelId, pageDimDyoMap, massage);
        DataTraceHelper.dealYearPeriodScenario(selectDimCell, pageDimMap, showParameter, SysDimensionEnum.Scenario.getNumber(), modelId, pageDimDyoMap, massage);
        showParameter.setCustomParam("orgNumberIdMap", orgNumberIdMap);
        showParameter.setCustomParam("selectDimCell", newSelectCell);
        showParameter.setCustomParam("commonMemberList", pageDimMap);
        showParameter.setCaption(caption);
        showParameter.setFormId("bcm_datatrace");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        LinkedHashMap<String, Pair> pageMemberMap = new LinkedHashMap<String, Pair>(10);
        for (Map.Entry<String, DynamicObject> entry : pageDimDyoMap.entrySet()) {
            if (entry.getKey().equals(SysDimensionEnum.Currency.getNumber()) && pageDimMap.containsKey(SysDimensionEnum.Currency.getNumber())) {
                IDNumberTreeNode node = MemberReader.findCurrencyMemberByNum((String)modelNumber, (String)pageDimMap.get(SysDimensionEnum.Currency.getNumber()));
                pageMemberMap.put(entry.getKey(), Pair.onePair((Object)node.getId(), (Object)node.getNumber()));
                continue;
            }
            pageMemberMap.put(entry.getKey(), Pair.onePair((Object)entry.getValue().getLong("id"), (Object)entry.getValue().getString("number")));
        }
        showParameter.setCustomParam("pageMemberMap", pageMemberMap);
        showParameter.setCustomParam("hideMemberMap", Collections.emptyMap());
        showParameter.setFormId("bcm_linkdata");
        view.showForm(showParameter);
        return true;
    }

    public static void openLinkDataSource(long modelId, Sheet sheet, IFormView view, Map<String, DynamicObject> dimMemDyoMap, Map<String, String> dimMap, SpreadSelector selector, String caption, RangeModel rangeModel, Map<String, Pair<String, String>> specialYear) {
        int r = selector.getStartRow();
        int c = selector.getStartCol();
        if (selector.getEndRow() - r != 0 || selector.getEndCol() - c != 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6570\u636e\u6765\u6e90\u4ec5\u652f\u6301\u5355\u4e00\u5355\u5143\u683c\u3002", (String)"LinkDataTracePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        Cell cell = sheet.getCell(r, c);
        LinkedHashMap<String, Pair<Long, String>> pageDimMap = new LinkedHashMap<String, Pair<Long, String>>(16);
        for (Map.Entry<String, DynamicObject> entry : dimMemDyoMap.entrySet()) {
            pageDimMap.put(entry.getKey(), Pair.onePair((Object)entry.getValue().getLong("id"), (Object)entry.getValue().getString("number")));
        }
        Map<String, String> memberMap = MDQADataQueryHelper.getCellDimMemberMap(modelId, sheet.getRowHeader(), sheet.getColHeader(), r, c, dimMap, rangeModel, specialYear);
        if (memberMap == null || memberMap.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"MultiDimQueryAnalysisPlugin_38", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<String, String> entry : memberMap.entrySet()) {
            if (pageDimMap.containsKey(entry.getKey())) continue;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)entry.getKey(), (String)entry.getValue());
            pageDimMap.put(entry.getKey(), (Pair<Long, String>)Pair.onePair((Object)node.getId(), (Object)node.getNumber()));
        }
        Map<String, Pair<Long, String>> map = DataTraceHelper.getCelInfo(sheet, pageDimMap, r, c);
        if (DataTraceHelper.showLinkTips(view, modelId, map)) {
            return;
        }
        if ("DC".equals(map.get((Object)SysDimensionEnum.Currency.getNumber()).p2) || "EC".equals(map.get((Object)SysDimensionEnum.Currency.getNumber()).p2)) {
            String string = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)((Long)map.get((Object)SysDimensionEnum.Entity.getNumber()).p1).longValue(), (String)((String)map.get((Object)SysDimensionEnum.Process.getNumber()).p2), (String)((String)map.get((Object)SysDimensionEnum.Currency.getNumber()).p2), (long)((Long)map.get((Object)SysDimensionEnum.Year.getNumber()).p1).longValue(), (long)((Long)map.get((Object)SysDimensionEnum.Period.getNumber()).p1).longValue()).p2;
            Pair<Long, String> pair = map.get(SysDimensionEnum.Currency.getNumber());
            IDNumberTreeNode node = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)string);
            map.put(SysDimensionEnum.Currency.getNumber(), (Pair<Long, String>)Pair.onePair((Object)node.getId(), (Object)node.getNumber()));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("model", modelId);
        hashMap.put("redata", cell.getValue());
        hashMap.putAll(map);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_sourcedetail");
        parameter.setCustomParams(hashMap);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(caption);
        view.showForm(parameter);
    }

    private static boolean showLinkTips(IFormView view, long modelId, Map<String, Pair<Long, String>> cellInfo) {
        boolean isBreak = false;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (cellInfo.isEmpty()) {
            isBreak = true;
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u591a\u7ef4\u6570\u636e\u5355\u5143\u683c\u540e\u518d\u8bd5\u3002", (String)"LinkDataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            boolean isDynamic = false;
            for (Map.Entry<String, Pair<Long, String>> entry : cellInfo.entrySet()) {
                IDNumberTreeNode node;
                if (DimEntityNumEnum.ENTITY.getNumber().equals(entry.getKey()) || (node = MemberReader.findMemberById((long)modelId, (String)MemberReader.getEntityNumberByDim((String)modelNum, (String)entry.getKey()), (Long)((Long)entry.getValue().p1))).getStorageType() != StorageTypeEnum.DYNAMIC) continue;
                isDynamic = true;
                break;
            }
            if (!isDynamic) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6570\u636e\u6765\u6e90\u4ec5\u652f\u6301\u52a8\u6001\u8ba1\u7b97\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"LinkDataTracePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                isBreak = true;
            }
        }
        return isBreak;
    }

    private static Map<String, Pair<Long, String>> getCelInfo(Sheet sheet, Map<String, Pair<Long, String>> pageDimMap, int r, int c) {
        LinkedHashMap<String, Pair<Long, String>> cellInfo = new LinkedHashMap<String, Pair<Long, String>>();
        HeadObject rowHead = sheet.getRowHeader().get(r, false);
        HeadObject colHead = sheet.getColHeader().get(c, false);
        if (rowHead != null && colHead != null) {
            for (Map.Entry entry : rowHead.getAllMemberMap().entrySet()) {
                cellInfo.put((String)entry.getKey(), (Pair<Long, String>)Pair.onePair((Object)((Long)((Map)entry.getValue()).get("id")), (Object)((String)((Map)entry.getValue()).get("number"))));
            }
            for (Map.Entry entry : colHead.getAllMemberMap().entrySet()) {
                cellInfo.put((String)entry.getKey(), (Pair<Long, String>)Pair.onePair((Object)((Long)((Map)entry.getValue()).get("id")), (Object)((String)((Map)entry.getValue()).get("number"))));
            }
            cellInfo.putAll(pageDimMap);
        }
        return cellInfo;
    }

    private static Map<String, Object> getCommonParamId(String modelNum, Map<String, String> memberMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("model", MemberReader.findModelIdByNum((String)modelNum));
        result.put(DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.ENTITY.getNumber())).getId());
        result.put(DimTypesEnum.SCENARIO.getNumber(), MemberReader.findScenaMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.SCENARIO.getNumber())).getId());
        result.put(DimTypesEnum.YEAR.getNumber(), MemberReader.findFyMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.YEAR.getNumber())).getId());
        result.put(DimTypesEnum.PERIOD.getNumber(), MemberReader.findPeriodMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.PERIOD.getNumber())).getId());
        result.put(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findCurrencyMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.CURRENCY.getNumber())).getId());
        result.put("memberMap", memberMap);
        return result;
    }

    private static void buildOrgIdNumberMap(Map<String, String> commonMemberMap, List<Map<String, Object>> selectDimCell, Map<String, Long> orgNumberIdMap, long modelId, Map<String, DynamicObject> pageDimDyoMap) {
        if (commonMemberMap.get(SysDimensionEnum.Entity.getNumber()) != null) {
            DynamicObject org = pageDimDyoMap.get(SysDimensionEnum.Entity.getNumber());
            if (org != null) {
                orgNumberIdMap.put(org.getString("number"), org.getLong("id"));
                commonMemberMap.put(SysDimensionEnum.Entity.getNumber(), org.getString("number"));
            }
            return;
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        for (Map<String, Object> map : selectDimCell) {
            Object entity = map.get("Entity");
            IDNumberTreeNode entityMember = MemberReader.findMemberByNumber((String)modelNumber, (String)"Entity", (String)entity.toString());
            orgNumberIdMap.put(entityMember.getNumber(), entityMember.getId());
        }
    }

    private static boolean dealYearPeriodScenario(List<Map<String, Object>> selectDimCell, Map<String, String> commonMemberMap, FormShowParameter showParameter, String dimNum, long modelId, Map<String, DynamicObject> pageDimDyoMap, List<String> massage) {
        String yearNum = "";
        String memberNum = "";
        if (commonMemberMap.get(dimNum) == null) {
            for (Map<String, Object> dimCell : selectDimCell) {
                if (dimCell.get(dimNum) == null) continue;
                if (yearNum.length() == 0) {
                    yearNum = (String)dimCell.get(dimNum);
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and("number", "=", (Object)yearNum);
                    DynamicObject obj = QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)"id,number,parent", (QFilter[])new QFilter[]{qFilter});
                    if (SysDimensionEnum.Year.getNumber().equals(dimNum) && !"AllYear".equals(MemberReader.findFyMemberById((Long)modelId, (Long)obj.getLong("parent")).getNumber())) {
                        massage.add(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7cfb\u7edf\u662f\u5426\u5b58\u5728\u8be5\u8d22\u5e74\u3002", (String)"AbstractMultiReportPlugin_252", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new Object[0]));
                        return false;
                    }
                    memberNum = obj.getString("number");
                    showParameter.setCustomParam(dimNum.toLowerCase(Locale.ENGLISH), (Object)obj.getLong("id"));
                    continue;
                }
                if (memberNum.equalsIgnoreCase((String)dimCell.get(dimNum))) continue;
                if (SysDimensionEnum.Year.getNumber().equals(dimNum)) {
                    massage.add(ResManager.loadKDString((String)"\u8d22\u5e74\u53ea\u80fd\u9009\u4e00\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractMultiReportPlugin_84", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else if (SysDimensionEnum.Period.getNumber().equals(dimNum)) {
                    massage.add(ResManager.loadKDString((String)"\u671f\u95f4\u53ea\u80fd\u9009\u4e00\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractMultiReportPlugin_85", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                } else if (SysDimensionEnum.Scenario.getNumber().equals(dimNum)) {
                    massage.add(ResManager.loadKDString((String)"\u60c5\u666f\u53ea\u80fd\u9009\u4e00\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractMultiReportPlugin_86", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
        } else {
            DynamicObject dynamicObject = pageDimDyoMap.get(dimNum);
            if (dynamicObject != null) {
                showParameter.setCustomParam(dimNum.toLowerCase(Locale.ENGLISH), (Object)dynamicObject.getLong("id"));
            }
        }
        return true;
    }

    private static long getSchemeId(Map<String, Long> orgNumberIdMap, String modelNum) {
        for (Map.Entry<String, Long> entry : orgNumberIdMap.entrySet()) {
            IDNumberTreeNode node = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)entry.getValue());
            if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
            return (Long)node.getProperty("cslscheme.id");
        }
        return 0L;
    }

    public static boolean openExtDataTrace(long modelId, Sheet sheet, IFormView view, Map<String, DynamicObject> pageDimDyoMap, Map<String, String> pageDimMap, SpreadSelector selector, String caption, RangeModel rangeModel, Map<String, Pair<String, String>> specialYear) {
        String dimStr;
        int c;
        int r;
        List selections = selector.getSelections();
        if (selector.isMultiSelectCells() && selections == null || selections != null && selections.size() != 1) {
            return false;
        }
        if (selections != null) {
            Map map = (Map)selections.get(0);
            if ((Integer)map.get("rowCount") != 1 || (Integer)map.get("colCount") != 1) {
                return false;
            }
            r = (Integer)map.get("row");
            c = (Integer)map.get("col");
        } else {
            r = selector.getStartRow();
            c = selector.getStartCol();
        }
        Map selectCellDimMap = null;
        try {
            Map<String, Object> cellInfo = MDQADataQueryHelper.getCellInfo(modelId, sheet.getRowHeader(), sheet.getColHeader(), r, c, pageDimMap, false, null, null, false, false, rangeModel, specialYear);
            if (cellInfo != null) {
                if (cellInfo.isEmpty()) {
                    return false;
                }
                selectCellDimMap = MDQADataQueryHelper.getValue(cellInfo, "dimNumber2MembNumber", new HashMap());
            }
        }
        catch (Exception cellInfo) {
            // empty catch block
        }
        if (selectCellDimMap == null || selectCellDimMap.isEmpty()) {
            return false;
        }
        if (LinkExtDataUtil.processByAdj.contains(selectCellDimMap.get("Process")) && pageDimMap.containsKey(SysDimensionEnum.Entity.getNumber())) {
            DynamicObject org = pageDimDyoMap.get(SysDimensionEnum.Entity.getNumber());
            selectCellDimMap.put(SysDimensionEnum.Entity.getNumber(), LinkExtDataUtil.parent2ChildEntity(modelId, org.getLong("id")));
        }
        if (LinkExtDataUtil.existExtData(dimStr = LinkExtDataUtil.getTotalDimStr(selectCellDimMap, modelId), modelId)) {
            FormShowParameter parameter = LinkExtDataUtil.getLinkExtDataParameter(modelId, selectCellDimMap, dimStr);
            view.showForm(parameter);
            return true;
        }
        return false;
    }

    static {
        isNotNormalDataMap.put("ADJ", "RptDS");
        isNotNormalDataMap.put("ERAdj", "RptDS");
        isNotNormalDataMap.put("EIRpt", "ADJE");
        isNotNormalDataMap.put("IRpt", "ADJE");
    }
}

