/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.datatrace;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.query.BaseConvertFormula;
import kd.fi.bcm.business.convert.util.ConvertSchemeServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.integrationnew.model.DataTraceFrom;
import kd.fi.bcm.business.integrationnew.service.DataTrace2FromService;
import kd.fi.bcm.business.linkquery.LinkFormulaUtil;
import kd.fi.bcm.business.linkquery.LinkQueryService;
import kd.fi.bcm.business.linkquery.LinkQueryUtil;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.ISqlLazyFilter;
import kd.fi.bcm.business.sql.MDColumn;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DataTraceSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.formplugin.analytics.SearchHelper;
import kd.fi.bcm.formplugin.datatrace.DataTraceHelper;
import kd.fi.bcm.formplugin.intergration.util.LinkExtDataUtil;
import kd.fi.bcm.formplugin.intergration.util.OlapUtil;
import kd.fi.bcm.formplugin.pageinteraction.MainPage;
import kd.fi.bcm.formplugin.spread.SpreadClientInvoker;
import kd.fi.bcm.formplugin.spread.SpreadEasyInvoker;
import kd.fi.bcm.formplugin.template.AbstractTemplateBasePlugin;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadSelector;
import kd.fi.bcm.spread.domain.view.event.EventConstant;
import kd.fi.bcm.spread.domain.view.js.SpreadProperties;
import org.apache.commons.lang3.StringUtils;

public class DataTracePlugin
extends AbstractTemplateBasePlugin
implements MainPage {
    private static String spreadKey = "report";
    private static String UNAGGROW = "unaggrow";
    private static final String ISCANDIF = "candif";
    private static final Set<String> doNotShowHyperlink = new HashSet<String>(Arrays.asList("ADJT", "SADJ", "EJET", "SEJE", "CCTotal", "CC", "PRPT", "ARPT", "Rpt", "ERpt", "CT", "CSTE", "SRPT", "SCADJ", "SCCADJ", "SEIC", "SEOE", "SEOther", "SEIT", "SECF"));
    private static final Set<String> doNotIncludeSub = new HashSet<String>(Arrays.asList("Account", "ChangeType", "Currency", "Process", "AuditTrail"));
    private static final String[] staticFixHeads = new String[]{"Process", "AuditTrail", "Entity", "Account", "ChangeType", "Currency"};
    private static final String[] staticFixHeadsATCT = new String[]{"Process", "Entity", "Account", "Currency"};
    private static final String[] staticFixHeads1 = new String[]{"Entity", "Account", "ChangeType", "Currency"};
    private static final String[] staticFixHeads1ATCT = new String[]{"Entity", "Account", "Currency"};
    private static final String[] staticDifTraceProcess = new String[]{"ERpt", "DIF", "Rpt"};
    private static final Set<String> staticExpandOCProcess = Stream.of("ERpt", "Rpt", "EIRpt", "IRpt", "ERAdj", "RAdj").collect(Collectors.toSet());
    private static final String[] selectDimList = new String[]{"Entity", "AuditTrail", "Process", "Currency"};
    private static final String[] selectDimListATCT = new String[]{"Entity", "Process", "Currency"};
    private static final String UNFOLDFILED = "unfoldFiled";
    private static final String TRACE_MODEL = "tracemodel";
    private boolean supportNewLink = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SUPPORT_NEWLINK.getNumber());
    private static final String UNFOLD_TO_X = "unfoldtox";
    private static final String FATHER_CURRENCY = "fatherCurrency";
    private static final String CELL_VALUE = "cellValue";
    public static final String EXPAND_PLUS = "\u25b6 ";
    public static final String EXPAND_SUB = "\u25bd ";
    private static final String PEER_ALIGNMENT = "    ";
    private static final String ISEXPANDOC = "isExpandOC";
    private static final String EXPANDOC = "expandOC";
    private Pair<String, Set<String>> ocPair = null;

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners("toolbarap");
    }

    @Override
    public String getSpreadKey() {
        return spreadKey;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        Sheet sheet = this.getEffectiveSheet();
        switch (key) {
            case "btn_showallcolumn": {
                String inputMode = this.getModel().getValue("hiddeninfo").toString();
                HashMap<String, LocaleString> captionInfo2 = new HashMap<String, LocaleString>(16);
                if ("hidden".equals(inputMode)) {
                    this.getModel().setValue("hiddeninfo", (Object)"isdisplay");
                    captionInfo2.put("text", new LocaleString(ResManager.loadKDString((String)"\u9690\u85cf\u5176\u4f59\u5217", (String)"DataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    this.setColumnDisplay(sheet, true);
                } else {
                    this.getModel().setValue("hiddeninfo", (Object)"hidden");
                    captionInfo2.put("text", new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u6240\u6709\u5217", (String)"DataTracePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
                    this.setColumnDisplay(sheet, false);
                }
                this.getView().updateControlMetadata("btn_showallcolumn", captionInfo2);
                break;
            }
            case "btn_packup": {
                this.packUp(sheet);
                break;
            }
            case "btn_export": {
                HashMap<String, String> map2 = new HashMap<String, String>(16);
                map2.put(SpreadProperties.ExportExcelFileMethod.FILENAME.k(), ResManager.loadKDString((String)"\u6570\u636e\u8ffd\u6eaf", (String)"DataTracePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                SpreadClientInvoker.invokeExportExcelFileMethod(this.getClientViewProxy(), spreadKey, map2);
                break;
            }
            case "btn_unfolddescendant": {
                this.unfoldAllDescendants(-9999);
                break;
            }
            case "btn_unfoldlevel1": {
                this.unfoldAllDescendants(1);
                break;
            }
            case "btn_unfoldlevel2": {
                this.unfoldAllDescendants(2);
                break;
            }
            case "btn_unfoldlevel3": {
                this.unfoldAllDescendants(3);
                break;
            }
            case "btn_unfoldlevelX": {
                this.unfoldLevelToX();
                break;
            }
            case "linkdata": {
                this.linkData();
                break;
            }
            case "btn_link_integration": {
                this.linkIntegration();
                break;
            }
            case "unfoldbyorg": {
                this.getPageCache().put(UNFOLDFILED, "Entity");
                this.packUp(sheet);
                this.visibleButton();
                break;
            }
            case "unfoldbyprocess": {
                this.getPageCache().put(UNFOLDFILED, "Process");
                this.packUp(sheet);
                this.visibleButton();
                break;
            }
            case "difmodel": {
                List selectDimCell = (List)this.getFormCustomParam("selectDimCell");
                this.handleProcessCS(selectDimCell);
                Map<String, Object> dimList = this.getMemberFromJson(selectDimCell);
                Map commonMemberList = (Map)this.getFormCustomParam("commonMemberList");
                commonMemberList.forEach((k, v) -> dimList.put((String)k, v));
                long modelId = (Long)this.getFormCustomParam("model");
                String orgNum = dimList.get("Entity").toString();
                String processNum = dimList.get("Process").toString();
                String curNum = dimList.get("Currency").toString();
                String auditNum = dimList.get("AuditTrail").toString();
                String cube = MemberReader.findModelNumberById((Object)modelId);
                IDNumberTreeNode pnode = MemberReader.findProcessMemberByNum((String)cube, (String)"DIF");
                IDNumberTreeNode onode = MemberReader.findEntityMemberByNum((String)cube, (String)orgNum);
                if (pnode == IDNumberTreeNode.NotFoundTreeNode) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc7\u7a0b\u65e0\u5dee\u989d\u6210\u5458\uff0c\u8bf7\u5148\u5230\u7ef4\u5ea6\u9875\u9762\u751f\u6210\u5408\u5e76\u5dee\u989d\u8fc7\u7a0b\u6210\u5458\u3002", (String)"DataTracePlugin_27", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(ISCANDIF, "1");
            }
            case "normalmode": {
                this.getPageCache().put(UNFOLDFILED, "Entity");
                this.getPageCache().put(TRACE_MODEL, key);
                this.packUp(sheet);
                this.changeModel(key);
                break;
            }
            case "btn_name": 
            case "btn_number": 
            case "btn_numname": {
                this.getModel().setValue("showtype", (Object)key);
                this.changeDisplay(sheet, key);
                break;
            }
        }
    }

    private void unfoldLevelToX() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_unfoldtox");
        param.setCustomParam("operationKey", (Object)"btn_unfoldtox");
        param.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"AnalyticsSolutionDataPlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UNFOLD_TO_X));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (UNFOLD_TO_X.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            int x = (Integer)closedCallBackEvent.getReturnData();
            this.unfoldAllDescendants(x);
        }
    }

    private void clearSpreadData(Sheet sheet) {
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        int rowCount = sheet.getMaxRowCount();
        ArrayList<Integer> delNumberList = new ArrayList<Integer>(rowCount);
        for (int i = 1; i < rowCount; ++i) {
            delNumberList.add(1);
            sheet.delRow(1);
        }
        map.put("data", delNumberList);
        SpreadClientInvoker.invokeDelRow(this.getClientViewProxy(), spreadKey, map);
        SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), spreadKey, map);
    }

    private void packUp(Sheet sheet) {
        this.clearSpreadData(sheet);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        this.buildSpreadData(sheet, cellValues, columnIndexMap);
    }

    @Override
    public void showFormulaPanel(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u9875\u9762\u6682\u4e0d\u652f\u6301\u516c\u5f0f\u5411\u5bfc\u3002", (String)"DataTracePlugin_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
    }

    public void unfoldAllDescendants() {
        this.unfoldAllDescendants(-9999);
    }

    public void unfoldAllDescendants(int unfoldLevel) {
        Sheet sheet = this.getEffectiveSheet();
        SpreadSelector selector = this.getSpreadSelector();
        int selectRow = selector.getEndRow() - selector.getStartRow();
        int selectCol = selector.getEndCol() - selector.getStartCol();
        int rowNumber = selector.getStartRow();
        int colNumber = selector.getStartCol();
        Cell selectCell = sheet.getCell(rowNumber, colNumber);
        Object dimNumber = sheet.getCell(0, colNumber).getUserObject("number");
        if (dimNumber != null && this.checkUnfold(dimNumber.toString(), unfoldLevel).booleanValue()) {
            return;
        }
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        if (rowNumber > 0 && selectRow == 0 && selectCol == 0 && selectCell.getUserObject("number") != null) {
            if (colNumber != columnIndexMap.get("rMoney") && colNumber != columnIndexMap.get("fMoney")) {
                String values = selectCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
                if (values.startsWith(EXPAND_PLUS)) {
                    this.unfoldAllRow(sheet, rowNumber, colNumber, unfoldLevel);
                } else if (values.startsWith(EXPAND_SUB)) {
                    this.packUpRow(rowNumber, colNumber, sheet, selectCell);
                    this.unfoldAllRow(sheet, rowNumber, colNumber, unfoldLevel);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u5355\u5143\u683c\u3002", (String)"DataTracePlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean checkUnfold(String number, int unfoldLevel) {
        if (unfoldLevel == -9999) {
            return Boolean.FALSE;
        }
        if ("AuditTrail".equals(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22\u7ef4\u5ea6\u4e0d\u652f\u6301\u5c55\u5f00\u52301/2/3/X\u7ea7\uff0c\u8bf7\u76f4\u63a5\u5c55\u5f00\u6240\u6709\u4e0b\u7ea7\u3002", (String)"DataTracePlugin_24", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if ("Process".equals(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5408\u5e76\u8fc7\u7a0b\u7ef4\u5ea6\u4e0d\u652f\u6301\u5c55\u5f00\u52301/2/3/X\u7ea7\uff0c\u8bf7\u76f4\u63a5\u5c55\u5f00\u6240\u6709\u4e0b\u7ea7\u3002", (String)"DataTracePlugin_25", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if (unfoldLevel <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"AnalyticsCheckService_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void unfoldAllRow(Sheet sheet, int rowNumber, int colNumber, int unfoldLevel) {
        boolean isOrgUnfold = this.isOrgUnfold();
        int selectDimLevel = Integer.parseInt(sheet.getCell(rowNumber, colNumber).getUserObject().get((Object)"level").toString());
        Pair<Integer, String> insertRowCount = this.addNewRow(rowNumber, colNumber, sheet, isOrgUnfold);
        if ((Integer)insertRowCount.p1 > 0) {
            int maxOpeRowCount = rowNumber + (Integer)insertRowCount.p1;
            for (int i = rowNumber + 1; i < maxOpeRowCount + 1; ++i) {
                Cell cell = sheet.getCell(i, colNumber);
                String tempValues = cell.getValue().toString().replaceAll("^[\u3000 ]+", "");
                int dimLevel = Integer.parseInt(cell.getUserObject().get((Object)"level").toString());
                if (!tempValues.startsWith(EXPAND_PLUS) || unfoldLevel != -9999 && dimLevel - selectDimLevel >= unfoldLevel) continue;
                Pair<Integer, String> insertCount = this.addNewRow(i, colNumber, sheet, isOrgUnfold);
                if ((Integer)insertCount.p1 <= 0) continue;
                maxOpeRowCount += ((Integer)insertCount.p1).intValue();
            }
        } else {
            String msg = StringUtils.isEmpty((CharSequence)((CharSequence)insertRowCount.p2)) ? ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (String)insertRowCount.p2;
            this.getView().showTipNotification(msg);
        }
        this.cacheSpreadModel();
    }

    private void afterAddNewRows(Sheet sheet, int rowNumber, Cell clickCell, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int insertRowCount, Set<Integer> hyperlinkSet, Set<Integer> grayBackColorRows) {
        if (insertRowCount > 0) {
            SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
            SearchHelper.updateDataTraceParenOpenRowCount(sheet, clickCell, insertRowCount, true);
            Set<Integer> unAggRows = this.getUnAggRowfromCache();
            Iterator<Integer> iterator = unAggRows.iterator();
            HashSet<Integer> newRow = new HashSet<Integer>(10);
            while (iterator.hasNext()) {
                int row = iterator.next();
                if (row <= rowNumber) continue;
                iterator.remove();
                newRow.add(row + insertRowCount);
            }
            unAggRows.addAll(newRow);
            SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, rowNumber + 1, 0, insertRowCount, sheet.getMaxColumnCount(), "#FFFFFF", false);
            if (!unAggRows.contains(rowNumber)) {
                SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, rowNumber, 0, 1, sheet.getMaxColumnCount(), "#eff3fd", false);
            }
            for (Integer row : grayBackColorRows) {
                SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, row, 0, 1, sheet.getMaxColumnCount(), "#cbcbcb", false);
            }
            unAggRows.addAll(grayBackColorRows);
            this.cacheUnAggRow(unAggRows);
            SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, rowNumber + 1, 0, insertRowCount, sheet.getMaxColumnCount());
            this.setTwoPoint(sheet, columnIndexMap);
            for (int num : hyperlinkSet) {
                spreadEasyInvoker.setHyperLinkCellSimple(num, columnIndexMap.get("fMoney"), 1, 1, "openDataEntry");
            }
            int clickRowNum = clickCell.getRow();
            Cell rMoneyCell = sheet.getCell(clickRowNum, columnIndexMap.get("rMoney").intValue());
            if (rMoneyCell.getUserObject("needChangeColor") != null) {
                SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, clickRowNum, columnIndexMap.get("rMoney"), 1, 1, "#ffd4aa", false);
            }
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        }
    }

    private Set<Integer> getUnAggRowfromCache() {
        Set<Integer> result = this.getPageCache().get(UNAGGROW) != null ? (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(UNAGGROW), Set.class) : new HashSet<Integer>(10);
        return result;
    }

    private void cacheUnAggRow(Set<Integer> rows) {
        this.getPageCache().put(UNAGGROW, SerializationUtils.toJsonString(rows));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildAllData(false);
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
        if (!ApplicationTypeEnum.RPT.getAppnum().equals(this.getBizAppId())) {
            spreadEasyInvoker.addContextMenuItem("linkDataSource", ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6765\u6e90", (String)"AbstractMultiReportPlugin_227", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        }
        spreadEasyInvoker.addContextMenuItem("unfoldAllDescendants", ResManager.loadKDString((String)"\u5c55\u5f00\u6240\u6709\u4e0b\u7ea7", (String)"DataTracePlugin_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        this.settingButtonIsVisibleByConfigParam();
        if (!this.supportNewLink) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"linkdata"});
        }
        DataTracePlugin.hideContextMenu(this.getClientViewProxy(), spreadKey);
    }

    private void initOCSet() {
        Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        boolean openOc = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM031");
        if (!openOc) {
            return;
        }
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter ocQf = new QFilter("isoriginalcur", "=", (Object)"1");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"dimension.id, longnumber", (QFilter[])new QFilter[]{modelQf, ocQf});
        if (dynamicObject == null) {
            return;
        }
        long dimensionId = dynamicObject.getLong("dimension.id");
        String dimensionNum = MemberReader.getDimensionNumById((long)dimensionId);
        QFilter dimensionQf = new QFilter("dimension.id", "=", (Object)dimensionId);
        QFilter longNumQf = new QFilter("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + "!%"));
        DynamicObjectCollection numbers = QueryServiceHelper.query((String)"bcm_userdefinedmembertree", (String)"number", (QFilter[])new QFilter[]{modelQf, dimensionQf, longNumQf});
        this.ocPair = Pair.onePair((Object)dimensionNum, numbers.stream().map(e -> e.getString("number")).collect(Collectors.toSet()));
        this.getPageCache().put("OCDim", (String)this.ocPair.p1);
        this.getPageCache().put("OCNumber", this.ocPair.p2 == null ? null : JSONObject.toJSONString((Object)this.ocPair.p2));
    }

    public static void hideContextMenu(IClientViewProxy viewProxy, String spreadKey) {
        ArrayList<Map> MenuItems = new ArrayList<Map>(10);
        MenuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.sort, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
        SpreadClientInvoker.invokeHideContextMenuItems(viewProxy, spreadKey, MenuItems);
    }

    private void settingButtonIsVisibleByConfigParam() {
        if (!ConfigServiceHelper.isHwApp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_link_integration"});
        }
        this.visibleButton();
    }

    private void visibleButton() {
        if (this.isDifModel().booleanValue()) {
            this.changeModel("difmodel");
        } else {
            this.getPageCache().put(TRACE_MODEL, "normalmode");
            this.changeModel("normalmode");
        }
        if (this.isOrgUnfold()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unfoldbyorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unfoldbyprocess"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unfoldbyorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unfoldbyprocess"});
        }
        if (OlapCommandUtil.checkMeasure((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isdatasourcetag"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdatasourcetag"});
        }
    }

    private void buildAllData(boolean needClearSheet) {
        this.setPageDimValue();
        this.initOCSet();
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        Sheet sheet = this.getEffectiveSheet();
        if (needClearSheet) {
            this.clearAllContent(sheet);
        }
        this.buildSpreadHead(sheet, cellValues);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, 0, 0, 1, sheet.getMaxColumnCount(), "#f4f4f4", true);
        this.setFrozen();
        this.setColumnWidth(sheet.getMaxColumnCount(), columnIndexMap);
        this.setColumnDisplay(sheet, false);
        this.getPageCache().put(UNFOLDFILED, "Entity");
        this.getPageCache().put(TRACE_MODEL, "normalmode");
        this.buildSpreadData(sheet, cellValues, columnIndexMap);
    }

    private void clearAllContent(Sheet sheet) {
        SearchHelper.clearSheet(sheet, spreadKey, this.getClientViewProxy());
        int insertCount = 0;
        if (SearchHelper.getObjectCache(this.getView(), "tranceInsertCount") != null) {
            insertCount = (Integer)SearchHelper.getObjectCache(this.getView(), "tranceInsertCount");
            LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
            map.put("status", Boolean.valueOf(true));
            ArrayList<Integer> delNumberList = new ArrayList<Integer>(insertCount);
            for (int i = 0; i < insertCount; ++i) {
                delNumberList.add(1);
                sheet.delRow(1);
            }
            map.put("data", delNumberList);
            SpreadClientInvoker.invokeDelRow(this.getClientViewProxy(), spreadKey, map);
            SearchHelper.setObjectCache(this.getView(), "tranceInsertCount", null);
        }
    }

    private void setColumnDisplay(Sheet sheet, boolean isDisplay) {
        List<String> fixHead = Arrays.asList("Process", "AuditTrail", "Entity", "Account", "ChangeType", "Currency", "fMoney", "rMoney");
        if (!this.isExistAuditTrailDimension()) {
            fixHead = Arrays.asList("Process", "Entity", "Account", "Currency", "fMoney", "rMoney");
        }
        int colSize = (Integer)SearchHelper.getObjectCache(this.getView(), "colSize") + 2;
        int[] colArray = new int[colSize - fixHead.size()];
        int index = 0;
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            String dinNumber;
            Cell cell = sheet.getCell(0, i);
            if (cell.getUserObject("number") == null || fixHead.contains(dinNumber = (String)cell.getUserObject("number"))) continue;
            colArray[index] = i;
            ++index;
        }
        SpreadEasyInvoker.setColumnVisble(this.getClientViewProxy(), spreadKey, colArray, isDisplay);
    }

    private void changeDisplay(Sheet sheet, String type) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        for (int i = 1; i < sheet.getTable().size(); ++i) {
            for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
                Cell cell = sheet.getCell(i, j);
                if (cell.getUserObject("name") == null || cell.getUserObject("number") == null) continue;
                String dinNumber = (String)cell.getUserObject("number");
                String dinName = (String)cell.getUserObject("name");
                String value = cell.getValue().toString();
                StringBuilder sb = new StringBuilder();
                if (value.startsWith(EXPAND_PLUS) || value.startsWith(EXPAND_SUB)) {
                    sb.append(value, 0, 2);
                }
                this.appendAgg(sb, value);
                switch (type) {
                    case "btn_number": {
                        sb.append(dinNumber);
                        break;
                    }
                    case "btn_name": {
                        sb.append(dinName);
                        break;
                    }
                    case "btn_numname": {
                        sb.append(dinName);
                        sb.append("|");
                        sb.append(dinNumber);
                        break;
                    }
                }
                cell.setValue((Object)sb.toString());
                cellValues.add(this.packedUpdateCellMap(cell.getRow(), cell.getCol(), sb.toString()));
            }
        }
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        this.cacheSpreadModel();
    }

    private void appendAgg(StringBuilder sb, String value) {
        if (value.contains(AggOprtEnum.ADD.getMiniDesc())) {
            sb.append(AggOprtEnum.ADD.getMiniDesc());
        } else if (value.contains(AggOprtEnum.SUBSTRACT.getMiniDesc())) {
            sb.append(AggOprtEnum.SUBSTRACT.getMiniDesc());
        } else if (value.contains(AggOprtEnum.MULTI.getMiniDesc())) {
            sb.append(AggOprtEnum.MULTI.getMiniDesc());
        } else if (value.contains(AggOprtEnum.DIVIDE.getMiniDesc())) {
            sb.append(AggOprtEnum.DIVIDE.getMiniDesc());
        } else if (value.contains(AggOprtEnum.SKIP.getMiniDesc())) {
            sb.append(AggOprtEnum.SKIP.getMiniDesc());
        } else if (value.contains(AggOprtEnum.NONE.getMiniDesc())) {
            sb.append(AggOprtEnum.NONE.getMiniDesc());
        }
    }

    private void setPageDimValue() {
        this.getModel().setValue("model", this.getFormCustomParam("model"));
        this.getModel().setValue("year", this.getFormCustomParam("year"));
        this.getModel().setValue("period", this.getFormCustomParam("period"));
        this.getModel().setValue("scenario", this.getFormCustomParam("scenario"));
    }

    private void buildSpreadHead(Sheet sheet, List<Map<String, Object>> cellValues) {
        DynamicObjectCollection col = this.getAllDimInfo();
        HashMap<String, DynamicObject> allDimMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject obj : col) {
            allDimMap.put(obj.getString("number"), obj);
        }
        SearchHelper.setObjectCache(this.getView(), "colSize", col.size());
        int colIndex = 0;
        String[] fixHead = staticFixHeads;
        if (!this.isExistAuditTrailDimension()) {
            fixHead = staticFixHeadsATCT;
        }
        if ("org".equalsIgnoreCase(this.getModel().getValue("trancedim").toString())) {
            fixHead = staticFixHeads1;
            if (!this.isExistAuditTrailDimension()) {
                fixHead = staticFixHeads1ATCT;
            }
            colIndex = this.buildFixDim(sheet, cellValues, allDimMap, fixHead, true, colIndex) + 1;
            fixHead = new String[]{"Process", "AuditTrail"};
            if (!this.isExistAuditTrailDimension()) {
                fixHead = new String[]{"Process"};
            }
            colIndex = this.buildFixDim(sheet, cellValues, allDimMap, fixHead, false, colIndex);
        } else {
            colIndex = this.buildFixDim(sheet, cellValues, allDimMap, fixHead, true, colIndex) + 1;
        }
        for (DynamicObject dim : allDimMap.values()) {
            Cell hideCell = sheet.getCell(0, colIndex);
            hideCell.setValue((Object)dim.getString("name"));
            hideCell.setUserObject("number", (Object)dim.getString("number"));
            hideCell.setUserObject("dimId", (Object)dim.getString("id"));
            cellValues.add(this.packedUpdateCellMap(0, colIndex, dim.getString("name")));
            ++colIndex;
        }
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
        SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(this.getClientViewProxy(), spreadKey);
        SpreadClientInvoker.invokeCloseToolBar(this.getClientViewProxy(), spreadKey);
    }

    private DynamicObjectCollection getAllDimInfo() {
        QFilter qFilter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
        qFilter.and("number", "not in", (Object)new String[]{"Year", "Period", "Scenario"});
        return QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,name,issysdimension", (QFilter[])new QFilter[]{qFilter}, (String)"number desc");
    }

    private int buildFixDim(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, DynamicObject> allDimMap, String[] fixHead, boolean needCurrency, int beginCol) {
        int colIndex = fixHead.length;
        for (int i = 0; i < colIndex; ++i) {
            Cell cell = sheet.getCell(0, i + beginCol);
            DynamicObject dim = allDimMap.get(fixHead[i]);
            String displayName = dim.getString("name");
            if ("Process".equalsIgnoreCase(fixHead[i])) {
                displayName = String.format(ResManager.loadKDString((String)"\u5408\u5e76%s", (String)"DataTracePlugin_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]), displayName);
            }
            cell.setValue((Object)displayName);
            cell.setUserObject("number", (Object)dim.getString("number"));
            cell.setUserObject("dimId", (Object)dim.getString("id"));
            cellValues.add(this.packedUpdateCellMap(0, i + beginCol, displayName));
            allDimMap.remove(fixHead[i]);
        }
        if (needCurrency) {
            Cell cell = sheet.getCell(0, colIndex);
            cell.setValue((Object)ResManager.loadKDString((String)"\u8ffd\u6eaf\u6570", (String)"DataTracePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            cell.setUserObject("number", (Object)"fMoney");
            cellValues.add(this.packedUpdateCellMap(0, colIndex, ResManager.loadKDString((String)"\u8ffd\u6eaf\u6570", (String)"DataTracePlugin_10", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
            Cell cell2 = sheet.getCell(0, ++colIndex);
            cell2.setValue((Object)ResManager.loadKDString((String)"\u8868\u683c\u6570", (String)"DataTracePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            cell2.setUserObject("number", (Object)"rMoney");
            cellValues.add(this.packedUpdateCellMap(0, colIndex, ResManager.loadKDString((String)"\u8868\u683c\u6570", (String)"DataTracePlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0])));
        }
        return colIndex + beginCol;
    }

    private void buildSpreadData(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap) {
        HashSet<Integer> hyperlinkSet = new HashSet<Integer>(16);
        List selectDimCell = (List)this.getFormCustomParam("selectDimCell");
        this.handleProcessCS(selectDimCell);
        Map commonMemberList = (Map)this.getFormCustomParam("commonMemberList");
        Map orgNumberIdMap = (Map)this.getFormCustomParam("orgNumberIdMap");
        if (this.isDifModel().booleanValue()) {
            this.HandleDifProcessAuditTrailCurrency(selectDimCell, commonMemberList, orgNumberIdMap);
        }
        Map<String, Object> dimMemList = this.getMemberFromDB(selectDimCell);
        dimMemList.putAll(this.getPageMemberFromDB(commonMemberList, orgNumberIdMap));
        String[] selectKey = new String[selectDimCell.size()];
        Map<String, Object> realValue = this.getRealDataList(selectDimCell, commonMemberList, selectKey, dimMemList, FacTabFieldDefEnum.FIELD_MONEY.getField());
        Map<String, Object> sourceValue = null;
        if (this.isShowDataSourceTag()) {
            sourceValue = this.getRealDataList(selectDimCell, commonMemberList, selectKey, dimMemList, FacTabFieldDefEnum.FIELD_SOURCE.getField());
        }
        for (int i = 0; i < selectDimCell.size(); ++i) {
            String[] values;
            Map map = (Map)selectDimCell.get(i);
            if (map.get("Entity") != null && (values = map.get("Entity").toString().split("_")).length > 1) {
                map.put("Entity", values[1]);
            }
            map.putAll(commonMemberList);
            this.buildNewRowCellForInit(sheet, cellValues, columnIndexMap, dimMemList, i + 1, map);
            Cell cell = sheet.getCell(i + 1, columnIndexMap.get("fMoney").intValue());
            cell.setValue(realValue.get(selectKey[i]));
            cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
            cellValues.add(this.packedUpdateCellMap(i + 1, columnIndexMap.get("fMoney"), realValue.get(selectKey[i])));
            Cell cell2 = sheet.getCell(i + 1, columnIndexMap.get("rMoney").intValue());
            cell2.setValue(map.get(CELL_VALUE));
            cell2.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
            cellValues.add(this.packedUpdateCellMap(i + 1, columnIndexMap.get("rMoney"), map.get(CELL_VALUE)));
            this.dealSpecialCell(sheet, cellValues, columnIndexMap, i + 1, hyperlinkSet);
            if (cell.getValue() instanceof BigDecimal && cell2.getValue() instanceof BigDecimal) {
                if (((BigDecimal)cell.getValue()).compareTo((BigDecimal)cell2.getValue()) != 0) {
                    cell2.setUserObject("needChangeColor", (Object)1);
                    SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, i + 1, columnIndexMap.get("rMoney"), 1, 1, "#ffd4aa", false);
                }
            } else if (cell.getValue() != null && cell2.getValue() != null && !cell.getValue().toString().equals(cell2.getValue().toString())) {
                cell2.setUserObject("needChangeColor", (Object)1);
                SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, i + 1, columnIndexMap.get("rMoney"), 1, 1, "#ffd4aa", false);
            }
            if (sourceValue == null || sourceValue.size() <= 0 || sourceValue.get(selectKey[i]) == null) continue;
            Long source = (Long)sourceValue.get(selectKey[i]);
            this.setAttachmentMark(OlapSourceEnum.getNumber((Object)source), i + 1, columnIndexMap.get("fMoney"), 1, 1);
        }
        this.setTwoPoint(sheet, columnIndexMap);
        long modelId = (Long)this.getFormCustomParam("model");
        BaseConvertFormula convertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula((long)modelId, (long)0L);
        Map<String, String> orgCurrencyMap = SearchHelper.getCurrencyByOrg(sheet, 0L, modelId);
        Map<String, List<String>> unfoldMap = DataTraceHelper.getUnfoldMapForProcess(orgCurrencyMap, convertFormula, this.isExistAuditTrailDimension(), Boolean.FALSE);
        this.addPlusClickCell(sheet, cellValues, columnIndexMap, orgCurrencyMap, 1, sheet.getMaxRowCount(), unfoldMap, convertFormula);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        SpreadEasyInvoker spreadEasyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), spreadKey);
        Iterator iterator = hyperlinkSet.iterator();
        while (iterator.hasNext()) {
            int num = (Integer)iterator.next();
            spreadEasyInvoker.setHyperLinkCellSimple(num, columnIndexMap.get("fMoney"), 1, 1, "openDataEntry");
        }
        SearchHelper.lockOrUnlockCell(this.getClientViewProxy(), spreadKey, true, 0, 0, sheet.getMaxRowCount(), sheet.getMaxColumnCount());
        this.cacheSpreadModel();
    }

    private boolean isShowDataSourceTag() {
        boolean flag = Boolean.FALSE;
        if (OlapCommandUtil.checkMeasure((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)FacTabFieldDefEnum.FIELD_SOURCE.getField())) {
            flag = (Boolean)this.getModel().getValue("isdatasourcetag");
        }
        return flag;
    }

    public void setAttachmentMark(String text, int r, int c, int rc, int cc) {
        ArrayList rangedetails = new ArrayList(16);
        HashMap<String, Integer> rangedetail = new HashMap<String, Integer>(16);
        rangedetail.put("r", r);
        rangedetail.put("c", c);
        rangedetail.put("rc", rc);
        rangedetail.put("cc", cc);
        rangedetails.add(rangedetail);
        if (!rangedetails.isEmpty()) {
            ArrayList parameters = new ArrayList(10);
            HashMap<String, Object> parameter = new HashMap<String, Object>(16);
            parameter.put("range", rangedetails.toArray());
            parameter.put("vi", true);
            parameter.put("text", text);
            parameter.put("bc", "#5582f3");
            parameter.put("fc", "white");
            parameter.put("pos", new int[]{3});
            parameters.add(parameter);
            if (!parameters.isEmpty()) {
                SpreadClientInvoker.invokeMethod(this.getClientViewProxy(), "setCornerMark", "report", parameters.toArray());
            }
        }
    }

    private void HandleDifProcessAuditTrailCurrency(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList, Map<String, Long> orgNumberIdMap) {
        this.handleDifCellValue(selectDimCell);
        this.handleDifProcess(selectDimCell, commonMemberList);
        this.handleDifAuditTrail(selectDimCell, commonMemberList);
        this.handleDifCurrency(selectDimCell, commonMemberList, orgNumberIdMap);
    }

    private void handleDifCellValue(List<Map<String, Object>> selectDimCell) {
        for (Map<String, Object> map : selectDimCell) {
            if (map.get(CELL_VALUE) == null) continue;
            map.put(CELL_VALUE, null);
        }
    }

    private void handleDifCurrency(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList, Map<String, Long> orgNumberIdMap) {
        block7: {
            String entityMember;
            Map<String, String> orgCurrencyMap;
            block6: {
                orgCurrencyMap = this.findOrgCurrencyMap(selectDimCell, commonMemberList);
                for (Map<String, Object> map : selectDimCell) {
                    if (map.get(DimTypesEnum.CURRENCY.getNumber()) == null || map.get(DimTypesEnum.ENTITY.getNumber()) == null) continue;
                    entityMember = this.findEntityNumber(map.get(DimTypesEnum.ENTITY.getNumber()).toString());
                    if (map.get(DimTypesEnum.CURRENCY.getNumber()).toString().equals(orgCurrencyMap.get(entityMember))) continue;
                    map.put(DimTypesEnum.CURRENCY.getNumber(), orgCurrencyMap.get(entityMember));
                }
                if (!commonMemberList.containsKey(DimTypesEnum.CURRENCY.getNumber()) || !commonMemberList.containsKey(DimTypesEnum.ENTITY.getNumber())) break block6;
                String entityMember2 = this.findEntityNumber(commonMemberList.get(DimTypesEnum.ENTITY.getNumber()).toString());
                if (commonMemberList.get(DimTypesEnum.CURRENCY.getNumber()).equals(orgCurrencyMap.get(entityMember2)) || orgCurrencyMap.get(entityMember2) == null) break block7;
                commonMemberList.put(DimTypesEnum.CURRENCY.getNumber(), orgCurrencyMap.get(entityMember2));
                break block7;
            }
            if (!commonMemberList.containsKey(DimTypesEnum.CURRENCY.getNumber()) && commonMemberList.containsKey(DimTypesEnum.ENTITY.getNumber())) {
                for (Map<String, Object> map : selectDimCell) {
                    if (map.get(DimTypesEnum.CURRENCY.getNumber()) == null) continue;
                    entityMember = this.findEntityNumber(commonMemberList.get(DimTypesEnum.ENTITY.getNumber()).toString());
                    if (map.get(DimTypesEnum.CURRENCY.getNumber()).toString().equals(orgCurrencyMap.get(entityMember))) continue;
                    map.put(DimTypesEnum.CURRENCY.getNumber(), orgCurrencyMap.get(entityMember));
                }
            } else if (commonMemberList.containsKey(DimTypesEnum.CURRENCY.getNumber()) && !commonMemberList.containsKey(DimTypesEnum.ENTITY.getNumber())) {
                commonMemberList.remove(DimTypesEnum.CURRENCY.getNumber());
                for (Map<String, Object> map : selectDimCell) {
                    entityMember = this.findEntityNumber(map.get(DimTypesEnum.ENTITY.getNumber()).toString());
                    map.put(DimTypesEnum.CURRENCY.getNumber(), orgCurrencyMap.get(entityMember));
                }
            }
        }
    }

    private String findEntityNumber(String entityNumber) {
        String[] values = entityNumber.split("_");
        String entityMember = entityNumber;
        if (values.length > 1) {
            entityMember = values[1];
        }
        return entityMember;
    }

    private Map<String, String> findOrgCurrencyMap(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList) {
        String entityMember;
        HashMap<String, String> orgCurrencyMap = new HashMap<String, String>(8);
        selectDimCell.forEach(map -> {
            String entityMember;
            if (map.containsKey(DimTypesEnum.ENTITY.getNumber()) && !orgCurrencyMap.containsKey(entityMember = this.findEntityNumber(map.get(DimTypesEnum.ENTITY.getNumber()).toString()))) {
                IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)entityMember);
                if (!IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(entity.getNumber())) {
                    orgCurrencyMap.put(entityMember, entity.getCurrency());
                }
            }
        });
        if (commonMemberList.containsKey(DimTypesEnum.ENTITY.getNumber()) && !orgCurrencyMap.containsKey(entityMember = this.findEntityNumber(commonMemberList.get(DimTypesEnum.ENTITY.getNumber()).toString()))) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)entityMember);
            if (!IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(entity.getNumber())) {
                orgCurrencyMap.put(entityMember, entity.getCurrency());
            }
        }
        return orgCurrencyMap;
    }

    private void handleDifAuditTrail(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList) {
        for (Map<String, Object> map : selectDimCell) {
            if (map.get(DimTypesEnum.AUDITTRIAL.getNumber()) == null || "ATTotal".equals(map.get(DimTypesEnum.AUDITTRIAL.getNumber()))) continue;
            map.put(DimTypesEnum.AUDITTRIAL.getNumber(), "ATTotal");
        }
        if (commonMemberList.containsKey(DimTypesEnum.AUDITTRIAL.getNumber()) && commonMemberList.get(DimTypesEnum.AUDITTRIAL.getNumber()) instanceof String && !commonMemberList.get(DimTypesEnum.AUDITTRIAL.getNumber()).toString().equals("ATTotal")) {
            commonMemberList.put(DimTypesEnum.AUDITTRIAL.getNumber(), "ATTotal");
        }
    }

    private void handleDifProcess(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList) {
        for (Map<String, Object> map : selectDimCell) {
            if (map.get(DimTypesEnum.PROCESS.getNumber()) == null || "ERpt".equals(map.get(DimTypesEnum.PROCESS.getNumber()))) continue;
            map.put(DimTypesEnum.PROCESS.getNumber(), "ERpt");
        }
        if (commonMemberList.containsKey(DimTypesEnum.PROCESS.getNumber()) && commonMemberList.get(DimTypesEnum.PROCESS.getNumber()) instanceof String && !commonMemberList.get(DimTypesEnum.PROCESS.getNumber()).toString().equals("ERpt")) {
            commonMemberList.put(DimTypesEnum.PROCESS.getNumber(), "ERpt");
        }
    }

    private void handleProcessCS(List<Map<String, Object>> selectDimCell) {
        for (Map<String, Object> map : selectDimCell) {
            if (map.get(DimTypesEnum.PROCESS.getNumber()) == null || !"CS".equals(map.get(DimTypesEnum.PROCESS.getNumber()))) continue;
            map.put(DimTypesEnum.PROCESS.getNumber(), "EIRpt");
        }
    }

    private Map<String, Object> getRealDataList(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList, String[] selectKey, Map<String, Object> dimMemList, String measure) {
        HashMap<String, Object> realValue;
        block9: {
            block8: {
                String v;
                String[] selectDimName = new String[selectDimCell.get(0).size() - 1];
                for (int i = 0; i < selectDimCell.size(); ++i) {
                    StringBuilder key = new StringBuilder();
                    int j = 0;
                    Map<String, Object> cell = selectDimCell.get(i);
                    for (Map.Entry<String, Object> entry : cell.entrySet()) {
                        String dimName = entry.getKey();
                        if (CELL_VALUE.equalsIgnoreCase(dimName)) continue;
                        v = entry.getValue().toString();
                        if ("Entity".equalsIgnoreCase(dimName) && v.split("_").length > 1) {
                            v = v.split("_")[1];
                        }
                        key.append(v).append(",");
                        if (i != 0) continue;
                        selectDimName[j] = dimName;
                        ++j;
                    }
                    selectKey[i] = key.substring(0, key.length() - 1);
                }
                realValue = new HashMap<String, Object>(selectDimCell.size());
                MDResultSet set = this.getInitDataFromOLAP(selectDimCell, commonMemberList, selectDimName, dimMemList, measure);
                if (set == null || set.getFetchSize() <= 0) break block8;
                int i = 0;
                while (set.next()) {
                    Row row = set.getRow();
                    if (i < 5) {
                        log.info("DataTracePlugin mdResult: " + row);
                        ++i;
                    }
                    String key = "";
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < selectDimName.length; ++k) {
                        v = row.getValue(k).toString();
                        if ("Entity".equalsIgnoreCase(selectDimName[k]) && v.split("_").length > 1) {
                            v = v.split("_")[1];
                        }
                        sb.append(v).append(",");
                    }
                    key = sb.toString();
                    realValue.put(key.substring(0, key.length() - 1), row.getValue(selectDimName.length));
                }
                break block9;
            }
            log.info(measure + "DataTracePlugin mdResult: null");
            if (!FacTabFieldDefEnum.FIELD_MONEY.getField().equals(measure)) break block9;
            for (String key : selectKey) {
                realValue.put(key, 0);
            }
        }
        return realValue;
    }

    private Set<Integer> getIgnoreAggRow(boolean isEntity, Map<Integer, Map<String, String>> insertDimMember, Long modelId, String clickDimNumber, String expandNumber, int clickRow, Sheet sheet, Map<String, Integer> columnIndexMap) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        HashSet<Integer> result = new HashSet<Integer>(10);
        Map short2NumberMap = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum);
        IDNumberTreeNode expandMember = MemberReader.findMemberByNumber((String)modelNum, (String)clickDimNumber, (String)expandNumber);
        if (!isEntity && !"Process".equals(clickDimNumber) && StorageTypeEnum.DYNAMIC != expandMember.getStorageType()) {
            result.addAll(insertDimMember.keySet());
            return result;
        }
        String clickDimShortNumber = this.getClickDimShortNumber(clickDimNumber, short2NumberMap);
        insertDimMember.forEach((row, m) -> {
            Recorder noAgg = new Recorder((Object)false);
            m.forEach((dim, member) -> {
                if ("Entity".equals(dim)) {
                    return;
                }
                if (this.isDifModel().booleanValue() && "Process".equals(dim) && "DIF".equals(member)) {
                    return;
                }
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dim, (String)member);
                if (clickDimNumber.equals(dim)) {
                    if (!"Process".equals(dim)) {
                        Optional<IDNumberTreeNode> Opt;
                        String parentNumber = sheet.getCell(clickRow, ((Integer)columnIndexMap.get(dim)).intValue()).getUserObject("number").toString();
                        if (!node.getParent().getNumber().equals(parentNumber) && (Opt = node.getShareNodes().stream().filter(s -> s.getParent().getNumber().equals(parentNumber)).findFirst()).isPresent()) {
                            node = Opt.get();
                        }
                    }
                    noAgg.setRecord((Object)((Boolean)noAgg.getRecord() != false || AggOprtEnum.SKIP.name.equals(node.getAggOprt()) ? 1 : 0));
                } else {
                    String rule = ShieldRuleBulider.getRuleStrByMem((Object)node.getDimId(), (Object)node.getId());
                    if (rule != null) {
                        String[] dimShortNumbers;
                        for (String num : dimShortNumbers = rule.split(",")) {
                            if (!num.equals(clickDimShortNumber)) continue;
                            noAgg.setRecord((Object)true);
                        }
                    }
                }
            });
            if (((Boolean)noAgg.getRecord()).booleanValue()) {
                result.add((Integer)row);
            }
        });
        return result;
    }

    private String getClickDimShortNumber(String clickDimNumber, Map<String, String> short2NumberMap) {
        for (Map.Entry<String, String> entry : short2NumberMap.entrySet()) {
            if (!entry.getValue().equals(clickDimNumber)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void addPlusClickCell(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap, int beginRow, int endRow, Map<String, List<String>> unfoldMap, BaseConvertFormula convertFormula) {
        boolean isOrgUnfold = this.isOrgUnfold();
        for (int i = beginRow; i < endRow; ++i) {
            Cell processCell = sheet.getCell(i, columnIndexMap.get("Process").intValue());
            Cell auditCell = sheet.getCell(i, columnIndexMap.get("AuditTrail").intValue());
            String displayContent = processCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            Cell orgCell = sheet.getCell(i, columnIndexMap.get("Entity").intValue());
            Cell curCell = sheet.getCell(i, columnIndexMap.get("Currency").intValue());
            String process = processCell.getUserObject("number").toString();
            String auditNumber = auditCell == null ? "" : auditCell.getUserObject("number").toString();
            String curNum = curCell.getUserObject("number").toString();
            String orgNum = orgCell.getUserObject("number").toString();
            if (isOrgUnfold) {
                if (this.isDifModel().booleanValue()) {
                    if (orgCell.getUserObject("isleaf") == null && (Objects.equals("ERpt", processCell.getUserObject("number")) || Objects.equals("Rpt", processCell.getUserObject("number"))) && !(displayContent = orgCell.getValue().toString().replaceAll("^[\u3000 ]+", "")).startsWith(EXPAND_PLUS)) {
                        displayContent = EXPAND_PLUS + displayContent;
                        orgCell.setValue((Object)displayContent);
                        cellValues.add(this.packedUpdateCellMap(i, columnIndexMap.get("Entity"), displayContent));
                    }
                    if (orgCell.getUserObject("isleaf") != null && !curNum.equals(orgCurrencyMap.get(orgNum)) && !(displayContent = orgCell.getValue().toString().replaceAll("^[\u3000 ]+", "")).startsWith(EXPAND_PLUS)) {
                        displayContent = EXPAND_PLUS + displayContent;
                        orgCell.setValue((Object)displayContent);
                        cellValues.add(this.packedUpdateCellMap(i, columnIndexMap.get("Entity"), displayContent));
                    }
                } else if ((processCell.getUserObject("isleaf") == null || auditCell != null && auditCell.getUserObject("isleaf") == null || orgCell.getUserObject("isleaf") == null && DataTraceHelper.getProcessForUnfold(sheet, i, unfoldMap, columnIndexMap, false) != null) && !(displayContent = orgCell.getValue().toString().replaceAll("^[\u3000 ]+", "")).startsWith(EXPAND_PLUS)) {
                    displayContent = EXPAND_PLUS + displayContent;
                    orgCell.setValue((Object)displayContent);
                    cellValues.add(this.packedUpdateCellMap(i, columnIndexMap.get("Entity"), displayContent));
                }
            } else if (orgCell.getUserObject("isleaf") == null && DataTraceHelper.getProcessForUnfold(sheet, i, unfoldMap, columnIndexMap, false) != null && !displayContent.startsWith(EXPAND_PLUS)) {
                displayContent = EXPAND_PLUS + displayContent;
                processCell.setValue((Object)displayContent);
                processCell.removeUserObject("isleaf");
                cellValues.add(this.packedUpdateCellMap(i, columnIndexMap.get("Process"), displayContent));
            }
            this.setCurrencyCell(sheet, cellValues, columnIndexMap, i, orgCurrencyMap, convertFormula);
            if (!this.isDifModel().booleanValue() || !Objects.equals(process, "ERpt") || !Objects.equals(auditNumber, "ATTotal") || !Objects.equals(curNum, orgCurrencyMap.get(orgNum))) continue;
            SearchHelper.setCellFontColor(this.getClientViewProxy(), spreadKey, i, 0, 1, sheet.getMaxColumnCount(), "#5656FF");
        }
    }

    private void needAddBreak(Cell cell, Cell parentCell) {
        if (cell.getUserObject("ti") != null) {
            int ti = (Integer)cell.getUserObject("ti");
            int pti = parentCell.getUserObject("ti") == null ? 0 : (Integer)parentCell.getUserObject("ti");
            String pCell = parentCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            String newCell = cell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            if (ti == pti) {
                if ((pCell.startsWith(EXPAND_PLUS) || pCell.startsWith(EXPAND_SUB)) && !newCell.startsWith(EXPAND_PLUS) && !newCell.startsWith(EXPAND_SUB)) {
                    SearchHelper.setCellIndentOne(this.getClientViewProxy(), spreadKey, cell, cell, 1);
                }
                if (!pCell.startsWith(EXPAND_PLUS) && !pCell.startsWith(EXPAND_SUB) && (newCell.startsWith(EXPAND_PLUS) || newCell.startsWith(EXPAND_SUB))) {
                    SearchHelper.setCellIndentOne(this.getClientViewProxy(), spreadKey, cell, cell, -1);
                }
            } else if (!(ti <= pti || !pCell.startsWith(EXPAND_PLUS) && !pCell.startsWith(EXPAND_SUB) || newCell.startsWith(EXPAND_PLUS) || newCell.startsWith(EXPAND_SUB) || cell.getValue().toString().startsWith(PEER_ALIGNMENT))) {
                SearchHelper.setCellIndentOne(this.getClientViewProxy(), spreadKey, cell, cell, 1);
            }
        }
    }

    private void buildNewRowCellForInit(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, Map<String, Object> dimMemList, int rowNum, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String dimName = entry.getKey();
            if (dimMemList.get(dimName + "," + entry.getValue()) == null) continue;
            DynamicObject dim = (DynamicObject)dimMemList.get(dimName + "," + entry.getValue());
            int colNum = columnIndexMap.get(dimName);
            this.buildSingleCellData(cellValues, rowNum, dim, colNum, sheet, sheet.getCell(0, 0), dimName, false, new HashMap<Integer, Map<String, String>>());
        }
    }

    public boolean isOrgUnfold() {
        return "Entity".equalsIgnoreCase(this.getPageCache().get(UNFOLDFILED));
    }

    private void buildSingleCellData(List<Map<String, Object>> cellValues, int rowNum, DynamicObject dim, int colNum, Sheet sheet, Cell clickCell, String clickDimName, boolean needIndent, Map<Integer, Map<String, String>> insertDimMember) {
        String unfoldFiled = this.getPageCache().get(UNFOLDFILED);
        Cell cell = sheet.getCell(rowNum, colNum);
        String showType = this.getModel().getValue("showtype").toString();
        String displayContent = dim.getString("name") + "|" + dim.getString("number");
        if ("btn_number".equalsIgnoreCase(showType)) {
            displayContent = dim.getString("number");
        } else if ("btn_name".equalsIgnoreCase(showType)) {
            displayContent = dim.getString("name");
        }
        Set<String> properties = this.getProperties(dim);
        displayContent = this.addAggoprt(dim.getDynamicObjectType().getName(), sheet, rowNum, properties.contains("aggoprt") ? dim.getString("aggoprt") : null, displayContent, dim.getString("number"));
        if (dim.getBoolean("isleaf")) {
            cell.setUserObject("isleaf", (Object)1);
        } else if (this.isNeedAddPlus(unfoldFiled, clickDimName)) {
            displayContent = EXPAND_PLUS + displayContent;
        }
        if (needIndent) {
            SearchHelper.setCellIndent(this.getClientViewProxy(), spreadKey, sheet.getCell(clickCell.getRow(), colNum), cell);
        }
        cell.setValue((Object)displayContent);
        cell.setUserObject("number", (Object)dim.getString("number"));
        cell.setUserObject("name", (Object)dim.getString("name"));
        cell.setUserObject("id", (Object)dim.getLong("id"));
        cell.setUserObject("level", (Object)dim.getInt("level"));
        cell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
        if (clickCell.getUserObject("cellFlag") != null) {
            cell.setUserObject("openParent", clickCell.getUserObject("cellFlag"));
            cell.setUserObject("parentCell", (Object)clickCell);
        }
        cellValues.add(this.packedUpdateCellMap(rowNum, colNum, displayContent));
        insertDimMember.computeIfAbsent(rowNum, m -> new HashMap());
        Map<String, String> dimMember = insertDimMember.get(rowNum);
        dimMember.put(clickDimName, dim.getString("number"));
    }

    private Set<String> getProperties(DynamicObject dim) {
        HashSet<String> proSet = new HashSet<String>();
        for (IDataEntityProperty pro : dim.getDataEntityType().getProperties()) {
            proSet.add(pro.getName());
        }
        return proSet;
    }

    private String addAggoprt(String entityNumber, Sheet sheet, int rowNum, String aggoprt, String displayContent, String number) {
        Set<String> notShowAggSet = this.getNotShowAggSet();
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        if (StringUtils.isNotEmpty((CharSequence)aggoprt) && !notShowAggSet.contains(entityNumber)) {
            if ("bcm_processmembertree".equals(entityNumber)) {
                if ("DIF".equals(number)) {
                    return AggOprtEnum.ADD.getMiniDesc() + displayContent;
                }
                if (sheet.getCell(rowNum, columnIndexMap.get("Currency").intValue()).getValue().toString().equals(this.getPageCache().get(FATHER_CURRENCY))) {
                    return AggOprtEnum.ADD.getMiniDesc() + displayContent;
                }
                return AggOprtEnum.SKIP.getMiniDesc() + displayContent;
            }
            if (StringUtils.isNotEmpty((CharSequence)aggoprt)) {
                return AggOprtEnum.getAggOprtEnumBySign((String)aggoprt).getMiniDesc() + displayContent;
            }
        }
        return displayContent;
    }

    private Set<String> getNotShowAggSet() {
        HashSet<String> notShowAggSet = new HashSet<String>();
        notShowAggSet.add("bcm_entitymembertree");
        notShowAggSet.add("bcm_currencymembertree");
        if (!this.isDifModel().booleanValue()) {
            notShowAggSet.add("bcm_processmembertree");
        }
        return notShowAggSet;
    }

    private void setToOrgCell(String clickDimName, Map<String, Integer> columnIndexMap, Sheet sheet, Cell clickCell, int rowNumber, int inserRowNum) {
        if (this.isOrgUnfold() && this.isProcessOrAuditTrailUnfold(clickDimName)) {
            int colNum = columnIndexMap.get("Entity");
            Cell cell = sheet.getCell(inserRowNum, colNum);
            Cell parentCell = sheet.getCell(rowNumber, colNum);
            SearchHelper.setCellIndent(this.getClientViewProxy(), spreadKey, parentCell, cell);
            if (parentCell.getUserObject("cellFlag") != null) {
                clickCell.setUserObject("openParent", parentCell.getUserObject("cellFlag"));
                clickCell.setUserObject("parentCell", (Object)parentCell);
            }
        }
    }

    private boolean isNeedAddPlus(String unfoldFiled, String clickDimName) {
        if ("Entity".equalsIgnoreCase(clickDimName) && "Process".equalsIgnoreCase(unfoldFiled)) {
            return false;
        }
        return !"Process".equalsIgnoreCase(clickDimName) && !"AuditTrail".equalsIgnoreCase(clickDimName) && !"Entity".equalsIgnoreCase(clickDimName) || !"Entity".equalsIgnoreCase(unfoldFiled);
    }

    private Map<String, Object> getMemberFromDB(List<Map<String, Object>> selectDimCell) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (Map<String, Object> map : selectDimCell) {
            this.buildParams(params, map);
        }
        return this.getDimMember(params, null);
    }

    private Map<String, Object> getMemberFromJson(List<Map<String, Object>> selectDimCell) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (Map<String, Object> map : selectDimCell) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String dimName = entry.getKey();
                if (CELL_VALUE.equalsIgnoreCase(dimName)) continue;
                params.put(dimName, entry.getValue());
            }
        }
        return params;
    }

    private Map<String, Object> getPageMemberFromDB(Map<String, Object> commonMemberList, Map<String, Long> orgNumberIdMap) {
        return this.getDimMember(this.buildParams(new HashMap<String, Object>(16), commonMemberList), orgNumberIdMap);
    }

    private Map<String, Object> getDimMember(Map<String, Object> params, Map<String, Long> orgNumberIdMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String dimNumber = entry.getKey();
            if ("Year".equalsIgnoreCase(dimNumber) || "Period".equalsIgnoreCase(dimNumber) || "Scenario".equalsIgnoreCase(dimNumber)) continue;
            if ("Entity".equalsIgnoreCase(dimNumber)) {
                String[] entityNumber = entry.getValue().toString().split(",");
                List<Pair<String, String>> pairs = this.handleEntityNumber(entityNumber);
                for (Pair<String, String> pair : pairs) {
                    QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                    qFilter.and("number", "in", pair.p2);
                    Long entitySchemeId = 0L;
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p1))) {
                        qFilter.and("parent.number", "in", pair.p1);
                        IDNumberTreeNode entity = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)((String)pair.p1 + "_" + (String)pair.p2));
                        entitySchemeId = (Long)entity.getProperty("cslscheme.id");
                    }
                    if (orgNumberIdMap != null) {
                        qFilter.and("id", "in", orgNumberIdMap.values());
                    } else {
                        Object schemeIdObj = this.getView().getFormShowParameter().getCustomParam("schemeId");
                        if (schemeIdObj instanceof Long) {
                            long schemeId = (Long)schemeIdObj;
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p1)) && schemeId != entitySchemeId && entitySchemeId > 0L) {
                                schemeId = entitySchemeId;
                            }
                            if (schemeId > 0L) {
                                qFilter.and("cslscheme", "=", (Object)schemeId);
                            } else {
                                qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                            }
                        } else {
                            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                        }
                    }
                    DynamicObjectCollection col = this.getDataTraceDynFromCache(dimNumber, qFilter);
                    for (DynamicObject obj : col) {
                        result.put(dimNumber + "," + obj.getString("number"), obj);
                    }
                }
                continue;
            }
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("number", "in", (Object)entry.getValue().toString().split(","));
            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            if ("bcm_userdefinedmembertree".equals(DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber))) {
                qFilter.and("dimension.number", "=", (Object)dimNumber);
            }
            DynamicObjectCollection col = this.getDataTraceDynFromCache(dimNumber, qFilter);
            for (DynamicObject obj : col) {
                result.put(dimNumber + "," + obj.getString("number"), obj);
            }
        }
        return result;
    }

    private DynamicObjectCollection getDataTraceDynFromCache(String dimNumber, QFilter qFilter) {
        String key = "getDataTraceDyn" + dimNumber + qFilter.toString();
        DynamicObjectCollection cachedResult = (DynamicObjectCollection)ThreadCache.get((Object)key);
        if (cachedResult != null) {
            return cachedResult;
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber), (String)"id,number,name,isleaf,storagetype,level,dseq", (QFilter[])new QFilter[]{qFilter});
        ThreadCache.put((Object)key, (Object)col);
        return col;
    }

    private List<Pair<String, String>> handleEntityNumber(String[] entityNumbers) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>(2);
        for (int i = 0; i < entityNumbers.length; ++i) {
            Pair one;
            String entityNumber = entityNumbers[i];
            if (entityNumber.split("_").length > 1) {
                one = new Pair((Object)entityNumber.split("_")[0], (Object)entityNumber.split("_")[1]);
                pairs.add((Pair<String, String>)one);
                continue;
            }
            one = new Pair((Object)"", (Object)entityNumber);
            pairs.add((Pair<String, String>)one);
        }
        return pairs;
    }

    private Map<String, Object> buildParams(Map<String, Object> params, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String dimName = entry.getKey();
            if (CELL_VALUE.equalsIgnoreCase(dimName)) continue;
            if (params.get(dimName) != null) {
                params.put(dimName, params.get(dimName) + "," + entry.getValue());
                continue;
            }
            params.put(dimName, entry.getValue());
        }
        return params;
    }

    private void setTwoPoint(Sheet sheet, Map<String, Integer> columnIndexMap) {
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>(8);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), 0);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), columnIndexMap.get("fMoney"));
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), sheet.getMaxRowCount());
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), 1);
        HashMap<String, Integer> rangeMap2 = new HashMap<String, Integer>(8);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.R.k(), 0);
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.C.k(), columnIndexMap.get("rMoney"));
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.RC.k(), sheet.getMaxRowCount());
        rangeMap2.put(SpreadProperties.SetCellStyleMethod.CC.k(), 1);
        ArrayList<HashMap<String, Integer>> rangeList = new ArrayList<HashMap<String, Integer>>(2);
        rangeList.add(rangeMap);
        rangeList.add(rangeMap2);
        HashMap<String, String> styleMap = new HashMap<String, String>(16);
        styleMap.put(SpreadProperties.SetCellStyleMethod.FORMAT.k(), "#,##0.00");
        HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    private void setFrozen() {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), 1);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), 0);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), "#ccc");
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.getClientViewProxy(), spreadKey, features);
    }

    private void setColumnWidth(int colSize, Map<String, Integer> columnIndexMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int[] colIndex = new int[colSize];
        for (int i = 0; i < colIndex.length; ++i) {
            if (i == columnIndexMap.get("Entity")) continue;
            colIndex[i] = i;
        }
        map.put("index", colIndex);
        map.put("num", 150);
        SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), spreadKey, map);
        HashMap<String, Object> map2 = new HashMap<String, Object>(16);
        int[] colIndex2 = new int[]{columnIndexMap.get("Entity")};
        map2.put("index", colIndex2);
        map2.put("num", 200);
        SpreadClientInvoker.invokeSetColumsWidthMethod(this.getClientViewProxy(), spreadKey, map2);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void openDataEntry() {
        if (!BcmFunPermissionHelper.isHasModelFuncPermToPage((long)this.getModelId(), (String)"bcm_rptadjustquery_list")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2\u5217\u8868\u7684\u529f\u80fd\u6743\u9650\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"DataTracePlugin_23", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Sheet sheet = this.getEffectiveSheet();
        SpreadSelector selector = this.getSpreadSelector();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setCustomParam("datatrace", (Object)1);
        showParameter.setCustomParam("model", this.getFormCustomParam("model"));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getFormCustomParam("model").toString());
        DynamicObject year = (DynamicObject)this.getModel().getValue("year");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        DynamicObject scenario = (DynamicObject)this.getModel().getValue("scenario");
        showParameter.setCustomParam("year", (Object)year.getLong("id"));
        showParameter.setCustomParam("yearName", (Object)year.getString("name"));
        showParameter.setCustomParam("yearScope", (Object)"10");
        showParameter.setCustomParam("period", (Object)period.getLong("id"));
        showParameter.setCustomParam("periodName", (Object)period.getString("name"));
        showParameter.setCustomParam("periodScope", (Object)"10");
        showParameter.setCustomParam("scenario", (Object)scenario.getLong("id"));
        showParameter.setCustomParam("scenarioName", (Object)scenario.getString("name"));
        showParameter.setCustomParam("scenarioScope", (Object)"10");
        showParameter.setCustomParam("schemeId", this.getFormCustomParam("schemeId"));
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        String audiScope = "10";
        long audiMemId = 0L;
        String audiShowName = "";
        List<String> fixHead = Arrays.asList("process", "audittrail", "entity", "account", "changetype", "currency");
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            String realShowName;
            if (i == columnIndexMap.get("fMoney") || i == columnIndexMap.get("AuditTrail")) continue;
            int rowNumber = selector.getStartRow();
            Cell tempCell = sheet.getCell(rowNumber, i);
            Cell dimCell = sheet.getCell(0, i);
            if (dimCell.getUserObject("number") == null || "rmoney".equalsIgnoreCase(dimCell.getUserObject("number").toString())) continue;
            String dimNum = dimCell.getUserObject("number").toString().toLowerCase(Locale.ENGLISH);
            String showName = realShowName = tempCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            long memId = (Long)tempCell.getUserObject("id");
            String number = tempCell.getUserObject("number").toString();
            showName = showName.replace(EXPAND_PLUS, "").replace("   ", "").replace(EXPAND_SUB, "");
            String scope = "10";
            if ("Entity".equalsIgnoreCase(dimNum)) {
                if (OrgRelaProcessMembPool.isRelaProcess((String)sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue()).getUserObject("number").toString())) {
                    long modelId = (Long)this.getFormCustomParam("model");
                    QFilter pFilter = new QFilter("model", "=", (Object)modelId);
                    pFilter.and("id", "=", (Object)memId);
                    DynamicObject org = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,parent.id", (QFilter[])new QFilter[]{pFilter});
                    QFilter pFilter2 = new QFilter("model", "=", (Object)modelId);
                    pFilter2.and("id", "=", (Object)org.getLong("parent.id"));
                    DynamicObject parentOrg = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{pFilter2});
                    showParameter.setCustomParam("mergeId", (Object)parentOrg.getLong("id"));
                }
                showParameter.setCustomParam(dimNum + "Number", (Object)number);
            } else if (doNotIncludeSub.stream().noneMatch(p -> p.equalsIgnoreCase(dimNum)) && realShowName.startsWith(EXPAND_PLUS)) {
                scope = Integer.toString(RangeEnum.VALUE_90.getValue());
            } else if ("process".equalsIgnoreCase(dimNum)) {
                if ("SADJ".equals(number) || this.getTranslateNumber(number) != null) {
                    DynamicObject obj = this.getTranslateProcess(dimNum, number);
                    memId = obj.getLong("id");
                    showName = obj.getString("name");
                } else {
                    showName = this.getProcessShowName(showName);
                }
                showParameter.setCustomParam(dimNum + "Number", (Object)number);
                if (this.isExistAuditTrailDimension()) {
                    Cell audiCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
                    audiMemId = (Long)audiCell.getUserObject("id");
                    audiShowName = audiCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
                    audiShowName = audiShowName.replace(EXPAND_PLUS, "").replace(EXPAND_SUB, "").replace(" ", "");
                    String audiNum = audiCell.getUserObject("number").toString();
                    if ("ADJE".equalsIgnoreCase(audiNum)) {
                        audiScope = "30";
                    }
                    if ("EJE".equalsIgnoreCase(number) && ("ADJE".equalsIgnoreCase(audiNum) || "ManualJournal".equalsIgnoreCase(audiNum) || "AutoJournal".equalsIgnoreCase(audiNum) || "LinkageJournal".equalsIgnoreCase(audiNum))) {
                        scope = "30";
                    }
                }
            } else if (!fixHead.contains(dimNum)) {
                scope = Integer.toString(RangeEnum.VALUE_90.getValue());
            }
            if ("ADJT".equalsIgnoreCase(number)) {
                showParameter.setCustomParam("specialAdjt", (Object)true);
            }
            showParameter.setCustomParam(dimNum, (Object)memId);
            showParameter.setCustomParam(dimNum + "Name", (Object)showName);
            showParameter.setCustomParam(dimNum + "Scope", (Object)scope);
        }
        showParameter.setCustomParam("status", (Object)"3");
        showParameter.setCustomParam("audittrail", (Object)audiMemId);
        showParameter.setCustomParam("audittrailName", (Object)audiShowName);
        showParameter.setCustomParam("audittrailScope", (Object)audiScope);
        showParameter.setBillFormId("bcm_rptadjustdata");
        showParameter.setFormId("bcm_rptadjustquery_edit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u62b5\u9500\u5206\u5f55\u67e5\u8be2\u5217\u8868", (String)"DataTracePlugin_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject getTranslateProcess(String dimNum, String number) {
        QFilter qFilter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
        if (this.getTranslateNumber(number) != null) {
            qFilter.and("number", "=", (Object)this.getTranslateNumber(number));
        } else {
            qFilter.and("number", "=", (Object)"ADJ");
        }
        return QueryServiceHelper.queryOne((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)"id,name,number,isleaf", (QFilter[])new QFilter[]{qFilter});
    }

    private String getProcessShowName(String showName) {
        String[] values = showName.split("\\|");
        StringBuilder sb = new StringBuilder();
        for (String str : values) {
            if ("|".equals(str)) break;
            sb.append(str);
        }
        showName = sb.toString();
        return showName;
    }

    @Override
    public void doubleClickLockedCell(int rowNumber, int colNumber) {
        this.getView().showLoading(ResManager.getLocaleString((String)"\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"AdjustTemplateBottomPlugin_4", (String)"fi-bcm-formplugin"));
        Sheet sheet = this.getEffectiveSheet();
        Cell cell = sheet.getCell(rowNumber, colNumber);
        Cell clickDimCel = sheet.getCell(0, colNumber);
        if (clickDimCel.getUserObject("number") == null) {
            return;
        }
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        boolean isOrgUnfold = this.isOrgUnfold();
        if (colNumber != columnIndexMap.get("rMoney") && colNumber != columnIndexMap.get("fMoney") && rowNumber > 0) {
            String values = cell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            if (values.startsWith(EXPAND_PLUS)) {
                this.getPageCache().put(FATHER_CURRENCY, sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue()).getValue().toString());
                Pair<Integer, String> insertCount = this.addNewRow(rowNumber, colNumber, sheet, isOrgUnfold);
                if ((Integer)insertCount.p1 <= 0) {
                    String msg = StringUtils.isEmpty((CharSequence)((CharSequence)insertCount.p2)) ? ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]) : (String)insertCount.p2;
                    this.getView().showTipNotification(msg);
                }
            } else {
                this.packUpRow(rowNumber, colNumber, sheet, cell);
            }
            this.cacheSpreadModel();
        }
        this.getView().hideLoading();
    }

    private void packUpRow(int rowNumber, int colNumber, Sheet sheet, Cell cell) {
        int openCount = DataTraceHelper.packUpRowOrCol(this.getClientViewProxy(), spreadKey, rowNumber, colNumber, sheet, cell, false, true);
        SearchHelper.dealAllInsertCountCache(this.getView(), "tranceInsertCount", openCount, false);
        SearchHelper.updateDataTraceParenOpenRowCount(sheet, cell, openCount, false);
        Set<Integer> unAggRow = this.getUnAggRowfromCache();
        for (int i = 0; i < openCount; ++i) {
            unAggRow.remove(rowNumber + i + 1);
        }
        if (!unAggRow.contains(rowNumber)) {
            SearchHelper.setCellBackColor(this.getClientViewProxy(), spreadKey, rowNumber, 0, 1, sheet.getMaxColumnCount(), "#FFFFFF", false);
        }
        this.cacheUnAggRow(unAggRow);
    }

    public void updateSelectCellValue(int rowNumber, int colNumber, Cell cell, List<Map<String, Object>> cellValues) {
        String newCellValue = cell.getValue().toString().replace(EXPAND_PLUS, EXPAND_SUB);
        cell.setValue((Object)newCellValue);
        cellValues.add(this.packedUpdateCellMap(rowNumber, colNumber, newCellValue));
    }

    private Pair<Integer, String> addNewRow(int rowNumber, int colNumber, Sheet sheet, boolean isOrgUnfold) {
        long modelId = (Long)this.getFormCustomParam("model");
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>(10);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        Cell clickCell = sheet.getCell(rowNumber, colNumber);
        this.updateSelectCellValue(rowNumber, colNumber, clickCell, cellValues);
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), spreadKey, Lists.newArrayList(cellValues));
        Cell fMoney = sheet.getCell(rowNumber, columnIndexMap.get("fMoney").intValue());
        Cell clickDimCell = sheet.getCell(0, colNumber);
        String clickDimNumber = (String)clickDimCell.getUserObject("number");
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        Map<String, String> orgCurrencyMap = SearchHelper.getCurrencyByOrg(sheet, Long.parseLong(orgCell.getUserObject("id").toString()), modelId);
        BaseConvertFormula convertFormula = ConvertSchemeServiceHelper.getBaseConvertFormula((long)modelId, (long)0L);
        Cell auditCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        String audittrail = auditCell.getUserObject("number").toString();
        Boolean unfoldForDif = this.unforldForDif(audittrail);
        Map<String, List<String>> unfoldMap = DataTraceHelper.getUnfoldMapForProcess(orgCurrencyMap, convertFormula, this.isExistAuditTrailDimension(), unfoldForDif);
        return this.dealNewRowUnfoldByOrg(rowNumber, colNumber, sheet, modelId, cellValues, columnIndexMap, clickCell, clickDimNumber, orgCurrencyMap, convertFormula, unfoldMap);
    }

    private Boolean unforldForDif(String audittrail) {
        if (Objects.equals("difmodel", this.getPageCache().get(TRACE_MODEL)) && Objects.equals("ATTotal", audittrail)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DynamicObjectCollection filterEffectiveMember(String clickDimNumber, DynamicObjectCollection sonInfo) {
        if ("AuditTrail".equals(clickDimNumber)) {
            sonInfo = this.getAuditTrailCol(sonInfo);
        }
        return sonInfo;
    }

    private List<Row> getEffectOLAPResultList(String clickDimNumber, MDResultSet set, DynamicObjectCollection orgSonCol) {
        ArrayList<Row> effectList = new ArrayList<Row>(set.getFetchSize());
        MDResultSetMetaData md = set.getMetaData();
        Set<String> orgs = orgSonCol.stream().map(s -> s.getString("number")).collect(Collectors.toSet());
        int orgIndex = -1;
        int processIndex = -1;
        for (MDColumn mdColumn : md.getMetaDatas()) {
            if ("Entity".equalsIgnoreCase(mdColumn.getMdName())) {
                orgIndex = mdColumn.getColIndex();
                continue;
            }
            if (!"Process".equalsIgnoreCase(mdColumn.getMdName())) continue;
            processIndex = mdColumn.getColIndex();
        }
        while (set.next()) {
            Row row = set.getRow();
            if (this.judgeIsIgnore(orgIndex, processIndex, clickDimNumber, row) || !this.orgsIsContains(orgs, row, Objects.equals(orgIndex, -1))) continue;
            effectList.add(row);
        }
        return effectList;
    }

    private boolean orgsIsContains(Set<String> orgs, Row row, boolean notexsitOrg) {
        if (notexsitOrg) {
            return true;
        }
        String orgNum = row.getString(DimTypesEnum.ENTITY.getNumber());
        if (Objects.nonNull(orgNum)) {
            String[] orgNums = orgNum.split("_");
            if (orgNums.length > 1) {
                orgNum = orgNums[1];
            }
            return orgs.contains(orgNum);
        }
        return true;
    }

    private HashMap<String, HashMap<String, String>> isAuditChidData(Boolean unfoledDim, MDResultSet set, DynamicObjectCollection orgSonCol, Map<String, DynamicObject> orgDimMap, String extenddim, DynamicObjectCollection nextChild, String processNumber, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Cell audiCell, Long modelId, Boolean flag, DynamicObjectCollection nextChildrenforAudittail, Sheet sheet, int rowNumber) {
        set.beforeFirst();
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(16);
        HashMap<String, String> resultmap = new HashMap<String, String>(16);
        HashSet<String> validchildren = new HashSet<String>(set.getCount());
        String myextenddim = extenddim;
        Set extendDims = nextChild.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        Set extendOrgs = orgSonCol.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        Set extendAts = nextChildrenforAudittail.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        List<String> belongtoMerOrg = Arrays.asList("CT", "CSTE", "SRPT", "ADJT", "SADJ", "SCADJ", "SCCADJ", "DADJ", "EJET", "SEJE", "DEJE");
        while (set.next()) {
            String auditchild;
            Row row = set.getRow();
            int orgIndex = -1;
            MDResultSetMetaData md = set.getMetaData();
            md.getMetaDatas().parallelStream().filter(s -> Objects.equals(s.getMdName(), "Entity"));
            for (MDColumn mdColumn : md.getMetaDatas()) {
                if (!"Entity".equalsIgnoreCase(mdColumn.getMdName())) continue;
                orgIndex = mdColumn.getColIndex();
            }
            String orgNum = null;
            if (orgIndex != -1) {
                orgNum = row.getString(DimTypesEnum.ENTITY.getNumber());
                if (orgNum == null || orgNum.length() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return null;
                }
                String[] orgNums = orgNum.split("_");
                if (orgNums.length > 1) {
                    orgNum = orgNums[1];
                }
            }
            String finalOrgNum = orgNum;
            String validParent = extendOrgs.stream().filter(s -> ((DynamicObject)orgDimMap.get(finalOrgNum)).getString("longnumber").startsWith(((DynamicObject)orgDimMap.get(s)).getString("longnumber"))).findFirst().orElse("");
            if (extendDims.contains(row.getString(extenddim)) && extendOrgs.contains(orgNum) && extendAts.contains(row.getString("AuditTrail")) || !this.isDifModel().booleanValue() && "Process".equals(extenddim) && extendOrgs.contains(row.getString("Entity"))) continue;
            String child = this.getExistNode(extenddim, nextChild, row.getString(extenddim), processNumber, currencyNumber, unfoldMap, columnIndexMap, audiCell, modelId);
            if (Objects.nonNull(child) && extendDims.contains(child) && (!Objects.equals(((DynamicObject)orgSonCol.get(0)).getBoolean("isleaf"), true) || !belongtoMerOrg.contains(child))) {
                validchildren.add(child);
                orgNum = validParent;
                if (unfoledDim.booleanValue()) {
                    if (resultmap.containsKey(orgNum)) {
                        String process;
                        String currentProcess = row.getString(extenddim);
                        if (DataTraceHelper.getParentNumber(currentProcess, process = (String)resultmap.get(orgNum), modelId)) {
                            resultmap.put(orgNum, row.getString(extenddim));
                        }
                    } else if (StringUtils.isNotEmpty((CharSequence)orgNum)) {
                        resultmap.put(orgNum, child);
                    }
                    if (Objects.nonNull(validParent) && !extendOrgs.contains(finalOrgNum)) {
                        boolean canModifyRow = Boolean.TRUE;
                        for (MDColumn mdColumn : md.getMetaDatas()) {
                            Cell mCell;
                            if (mdColumn.getMdName().equals("Entity") || mdColumn.getMdName().equals("FMONEY") || mdColumn.getMdName().equals("Process") || (mCell = sheet.getCell(rowNumber, columnIndexMap.get(mdColumn.getMdName()).intValue())).getUserObject("number").equals(row.getValue(row.getColIndex(mdColumn.getMdName())))) continue;
                            canModifyRow = Boolean.FALSE;
                        }
                        if (canModifyRow && (row.getColIndex("Entity") != -1 || row.getColIndex("Process") != -1)) {
                            row.replaceColumnValue(row.getColIndex("Entity"), (Object)validParent);
                            row.replaceColumnValue(row.getColIndex("Process"), (Object)child);
                            row.replaceColumnValue(row.getColIndex("FMONEY"), (Object)0);
                        }
                    }
                } else {
                    resultmap.put(child, orgNum);
                }
            }
            if (!flag.booleanValue() || !validchildren.isEmpty() || !Objects.nonNull(auditchild = this.getExistNode("AuditTrail", nextChildrenforAudittail, row.getString("AuditTrail"), processNumber, currencyNumber, unfoldMap, columnIndexMap, audiCell, modelId)) || !extendAts.contains(auditchild)) continue;
            if (ConfigServiceHelper.getGlobalBoolParam((String)"isIntegrationResetNum")) {
                resultmap.put(auditchild, orgNum);
            } else {
                resultmap.put("AuditTrail", auditchild);
            }
            myextenddim = "AuditTrail";
        }
        set.beforeFirst();
        if (resultmap.size() > 0) {
            result.put(myextenddim, resultmap);
        }
        return result;
    }

    private String getExistNode(String extenddim, DynamicObjectCollection nextChild, String value, String processNumber, String currencyNumber, Map<String, List<String>> unfoldMap, Map<String, Integer> columnIndexMap, Cell audiCell, Long modelId) {
        String resultstring = null;
        for (DynamicObject temp : nextChild) {
            if (Objects.equals(temp.getString("number"), value)) {
                return temp.getString("number");
            }
            DynamicObjectCollection result = new DynamicObjectCollection();
            DataTraceHelper.getAllChildrenNodes(extenddim, temp.getString("number"), temp.getLong("id"), currencyNumber, unfoldMap, columnIndexMap, result, modelId, audiCell, false);
            if (!result.parallelStream().anyMatch(s -> Objects.equals(s.getString("number"), value))) continue;
            return temp.getString("number");
        }
        return resultstring;
    }

    private DynamicObjectCollection getSonInfo(Sheet sheet, long modelId, Cell clickCell, String clickDimNumber, Map<String, Integer> columnIndexMap, Map<String, List<String>> unfoldMap, Map<String, String> orgCurrencyMap, Boolean money, Boolean ignoreAT) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        int rowNumber = clickCell.getRow();
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        Cell audiCell = null;
        if (columnIndexMap.containsKey("AuditTrail")) {
            audiCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        }
        if ("Process".equalsIgnoreCase(clickDimNumber) && DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, ignoreAT) != null) {
            qFilter.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            qFilter.and("number", "in", DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, ignoreAT));
        } else if ("Currency".equalsIgnoreCase(clickDimNumber)) {
            qFilter.and("number", "=", this.getQueryCurrency(clickCell, orgCurrencyMap, orgCell));
        } else {
            qFilter.and("parent.id", "=", clickCell.getUserObject("id"));
        }
        if (Objects.equals(money, true)) {
            if ("Process".equalsIgnoreCase(clickDimNumber)) {
                DynamicObjectCollection result = new DynamicObjectCollection();
                result = DataTraceHelper.getAllChildrenNodes("Process", processCell.getUserObject("number").toString(), LongUtil.toLong((Object)processCell.getUserObject("id")), currencyCell.getUserObject("number").toString(), unfoldMap, columnIndexMap, result, modelId, audiCell, ignoreAT);
                return result.parallelStream().distinct().collect(Collectors.toCollection(DynamicObjectCollection::new));
            }
            if ("Currency".equalsIgnoreCase(clickDimNumber)) {
                qFilter.and("number", "=", (Object)orgCurrencyMap.get(orgCell.getUserObject("number").toString()));
            } else {
                String longNumber = MemberReader.findMemberById((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)clickDimNumber), (Long)((Long)clickCell.getUserObject("id"))).getLongNumber();
                qFilter = new QFilter("model", "=", (Object)modelId).and(new QFilter("longnumber", "like", (Object)(longNumber + "!%")));
            }
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if ("InternalCompany".equals(clickDimNumber)) {
            Set<String> InternalCompanyNumber = this.getInternalCompanyNumber(sheet, rowNumber, columnIndexMap, clickDimNumber);
            if (InternalCompanyNumber.size() > 0) {
                qFilter.and("number", "in", InternalCompanyNumber);
            } else {
                return collection;
            }
        }
        DynamicObjectCollection dynamicObjectMap = QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)clickDimNumber), (String)"id,name,number,isleaf,level,storagetype,dseq,aggoprt,longnumber", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] dys = dynamicObjectMap.stream().sorted(Comparator.comparing(dy -> dy.getInt("dseq"))).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        for (int i = 0; i < dys.length; ++i) {
            collection.add(i, dys[i]);
        }
        return collection;
    }

    private Object getQueryCurrency(Cell clickCell, Map<String, String> orgCurrencyMap, Cell orgCell) {
        if (EXPANDOC.equals(clickCell.getUserObject(ISEXPANDOC))) {
            return CurrencyEnum.OC.getNumber();
        }
        return orgCurrencyMap.get(orgCell.getUserObject("number").toString());
    }

    private DynamicObject getSingleDynamicObject(String dimName, String memNumber) {
        QFilter qFilter2 = new QFilter("model", "=", this.getFormCustomParam("model"));
        qFilter2.and("number", "=", (Object)memNumber);
        String selectFiled = "id,name,number,isleaf,level,aggoprt";
        if (this.isDifModel().booleanValue() && "AuditTrail".equals(dimName)) {
            selectFiled = "id,name,number,isleaf,level";
        }
        DynamicObject atTotalObj = BusinessDataServiceHelper.loadSingleFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)selectFiled, (QFilter[])new QFilter[]{qFilter2});
        return atTotalObj;
    }

    private boolean judgeIsIgnore(int orgIndex, int processIndex, String dimName, Row row) {
        boolean isIgnore = false;
        if (orgIndex != -1 && processIndex != -1 && "Process".equalsIgnoreCase(dimName)) {
            String[] orgNum = row.getValue(orgIndex).toString().split("_");
            if (OrgRelaProcessMembPool.isRelaProcess((String)row.getValue(processIndex).toString())) {
                if (orgNum.length != 2) {
                    isIgnore = true;
                }
            } else if (orgNum.length == 2) {
                isIgnore = true;
            }
        }
        return isIgnore;
    }

    private void buildSonNode(DynamicObjectCollection col, Map<String, DynamicObject> sonDimMap) {
        HashMap<String, String> numberMap = new HashMap<String, String>(16);
        for (DynamicObject dim : col) {
            String number = dim.getString("number");
            Set<String> properties = this.getProperties(dim);
            if (properties.contains("longnumber")) {
                String longnumber = dim.getString("longnumber");
                if (StringUtil.isEmptyString((String)longnumber)) {
                    sonDimMap.put(number, dim);
                    continue;
                }
                String preLongNumber = (String)numberMap.get(number);
                if (preLongNumber != null && preLongNumber.length() <= longnumber.length()) continue;
                numberMap.put(number, longnumber);
                sonDimMap.put(number, dim);
                continue;
            }
            sonDimMap.put(number, dim);
        }
    }

    private void dealSpecialCell(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int inserRowNum, Set<Integer> hyperlinkSet) {
        Cell audiCell = null;
        String audiNum = null;
        if (this.isExistAuditTrailDimension()) {
            audiCell = sheet.getCell(inserRowNum, columnIndexMap.get("AuditTrail").intValue());
            audiNum = audiCell.getUserObject("number").toString();
        }
        Cell processCell = sheet.getCell(inserRowNum, columnIndexMap.get("Process").intValue());
        Cell accountCell = sheet.getCell(inserRowNum, columnIndexMap.get("Account").intValue());
        String process = processCell.getUserObject("number").toString();
        if (!doNotShowHyperlink.contains(process) && (!"EJE".equals(processCell.getUserObject("number").toString()) || "EJE".equals(processCell.getUserObject("number").toString()) && processCell.getUserObject("isleaf") != null) && audiNum != null && this.isEntryAdjusted(audiNum) && accountCell.getUserObject("isleaf") != null) {
            hyperlinkSet.add(inserRowNum);
        }
    }

    private void setCurrencyCell(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int inserRowNum, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula) {
        Cell orgCell = sheet.getCell(inserRowNum, columnIndexMap.get("Entity").intValue());
        Cell curCell = sheet.getCell(inserRowNum, columnIndexMap.get("Currency").intValue());
        Cell proCell = sheet.getCell(inserRowNum, columnIndexMap.get("Process").intValue());
        Cell audCell = null;
        if (this.isExistAuditTrailDimension()) {
            audCell = sheet.getCell(inserRowNum, columnIndexMap.get("AuditTrail").intValue());
        }
        String orgNum = orgCell.getUserObject("number").toString();
        boolean isSpecial = false;
        String proNum = proCell.getUserObject("number").toString();
        String audNum = audCell == null ? null : audCell.getUserObject("number").toString();
        String converNum = convertFormula.getConvertAudittrial();
        if (converNum == null) {
            isSpecial = true;
        }
        String curNumber = curCell.getUserObject("number").toString();
        int expandType = 0;
        if (!(isSpecial || curNumber.equalsIgnoreCase(orgCurrencyMap.get(orgNum)) || !"EIRpt".equalsIgnoreCase(proNum) && !"IRpt".equalsIgnoreCase(proNum) || !isSpecial && !converNum.equalsIgnoreCase(audNum) || CurrencyEnum.OC.getNumber().equalsIgnoreCase(curNumber))) {
            expandType = 1;
        } else if (this.checkExpandOc(orgCell, orgCurrencyMap, curNumber, proNum, sheet, inserRowNum, columnIndexMap)) {
            expandType = 2;
        }
        if (expandType > 0) {
            String displayContent = (String)curCell.getValue();
            String values = displayContent.replaceAll("^[\u3000 ]+", "");
            if (!values.startsWith(EXPAND_PLUS)) {
                displayContent = EXPAND_PLUS + displayContent;
                curCell.setValue((Object)displayContent);
                curCell.removeUserObject("isleaf");
                cellValues.add(this.packedUpdateCellMap(inserRowNum, columnIndexMap.get("Currency"), displayContent));
            }
            if (expandType == 2) {
                curCell.setUserObject(ISEXPANDOC, (Object)EXPANDOC);
            }
        }
    }

    private boolean checkExpandOc(Cell orgCell, Map<String, String> orgCurrencyMap, String curNumber, String proNum, Sheet sheet, int inserRowNum, Map<String, Integer> columnIndexMap) {
        Long orgId;
        Long periodId;
        Long yearId;
        Long scenarioId;
        Long modelId;
        MergeDataSourceEnum mergeSource;
        String ocDim = this.getPageCache().get("OCDim");
        String oCNumber = this.getPageCache().get("OCNumber");
        if (ocDim == null || oCNumber == null) {
            return false;
        }
        this.ocPair = Pair.onePair((Object)ocDim, (Object)JSONObject.parseObject((String)oCNumber, Set.class));
        if (CollectionUtil.isEmpty((Collection)((Collection)this.ocPair.p2))) {
            return false;
        }
        Integer ocCol = columnIndexMap.get(this.ocPair.p1);
        Cell cell = sheet.getCell(inserRowNum, ocCol.intValue());
        if (cell == null) {
            return false;
        }
        String ocNum = cell.getUserObject("number").toString();
        if (!((Set)this.ocPair.p2).contains(ocNum)) {
            return false;
        }
        String orgNum = orgCell.getUserObject("number").toString();
        String orgCurrency = orgCurrencyMap.get(orgNum);
        if (!curNumber.equalsIgnoreCase(orgCurrency)) {
            return false;
        }
        Integer isleaf = (Integer)orgCell.getUserObject("isleaf");
        if (isleaf == null) {
            Long orgId2 = (Long)orgCell.getUserObject("id");
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)orgId2);
            isleaf = entity.isLeaf() ? 1 : 2;
        }
        if (1 != isleaf && MergeDataSourceEnum.CSTE != (mergeSource = MergeControlHelper.getMergeSource((Object)(modelId = Long.valueOf(((DynamicObject)this.getModel().getValue("model")).getLong("id"))), (Object)(scenarioId = Long.valueOf(((DynamicObject)this.getModel().getValue("scenario")).getLong("id"))), (Object)(yearId = Long.valueOf(((DynamicObject)this.getModel().getValue("year")).getLong("id"))), (Object)(periodId = Long.valueOf(((DynamicObject)this.getModel().getValue("period")).getLong("id"))), (Object)(orgId = (Long)orgCell.getUserObject("id"))))) {
            return false;
        }
        if (1 == isleaf && !staticExpandOCProcess.contains(proNum)) {
            return false;
        }
        return 1 == isleaf || staticExpandOCProcess.contains(proNum) || "CSTE".equals(proNum);
    }

    private void copyOldCell(int rowNumber, Sheet sheet, Cell cell, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int inserRowNum, int j, Map<Integer, Map<String, String>> insertDimMember) {
        Cell newCell = sheet.getCell(inserRowNum, j);
        Cell oldCell = sheet.getCell(rowNumber, j);
        String oldValue = (String)oldCell.getValue();
        if (oldValue != null && oldValue.startsWith(EXPAND_SUB)) {
            oldValue = oldValue.replace(EXPAND_SUB, EXPAND_PLUS);
        }
        if (columnIndexMap.get("Entity") == j && oldValue != null && oldValue.trim().startsWith(EXPAND_PLUS)) {
            oldValue = oldValue.replace(EXPAND_PLUS, "");
        }
        String number = oldCell.getUserObject("number").toString();
        insertDimMember.computeIfAbsent(inserRowNum, m -> new HashMap());
        Map<String, String> dimMember = insertDimMember.get(inserRowNum);
        columnIndexMap.forEach((k, v) -> {
            if (v == j) {
                dimMember.put((String)k, number);
            }
        });
        newCell.setValue((Object)oldValue);
        newCell.setUserObject("number", (Object)number);
        newCell.setUserObject("name", oldCell.getUserObject("name"));
        newCell.setUserObject("id", oldCell.getUserObject("id"));
        newCell.setUserObject("level", oldCell.getUserObject("level"));
        newCell.setUserObject("isleaf", oldCell.getUserObject("isleaf"));
        newCell.setUserObject("ti", oldCell.getUserObject("ti"));
        newCell.setUserObject("cellFlag", (Object)GlobalIdUtil.genStringId());
        newCell.setUserObject("openParent", cell.getUserObject("cellFlag"));
        newCell.setUserObject("parentCell", (Object)cell);
        cellValues.add(this.packedUpdateCellMap(inserRowNum, j, oldValue));
        this.dealCellIndent(oldCell, inserRowNum, j, newCell);
    }

    private void dealCellIndent(Cell cell, int inserRowNum, int j, Cell newCell) {
        if (cell.getUserObject("ti") != null) {
            int ti = (Integer)cell.getUserObject("ti");
            newCell.setUserObject("ti", (Object)ti);
            SearchHelper.setIndent(this.getClientViewProxy(), spreadKey, inserRowNum, j, 1, 1, ti);
        }
    }

    private String getTranslateNumber(String number) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("SEIC", "EICA");
        map.put("SEIT", "EIT");
        map.put("SEOE", "EOE");
        map.put("SECF", "ECF");
        map.put("SEOther", "EOther");
        map.put("SADJ", "ADJ");
        map.put("SCADJ", "CADJ");
        map.put("ACCADJ", "CCADJ");
        map.put("SIRpt", "IRpt");
        return (String)map.get(number);
    }

    private void buildSingleNewRow(int rowNumber, int colNumber, Sheet sheet, List<Map<String, Object>> cellValues, Map<String, DynamicObject> sonDimMap, Map<String, Integer> columnIndexMap, int inserRowNum, Map<String, Object> row, DynamicObject atTotalObj, String clickDimNumber, Map<String, List<String>> unfoldMap, Map<String, DynamicObject> orgDimMap, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula, DynamicObject erptObj, Map<Integer, Map<String, String>> insertDimMember) {
        Cell clickCell = sheet.getCell(rowNumber, colNumber);
        for (int j = 0; j < sheet.getMaxColumnCount(); ++j) {
            String[] orgNums;
            String orgNum;
            Cell dimCell = sheet.getCell(0, j);
            if (dimCell.getUserObject("number") == null) continue;
            if (j == colNumber) {
                DynamicObject mem = sonDimMap.get(row.get(clickDimNumber));
                if (mem == null) continue;
                this.buildSingleCellData(cellValues, inserRowNum, mem, j, sheet, clickCell, dimCell.getUserObject("number").toString(), true, insertDimMember);
                continue;
            }
            if (j == columnIndexMap.get("fMoney")) {
                Cell newCell = sheet.getCell(inserRowNum, j);
                newCell.setValue(row.get(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                cellValues.add(this.packedUpdateCellMap(inserRowNum, j, row.get(FacTabFieldDefEnum.FIELD_MONEY.getField())));
                continue;
            }
            if (j == columnIndexMap.get("Entity") && "Process".equalsIgnoreCase(clickDimNumber) && DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
                orgNum = (String)row.get("Entity");
                if (orgNum == null || orgNum.length() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    return;
                }
                orgNums = orgNum.split("_");
                if (orgNums.length > 1) {
                    orgNum = orgNums[1];
                }
                this.buildSingleCellData(cellValues, inserRowNum, orgDimMap.get(orgNum), j, sheet, clickCell, dimCell.getUserObject("number").toString(), true, insertDimMember);
                continue;
            }
            if (this.isExistAuditTrailDimension() && j == columnIndexMap.get("AuditTrail") && (Objects.equals(clickDimNumber, "Process") && DataTraceHelper.isIRptEC(sheet, rowNumber, columnIndexMap, unfoldMap) || DataTraceHelper.needChangeAudiForIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap, convertFormula))) {
                this.buildSingleCellData(cellValues, inserRowNum, atTotalObj, j, sheet, clickCell, "AuditTrail", false, insertDimMember);
                continue;
            }
            if ("Currency".equalsIgnoreCase(clickDimNumber) && j == columnIndexMap.get("Process") && DataTraceHelper.isIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) {
                this.buildSingleCellData(cellValues, inserRowNum, erptObj, j, sheet, clickCell, "Process", false, insertDimMember);
                SearchHelper.setCellIndent(this.getClientViewProxy(), spreadKey, sheet.getCell(clickCell.getRow(), j), sheet.getCell(inserRowNum, j));
                continue;
            }
            if (this.isDifModel().booleanValue() && j == columnIndexMap.get("Currency") && Objects.equals(row.get("Process"), "ERpt")) {
                orgNum = (String)row.get("Entity");
                orgNums = orgNum.split("_");
                if (orgNums.length > 1) {
                    orgNum = orgNums[1];
                }
                String curNumber = orgDimMap.get(orgNum).getString("currency.number");
                Long modelId = orgDimMap.get(orgNum).getLong("model.id");
                if (!Objects.equals(row.get("Currency"), curNumber)) continue;
                QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
                qfBuilder.and("number", "=", (Object)curNumber);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,name,number,level,isleaf", (QFilter[])qfBuilder.toArray());
                this.buildSingleCellData(cellValues, inserRowNum, obj, j, sheet, clickCell, "Currency", false, insertDimMember);
                continue;
            }
            if (j == columnIndexMap.get("rMoney")) continue;
            this.copyOldCell(rowNumber, sheet, clickCell, cellValues, columnIndexMap, inserRowNum, j, insertDimMember);
        }
        this.setToOrgCell(clickDimNumber, columnIndexMap, sheet, clickCell, rowNumber, inserRowNum);
    }

    private MDResultSet getDataFromOLAP(Sheet sheet, int rowNumber, int colNumber, DynamicObjectCollection sonInfo, Map<String, Integer> columnIndexMap, DynamicObjectCollection orgSonCol, Map<String, List<String>> unfoldMap, DynamicObject atTotalObj, String clickDimNumber, BaseConvertFormula convertFormula, Map<String, String> orgCurrencyMap, DynamicObject erptObj, Boolean money) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        SQLBuilder sql = new SQLBuilder(model.getString("number"));
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        DynamicObject year = this.addFilterByPageDim(sql, "Year");
        DynamicObject period = this.addFilterByPageDim(sql, "Period");
        DynamicObject scene = this.addFilterByPageDim(sql, "Scenario");
        if (this.isDifModel().booleanValue() && this.needChangeSon(sheet, rowNumber, columnIndexMap, orgCurrencyMap) && ("Entity".equals(clickDimNumber) || "Process".equals(clickDimNumber))) {
            DynamicObjectCollection erpt = new DynamicObjectCollection();
            erpt.add((Object)erptObj);
            sonInfo = erpt;
        }
        try {
            if (columnIndexMap.containsKey(DimTypesEnum.INTERCOMPANY.getNumber()) && year != null && period != null && scene != null) {
                Cell cell = sheet.getCell(rowNumber, colNumber);
                IDNumberTreeNode icNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_icmembertree", (Long)((Long)cell.getUserObject("id")));
                if (IDNumberTreeNode.NotFoundTreeNode != icNode) {
                    VersionParam verParam = new VersionParam(this.getModelId(), scene.getLong("id"), year.getLong("id"), period.getLong("id"));
                    MembRangeItem item = new MembRangeItem("bcm_icmembertree", icNode.getId(), icNode.getLongNumber(), icNode.getNumber(), RangeEnum.VALUE_50, false, (Object)this.getModelId());
                    HashSet icIds = new HashSet(16);
                    item.matchItem4Ic(verParam, c -> icIds.add(c.getId()));
                    sonInfo.removeIf(s -> !icIds.contains(s.getLong("id")));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (this.setOLAPFilterFromSheet(sheet, rowNumber, colNumber, sonInfo, columnIndexMap, orgSonCol, unfoldMap, atTotalObj, sql, convertFormula, orgCurrencyMap, erptObj, clickDimNumber)) {
            return null;
        }
        if (!"Process".equalsIgnoreCase(clickDimNumber) && !this.isInSelectDimList(clickDimNumber)) {
            if (!this.isExistAuditTrailDimension()) {
                if (money.booleanValue()) {
                    sql.addSelectField(new String[]{clickDimNumber, "Process", "Currency", "Entity"});
                } else {
                    sql.addSelectField(new String[]{clickDimNumber, "Process", "Currency"});
                }
            } else if (money.booleanValue()) {
                sql.addSelectField(new String[]{clickDimNumber, "Process", "AuditTrail", "Currency", "Entity"});
            } else {
                sql.addSelectField(new String[]{clickDimNumber, "Process", "AuditTrail", "Currency"});
            }
        } else if (!this.isExistAuditTrailDimension()) {
            sql.addSelectField(selectDimListATCT);
        } else {
            sql.addSelectField(selectDimList);
        }
        try {
            MDResultSet resultSet = OlapServiceHelper.queryData((SQLBuilder)sql);
            return resultSet;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return new MDResultSet();
        }
    }

    private Set<String> getInternalCompanyNumber(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, String clickDimNumber) {
        MDResultSet resultSet = this.getInternalCompanyNumberDataFromOLAP(sheet, rowNumber, columnIndexMap, clickDimNumber);
        if (resultSet != null && resultSet.getFetchSize() > 0) {
            HashSet<String> number = new HashSet<String>(resultSet.getCount());
            while (resultSet.next()) {
                String member = resultSet.getString("InternalCompany");
                if (member == null) continue;
                number.add(member);
            }
            return number;
        }
        return Collections.emptySet();
    }

    private MDResultSet getInternalCompanyNumberDataFromOLAP(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, String clickDimNumber) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        SQLBuilder sql = new SQLBuilder(model.getString("number"));
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        this.addFilterByPageDim(sql, "Year");
        this.addFilterByPageDim(sql, "Period");
        this.addFilterByPageDim(sql, "Scenario");
        int colNumber = columnIndexMap.get(clickDimNumber);
        if (this.setInternalCompanyOLAPFilterFromSheet(sheet, rowNumber, colNumber, columnIndexMap, sql)) {
            return null;
        }
        sql.addSelectField(new String[]{clickDimNumber});
        ISqlLazyFilter & Serializable filter = (ISqlLazyFilter & Serializable)member -> true;
        sql.addLazyFilter("InternalCompany", (ISqlLazyFilter)filter);
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private boolean setInternalCompanyOLAPFilterFromSheet(Sheet sheet, int rowNumber, int colNumber, Map<String, Integer> columnIndexMap, SQLBuilder sql) {
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            Cell currentDimCell = sheet.getCell(0, i);
            String dimNumber = (String)currentDimCell.getUserObject("number");
            if (i == colNumber) continue;
            if ("AuditTrail".equalsIgnoreCase(dimNumber)) {
                Cell auditTrailCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
                sql.addFilter(dimNumber, new String[]{auditTrailCell.getUserObject("number").toString()});
                continue;
            }
            if ("Entity".equalsIgnoreCase(dimNumber)) {
                DynamicObjectCollection col = this.getOrgByOrgCell(sheet, rowNumber, columnIndexMap);
                Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
                sql.addFilter(dimNumber, this.dealOrgMemForOLAP(col, Collections.singletonList(processCell.getUserObject("number").toString())));
                continue;
            }
            Cell cell = sheet.getCell(rowNumber, i);
            if (cell.getUserObject("number") == null) continue;
            sql.addFilter(dimNumber, new String[]{cell.getUserObject("number").toString()});
        }
        return false;
    }

    private boolean needChangeSon(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap) {
        Cell orgCell;
        Cell proCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        if (proCell.getUserObject("number") != null && "Rpt".equals(proCell.getUserObject("number")) && (orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue())).getUserObject("number") != null) {
            Cell curCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
            String entityNumber = this.findEntityNumber(orgCell.getUserObject("number").toString());
            if (curCell.getUserObject("number") != null && !curCell.getUserObject("number").equals(orgCurrencyMap.get(entityNumber))) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private boolean needChangeToBaseCurrency(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap) {
        Cell orgCell;
        Cell proCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        if (proCell.getUserObject("number") != null && "Rpt".equals(proCell.getUserObject("number")) && (orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue())).getUserObject("number") != null) {
            Cell curCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
            String entityNumber = this.findEntityNumber(orgCell.getUserObject("number").toString());
            if (curCell.getUserObject("number") != null && !curCell.getUserObject("number").equals(orgCurrencyMap.get(entityNumber))) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private MDResultSet getInitDataFromOLAP(List<Map<String, Object>> selectDimCell, Map<String, Object> commonMemberList, String[] selectDim, Map<String, Object> dimMemList, String measure) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        SQLBuilder sql = new SQLBuilder(model.getString("number"));
        sql.addMeasures(new String[]{measure});
        for (Map.Entry<String, Object> entry : commonMemberList.entrySet()) {
            if (selectDimCell.get(0).containsKey(entry.getKey())) continue;
            String string = entry.getValue().toString();
            if ("Entity".equalsIgnoreCase(entry.getKey()) && dimMemList.get(entry.getKey() + "," + string) != null) {
                DynamicObject org = (DynamicObject)dimMemList.get(entry.getKey() + "," + string);
                OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(Long.valueOf(org.getLong("id")), string, (Long)this.getFormCustomParam("model"));
                String string2 = string + "," + supplier.access(string);
                sql.addFilter(entry.getKey(), string2.split(","));
                continue;
            }
            sql.addFilter(entry.getKey(), new String[]{string});
        }
        HashMap<String, String> selectMap = new HashMap<String, String>(selectDimCell.size());
        for (Map<String, Object> map : selectDimCell) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String dimName = entry.getKey();
                String value = null;
                if (entry.getValue() != null) {
                    value = entry.getValue().toString();
                }
                if (CELL_VALUE.equalsIgnoreCase(dimName)) continue;
                if (selectMap.get(dimName) == null) {
                    selectMap.put(dimName, value);
                    continue;
                }
                selectMap.put(dimName, (String)selectMap.get(dimName) + "," + value);
            }
        }
        for (Map.Entry entry : selectMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if ("Entity".equalsIgnoreCase((String)entry.getKey())) {
                this.setOrgFilterForSelectInit(dimMemList, sql, entry);
                continue;
            }
            sql.addFilter((String)entry.getKey(), ((String)entry.getValue()).split(","));
        }
        sql.addSelectField(selectDim);
        log.info("DataTracePlugin sql: " + sql);
        if (FacTabFieldDefEnum.FIELD_SOURCE.getField().equals(measure)) {
            DataTracePlugin.changeSQLBuilder(sql);
        }
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private static void changeSQLBuilder(SQLBuilder sql) {
        List filters = sql.getFilters();
        for (Pair filter : filters) {
            if (!"Process".equals(filter.p1)) continue;
            String[] member = (String[])filter.p2;
            for (int i = 0; i < member.length; ++i) {
                if ("EIRpt".equals(member[i])) {
                    member[i] = "IRpt";
                    continue;
                }
                if (!"ERAdj".equals(member[i])) continue;
                member[i] = "RAdj";
            }
            sql.replaceOrAddFilter("Process", member);
        }
    }

    private void setOrgFilterForSelectInit(Map<String, Object> dimMemList, SQLBuilder sql, Map.Entry<String, String> entry) {
        String[] numbers = entry.getValue().split(",");
        String[] newNumbers = new String[numbers.length * 2];
        for (int i = 0; i < numbers.length; ++i) {
            IDNumberTreeNode org;
            String number = numbers[i];
            if (dimMemList.get(entry.getKey() + "," + number) != null) {
                org = (DynamicObject)dimMemList.get(entry.getKey() + "," + number);
                OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(Long.valueOf(org.getLong("id")), number, (Long)this.getFormCustomParam("model"));
                newNumbers[i * 2 + 1] = supplier.access(number);
            } else {
                org = MemberReader.findMemberByNumber((String)sql.getCubecatalog(), (String)DimEntityNumEnum.ENTITY.getNumber(), (String)number);
                newNumbers[i * 2 + 1] = org.getNumber();
            }
            newNumbers[i * 2] = number;
        }
        sql.addFilter(entry.getKey(), newNumbers);
    }

    private boolean isInSelectDimList(String clickDimNumber) {
        boolean result = false;
        for (String dimNum : selectDimList) {
            if (!dimNum.equalsIgnoreCase(clickDimNumber)) continue;
            result = true;
        }
        return result;
    }

    private boolean setOLAPFilterFromSheet(Sheet sheet, int rowNumber, int colNumber, DynamicObjectCollection sonInfo, Map<String, Integer> columnIndexMap, DynamicObjectCollection orgSonCol, Map<String, List<String>> unfoldMap, DynamicObject atTotalObj, SQLBuilder sql, BaseConvertFormula convertFormula, Map<String, String> orgCurrencyMap, DynamicObject erptObj, String clickDimNumber) {
        Cell fMoney = sheet.getCell(rowNumber, columnIndexMap.get("fMoney").intValue());
        Boolean money = DataTraceHelper.checkZero(fMoney.getValue());
        for (int i = 0; i < sheet.getMaxColumnCount(); ++i) {
            Cell cell;
            Cell currentDimCell = sheet.getCell(0, i);
            String dimNumber = (String)currentDimCell.getUserObject("number");
            if (i == colNumber) {
                sql.addFilter(dimNumber, DataTraceHelper.getMembersFromCollection(sonInfo));
                continue;
            }
            if ("AuditTrail".equalsIgnoreCase(dimNumber)) {
                Boolean specialScenes = !(!Objects.equals(clickDimNumber, "Process") && !Objects.equals(clickDimNumber, "Currency") || !DataTraceHelper.isIRptEC(sheet, rowNumber, columnIndexMap, unfoldMap) && !DataTraceHelper.needChangeAudiForIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap, convertFormula));
                if (!money.booleanValue() && !specialScenes.booleanValue()) {
                    Cell auditTrailCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
                    sql.addFilter(dimNumber, new String[]{auditTrailCell.getUserObject("number").toString()});
                    continue;
                }
                if (!money.booleanValue() && specialScenes.booleanValue()) {
                    sql.addFilter(dimNumber, new String[]{atTotalObj.getString("number")});
                    continue;
                }
                if (money.booleanValue() && specialScenes.booleanValue()) {
                    sql.addFilter(dimNumber, this.getArptObjAuditTrailDirectSubordinate(atTotalObj.getString("number")));
                    continue;
                }
                if (!money.booleanValue() || specialScenes.booleanValue()) continue;
                sql.addFilter(dimNumber, this.getCurrentAuditTrailDirectSubordinate(sheet, rowNumber, columnIndexMap));
                continue;
            }
            if ("Entity".equalsIgnoreCase(dimNumber)) {
                DynamicObjectCollection col;
                if (money.booleanValue() && Objects.nonNull(orgSonCol) && !orgSonCol.isEmpty()) {
                    sql.addFilter(dimNumber, this.dealOrgMemForOLAP(orgSonCol, Arrays.asList(DataTraceHelper.getMembersFromCollection(sonInfo))));
                    continue;
                }
                if ("Process".equalsIgnoreCase(clickDimNumber)) {
                    if (DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
                        if (Objects.isNull(orgSonCol) || orgSonCol.isEmpty()) {
                            return true;
                        }
                        sql.addFilter(dimNumber, this.dealOrgMemForOLAP(orgSonCol, DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, false)));
                        continue;
                    }
                    col = this.getOrgByOrgCell(sheet, rowNumber, columnIndexMap);
                    sql.addFilter(dimNumber, this.dealOrgMemForOLAP(col, Arrays.asList(DataTraceHelper.getMembersFromCollection(sonInfo))));
                    continue;
                }
                col = this.getOrgByOrgCell(sheet, rowNumber, columnIndexMap);
                Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
                sql.addFilter(dimNumber, this.dealOrgMemForOLAP(col, Collections.singletonList(processCell.getUserObject("number").toString())));
                continue;
            }
            if ("Currency".equalsIgnoreCase(clickDimNumber) && "Process".equalsIgnoreCase(dimNumber) && DataTraceHelper.isIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) {
                sql.addFilter(dimNumber, new String[]{erptObj.getString("number")});
                continue;
            }
            if ("Currency".equalsIgnoreCase(dimNumber) && this.isDifModel().booleanValue() && (clickDimNumber.equals("Process") || clickDimNumber.equals("Entity"))) {
                Set<String> currencys = orgSonCol.stream().filter(s -> Objects.nonNull(s.get("currency.number"))).map(s -> s.getString("currency.number")).collect(Collectors.toSet());
                if (currencys.size() > 0) {
                    sql.addFilter(dimNumber, currencys.toArray(new String[0]));
                }
                if (!this.needChangeToBaseCurrency(sheet, rowNumber, columnIndexMap, orgCurrencyMap)) continue;
                this.changeToBaseCurrency(dimNumber, sql, sheet, rowNumber, columnIndexMap, orgCurrencyMap);
                continue;
            }
            if (money.booleanValue() && ("Currency".equalsIgnoreCase(dimNumber) || "AuditTrail".equalsIgnoreCase(dimNumber)) || (cell = sheet.getCell(rowNumber, i)).getUserObject("number") == null) continue;
            sql.addFilter(dimNumber, new String[]{cell.getUserObject("number").toString()});
        }
        return false;
    }

    private void changeToBaseCurrency(String dimNumber, SQLBuilder sql, Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap, Map<String, String> orgCurrencyMap) {
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        if (orgCell.getUserObject("number") != null && orgCurrencyMap.get(orgCell.getUserObject("number")) != null) {
            sql.replaceOrAddFilter(dimNumber, new String[]{orgCurrencyMap.get(orgCell.getUserObject("number"))});
        }
    }

    private String[] getCurrentAuditTrailDirectSubordinate(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap) {
        HashSet<String> memSet = new HashSet<String>(16);
        Cell auditTrailCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        String auditTrailNumber = auditTrailCell.getUserObject("number").toString();
        memSet.addAll(this.getAuditTrailDirectSubordinateNumber(auditTrailNumber));
        memSet.add(auditTrailNumber);
        return memSet.toArray(new String[memSet.size()]);
    }

    private String[] getArptObjAuditTrailDirectSubordinate(String number) {
        HashSet<String> memSet = new HashSet<String>(16);
        memSet.addAll(this.getAuditTrailDirectSubordinateNumber(number));
        memSet.add(number);
        return memSet.toArray(new String[memSet.size()]);
    }

    private Set<String> getAuditTrailDirectSubordinateNumber(String auditTrailNumber) {
        HashSet<String> memSet = new HashSet<String>(16);
        String modelNumber = MemberReader.findModelNumberById((Object)this.getFormCustomParam("model"));
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNumber, (String)"AuditTrail", (String)auditTrailNumber);
        List child = node.getChildren();
        for (IDNumberTreeNode childMember : child) {
            memSet.add(childMember.getNumber());
        }
        return memSet;
    }

    private DynamicObjectCollection getOrgByOrgCell(Sheet sheet, int rowNumber, Map<String, Integer> columnIndexMap) {
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust");
        org.set("id", (Object)Long.valueOf(orgCell.getUserObject("id").toString()));
        org.set("number", (Object)orgCell.getUserObject("number").toString());
        col.add((Object)org);
        return col;
    }

    private String[] dealOrgMemForOLAP(DynamicObjectCollection col, List<String> memNumbers) {
        HashSet<String> memSet = new HashSet<String>(16);
        for (DynamicObject obj : col) {
            String number = obj.getString("number");
            for (String mem : memNumbers) {
                String newMember = number;
                if (mem != null && OrgRelaProcessMembPool.isRelaProcess((String)mem)) {
                    OrgRelaMembSupplier supplier = new OrgRelaMembSupplier(Long.valueOf(obj.getLong("id")), number, (Long)this.getFormCustomParam("model"));
                    newMember = supplier.access(newMember);
                }
                memSet.add(newMember);
            }
        }
        return memSet.toArray(new String[memSet.size()]);
    }

    private DynamicObjectCollection getBasicDimSon(String dimName, String member, String isNeedChildData) {
        QFilter qFilter2 = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
        QFilter qFilter = new QFilter("parent.id", "=", (Object)LongUtil.toLong((Object)member));
        if (Objects.nonNull(isNeedChildData)) {
            QFilter qf = new QFilter("longnumber", "like", (Object)(isNeedChildData + "!%"));
            return QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)"id,name,number,isleaf,level,longnumber,parent.number,parent.longnumber,currency,currency.number,model", (QFilter[])new QFilter[]{qFilter2, qf}, (String)"dseq asc");
        }
        return QueryServiceHelper.query((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimName), (String)"id,name,number,isleaf,level,longnumber,parent.number,parent.longnumber,currency,currency.number,model", (QFilter[])new QFilter[]{qFilter2, qFilter}, (String)"dseq asc");
    }

    private DynamicObject addFilterByPageDim(SQLBuilder sql, String dimName) {
        DynamicObject mem = (DynamicObject)this.getModel().getValue(dimName.toLowerCase(Locale.ENGLISH));
        sql.addFilter(dimName, new String[]{mem.getString("number")});
        return mem;
    }

    private void insertSpaceRow(int rowNumber, int insertCount, Sheet sheet) {
        LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>(16);
        map.put("status", Boolean.valueOf(true));
        ArrayList<Integer> insertRowNumbers = new ArrayList<Integer>(insertCount);
        int insertRowNumber = rowNumber + 1;
        for (int j = 0; j < insertCount; ++j) {
            insertRowNumbers.add(insertRowNumber);
            sheet.insertRow(insertRowNumber);
        }
        map.put("data", insertRowNumbers);
        SpreadClientInvoker.invokeInsertRow(this.getClientViewProxy(), spreadKey, map);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initSpreadListener();
    }

    private void initSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.CELL_SELECT, e -> {
            SpreadPostDataInfo selectCell = (SpreadPostDataInfo)e.getSource();
            SearchHelper.setObjectCache(this.getView(), "cellSelectRow", selectCell.getSelRows().size());
        });
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, e -> {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8ffd\u6eaf\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"DataTracePlugin_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        });
    }

    private DynamicObjectCollection getEffectiveOrg(int rowNumber, Cell cell, Sheet sheet, Map<String, Integer> columnIndexMap, String isNeedChildData) {
        ArrayList<String> yearList = new ArrayList<String>(10);
        ArrayList<String> periodList = new ArrayList<String>(10);
        ArrayList<Long> yearIdList = new ArrayList<Long>(10);
        ArrayList<Long> periodIdList = new ArrayList<Long>(10);
        this.buildYearOrPeriodInfoList(yearList, yearIdList, "year");
        this.buildYearOrPeriodInfoList(periodList, periodIdList, "period");
        DynamicObject scen = (DynamicObject)this.getValue("scenario");
        Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
        String mergeOrgNum = orgCell.getUserObject("number").toString();
        Set noMergeOrgNumSet = MergeControlHelper.getNoMergeByNumber((Long)((Long)this.getFormCustomParam("model")), (Long)scen.getLong("id"), (Long)((Long)yearIdList.get(0)), (Long)((Long)periodIdList.get(0)));
        DynamicObjectCollection orgCols = this.getBasicDimSon("Entity", sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue()).getUserObject("id").toString(), isNeedChildData);
        DynamicObjectCollection orgSonList = new DynamicObjectCollection();
        for (DynamicObject org : orgCols) {
            if (noMergeOrgNumSet.contains(mergeOrgNum + "!" + org.getString("number"))) continue;
            orgSonList.add((Object)org);
        }
        return this.filterByOrgVersion(orgSonList);
    }

    private DynamicObjectCollection filterByOrgVersion(DynamicObjectCollection dynamicObjects) {
        Long modelId = ConvertUtil.convertObjToLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        DynamicObject yearDy = (DynamicObject)this.getModel().getValue("year");
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
        DynamicObject sceneDy = (DynamicObject)this.getModel().getValue("scenario");
        String yearNumber = yearDy.getString("number");
        long periodId = periodDy.getLong("id");
        long sceneId = sceneDy.getLong("id");
        FilterOrgStructParam param = new FilterOrgStructParam(modelId.longValue(), sceneId, yearNumber, periodId);
        ArrayList orgList = new ArrayList(dynamicObjects.size());
        dynamicObjects.forEach(org -> orgList.add(org));
        EntityVersioningUtil.filterOrgsByMergeStruct((FilterOrgStructParam)param, orgList);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(orgList);
        return collection;
    }

    private void buildYearOrPeriodInfoList(List<String> list, List<Long> memIdList, String dimNum) {
        DynamicObject obj = (DynamicObject)this.getValue(dimNum);
        String number = obj.getString("number");
        if ("year".equals(dimNum) && (number.startsWith("FY") || number.startsWith("Year")) || "period".equals(dimNum)) {
            list.add(number);
            memIdList.add(obj.getLong("id"));
        }
    }

    private boolean isEntryAdjusted(String number) {
        QFilter qFilter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
        qFilter.and("number", "=", (Object)number);
        DynamicObject auditTrailObject = BusinessDataServiceHelper.loadSingleFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)"AuditTrail"), (String)"datasource", (QFilter[])new QFilter[]{qFilter});
        String datasource = auditTrailObject.getString("datasource");
        return "3".equals(datasource);
    }

    private DynamicObjectCollection getAuditTrailCol(DynamicObjectCollection col) {
        ArrayList<Long> atIds = new ArrayList<Long>(10);
        for (DynamicObject at : col) {
            Long id = at.getLong("id");
            atIds.add(id);
        }
        QFilter qFilter = new QFilter("model", "=", this.getView().getFormShowParameter().getCustomParam("model"));
        qFilter.and("id", "in", atIds);
        qFilter.and("aggoprt", "=", (Object)"5");
        Map col1 = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)"AuditTrail"), (String)"id,longnumber", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection colDelete = new DynamicObjectCollection();
        for (DynamicObject at : col) {
            String id = at.getString("id");
            String longNumber = at.getString("longnumber");
            for (DynamicObject dt1 : col1.values()) {
                String id1 = dt1.getString("id");
                String longNumber1 = dt1.getString("longnumber") + "!";
                if (!id.equals(id1) && !longNumber.startsWith(longNumber1)) continue;
                colDelete.add((Object)at);
            }
        }
        col.removeAll((Collection)colDelete);
        return col;
    }

    private Pair<Integer, String> dealNewRowUnfoldByOrg(int rowNumber, int colNumber, Sheet sheet, Long modelId, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, Cell clickCell, String clickDimNumber, Map<String, String> orgCurrencyMap, BaseConvertFormula convertFormula, Map<String, List<String>> unfoldMap) {
        String unfoledDim = clickDimNumber;
        boolean isEntity = "Entity".equalsIgnoreCase(clickDimNumber);
        Cell unfoledCell = clickCell;
        DynamicObjectCollection lookupOrgs = null;
        DynamicObjectCollection extendsOrgs = new DynamicObjectCollection();
        Cell fMoney = sheet.getCell(rowNumber, columnIndexMap.get("fMoney").intValue());
        Boolean money = DataTraceHelper.checkZero(fMoney.getValue());
        Cell processCell = sheet.getCell(rowNumber, columnIndexMap.get("Process").intValue());
        Cell currencyCell = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue());
        Cell auditTrailCell = new Cell();
        if (columnIndexMap.containsKey("AuditTrail")) {
            auditTrailCell = sheet.getCell(rowNumber, columnIndexMap.get("AuditTrail").intValue());
        }
        HashMap<String, DynamicObject> orgDimMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, HashMap<String, String>> auditOrEcChildren = null;
        QFilter qFilter = new QFilter("id", "=", sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue()).getUserObject("id"));
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)"Entity"), (String)"id,name,number,isleaf,level,longnumber,parent.number,parent.longnumber,currency,model", (QFilter[])new QFilter[]{qFilter});
        orgDimMap.put(currentOrg.getString("number"), currentOrg);
        Boolean flag = money != false && Objects.nonNull(auditTrailCell) && Objects.equals("ATTotal", auditTrailCell.getUserObject("number"));
        DynamicObjectCollection nextChildrenforAudittail = this.getSonInfo(sheet, modelId, auditTrailCell, "AuditTrail", columnIndexMap, unfoldMap, orgCurrencyMap, false, flag);
        DynamicObjectCollection nextProcess = this.getSonInfo(sheet, modelId, processCell, "Process", columnIndexMap, unfoldMap, orgCurrencyMap, false, flag);
        if ("Entity".equalsIgnoreCase(clickDimNumber)) {
            if (processCell.getUserObject("isleaf") == null || flag.booleanValue()) {
                unfoledDim = "Process";
                unfoledCell = processCell;
            } else if (DataTraceHelper.getProcessForUnfold(sheet, rowNumber, unfoldMap, columnIndexMap, flag) != null) {
                unfoledDim = "Process";
                unfoledCell = processCell;
            } else if (auditTrailCell.getUserObject("isleaf") == null) {
                unfoledDim = "AuditTrail";
                unfoledCell = auditTrailCell;
            } else {
                clickCell.setUserObject("openCount", (Object)0);
                return Pair.onePair((Object)0, (Object)"");
            }
        }
        colNumber = columnIndexMap.get(unfoledDim);
        DynamicObject atTotalObj = this.getSingleDynamicObject("AuditTrail", "ATTotal");
        DynamicObject erptObj = this.getSingleDynamicObject("Process", "ERpt");
        DynamicObjectCollection sonInfo = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, money, flag);
        DynamicObjectCollection nextChildren = new DynamicObjectCollection();
        if (Objects.equals(money, true)) {
            nextChildren = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, null, flag);
        } else {
            nextChildren.addAll((Collection)sonInfo);
        }
        sonInfo = this.filterEffectiveMember(unfoledDim, sonInfo);
        if ((sonInfo == null || sonInfo.isEmpty()) && !"InternalCompany".equals(clickDimNumber)) {
            unfoledDim = "AuditTrail";
            unfoledCell = auditTrailCell;
            sonInfo = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, money, flag);
            sonInfo = this.filterEffectiveMember(unfoledDim, sonInfo);
            nextChildren = this.getSonInfo(sheet, modelId, unfoledCell, unfoledDim, columnIndexMap, unfoldMap, orgCurrencyMap, null, flag);
            colNumber = columnIndexMap.get(unfoledDim);
        }
        nextChildren = this.filterEffectiveMember(unfoledDim, nextChildren);
        if (sonInfo == null || sonInfo.isEmpty()) {
            clickCell.setUserObject("openCount", (Object)0);
            return Pair.onePair((Object)0, (Object)"");
        }
        String currency = sheet.getCell(rowNumber, columnIndexMap.get("Currency").intValue()).getUserObject("number").toString();
        if (money.booleanValue()) {
            lookupOrgs = this.getEffectiveOrg(rowNumber, clickCell, sheet, columnIndexMap, currentOrg.getString("longnumber"));
            lookupOrgs.add((Object)currentOrg);
        }
        boolean isUnfoldDimOrg = false;
        if ("Process".equalsIgnoreCase(unfoledDim) && DataTraceHelper.isCanUnfoldProcessEC(sheet, rowNumber, columnIndexMap, unfoldMap)) {
            isUnfoldDimOrg = true;
            Cell orgCell = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue());
            extendsOrgs = this.getEffectiveOrg(rowNumber, orgCell, sheet, columnIndexMap, null);
            if (extendsOrgs.isEmpty() || this.isDifModel().booleanValue()) {
                extendsOrgs.add((Object)currentOrg);
            }
        } else {
            extendsOrgs.add((Object)currentOrg);
        }
        this.buildSonNode(Objects.nonNull(lookupOrgs) ? lookupOrgs : extendsOrgs, orgDimMap);
        MDResultSet set = this.getDataFromOLAP(sheet, rowNumber, colNumber, sonInfo, columnIndexMap, Objects.nonNull(lookupOrgs) ? lookupOrgs : extendsOrgs, unfoldMap, atTotalObj, unfoledDim, convertFormula, orgCurrencyMap, erptObj, money);
        if (money.booleanValue() && Objects.nonNull(auditOrEcChildren = this.isAuditChidData(isUnfoldDimOrg, set, extendsOrgs, orgDimMap, unfoledDim, nextChildren, processCell.getUserObject("number").toString(), currencyCell.getUserObject("number").toString(), unfoldMap, columnIndexMap, auditTrailCell, modelId, flag, nextChildrenforAudittail, sheet, rowNumber)) && auditOrEcChildren.keySet().contains("AuditTrail")) {
            clickDimNumber = "AuditTrail";
            unfoledDim = "AuditTrail";
            unfoledCell = auditTrailCell;
            sonInfo = nextChildrenforAudittail;
            colNumber = columnIndexMap.get("AuditTrail");
        }
        Boolean specialScenes = !(!Objects.equals(clickDimNumber, "Process") && !Objects.equals(clickDimNumber, "Currency") && !Objects.equals(clickDimNumber, "Entity") || !DataTraceHelper.isIRptEC(sheet, rowNumber, columnIndexMap, unfoldMap) && !DataTraceHelper.needChangeAudiForIRptNotEC(sheet, rowNumber, columnIndexMap, orgCurrencyMap, convertFormula));
        if (this.isDifModel().booleanValue() && this.needChangeSon(sheet, rowNumber, columnIndexMap, orgCurrencyMap) && ("Entity".equals(clickDimNumber) || "Process".equals(clickDimNumber))) {
            DynamicObjectCollection erpt = new DynamicObjectCollection();
            erpt.add((Object)erptObj);
            nextChildren = erpt;
        }
        List<Map<String, Object>> realList = this.getRealListUnfoldByOrg(unfoledDim, set, extendsOrgs, nextChildren, isUnfoldDimOrg, money, auditOrEcChildren, currentOrg, currency, clickDimNumber, processCell.getUserObject("number").toString(), nextChildrenforAudittail, nextProcess, auditTrailCell, specialScenes);
        if ((realList = this.filterRealList(realList, unfoledDim, columnIndexMap, sheet, unfoledCell, unfoldMap, money, rowNumber, orgCurrencyMap)).isEmpty()) {
            clickCell.setUserObject("openCount", (Object)0);
            return Pair.onePair((Object)0, (Object)"");
        }
        this.filterNoPermData(modelId, realList);
        if (realList.isEmpty()) {
            clickCell.setUserObject("openCount", (Object)0);
            return Pair.onePair((Object)0, (Object)ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u6743\u9650\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u5f00\u3002", (String)"DataTracePlugin_26", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        int insertRowCount = realList.size();
        this.insertSpaceRow(rowNumber, insertRowCount, sheet);
        HashMap<String, DynamicObject> sonDimMap = new HashMap<String, DynamicObject>(16);
        if (this.isDifModel().booleanValue() && this.needChangeSon(sheet, rowNumber, columnIndexMap, orgCurrencyMap) && ("Entity".equals(clickDimNumber) || "Process".equals(clickDimNumber))) {
            DynamicObjectCollection erpt = new DynamicObjectCollection();
            erpt.add((Object)erptObj);
            sonInfo = erpt;
        }
        this.buildSonNode(sonInfo, sonDimMap);
        HashSet<Integer> hyperlinkSet = new HashSet<Integer>(16);
        int insertRowNum = rowNumber + 1;
        HashMap<Integer, Map<String, String>> insertDimMember = new HashMap<Integer, Map<String, String>>();
        for (Map<String, Object> row : realList) {
            Object value = row.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (value == null) continue;
            this.buildSingleNewRow(rowNumber, colNumber, sheet, cellValues, sonDimMap, columnIndexMap, insertRowNum, row, atTotalObj, unfoledDim, unfoldMap, orgDimMap, orgCurrencyMap, convertFormula, erptObj, insertDimMember);
            SearchHelper.clearCellsStyle(this.getClientViewProxy(), spreadKey, insertRowNum, columnIndexMap.get("fMoney"), 1, 1);
            if (this.isDifModel().booleanValue()) {
                SearchHelper.setCellFontColor(this.getClientViewProxy(), spreadKey, insertRowNum, 0, 1, sheet.getMaxColumnCount(), "#000000");
            }
            this.dealSpecialCell(sheet, cellValues, columnIndexMap, insertRowNum, hyperlinkSet);
            ++insertRowNum;
        }
        if (this.isShowDataSourceTag()) {
            this.setCornerMark2FMoney(sheet, rowNumber, insertDimMember, columnIndexMap);
        }
        String expandNumber = sheet.getCell(rowNumber, colNumber).getUserObject("number").toString();
        Set<Integer> rows = this.getIgnoreAggRow(isEntity, insertDimMember, modelId, unfoledDim, expandNumber, rowNumber, sheet, columnIndexMap);
        clickCell.setUserObject("openCount", (Object)insertRowCount);
        this.addPlusClickCell(sheet, cellValues, columnIndexMap, SearchHelper.getCurrencyByOrg(sheet, 0L, modelId), rowNumber + 1, rowNumber + 1 + insertRowCount, unfoldMap, convertFormula);
        this.dealti(sheet, cellValues, columnIndexMap, rowNumber + 1, rowNumber + 1 + insertRowCount);
        this.afterAddNewRows(sheet, rowNumber, clickCell, cellValues, columnIndexMap, insertRowCount, hyperlinkSet, rows);
        return Pair.onePair((Object)insertRowCount, (Object)"");
    }

    private List<Tuple<String, Integer, Integer>> getAttachmentMarkList(Sheet sheet, int rowNumber, Map<Integer, Map<String, String>> insertDimMember, Map<String, Integer> columnIndexMap) {
        ArrayList<Tuple<String, Integer, Integer>> cornerList = new ArrayList<Tuple<String, Integer, Integer>>(8);
        HashSet<String> insertDimSet = new HashSet<String>(8);
        HashMap<String, Set<String>> unfoldDimMap = this.unfoldDimMap(sheet, rowNumber, insertDimMember, columnIndexMap, insertDimSet);
        MDResultSet olapData = DataTracePlugin.queryOlap(MemberReader.findModelNumberById((Object)this.getModelId()), insertDimSet, unfoldDimMap);
        HashMap<String, String> olapMap = new HashMap<String, String>(8);
        while (olapData.next()) {
            StringBuilder key = new StringBuilder();
            for (String dim : insertDimSet) {
                key.append(dim).append(olapData.getString(dim));
            }
            olapMap.put(key.toString(), olapData.getString(FacTabFieldDefEnum.FIELD_SOURCE.getField()));
        }
        if (olapMap.size() > 0) {
            insertDimMember.forEach((index, dimMap) -> {
                Map value = dimMap;
                StringBuilder key = new StringBuilder();
                StringBuilder parentKey = new StringBuilder();
                value.forEach((dim, member) -> {
                    Object id;
                    if (DimTypesEnum.PROCESS.getNumber().equals(dim)) {
                        if ("EIRpt".equals(member)) {
                            member = "IRpt";
                        } else if ("ERAdj".equals(member)) {
                            member = "RAdj";
                        }
                    }
                    key.append((String)dim).append((String)member);
                    if (DimTypesEnum.ENTITY.getNumber().equals(dim) && (id = sheet.getCell(rowNumber, ((Integer)columnIndexMap.get("Entity")).intValue()).getUserObject().get((Object)"id")) != null) {
                        IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)Long.parseLong(id.toString()));
                        member = entityNode.getParent_SonNumber();
                    }
                    parentKey.append((String)dim).append((String)member);
                });
                if (olapMap.get(key.toString()) != null) {
                    Long source = Long.parseLong((String)olapMap.get(key.toString()));
                    cornerList.add(Tuple.create((Object)OlapSourceEnum.getNumber((Object)source), (Object)index, columnIndexMap.get("fMoney")));
                } else if (olapMap.get(parentKey.toString()) != null) {
                    Long source = Long.parseLong((String)olapMap.get(parentKey.toString()));
                    cornerList.add(Tuple.create((Object)OlapSourceEnum.getNumber((Object)source), (Object)index, columnIndexMap.get("fMoney")));
                }
            });
        }
        return cornerList;
    }

    private HashMap<String, Set<String>> unfoldDimMap(Sheet sheet, int rowNumber, Map<Integer, Map<String, String>> insertDimMember, Map<String, Integer> columnIndexMap, Set<String> insertDimSet) {
        LinkedHashMap<String, Set<String>> unfoldDimMap = new LinkedHashMap<String, Set<String>>();
        HashSet<String> dimMaps = new HashSet<String>(columnIndexMap.keySet());
        dimMaps.remove("rMoney");
        dimMaps.remove("fMoney");
        insertDimMember.forEach((k, v) -> v.forEach((key, value) -> {
            insertDimSet.add((String)key);
            dimMaps.remove(key);
            if (!unfoldDimMap.containsKey(key)) {
                HashSet<String> unfoldValue = new HashSet<String>();
                unfoldValue.add((String)value);
                unfoldDimMap.put((String)key, (Set<String>)unfoldValue);
            } else {
                Set unfoldValue = (Set)unfoldDimMap.get(key);
                unfoldValue.add(value);
                unfoldDimMap.put((String)key, unfoldValue);
            }
        }));
        dimMaps.forEach(dim -> {
            int index = (Integer)columnIndexMap.get(dim);
            String member = sheet.getCell(rowNumber + 1, index).getUserObject("number").toString();
            HashSet<String> unfoldValue = new HashSet<String>();
            unfoldValue.add(member);
            if (!unfoldDimMap.containsKey(dim)) {
                unfoldDimMap.put((String)dim, (Set<String>)unfoldValue);
            }
        });
        Object id = sheet.getCell(rowNumber, columnIndexMap.get("Entity").intValue()).getUserObject().get((Object)"id");
        if (id != null) {
            IDNumberTreeNode entityNode = MemberReader.findEntityMemberById((Long)this.getModelId(), (Long)Long.parseLong(id.toString()));
            Set entity = (Set)((HashMap)unfoldDimMap).get("Entity");
            entity.add(entityNode.getParent_SonNumber());
            unfoldDimMap.replace("Entity", entity);
        }
        HashSet<String> yearSet = new HashSet<String>(1);
        yearSet.add(MemberReader.findFyMemberById((Long)this.getModelId(), (Long)((Long)this.getFormCustomParam("year"))).getNumber());
        unfoldDimMap.put(DimTypesEnum.YEAR.getNumber(), yearSet);
        HashSet<String> periodSet = new HashSet<String>(1);
        periodSet.add(MemberReader.findPeriodMemberById((Long)this.getModelId(), (Long)((Long)this.getFormCustomParam("period"))).getNumber());
        unfoldDimMap.put(DimTypesEnum.PERIOD.getNumber(), periodSet);
        HashSet<String> scenarioSet = new HashSet<String>(1);
        scenarioSet.add(MemberReader.findScenaMemberById((Long)this.getModelId(), (Long)((Long)this.getFormCustomParam("scenario"))).getNumber());
        unfoldDimMap.put(DimTypesEnum.SCENARIO.getNumber(), scenarioSet);
        return unfoldDimMap;
    }

    private static MDResultSet queryOlap(String modelNum, Set<String> allDims, Map<String, Set<String>> filter) {
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()});
        sql.addSelectField(allDims.toArray(new String[0]));
        filter.forEach((k, v) -> {
            HashSet set = new HashSet(v);
            if (set.size() > 0) {
                sql.addFilter(k, set.toArray(new String[0]));
            }
        });
        DataTracePlugin.changeSQLBuilder(sql);
        return OlapServiceHelper.queryData((SQLBuilder)sql);
    }

    private void setCornerMark2FMoney(Sheet sheet, int rowNumber, Map<Integer, Map<String, String>> insertDimMember, Map<String, Integer> columnIndexMap) {
        List<Tuple<String, Integer, Integer>> cornerList = this.getAttachmentMarkList(sheet, rowNumber, insertDimMember, columnIndexMap);
        cornerList.forEach(t -> this.setAttachmentMark((String)t.p1, (Integer)t.p2, (Integer)t.p3, 1, 1));
    }

    private void dealti(Sheet sheet, List<Map<String, Object>> cellValues, Map<String, Integer> columnIndexMap, int beginRow, int endRow) {
        for (int i = beginRow; i < endRow; ++i) {
            Cell orgCell = sheet.getCell(i, columnIndexMap.get("Entity").intValue());
            if (this.isDifModel().booleanValue() && endRow - beginRow > 1 && this.plusSingInExpNode(sheet, columnIndexMap, beginRow, endRow)) {
                String displayContent = orgCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
                if (beginRow > 1 && !displayContent.startsWith(EXPAND_PLUS) && !displayContent.startsWith(EXPAND_SUB)) {
                    displayContent = PEER_ALIGNMENT + displayContent;
                    orgCell.setValue((Object)displayContent);
                    cellValues.add(this.packedUpdateCellMap(i, columnIndexMap.get("Entity"), displayContent));
                }
            }
            if (beginRow <= 1) continue;
            for (int j = 0; j < columnIndexMap.size(); ++j) {
                int fMoneyIndex = columnIndexMap.get("fMoney");
                int rMoneyIndex = columnIndexMap.get("rMoney");
                if (j == fMoneyIndex || j == rMoneyIndex) continue;
                Cell cell = sheet.getCell(i, j);
                Cell parentCell = sheet.getCell(beginRow - 1, j);
                this.needAddBreak(cell, parentCell);
            }
        }
    }

    private boolean plusSingInExpNode(Sheet sheet, Map<String, Integer> columnIndexMap, int beginRow, int endRow) {
        for (int i = beginRow; i < endRow; ++i) {
            Cell orgCell = sheet.getCell(i, columnIndexMap.get("Entity").intValue());
            String displayContent = orgCell.getValue().toString().replaceAll("^[\u3000 ]+", "");
            if (!displayContent.startsWith(EXPAND_PLUS) && !displayContent.startsWith(EXPAND_SUB)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<Map<String, Object>> filterRealList(List<Map<String, Object>> realList, String unfoldDimNumber, Map<String, Integer> columnIndexMap, Sheet sheet, Cell unfoldCell, Map<String, List<String>> unfoldMap, Boolean money, int rowNumber, Map<String, String> orgCurrencyMap) {
        if (realList == null || realList.isEmpty()) {
            return realList;
        }
        Iterator<Map<String, Object>> it = realList.iterator();
        while (it.hasNext()) {
            Map<String, Object> rowData = it.next();
            if (rowData.get(FacTabFieldDefEnum.FIELD_MONEY.getField()) != BigDecimal.ZERO || money.booleanValue() || !this.isNotNormalData(rowData, unfoldDimNumber, columnIndexMap, sheet, unfoldCell.getRow(), unfoldMap)) continue;
            it.remove();
        }
        if (this.isDifModel().booleanValue() && Objects.equals(unfoldDimNumber, "Process")) {
            Optional<Map> org;
            Cell orgCell = sheet.getCell(unfoldCell.getRow(), columnIndexMap.get("Entity").intValue());
            ArrayList<Map<String, Object>> sortedList = new ArrayList<Map<String, Object>>(realList.size());
            Optional<Map> currentOrg = realList.stream().filter(s -> Objects.equals(orgCell.getUserObject("number"), s.get("Entity")) && Objects.equals(s.get("Process"), "DIF")).findFirst();
            if (currentOrg.isPresent()) {
                sortedList.add(currentOrg.get());
            }
            if (this.needChangeSon(sheet, rowNumber, columnIndexMap, orgCurrencyMap) && (org = realList.stream().filter(s -> Objects.equals(orgCell.getUserObject("number"), s.get("Entity")) && Objects.equals(s.get("Process"), "ERpt")).findFirst()).isPresent()) {
                sortedList.add(org.get());
            }
            Map<String, List<Map>> childrenOrg = realList.stream().filter(s -> !Objects.equals(orgCell.getUserObject("number"), s.get("Entity")) && !Objects.equals(s.get("Process"), "DIF")).collect(Collectors.groupingBy(s -> s.get("Entity").toString()));
            childrenOrg.forEach((k, v) -> {
                Optional<Map> rptData = v.stream().filter(s -> Objects.equals(s.get("Process"), "Rpt")).findFirst();
                Optional<Map> erptData = v.stream().filter(s -> Objects.equals(s.get("Process"), "ERpt")).findFirst();
                String rptCurrency = "";
                String erptCurrency = "";
                if (rptData.isPresent()) {
                    rptCurrency = rptData.get().get("Currency").toString();
                }
                if (erptData.isPresent()) {
                    erptCurrency = erptData.get().get("Currency").toString();
                }
                if (rptData.isPresent() && !Objects.equals(rptCurrency, erptCurrency)) {
                    sortedList.add(rptData.get());
                }
                if (erptData.isPresent()) {
                    sortedList.add(erptData.get());
                }
            });
            realList = sortedList;
        }
        return realList;
    }

    private void filterNoPermData(Long modelId, List<Map<String, Object>> realList) {
        HashMap dim2Nums = new HashMap(4);
        Map dims = MemberReader.getDimDyoByModelId((long)modelId);
        realList.forEach(row -> row.forEach((k, v) -> {
            if (dims.containsKey(k)) {
                Set orDefault = dim2Nums.getOrDefault(k, new HashSet(2));
                orDefault.add(v.toString());
                dim2Nums.put(k, orDefault);
            }
        }));
        boolean containNoPerm = dim2Nums.entrySet().stream().anyMatch(e -> {
            Set noPermMembers = PermissionServiceImpl.getInstance((Long)modelId).matchNoPermMembersByNum(Long.valueOf(((DynamicObject)dims.get(e.getKey())).getLong("id")), ((DynamicObject)dims.get(e.getKey())).getString("membermodel"), (Collection)e.getValue());
            return !noPermMembers.isEmpty();
        });
        if (containNoPerm) {
            realList.clear();
        }
    }

    private boolean isNotNormalData(Map<String, Object> rowData, String clickDimNumber, Map<String, Integer> columnIndexMap, Sheet sheet, int row, Map<String, List<String>> unfoldMap) {
        if (this.isProcessOrAuditTrailUnfold(clickDimNumber)) {
            String processDim = rowData.get("Process") != null ? rowData.get("Process").toString() : String.valueOf(sheet.getCell(row, columnIndexMap.get("Process").intValue()).getUserObject("number"));
            String auditDim = rowData.get("AuditTrail") != null ? rowData.get("AuditTrail").toString() : String.valueOf(sheet.getCell(row, columnIndexMap.get("AuditTrail").intValue()).getUserObject("number"));
            return DataTraceHelper.isLeafNodeData(processDim, auditDim, this.getModelId());
        }
        if ("Currency".equalsIgnoreCase(clickDimNumber)) {
            return false;
        }
        boolean isleaf = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)this.getModelId()), (String)clickDimNumber, (String)String.valueOf(rowData.get(clickDimNumber))).isLeaf();
        Cell processCell = sheet.getCell(row, columnIndexMap.get("Process").intValue());
        Cell auditCell = sheet.getCell(row, columnIndexMap.get("AuditTrail").intValue());
        return isleaf && auditCell.getUserObject("isleaf") != null && processCell.getUserObject("isleaf") != null;
    }

    private List<Map<String, Object>> getRealListUnfoldByOrg(String clickDimNumber, MDResultSet set, DynamicObjectCollection currentOrgs, DynamicObjectCollection sonInfo, boolean isUnfoldDimOrg, boolean money, HashMap<String, HashMap<String, String>> auditOrEcChildren, DynamicObject currentOrg, String currency, String realclickDimNumber, String processnumber, DynamicObjectCollection nextChildrenforAudittail, DynamicObjectCollection nextprocess, Cell auditTrailCell, Boolean specialScenes) {
        Set extendDims = sonInfo.parallelStream().map(s -> s.getString("number")).collect(Collectors.toSet());
        List<Object> effectList = new ArrayList(0);
        if (set != null && set.getFetchSize() != 0) {
            effectList = this.getEffectOLAPResultList(clickDimNumber, set, currentOrgs);
        }
        LinkedList<Map<String, Object>> realList = new LinkedList<Map<String, Object>>();
        LinkedList needAddList = new LinkedList();
        Map<String, Row> rowMap = null;
        String realCurrency = currency;
        boolean iscontainson = (Boolean)this.getModel().getValue("iscontainson");
        Row exist = effectList.stream().filter(row -> row.getString("Currency").equals(currency)).findAny().orElse(null);
        if (money && effectList.isEmpty()) {
            if (Objects.nonNull(auditOrEcChildren) && auditOrEcChildren.size() > 0) {
                if (isUnfoldDimOrg) {
                    for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                        HashMap<String, String> values = entry.getValue();
                        for (Map.Entry<String, String> entry2 : values.entrySet()) {
                            HashMap<String, Object> tempRow = new HashMap<String, Object>(4);
                            tempRow.put(entry.getKey(), entry2.getValue());
                            tempRow.put(DimTypesEnum.ENTITY.getNumber(), entry2.getKey());
                            tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            realList.add(tempRow);
                        }
                    }
                    return realList;
                }
                for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                    HashMap<String, String> values = entry.getValue();
                    for (Map.Entry<String, String> entry3 : values.entrySet()) {
                        HashMap<String, Object> tempRow = new HashMap<String, Object>(4);
                        tempRow.put(entry.getKey(), entry3.getKey());
                        tempRow.put(DimTypesEnum.ENTITY.getNumber(), currentOrg.getString("number"));
                        tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                        realList.add(tempRow);
                    }
                }
                return realList;
            }
        } else if (money && !effectList.isEmpty()) {
            effectList = effectList.parallelStream().filter(row -> sonInfo.parallelStream().map(s -> s.getString("number")).collect(Collectors.toList()).contains(row.getString(clickDimNumber))).collect(Collectors.toList());
            effectList = this.generateResult(effectList, clickDimNumber, sonInfo, auditTrailCell, processnumber, specialScenes);
            if (auditOrEcChildren != null && !auditOrEcChildren.isEmpty()) {
                Map.Entry<String, HashMap<String, String>> entry = auditOrEcChildren.entrySet().iterator().next();
                String process = entry.getKey();
                Map childrenMap = entry.getValue();
                if (childrenMap != null) {
                    for (Row row2 : effectList) {
                        String exitValue = row2.getString(process);
                        childrenMap.remove(exitValue);
                    }
                }
            }
            if (Objects.nonNull(auditOrEcChildren) && auditOrEcChildren.size() > 0 && Boolean.TRUE.equals(specialScenes)) {
                HashMap<String, Object> tempRow;
                HashMap<String, String> values;
                if (isUnfoldDimOrg) {
                    for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                        values = entry.getValue();
                        for (Map.Entry entry4 : values.entrySet()) {
                            tempRow = new HashMap<String, Object>(4);
                            tempRow.put(entry.getKey(), entry4.getValue());
                            tempRow.put(DimTypesEnum.ENTITY.getNumber(), entry4.getKey());
                            tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            needAddList.add(tempRow);
                        }
                    }
                } else {
                    for (Map.Entry<String, HashMap<String, String>> entry : auditOrEcChildren.entrySet()) {
                        values = entry.getValue();
                        for (Map.Entry entry5 : values.entrySet()) {
                            tempRow = new HashMap(4);
                            tempRow.put(entry.getKey(), entry5.getKey());
                            tempRow.put(DimTypesEnum.ENTITY.getNumber(), currentOrg.getString("number"));
                            tempRow.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            needAddList.add(tempRow);
                        }
                    }
                }
            }
        }
        rowMap = this.getRowMap(isUnfoldDimOrg, effectList, clickDimNumber);
        if (isUnfoldDimOrg) {
            for (DynamicObject son : sonInfo) {
                for (DynamicObject org : currentOrgs) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    String sonNumber = son.getString("number");
                    String orgNumber = org.getString("number");
                    String number = sonNumber + "_" + orgNumber;
                    if (this.isDifModel().booleanValue()) {
                        if (Objects.equals("ERpt", son.getString("number"))) {
                            realCurrency = org.getString("currency.number");
                            number = sonNumber + "_" + orgNumber + "_" + org.getString("currency.number");
                        } else {
                            number = sonNumber + "_" + orgNumber + "_" + currency;
                        }
                        hashMap.put("Currency", realCurrency);
                    }
                    hashMap.put(clickDimNumber, sonNumber);
                    hashMap.put("Entity", orgNumber);
                    if (rowMap.containsKey(number) && rowMap.get(number) != null) {
                        if (money) {
                            if (Objects.nonNull(exist) && !Objects.equals(realCurrency, rowMap.get(number).getString("Currency"))) continue;
                            if (!(Objects.nonNull(exist) || Objects.equals(realCurrency, rowMap.get(number).getString("Currency")) || Objects.equals(clickDimNumber, "Currency"))) {
                                hashMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                                hashMap.put("Currency", rowMap.get(number).getString("Currency"));
                            } else {
                                hashMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getOriginalValue("FMONEY") instanceof Long ? rowMap.get(number).getBigDecimal("FMONEY") : rowMap.get(number).getOriginalValue("FMONEY"));
                            }
                            if (!extendDims.contains(rowMap.get(number).getString(clickDimNumber))) {
                                hashMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            }
                        } else {
                            hashMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getOriginalValue("FMONEY") instanceof Long ? rowMap.get(number).getBigDecimal("FMONEY") : rowMap.get(number).getOriginalValue("FMONEY"));
                        }
                        realList.add(hashMap);
                        continue;
                    }
                    if (!iscontainson) continue;
                    hashMap.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                    realList.add(hashMap);
                }
            }
        } else {
            for (DynamicObject son : sonInfo) {
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                String number = son.getString("number");
                tmp.put(clickDimNumber, number);
                tmp.put("Entity", currentOrg.getString("number"));
                if (rowMap.containsKey(number) && rowMap.get(number) != null) {
                    if (money) {
                        if (Objects.nonNull(exist) && !Objects.equals(currency, rowMap.get(number).getString("Currency"))) {
                            tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            tmp.put("Currency", rowMap.get(number).getString("Currency"));
                        }
                        if (!(Objects.nonNull(exist) || Objects.equals(currency, rowMap.get(number).getString("Currency")) || Objects.equals(clickDimNumber, "Currency"))) {
                            tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                            tmp.put("Currency", rowMap.get(number).getString("Currency"));
                        } else {
                            tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getOriginalValue("FMONEY") instanceof Long ? rowMap.get(number).getBigDecimal("FMONEY") : rowMap.get(number).getOriginalValue("FMONEY"));
                        }
                        if (!extendDims.contains(rowMap.get(number).getString(clickDimNumber))) {
                            tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                        }
                    } else {
                        tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), rowMap.get(number).getOriginalValue("FMONEY") instanceof Long ? rowMap.get(number).getBigDecimal("FMONEY") : rowMap.get(number).getOriginalValue("FMONEY"));
                        if (this.isDifModel().booleanValue() && rowMap.get(number).getString("Currency") != null && !currency.equals(rowMap.get(number).getString("Currency"))) {
                            tmp.put("Currency", rowMap.get(number).getString("Currency"));
                        }
                    }
                    realList.add(tmp);
                    continue;
                }
                if (!iscontainson) continue;
                tmp.put(FacTabFieldDefEnum.FIELD_MONEY.getField(), BigDecimal.ZERO);
                realList.add(tmp);
            }
        }
        if (needAddList != null && !needAddList.isEmpty()) {
            realList.addAll(needAddList);
        }
        return realList;
    }

    private List<Row> generateResult(List<Row> effectList, String clickDimNumber, DynamicObjectCollection sonInfo, Cell auditTrailCell, String processnumber, Boolean specialScenes) {
        ArrayList<Row> result = new ArrayList<Row>(10);
        Set child = sonInfo.stream().map(s -> s.getString("number")).collect(Collectors.toSet());
        if (clickDimNumber.equals("Process")) {
            effectList.stream().forEach(s -> {
                if (Objects.nonNull(auditTrailCell)) {
                    String cAuditTrail = auditTrailCell.getUserObject("number").toString();
                    if (specialScenes.booleanValue()) {
                        cAuditTrail = "ATTotal";
                    }
                    if (child.contains(s.getString("Process")) && Objects.nonNull(auditTrailCell) && Objects.equals(s.getString("AuditTrail"), cAuditTrail)) {
                        result.add((Row)s);
                    }
                }
            });
            if (result.isEmpty()) {
                for (Row row : effectList) {
                    int auditTrailIndex = row.getColIndex("AuditTrail");
                    int fmoneyIndex = row.getColIndex("FMONEY");
                    row.replaceColumnValue(auditTrailIndex, auditTrailCell.getUserObject("number"));
                    row.replaceColumnValue(fmoneyIndex, (Object)new BigDecimal(0));
                    result.add(row);
                }
            }
        } else if (clickDimNumber.equals("AuditTrail")) {
            effectList.stream().forEach(s -> {
                if (child.contains(s.getString("AuditTrail")) && Objects.nonNull(processnumber) && Objects.equals(s.getString("Process"), processnumber)) {
                    result.add((Row)s);
                }
            });
            if (result.isEmpty()) {
                for (Row row : effectList) {
                    int processIndex = row.getColIndex("Process");
                    int fmoneyIndex = row.getColIndex("FMONEY");
                    row.replaceColumnValue(processIndex, (Object)processnumber);
                    row.replaceColumnValue(fmoneyIndex, (Object)new BigDecimal(0));
                    result.add(row);
                }
            }
        } else if (clickDimNumber.equals("Currency")) {
            effectList.stream().forEach(s -> {
                String processnum = processnumber;
                String cAuditTrail = "";
                if (Objects.nonNull(auditTrailCell)) {
                    cAuditTrail = auditTrailCell.getUserObject("number").toString();
                    if (specialScenes.booleanValue()) {
                        cAuditTrail = "ATTotal";
                        processnum = "ERpt";
                    }
                }
                if (child.contains(s.getString(clickDimNumber)) && Objects.nonNull(processnum) && Objects.equals(s.getString("Process"), processnum) && Objects.nonNull(auditTrailCell) && Objects.equals(s.getString("AuditTrail"), cAuditTrail)) {
                    result.add((Row)s);
                }
            });
        } else {
            effectList.stream().forEach(s -> {
                if (child.contains(s.getString(clickDimNumber)) && Objects.nonNull(processnumber) && Objects.equals(s.getString("Process"), processnumber) && Objects.nonNull(auditTrailCell) && Objects.equals(s.getString("AuditTrail"), auditTrailCell.getUserObject("number"))) {
                    result.add((Row)s);
                }
            });
        }
        return result;
    }

    private Map<String, Row> getRowMap(boolean isUnfoldDimOrg, List<Row> effectList, String clickDimNumber) {
        HashMap<String, Row> rowMap = new HashMap<String, Row>(16);
        for (Row row : effectList) {
            if (isUnfoldDimOrg) {
                String orgNumber = row.getString("Entity");
                if (orgNumber != null && orgNumber.split("_").length > 1) {
                    orgNumber = orgNumber.split("_")[1];
                }
                if (this.isDifModel().booleanValue()) {
                    String curNumber = row.getString("Currency");
                    rowMap.put(row.getString(clickDimNumber) + "_" + orgNumber + "_" + curNumber, row);
                    continue;
                }
                rowMap.put(row.getString(clickDimNumber) + "_" + orgNumber, row);
                continue;
            }
            rowMap.put(row.getString(clickDimNumber), row);
        }
        return rowMap;
    }

    private boolean isProcessOrAuditTrailUnfold(String clickDimNumber) {
        return "Process".equalsIgnoreCase(clickDimNumber) || "AuditTrail".equalsIgnoreCase(clickDimNumber);
    }

    private void linkData() {
        SpreadSelector selector = this.getSpreadSelector();
        if (selector.getStartCol() == selector.getEndCol() && selector.getStartRow() == selector.getEndRow()) {
            Sheet sheet = this.getEffectiveSheet();
            Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
            int fMoneyIndex = columnIndexMap.get("fMoney");
            int selectRow = selector.getStartRow();
            if (selectRow != 0 && selector.getStartCol() == fMoneyIndex) {
                Long modelID;
                String modelNum = ((DynamicObject)this.getModel().getValue("model")).getString("number");
                Map<String, String> memberMap = this.getSelectCellMemberMap("extdata");
                String dimStr = LinkExtDataUtil.getTotalDimStr(memberMap, modelID = MemberReader.findModelIdByNum((String)modelNum));
                if (LinkExtDataUtil.existExtData(dimStr, modelID)) {
                    FormShowParameter parameter = LinkExtDataUtil.getLinkExtDataParameter(modelID, memberMap, dimStr);
                    this.getView().showForm(parameter);
                    return;
                }
                memberMap = this.getSelectCellMemberMap(null);
                Set<String> dims = memberMap.keySet();
                Boolean isMMark = OlapUtil.getMMarkStatus(modelNum, dims, memberMap);
                if (!isMMark.booleanValue()) {
                    DataTrace2FromService service = new DataTrace2FromService(Long.valueOf(this.getModelId()), Long.valueOf(0L));
                    DataTraceFrom dtf = service.queryDataTraceFrom(memberMap);
                    if (dtf != null) {
                        if (DataTraceSourceEnum.DI_OUTPUT.getCode().equals(dtf.getF())) {
                            new LinkQueryService(this.getModelId(), this.getView()).linkDiByDataTrace(dtf, memberMap);
                        } else {
                            Map<String, Object> commonParamId = this.getCommonParamId(modelNum, memberMap);
                            String traceInfo = LinkQueryUtil.createDimMember(memberMap, (long)this.getModelId());
                            FormShowParameter parameter = LinkFormulaUtil.getLinkQueryParameter((String)JacksonUtils.toJson((Object)dtf), (String)memberMap.get("Entity"), (String)memberMap.get("Year"), (String)memberMap.get("Period"), commonParamId, (String)traceInfo);
                            this.getView().showForm(parameter);
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u8ffd\u6eaf\u4fe1\u606f\u3002", (String)"DataTracePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\u8ffd\u6eaf\u4fe1\u606f\u3002", (String)"DataTracePlugin_14", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u8ffd\u6eaf\u6570\u652f\u6301\u8054\u67e5\u3002", (String)"DataTracePlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u4e2a\u5355\u5143\u683c\u8054\u67e5\u3002", (String)"DataTracePlugin_17", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    public void linkDataSource() {
        Sheet sheet = this.getEffectiveSheet();
        SpreadSelector selector = this.getSpreadSelector();
        if (selector.getStartRow() != selector.getEndRow() || selector.getStartCol() != selector.getEndCol()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6570\u636e\u6765\u6e90\u4ec5\u652f\u6301\u5355\u4e00\u5355\u5143\u683c\u3002", (String)"LinkDataTracePlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Pair> map = new HashMap<String, Pair>(16);
        Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
        int fMoneyIndex = columnIndexMap.get("fMoney");
        int selectRow = selector.getStartRow();
        if (selectRow == 0 || selector.getStartCol() != fMoneyIndex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u591a\u7ef4\u6570\u636e\u5355\u5143\u683c\u540e\u518d\u8bd5\u3002", (String)"LinkDataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        int rMoneyIndex = columnIndexMap.get("rMoney");
        map.put("Year", Pair.onePair((Object)((DynamicObject)this.getModel().getValue("year")).getLong("id"), (Object)((DynamicObject)this.getModel().getValue("year")).getString("number")));
        map.put("Period", Pair.onePair((Object)((DynamicObject)this.getModel().getValue("period")).getLong("id"), (Object)((DynamicObject)this.getModel().getValue("period")).getString("number")));
        map.put("Scenario", Pair.onePair((Object)((DynamicObject)this.getModel().getValue("scenario")).getLong("id"), (Object)((DynamicObject)this.getModel().getValue("scenario")).getString("number")));
        sheet.iteratorRowRangeCells(selectRow, selectRow, c -> {
            int col = c.getCol();
            if (col != fMoneyIndex && col != rMoneyIndex) {
                String dimNum = sheet.getCell(0, col).getUserObject("number").toString();
                String memberNum = sheet.getCell(selectRow, col).getUserObject("number").toString();
                Long memberId = (Long)sheet.getCell(selectRow, col).getUserObject("id");
                map.put(dimNum, Pair.onePair((Object)memberId, (Object)memberNum));
            }
        });
        if (map.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u591a\u7ef4\u6570\u636e\u5355\u5143\u683c\u540e\u518d\u8bd5\u3002", (String)"LinkDataTracePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isDynamic = false;
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        for (Map.Entry entry : map.entrySet()) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)((String)entry.getKey()), (String)((String)((Pair)entry.getValue()).p2));
            if (node.getStorageType() != StorageTypeEnum.DYNAMIC) continue;
            isDynamic = true;
        }
        if (!isDynamic) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8054\u67e5\u660e\u7ec6\u6570\u636e\u6765\u6e90\u4ec5\u652f\u6301\u52a8\u6001\u8ba1\u7b97\u7684\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"LinkDataTracePlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("model", this.getModelId());
        params.put("redata", sheet.getCell(selector.getStartRow(), fMoneyIndex).getValue());
        params.putAll(map);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bcm_sourcedetail");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u8ffd\u6eaf\uff1a\u8054\u67e5\u660e\u7ec6\u6765\u6e90", (String)"DataTracePlugin_29", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }

    private Map<String, String> getSelectCellMemberMap(String linkData) {
        SpreadSelector selector = this.getSpreadSelector();
        HashMap<String, String> memberMap = new HashMap<String, String>();
        if (selector.getStartCol() == selector.getEndCol() && selector.getStartRow() == selector.getEndRow()) {
            Sheet sheet = this.getEffectiveSheet();
            Map<String, Integer> columnIndexMap = SearchHelper.createColumnIndex(sheet);
            int fMoneyIndex = columnIndexMap.get("fMoney");
            int rMoneyIndex = columnIndexMap.get("rMoney");
            int selectRow = selector.getStartRow();
            if (selectRow != 0 && selector.getStartCol() == fMoneyIndex) {
                memberMap.put("Year", ((DynamicObject)this.getModel().getValue("year")).getString("number"));
                memberMap.put("Period", ((DynamicObject)this.getModel().getValue("period")).getString("number"));
                memberMap.put("Scenario", ((DynamicObject)this.getModel().getValue("scenario")).getString("number"));
                sheet.iteratorRowRangeCells(selectRow, selectRow, c -> {
                    int col = c.getCol();
                    if (col != fMoneyIndex && col != rMoneyIndex) {
                        String dimNum = sheet.getCell(0, col).getUserObject("number").toString();
                        String memberNum = sheet.getCell(selectRow, col).getUserObject("number").toString();
                        memberMap.put(dimNum, memberNum);
                    }
                });
            }
            if ("extdata".equals(linkData) && LinkExtDataUtil.processByAdj.contains(memberMap.get("Process")) && selectRow != 0 && selector.getStartCol() == fMoneyIndex) {
                sheet.iteratorRowRangeCells(selectRow, selectRow, c -> {
                    String dimNum;
                    int col = c.getCol();
                    if (col != fMoneyIndex && col != rMoneyIndex && "Entity".equalsIgnoreCase(dimNum = sheet.getCell(0, col).getUserObject("number").toString())) {
                        String modelNum = ((DynamicObject)this.getModel().getValue("model")).getString("number");
                        Long modelID = MemberReader.findModelIdByNum((String)modelNum);
                        Long memberID = (Long)sheet.getCell(selectRow, col).getUserObject("id");
                        memberMap.put(dimNum, LinkExtDataUtil.parent2ChildEntity(modelID, memberID));
                    }
                });
            }
        }
        return memberMap;
    }

    private Map<String, Object> getCommonParamId(String modelNum, Map<String, String> memberMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("model", MemberReader.findModelIdByNum((String)modelNum));
        result.put(DimTypesEnum.ENTITY.getNumber(), MemberReader.findEntityMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.ENTITY.getNumber())).getId());
        result.put(DimTypesEnum.SCENARIO.getNumber(), MemberReader.findScenaMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.SCENARIO.getNumber())).getId());
        result.put(DimTypesEnum.YEAR.getNumber(), MemberReader.findFyMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.YEAR.getNumber())).getId());
        result.put(DimTypesEnum.PERIOD.getNumber(), MemberReader.findPeriodMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.PERIOD.getNumber())).getId());
        result.put(DimTypesEnum.CURRENCY.getNumber(), MemberReader.findCurrencyMemberByNum((String)modelNum, (String)memberMap.get(DimTypesEnum.CURRENCY.getNumber())).getId());
        result.put("memberMap", memberMap);
        return result;
    }

    private void linkIntegration() {
        Sheet sheet = this.getEffectiveSheet();
        List row = sheet.getRow(this.getSelectorStartRow());
        if (row == null || row.size() < 6) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u65e0\u6570\u636e\u3002", (String)"DataTracePlugin_21", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        List indRow = sheet.getRow(0);
        Map<Integer, String> memberLocation = this.getMemberLocation(indRow);
        Map commonMemberList = (Map)this.getView().getFormShowParameter().getCustomParam("commonMemberList");
        sheet.iteratorRangeCells(this.getSelectorStartRow(), this.getSelectorStartRow(), 0, sheet.getMaxColumnCount(), cell -> {
            String memberNumber = (String)memberLocation.get(cell.getCol());
            if (memberNumber == null) {
                return;
            }
            commonMemberList.put(memberNumber, this.getCellValue(cell.getValue()));
        });
        Long modelId = this.getModelId();
        QFilter filter = new QFilter("modelid", "=", (Object)modelId);
        HashMap resultMap = new HashMap(16);
        String view = HWModelParamUtil.getFirstCustomDimIsView((long)modelId);
        this.handleProcess(commonMemberList);
        commonMemberList.keySet().forEach(key -> {
            Object value = commonMemberList.get(key);
            String filedName = this.getComparisonField(view, (String)key);
            if (StringUtils.isNotEmpty((CharSequence)filedName)) {
                filter.and(new QFilter(filedName, "=", value));
                resultMap.put(filedName, value);
            }
        });
        if (!QueryServiceHelper.exists((String)"bcm_datacomparisontable", (QFilter[])filter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u7684\u6765\u6e90\u4e0d\u662f\u6570\u636e\u96c6\u6210\u3002", (String)"DataTracePlugin_22", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            log.debug("\u8054\u67e5\u96c6\u6210\u53c2\u6570\u5217\u8868 \uff1a " + ((Object)resultMap).toString());
            return;
        }
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("bcm_link_integration");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formparam.setCustomParam("modelId", (Object)modelId);
        formparam.setCustomParam("view", (Object)view);
        formparam.setCustomParam("resultMap", resultMap);
        this.getView().showForm(formparam);
    }

    private Map<Integer, String> getMemberLocation(List<Cell> row) {
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        row.forEach(cell -> {
            if (cell.getUserObject("number") != null && cell.getUserObject("dimId") != null) {
                map.put(cell.getCol(), cell.getUserObject("number").toString());
            }
        });
        return map;
    }

    private void handleProcess(Map<String, Object> map) {
        Object curValue = map.get(DimEntityNumEnum.PROCESS.getNumber());
        if (curValue != null && "EIRpt".equalsIgnoreCase(curValue.toString())) {
            map.put(DimEntityNumEnum.PROCESS.getNumber(), "IRpt");
        }
    }

    private String getComparisonField(String view, String key) {
        String result = null;
        switch (key) {
            case "Custom1": {
                result = "1".equals(view) ? "dim2" : "dim1";
                break;
            }
            case "Custom2": {
                result = "1".equals(view) ? "dim3" : "dim2";
                break;
            }
            case "Custom3": {
                result = "1".equals(view) ? "dim4" : "dim3";
                break;
            }
            case "Custom4": {
                result = "1".equals(view) ? "dim5" : "dim4";
                break;
            }
            case "Custom5": {
                result = "1".equals(view) ? "dim6" : "dim5";
                break;
            }
            case "Year": {
                result = "fy";
                break;
            }
            case "Entity": 
            case "InternalCompany": 
            case "Period": 
            case "Scenario": 
            case "Process": 
            case "AuditTrail": 
            case "Account": 
            case "ChangeType": {
                result = key == null ? null : key.toLowerCase(Locale.ENGLISH);
                break;
            }
        }
        return result;
    }

    private Object getCellValue(Object value) {
        if (value instanceof String) {
            String[] values = value.toString().split("\\|");
            String result = values.length > 1 ? values[1] : values[0];
            return StringUtils.trim((String)result);
        }
        return value;
    }

    private Boolean isDifModel() {
        if ("difmodel".equalsIgnoreCase(this.getPageCache().get(TRACE_MODEL))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void changeModel(String key) {
        if (key.equalsIgnoreCase("difmodel")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"unfoldbyorg", "unfoldbyprocess", "difmodel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"normalmode"});
        } else if (key.equalsIgnoreCase("normalmode")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"difmodel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"normalmode"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"unfoldbyprocess"});
        }
    }
}

